/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

// --- project includes ---
#include "vec3.h"

// --- TML includes ---
#include "tml/message/packed_message_interface.h"

/*!
  Pack a Vec3 into a TML packed message

  \param p the Vec3
*/
template<>
void TML_PackedMessageInterface::pack<Vec3>(const Vec3& v)
{
  append(v.X());
  append(v.Y());
  append(v.Z());
}

/*!
  Unpack a Vec3 from a TML packed message

  \param p the Vec3
*/
template<>
void TML_PackedMessageInterface::unpack<Vec3>(Vec3& v)
{
  double db[3];

  pop_doubles(db,3);
  v=Vec3(db[0],db[1],db[2]);
}
  
