# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Printer configuration page.
"""

from PyQt4.QtCore import pyqtSignature

from KdeQt import KQFontDialog

from ConfigurationPageBase import ConfigurationPageBase
from Ui_PrinterPage import Ui_PrinterPage

import Preferences

class PrinterPage(ConfigurationPageBase, Ui_PrinterPage):
    """
    Class implementing the Printer configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("PrinterPage")
        
        # set initial values
        self.printerNameEdit.setText(\
            Preferences.getPrinter("PrinterName"))
        if Preferences.getPrinter("ColorMode"):
            self.printerColorButton.setChecked(True)
        else:
            self.printerGrayscaleButton.setChecked(True)
        if Preferences.getPrinter("FirstPageFirst"):
            self.printFirstPageFirstButton.setChecked(True)
        else:
            self.printFirstPageLastButton.setChecked(True)
        self.printMagnificationSpinBox.setValue(\
            Preferences.getPrinter("Magnification"))
        self.printheaderFont = Preferences.getPrinter("HeaderFont")
        self.printheaderFontSample.setFont(self.printheaderFont)
        
    def save(self):
        """
        Public slot to save the Printer configuration.
        """
        Preferences.setPrinter("PrinterName",
            self.printerNameEdit.text())
        if self.printerColorButton.isChecked():
            Preferences.setPrinter("ColorMode", 1)
        else:
            Preferences.setPrinter("ColorMode", 0)
        if self.printFirstPageFirstButton.isChecked():
            Preferences.setPrinter("FirstPageFirst", 1)
        else:
            Preferences.setPrinter("FirstPageFirst", 0)
        Preferences.setPrinter("Magnification", 
            self.printMagnificationSpinBox.value())
        Preferences.setPrinter("HeaderFont", self.printheaderFont)
        
    @pyqtSignature("")
    def on_printheaderFontButton_clicked(self):
        """
        Private method used to select the font for the page header.
        """
        font, ok = KQFontDialog.getFont(self.printheaderFont)
        if ok:
            self.printheaderFontSample.setFont(font)
            self.printheaderFont = font
        
    def polishPage(self):
        """
        Public slot to perform some polishing actions.
        """
        self.printheaderFontSample.setFont(self.printheaderFont)
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = PrinterPage()
    return page
