"""
Defines the function show_me() for experimenting with trait/editor combinations
"""

from enthought.traits.ui.api \
    import View, Group, Item


def ed_demo_factory ( trait, edr ):
    """ Create a class with trait 'trait' and a View displaying editor 'edr'.
    """

    class EdDemo ( HasTraits ):
        """ This class is defined at runtime with a specified trait and editor.
        
        This class contains a trait attribute of the specified type and a
        display specification for showing the four styles of the given editor
        when applied to that trait type.
        """

        # Two attributes are defined at runtime: the editor to be demonstrated
        # and the trait that the editor will display.
        ed = edr
        f1 = trait

        grp = Group( Group( '15', Item( 'f1', editor = ed ), '15', 
                            style       = 'simple', 
                            label       = "Simple", 
                            show_border = True ),
                     Group( ' ' ),
                     Group( '15', Item( 'f1', editor = ed ), '15', 
                            style       = 'custom', 
                            label       = 'Custom',
                            show_border = True ),
                     Group( ' ' ),
                     Group( '15', Item( 'f1', editor = ed ), '15',
                            style       = "text", 
                            label       = "Text", 
                            show_border = True ),
                     Group( ' ' ),
                     Group( '15', Item( 'f1', editor = ed ), '15', 
                            style       = 'readonly', 
                            label       = 'Read Only', 
                            show_border = True )
              ) 

        view1 = View( grp )

    return EdDemo()


def show_me ( trait, edr = None, value = None ):
    """ Show how editor 'edr' appears when applied to a trait of type 'trait'.

    Demonstrate the use of the four styles of editor "edr" on a Trait of 
    type "trait".  The optional "value" keyword argument may be used to specify 
    an initial value.

    """
    
    # Create an object with the appropriate trait attribute and display spec:
    edit1 = ed_demo_factory( trait, edr )
 
    # If an initial value is specified, assign it to the trait attribute:
    if value != None:
        edit1.f1 = value
    
    # Display the editor demo dialogue in wizard form:
    edit1.edit_traits( kind = "wizard" )
    
