C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE CHKPREC()
C
C---->
C**** CHKPREC
C
C     Purpose
C     -------
C
C     Determines whether or not the current field is to be
C     considered for 'precipitation' treatment.
C
C
C     Interface
C     ---------
C
C     CALL CHKPREC()
C
C     Input
C     -----
C
C     None
C
C
C     Output
C     ------
C
C     Sets the precipitation threshold if give by environment variable
C     PRECIPITATION_THRESHOLD. Otherwise gives it a default value.
C
C
C     Method
C     ------
C
C     See below.
C
C
C     Externals
C     ---------
C
C     INTLOG  - Logs messages
C
C     Uses common block nifld.common
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF     December 2003
C
C----<
C
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nifld.common"
C
C     Local variables
C
      CHARACTER*20 PTHRESH
      INTEGER IBLANK
      LOGICAL LFIRST
      DATA LFIRST/.TRUE./
      SAVE LFIRST
C
C     -----------------------------------------------------------------|
C*    Section 1. Initialise
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
      IF( LFIRST ) THEN
        LFIRST = .FALSE.
        CALL GETENV('PRECIPITATION_THRESHOLD',PTHRESH)
        IBLANK = INDEX(PTHRESH, ' ')
        IF( IBLANK.GT.1 ) THEN
          READ(PTHRESH,'(F15.8)') ZPRECIP
        ELSE
          ZPRECIP = 0.00005
        ENDIF
C
        CALL INTLOGR(JP_DEBUG,
     X    'CHKPREC: PRECIPITATION_THRESHOLD = ',ZPRECIP)
      ENDIF
C
C     -----------------------------------------------------------------|
C*    Section 9.   Return
C     -----------------------------------------------------------------|
C
  900 CONTINUE
      RETURN
      END
