C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION LSM_RED( KGAUSS, KDATE, KBITS, HPATH )
C
C---->
C**** LSM_RED
C
C     PURPOSE
C     -------
C
C     Generates the land sea mask file pathname.
C
C
C     INTERFACE
C     ---------
C
C     IRET = LSM_RED( KGAUSS, KDATE, KBITS, HPATH )
C
C
C     Input
C     -----
C     KGAUSS - The gaussian number (80 or 160)
C     KDATE  - The data date in YYYYMMDD format.
C     KBITS  - Number of bits per land-sea mask value (eg 32 or 64)
C
C     Output
C     ------
C     HPATH  - The full file pathname (with gaussian number
C              number of bits and date).
C
C
C     Return value
C     ------------
C
C     Function returns the number of characters in the file pathname,
C     or zero if no match found.
C
C
C     Common block usage
C     ------------------
C
C     None
C
C
C     EXTERNALS
C     ---------
C
C     GETENV     - Standard routine to get environmental variable.
C     INDEX      - Intrinsic routine to find position of substring.
C     LEN        - Intrinsic routine to find length of string.
C     EMOSNUM    - Gives current EMOSLIB version number.
C
C
C     METHOD
C     ------
C     None
C
C
C     REFERENCE
C     ---------
C
C     None
C
C     COMMENTS
C     --------
C
C     None
C
C
C     AUTHOR
C     ------
C
C     J.D.Chambers      *ECMWF*      ??? 1996
C
C
C     MODIFICATIONS
C     -------------
C
C     J.D.Chambers      *ECMWF*      July 1998
C     Use dates in YYYYMMDD format to handle year 2000 etc.
C
C----<
C     _______________________________________________________
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
      IMPLICIT NONE
C
C     Parameters
C
      INTEGER JPD160, JPD80
      PARAMETER (JPD160=6)
      PARAMETER (JPD80=2)
C
C     Function parameters
C
      INTEGER KGAUSS, KDATE, KBITS
      CHARACTER*(*) HPATH
C
C     Local variables
C
      CHARACTER*6 YEMOSNM
      INTEGER IEMOSNM, LOOP, IOFFSET
C
C     Change dates for N160
C
      INTEGER DATE160(JPD160)
      DATA DATE160/
     X            19790930,
     X            19910917,
     X            19930804,
     X            19940302,
     X            19940823,
     X            19950404
     X           /
C
C     Change dates for N80
C
      INTEGER DATE80(JPD80)
      DATA DATE80/
     X            19790930,
     X            19790930
     X           /
C
      CHARACTER YPENVIRON*13
      PARAMETER (YPENVIRON = 'MARS_LSM_PATH')
      CHARACTER*80 YBASE, YENVBACK
      INTEGER IBASELEN
      CHARACTER*256 HDIREC


#ifdef CRAY
      DATA HDIREC/ '/owrk/marsint/new'/
#endif

#ifdef __uxp__
      DATA HDIREC/ '/mrfs/postproc'/
#endif

#ifdef TABLE_PATH
      DATA HDIREC / TABLE_PATH /
#else
      DATA HDIREC / '' /
#endif

      CHARACTER*50 PATH160(JPD160)
      CHARACTER*50 PATH80(JPD80)
C
C     Pathnames for N160
C
      DATA PATH160/
     X            '_19790930',
     X            '_19910917',
     X            '_19930804',
     X            '_19940302',
     X            '_19940823',
     X            '_19950404'
     X          /
C
C
C     Pathnames for N80
      DATA PATH80/
     X            '_19790930',
     X            '_19790930'
     X          /
C
      INTEGER INDEX
C
C     External functions
C
      INTEGER EMOSNUM
      EXTERNAL EMOSNUM
C
C***************************************************************
C     Section 1. Initialize and check input values.
C***************************************************************
C
  100 CONTINUE
C
      LSM_RED = 0
      HPATH = ' '
C
C     Only reduced N160 gaussian fields handled.
C
      IF( KGAUSS.NE.160 ) GOTO 900
C
C     Only 32 bit and 64 bit land-sea masks handled.
C
      IF( (KBITS.NE.32).AND.(KBITS.NE.64) ) GOTO 900
C
C     Check environment variable for path of land sea masks.
C
      CALL GETENV(YPENVIRON, YENVBACK)
C
      IF( YENVBACK.EQ.' ' ) THEN
#ifdef __uxp__
C
C       On Fujitsus, need to build different pathname for vpp300,
C       vpp700, vpp700e and vpp5000
C
        CALL GETENV ('HOST', YENVBACK)
        IF( YENVBACK(1:7).EQ.'vpp5000' )THEN
          YBASE = '/vpp5000' // HDIREC
          IBASELEN = LEN(HDIREC) + LEN('/vpp5000')
        ELSE IF( YENVBACK(1:7).EQ.'vpp700e' )THEN
          YBASE = '/vpp700e' // HDIREC
          IBASELEN = LEN(HDIREC) + LEN('/vpp700e')
        ELSE IF( YENVBACK(1:6).EQ.'vpp700' )THEN
          YBASE = '/vpp700' // HDIREC
          IBASELEN = LEN(HDIREC) + LEN('/vpp700')
        ELSE
          YBASE = HDIREC
          IBASELEN = LEN(HDIREC)
        ENDIF
#else
         IOFFSET = INDEX(HDIREC,' ') - 1
         IF(IOFFSET.GT.0) THEN
           YBASE = HDIREC(1:IOFFSET)//'/land_sea_mask/'
           IBASELEN = LEN(YBASE)
         ELSE
		   YBASE = '/usr/local/lib/metaps/tables/interpolation'
		   IBASELEN = 42
         ENDIF
#endif
      ELSE
        YBASE = YENVBACK
        IBASELEN  = INDEX(YENVBACK,' ') - 1
        IF( IBASELEN.LT.0 ) IBASELEN = LEN (YENVBACK)
        IF( IBASELEN.EQ.0 ) THEN
#ifdef __uxp__
C
C         On Fujitsus, need to build different pathname for vpp300,
C         vpp700, vpp700e and vpp5000
C
          CALL GETENV ('HOST', YENVBACK)
          IF( YENVBACK(1:7).EQ.'vpp5000' )THEN
            YBASE = '/vpp5000' // HDIREC
            IBASELEN = LEN(HDIREC) + LEN('/vpp5000')
          ELSE IF( YENVBACK(1:7).EQ.'vpp700e' )THEN
            YBASE = '/vpp700e' // HDIREC
            IBASELEN = LEN(HDIREC) + LEN('/vpp700e')
          ELSE IF( YENVBACK(1:6).EQ.'vpp700' )THEN
            YBASE = '/vpp700' // HDIREC
            IBASELEN = LEN(HDIREC) + LEN('/vpp700')
          ELSE
            YBASE = HDIREC
            IBASELEN = LEN(HDIREC)
          ENDIF
#else
          YBASE = HDIREC
          IBASELEN = LEN(HDIREC)
#endif
        ENDIF
      ENDIF
C
C***************************************************************
C     Section 2. Build pathnames.
C***************************************************************
C
  200 CONTINUE
C
C     Handle N160
C
      IF( KGAUSS.EQ.160 ) THEN 
        DO 210 LOOP = 1, JPD160-1
          IF( (KDATE.GE.DATE160(LOOP) ) .AND.
     X         (KDATE.LT.DATE160(LOOP+1)) ) THEN
            HPATH(1:) = YBASE(1:IBASELEN) // '/' //
     X                  'r160_' // 'xx' // PATH160(LOOP)
            LSM_RED = INDEX(HPATH,' ')
            GOTO 900
          ENDIF
  210   CONTINUE
C
C       Dropthrough -> take latest.
C
        HPATH(1:) = YBASE(1:IBASELEN) // '/' //
     X              'r160_' // 'xx' // PATH160(JPD160)
        LSM_RED = INDEX(HPATH,' ')
C
C     Handle N80
C
      ELSE
        DO 220 LOOP = 1, JPD80-1
          IF( (KDATE.GE.DATE80(LOOP) ) .AND.
     X         (KDATE.LT.DATE80(LOOP+1)) ) THEN
            HPATH(1:) = YBASE(1:IBASELEN) // '/' //
     X                  'r80_' // 'xx' // PATH80(LOOP)
            LSM_RED = INDEX(HPATH,' ')
            GOTO 900
          ENDIF
  220   CONTINUE
C
C       Dropthrough -> take latest.
C
        HPATH(1:) = YBASE(1:IBASELEN) // '/' //
     X              'r80_' // 'xx' // PATH80(JPD80)
        LSM_RED = INDEX(HPATH,' ')
      ENDIF
C
C***************************************************************
C     Section 9. Return.
C***************************************************************
C
  900 CONTINUE
C
      RETURN
      END
