/*
  This file is part of PLplot.
  
  PLplot is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Library Public License as published
  by the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  PLplot is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public License
  along with PLplot; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
  
  
  This header file contains the lookup tables used for converting between
  hershey and unicode. It is an automatically generated file, so please do
  not edit it directly. Make any changes to plhershey-unicode.csv, then use
  plhershey-unicode-gen.c to recreate this header file.
  
  plhershey-unicode.csv consists of three fields: the first field is the
  hershey code, and is in decimal; the second is the unicode value, and is
  in hex; and the final field is font index. There are five possible font
  indices:
       0        undefined/unknown
       1        normal
       2        roman
       3        italic-roman
       4        script
  
  Font indices are used for approximating the appearence of the original
  hershey glyphs.
  
  Unicode values of 0x0000 signify unknowns.
  
*/
const int number_of_entries_in_hershey_to_unicode_table=980;

typedef struct {
	unsigned int Hershey;
	PLUNICODE Unicode;
	char Font;
	char Padding[7];
} Hershey_to_Unicode_table;


const Hershey_to_Unicode_table hershey_to_unicode_lookup_table[980] = {
{1,0x0041,1,{0}}, {2,0x0042,1,{0}}, {3,0x0043,1,{0}}, {4,0x0044,1,{0}}, 
{5,0x0045,1,{0}}, {6,0x0046,1,{0}}, {7,0x0047,1,{0}}, {8,0x0048,1,{0}}, 
{9,0x0049,1,{0}}, {10,0x004a,1,{0}}, {11,0x004b,1,{0}}, {12,0x004c,1,{0}}, 
{13,0x004d,1,{0}}, {14,0x004e,1,{0}}, {15,0x004f,1,{0}}, {16,0x0050,1,{0}}, 
{17,0x0051,1,{0}}, {18,0x0052,1,{0}}, {19,0x0053,1,{0}}, {20,0x0054,1,{0}}, 
{21,0x0055,1,{0}}, {22,0x0056,1,{0}}, {23,0x0057,1,{0}}, {24,0x0058,1,{0}}, 
{25,0x0059,1,{0}}, {26,0x005a,1,{0}}, {27,0x0391,1,{0}}, {28,0x0392,1,{0}}, 
{29,0x0393,1,{0}}, {30,0x0394,1,{0}}, {31,0x0395,1,{0}}, {32,0x0396,1,{0}}, 
{33,0x0397,1,{0}}, {34,0x0398,1,{0}}, {35,0x0399,1,{0}}, {36,0x039a,1,{0}}, 
{37,0x039b,1,{0}}, {38,0x039c,1,{0}}, {39,0x039d,1,{0}}, {40,0x039e,1,{0}}, 
{41,0x039f,1,{0}}, {42,0x03a0,1,{0}}, {43,0x03a1,1,{0}}, {44,0x03a3,1,{0}}, 
{45,0x03a4,1,{0}}, {46,0x03a5,1,{0}}, {47,0x03a6,1,{0}}, {48,0x03a7,1,{0}}, 
{49,0x03a8,1,{0}}, {50,0x03a9,1,{0}}, {200,0x0030,1,{0}}, {201,0x0031,1,{0}}, 
{202,0x0032,1,{0}}, {203,0x0033,1,{0}}, {204,0x0034,1,{0}}, {205,0x0035,1,{0}}, 
{206,0x0036,1,{0}}, {207,0x0037,1,{0}}, {208,0x0038,1,{0}}, {209,0x0039,1,{0}}, 
{210,0x002e,1,{0}}, {211,0x002c,1,{0}}, {212,0x003a,1,{0}}, {213,0x003b,1,{0}}, 
{214,0x0021,1,{0}}, {215,0x003f,1,{0}}, {216,0x0027,1,{0}}, {217,0x0093,1,{0}}, 
{218,0x00b0,1,{0}}, {219,0x0024,1,{0}}, {220,0x002f,1,{0}}, {221,0x0028,1,{0}}, 
{222,0x0029,1,{0}}, {223,0x007c,1,{0}}, {224,0x002d,1,{0}}, {225,0x002b,1,{0}}, 
{226,0x003d,1,{0}}, {227,0x0078,1,{0}}, {228,0x002a,1,{0}}, {229,0x0000,1,{0}}, 
{230,0x0000,1,{0}}, {231,0x0000,1,{0}}, {232,0x0000,1,{0}}, {233,0x0000,1,{0}}, 
{234,0x0026,1,{0}}, {235,0x0000,1,{0}}, {236,0x0040,1,{0}}, {238,0x2025,0,{0}}, 
{239,0x2025,0,{0}}, {240,0x0000,0,{0}}, {242,0x0000,0,{0}}, {248,0x2248,0,{0}}, 
{250,0x2245,0,{0}}, {252,0x21cc,0,{0}}, {261,0x00bd,2,{0}}, {262,0x2153,2,{0}}, 
{263,0x0000,2,{0}}, {264,0x2155,2,{0}}, {265,0x2154,2,{0}}, {266,0x215c,2,{0}}, 
{267,0x215d,2,{0}}, {268,0x215e,2,{0}}, {269,0x0000,2,{0}}, {270,0x00bc,2,{0}}, 
{271,0x00be,2,{0}}, {272,0x00a3,2,{0}}, {273,0x00ae,2,{0}}, {274,0x00a9,2,{0}}, 
{275,0x2262,0,{0}}, {276,0x22ef,0,{0}}, {278,0x2194,0,{0}}, {279,0x2195,0,{0}}, 
{280,0x0000,0,{0}}, {281,0x0000,0,{0}}, {282,0x220b,0,{0}}, {284,0x2980,0,{0}}, 
{501,0x0041,1,{0}}, {502,0x0042,1,{0}}, {503,0x0043,1,{0}}, {504,0x0044,1,{0}}, 
{505,0x0045,1,{0}}, {506,0x0046,1,{0}}, {507,0x0047,1,{0}}, {508,0x0048,1,{0}}, 
{509,0x0049,1,{0}}, {510,0x004a,1,{0}}, {511,0x004b,1,{0}}, {512,0x004c,1,{0}}, 
{513,0x004d,1,{0}}, {514,0x004e,1,{0}}, {515,0x004f,1,{0}}, {516,0x0050,1,{0}}, 
{517,0x0051,1,{0}}, {518,0x0052,1,{0}}, {519,0x0053,1,{0}}, {520,0x0054,1,{0}}, 
{521,0x0055,1,{0}}, {522,0x0056,1,{0}}, {523,0x0057,1,{0}}, {524,0x0058,1,{0}}, 
{525,0x0059,1,{0}}, {526,0x005a,1,{0}}, {527,0x0391,1,{0}}, {528,0x0392,1,{0}}, 
{529,0x0393,1,{0}}, {530,0x0394,1,{0}}, {531,0x0395,1,{0}}, {532,0x0396,1,{0}}, 
{533,0x0397,1,{0}}, {534,0x0398,1,{0}}, {535,0x0399,1,{0}}, {536,0x039a,1,{0}}, 
{537,0x039b,1,{0}}, {538,0x039c,1,{0}}, {539,0x039d,1,{0}}, {540,0x039e,1,{0}}, 
{541,0x039f,1,{0}}, {542,0x03a0,1,{0}}, {543,0x03a1,1,{0}}, {544,0x03a3,1,{0}}, 
{545,0x03a4,1,{0}}, {546,0x03a5,1,{0}}, {547,0x03a6,1,{0}}, {548,0x03a7,1,{0}}, 
{549,0x03a8,1,{0}}, {550,0x03a9,1,{0}}, {551,0x0041,4,{0}}, {552,0x0042,4,{0}}, 
{553,0x0043,4,{0}}, {554,0x0044,4,{0}}, {555,0x0045,4,{0}}, {556,0x0046,4,{0}}, 
{557,0x0047,4,{0}}, {558,0x0048,4,{0}}, {559,0x0049,4,{0}}, {560,0x004a,4,{0}}, 
{561,0x004b,4,{0}}, {562,0x004c,4,{0}}, {563,0x004d,4,{0}}, {564,0x004e,4,{0}}, 
{565,0x004f,4,{0}}, {566,0x0050,4,{0}}, {567,0x0051,4,{0}}, {568,0x0052,4,{0}}, 
{569,0x0053,4,{0}}, {570,0x0054,4,{0}}, {571,0x0055,4,{0}}, {572,0x0056,4,{0}}, 
{573,0x0057,4,{0}}, {574,0x0058,4,{0}}, {575,0x0059,4,{0}}, {576,0x005a,4,{0}}, 
{583,0x2207,1,{0}}, {601,0x0061,1,{0}}, {602,0x0062,1,{0}}, {603,0x0063,1,{0}}, 
{604,0x0064,1,{0}}, {605,0x0065,1,{0}}, {606,0x0066,1,{0}}, {607,0x0067,1,{0}}, 
{608,0x0068,1,{0}}, {609,0x0069,1,{0}}, {610,0x006a,1,{0}}, {611,0x006b,1,{0}}, 
{612,0x006c,1,{0}}, {613,0x006d,1,{0}}, {614,0x006e,1,{0}}, {615,0x006f,1,{0}}, 
{616,0x0070,1,{0}}, {617,0x0071,1,{0}}, {618,0x0072,1,{0}}, {619,0x0073,1,{0}}, 
{620,0x0074,1,{0}}, {621,0x0075,1,{0}}, {622,0x0076,1,{0}}, {623,0x0077,1,{0}}, 
{624,0x0078,1,{0}}, {625,0x0079,1,{0}}, {626,0x007a,1,{0}}, {627,0x03b1,4,{0}}, 
{628,0x03b2,4,{0}}, {629,0x03b3,4,{0}}, {630,0x03b4,4,{0}}, {631,0x03b5,4,{0}}, 
{632,0x03b6,4,{0}}, {633,0x03b7,4,{0}}, {634,0x03b8,4,{0}}, {635,0x03b9,4,{0}}, 
{636,0x03ba,4,{0}}, {637,0x03bb,4,{0}}, {638,0x03bc,4,{0}}, {639,0x03bd,4,{0}}, 
{640,0x03be,4,{0}}, {641,0x03bf,4,{0}}, {642,0x03c0,4,{0}}, {643,0x03c1,4,{0}}, 
{644,0x03c3,4,{0}}, {645,0x03c4,4,{0}}, {646,0x03c5,4,{0}}, {647,0x03c6,4,{0}}, 
{648,0x03c7,4,{0}}, {649,0x03c8,4,{0}}, {650,0x03c9,4,{0}}, {651,0x0061,4,{0}}, 
{652,0x0062,4,{0}}, {653,0x0063,4,{0}}, {654,0x0064,4,{0}}, {655,0x0065,4,{0}}, 
{656,0x0066,4,{0}}, {657,0x0067,4,{0}}, {658,0x0068,4,{0}}, {659,0x0069,4,{0}}, 
{660,0x006a,4,{0}}, {661,0x006b,4,{0}}, {662,0x006c,4,{0}}, {663,0x006d,4,{0}}, 
{664,0x006e,4,{0}}, {665,0x006f,4,{0}}, {666,0x0070,4,{0}}, {667,0x0071,4,{0}}, 
{668,0x0072,4,{0}}, {669,0x0073,4,{0}}, {670,0x0074,4,{0}}, {671,0x0075,4,{0}}, 
{672,0x0076,4,{0}}, {673,0x0077,4,{0}}, {674,0x0078,4,{0}}, {675,0x0079,4,{0}}, 
{676,0x007a,4,{0}}, {677,0x0671,4,{0}}, {683,0x2202,4,{0}}, {684,0x03f5,4,{0}}, 
{685,0x03f4,4,{0}}, {686,0x03d5,4,{0}}, {687,0x03da,4,{0}}, {700,0x0030,1,{0}}, 
{701,0x0031,1,{0}}, {702,0x0032,1,{0}}, {703,0x0033,1,{0}}, {704,0x0034,1,{0}}, 
{705,0x0035,1,{0}}, {706,0x0036,1,{0}}, {707,0x0037,1,{0}}, {708,0x0038,1,{0}}, 
{709,0x0039,1,{0}}, {710,0x002e,1,{0}}, {711,0x002c,1,{0}}, {712,0x003a,1,{0}}, 
{713,0x003b,1,{0}}, {714,0x0021,1,{0}}, {715,0x003f,1,{0}}, {716,0x0027,1,{0}}, 
{717,0x0022,1,{0}}, {718,0x00b0,1,{0}}, {719,0x0024,1,{0}}, {720,0x00d7,1,{0}}, 
{721,0x0028,1,{0}}, {722,0x0029,1,{0}}, {723,0x007c,1,{0}}, {724,0x002d,1,{0}}, 
{725,0x002b,1,{0}}, {726,0x003d,1,{0}}, {727,0x0078,1,{0}}, {728,0x002a,1,{0}}, 
{729,0x0000,1,{0}}, {730,0x0000,1,{0}}, {731,0x0000,1,{0}}, {732,0x2192,1,{0}}, 
{733,0x0023,1,{0}}, {734,0x0026,1,{0}}, {735,0x0000,1,{0}}, {736,0x0020,1,{0}}, 
{737,0x2225,1,{0}}, {738,0x22a5,1,{0}}, {739,0x2220,1,{0}}, {740,0x2234,1,{0}}, 
{741,0x2664,1,{0}}, {742,0x2661,1,{0}}, {743,0x2662,1,{0}}, {744,0x2667,1,{0}}, 
{745,0x0000,1,{0}}, {746,0x0000,1,{0}}, {750,0x0000,0,{0}}, {751,0x0000,0,{0}}, 
{752,0x0000,0,{0}}, {753,0x25b4,0,{0}}, {754,0x0000,0,{0}}, {755,0x0000,0,{0}}, 
{756,0x0000,0,{0}}, {757,0x0000,0,{0}}, {758,0x25e0,0,{0}}, {759,0x0000,0,{0}}, 
{760,0x0000,0,{0}}, {761,0x0000,0,{0}}, {762,0x0000,0,{0}}, {763,0x0000,0,{0}}, 
{764,0x0000,0,{0}}, {765,0x223e,0,{0}}, {766,0x22e1,0,{0}}, {767,0x2608,0,{0}}, 
{768,0x00a7,0,{0}}, {796,0x257c,0,{0}}, {797,0x2571,0,{0}}, {798,0x257d,0,{0}}, 
{799,0x2572,0,{0}}, {800,0x0000,0,{0}}, {801,0x0000,0,{0}}, {802,0x0000,0,{0}}, 
{803,0x0000,0,{0}}, {804,0x0000,0,{0}}, {805,0x0000,0,{0}}, {806,0x0000,0,{0}}, 
{807,0x0000,0,{0}}, {808,0x0000,0,{0}}, {809,0x0000,0,{0}}, {810,0x25dc,0,{0}}, 
{811,0x25df,0,{0}}, {812,0x25de,0,{0}}, {813,0x25dd,0,{0}}, {814,0x0000,0,{0}}, 
{815,0x0000,0,{0}}, {816,0x0000,0,{0}}, {817,0x0000,0,{0}}, {818,0x0000,0,{0}}, 
{819,0x223f,0,{0}}, {820,0x0000,0,{0}}, {821,0x0000,0,{0}}, {822,0x0000,0,{0}}, 
{823,0x221d,0,{0}}, {824,0x0000,0,{0}}, {825,0x0000,0,{0}}, {826,0x0000,0,{0}}, 
{827,0x0000,0,{0}}, {828,0x22c5,0,{0}}, {829,0x0000,0,{0}}, {830,0x0000,0,{0}}, 
{831,0x0000,0,{0}}, {832,0x0000,0,{0}}, {833,0x0000,0,{0}}, {834,0x0000,0,{0}}, 
{840,0x25cb,0,{0}}, {841,0x25a1,0,{0}}, {842,0x25b3,0,{0}}, {843,0x2662,0,{0}}, 
{844,0x2729,0,{0}}, {845,0x002b,1,{0}}, {846,0x00d7,1,{0}}, {847,0x2217,1,{0}}, 
{850,0x2219,0,{0}}, {851,0x25a0,0,{0}}, {852,0x25b2,0,{0}}, {853,0x25c0,0,{0}}, 
{854,0x25bc,0,{0}}, {855,0x25b6,0,{0}}, {856,0x22c6,0,{0}}, {857,0x21be,0,{0}}, 
{860,0x0000,0,{0}}, {861,0x0000,0,{0}}, {862,0x0000,0,{0}}, {863,0x0000,0,{0}}, 
{864,0x0000,0,{0}}, {865,0x0000,0,{0}}, {866,0x0000,0,{0}}, {867,0x263e,0,{0}}, 
{868,0x2721,0,{0}}, {869,0x0000,0,{0}}, {870,0x0000,0,{0}}, {871,0x0000,0,{0}}, 
{872,0x0000,0,{0}}, {873,0x0000,0,{0}}, {874,0x0000,0,{0}}, {900,0x0000,0,{0}}, 
{901,0x0000,0,{0}}, {902,0x0000,0,{0}}, {903,0x0000,0,{0}}, {904,0x0000,0,{0}}, 
{905,0x0000,0,{0}}, {906,0x0000,0,{0}}, {907,0x0000,0,{0}}, {908,0x0000,0,{0}}, 
{909,0x0000,0,{0}}, {910,0x0000,0,{0}}, {911,0x0000,0,{0}}, {2001,0x0041,2,{0}}, 
{2002,0x0042,2,{0}}, {2003,0x0043,2,{0}}, {2004,0x0044,2,{0}}, {2005,0x0045,2,{0}}, 
{2006,0x0046,2,{0}}, {2007,0x0047,2,{0}}, {2008,0x0048,2,{0}}, {2009,0x0049,2,{0}}, 
{2010,0x004a,2,{0}}, {2011,0x004b,2,{0}}, {2012,0x004c,2,{0}}, {2013,0x004d,2,{0}}, 
{2014,0x004e,2,{0}}, {2015,0x004f,2,{0}}, {2016,0x0050,2,{0}}, {2017,0x0051,2,{0}}, 
{2018,0x0052,2,{0}}, {2019,0x0053,2,{0}}, {2020,0x0054,2,{0}}, {2021,0x0055,2,{0}}, 
{2022,0x0056,2,{0}}, {2023,0x0057,2,{0}}, {2024,0x0058,2,{0}}, {2025,0x0059,2,{0}}, 
{2026,0x005a,2,{0}}, {2027,0x0391,2,{0}}, {2028,0x0392,2,{0}}, {2029,0x0393,2,{0}}, 
{2030,0x0394,2,{0}}, {2031,0x0395,2,{0}}, {2032,0x0396,2,{0}}, {2033,0x0397,2,{0}}, 
{2034,0x0398,2,{0}}, {2035,0x0399,2,{0}}, {2036,0x039a,2,{0}}, {2037,0x039b,2,{0}}, 
{2038,0x039c,2,{0}}, {2039,0x039d,2,{0}}, {2040,0x039e,2,{0}}, {2041,0x039f,2,{0}}, 
{2042,0x03a0,2,{0}}, {2043,0x03a1,2,{0}}, {2044,0x03a3,2,{0}}, {2045,0x03a4,2,{0}}, 
{2046,0x03a5,2,{0}}, {2047,0x03a6,2,{0}}, {2048,0x03a7,2,{0}}, {2049,0x03a8,2,{0}}, 
{2050,0x03a9,2,{0}}, {2051,0x0041,3,{0}}, {2052,0x0042,3,{0}}, {2053,0x0043,3,{0}}, 
{2054,0x0044,3,{0}}, {2055,0x0045,3,{0}}, {2056,0x0046,3,{0}}, {2057,0x0047,3,{0}}, 
{2058,0x0048,3,{0}}, {2059,0x0049,3,{0}}, {2060,0x004a,3,{0}}, {2061,0x004b,3,{0}}, 
{2062,0x004c,3,{0}}, {2063,0x004d,3,{0}}, {2064,0x004e,3,{0}}, {2065,0x004f,3,{0}}, 
{2066,0x0050,3,{0}}, {2067,0x0051,3,{0}}, {2068,0x0052,3,{0}}, {2069,0x0053,3,{0}}, 
{2070,0x0054,3,{0}}, {2071,0x0055,3,{0}}, {2072,0x0056,3,{0}}, {2073,0x0057,3,{0}}, 
{2074,0x0058,3,{0}}, {2075,0x0059,3,{0}}, {2076,0x005a,3,{0}}, {2077,0x03f0,3,{0}}, 
{2101,0x0061,2,{0}}, {2102,0x0062,2,{0}}, {2103,0x0063,2,{0}}, {2104,0x0064,2,{0}}, 
{2105,0x0065,2,{0}}, {2106,0x0066,2,{0}}, {2107,0x0067,2,{0}}, {2108,0x0068,2,{0}}, 
{2109,0x0069,2,{0}}, {2110,0x006a,2,{0}}, {2111,0x006b,2,{0}}, {2112,0x006c,2,{0}}, 
{2113,0x006d,2,{0}}, {2114,0x006e,2,{0}}, {2115,0x006f,2,{0}}, {2116,0x0070,2,{0}}, 
{2117,0x0071,2,{0}}, {2118,0x0072,2,{0}}, {2119,0x0073,2,{0}}, {2120,0x0074,2,{0}}, 
{2121,0x0075,2,{0}}, {2122,0x0076,2,{0}}, {2123,0x0077,2,{0}}, {2124,0x0078,2,{0}}, 
{2125,0x0079,2,{0}}, {2126,0x007a,2,{0}}, {2127,0x03b1,3,{0}}, {2128,0x03b2,3,{0}}, 
{2129,0x03b3,3,{0}}, {2130,0x03b4,3,{0}}, {2131,0x03b5,3,{0}}, {2132,0x03b6,3,{0}}, 
{2133,0x03b7,3,{0}}, {2134,0x03b8,3,{0}}, {2135,0x03b9,3,{0}}, {2136,0x03ba,3,{0}}, 
{2137,0x03bb,3,{0}}, {2138,0x03bc,3,{0}}, {2139,0x03bd,3,{0}}, {2140,0x03be,3,{0}}, 
{2141,0x03bf,3,{0}}, {2142,0x03c0,3,{0}}, {2143,0x03c1,3,{0}}, {2144,0x03c3,3,{0}}, 
{2145,0x03c4,3,{0}}, {2146,0x03c5,3,{0}}, {2147,0x03c6,3,{0}}, {2148,0x03c7,3,{0}}, 
{2149,0x03c8,3,{0}}, {2150,0x03c9,3,{0}}, {2151,0x0061,3,{0}}, {2152,0x0062,3,{0}}, 
{2153,0x0063,3,{0}}, {2154,0x0064,3,{0}}, {2155,0x0065,3,{0}}, {2156,0x0066,3,{0}}, 
{2157,0x0067,3,{0}}, {2158,0x0068,3,{0}}, {2159,0x0069,3,{0}}, {2160,0x006a,3,{0}}, 
{2161,0x006b,3,{0}}, {2162,0x006c,3,{0}}, {2163,0x006d,3,{0}}, {2164,0x006e,3,{0}}, 
{2165,0x006f,3,{0}}, {2166,0x0070,3,{0}}, {2167,0x0071,3,{0}}, {2168,0x0072,3,{0}}, 
{2169,0x0073,3,{0}}, {2170,0x0074,3,{0}}, {2171,0x0075,3,{0}}, {2172,0x0076,3,{0}}, 
{2173,0x0077,3,{0}}, {2174,0x0078,3,{0}}, {2175,0x0079,3,{0}}, {2176,0x007a,3,{0}}, 
{2177,0x0000,0,{0}}, {2178,0xfb01,2,{0}}, {2179,0xfb02,2,{0}}, {2180,0x0000,0,{0}}, 
{2181,0x0000,0,{0}}, {2182,0x0000,0,{0}}, {2184,0x03f5,0,{0}}, {2185,0x03f4,0,{0}}, 
{2186,0x03d5,0,{0}}, {2187,0x03da,0,{0}}, {2190,0x0000,0,{0}}, {2191,0x0000,0,{0}}, 
{2192,0xfb01,3,{0}}, {2193,0xfb02,3,{0}}, {2194,0x0000,0,{0}}, {2195,0x0000,0,{0}}, 
{2196,0x0000,0,{0}}, {2200,0x0030,2,{0}}, {2201,0x0031,2,{0}}, {2202,0x0032,2,{0}}, 
{2203,0x0033,2,{0}}, {2204,0x0034,2,{0}}, {2205,0x0035,2,{0}}, {2206,0x0036,2,{0}}, 
{2207,0x0037,2,{0}}, {2208,0x0038,2,{0}}, {2209,0x0039,2,{0}}, {2210,0x002e,2,{0}}, 
{2211,0x002c,2,{0}}, {2212,0x003a,2,{0}}, {2213,0x003b,2,{0}}, {2214,0x0021,2,{0}}, 
{2215,0x003f,2,{0}}, {2216,0x0027,2,{0}}, {2217,0x0093,2,{0}}, {2218,0x00b0,2,{0}}, 
{2219,0x002a,2,{0}}, {2220,0x002f,2,{0}}, {2221,0x0028,2,{0}}, {2222,0x0029,2,{0}}, 
{2223,0x005b,2,{0}}, {2224,0x005d,2,{0}}, {2225,0x007b,2,{0}}, {2226,0x007d,2,{0}}, 
{2227,0x2329,2,{0}}, {2228,0x232a,2,{0}}, {2229,0x007c,2,{0}}, {2230,0x2225,0,{0}}, 
{2231,0x2212,0,{0}}, {2232,0x002b,0,{0}}, {2233,0x0000,0,{0}}, {2234,0x2213,0,{0}}, 
{2235,0x0000,0,{0}}, {2236,0x0000,0,{0}}, {2237,0x00f7,0,{0}}, {2238,0x0000,0,{0}}, 
{2239,0x2260,0,{0}}, {2240,0x2261,0,{0}}, {2241,0x003c,0,{0}}, {2242,0x003e,0,{0}}, 
{2243,0x2266,0,{0}}, {2244,0x2267,0,{0}}, {2245,0x221d,0,{0}}, {2246,0x223e,0,{0}}, 
{2247,0x0000,0,{0}}, {2248,0x0000,0,{0}}, {2249,0x0000,0,{0}}, {2250,0x0000,0,{0}}, 
{2251,0x0000,0,{0}}, {2252,0x0000,0,{0}}, {2253,0x0000,0,{0}}, {2254,0x0000,0,{0}}, 
{2255,0x221a,0,{0}}, {2256,0x2282,0,{0}}, {2257,0x22c3,0,{0}}, {2258,0x2283,0,{0}}, 
{2259,0x22c2,0,{0}}, {2260,0x220a,0,{0}}, {2261,0x2192,0,{0}}, {2262,0x2191,0,{0}}, 
{2263,0x2190,0,{0}}, {2264,0x2193,0,{0}}, {2265,0x2202,0,{0}}, {2266,0x2207,0,{0}}, 
{2267,0x221a,0,{0}}, {2268,0x222b,0,{0}}, {2269,0x2233,0,{0}}, {2270,0x221e,0,{0}}, 
{2271,0x0025,0,{0}}, {2272,0x0026,0,{0}}, {2273,0x0040,0,{0}}, {2274,0x0024,0,{0}}, 
{2275,0x0023,0,{0}}, {2276,0x00a7,0,{0}}, {2277,0x2020,0,{0}}, {2278,0x2021,0,{0}}, 
{2279,0x2203,0,{0}}, {2281,0x2299,0,{0}}, {2282,0x263f,0,{0}}, {2283,0x2640,0,{0}}, 
{2284,0x2295,0,{0}}, {2285,0x2642,0,{0}}, {2286,0x2643,0,{0}}, {2287,0x2644,0,{0}}, 
{2288,0x0000,0,{0}}, {2289,0x2646,0,{0}}, {2290,0x2647,0,{0}}, {2291,0x263e,0,{0}}, 
{2292,0x2604,0,{0}}, {2293,0x2600,0,{0}}, {2293,0x0000,0,{0}}, {2294,0x260a,0,{0}}, 
{2295,0x260b,0,{0}}, {2296,0x2197,0,{0}}, {2297,0x2199,0,{0}}, {2298,0x2196,0,{0}}, 
{2299,0x2198,0,{0}}, {2301,0x2648,0,{0}}, {2302,0x2649,0,{0}}, {2303,0x264a,0,{0}}, 
{2304,0x264b,0,{0}}, {2305,0x260a,0,{0}}, {2306,0x264d,0,{0}}, {2307,0x264e,0,{0}}, 
{2308,0x264f,0,{0}}, {2309,0x2650,0,{0}}, {2310,0x2651,0,{0}}, {2311,0x2652,0,{0}}, 
{2312,0x2653,0,{0}}, {2317,0x0000,0,{0}}, {2318,0x0000,0,{0}}, {2319,0x0000,0,{0}}, 
{2320,0x0000,0,{0}}, {2321,0x0000,0,{0}}, {2322,0x0000,0,{0}}, {2323,0x266f,0,{0}}, 
{2324,0x266e,0,{0}}, {2325,0x266d,0,{0}}, {2326,0x0000,0,{0}}, {2327,0x0000,0,{0}}, 
{2328,0x0000,0,{0}}, {2329,0x0000,0,{0}}, {2330,0x0000,0,{0}}, {2331,0x0000,0,{0}}, 
{2332,0x0000,0,{0}}, {2363,0x0000,0,{0}}, {2364,0x0000,0,{0}}, {2365,0x0000,0,{0}}, 
{2367,0x0000,0,{0}}, {2368,0x0000,0,{0}}, {2369,0x0000,0,{0}}, {2370,0x0000,0,{0}}, 
{2371,0x0000,0,{0}}, {2372,0x0000,0,{0}}, {2373,0x266f,0,{0}}, {2374,0x266e,0,{0}}, 
{2375,0x266d,0,{0}}, {2376,0x0000,0,{0}}, {2377,0x0000,0,{0}}, {2378,0x0000,0,{0}}, 
{2379,0x0000,0,{0}}, {2380,0x0000,0,{0}}, {2381,0x0000,0,{0}}, {2382,0x0000,0,{0}}, 
{2401,0x220f,0,{0}}, {2402,0x2211,0,{0}}, {2403,0x0000,0,{0}}, {2404,0x0000,0,{0}}, 
{2405,0x0000,0,{0}}, {2406,0x0000,0,{0}}, {2407,0x0000,0,{0}}, {2408,0x0000,0,{0}}, 
{2409,0x0000,0,{0}}, {2410,0x0000,0,{0}}, {2411,0x221a,0,{0}}, {2412,0x222b,0,{0}}, 
{2501,0x0041,1,{0}}, {2502,0x0042,1,{0}}, {2503,0x0043,1,{0}}, {2504,0x0044,1,{0}}, 
{2505,0x0045,1,{0}}, {2506,0x0046,1,{0}}, {2507,0x0047,1,{0}}, {2508,0x0048,1,{0}}, 
{2509,0x0049,1,{0}}, {2510,0x004a,1,{0}}, {2511,0x004b,1,{0}}, {2512,0x004c,1,{0}}, 
{2513,0x004d,1,{0}}, {2514,0x004e,1,{0}}, {2515,0x004f,1,{0}}, {2516,0x0050,1,{0}}, 
{2517,0x0051,1,{0}}, {2518,0x0052,1,{0}}, {2519,0x0053,1,{0}}, {2520,0x0054,1,{0}}, 
{2521,0x0055,1,{0}}, {2522,0x0056,1,{0}}, {2523,0x0057,1,{0}}, {2524,0x0058,1,{0}}, 
{2525,0x0059,1,{0}}, {2526,0x005a,1,{0}}, {2551,0x0041,4,{0}}, {2552,0x0042,4,{0}}, 
{2553,0x0043,4,{0}}, {2554,0x0044,4,{0}}, {2555,0x0045,4,{0}}, {2556,0x0046,4,{0}}, 
{2557,0x0047,4,{0}}, {2558,0x0048,4,{0}}, {2559,0x0049,4,{0}}, {2560,0x004a,4,{0}}, 
{2561,0x004b,4,{0}}, {2562,0x004c,4,{0}}, {2563,0x004d,4,{0}}, {2564,0x004e,4,{0}}, 
{2565,0x004f,4,{0}}, {2566,0x0050,4,{0}}, {2567,0x0051,4,{0}}, {2568,0x0052,4,{0}}, 
{2569,0x0053,4,{0}}, {2570,0x0054,4,{0}}, {2571,0x0055,4,{0}}, {2572,0x0056,4,{0}}, 
{2573,0x0057,4,{0}}, {2574,0x0058,4,{0}}, {2575,0x0059,4,{0}}, {2576,0x005a,4,{0}}, 
{2601,0x0061,1,{0}}, {2602,0x0062,1,{0}}, {2603,0x0063,1,{0}}, {2604,0x0064,1,{0}}, 
{2605,0x0065,1,{0}}, {2606,0x0066,1,{0}}, {2607,0x0067,1,{0}}, {2608,0x0068,1,{0}}, 
{2609,0x0069,1,{0}}, {2610,0x006a,1,{0}}, {2611,0x006b,1,{0}}, {2612,0x006c,1,{0}}, 
{2613,0x006d,1,{0}}, {2614,0x006e,1,{0}}, {2615,0x006f,1,{0}}, {2616,0x0070,1,{0}}, 
{2617,0x0071,1,{0}}, {2618,0x0072,1,{0}}, {2619,0x0073,1,{0}}, {2620,0x0074,1,{0}}, 
{2621,0x0075,1,{0}}, {2622,0x0076,1,{0}}, {2623,0x0077,1,{0}}, {2624,0x0078,1,{0}}, 
{2625,0x0079,1,{0}}, {2626,0x007a,1,{0}}, {2628,0x0022,1,{0}}, {2651,0x0061,4,{0}}, 
{2652,0x0062,4,{0}}, {2653,0x0063,4,{0}}, {2654,0x0064,4,{0}}, {2655,0x0065,4,{0}}, 
{2656,0x0066,4,{0}}, {2657,0x0067,4,{0}}, {2658,0x0068,4,{0}}, {2659,0x0069,4,{0}}, 
{2660,0x006a,4,{0}}, {2661,0x006b,4,{0}}, {2662,0x006c,4,{0}}, {2663,0x006d,4,{0}}, 
{2664,0x006e,4,{0}}, {2665,0x006f,4,{0}}, {2666,0x0070,4,{0}}, {2667,0x0071,4,{0}}, 
{2668,0x0072,4,{0}}, {2669,0x0073,4,{0}}, {2670,0x0074,4,{0}}, {2671,0x0075,4,{0}}, 
{2672,0x0076,4,{0}}, {2673,0x0077,4,{0}}, {2674,0x0078,4,{0}}, {2675,0x0079,4,{0}}, 
{2676,0x007a,4,{0}}, {2700,0x0030,1,{0}}, {2701,0x0031,1,{0}}, {2702,0x0032,1,{0}}, 
{2703,0x0033,1,{0}}, {2704,0x0034,1,{0}}, {2705,0x0035,1,{0}}, {2706,0x0036,1,{0}}, 
{2707,0x0037,1,{0}}, {2708,0x0038,1,{0}}, {2709,0x0039,1,{0}}, {2710,0x003a,1,{0}}, 
{2711,0x003b,1,{0}}, {2712,0x003c,1,{0}}, {2713,0x003d,1,{0}}, {2714,0x003e,1,{0}}, 
{2715,0x003f,1,{0}}, {2716,0x2018,1,{0}}, {2717,0x2019,1,{0}}, {2718,0x0026,1,{0}}, 
{2719,0x0024,1,{0}}, {2720,0x002f,1,{0}}, {2721,0x0028,1,{0}}, {2722,0x0029,1,{0}}, 
{2723,0x002a,1,{0}}, {2724,0x002d,1,{0}}, {2725,0x002b,1,{0}}, {2726,0x003d,1,{0}}, 
{2726,0x0027,1,{0}}, {2729,0x0000,1,{0}}, {2750,0x0030,3,{0}}, {2751,0x0031,3,{0}}, 
{2752,0x0032,3,{0}}, {2753,0x0033,3,{0}}, {2754,0x0034,3,{0}}, {2755,0x0035,3,{0}}, 
{2756,0x0036,3,{0}}, {2757,0x0037,3,{0}}, {2758,0x0038,3,{0}}, {2759,0x0039,3,{0}}, 
{2760,0x003a,3,{0}}, {2761,0x003b,3,{0}}, {2762,0x003c,3,{0}}, {2763,0x003d,3,{0}}, 
{2764,0x003e,3,{0}}, {2765,0x003f,3,{0}}, {2766,0x0000,3,{0}}, {2767,0x0000,3,{0}}, 
{2768,0x0026,3,{0}}, {2769,0x0024,3,{0}}, {2770,0x002f,3,{0}}, {2771,0x0028,3,{0}}, 
{2772,0x0029,3,{0}}, {2773,0x002a,3,{0}}, {2774,0x002d,3,{0}}, {2775,0x002b,3,{0}}, 
{2776,0x003d,3,{0}}, {2777,0x0027,3,{0}}, {2778,0x0022,3,{0}}, {2779,0x0000,3,{0}}, 
{2801,0x0410,2,{0}}, {2802,0x0411,2,{0}}, {2803,0x0412,2,{0}}, {2804,0x0413,2,{0}}, 
{2805,0x0414,2,{0}}, {2806,0x0415,2,{0}}, {2807,0x0416,2,{0}}, {2808,0x0417,2,{0}}, 
{2809,0x0418,2,{0}}, {2810,0x0419,2,{0}}, {2811,0x041a,2,{0}}, {2812,0x041b,2,{0}}, 
{2813,0x041c,2,{0}}, {2814,0x041d,2,{0}}, {2815,0x041e,2,{0}}, {2816,0x041f,2,{0}}, 
{2817,0x0420,2,{0}}, {2818,0x0421,2,{0}}, {2819,0x0422,2,{0}}, {2820,0x0423,2,{0}}, 
{2821,0x0424,2,{0}}, {2822,0x0425,2,{0}}, {2823,0x0426,2,{0}}, {2824,0x0427,2,{0}}, 
{2825,0x0428,2,{0}}, {2826,0x0429,2,{0}}, {2827,0x042a,2,{0}}, {2828,0x042b,2,{0}}, 
{2829,0x042c,2,{0}}, {2830,0x042d,2,{0}}, {2831,0x042e,2,{0}}, {2832,0x042f,2,{0}}, 
{2901,0x0430,2,{0}}, {2902,0x0431,2,{0}}, {2903,0x0432,2,{0}}, {2904,0x0433,2,{0}}, 
{2905,0x0434,2,{0}}, {2906,0x0435,2,{0}}, {2907,0x0436,2,{0}}, {2908,0x0437,2,{0}}, 
{2909,0x0438,2,{0}}, {2910,0x0439,2,{0}}, {2911,0x043a,2,{0}}, {2912,0x043b,2,{0}}, 
{2913,0x043c,2,{0}}, {2914,0x043d,2,{0}}, {2915,0x043e,2,{0}}, {2916,0x043f,2,{0}}, 
{2917,0x0440,2,{0}}, {2918,0x0441,2,{0}}, {2919,0x0442,2,{0}}, {2920,0x0443,2,{0}}, 
{2921,0x0444,2,{0}}, {2922,0x0445,2,{0}}, {2923,0x0446,2,{0}}, {2924,0x0447,2,{0}}, 
{2925,0x0448,2,{0}}, {2926,0x0449,2,{0}}, {2927,0x044a,2,{0}}, {2928,0x044b,2,{0}}, 
{2929,0x044c,2,{0}}, {2930,0x044d,2,{0}}, {2931,0x044e,2,{0}}, {2932,0x044f,2,{0}}
};
