/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollectionEvent;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollectionListener;
import org.emboss.jemboss.editor.GroutSequence;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceJPanel;

public class GroutSequenceJPanel
extends SequenceJPanel
implements GroutGraphicSequenceCollectionListener {
    int centreMarkerX = -1;
    int indent = 0;

    public GroutSequenceJPanel(int indent, Sequence seq, JComponent viewPane, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, Hashtable colorTable, int fontSize, int ypad) {
        super(seq, viewPane, drawSequence, drawBlackBox, drawColorBox, colorTable, fontSize, ypad);
        this.setIndent(indent);
    }

    public GroutSequenceJPanel(int indent, Sequence seq, JComponent viewPane, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, Hashtable colorTable, int ypad) {
        super(seq, viewPane, drawSequence, drawBlackBox, drawColorBox, colorTable, 0, ypad);
        this.setIndent(indent);
    }

    public GroutSequenceJPanel(int indent, int interval, int seqLength) {
        super(interval, seqLength);
        this.setIndent(indent);
    }

    public GroutSequenceJPanel(Sequence seq, JComponent viewPane, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, Hashtable colorTable, int fontSize, int ypad) {
        super(seq, viewPane, drawSequence, drawBlackBox, drawColorBox, colorTable, fontSize, ypad);
    }

    public GroutSequenceJPanel(Sequence seq, JComponent viewPane, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, Hashtable colorTable, int ypad) {
        super(seq, viewPane, drawSequence, drawBlackBox, drawColorBox, colorTable, 0, ypad);
    }

    public GroutSequenceJPanel(int interval, int seqLength) {
        super(interval, seqLength);
    }

    public void setIndent(int indent) {
        if (!this.drawNumber) {
            ((GroutSequence)this.seq).setIndent(indent);
            ((GraphicSequenceCollection)this.viewPane).setMaxSequenceLength(this.seq.getLength());
            if (this.getGraphics() != null) {
                this.paintComponent(this.getGraphics());
            }
            this.viewPaneResize();
        } else {
            this.indent = indent;
        }
    }

    public void init() {
        if (!this.drawNumber) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent e) {
                }
            });
        }
    }

    public void groutGraphicSequenceCollectionChanged(GroutGraphicSequenceCollectionEvent e) {
        this.repaint();
    }

    protected void doDrawNumber(int i, FontMetrics metrics, Graphics g) {
        this.drawCentreMarker(g);
        if ((i + 1 - this.indent) % this.interval == 0 && i + 1 - this.indent > 0) {
            String snum = Integer.toString(i + 1 - this.indent);
            int numWidth = metrics.stringWidth(snum);
            g.drawString(snum, (int)(((double)i + 0.5) * (double)this.resWidth) - numWidth / 2, this.seqHeight - this.boundWidth2);
        }
    }

    protected void drawCentreMarker(Graphics g) {
        Container parent = this.getParent();
        Container parent2 = parent.getParent();
        Container parent3 = parent2.getParent();
        Container parent4 = parent3.getParent();
        JScrollPane scrollPane = ((GraphicSequenceCollection)parent4).jspSequence;
        JScrollBar slider = scrollPane.getHorizontalScrollBar();
        int pos = slider.getValue() + slider.getVisibleAmount() / 2;
        g.setColor(Color.white);
        g.drawLine(this.centreMarkerX, 0, this.centreMarkerX, this.seqHeight);
        g.setColor(Color.black);
        g.drawLine(pos, 0, pos, this.seqHeight);
        this.centreMarkerX = pos;
    }
}

