# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


class Observer(object):
    """Instances of Observer are notified of changes happening in the
    L{elisa.core.observers.observable.Observable} instance they are
    attached to.
    """

    def attribute_set(self, origin, key, old_value, new_value):
        """Called when an attribute of the observed object is changed.

        @param origin:    observed object for which the attribute is changed
        @type origin:     any
        @param key:       attribute changed
        @type key:        string
        @param old_value: value of the attribute before being set; None if
                          attribute was not existing
        @type old_value:  any
        @param new_value: value of the attribute after being set
        @type new_value:  any
        """
        pass
