#@ MODIF N_PROC Noyau  DATE 07/09/2009   AUTEUR COURTOIS M.COURTOIS 
# -*- coding: iso-8859-1 -*-
# RESPONSABLE COURTOIS M.COURTOIS
#            CONFIGURATION MANAGEMENT OF EDF VERSION
# ======================================================================
# COPYRIGHT (C) 1991 - 2002  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR   
# (AT YOUR OPTION) ANY LATER VERSION.                                 
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT 
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF          
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU    
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.                            
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE   
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,       
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.      
#                                                                       
#                                                                       
# ======================================================================


""" 
    Ce module contient la classe de definition PROC
    qui permet de spcifier les caractristiques d'une procdure
"""

import types,string,traceback

import N_ENTITE
import N_PROC_ETAPE

class PROC(N_ENTITE.ENTITE):
   """
    Classe pour definir un oprateur

    Cette classe a deux attributs de classe 

    - class_instance qui indique la classe qui devra etre utilise 
            pour crer l'objet qui servira  controler la conformit d'un 
            oprateur avec sa dfinition

    - label qui indique la nature de l'objet de dfinition (ici, PROC)


    et les attributs d'instance suivants :

    - nom   : son nom

    - op   : le numro d'oprateur

    - reentrant : vaut 'n' ou 'o'. Indique si l'oprateur est rentrant ou pas. Un oprateur
                        rentrant peut modifier un concept d'entre et le produire comme concept de sortie

    - repetable : vaut 'n' ou 'o'. Indique si l'oprateur est rpetable ou pas. Un oprateur
                        non rptable ne doit apparaitre qu'une fois dans une excution. C'est du ressort
                        de l'objet grant le contexte d'excution de vrifier cette contrainte.

    - fr   : commentaire associ en francais

    - ang : commentaire associ en anglais

    - docu : cl de documentation associe

    - regles : liste des rgles associes

    - op_init : cet attribut vaut None ou une fonction. Si cet attribut ne vaut pas None, cette
                      fonction est excute lors des phases d'initialisation de l'tape associe.

    - niveau : indique le niveau dans lequel est rang l'oprateur. Les oprateurs peuvent etre
                     rangs par niveau. Ils apparaissent alors exclusivement dans leur niveau de rangement.
                     Si niveau vaut None, l'oprateur est rang au niveau global.

    - entites : dictionnaire dans lequel sont stocks les sous entits de l'oprateur. Il s'agit
                      des entits de dfinition pour les mots-cls : FACT, BLOC, SIMP. Cet attribut
                      est initialis avec args, c'est  dire les arguments d'appel restants.


   """
   class_instance = N_PROC_ETAPE.PROC_ETAPE
   label = 'PROC'

   def __init__(self,nom,op,reentrant='n',repetable='o',fr="",ang="",
                docu="",regles=(),op_init=None,niveau = None,UIinfo=None,**args):
      """
         Mthode d'initialisation de l'objet PROC. Les arguments sont utiliss pour initialiser
         les attributs de meme nom
      """
      self.nom=nom
      self.op=op
      self.reentrant=reentrant
      self.repetable = repetable
      self.fr=fr
      self.ang=ang
      self.docu=docu
      if type(regles)== types.TupleType:
          self.regles=regles
      else:
          self.regles=(regles,)
      # Attribut op_init : Fonction a appeler a la construction de l operateur sauf si == None
      self.op_init=op_init
      self.entites=args
      current_cata=CONTEXT.get_current_cata()
      if niveau == None:
         self.niveau=None
         current_cata.enregistre(self)
      else:
         self.niveau=current_cata.get_niveau(niveau)
         self.niveau.enregistre(self)
      self.UIinfo=UIinfo
      self.affecter_parente()

   def __call__(self,**args):
      """
          Construit l'objet PROC_ETAPE a partir de sa definition (self),
          puis demande la construction de ses sous-objets et du concept produit.
      """
      etape= self.class_instance(oper=self,args=args)
      etape.McBuild()
      return etape.Build_sd()

   def make_objet(self,mc_list='oui'):
      """
           Cette mthode cre l'objet PROC_ETAPE dont la dfinition est self sans
            l'enregistrer ni crer sa sdprod.
           Si l'argument mc_list vaut 'oui', elle dclenche en plus la construction
           des objets MCxxx.
      """
      etape= self.class_instance(oper=self,args={})
      if mc_list == 'oui':etape.McBuild()
      return etape

   def verif_cata(self):
      """
          Mthode de vrification des attributs de dfinition
      """
      if type(self.regles) != types.TupleType :
        self.cr.fatal("L'attribut 'regles' doit etre un tuple : %s" %`self.regles`)
      if type(self.fr) != types.StringType :
        self.cr.fatal("L'attribut 'fr' doit etre une chaine de caractres : %s" %`self.fr`)
      if self.reentrant not in ('o','n','f'):
        self.cr.fatal("L'attribut 'reentrant' doit valoir 'o','n' ou 'f' : %s" %`self.reentrant`)
      if type(self.docu) != types.StringType :
        self.cr.fatal("L'attribut 'docu' doit etre une chaine de caractres : %s" %`self.docu` )
      if type(self.nom) != types.StringType :
        self.cr.fatal("L'attribut 'nom' doit etre une chaine de caractres : %s" %`self.nom`)
      if type(self.op) != types.IntType :
        self.cr.fatal("L'attribut 'op' doit etre un entier sign : %s" %`self.op`)
      self.verif_cata_regles()

   def supprime(self):
      """
          Mthode pour supprimer les rfrences arrires susceptibles de provoquer
          des cycles de rfrences
      """
      self.niveau=None


