#ifndef _ECS_VEC_DEF_PERIO_H_
#define _ECS_VEC_DEF_PERIO_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associées aux structures `ecs_vec_int_t' et `ecs_vec_real_t' décrivant
 *   les vecteurs indexés entier et réel
 *   et propres aux vecteurs indexés
 *      lies aux champs principaux de type "définition"
 *  Ces fonctions participent à la fonctionnalité de "périodicité"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_param_perio_glob.h"
#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int.h"
#include "ecs_vec_real.h"



/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------*
 *  Calcul de la matrice d'une rotation définie par un angle theta (en
 *   radians) et un vecteur unitaire direction.
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__mat_rot_3d
(
 ecs_real_t  angle,              /* --> Angle de rotation en degres           */
 ecs_real_t  direction[3],       /* --> Vecteur directeur (unitaire) de l'axe */
 ecs_real_t  matrice[3][3]       /* <-- Matrice definissant la rotation       */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui duplique les faces sélectionnées pour la périodicité
 *  ainsi que les arêtes et sommets associés. Les distances maximales
 *  associées aux sommets sont aussi dupliquées
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__duplique_def
(
       ecs_vec_int_t        *const  vec_def_fac,
       ecs_vec_int_t        *const  vec_def_are,
       ecs_vec_real_t       *const  vec_def_som,
       ecs_vec_int_t      * *const  vec_fac_perio,
       ecs_vec_int_t      * *const  vec_are_perio,
       ecs_vec_int_t      * *const  vec_som_perio,
 const ecs_tab_int_t             *  tab_fac_select,
       ecs_tab_real_t            *  dist_max_som,
 const ecs_param_perio_t            param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui duplique les normales aux faces périodiques dupliquées.
 *
 *  La taille du tableau normale_fac est doublée (elle doit initialement
 *  correspondre au nombre de faces sélectionnées, donc au nombre de valeurs
 *  non nulles de vec_fac_perio).
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__duplique_norm
(
 const ecs_vec_int_t        *const  vec_fac_perio,
 const ecs_param_perio_t            param_perio,
       float              * *       normale_fac
) ;


/*----------------------------------------------------------------------------
 *  Traitement spécifique pour la périodicité de rotation de 180 degrés
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__trait_spec_sym
(
       ecs_vec_real_t     * *const  vec_def_som,
       ecs_vec_int_t      * *const  vec_fac_perio,
       ecs_vec_int_t      * *const  vec_are_perio,
       ecs_vec_int_t      * *const  vec_som_perio,
 const ecs_tab_int_t                liste_som_new,
 const ecs_param_perio_t            param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui hérite le recollement dans le cas d'une périodicité
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__herite
(
       ecs_vec_int_t      * *const  vec_def_fac,
       ecs_vec_int_t      * *const  vec_def_are,
       ecs_vec_real_t     * *const  vec_def_som,
       ecs_vec_int_t        *const  vec_fac_old_new,
       ecs_vec_int_t        *const  vec_are_old_new,
       ecs_vec_int_t        *const  vec_som_old_new,
       ecs_vec_int_t      * *const  vec_fac_perio,
       ecs_vec_int_t      * *const  vec_are_perio,
       ecs_vec_int_t      * *const  vec_som_perio,
       ecs_tab_int_t        *const  liste_fac_err,
       ecs_tab_int_t        *const  liste_som_new,
 const ecs_param_perio_t            param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui nettoie les éléments dupliqués n'ayant pas participé au
 *  recollement périodique
 *
 *  Attention : cette fonction doit être appellée un nombre pair de fois
 *              (deux fois par périodicité) et contient un compteur statique
 *              égal au nombre d'appels modulo 2 + 1 à cet effet.
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__nettoie
(
       ecs_vec_int_t    * *const  vec_def_fac,
       ecs_vec_int_t    * *const  vec_def_are,
       ecs_vec_real_t   * *const  vec_def_som,
       ecs_vec_int_t      *const  vec_fac_old_new,
       ecs_vec_int_t      *const  vec_are_old_new,
       ecs_vec_int_t      *const  vec_fac_perio,
       ecs_vec_int_t      *const  vec_are_perio,
       ecs_vec_int_t      *const  vec_som_perio,
       ecs_tab_int_t      *const  liste_fac_err,
       ecs_tab_int_t      *const  liste_som_new,
 const ecs_param_perio_t          param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met à jour la renumérotation
 *  "éléments initiaux -> éléments périodiques" en fonction d'un champ
 *  "éléments précédents -> nouveaux éléments" en cas de modifications
 *  successives de la définition des éléments
 *  On modifie a la fois 'val_tab' et on décale 'pos_tab'.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__maj_elt_perio
(
 ecs_vec_int_t  *const vec_elt_perio,
 ecs_vec_int_t  *const vec_elt_old_new,
 size_t                nbr_elt_new
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met à jour le tableau renvoyé par
 * ecs_vec_def__typ_fac_cel() en fonction d'une connectivité ajoutée par
 * une périodicité.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__typ_fac_perio
(
 ecs_vec_int_t  * vec_fac_perio,
 ecs_tab_int_t  * typ_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui compte le nombre d'éléments périodiques.
 *  On vérifie qu'un élément périodique ne se voit pas lui-même (cela
 *  peut arriver dans le cas d'une périodicité de rotation de 180 degrés)
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_vec_def__compte_elt_perio
(
 const ecs_vec_int_t  * vec_elt_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la des faces périodiques associées à une
 *  périodicité num_per de la manière suivante :
 *  =>  [i,j; ...] avec i->j
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__liste_fac_perio
(
 const ecs_vec_int_t  * vec_elt_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui liste parmi les faces périodiques celles qui se "voient"
 *  elles-mêmes (i.e  "i -> i").
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__lis_fac_err
(
 const ecs_vec_int_t   *const vec_fac_perio,
       ecs_tab_int_t   *const liste_fac_err
) ;


#endif /* _ECS_VEC_DEF_PERIO_H_ */
