// ------------------------------------------------------------------------
// qechainoperatorinput.cpp: Chain operator input widget
// Copyright (C) 2000,2001 Kai Vehmanen (kai.vehmanen@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>

#include <qlayout.h>
#include <qlabel.h>
#include <qtabwidget.h>

#include <eca-object-map.h>
#include <eca-preset-map.h>
#include <audiofx_amplitude.h>

#include <eca-version.h>
#if ECA_LIBECASOUND_VERSION > 7
#include <eca-object-factory.h>
#else
#include <eca-static-object-maps.h>
#endif

#include "qeobjectmap.h"
#include "qeoperatorconfiguration.h"
#include "qechainoperatorinput.h"

using std::cerr;
using std::endl;

QEChainOperatorInput::QEChainOperatorInput (QWidget *parent, const char *name) 
  : QEInput(parent, name)
{
  default_chainop_repp = 0;
  init_layout();
}

QEChainOperatorInput::~QEChainOperatorInput (void)
{
  if (default_chainop_repp != 0)
    delete default_chainop_repp;
}

void QEChainOperatorInput::init_layout(void)
{
  QBoxLayout* top = new QVBoxLayout(this);
  maptab_rep = new QTabWidget(this, "maptab");

  const ECA_OBJECT_MAP& cop_map = ECA_OBJECT_FACTORY::chain_operator_map();
  const ECA_OBJECT_MAP& preset_map = ECA_OBJECT_FACTORY::preset_map();
  const ECA_OBJECT_MAP& ladspa_map = ECA_OBJECT_FACTORY::ladspa_plugin_map();

  omap_inputs.push_back(new QEObjectMap(&cop_map, this));
  maptab_rep->addTab(omap_inputs.back(), "&Chain operators");
  QObject::connect(omap_inputs.back(), SIGNAL(changed()), this, SLOT(operator_change_event()));

  omap_inputs.push_back(new QEObjectMap(&preset_map, this));
  maptab_rep->addTab(omap_inputs.back(), "&Effect presets");
  QObject::connect(omap_inputs.back(), SIGNAL(changed()), this, SLOT(operator_change_event()));

  omap_inputs.push_back(new QEObjectMap(&ladspa_map, this));
  maptab_rep->addTab(omap_inputs.back(), "&Ladspa plugins");
  QObject::connect(omap_inputs.back(), SIGNAL(changed()), this, SLOT(operator_change_event()));

  top->addWidget(maptab_rep, 2);
  QObject::connect(maptab_rep, SIGNAL(selected(const QString&)), 
  		   this, SLOT(operator_change_event()));

  chainop_repp = 0;
  const CHAIN_OPERATOR* temp_cop = dynamic_cast<const CHAIN_OPERATOR*>(omap_inputs[0]->result());
  if (temp_cop != 0) {
    chainop_repp = dynamic_cast<CHAIN_OPERATOR*>(temp_cop->new_expr());
    // std::cerr << "(qechainoperator) new_expr\n";
  }

  if (chainop_repp == 0) {
    default_chainop_repp = new QEEmptyChainOperator();
    chainop_repp = default_chainop_repp;
  }

  opconf_repp = new QEOperatorConfiguration(chainop_repp, this, "qeopconf");
  QObject::connect(opconf_repp,
		   SIGNAL(parameters_changed()), 
		   this, 
		   SLOT(parameter_change_event()));
  top->addWidget(opconf_repp, 1);
}

/**
 * Updates results from user-interface to the 
 * controlled operator.
 */
void QEChainOperatorInput::update_results(void)
{
  if (opconf_repp != 0) {
    opconf_repp->update_results();
  }
}

void QEChainOperatorInput::operator_change_event(void)
{
//    cerr << "operator_change_event()" << endl;
  QEObjectMap* omap = dynamic_cast<QEObjectMap*>(maptab_rep->currentPage());
  
  const CHAIN_OPERATOR* temp_cop = dynamic_cast<const CHAIN_OPERATOR*>(omap->result());
  if (temp_cop != 0) {
    if (chainop_repp != 0 &&
	chainop_repp != default_chainop_repp) {
      delete chainop_repp;
      // std::cerr << "(qechainoperator) delete\n";
      chainop_repp = 0;
    }
    chainop_repp = dynamic_cast<CHAIN_OPERATOR*>(temp_cop->new_expr());
    // std::cerr << "(qechainoperator) new_expr (2)\n";
  }
  else {
    // std::cerr << "(qechainoperator) temp_cop failed; " << omap->result() << ".\n";
    chainop_repp = default_chainop_repp;
  }

  if (opconf_repp != 0 && chainop_repp != 0) 
    opconf_repp->change_operator(chainop_repp);

  update_results();

  emit changed();
  emit operator_changed();
}

void QEChainOperatorInput::parameter_change_event(void)
{
  // cerr << "parameter_change_event()" << endl;
  emit changed();
  emit parameters_changed();
}
