/* - mode: c; c-basic-offset: 2; indent-tabs-mode: nil; -*-
 *  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 *  Copyright (C) 2008 MySQL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"

#include <client/errname.h>

using namespace std;

ErrorCodes::ErrorCodes()
  :
    error_code_map()
{
  static struct st_error
  {
    const char *name;
    uint32_t code;
  }
  st_error_names[]=
  {
    { "ER_NO",1002 },
    { "ER_YES",1003 },
    { "ER_CANT_CREATE_FILE",1004 },
    { "ER_CANT_CREATE_TABLE",1005 },
    { "ER_CANT_CREATE_DB",1006 },
    { "ER_DB_CREATE_EXISTS",1007 },
    { "ER_DB_DROP_EXISTS",1008 },
    { "ER_UNUSED1009",1009 },
    { "ER_UNUSED1010",1010 },
    { "ER_CANT_DELETE_FILE",1011 },
    { "ER_UNUSED1012",1012 },
    { "ER_CANT_GET_STAT",1013 },
    { "ER_UNUSED1014",1014 },
    { "ER_CANT_LOCK",1015 },
    { "ER_CANT_OPEN_FILE",1016 },
    { "ER_FILE_NOT_FOUND",1017 },
    { "ER_CANT_READ_DIR",1018 },
    { "ER_UNUSED1019",1019 },
    { "ER_CHECKREAD",1020 },
    { "ER_DISK_FULL",1021 },
    { "ER_DUP_KEY",1022 },
    { "ER_ERROR_ON_CLOSE",1023 },
    { "ER_ERROR_ON_READ",1024 },
    { "ER_ERROR_ON_RENAME",1025 },
    { "ER_ERROR_ON_WRITE",1026 },
    { "ER_FILE_USED",1027 },
    { "ER_FILSORT_ABORT",1028 },
    { "ER_UNUSED1029",1029 },
    { "ER_GET_ERRNO",1030 },
    { "ER_ILLEGAL_HA",1031 },
    { "ER_KEY_NOT_FOUND",1032 },
    { "ER_NOT_FORM_FILE",1033 },
    { "ER_NOT_KEYFILE",1034 },
    { "ER_OLD_KEYFILE",1035 },
    { "ER_OPEN_AS_READONLY",1036 },
    { "ER_OUTOFMEMORY",1037 },
    { "ER_OUT_OF_SORTMEMORY",1038 },
    { "ER_UNEXPECTED_EOF",1039 },
    { "ER_CON_COUNT_ERROR",1040 },
    { "ER_OUT_OF_RESOURCES",1041 },
    { "ER_BAD_HOST_ERROR",1042 },
    { "ER_HANDSHAKE_ERROR",1043 },
    { "ER_DBACCESS_DENIED_ERROR",1044 },
    { "ER_ACCESS_DENIED_ERROR",1045 },
    { "ER_NO_DB_ERROR",1046 },
    { "ER_UNKNOWN_COM_ERROR",1047 },
    { "ER_BAD_NULL_ERROR",1048 },
    { "ER_BAD_DB_ERROR",1049 },
    { "ER_TABLE_EXISTS_ERROR",1050 },
    { "ER_BAD_TABLE_ERROR",1051 },
    { "ER_NON_UNIQ_ERROR",1052 },
    { "ER_SERVER_SHUTDOWN",1053 },
    { "ER_BAD_FIELD_ERROR",1054 },
    { "ER_WRONG_FIELD_WITH_GROUP",1055 },
    { "ER_WRONG_GROUP_FIELD",1056 },
    { "ER_WRONG_SUM_SELECT",1057 },
    { "ER_WRONG_VALUE_COUNT",1058 },
    { "ER_TOO_LONG_IDENT",1059 },
    { "ER_DUP_FIELDNAME",1060 },
    { "ER_DUP_KEYNAME",1061 },
    { "ER_DUP_ENTRY",1062 },
    { "ER_WRONG_FIELD_SPEC",1063 },
    { "ER_PARSE_ERROR",1064 },
    { "ER_EMPTY_QUERY",1065 },
    { "ER_NONUNIQ_TABLE",1066 },
    { "ER_INVALID_DEFAULT",1067 },
    { "ER_MULTIPLE_PRI_KEY",1068 },
    { "ER_TOO_MANY_KEYS",1069 },
    { "ER_TOO_MANY_KEY_PARTS",1070 },
    { "ER_TOO_LONG_KEY",1071 },
    { "ER_KEY_COLUMN_DOES_NOT_EXITS",1072 },
    { "ER_BLOB_USED_AS_KEY",1073 },
    { "ER_TOO_BIG_FIELDLENGTH",1074 },
    { "ER_WRONG_AUTO_KEY",1075 },
    { "ER_UNUSED1076",1076 },
    { "ER_NORMAL_SHUTDOWN",1077 },
    { "ER_GOT_SIGNAL",1078 },
    { "ER_SHUTDOWN_COMPLETE",1079 },
    { "ER_FORCING_CLOSE",1080 },
    { "ER_IPSOCK_ERROR",1081 },
    { "ER_NO_SUCH_INDEX",1082 },
    { "ER_WRONG_FIELD_TERMINATORS",1083 },
    { "ER_BLOBS_AND_NO_TERMINATED",1084 },
    { "ER_TEXTFILE_NOT_READABLE",1085 },
    { "ER_FILE_EXISTS_ERROR",1086 },
    { "ER_LOAD_INFO",1087 },
    { "ER_UNUSED1088",1088 },
    { "ER_WRONG_SUB_KEY",1089 },
    { "ER_CANT_REMOVE_ALL_FIELDS",1090 },
    { "ER_CANT_DROP_FIELD_OR_KEY",1091 },
    { "ER_INSERT_INFO",1092 },
    { "ER_UPDATE_TABLE_USED",1093 },
    { "ER_NO_SUCH_THREAD",1094 },
    { "ER_KILL_DENIED_ERROR",1095 },
    { "ER_NO_TABLES_USED",1096 },
    { "ER_UNUSED1097",1097 },
    { "ER_UNUSED1098",1098 },
    { "ER_UNUSED1099",1099 },
    { "ER_UNUSED1100",1100 },
    { "ER_BLOB_CANT_HAVE_DEFAULT",1101 },
    { "ER_WRONG_DB_NAME",1102 },
    { "ER_WRONG_TABLE_NAME",1103 },
    { "ER_TOO_BIG_SELECT",1104 },
    { "ER_UNKNOWN_ERROR",1105 },
    { "ER_UNKNOWN_PROCEDURE",1106 },
    { "ER_WRONG_PARAMCOUNT_TO_PROCEDURE",1107 },
    { "ER_UNUSED1108",1108 },
    { "ER_UNKNOWN_TABLE",1109 },
    { "ER_FIELD_SPECIFIED_TWICE",1110 },
    { "ER_INVALID_GROUP_FUNC_USE",1111 },
    { "ER_UNSUPPORTED_EXTENSION",1112 },
    { "ER_TABLE_MUST_HAVE_COLUMNS",1113 },
    { "ER_RECORD_FILE_FULL",1114 },
    { "ER_UNUSED1115",1115 },
    { "ER_TOO_MANY_TABLES",1116 },
    { "ER_TOO_MANY_FIELDS",1117 },
    { "ER_TOO_BIG_ROWSIZE",1118 },
    { "ER_UNUSED1119",1119 },
    { "ER_WRONG_OUTER_JOIN",1120 },
    { "ER_NULL_COLUMN_IN_INDEX",1121 },
    { "ER_UNUSED1122",1122 },
    { "ER_UNUSED1123",1123 },
    { "ER_PLUGIN_NO_PATHS",1124 },
    { "ER_PLUGIN_EXISTS",1125 },
    { "ER_CANT_OPEN_LIBRARY",1126 },
    { "ER_CANT_FIND_DL_ENTRY",1127 },
    { "ER_UNUSED1128",1128 },
    { "ER_UNUSED1129",1129 },
    { "ER_UNUSED1130",1130 },
    { "ER_UNUSED1131",1131 },
    { "ER_UNUSED1132",1132 },
    { "ER_UNUSED1133",1133 },
    { "ER_UPDATE_INFO",1134 },
    { "ER_CANT_CREATE_THREAD",1135 },
    { "ER_WRONG_VALUE_COUNT_ON_ROW",1136 },
    { "ER_CANT_REOPEN_TABLE",1137 },
    { "ER_UNUSED1138",1138 },
    { "ER_UNUSED1139",1139 },
    { "ER_MIX_OF_GROUP_FUNC_AND_FIELDS",1140 },
    { "ER_UNUSED1141",1141 },
    { "ER_UNUSED1142",1142 },
    { "ER_UNUSED1143",1143 },
    { "ER_UNUSED1144",1144 },
    { "ER_UNUSED1145",1145 },
    { "ER_NO_SUCH_TABLE",1146 },
    { "ER_UNUSED1147",1147 },
    { "ER_UNUSED1148",1148 },
    { "ER_SYNTAX_ERROR",1149 },
    { "ER_UNUSED1150",1150 },
    { "ER_UNUSED1151",1151 },
    { "ER_UNUSED1152",1152 },
    { "ER_NET_PACKET_TOO_LARGE",1153 },
    { "ER_UNUSED1154",1154 },
    { "ER_UNUSED1155",1155 },
    { "ER_NET_PACKETS_OUT_OF_ORDER",1156 },
    { "ER_UNUSED1157",1157 },
    { "ER_UNUSED1158",1158 },
    { "ER_UNUSED1159",1159 },
    { "ER_UNUSED1160",1160 },
    { "ER_UNUSED1161",1161 },
    { "ER_UNUSED1162",1162 },
    { "ER_TABLE_CANT_HANDLE_BLOB",1163 },
    { "ER_TABLE_CANT_HANDLE_AUTO_INCREMENT",1164 },
    { "ER_UNUSED1165",1165 },
    { "ER_WRONG_COLUMN_NAME",1166 },
    { "ER_WRONG_KEY_COLUMN",1167 },
    { "ER_WRONG_MRG_TABLE",1168 },
    { "ER_DUP_UNIQUE",1169 },
    { "ER_BLOB_KEY_WITHOUT_LENGTH",1170 },
    { "ER_PRIMARY_CANT_HAVE_NULL",1171 },
    { "ER_TOO_MANY_ROWS",1172 },
    { "ER_REQUIRES_PRIMARY_KEY",1173 },
    { "ER_UNUSED1174",1174 },
    { "ER_UNUSED1175",1175 },
    { "ER_KEY_DOES_NOT_EXITS",1176 },
    { "ER_CHECK_NO_SUCH_TABLE",1177 },
    { "ER_CHECK_NOT_IMPLEMENTED",1178 },
    { "ER_UNUSED1179",1179 },
    { "ER_ERROR_DURING_COMMIT",1180 },
    { "ER_ERROR_DURING_ROLLBACK",1181 },
    { "ER_UNUSED1182",1182 },
    { "ER_UNUSED1183",1183 },
    { "ER_NEW_ABORTING_CONNECTION",1184 },
    { "ER_UNUSED1185",1185 },
    { "ER_UNUSED1186",1186 },
    { "ER_UNUSED1187",1187 },
    { "ER_UNUSED1188",1188 },
    { "ER_UNUSED1189",1189 },
    { "ER_UNUSED1190",1190 },
    { "ER_UNUSED1191",1191 },
    { "ER_LOCK_OR_ACTIVE_TRANSACTION",1192 },
    { "ER_UNKNOWN_SYSTEM_VARIABLE",1193 },
    { "ER_CRASHED_ON_USAGE",1194 },
    { "ER_CRASHED_ON_REPAIR",1195 },
    { "ER_WARNING_NOT_COMPLETE_ROLLBACK",1196 },
    { "ER_UNUSED1197",1197 },
    { "ER_UNUSED1198",1198 },
    { "ER_UNUSED1199",1199 },
    { "ER_BAD_SLAVE",1200 },
    { "ER_UNUSED1201",1201 },
    { "ER_UNUSED1202",1202 },
    { "ER_UNUSED1203",1203 },
    { "ER_SET_CONSTANTS_ONLY",1204 },
    { "ER_LOCK_WAIT_TIMEOUT",1205 },
    { "ER_LOCK_TABLE_FULL",1206 },
    { "ER_READ_ONLY_TRANSACTION",1207 },
    { "ER_DROP_DB_WITH_READ_LOCK",1208 },
    { "ER_UNUSED1209",1209 },
    { "ER_WRONG_ARGUMENTS",1210 },
    { "ER_UNUSED1211",1211 },
    { "ER_UNUSED1212",1212 },
    { "ER_LOCK_DEADLOCK",1213 },
    { "ER_TABLE_CANT_HANDLE_FT",1214 },
    { "ER_CANNOT_ADD_FOREIGN",1215 },
    { "ER_NO_REFERENCED_ROW",1216 },
    { "ER_ROW_IS_REFERENCED",1217 },
    { "ER_UNUSED1218",1218 },
    { "ER_UNUSED1219",1219 },
    { "ER_UNUSED1220",1220 },
    { "ER_WRONG_USAGE",1221 },
    { "ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT",1222 },
    { "ER_CANT_UPDATE_WITH_READLOCK",1223 },
    { "ER_UNUSED1224",1224 },
    { "ER_UNUSED1225",1225 },
    { "ER_UNUSED1226",1226 },
    { "ER_UNUSED1227",1227 },
    { "ER_LOCAL_VARIABLE",1228 },
    { "ER_GLOBAL_VARIABLE",1229 },
    { "ER_NO_DEFAULT",1230 },
    { "ER_WRONG_VALUE_FOR_VAR",1231 },
    { "ER_WRONG_TYPE_FOR_VAR",1232 },
    { "ER_VAR_CANT_BE_READ",1233 },
    { "ER_CANT_USE_OPTION_HERE",1234 },
    { "ER_NOT_SUPPORTED_YET",1235 },
    { "ER_UNUSED1236",1236 },
    { "ER_UNUSED1237",1237 },
    { "ER_INCORRECT_GLOBAL_LOCAL_VAR",1238 },
    { "ER_WRONG_FK_DEF",1239 },
    { "ER_KEY_REF_DO_NOT_MATCH_TABLE_REF",1240 },
    { "ER_OPERAND_COLUMNS",1241 },
    { "ER_SUBQUERY_NO_1_ROW",1242 },
    { "ER_UNUSED1243",1243 },
    { "ER_UNUSED1244",1244 },
    { "ER_UNUSED1245",1245 },
    { "ER_AUTO_CONVERT",1246 },
    { "ER_ILLEGAL_REFERENCE",1247 },
    { "ER_DERIVED_MUST_HAVE_ALIAS",1248 },
    { "ER_SELECT_REDUCED",1249 },
    { "ER_TABLENAME_NOT_ALLOWED_HERE",1250 },
    { "ER_UNUSED1251",1251 },
    { "ER_SPATIAL_CANT_HAVE_NULL",1252 },
    { "ER_COLLATION_CHARSET_MISMATCH",1253 },
    { "ER_UNUSED1254",1254 },
    { "ER_UNUSED1255",1255 },
    { "ER_TOO_BIG_FOR_UNCOMPRESS",1256 },
    { "ER_ZLIB_Z_MEM_ERROR",1257 },
    { "ER_ZLIB_Z_BUF_ERROR",1258 },
    { "ER_ZLIB_Z_DATA_ERROR",1259 },
    { "ER_CUT_VALUE_GROUP_CONCAT",1260 },
    { "ER_WARN_TOO_FEW_RECORDS",1261 },
    { "ER_WARN_TOO_MANY_RECORDS",1262 },
    { "ER_WARN_NULL_TO_NOTNULL",1263 },
    { "ER_WARN_DATA_OUT_OF_RANGE",1264 },
    { "ER_WARN_DATA_TRUNCATED",1265 },
    { "ER_UNUSED1266",1266 },
    { "ER_CANT_AGGREGATE_2COLLATIONS",1267 },
    { "ER_UNUSED1268",1268 },
    { "ER_UNUSED1269",1269 },
    { "ER_CANT_AGGREGATE_3COLLATIONS",1270 },
    { "ER_CANT_AGGREGATE_NCOLLATIONS",1271 },
    { "ER_VARIABLE_IS_NOT_STRUCT",1272 },
    { "ER_UNKNOWN_COLLATION",1273 },
    { "ER_UNUSED1274",1274 },
    { "ER_UNUSED1275",1275 },
    { "ER_WARN_FIELD_RESOLVED",1276 },
    { "ER_UNUSED1277",1277 },
    { "ER_UNUSED1278",1278 },
    { "ER_UNUSED1279",1279 },
    { "ER_WRONG_NAME_FOR_INDEX",1280 },
    { "ER_WRONG_NAME_FOR_CATALOG",1281 },
    { "ER_UNUSED1282",1282 },
    { "ER_BAD_FT_COLUMN",1283 },
    { "ER_UNUSED1284",1284 },
    { "ER_UNUSED1285",1285 },
    { "ER_UNKNOWN_STORAGE_ENGINE",1286 },
    { "ER_UNUSED1287",1287 },
    { "ER_NON_UPDATABLE_TABLE",1288 },
    { "ER_FEATURE_DISABLED",1289 },
    { "ER_OPTION_PREVENTS_STATEMENT",1290 },
    { "ER_DUPLICATED_VALUE_IN_TYPE",1291 },
    { "ER_TRUNCATED_WRONG_VALUE",1292 },
    { "ER_TOO_MUCH_AUTO_TIMESTAMP_COLS",1293 },
    { "ER_INVALID_ON_UPDATE",1294 },
    { "ER_UNUSED1295",1295 },
    { "ER_GET_ERRMSG",1296 },
    { "ER_GET_TEMPORARY_ERRMSG",1297 },
    { "ER_UNKNOWN_TIME_ZONE",1298 },
    { "ER_UNUSED1299",1299 },
    { "ER_INVALID_CHARACTER_STRING",1300 },
    { "ER_WARN_ALLOWED_PACKET_OVERFLOWED",1301 },
    { "ER_UNUSED1302",1302 },
    { "ER_UNUSED1303",1303 },
    { "ER_UNUSED1304",1304 },
    { "ER_SP_DOES_NOT_EXIST",1305 },
    { "ER_UNUSED1306",1306 },
    { "ER_UNUSED1307",1307 },
    { "ER_UNUSED1308",1308 },
    { "ER_UNUSED1309",1309 },
    { "ER_UNUSED1310",1310 },
    { "ER_UNUSED1311",1311 },
    { "ER_UNUSED1312",1312 },
    { "ER_UNUSED1313",1313 },
    { "ER_UNUSED1314",1314 },
    { "ER_UNUSED1315",1315 },
    { "ER_UNUSED1316",1316 },
    { "ER_QUERY_INTERRUPTED",1317 },
    { "ER_UNUSED1318",1318 },
    { "ER_UNUSED1319",1319 },
    { "ER_UNUSED1320",1320 },
    { "ER_UNUSED1321",1321 },
    { "ER_UNUSED1322",1322 },
    { "ER_UNUSED1323",1323 },
    { "ER_UNUSED1324",1324 },
    { "ER_UNUSED1325",1325 },
    { "ER_UNUSED1326",1326 },
    { "ER_UNUSED1327",1327 },
    { "ER_UNUSED1328",1328 },
    { "ER_SP_FETCH_NO_DATA",1329 },
    { "ER_UNUSED1330",1330 },
    { "ER_UNUSED1331",1331 },
    { "ER_UNUSED1332",1332 },
    { "ER_UNUSED1333",1333 },
    { "ER_UNUSED1334",1334 },
    { "ER_UNUSED1335",1335 },
    { "ER_UNUSED1336",1336 },
    { "ER_UNUSED1337",1337 },
    { "ER_UNUSED1338",1338 },
    { "ER_UNUSED1339",1339 },
    { "ER_UNUSED1340",1340 },
    { "ER_UNUSED1341",1341 },
    { "ER_UNUSED1342",1342 },
    { "ER_UNUSED1343",1343 },
    { "ER_UNUSED1344",1344 },
    { "ER_UNUSED1345",1345 },
    { "ER_UNUSED1346",1346 },
    { "ER_UNUSED1347",1347 },
    { "ER_UNUSED1348",1348 },
    { "ER_UNUSED1349",1349 },
    { "ER_UNUSED1350",1350 },
    { "ER_UNUSED1351",1351 },
    { "ER_UNUSED1352",1352 },
    { "ER_UNUSED1353",1353 },
    { "ER_UNUSED1354",1354 },
    { "ER_UNUSED1355",1355 },
    { "ER_VIEW_INVALID",1356 },
    { "ER_UNUSED1357",1357 },
    { "ER_UNUSED1358",1358 },
    { "ER_UNUSED1359",1359 },
    { "ER_UNUSED1360",1360 },
    { "ER_UNUSED1361",1361 },
    { "ER_UNUSED1362",1362 },
    { "ER_UNUSED1363",1363 },
    { "ER_NO_DEFAULT_FOR_FIELD",1364 },
    { "ER_DIVISION_BY_ZERO",1365 },
    { "ER_TRUNCATED_WRONG_VALUE_FOR_FIELD",1366 },
    { "ER_ILLEGAL_VALUE_FOR_TYPE",1367 },
    { "ER_UNUSED1368",1368 },
    { "ER_UNUSED1369",1369 },
    { "ER_UNUSED1370",1370 },
    { "ER_UNUSED1371",1371 },
    { "ER_UNUSED1372",1372 },
    { "ER_UNUSED1373",1373 },
    { "ER_UNUSED1374",1374 },
    { "ER_UNUSED1375",1375 },
    { "ER_UNUSED1376",1376 },
    { "ER_UNUSED1377",1377 },
    { "ER_UNUSED1378",1378 },
    { "ER_UNUSED1379",1379 },
    { "ER_UNUSED1380",1380 },
    { "ER_UNUSED1381",1381 },
    { "ER_UNUSED1382",1382 },
    { "ER_UNUSED1383",1383 },
    { "ER_UNUSED1384",1384 },
    { "ER_UNUSED1385",1385 },
    { "ER_UNUSED1386",1386 },
    { "ER_UNUSED1387",1387 },
    { "ER_UNUSED1388",1388 },
    { "ER_UNUSED1389",1389 },
    { "ER_UNUSED1390",1390 },
    { "ER_KEY_PART_0",1391 },
    { "ER_UNUSED1392",1392 },
    { "ER_UNUSED1393",1393 },
    { "ER_UNUSED1394",1394 },
    { "ER_UNUSED1395",1395 },
    { "ER_UNUSED1396",1396 },
    { "ER_UNUSED1397",1397 },
    { "ER_UNUSED1398",1398 },
    { "ER_XAER_RMFAIL",1399 },
    { "ER_UNUSED1400",1400 },
    { "ER_UNUSED1401",1401 },
    { "ER_UNUSED1402",1402 },
    { "ER_UNUSED1403",1403 },
    { "ER_UNUSED1404",1404 },
    { "ER_UNUSED1405",1405 },
    { "ER_DATA_TOO_LONG",1406 },
    { "ER_UNUSED1407",1407 },
    { "ER_STARTUP",1408 },
    { "ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR",1409 },
    { "ER_UNUSED1410",1410 },
    { "ER_WRONG_VALUE_FOR_TYPE",1411 },
    { "ER_TABLE_DEF_CHANGED",1412 },
    { "ER_UNUSED1413",1413 },
    { "ER_UNUSED1414",1414 },
    { "ER_SP_NO_RETSET",1415 },
    { "ER_CANT_CREATE_GEOMETRY_OBJECT",1416 },
    { "ER_UNUSED1417",1417 },
    { "ER_UNUSED1418",1418 },
    { "ER_UNUSED1419",1419 },
    { "ER_UNUSED1420",1420 },
    { "ER_UNUSED1421",1421 },
    { "ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG",1422 },
    { "ER_UNUSED1423",1423 },
    { "ER_UNUSED1424",1424 },
    { "ER_TOO_BIG_SCALE",1425 },
    { "ER_TOO_BIG_PRECISION",1426 },
    { "ER_M_BIGGER_THAN_D",1427 },
    { "ER_UNUSED1428",1428 },
    { "ER_UNUSED1429",1429 },
    { "ER_UNUSED1430",1430 },
    { "ER_UNUSED1431",1431 },
    { "ER_UNUSED1432",1432 },
    { "ER_UNUSED1433",1433 },
    { "ER_UNUSED1434",1434 },
    { "ER_TRG_IN_WRONG_SCHEMA",1435 },
    { "ER_STACK_OVERRUN_NEED_MORE",1436 },
    { "ER_UNUSED1437",1437 },
    { "ER_UNUSED1438",1438 },
    { "ER_TOO_BIG_DISPLAYWIDTH",1439 },
    { "ER_UNUSED1440",1440 },
    { "ER_DATETIME_FUNCTION_OVERFLOW",1441 },
    { "ER_UNUSED1442",1442 },
    { "ER_UNUSED1443",1443 },
    { "ER_UNUSED1444",1444 },
    { "ER_UNUSED1445",1445 },
    { "ER_UNUSED1446",1446 },
    { "ER_UNUSED1447",1447 },
    { "ER_UNUSED1448",1448 },
    { "ER_UNUSED1449",1449 },
    { "ER_UNUSED1450",1450 },
    { "ER_ROW_IS_REFERENCED_2",1451 },
    { "ER_NO_REFERENCED_ROW_2",1452 },
    { "ER_UNUSED1453",1453 },
    { "ER_UNUSED1454",1454 },
    { "ER_UNUSED1455",1455 },
    { "ER_UNUSED1456",1456 },
    { "ER_UNUSED1457",1457 },
    { "ER_UNUSED1458",1458 },
    { "ER_TABLE_NEEDS_UPGRADE",1459 },
    { "ER_UNUSED1460",1460 },
    { "ER_UNUSED1461",1461 },
    { "ER_UNUSED1462",1462 },
    { "ER_NON_GROUPING_FIELD_USED",1463 },
    { "ER_TABLE_CANT_HANDLE_SPKEYS",1464 },
    { "ER_UNUSED1465",1465 },
    { "ER_REMOVED_SPACES",1466 },
    { "ER_AUTOINC_READ_FAILED",1467 },
    { "ER_UNUSED1468",1468 },
    { "ER_UNUSED1469",1469 },
    { "ER_WRONG_STRING_LENGTH",1470 },
    { "ER_UNUSED1471",1471 },
    { "ER_UNUSED1472",1472 },
    { "ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT",1473 },
    { "ER_NAME_BECOMES_EMPTY",1474 },
    { "ER_AMBIGUOUS_FIELD_TERM",1475 },
    { "ER_UNUSED1476",1476 },
    { "ER_UNUSED1477",1477 },
    { "ER_ILLEGAL_HA_CREATE_OPTION",1478 },
    { "ER_UNUSED1479",1479 },
    { "ER_UNUSED1480",1480 },
    { "ER_UNUSED1481",1481 },
    { "ER_UNUSED1482",1482 },
    { "ER_UNUSED1483",1483 },
    { "ER_UNUSED1484",1484 },
    { "ER_UNUSED1485",1485 },
    { "ER_UNUSED1486",1486 },
    { "ER_UNUSED1487",1487 },
    { "ER_UNUSED1488",1488 },
    { "ER_UNUSED1489",1489 },
    { "ER_UNUSED1490",1490 },
    { "ER_UNUSED1491",1491 },
    { "ER_UNUSED1492",1492 },
    { "ER_UNUSED1493",1493 },
    { "ER_UNUSED1494",1494 },
    { "ER_UNUSED1495",1495 },
    { "ER_UNUSED1496",1496 },
    { "ER_UNUSED1497",1497 },
    { "ER_UNUSED1498",1498 },
    { "ER_UNUSED1499",1499 },
    { "ER_UNUSED1500",1500 },
    { "ER_UNUSED1501",1501 },
    { "ER_UNUSED1502",1502 },
    { "ER_UNUSED1503",1503 },
    { "ER_UNUSED1504",1504 },
    { "ER_UNUSED1505",1505 },
    { "ER_UNUSED1506",1506 },
    { "ER_UNUSED1507",1507 },
    { "ER_UNUSED1508",1508 },
    { "ER_UNUSED1509",1509 },
    { "ER_UNUSED1510",1510 },
    { "ER_UNUSED1511",1511 },
    { "ER_UNUSED1512",1512 },
    { "ER_UNUSED1513",1513 },
    { "ER_UNUSED1514",1514 },
    { "ER_UNUSED1515",1515 },
    { "ER_UNUSED1516",1516 },
    { "ER_UNUSED1517",1517 },
    { "ER_UNUSED1518",1518 },
    { "ER_UNUSED1519",1519 },
    { "ER_UNUSED1520",1520 },
    { "ER_UNUSED1521",1521 },
    { "ER_UNUSED1522",1522 },
    { "ER_UNUSED1523",1523 },
    { "ER_UNUSED1524",1524 },
    { "ER_WRONG_VALUE",1525 },
    { "ER_NO_PARTITION_FOR_GIVEN_VALUE",1526 },
    { "ER_UNUSED1527",1527 },
    { "ER_UNUSED1528",1528 },
    { "ER_UNUSED1529",1529 },
    { "ER_UNUSED1530",1530 },
    { "ER_UNUSED1531",1531 },
    { "ER_UNUSED1532",1532 },
    { "ER_UNUSED1533",1533 },
    { "ER_BINLOG_ROW_LOGGING_FAILED",1534 },
    { "ER_UNUSED1535",1535 },
    { "ER_UNUSED1536",1536 },
    { "ER_UNUSED1537",1537 },
    { "ER_UNUSED1538",1538 },
    { "ER_UNUSED1539",1539 },
    { "ER_UNUSED1540",1540 },
    { "ER_UNUSED1541",1541 },
    { "ER_UNUSED1542",1542 },
    { "ER_UNUSED1543",1543 },
    { "ER_UNUSED1544",1544 },
    { "ER_UNUSED1545",1545 },
    { "ER_UNUSED1546",1546 },
    { "ER_UNUSED1547",1547 },
    { "ER_UNUSED1548",1548 },
    { "ER_UNUSED1549",1549 },
    { "ER_UNUSED1550",1550 },
    { "ER_UNUSED1551",1551 },
    { "ER_UNUSED1552",1552 },
    { "ER_DROP_INDEX_FK",1553 },
    { "ER_UNUSED1554",1554 },
    { "ER_UNUSED1555",1555 },
    { "ER_UNUSED1556",1556 },
    { "ER_FOREIGN_DUPLICATE_KEY",1557 },
    { "ER_UNUSED1558",1558 },
    { "ER_UNUSED1559",1559 },
    { "ER_UNUSED1560",1560 },
    { "ER_UNUSED1561",1561 },
    { "ER_UNUSED1562",1562 },
    { "ER_UNUSED1563",1563 },
    { "ER_UNUSED1564",1564 },
    { "ER_UNUSED1565",1565 },
    { "ER_UNUSED1566",1566 },
    { "ER_UNUSED1567",1567 },
    { "ER_CANT_CHANGE_TX_ISOLATION",1568 },
    { "ER_UNUSED1569",1569 },
    { "ER_UNUSED1570",1570 },
    { "ER_UNUSED1571",1571 },
    { "ER_UNUSED1572",1572 },
    { "ER_UNUSED1573",1573 },
    { "ER_UNUSED1574",1574 },
    { "ER_UNUSED1575",1575 },
    { "ER_UNUSED1576",1576 },
    { "ER_UNUSED1577",1577 },
    { "ER_UNUSED1578",1578 },
    { "ER_UNUSED1579",1579 },
    { "ER_UNUSED1580",1580 },
    { "ER_UNUSED1581",1581 },
    { "ER_WRONG_PARAMCOUNT_TO_FUNCTION",1582 },
    { "ER_WRONG_PARAMETERS_TO_NATIVE_FCT",1583 },
    { "ER_UNUSED1584",1584 },
    { "ER_UNUSED1585",1585 },
    { "ER_DUP_ENTRY_WITH_KEY_NAME",1586 },
    { "ER_UNUSED1587",1587 },
    { "ER_UNUSED1588",1588 },
    { "ER_UNUSED1589",1589 },
    { "ER_UNUSED1590",1590 },
    { "ER_UNUSED1591",1591 },
    { "ER_UNUSED1592",1592 },
    { "ER_UNUSED1593",1593 },
    { "ER_UNUSED1594",1594 },
    { "ER_UNUSED1595",1595 },
    { "ER_UNUSED1596",1596 },
    { "ER_UNUSED1597",1597 },
    { "ER_UNUSED1598",1598 },
    { "ER_UNUSED1599",1599 },
    { "ER_UNUSED1600",1600 },
    { "ER_UNUSED1601",1601 },
    { "ER_UNUSED1602",1602 },
    { "ER_UNUSED1603",1603 },
    { "ER_UNUSED1604",1604 },
    { "ER_UNUSED1605",1605 },
    { "ER_UNUSED1606",1606 },
    { "ER_UNUSED1607",1607 },
    { "ER_UNUSED1608",1608 },
    { "ER_UNUSED1609",1609 },
    { "ER_UNUSED1610",1610 },
    { "ER_LOAD_DATA_INVALID_COLUMN",1611 },
    { "ER_UNUSED1612",1612 },
    { "ER_UNUSED1613",1613 },
    { "ER_UNUSED1614",1614 },
    { "ER_UNUSED1615",1615 },
    { "ER_UNUSED1616",1616 },
    { "ER_UNUSED1617",1617 },
    { "ER_UNUSED1618",1618 },
    { "ER_UNUSED1619",1619 },
    { "ER_UNUSED1620",1620 },
    { "ER_UNUSED1621",1621 },
    { "ER_UNUSED1622",1622 },
    { "ER_UNUSED1623",1623 },
    { "ER_UNUSED1624",1624 },
    { "ER_UNUSED1625",1625 },
    { "ER_UNUSED1626",1626 },
    { "ER_UNUSED1627",1627 },
    { "ER_UNUSED1628",1628 },
    { "ER_UNUSED1629",1629 },
    { "ER_UNUSED1630",1630 },
    { "ER_UNUSED1631",1631 },
    { "ER_UNUSED1632",1632 },
    { "ER_UNUSED1633",1633 },
    { "ER_UNUSED1634",1634 },
    { "ER_UNUSED1635",1635 },
    { "ER_UNUSED1636",1636 },
    { "ER_UNUSED1637",1637 },
    { "ER_UNUSED1638",1638 },
    { "ER_UNUSED1639",1639 },
    { "ER_UNUSED1640",1640 },
    { "ER_UNUSED1641",1641 },
    { "ER_UNUSED1642",1642 },
    { "ER_UNUSED1643",1643 },
    { "ER_UNUSED1644",1644 },
    { "ER_UNUSED1645",1645 },
    { "ER_UNUSED1646",1646 },
    { "ER_UNUSED1647",1647 },
    { "ER_UNUSED1648",1648 },
    { "ER_UNUSED1649",1649 },
    { "ER_UNUSED1650",1650 },
    { "ER_UNUSED1651",1651 },
    { "ER_UNUSED1652",1652 },
    { "ER_UNUSED1653",1653 },
    { "ER_UNUSED1654",1654 },
    { "ER_UNUSED1655",1655 },
    { "ER_UNUSED1656",1656 },
    { "ER_UNUSED1657",1657 },
    { "ER_UNUSED1658",1658 },
    { "ER_UNUSED1659",1659 },
    { "ER_UNUSED1660",1660 },
    { "ER_UNUSED1661",1661 },
    { "ER_UNUSED1662",1662 },
    { "ER_UNUSED1663",1663 },
    { "ER_UNUSED1664",1664 },
    { "ER_UNUSED1665",1665 },
    { "ER_UNUSED1666",1666 },
    { "ER_UNUSED1667",1667 },
    { "ER_UNUSED1668",1668 },
    { "ER_UNUSED1669",1669 },
    { "ER_UNUSED1670",1670 },
    { "ER_UNUSED1671",1671 },
    { "ER_UNUSED1672",1672 },
    { "ER_UNUSED1673",1673 },
    { "ER_UNUSED1674",1674 },
    { "ER_UNUSED1675",1675 },
    { "ER_UNUSED1676",1676 },
    { "ER_UNUSED1677",1677 },
    { "ER_UNUSED1678",1678 },
    { "ER_UNUSED1679",1679 },
    { "ER_UNUSED1680",1680 },
    { "ER_UNUSED1681",1681 },
    { "ER_UNUSED1682",1682 },
    { "ER_UNUSED1683",1683 },
    { "ER_UNUSED1684",1684 },
    { "ER_INVALID_UNIX_TIMESTAMP_VALUE",1685 },
    { "ER_INVALID_DATETIME_VALUE",1686 },
    { "ER_INVALID_NULL_ARGUMENT",1687 },
    { "ER_UNUSED1688",1688 },
    { "ER_ARGUMENT_OUT_OF_RANGE",1689 },
    { "ER_UNUSED1690",1690 },
    { "ER_INVALID_ENUM_VALUE",1691 },
    { "ER_NO_PRIMARY_KEY_ON_REPLICATED_TABLE", 1692},
    { "ER_CORRUPT_TABLE_DEFINITION", 1693},
    { "ER_SCHEMA_DOES_NOT_EXIST", 1694},
    { "ER_ALTER_SCHEMA", 1695},
    { "ER_DROP_SCHEMA", 1696},
    { "ER_USE_SQL_BIG_RESULT", 1697},
    { "ER_UNKNOWN_ENGINE_OPTION", 1698},
    { "ER_UNKNOWN_SCHEMA_OPTION", 1699},
    { "ER_EVENT_OBSERVER_PLUGIN", 1700},
    { "ER_CORRUPT_SCHEMA_DEFINITION", 1701},
    { "ER_UNUSED1702", 1702},
    { 0, 0 }
  };

  for (struct st_error *e=st_error_names;e->name;e++)
  {
    error_code_map.insert(pair<string, uint32_t>(e->name,e->code));
  }
}

uint32_t ErrorCodes::getErrorCode(const string &error_msg)
{
  return error_code_map[error_msg];
}
