// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=function, header=GenericFunction.h)
%feature("docstring")  dolfin::GenericFunction "
This is a common base class for functions. Functions can be
evaluated at a given point and they can be restricted to a given
cell in a finite element mesh. This functionality is implemented
by sub-classes that implement the eval() and restrict() functions.

DOLFIN provides two implementations of the GenericFunction
interface in the form of the classes Function and Expression.

Sub-classes may optionally implement the gather() function that
will be called prior to restriction when running in parallel.
";

%feature("docstring")  dolfin::GenericFunction::GenericFunction "
Constructor
";

%feature("docstring")  dolfin::GenericFunction::value_rank "
Return value rank
";

%feature("docstring")  dolfin::GenericFunction::value_dimension "
Return value dimension for given axis
";

%feature("docstring")  dolfin::GenericFunction::eval "
**Overloaded versions**

* eval\ **(values, x, cell)**

  Evaluate at given point in given cell

* eval\ **(values, x)**

  Evaluate at given point
";

%feature("docstring")  dolfin::GenericFunction::restrict "
Restrict function to local cell (compute expansion coefficients w)
";

%feature("docstring")  dolfin::GenericFunction::compute_vertex_values "
Compute values at all mesh vertices
";

%feature("docstring")  dolfin::GenericFunction::gather "
Collect off-process coefficients to prepare for interpolation
";

%feature("docstring")  dolfin::GenericFunction::operator "
**Overloaded versions**

* operator\ **(x)**

  Evaluation at given point (scalar function)

* operator\ **(x, y)**

  Evaluation at given point (scalar function)

* operator\ **(x, y, z)**

  Evaluation at given point (scalar function)

* operator\ **(p)**

  Evaluation at given point (scalar function)

* operator\ **(values, x)**

  Evaluation at given point (vector-valued function)

* operator\ **(values, x, y)**

  Evaluation at given point (vector-valued function)

* operator\ **(values, x, y, z)**

  Evaluation at given point (vector-valued function)

* operator\ **(values, p)**

  Evaluation at given point (vector-valued function)
";

%feature("docstring")  dolfin::GenericFunction::value_size "
Evaluation at given point
Return value size (product of value dimensions)
";

%feature("docstring")  dolfin::GenericFunction::evaluate "
Evaluate function at given point in cell
";

// Documentation extracted from: (module=function, header=Expression.h)
%feature("docstring")  dolfin::Expression "
This class represents a user-defined expression. Expressions can
be used as coefficients in variational forms or interpolated
into finite element spaces.

An expression is defined by overloading the eval() method. Users
may choose to overload either a simple version of eval(), in the
case of expressions only depending on the coordinate x, or an
optional version for expressions depending on x and mesh data
like cell indices or facet normals.

The geometric dimension (the size of x) and the value rank and
dimensions of an expression must supplied as arguments to the
constructor.
";

%feature("docstring")  dolfin::Expression::Expression "
**Overloaded versions**

* Expression\ **()**

  Create scalar expression

* Expression\ **(dim)**

  Create vector-valued expression with given dimension

* Expression\ **(dim0, dim1)**

  Create matrix-valued expression with given dimensions

* Expression\ **(value_shape)**

  Create tensor-valued expression with given shape

* Expression\ **(expression)**

  Copy constructor
";

%feature("docstring")  dolfin::Expression::eval "
**Overloaded versions**

* eval\ **(values, x, cell)**

  Note: The reimplementation of eval is needed for the Python interface
  Evaluate at given point in given cell

* eval\ **(values, x)**

  Evaluate at given point
";

%feature("docstring")  dolfin::Expression::value_rank "
Return value rank
";

%feature("docstring")  dolfin::Expression::value_dimension "
Return value dimension for given axis
";

%feature("docstring")  dolfin::Expression::restrict "
Restrict function to local cell (compute expansion coefficients w)
";

%feature("docstring")  dolfin::Expression::compute_vertex_values "
Compute values at all mesh vertices
";

// Documentation extracted from: (module=function, header=Function.h)
%feature("docstring")  dolfin::Function "
This class represents a function u_h in a finite element
function space V_h, given by

  u_h = sum_i U_i phi_i

where {phi_i}_i is a basis for V_h, and U is a vector of
expansion coefficients for u_h.
";

%feature("docstring")  dolfin::Function::Function "
**Overloaded versions**

* Function\ **(V)**

  Create function on given function space

* Function\ **(V)**

  Create function on given function space (shared data)

* Function\ **(V, x)**

  Create function on given function space with a given vector

* Function\ **(V, x)**

  Create function on given function space with a given vector
  (shared data)

* Function\ **(V, x)**

  Create function on given function space with a given vector (used by
  Python interface)

* Function\ **(V, filename)**

  Create function from vector of dofs stored to file

* Function\ **(V, filename)**

  Create function from vector of dofs stored to file (shared data)

* Function\ **(v)**

  Copy constructor

* Function\ **(v, i)**

  Sub-function constructor with shallow copy of vector (used in Python
  interface)
";

%feature("docstring")  dolfin::Function::operator= "
**Overloaded versions**

* operator=\ **(v)**

  Assignment from function

* operator=\ **(v)**

  Assignment from expression using interpolation
";

%feature("docstring")  dolfin::Function::operator[] "
Extract sub-function
";

%feature("docstring")  dolfin::Function::function_space "
Return function space
";

%feature("docstring")  dolfin::Function::function_space_ptr "
Return shared pointer to function space
";

%feature("docstring")  dolfin::Function::vector "
**Overloaded versions**

* vector\ **()**

  Return vector of expansion coefficients (non-const version)

* vector\ **()**

  Return vector of expansion coefficients (const version)
";

%feature("docstring")  dolfin::Function::in "
Check if function is a member of the given function space
";

%feature("docstring")  dolfin::Function::geometric_dimension "
Return geometric dimension
";

%feature("docstring")  dolfin::Function::eval "
**Overloaded versions**

* eval\ **(values, x)**

  Evaluate function for given coordinate

* eval\ **(values, x, dolfin_cell, ufc_cell)**

  Evaluate function for given coordinate in given cell

* eval\ **(values, x, cell)**

  Evaluate function for given data
";

%feature("docstring")  dolfin::Function::interpolate "
Interpolate function (possibly non-matching meshes)
";

%feature("docstring")  dolfin::Function::extrapolate "
Extrapolate function (from a possibly lower-degree function space)
";

%feature("docstring")  dolfin::Function::value_rank "
Return value rank
";

%feature("docstring")  dolfin::Function::value_dimension "
Return value dimension for given axis
";

%feature("docstring")  dolfin::Function::non_matching_eval "
Evaluate function for given data
";

%feature("docstring")  dolfin::Function::restrict "
Restrict function to local cell (compute expansion coefficients w)
";

%feature("docstring")  dolfin::Function::compute_vertex_values "
Compute values at all mesh vertices
";

%feature("docstring")  dolfin::Function::gather "
Collect off-process coefficients to prepare for interpolation
";

// Documentation extracted from: (module=function, header=FunctionSpace.h)
%feature("docstring")  dolfin::FunctionSpace "
This class represents a finite element function space defined by
a mesh, a finite element, and a local-to-global mapping of the
degrees of freedom (dofmap).
";

%feature("docstring")  dolfin::FunctionSpace::FunctionSpace "
**Overloaded versions**

* FunctionSpace\ **(mesh, element, dofmap)**

  Create function space for given mesh, element and dofmap (shared data)

* FunctionSpace\ **(mesh)**

  Create empty function space for later initialization. This
  constructor is intended for use by any sub-classes which need
  to construct objects before the initialisation of the base
  class. Data can be attached to the base class using
  FunctionSpace::attach(...).

* FunctionSpace\ **(V)**

  Copy constructor
";

%feature("docstring")  dolfin::FunctionSpace::attach "
Attach data to an empty FunctionSpace
";

%feature("docstring")  dolfin::FunctionSpace::operator= "
Assignment operator
";

%feature("docstring")  dolfin::FunctionSpace::mesh "
Return mesh
";

%feature("docstring")  dolfin::FunctionSpace::element "
Return finite element
";

%feature("docstring")  dolfin::FunctionSpace::dofmap "
Return dofmap
";

%feature("docstring")  dolfin::FunctionSpace::dim "
Return dimension of function space
";

%feature("docstring")  dolfin::FunctionSpace::interpolate "
Interpolate function v into function space, returning the vector of
expansion coefficients
";

%feature("docstring")  dolfin::FunctionSpace::operator[] "
Extract sub space for component
";

%feature("docstring")  dolfin::FunctionSpace::extract_sub_space "
Extract sub space for component
";

%feature("docstring")  dolfin::FunctionSpace::collapse "
Collapse a subspace and return a new function space and a map from new
to old dofs
";

%feature("docstring")  dolfin::FunctionSpace::has_cell "
Check if function space has given cell
";

%feature("docstring")  dolfin::FunctionSpace::has_element "
Check if function space has given element
";

%feature("docstring")  dolfin::FunctionSpace::component "
Return component (relative to super space)
";

%feature("docstring")  dolfin::FunctionSpace::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::FunctionSpace::print_dofmap "
Print dofmap (useful for debugging)
";

// Documentation extracted from: (module=function, header=SubSpace.h)
%feature("docstring")  dolfin::SubSpace "
This class represents a subspace (component) of a function space.

The subspace is specified by an array of indices. For example,
the array [3, 0, 2] specifies subspace 2 of subspace 0 of
subspace 3.

A typical example is the function space W = V x P for Stokes.
Here, V = W[0] is the subspace for the velocity component and
P = W[1] is the subspace for the pressure component. Furthermore,
W[0][0] = V[0] is the first component of the velocity space etc.
";

%feature("docstring")  dolfin::SubSpace::SubSpace "
**Overloaded versions**

* SubSpace\ **(V, component)**

  Create subspace for given component (one level)

* SubSpace\ **(V, component, sub_component)**

  Create subspace for given component (two levels)

* SubSpace\ **(V, component)**

  Create subspace for given component (n levels)
";

// Documentation extracted from: (module=function, header=Constant.h)
%feature("docstring")  dolfin::Constant "
This class represents a constant-valued expression.
";

%feature("docstring")  dolfin::Constant::Constant "
**Overloaded versions**

* Constant\ **(value)**

  Create scalar constant

* Constant\ **(value0, value1)**

  Create vector constant (dim = 2)

* Constant\ **(value0, value1, value2)**

  Create vector constant (dim = 3)

* Constant\ **(values)**

  Create vector-valued constant

* Constant\ **(value_shape, values)**

  Create tensor-valued constant for flattened array of values

* Constant\ **(constant)**

  Copy constructor
";

%feature("docstring")  dolfin::Constant::operator= "
**Overloaded versions**

* operator=\ **(constant)**

  Assignment operator

* operator=\ **(constant)**

  Assignment operator
";

%feature("docstring")  dolfin::Constant::operator double "
Cast to double (for scalar constants)
";

// Documentation extracted from: (module=function, header=SpecialFunctions.h)
%feature("docstring")  dolfin::MeshCoordinates "
This Function represents the mesh coordinates on a given mesh.
";

%feature("docstring")  dolfin::MeshCoordinates::MeshCoordinates "
Constructor
";

%feature("docstring")  dolfin::MeshCoordinates::eval "
Evaluate function
";

%feature("docstring")  dolfin::CellSize "
This Function represents the local cell size on a given mesh.
";

%feature("docstring")  dolfin::CellSize::CellSize "
Constructor
";

%feature("docstring")  dolfin::CellSize::eval "
Evaluate function
";

%feature("docstring")  dolfin::FacetArea "
This function represents the area/length of a cell facet on a given mesh.
";

%feature("docstring")  dolfin::FacetArea::FacetArea "
Constructor
";

%feature("docstring")  dolfin::FacetArea::eval "
Evaluate function
";

// Documentation extracted from: (module=plot, header=plot.h)
%feature("docstring")  dolfin::plot "
**Overloaded versions**

* plot\ **(v, title=\"Function\", mode=\"auto\")**

  Simple built-in plot commands for plotting functions and meshes.
  For plotting to work, PyDOLFIN and Viper must be installed.
  Plot function

* plot\ **(v, mesh, title=\"Expression\", mode=\"auto\")**

  Plot function

* plot\ **(mesh, title=\"Mesh\")**

  Plot mesh

* plot\ **(f, MeshFunction<uint>\")**

  Plot mesh function

* plot\ **(f, title=\"MeshFunction<double>\")**

  Plot mesh function

* plot\ **(f, title=\"MeshFunction<bool>\")**

  Plot mesh function
";

// Documentation extracted from: (module=plot, header=FunctionPlotData.h)
%feature("docstring")  dolfin::FunctionPlotData "
This class is used for communicating plot data for functions
to and from (XML) files. It is used by DOLFIN for plotting
Function objects. The data is stored as a mesh and a vector
of interpolated vertex values.
";

%feature("docstring")  dolfin::FunctionPlotData::FunctionPlotData "
**Overloaded versions**

* FunctionPlotData\ **(v, mesh)**

  Create plot data for given function

* FunctionPlotData\ **()**

  Create empty data to be read from file
";

%feature("docstring")  dolfin::FunctionPlotData::vertex_values "
Return vertex values
";

// Documentation extracted from: (module=nls, header=NonlinearProblem.h)
%feature("docstring")  dolfin::NonlinearProblem "
This is a base class for nonlinear problems which can return the
nonlinear function F(u) and its Jacobian J = dF(u)/du.
";

%feature("docstring")  dolfin::NonlinearProblem::NonlinearProblem "
Constructor
";

%feature("docstring")  dolfin::NonlinearProblem::form "
Function called by Newton solver before requesting F or J.
This can be used to compute F and J together
";

%feature("docstring")  dolfin::NonlinearProblem::F "
Compute F at current point x
";

%feature("docstring")  dolfin::NonlinearProblem::J "
Compute J = F' at current point x
";

// Documentation extracted from: (module=nls, header=NewtonSolver.h)
%feature("docstring")  dolfin::NewtonSolver "
This class defines a Newton solver for equations of the form F(u) = 0.
";

%feature("docstring")  dolfin::NewtonSolver::NewtonSolver "
**Overloaded versions**

* NewtonSolver\ **(\"lu\", \"default\")**

  Create nonlinear solver with default linear solver and default
  linear algebra backend

* NewtonSolver\ **(solver, factory)**

  Create nonlinear solver using provided linear solver and linear algebra
  backend determined by factory
";

%feature("docstring")  dolfin::NewtonSolver::solve "
Solve abstract nonlinear problem F(x) = 0 for given vector F and
Jacobian dF/dx
";

%feature("docstring")  dolfin::NewtonSolver::iteration "
Return Newton iteration number
";

%feature("docstring")  dolfin::NewtonSolver::residual "
Return current residual
";

%feature("docstring")  dolfin::NewtonSolver::relative_residual "
Return current relative residual
";

%feature("docstring")  dolfin::NewtonSolver::linear_solver "
Return the linear solver
";

%feature("docstring")  dolfin::NewtonSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::NewtonSolver::converged "
Convergence test
";

// Documentation extracted from: (module=fem, header=GenericDofMap.h)
%feature("docstring")  dolfin::GenericDofMap "
This class provides a generic interface for dof maps
";

%feature("docstring")  dolfin::GenericDofMap::is_view "
True if dof map is a view into another map (is a sub-dofmap)
";

%feature("docstring")  dolfin::GenericDofMap::needs_mesh_entities "
Return true iff mesh entities of topological dimension d are needed
";

%feature("docstring")  dolfin::GenericDofMap::global_dimension "
Return the dimension of the global finite element function space
";

%feature("docstring")  dolfin::GenericDofMap::cell_dimension "
Return the dimension of the local finite element function space on a
cell
";

%feature("docstring")  dolfin::GenericDofMap::max_cell_dimension "
Return the maximum dimension of the local finite element function space
";

%feature("docstring")  dolfin::GenericDofMap::num_facet_dofs "
Return number of facet dofs
";

%feature("docstring")  dolfin::GenericDofMap::ownership_range "
Return the ownership range (dofs in this range are owned by this process)
";

%feature("docstring")  dolfin::GenericDofMap::off_process_owner "
Return map from nonlocal-dofs (that appear in local dof map) to owning process
";

%feature("docstring")  dolfin::GenericDofMap::cell_dofs "
Local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_dofs "
Tabulate the local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_facet_dofs "
Tabulate local-local facet dofs
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_coordinates "
**Overloaded versions**

* tabulate_coordinates\ **(coordinates, ufc_cell)**

  Tabulate the coordinates of all dofs on a cell (UFC cell version)

* tabulate_coordinates\ **(coordinates, cell)**

  Tabulate the coordinates of all dofs on a cell (DOLFIN cell version)
";

%feature("docstring")  dolfin::GenericDofMap::copy "
Create a copy of the dof map
";

%feature("docstring")  dolfin::GenericDofMap::extract_sub_dofmap "
Extract sub dofmap component
";

%feature("docstring")  dolfin::GenericDofMap::collapse "
Create a \"collapsed\" a dofmap (collapses from a sub-dofmap view)
";

%feature("docstring")  dolfin::GenericDofMap::dofs "
Return the set of dof indices
";

%feature("docstring")  dolfin::GenericDofMap::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=fem, header=DofMap.h)
%feature("docstring")  dolfin::DofMap "
This class handles the mapping of degrees of freedom. It builds
a dof map based on a ufc::dofmap on a specific mesh. It will
reorder the dofs when running in parallel. Sub-dofmaps, both
views and copies, are supported.
";

%feature("docstring")  dolfin::DofMap::DofMap "
**Overloaded versions**

* DofMap\ **(ufc_dofmap, mesh)**

  Create dof map on mesh (data is not shared)

* DofMap\ **(ufc_dofmap, mesh)**

  Create dof map on mesh ((data is not shared), const mesh version)

* DofMap\ **(dofmap)**

  Copy constructor

* DofMap\ **(parent_dofmap, component, mesh, distributed)**

  Create a sub-dofmap (a view) from parent_dofmap

* DofMap\ **(boost::unordered_map<uint, collapsed_map, dofmap_view, mesh, distributed)**

  Create a collapsed dofmap from parent_dofmap
";

%feature("docstring")  dolfin::DofMap::is_view "
True if dof map is a view into another map (is a sub-dofmap)
";

%feature("docstring")  dolfin::DofMap::needs_mesh_entities "
Return true iff mesh entities of topological dimension d are needed
";

%feature("docstring")  dolfin::DofMap::global_dimension "
Return the dimension of the global finite element function space
";

%feature("docstring")  dolfin::DofMap::max_cell_dimension "
Return the maximum dimension of the local finite element function space
";

%feature("docstring")  dolfin::DofMap::num_facet_dofs "
Return number of facet dofs
";

%feature("docstring")  dolfin::DofMap::ownership_range "
Return the ownership range (dofs in this range are owned by this process)
";

%feature("docstring")  dolfin::DofMap::off_process_owner "
Return map from nonlocal-dofs that appear in local dof map to owning
process
";

%feature("docstring")  dolfin::DofMap::cell_dofs "
Local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::DofMap::tabulate_dofs "
Tabulate the local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::DofMap::tabulate_facet_dofs "
Tabulate local-local facet dofs
";

%feature("docstring")  dolfin::DofMap::tabulate_coordinates "
**Overloaded versions**

* tabulate_coordinates\ **(coordinates, ufc_cell)**

  Tabulate the coordinates of all dofs on a cell (UFC cell version)

* tabulate_coordinates\ **(coordinates, cell)**

  Tabulate the coordinates of all dofs on a cell (DOLFIN cell version)
";

%feature("docstring")  dolfin::DofMap::copy "
Create a copy of the dof map
";

%feature("docstring")  dolfin::DofMap::extract_sub_dofmap "
Extract sub dofmap component
";

%feature("docstring")  dolfin::DofMap::collapse "
Create a \"collapsed\" dofmap (collapses a sub-dofmap)
";

%feature("docstring")  dolfin::DofMap::dofs "
Return the set of dof indices
";

%feature("docstring")  dolfin::DofMap::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=fem, header=FiniteElement.h)
%feature("docstring")  dolfin::FiniteElement "
This is a wrapper for a UFC finite element (ufc::finite_element).
";

%feature("docstring")  dolfin::FiniteElement::FiniteElement "
Create finite element from UFC finite element (data may be shared)
";

%feature("docstring")  dolfin::FiniteElement::signature "
Return a string identifying the finite element
";

%feature("docstring")  dolfin::FiniteElement::cell_shape "
Return the cell shape
";

%feature("docstring")  dolfin::FiniteElement::space_dimension "
Return the dimension of the finite element function space
";

%feature("docstring")  dolfin::FiniteElement::value_rank "
Return the rank of the value space
";

%feature("docstring")  dolfin::FiniteElement::value_dimension "
Return the dimension of the value space for axis i
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis "
**Overloaded versions**

* evaluate_basis\ **(i, values, x, cell)**

  Evaluate basis function i at given point in cell

* evaluate_basis\ **(i, values, x, cell)**

  Evaluate basis function i at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_all "
Evaluate all basis functions at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_derivatives "
Evaluate order n derivatives of basis function i at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_derivatives_all "
Evaluate order n derivatives of all basis functions at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_dof "
Evaluate linear functional for dof i on the function f
";

%feature("docstring")  dolfin::FiniteElement::evaluate_dofs "
Evaluate linear functionals for all dofs on the function f
";

%feature("docstring")  dolfin::FiniteElement::interpolate_vertex_values "
Interpolate vertex values from dof values
";

%feature("docstring")  dolfin::FiniteElement::map_from_reference_cell "
Map coordinate xhat from reference cell to coordinate x in cell
";

%feature("docstring")  dolfin::FiniteElement::map_to_reference_cell "
Map from coordinate x in cell to coordinate xhat in reference cell
";

%feature("docstring")  dolfin::FiniteElement::num_sub_elements "
Return the number of sub elements (for a mixed element)
";

%feature("docstring")  dolfin::FiniteElement::hash "
Return simple hash of the signature string
";

%feature("docstring")  dolfin::FiniteElement::create_sub_element "
Create a new finite element for sub element i (for a mixed element)
";

%feature("docstring")  dolfin::FiniteElement::create "
Create a new class instance
";

%feature("docstring")  dolfin::FiniteElement::extract_sub_element "
Extract sub finite element for component
";

// Documentation extracted from: (module=fem, header=BasisFunction.h)
%feature("docstring")  dolfin::BasisFunction "
This class represents a finite element basis function. It can be
used for computation of basis function values and derivatives.

Evaluation of basis functions is also possible through the use
of the functions evaluate_basis and evaluate_basis_derivatives
available in the FiniteElement class. The BasisFunction class
relies on these functions for evaluation but also implements the
ufc::function interface which allows evaluate_dof to be
evaluated for a basis function (on a possibly different
element).
";

%feature("docstring")  dolfin::BasisFunction::BasisFunction "
Create basis function with given index on element on given cell
";

%feature("docstring")  dolfin::BasisFunction::eval "
Evaluate basis function at given point
";

%feature("docstring")  dolfin::BasisFunction::eval_derivatives "
Evaluate all order n derivatives at given point
";

%feature("docstring")  dolfin::BasisFunction::evaluate "
Evaluate function at given point in cell
";

// Documentation extracted from: (module=fem, header=BoundaryCondition.h)
%feature("docstring")  dolfin::BoundaryCondition "
Common base class for boundary conditions
";

%feature("docstring")  dolfin::BoundaryCondition::BoundaryCondition "
**Overloaded versions**

* BoundaryCondition\ **(V)**

  Constructor

* BoundaryCondition\ **(V)**

  Constructor
";

%feature("docstring")  dolfin::BoundaryCondition::apply "
**Overloaded versions**

* apply\ **(A)**

  Apply boundary condition to a matrix

* apply\ **(b)**

  Apply boundary condition to a vector

* apply\ **(A, b)**

  Apply boundary condition to a linear system

* apply\ **(b, x)**

  Apply boundary condition to a vector for a nonlinear problem

* apply\ **(A, b, x)**

  Apply boundary condition to a linear system for a nonlinear problem
";

%feature("docstring")  dolfin::BoundaryCondition::function_space "
Return function space
";

%feature("docstring")  dolfin::BoundaryCondition::function_space_ptr "
Return shared pointer to function space
";

// Documentation extracted from: (module=fem, header=DirichletBC.h)
%feature("docstring")  dolfin::DirichletBC "
This class specifies the interface for setting (strong)
Dirichlet boundary conditions for partial differential
equations,

   u = g on G,

where u is the solution to be computed, g is a function
and G is a sub domain of the mesh.

A DirichletBC is specified by the function g, the function space
(trial space) and boundary indicators on (a subset of) the mesh
boundary.

The boundary indicators may be specified in a number of
different ways.

The simplest approach is to specify the boundary by a SubDomain
object, using the inside() function to specify on which facets
the boundary conditions should be applied.

Alternatively, the boundary may be specified by a MeshFunction
labeling all mesh facets together with a number that specifies
which facets should be included in the boundary.

The third option is to attach the boundary information to the
mesh. This is handled automatically when exporting a mesh from
for example VMTK.

The BCMethod variable may be used to specify the type of method
used to identify degrees of freedom on the boundary. Available
methods are: topological approach (default), geometric approach,
and pointwise approach. The topological approach is faster, but
will only identify degrees of freedom that are located on a
facet that is entirely on the boundary. In particular, the
topological approach will not identify degrees of freedom for
discontinuous elements (which are all internal to the cell).  A
remedy for this is to use the geometric approach. To apply
pointwise boundary conditions e.g. pointloads, one will have to
use the pointwise approach which in turn is the slowest of the
three possible methods.  The three possibilties are
\"topological\", \"geometric\" and \"pointwise\".
This class specifies the interface for setting (strong)
";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "
**Overloaded versions**

* DirichletBC\ **(V, g, sub_domain, method=\"topological\")**

  Create boundary condition for subdomain

* DirichletBC\ **(V, g, sub_domain, method=\"topological\")**

  Create boundary condition for subdomain

* DirichletBC\ **(V, g, sub_domains, sub_domain, method=\"topological\")**

  Create boundary condition for subdomain specified by index

* DirichletBC\ **(V, g, sub_domains, sub_domain, method=\"topological\")**

  Create boundary condition for subdomain specified by index

* DirichletBC\ **(V, g, sub_domain, method=\"topological\")**

  Create boundary condition for boundary data included in the mesh

* DirichletBC\ **(V, g, sub_domain, method=\"topological\")**

  Create boundary condition for boundary data included in the mesh

* DirichletBC\ **(V, g, std::vector<std::pair<uint, markers, method=\"topological\")**

  Create boundary condition for subdomain by boundary markers
  (cells, local facet numbers)

* DirichletBC\ **(V, g, std::vector<std::pair<uint, markers, method=\"topological\")**

  Create boundary condition for subdomain by boundary markers
  (cells, local facet numbers)

* DirichletBC\ **(bc)**

  Copy constructor
";

%feature("docstring")  dolfin::DirichletBC::operator= "
Assignment operator
";

%feature("docstring")  dolfin::DirichletBC::apply "
**Overloaded versions**

* apply\ **(A)**

  Apply boundary condition to a matrix

* apply\ **(b)**

  Apply boundary condition to a vector

* apply\ **(A, b)**

  Apply boundary condition to a linear system

* apply\ **(b, x)**

  Apply boundary condition to a vector for a nonlinear problem

* apply\ **(A, b, x)**

  Apply boundary condition to a linear system for a nonlinear problem
";

%feature("docstring")  dolfin::DirichletBC::get_boundary_values "
Get Dirichlet dofs and values
";

%feature("docstring")  dolfin::DirichletBC::zero "
Make row associated with boundary conditions zero, useful for
non-diagonal matrices in a block matrix.
";

%feature("docstring")  dolfin::DirichletBC::zero_columns "
Make columns associated with boundary conditions zero, and
update the RHS to reflect the changes. Useful for non-diagonals.
The diag_val parameter would normally be -1, 0 or 1.
";

%feature("docstring")  dolfin::DirichletBC::markers "
Return boundary markers (facets stored as pairs of cells and local
facet numbers)
";

%feature("docstring")  dolfin::DirichletBC::value "
Return boundary value g
";

%feature("docstring")  dolfin::DirichletBC::value_ptr "
Return shared pointer to boundary value g
Testing multiline comment
";

%feature("docstring")  dolfin::DirichletBC::user_sub_domain_ptr "
Return shared pointer to sub-domain
";

%feature("docstring")  dolfin::DirichletBC::is_compatible "
Check if given function is compatible with boundary condition
(checking only vertex values)
";

%feature("docstring")  dolfin::DirichletBC::set_value "
**Overloaded versions**

* set_value\ **(g)**

  Set value g for boundary condition, domain remains unchanged

* set_value\ **(g)**

  Set value g for boundary condition, domain remains unchanged
";

%feature("docstring")  dolfin::DirichletBC::homogenize "
Set value to 0.0
";

%feature("docstring")  dolfin::DirichletBC::method "
Return method used for computing Dirichet dofs (\"topological\",
\"geometric\" or \"pointwise\")
";

%feature("docstring")  dolfin::DirichletBC::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=PeriodicBC.h)
%feature("docstring")  dolfin::PeriodicBC "
This class specifies the interface for setting periodic boundary
conditions for partial differential equations,

   u(x) = u(F^{-1}(x)) on G,
   u(x) = u(F(x))      on H,

where F : H --> G is a map from a subdomain H to a subdomain G.

A periodic boundary condition must be defined by the domain G
and the map F pulling coordinates back from H to G. The domain
and the map are both defined by a subclass of SubDomain which
must overload both the inside() function, which specifies the
points of G, and the map() function, which specifies the map
from the points of H to the points of G.

The implementation is based on matching degrees of freedom on G
with degrees of freedom on H and only works when the mapping F
is bijective between the sets of coordinates associated with the
two domains. In other words, the nodes (degrees of freedom) must
be aligned on G and H.

The matching of degrees of freedom is done at the construction
of the periodic boundary condition and is reused on subsequent
applications to a linear system. The matching may be recomputed
by calling the rebuild() function.
";

%feature("docstring")  dolfin::PeriodicBC::PeriodicBC "
**Overloaded versions**

* PeriodicBC\ **(V, sub_domain)**

  Create periodic boundary condition for sub domain

* PeriodicBC\ **(V, sub_domain)**

  Create periodic boundary condition for sub domain
";

%feature("docstring")  dolfin::PeriodicBC::apply "
**Overloaded versions**

* apply\ **(A)**

  Apply boundary condition to a matrix

* apply\ **(b)**

  Apply boundary condition to a vector

* apply\ **(A, b)**

  Apply boundary condition to a linear system

* apply\ **(b, x)**

  Apply boundary condition to a vector for a nonlinear problem

* apply\ **(A, b, x)**

  Apply boundary condition to a linear system for a nonlinear problem
";

%feature("docstring")  dolfin::PeriodicBC::rebuild "
Rebuild mapping between dofs
";

// Documentation extracted from: (module=fem, header=EqualityBC.h)
%feature("docstring")  dolfin::EqualityBC "
This class specifies the interface for setting equality boundary
conditions for partial differential equations,

   u(x) = u(y),    for all x and y on G,

where G is subdomain of the mesh.

The sub domain G may be specified in two different ways. Both of
them produce a set of unknowns (dofs) with should be equal.

The simplest approach is to specify a SubDomain object, using
the inside() function to specify on which facets the boundary
condition should be applied.

Alternatively, the boundary may be specified by the boundary
indicators included in the mesh.

Current implementation assume that the problem is scalar,
so in case of mixed systems (vector-valued and mixed elements)
all compoments will be set equal.
";

// Documentation extracted from: (module=fem, header=PointSource.h)
%feature("docstring")  dolfin::PointSource "
This class provides an easy mechanism for adding a point source
(Dirac delta function) to the right-hand side vector in a
variational problem. The associated function space must be
scalar in order for the inner product with the (scalar) Dirac
delta function to be well defined.
";

%feature("docstring")  dolfin::PointSource::PointSource "
**Overloaded versions**

* PointSource\ **(V, p, magnitude=1.0)**

  Create point source at given point of given magnitude

* PointSource\ **(V, p, magnitude=1.0)**

  Create point source at given point of given magnitude
";

%feature("docstring")  dolfin::PointSource::apply "
Apply (add) point source to right-hand side vector
";

// Documentation extracted from: (module=fem, header=assemble.h)
%feature("docstring")  dolfin::assemble "
**Overloaded versions**

* assemble\ **(A, a, reset_sparsity=true, add_values=false)**

  Assemble tensor

* assemble\ **(A, a, sub_domain, reset_sparsity=true, add_values=false)**

  Assemble tensor on sub domain

* assemble\ **(A, a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false)**

  Assemble tensor on sub domains

* assemble\ **(a, reset_sparsity=true, add_values=false)**

  Assemble scalar

* assemble\ **(a, sub_domain, reset_sparsity=true, add_values=false)**

  Assemble scalar on sub domain

* assemble\ **(a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false)**

  Assemble scalar on sub domains
";

%feature("docstring")  dolfin::assemble_system "
**Overloaded versions**

* assemble_system\ **(A, b, a, L, reset_sparsities=true, add_values=false)**

  Assemble system (A, b)

* assemble_system\ **(A, b, a, L, bc, reset_sparsities=true, add_values=false)**

  Assemble system (A, b) and apply Dirichlet boundary condition

* assemble_system\ **(A, b, a, L, bcs, reset_sparsities=true, add_values=false)**

  Assemble system (A, b) and apply Dirichlet boundary conditions

* assemble_system\ **(A, b, a, L, bcs, cell_domains, exterior_facet_domains, interior_facet_domains, x0, reset_sparsities=true, add_values=false)**

  Assemble system (A, b) on sub domains and apply Dirichlet boundary conditions
";

// Documentation extracted from: (module=fem, header=Form.h)
%feature("docstring")  dolfin::Form "
A note on the order of trial and test spaces: FEniCS numbers
argument spaces starting with the leading dimension of the
corresponding tensor (matrix). In other words, the test space is
numbered 0 and the trial space is numbered 1. However, in order
to have a notation that agrees with most existing finite element
literature, the spaces are numbered from right to left:

   a : V_1 x V_0 --> R
   a |--> a(u, v)

This is reflected in the ordering of the spaces that should be
supplied to generated subclasses. In particular, when a bilinear
form is initialized, it should be initialized as

   a(V1, V0)

where V1 is the trial space and V0 is the test space. However,
when a form is initialized by a list of argument spaces (the
variable 'function_spaces' in the constructors below, the list
of spaces should start with space number 0 (the test space) and
then space number 1 (the trial space).
";

%feature("docstring")  dolfin::Form::Form "
**Overloaded versions**

* Form\ **(rank, num_coefficients)**

  Create form of given rank with given number of coefficients

* Form\ **(ufc_form, function_spaces, coefficients)**

  Create form (shared data)
";

%feature("docstring")  dolfin::Form::rank "
Return rank of form (bilinear form = 2, linear form = 1,
functional = 0, etc)
";

%feature("docstring")  dolfin::Form::num_coefficients "
Return number of coefficients
";

%feature("docstring")  dolfin::Form::set_mesh "
Set mesh, necessary for functionals when there are no function spaces
";

%feature("docstring")  dolfin::Form::mesh "
Extract common mesh from form
";

%feature("docstring")  dolfin::Form::mesh_shared_ptr "
Return mesh shared pointer (if any)
";

%feature("docstring")  dolfin::Form::function_space "
Return function space for given argument
";

%feature("docstring")  dolfin::Form::function_spaces "
Return function spaces for arguments
";

%feature("docstring")  dolfin::Form::set_coefficient "
**Overloaded versions**

* set_coefficient\ **(i, coefficient)**

  Set coefficient with given number (shared pointer version)

* set_coefficient\ **(name, coefficient)**

  Set coefficient with given name (shared pointer version)
";

%feature("docstring")  dolfin::Form::set_coefficients "
Set all coefficients in given map, possibly a subset
(shared pointer version)
";

%feature("docstring")  dolfin::Form::coefficient "
**Overloaded versions**

* coefficient\ **(i)**

  Return coefficient with given number

* coefficient\ **(name)**

  Return coefficient with given name
";

%feature("docstring")  dolfin::Form::coefficients "
Return all coefficients
";

%feature("docstring")  dolfin::Form::coefficient_number "
Return the number of the coefficient with this name
";

%feature("docstring")  dolfin::Form::coefficient_name "
Return the name of the coefficient with this number
";

%feature("docstring")  dolfin::Form::cell_domains_shared_ptr "
Return cell domains (pointer may be zero if no domains have been specified)
";

%feature("docstring")  dolfin::Form::exterior_facet_domains_shared_ptr "
Return exterior facet domains (pointer may be zero if no domains have been specified)
";

%feature("docstring")  dolfin::Form::interior_facet_domains_shared_ptr "
Return interior facet domains (pointer may be zero if no domains have been specified)
";

%feature("docstring")  dolfin::Form::set_cell_domains "
Set cell domains
";

%feature("docstring")  dolfin::Form::set_exterior_facet_domains "
Set exterior facet domains
";

%feature("docstring")  dolfin::Form::set_interior_facet_domains "
Set interior facet domains
";

%feature("docstring")  dolfin::Form::ufc_form "
Return UFC form
";

%feature("docstring")  dolfin::Form::ufc_form_shared_ptr "
Return UFC form shared pointer
";

%feature("docstring")  dolfin::Form::check "
Check function spaces and coefficients
";

// Documentation extracted from: (module=fem, header=Assembler.h)
%feature("docstring")  dolfin::Assembler "
This class provides automated assembly of linear systems, or
more generally, assembly of a sparse tensor from a given
variational form.

Subdomains for cells and facets may be specified in a number
of different ways:

1. By explicitly passing MeshFunctions (as pointers) to the
   assemble functions

2. By assigning subdomain indicators specified by MeshFunctions
   to the Form being assembled:

   form.cell_domains = cell_domains
   form.exterior_facet_domains = exterior_facet_domains
   form.interior_facet_domains = interior_facet_domains

3. By MeshFunctions stored in MeshData as

   \"cell_domains\"
   \"exterior_facet_domains\"
   \"interior_facet_domains\"

4. By specifying a SubDomain which specifies the domain numbered
   as 0 (with the rest treated as domain number 1)

Note that (1) overrides (2), which overrides (3).
";

%feature("docstring")  dolfin::Assembler::assemble "
**Overloaded versions**

* assemble\ **(A, a, reset_sparsity=true, add_values=false)**

  Assemble tensor from given form

* assemble\ **(A, a, sub_domain, reset_sparsity=true, add_values=false)**

  Assemble tensor from given form on sub domain

* assemble\ **(A, a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false)**

  Assemble tensor from given form on sub domains
";

// Documentation extracted from: (module=fem, header=SparsityPatternBuilder.h)
%feature("docstring")  dolfin::SparsityPatternBuilder "
This class provides functions to compute the sparsity pattern.
";

%feature("docstring")  dolfin::SparsityPatternBuilder::build "
Build sparsity pattern for assembly of given form
";

// Documentation extracted from: (module=fem, header=SystemAssembler.h)
%feature("docstring")  dolfin::SystemAssembler "
This class provides implements an assembler for systems
of the form Ax = b. It differs from the default DOLFIN
assembler in that it assembles both A and b and the same
time (leading to better performance) and in that it applies
boundary conditions at the time of assembly.
";

%feature("docstring")  dolfin::SystemAssembler::assemble "
**Overloaded versions**

* assemble\ **(A, b, a, L, reset_sparsity=true, add_values=false)**

  Assemble system (A, b)

* assemble\ **(A, b, a, L, bc, reset_sparsity=true, add_values=true)**

  Assemble system (A, b) and apply Dirichlet boundary condition

* assemble\ **(A, b, a, L, bcs, reset_sparsity=true, add_values=false)**

  Assemble system (A, b) and apply Dirichlet boundary conditions

* assemble\ **(A, b, a, L, bcs, cell_domains, exterior_facet_domains, interior_facet_domains, x0, reset_sparsity=true, add_values=false)**

  Assemble system (A, b) and apply Dirichlet boundary conditions
";

// Documentation extracted from: (module=fem, header=VariationalProblem.h)
%feature("docstring")  dolfin::VariationalProblem "
A :py:class:`VariationalProblem` represents a (system of) partial
differential equation(s) in variational form:

Find u_h in V_h such that

    F(u_h; v) = 0  for all v in V_h',

where V_h is the trial space and V_h' is the test space.

The variational problem is specified in terms of a pair of
_Form_s and, optionally, a set of _BoundaryCondition_s.

The pair of forms may either specify a nonlinear problem

   (1) F(u_h; v) = 0

in terms of the residual F and its derivative J = F':

   F, J  (F linear, J bilinear)

or a linear problem

   (2) F(u_h; v) = a(u_h, v) - L(v) = 0

in terms of the bilinear form a and a linear form L:

   a, L  (a bilinear, L linear)

Thus, a pair of forms is interpreted either as a nonlinear
problem or a linear problem depending on the ranks of the given
forms.
";

%feature("docstring")  dolfin::VariationalProblem::VariationalProblem "
**Overloaded versions**

* VariationalProblem\ **(form_0, form_1)**

  Define variational problem with natural boundary conditions

* VariationalProblem\ **(form_0, form_1, bc)**

  Define variational problem with a single Dirichlet boundary condition

* VariationalProblem\ **(form_0, form_1, bcs)**

  Define variational problem with a list of Dirichlet boundary conditions

* VariationalProblem\ **(form_0, form_1, bcs)**

  Define variational problem with a list of Dirichlet boundary conditions
";

%feature("docstring")  dolfin::VariationalProblem::solve "
**Overloaded versions**

* solve\ **(u)**

  Solve variational problem

* solve\ **(u0, u1)**

  Solve variational problem and extract sub functions

* solve\ **(u0, u1, u2)**

  Solve variational problem and extract sub functions

* solve\ **(u, tol, M)**

  Solve variational problem adaptively to within given tolerance

* solve\ **(u, tol, M, ec)**

  Solve variational problem adaptively to within given tolerance
";

%feature("docstring")  dolfin::VariationalProblem::is_nonlinear "
Return true if problem is non-linear
";

%feature("docstring")  dolfin::VariationalProblem::trial_space "
Return trial space for variational problem
";

%feature("docstring")  dolfin::VariationalProblem::test_space "
Return test space for variational problem
";

%feature("docstring")  dolfin::VariationalProblem::bilinear_form "
Return the bilinear form
";

%feature("docstring")  dolfin::VariationalProblem::bilinear_form_shared_ptr "
Return the bilinear form (shared_ptr version)
";

%feature("docstring")  dolfin::VariationalProblem::form_0_shared_ptr "
Return form_0 (shared_ptr version)
";

%feature("docstring")  dolfin::VariationalProblem::form_1_shared_ptr "
Return form_1 (shared_ptr version)
";

%feature("docstring")  dolfin::VariationalProblem::linear_form "
Return the linear form
";

%feature("docstring")  dolfin::VariationalProblem::linear_form_shared_ptr "
Return the linear form (shared_ptr version)
";

%feature("docstring")  dolfin::VariationalProblem::bcs "
Return the list of boundary conditions
";

%feature("docstring")  dolfin::VariationalProblem::bcs_shared_ptr "
Return the list of boundary conditions (shared_ptr version)
";

%feature("docstring")  dolfin::VariationalProblem::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=OpenMpAssembler.h)
%feature("docstring")  dolfin::OpenMpAssembler "
This class provides automated assembly of linear systems, or
more generally, assembly of a sparse tensor from a given
variational form.

The MeshFunction arguments can be used to specify assembly over
subdomains of the mesh cells, exterior facets or interior
facets. Either a null pointer or an empty MeshFunction may be
used to specify that the tensor should be assembled over the
entire set of cells or facets.
";

%feature("docstring")  dolfin::OpenMpAssembler::assemble "
**Overloaded versions**

* assemble\ **(A, a, reset_sparsity=true, add_values=false)**

  Assemble tensor from given form

* assemble\ **(A, a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false)**

  Assemble tensor from given form on sub domains
";

// Documentation extracted from: (module=log, header=log.h)
%feature("docstring")  dolfin::info "
**Overloaded versions**

* info\ **(msg, ...)**

  The DOLFIN log system provides the following set of functions for
  uniform handling of log messages, warnings and errors. In addition,
  macros are provided for debug messages and assertions.
  
  Only messages with a debug level higher than or equal to the current
  log level are printed (the default being zero). Logging may also be
  turned off by calling set_log_active(false).
  Print message

* info\ **(parameters, verbose=false)**

  Print parameter (using output of str() method)

* info\ **(variable, verbose=false)**

  Print variable (using output of str() method)
";

%feature("docstring")  dolfin::info_stream "
Print message to stream
";

%feature("docstring")  dolfin::info_underline "
Print underlined message
";

%feature("docstring")  dolfin::warning "
Print warning
";

%feature("docstring")  dolfin::error "
Print error message and throw an exception
";

%feature("docstring")  dolfin::log "
Print message at given debug level
";

%feature("docstring")  dolfin::begin "
**Overloaded versions**

* begin\ **(msg, ...)**

  Begin task (increase indentation level)

* begin\ **(debug_level, msg, ...)**

  Begin task (increase indentation level)
";

%feature("docstring")  dolfin::end "
End task (decrease indentation level)
";

%feature("docstring")  dolfin::set_log_active "
Turn logging on or off (deprecated)
";

%feature("docstring")  dolfin::logging "
Turn logging on or off (deprecated, will be removed)
";

%feature("docstring")  dolfin::set_log_level "
Set log level
";

%feature("docstring")  dolfin::set_output_stream "
Set output stream
";

%feature("docstring")  dolfin::get_log_level "
Get log level
";

%feature("docstring")  dolfin::summary "
Print summary of timings and tasks, optionally clearing stored timings
";

%feature("docstring")  dolfin::timing "
Return timing (average) for given task, optionally clearing timing for task
";

%feature("docstring")  dolfin::not_working_in_parallel "
Report that functionality has not (yet) been implemented to work in parallel
";

%feature("docstring")  dolfin::check_equal "
Check value and print an informative error message if invalid
";

// Documentation extracted from: (module=log, header=Event.h)
%feature("docstring")  dolfin::Event "
A event is a string message which is displayed
only a limited number of times.

*Example*
    .. code-block:: python
    
        >>> event = dolfin.Event(\"System is stiff, damping is needed.\", 3)
        >>> for i in range(10):
        ...     if i > 7:
        ...         print i
        ...         event()
";

%feature("docstring")  dolfin::Event::Event "
Constructor
";

%feature("docstring")  dolfin::Event::operator "
Display message
";

%feature("docstring")  dolfin::Event::count "
Display count
";

%feature("docstring")  dolfin::Event::maxcount "
Maximum display count
";

// Documentation extracted from: (module=log, header=LogStream.h)
%feature("docstring")  dolfin::LogStream "
This class provides functionality similar to standard C++
streams (std::cout, std::endl) for output but working through
the DOLFIN log system.
";

%feature("docstring")  dolfin::LogStream::LogStream "
Create log stream of given type
";

%feature("docstring")  dolfin::LogStream::operator<< "
**Overloaded versions**

* operator<<\ **(stream)**

  Output for log stream

* operator<<\ **(s)**

  Output for string

* operator<<\ **(a)**

  Output for int

* operator<<\ **(a)**

  Output for unsigned int

* operator<<\ **(a)**

  Output for long int

* operator<<\ **(a)**

  Output for long int

* operator<<\ **(a)**

  Output for double

* operator<<\ **(z)**

  Output for complex

* operator<<\ **(variable)**

  Output for variable (calling str() method)

* operator<<\ **(entity)**

  Output for mesh entity (not subclass of Variable for efficiency)

* operator<<\ **(point)**

  Output for point (not subclass of Variable for efficiency)

* operator<<\ **(a)**

  Output for real
";

// Documentation extracted from: (module=log, header=Progress.h)
%feature("docstring")  dolfin::Progress::Progress "
**Overloaded versions**

* Progress\ **(title, n)**

  Create progress bar with a known number of steps

* Progress\ **(title)**

  Create progress bar with an unknown number of steps
";

%feature("docstring")  dolfin::Progress::operator= "
Set current position
";

%feature("docstring")  dolfin::Progress::operator++ "
Increment progress
";

// Documentation extracted from: (module=log, header=Table.h)
%feature("docstring")  dolfin::Table "
This class provides storage and pretty-printing for tables.
Example usage:

  Table table(\"Timings\");

  table(\"uBLAS\",  \"Assemble\") = 0.010;
  table(\"uBLAS\",  \"Solve\")    = 0.020;
  table(\"PETSc\",  \"Assemble\") = 0.011;
  table(\"PETSc\",  \"Solve\")    = 0.019;
  table(\"Epetra\", \"Assemble\") = 0.012;
  table(\"Epetra\", \"Solve\")    = 0.018;

  info(table);
";

%feature("docstring")  dolfin::Table::Table "
Create empty table
";

%feature("docstring")  dolfin::Table::operator "
Return table entry
";

%feature("docstring")  dolfin::Table::set "
**Overloaded versions**

* set\ **(row, col, value)**

  Set value of table entry

* set\ **(row, col, value)**

  Set value of table entry

* set\ **(row, col, value)**

  Set value of table entry

* set\ **(row, col, value)**

  Set value of table entry
";

%feature("docstring")  dolfin::Table::get "
Get value of table entry
";

%feature("docstring")  dolfin::Table::get_value "
Get value of table entry
";

%feature("docstring")  dolfin::Table::title "
Return table title
";

%feature("docstring")  dolfin::Table::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Table::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Table::str_latex "
Return informal string representation for LaTeX
";

%feature("docstring")  dolfin::TableEntry "
This class represents an entry in a Table
";

%feature("docstring")  dolfin::TableEntry::TableEntry "
Create table entry
";

%feature("docstring")  dolfin::TableEntry::operator= "
**Overloaded versions**

* operator=\ **(value)**

  Assign value to table entry

* operator=\ **(value)**

  Assign value to table entry

* operator=\ **(value)**

  Assign value to table entry

* operator=\ **(value)**

  Assign value to table entry
";

%feature("docstring")  dolfin::TableEntry::operator std::string "
Cast to entry value
";

// Documentation extracted from: (module=log, header=LogLevel.h)
// Documentation extracted from: (module=la, header=ublas.h)
// Documentation extracted from: (module=la, header=GenericLinearSolver.h)
%feature("docstring")  dolfin::GenericLinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::GenericLinearSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::GenericLinearSolver::solve "
**Overloaded versions**

* solve\ **(A, x, b)**

  Solve linear system Ax = b

* solve\ **(x, b)**

  Solve linear system Ax = b
";

// Documentation extracted from: (module=la, header=GenericLUSolver.h)
%feature("docstring")  dolfin::GenericLUSolver "
This a base class for LU solvers
";

%feature("docstring")  dolfin::GenericLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLUSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system Ax = b
";

// Documentation extracted from: (module=la, header=GenericTensor.h)
%feature("docstring")  dolfin::GenericTensor "
This class defines a common interface for arbitrary rank tensors.
";

%feature("docstring")  dolfin::GenericTensor::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::GenericTensor::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::GenericTensor::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericTensor::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericTensor::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericTensor::get "
Get block of values
";

%feature("docstring")  dolfin::GenericTensor::set "
Set block of values
";

%feature("docstring")  dolfin::GenericTensor::add "
**Overloaded versions**

* add\ **(block, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values

* add\ **(block, num_rows, rows)**

  Add block of values
";

%feature("docstring")  dolfin::GenericTensor::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericTensor::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericTensor::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericTensor::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::GenericTensor::down_cast "
**Overloaded versions**

* down_cast\ **()**

  Cast a GenericTensor to its derived class (const version)

* down_cast\ **()**

  Cast a GenericTensor to its derived class (non-const version)
";

%feature("docstring")  dolfin::GenericTensor::has_type "
Check whether the GenericTensor instance matches a specific type
";

%feature("docstring")  dolfin::GenericTensor::instance "
**Overloaded versions**

* instance\ **()**

  Return concrete instance / unwrap (const version)

* instance\ **()**

  Return concrete instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::GenericTensor::operator= "
Assignment (must be overloaded by subclass)
";

// Documentation extracted from: (module=la, header=GenericMatrix.h)
%feature("docstring")  dolfin::GenericMatrix "
This class defines a common interface for matrices.
";

%feature("docstring")  dolfin::GenericMatrix::resize "
**Overloaded versions**

* resize\ **(rank, dims)**

  Resize tensor with given dimensions

* resize\ **(y, dim)**

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::GenericMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::GenericMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::GenericMatrix::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericMatrix::get "
**Overloaded versions**

* get\ **(block, num_rows, rows)**

  Get block of values

* get\ **(block, m, rows, n, cols)**

  Get block of values
";

%feature("docstring")  dolfin::GenericMatrix::set "
**Overloaded versions**

* set\ **(block, num_rows, rows)**

  Set block of values

* set\ **(block, m, rows, n, cols)**

  Set block of values
";

%feature("docstring")  dolfin::GenericMatrix::add "
**Overloaded versions**

* add\ **(block, num_rows, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values

* add\ **(block, m, rows, n, cols)**

  Add block of values
";

%feature("docstring")  dolfin::GenericMatrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::GenericMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::GenericMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::GenericMatrix::getrow "
Get non-zero values of given row on local process
";

%feature("docstring")  dolfin::GenericMatrix::setrow "
Set values for given row on local process
";

%feature("docstring")  dolfin::GenericMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::GenericMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::GenericMatrix::transpmult "
Matrix-vector product, y = A^T x
";

%feature("docstring")  dolfin::GenericMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator+= "
Add given matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator-= "
Subtract given matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::GenericMatrix::data "
Return pointers to underlying compresssed row/column storage data
For compressed row storage, data = (row_pointer[#rows +1],
column_index[#nz], matrix_values[#nz], nz)
";

%feature("docstring")  dolfin::GenericMatrix::operator "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::setitem "
Set given entry to value. apply(\"insert\") should be called before using
using the object.
";

%feature("docstring")  dolfin::GenericMatrix::ident_zeros "
Insert one on the diagonal for all zero rows
";

// Documentation extracted from: (module=la, header=GenericSparsityPattern.h)
%feature("docstring")  dolfin::GenericSparsityPattern "
Base class (interface) for generic tensor sparsity patterns.
Currently, this interface is mostly limited to matrices.
";

%feature("docstring")  dolfin::GenericSparsityPattern::GenericSparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::GenericSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::GenericSparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::GenericSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::GenericSparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::GenericSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_diagonal "
Fill vector with number of nonzeros for diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_off_diagonal "
Fill vector with number of nonzeros for off-diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::apply "
Finalize sparsity pattern
";

// Documentation extracted from: (module=la, header=GenericVector.h)
%feature("docstring")  dolfin::GenericVector "
This class defines a common interface for vectors.
";

%feature("docstring")  dolfin::GenericVector::resize "
**Overloaded versions**

* resize\ **(rank, dims)**

  Resize tensor with given dimensions

* resize\ **(N)**

  Resize vector to global size N

* resize\ **(std::pair<uint, range)**

  Resize vector with given ownership range

* resize\ **(std::pair<uint, range, ghost_indices)**

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::GenericVector::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::GenericVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::GenericVector::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericVector::size "
**Overloaded versions**

* size\ **(dim)**

  Return size of given dimension

* size\ **()**

  Return global size of vector
";

%feature("docstring")  dolfin::GenericVector::local_range "
**Overloaded versions**

* local_range\ **(dim)**

  Return local ownership range

* local_range\ **()**

  Return local ownership range of a vector
";

%feature("docstring")  dolfin::GenericVector::get "
**Overloaded versions**

* get\ **(block, num_rows, rows)**

  Get block of values

* get\ **(block, m, rows)**

  Get block of values (values may live on any process)
";

%feature("docstring")  dolfin::GenericVector::set "
**Overloaded versions**

* set\ **(block, num_rows, rows)**

  Set block of values

* set\ **(block, m, rows)**

  Set block of values
";

%feature("docstring")  dolfin::GenericVector::add "
**Overloaded versions**

* add\ **(block, num_rows, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values

* add\ **(block, m, rows)**

  Add block of values
";

%feature("docstring")  dolfin::GenericVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::GenericVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::GenericVector::get_local "
**Overloaded versions**

* get_local\ **(block, m, rows)**

  Get block of values (values must all live on the local process)

* get_local\ **(values)**

  Get all values on local process
";

%feature("docstring")  dolfin::GenericVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::GenericVector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::GenericVector::gather "
**Overloaded versions**

* gather\ **(x, indices)**

  Gather entries into local vector x

* gather\ **(x, indices)**

  Gather entries into Array x
";

%feature("docstring")  dolfin::GenericVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::GenericVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::GenericVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::GenericVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::GenericVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::GenericVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::GenericVector::sum "
**Overloaded versions**

* sum\ **()**

  Return sum of vector

* sum\ **(rows)**

  Return sum of selected rows in vector. Repeated entries are only summed once.
";

%feature("docstring")  dolfin::GenericVector::operator*= "
**Overloaded versions**

* operator*=\ **(a)**

  Multiply vector by given number

* operator*=\ **(x)**

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::GenericVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::GenericVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::GenericVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::GenericVector::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(a)**

  Assignment operator
";

%feature("docstring")  dolfin::GenericVector::data "
**Overloaded versions**

* data\ **()**

  Return pointer to underlying data (const version)

* data\ **()**

  Return pointer to underlying data
";

%feature("docstring")  dolfin::GenericVector::update_ghost_values "
Update ghost values
";

%feature("docstring")  dolfin::GenericVector::operator[] "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::setitem "
Set given entry to value. apply(\"insert\") should be called before using
using the object.
";

// Documentation extracted from: (module=la, header=GenericSparsityPattern.h)
%feature("docstring")  dolfin::GenericSparsityPattern "
Base class (interface) for generic tensor sparsity patterns.
Currently, this interface is mostly limited to matrices.
";

%feature("docstring")  dolfin::GenericSparsityPattern::GenericSparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::GenericSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::GenericSparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::GenericSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::GenericSparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::GenericSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_diagonal "
Fill vector with number of nonzeros for diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_off_diagonal "
Fill vector with number of nonzeros for off-diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::apply "
Finalize sparsity pattern
";

// Documentation extracted from: (module=la, header=PETScObject.h)
%feature("docstring")  dolfin::PETScObject "
This class calls SubSystemsManager to initialise PETSc.

All PETSc objects must be derived from this class.
";

// Documentation extracted from: (module=la, header=PETScBaseMatrix.h)
%feature("docstring")  dolfin::PETScBaseMatrix "
This class is a base class for matrices that can be used in
PETScKrylovSolver.
";

%feature("docstring")  dolfin::PETScBaseMatrix::PETScBaseMatrix "
**Overloaded versions**

* PETScBaseMatrix\ **()**

  Constructor

* PETScBaseMatrix\ **(A)**

  Constructor
";

%feature("docstring")  dolfin::PETScBaseMatrix::resize "
**Overloaded versions**

* resize\ **(m, n)**

  Resize virtual matrix

* resize\ **(y, dim)**

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::PETScBaseMatrix::size "
Return number of rows (dim = 0) or columns (dim = 1)
";

%feature("docstring")  dolfin::PETScBaseMatrix::local_range "
Return local rang along dimension dim
";

%feature("docstring")  dolfin::PETScBaseMatrix::mat "
Return PETSc Mat pointer
";

%feature("docstring")  dolfin::PETScBaseMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=uBLASFactory.h)
%feature("docstring")  dolfin::uBLASFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::uBLASFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::uBLASFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::uBLASFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::uBLASFactory::create_lu_solver "
Create LU solver
";

// Documentation extracted from: (module=la, header=uBLASMatrix.h)
%feature("docstring")  dolfin::uBLASMatrix "
This class provides a simple matrix class based on uBLAS.
It is a simple wrapper for a uBLAS matrix implementing the
GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the underlying uBLAS matrix and use the standard
uBLAS interface which is documented at
http://www.boost.org/libs/numeric/ublas/doc/index.htm.

Developer note: specialised member functions must be
inlined to avoid link errors.
";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "
**Overloaded versions**

* uBLASMatrix\ **()**

  Create empty matrix

* uBLASMatrix\ **(M, N)**

  Create M x N matrix

* uBLASMatrix\ **(A)**

  Copy constructor

* uBLASMatrix\ **(A)**

  Create matrix from given uBLAS matrix expression
";

%feature("docstring")  dolfin::uBLASMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::uBLASMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::uBLASMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::uBLASMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::uBLASMatrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::uBLASMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::uBLASMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::uBLASMatrix::resize "
**Overloaded versions**

* resize\ **(M, N)**

  Resize matrix to M x N

* resize\ **(y, dim)**

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::uBLASMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::uBLASMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::uBLASMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::uBLASMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::uBLASMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::uBLASMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::uBLASMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::uBLASMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::uBLASMatrix::transpmult "
Matrix-vector product, y = A^T x
";

%feature("docstring")  dolfin::uBLASMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::uBLASMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::uBLASMatrix::operator= "
**Overloaded versions**

* operator=\ **(A)**

  Assignment operator

* operator=\ **(A)**

  Assignment operator
";

%feature("docstring")  dolfin::uBLASMatrix::data "
Return pointers to underlying compresssed storage data
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::uBLASMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::uBLASMatrix::mat "
**Overloaded versions**

* mat\ **()**

  Return reference to uBLAS matrix (const version)

* mat\ **()**

  Return reference to uBLAS matrix (non-const version)
";

%feature("docstring")  dolfin::uBLASMatrix::solve "
Solve Ax = b out-of-place using uBLAS (A is not destroyed)
";

%feature("docstring")  dolfin::uBLASMatrix::solveInPlace "
**Overloaded versions**

* solveInPlace\ **(x, b)**

  Solve Ax = b in-place using uBLAS(A is destroyed)

* solveInPlace\ **(X)**

  General uBLAS LU solver which accepts both vector and matrix right-hand sides
";

%feature("docstring")  dolfin::uBLASMatrix::invert "
Compute inverse of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::lump "
Lump matrix into vector m
";

%feature("docstring")  dolfin::uBLASMatrix::compress "
Compress matrix (eliminate all non-zeros from a sparse matrix)
";

%feature("docstring")  dolfin::uBLASMatrix::operator "
Access value of given entry
";

// Documentation extracted from: (module=la, header=uBLASKrylovMatrix.h)
%feature("docstring")  dolfin::uBLASKrylovMatrix "
This class provides an interface for matrices that define linear
systems for the uBLASKrylovSolver. This interface is implemented
by the classes uBLASSparseMatrix and DenseMatrix. Users may also
overload the mult() function to specify a linear system only in
terms of its action.
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::uBLASKrylovMatrix "
Constructor
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::size "
Return number of rows (dim = 0) or columns (dim = 1)
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::mult "
Compute product y = Ax
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::solve "
Solve linear system Ax = b for a Krylov matrix using uBLAS and dense matrices
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=PETScMatrix.h)
%feature("docstring")  dolfin::PETScMatrix "
This class provides a simple matrix class based on PETSc.
It is a wrapper for a PETSc matrix pointer (Mat)
implementing the GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Mat pointer using the function mat() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScMatrix::PETScMatrix "
**Overloaded versions**

* PETScMatrix\ **()**

  Create empty matrix

* PETScMatrix\ **(A)**

  Copy constructor

* PETScMatrix\ **(A)**

  Create matrix from given PETSc Mat pointer
";

%feature("docstring")  dolfin::PETScMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::PETScMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::PETScMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::PETScMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::PETScMatrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::PETScMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::PETScMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScMatrix::resize "
**Overloaded versions**

* resize\ **(M, N)**

  Resize matrix to M x N

* resize\ **(y, dim)**

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::PETScMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::PETScMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::PETScMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::PETScMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::PETScMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::PETScMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::PETScMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::PETScMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator= "
**Overloaded versions**

* operator=\ **(A)**

  Assignment operator

* operator=\ **(A)**

  Assignment operator
";

%feature("docstring")  dolfin::PETScMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::PETScMatrix::binary_dump "
Dump matrix to PETSc binary format
";

// Documentation extracted from: (module=la, header=PETScKrylovMatrix.h)
%feature("docstring")  dolfin::PETScKrylovMatrix "
This class represents a matrix-free matrix of dimension m x m.
It is a simple wrapper for a PETSc shell matrix. The interface
is intentionally simple. For advanced usage, access the PETSc
Mat pointer using the function mat() and use the standard PETSc
interface.

The class PETScKrylovMatrix enables the use of Krylov subspace
methods for linear systems Ax = b, without having to explicitly
store the matrix A. All that is needed is that the user-defined
PETScKrylovMatrix implements multiplication with vectors. Note that
the multiplication operator needs to be defined in terms of
PETSc data structures (Vec), since it will be called from PETSc.
";

%feature("docstring")  dolfin::PETScKrylovMatrix::PETScKrylovMatrix "
**Overloaded versions**

* PETScKrylovMatrix\ **()**

  Constructor

* PETScKrylovMatrix\ **(m, n)**

  Create a virtual matrix matching the given vectors
";

%feature("docstring")  dolfin::PETScKrylovMatrix::resize "
Resize virtual matrix
";

%feature("docstring")  dolfin::PETScKrylovMatrix::mult "
Compute product y = Ax
";

%feature("docstring")  dolfin::PETScKrylovMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=PETScPreconditioner.h)
%feature("docstring")  dolfin::PETScPreconditioner "
This class is a wrapper for configuring PETSc preconditioners. It does
not own a preconditioner. It can take a PETScKrylovSolver and set the
preconditioner type and parameters.
";

%feature("docstring")  dolfin::PETScPreconditioner::PETScPreconditioner "
Create a particular preconditioner object
";

%feature("docstring")  dolfin::PETScPreconditioner::set "
Set the precondtioner type and parameters
";

%feature("docstring")  dolfin::PETScPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScPreconditioner::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=EpetraLUSolver.h)
%feature("docstring")  dolfin::EpetraLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the LU
solver of Epetra.
";

%feature("docstring")  dolfin::EpetraLUSolver::EpetraLUSolver "
**Overloaded versions**

* EpetraLUSolver\ **()**

  Constructor

* EpetraLUSolver\ **(A)**

  Constructor
";

%feature("docstring")  dolfin::EpetraLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::EpetraLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::EpetraLUSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::EpetraLUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::EpetraLUSolver::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=EpetraKrylovSolver.h)
%feature("docstring")  dolfin::EpetraKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of Epetra.
";

%feature("docstring")  dolfin::EpetraKrylovSolver::EpetraKrylovSolver "
**Overloaded versions**

* EpetraKrylovSolver\ **(\"default\", \"default\")**

  Create Krylov solver for a particular method and preconditioner

* EpetraKrylovSolver\ **(method, preconditioner)**

  Create Krylov solver for a particular method and TrilinosPreconditioner
";

%feature("docstring")  dolfin::EpetraKrylovSolver::set_operator "
Set the operator (matrix)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::set_operators "
Set the operator (matrix)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::get_operator "
Get the operator (matrix)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::EpetraKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::EpetraKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::aztecoo "
Return pointer to Aztec00
";

// Documentation extracted from: (module=la, header=EpetraMatrix.h)
%feature("docstring")  dolfin::EpetraMatrix "
This class provides a simple matrix class based on Epetra.
It is a simple wrapper for an Epetra matrix object (Epetra_FECrsMatrix)
implementing the GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the Epetra_FECrsMatrix object using the function mat() and
use the standard Epetra interface.
";

%feature("docstring")  dolfin::EpetraMatrix::EpetraMatrix "
**Overloaded versions**

* EpetraMatrix\ **()**

  Create empty matrix

* EpetraMatrix\ **(A)**

  Copy constuctor

* EpetraMatrix\ **(A)**

  Create matrix from given Epetra_FECrsMatrix pointer

* EpetraMatrix\ **(graph)**

  Create matrix from given Epetra_CrsGraph
";

%feature("docstring")  dolfin::EpetraMatrix::init "
**Overloaded versions**

* init\ **(sparsity_pattern)**

  Initialize zero tensor using sparsity pattern

* init\ **(sparsity_pattern)**

  Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::EpetraMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::EpetraMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::EpetraMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::EpetraMatrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::EpetraMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::EpetraMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EpetraMatrix::resize "
Resize vector y such that is it compatible with matrix for
multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::EpetraMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::EpetraMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::EpetraMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::EpetraMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::EpetraMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::EpetraMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::EpetraMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::EpetraMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::EpetraMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::EpetraMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::EpetraMatrix::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator
";

%feature("docstring")  dolfin::EpetraMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::EpetraMatrix::mat "
Return Epetra_FECrsMatrix pointer
";

// Documentation extracted from: (module=la, header=EpetraVector.h)
%feature("docstring")  dolfin::EpetraVector "
This class provides a simple vector class based on Epetra.
It is a simple wrapper for an Epetra vector object (Epetra_FEVector)
implementing the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the Epetra_FEVector object using the function vec() or vec_ptr()
and use the standard Epetra interface.
";

%feature("docstring")  dolfin::EpetraVector::EpetraVector "
**Overloaded versions**

* EpetraVector\ **(type=\"global\")**

  Create empty vector

* EpetraVector\ **(N, type=\"global\")**

  Create vector of size N

* EpetraVector\ **(x)**

  Copy constructor

* EpetraVector\ **(vector)**

  Create vector view from given Epetra_FEVector pointer

* EpetraVector\ **(map)**

  Create vector from given Epetra_BlockMap
";

%feature("docstring")  dolfin::EpetraVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::EpetraVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::EpetraVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::EpetraVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EpetraVector::resize "
**Overloaded versions**

* resize\ **(N)**

  Resize vector to size N

* resize\ **(std::pair<uint, range)**

  Resize vector with given ownership range

* resize\ **(std::pair<uint, range, ghost_indices)**

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::EpetraVector::size "
Return size of vector
";

%feature("docstring")  dolfin::EpetraVector::local_size "
Return size of local vector
";

%feature("docstring")  dolfin::EpetraVector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::EpetraVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::EpetraVector::set "
Set block of values
";

%feature("docstring")  dolfin::EpetraVector::add "
Add block of values
";

%feature("docstring")  dolfin::EpetraVector::get_local "
Get all values on local process
";

%feature("docstring")  dolfin::EpetraVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::EpetraVector::add_local "
Add all values to each entry on local process
";

%feature("docstring")  dolfin::EpetraVector::gather "
**Overloaded versions**

* gather\ **(x, indices)**

  Gather entries into local vector x

* gather\ **(x, indices)**

  Gather entries into Array x
";

%feature("docstring")  dolfin::EpetraVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::EpetraVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::EpetraVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::EpetraVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::EpetraVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::EpetraVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::EpetraVector::sum "
**Overloaded versions**

* sum\ **()**

  Return sum of values of vector

* sum\ **(rows)**

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::EpetraVector::operator*= "
**Overloaded versions**

* operator*=\ **(a)**

  Multiply vector by given number

* operator*=\ **(x)**

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::EpetraVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::EpetraVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::EpetraVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::EpetraVector::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(a)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator
";

%feature("docstring")  dolfin::EpetraVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::EpetraVector::reset "
Reset Epetra_FEVector
";

%feature("docstring")  dolfin::EpetraVector::vec "
Return Epetra_FEVector pointer
";

// Documentation extracted from: (module=la, header=PETScKrylovSolver.h)
%feature("docstring")  dolfin::PETScKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of PETSc.
";

%feature("docstring")  dolfin::PETScKrylovSolver::PETScKrylovSolver "
**Overloaded versions**

* PETScKrylovSolver\ **(\"default\", \"default\")**

  Create Krylov solver for a particular method and names preconditioner

* PETScKrylovSolver\ **(method, preconditioner)**

  Create Krylov solver for a particular method and PETScPreconditioner

* PETScKrylovSolver\ **(method, preconditioner)**

  Create Krylov solver for a particular method and PETScPreconditioner

* PETScKrylovSolver\ **(ksp)**

  Create solver from given PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operator "
**Overloaded versions**

* set_operator\ **(A)**

  Set operator (matrix)

* set_operator\ **(A)**

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operators "
**Overloaded versions**

* set_operators\ **(A, P)**

  Set operator (matrix) and preconditioner matrix

* set_operators\ **(A, P)**

  Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::PETScKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::PETScKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScKrylovSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::PETScKrylovSolver::init "
Initialize KSP solver
";

%feature("docstring")  dolfin::PETScKrylovSolver::write_report "
Report the number of iterations
";

// Documentation extracted from: (module=la, header=PETScLUSolver.h)
%feature("docstring")  dolfin::PETScLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the LU
solver of PETSc.
";

%feature("docstring")  dolfin::PETScLUSolver::PETScLUSolver "
**Overloaded versions**

* PETScLUSolver\ **(lu_package=\"default\")**

  Constructor

* PETScLUSolver\ **(A, lu_package=\"default\")**

  Constructor

* PETScLUSolver\ **(A, lu_package=\"default\")**

  Constructor
";

%feature("docstring")  dolfin::PETScLUSolver::set_operator "
**Overloaded versions**

* set_operator\ **(A)**

  Set operator (matrix)

* set_operator\ **(A)**

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::PETScLUSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScLUSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=CholmodCholeskySolver.h)
%feature("docstring")  dolfin::CholmodCholeskySolver "
This class implements the direct solution (Cholesky factorization) of
linear systems of the form Ax = b. Sparse matrices
are solved using CHOLMOD http://www.cise.ufl.edu/research/sparse/cholmod/
if installed.
";

%feature("docstring")  dolfin::CholmodCholeskySolver::CholmodCholeskySolver "
**Overloaded versions**

* CholmodCholeskySolver\ **()**

  Constructor

* CholmodCholeskySolver\ **(A)**

  Constructor

* CholmodCholeskySolver\ **(A)**

  Constructor
";

%feature("docstring")  dolfin::CholmodCholeskySolver::set_operator "
Solve the operator (matrix)
";

%feature("docstring")  dolfin::CholmodCholeskySolver::solve "
Solve linear system Ax = b for a sparse matrix using CHOLMOD
";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorize "
Cholesky-factor sparse matrix A if CHOLMOD is installed
";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorized_solve "
Solve factorized system (CHOLMOD).
";

%feature("docstring")  dolfin::CholmodCholeskySolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::Cholmod::clear "
Clear data
";

%feature("docstring")  dolfin::Cholmod::init "
Initialise with matrix
";

%feature("docstring")  dolfin::Cholmod::factorize "
Factorize
";

%feature("docstring")  dolfin::Cholmod::factorized_solve "
Factorized solve
";

%feature("docstring")  dolfin::Cholmod::residual "
Compute residual: b-Ax
";

%feature("docstring")  dolfin::Cholmod::residual_norm "
Compute residual norm
";

%feature("docstring")  dolfin::Cholmod::refine_once "
Perform one refinement
";

%feature("docstring")  dolfin::Cholmod::check_status "
Check status flag returned by an CHOLMOD function
";

// Documentation extracted from: (module=la, header=UmfpackLUSolver.h)
%feature("docstring")  dolfin::UmfpackLUSolver "
This class implements the direct solution (LU factorization) of
linear systems of the form Ax = b using UMFPACK
(http://www.cise.ufl.edu/research/sparse/umfpack/) if installed.
";

%feature("docstring")  dolfin::UmfpackLUSolver::UmfpackLUSolver "
**Overloaded versions**

* UmfpackLUSolver\ **()**

  Constructor

* UmfpackLUSolver\ **(A)**

  Constructor

* UmfpackLUSolver\ **(A)**

  Constructor
";

%feature("docstring")  dolfin::UmfpackLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::UmfpackLUSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::UmfpackLUSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b for a sparse matrix using UMFPACK if installed

* solve\ **(A, x, b)**

  Solve linear system
";

%feature("docstring")  dolfin::UmfpackLUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::UmfpackLUSolver::numeric_factorize "
LU factorisation
";

%feature("docstring")  dolfin::UmfpackLUSolver::solve_factorized "
Solve factorized system (UMFPACK).
";

%feature("docstring")  dolfin::UmfpackLUSolver::umfpack_check_status "
Check status flag returned by an UMFPACK function
";

// Documentation extracted from: (module=la, header=ITLKrylovSolver.h)
%feature("docstring")  dolfin::ITLKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of ITL.
";

%feature("docstring")  dolfin::ITLKrylovSolver::ITLKrylovSolver "
Create Krylov solver for a particular method and preconditioner
";

%feature("docstring")  dolfin::ITLKrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::ITLKrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::ITLKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::ITLKrylovSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::ITLKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::ITLKrylovSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=MTL4Matrix.h)
%feature("docstring")  dolfin::MTL4Matrix::MTL4Matrix "
**Overloaded versions**

* MTL4Matrix\ **()**

  Create empty matrix

* MTL4Matrix\ **(A)**

  Copy constuctor

* MTL4Matrix\ **(M, N, nz)**

  Create M x N matrix with estimate of nonzeroes per row
";

%feature("docstring")  dolfin::MTL4Matrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::MTL4Matrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::MTL4Matrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::MTL4Matrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::MTL4Matrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::MTL4Matrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::MTL4Matrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::MTL4Matrix::resize "
**Overloaded versions**

* resize\ **(M, N)**

  Resize matrix to M x N

* resize\ **(y, dim)**

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::MTL4Matrix::get "
Get block of values
";

%feature("docstring")  dolfin::MTL4Matrix::set "
Set block of values
";

%feature("docstring")  dolfin::MTL4Matrix::add "
Add block of values
";

%feature("docstring")  dolfin::MTL4Matrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::MTL4Matrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::MTL4Matrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::MTL4Matrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::MTL4Matrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::MTL4Matrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::MTL4Matrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::MTL4Matrix::operator= "
**Overloaded versions**

* operator=\ **(A)**

  Assignment operator

* operator=\ **(A)**

  Assignment operator
";

%feature("docstring")  dolfin::MTL4Matrix::data "
Return pointers to underlying compresssed storage data
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::MTL4Matrix::mat "
Return mtl4_sparse_matrix reference
";

// Documentation extracted from: (module=la, header=STLMatrix.h)
%feature("docstring")  dolfin::STLMatrix "
Simple STL-based implementation of the GenericMatrix interface.
The sparse matrix is stored as a pair of std::vector of
std::vector, one for the columns and one for the values.

Historically, this class has undergone a number of different
incarnations, based on various combinations of std::vector,
std::set and std::map. The current implementation has proven to
be the fastest.
";

%feature("docstring")  dolfin::STLMatrix::STLMatrix "
**Overloaded versions**

* STLMatrix\ **()**

  Create empty matrix

* STLMatrix\ **(M, N)**

  Create M x N matrix

* STLMatrix\ **(A)**

  Copy constructor
";

%feature("docstring")  dolfin::STLMatrix::init "
--- Implementation of the GenericTensor interface ---
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::STLMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::STLMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::STLMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::STLMatrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::STLMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::STLMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::STLMatrix::resize "
**Overloaded versions**

* resize\ **(M, N)**

  Initialize M x N matrix

* resize\ **(y, dim)**

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.

* resize\ **(rank, dims, reset)**

  Resize tensor of given rank and dimensions
";

%feature("docstring")  dolfin::STLMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::STLMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::STLMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::STLMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::STLMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::STLMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::STLMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::STLMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::STLMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::STLMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::STLMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::STLMatrix::factory "
--- Specialized matrix functions ---
Return linear algebra backend factory
";

// Documentation extracted from: (module=la, header=uBLASVector.h)
%feature("docstring")  dolfin::uBLASVector "
This class provides a simple vector class based on uBLAS.
It is a simple wrapper for a uBLAS vector implementing the
GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the underlying uBLAS vector and use the standard
uBLAS interface which is documented at
http://www.boost.org/libs/numeric/ublas/doc/index.htm.
";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "
**Overloaded versions**

* uBLASVector\ **()**

  Create empty vector

* uBLASVector\ **(N)**

  Create vector of size N

* uBLASVector\ **(x)**

  Copy constructor

* uBLASVector\ **(x)**

  Construct vector from a ublas_vector
";

%feature("docstring")  dolfin::uBLASVector::copy "
Create copy of tensor
";

%feature("docstring")  dolfin::uBLASVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::uBLASVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::uBLASVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::uBLASVector::resize "
**Overloaded versions**

* resize\ **(N)**

  Resize vector to size N

* resize\ **(std::pair<uint, range)**

  Resize vector with given ownership range

* resize\ **(std::pair<uint, range, ghost_indices)**

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::uBLASVector::size "
Return size of vector
";

%feature("docstring")  dolfin::uBLASVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::uBLASVector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::uBLASVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::uBLASVector::get_local "
**Overloaded versions**

* get_local\ **(block, m, rows)**

  Get block of values

* get_local\ **(values)**

  Get all values on local process
";

%feature("docstring")  dolfin::uBLASVector::set "
Set block of values
";

%feature("docstring")  dolfin::uBLASVector::add "
Add block of values
";

%feature("docstring")  dolfin::uBLASVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::uBLASVector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::uBLASVector::gather "
**Overloaded versions**

* gather\ **(x, indices)**

  Gather entries into local vector x

* gather\ **(x, indices)**

  Gather entries into Array x
";

%feature("docstring")  dolfin::uBLASVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::uBLASVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::uBLASVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::uBLASVector::norm "
Compute norm of vector
";

%feature("docstring")  dolfin::uBLASVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::uBLASVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::uBLASVector::sum "
**Overloaded versions**

* sum\ **()**

  Return sum of values of vector

* sum\ **(rows)**

  Return sum of selected rows in vector. Repeated entries are only summed once.
";

%feature("docstring")  dolfin::uBLASVector::operator*= "
**Overloaded versions**

* operator*=\ **(a)**

  Multiply vector by given number

* operator*=\ **(x)**

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::uBLASVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::uBLASVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::uBLASVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::uBLASVector::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(a)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator
";

%feature("docstring")  dolfin::uBLASVector::data "
**Overloaded versions**

* data\ **()**

  Return pointer to underlying data (const version)

* data\ **()**

  Return pointer to underlying data
";

%feature("docstring")  dolfin::uBLASVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::uBLASVector::vec "
**Overloaded versions**

* vec\ **()**

  Return reference to uBLAS vector (const version)

* vec\ **()**

  Return reference to uBLAS vector (non-const version)
";

%feature("docstring")  dolfin::uBLASVector::operator[] "
**Overloaded versions**

* operator[]\ **(i)**

  Access value of given entry (const version)

* operator[]\ **(i)**

  Access value of given entry (non-const version)
";

// Documentation extracted from: (module=la, header=PETScVector.h)
%feature("docstring")  dolfin::PETScVector "
This class provides a simple vector class based on PETSc.
It is a simple wrapper for a PETSc vector pointer (Vec)
implementing the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Vec pointer using the function vec() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScVector::PETScVector "
**Overloaded versions**

* PETScVector\ **(type=\"global\")**

  Create empty vector

* PETScVector\ **(N, type=\"global\")**

  Create vector of size N

* PETScVector\ **(sparsity_pattern)**

  Create vector

* PETScVector\ **(x)**

  Copy constructor

* PETScVector\ **(x)**

  Create vector from given PETSc Vec pointer
";

%feature("docstring")  dolfin::PETScVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::PETScVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::PETScVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::PETScVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScVector::resize "
**Overloaded versions**

* resize\ **(N)**

  Resize vector to global size N

* resize\ **(std::pair<uint, range)**

  Resize vector with given ownership range

* resize\ **(std::pair<uint, range, ghost_indices)**

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::PETScVector::size "
Return size of vector
";

%feature("docstring")  dolfin::PETScVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::PETScVector::local_range "
Return ownership range of a vector
";

%feature("docstring")  dolfin::PETScVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::PETScVector::get_local "
**Overloaded versions**

* get_local\ **(block, m, rows)**

  Get block of values (values must all live on the local process)

* get_local\ **(values)**

  Get all values on local process
";

%feature("docstring")  dolfin::PETScVector::set "
Set block of values
";

%feature("docstring")  dolfin::PETScVector::add "
Add block of values
";

%feature("docstring")  dolfin::PETScVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::PETScVector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::PETScVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::PETScVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::PETScVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::PETScVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::PETScVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::PETScVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::PETScVector::sum "
**Overloaded versions**

* sum\ **()**

  Return sum of values of vector

* sum\ **(rows)**

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::PETScVector::operator*= "
**Overloaded versions**

* operator*=\ **(a)**

  Multiply vector by given number

* operator*=\ **(x)**

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::PETScVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::PETScVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::PETScVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::PETScVector::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(a)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator
";

%feature("docstring")  dolfin::PETScVector::reset "
Reset data and PETSc vector object
";

%feature("docstring")  dolfin::PETScVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScVector::vec "
Return shared_ptr to PETSc Vec object
";

%feature("docstring")  dolfin::PETScVector::gather "
**Overloaded versions**

* gather\ **(y, indices)**

  Gather vector entries into a local vector

* gather\ **(x, indices)**

  Gather entries into Array x
";

// Documentation extracted from: (module=la, header=MTL4Vector.h)
%feature("docstring")  dolfin::MTL4Vector::MTL4Vector "
**Overloaded versions**

* MTL4Vector\ **()**

  Create empty vector

* MTL4Vector\ **(N)**

  Create vector of size N

* MTL4Vector\ **(x)**

  Copy constructor
";

%feature("docstring")  dolfin::MTL4Vector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::MTL4Vector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::MTL4Vector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::MTL4Vector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::MTL4Vector::resize "
**Overloaded versions**

* resize\ **(N)**

  Resize vector to size N

* resize\ **(std::pair<uint, range)**

  Resize vector with given ownership range

* resize\ **(std::pair<uint, range, ghost_indices)**

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::MTL4Vector::size "
Return size of vector
";

%feature("docstring")  dolfin::MTL4Vector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::MTL4Vector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::MTL4Vector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::MTL4Vector::get_local "
**Overloaded versions**

* get_local\ **(block, m, rows)**

  Get block of values

* get_local\ **(values)**

  Get all values on local process
";

%feature("docstring")  dolfin::MTL4Vector::set "
Set block of values
";

%feature("docstring")  dolfin::MTL4Vector::add "
Add block of values
";

%feature("docstring")  dolfin::MTL4Vector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::MTL4Vector::add_local "
Add all values to each entry on local process
";

%feature("docstring")  dolfin::MTL4Vector::gather "
Gather entries into local vector x
";

%feature("docstring")  dolfin::MTL4Vector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::MTL4Vector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::MTL4Vector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::MTL4Vector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::MTL4Vector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::MTL4Vector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::MTL4Vector::sum "
**Overloaded versions**

* sum\ **()**

  Return sum of values of vector

* sum\ **(rows)**

  Return sum of selected rows in vector. Repeated entries are only summed once.
";

%feature("docstring")  dolfin::MTL4Vector::operator*= "
**Overloaded versions**

* operator*=\ **(a)**

  Multiply vector by given number

* operator*=\ **(x)**

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::MTL4Vector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::MTL4Vector::operator= "
**Overloaded versions**

* operator=\ **(a)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator
";

%feature("docstring")  dolfin::MTL4Vector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::MTL4Vector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::MTL4Vector::data "
**Overloaded versions**

* data\ **()**

  Return pointer to underlying data (const version)

* data\ **()**

  Return pointer to underlying data (non-const version)
";

%feature("docstring")  dolfin::MTL4Vector::vec "
**Overloaded versions**

* vec\ **()**

  Return const mtl4_vector reference

* vec\ **()**

  Return mtl4_vector reference
";

// Documentation extracted from: (module=la, header=SparsityPattern.h)
%feature("docstring")  dolfin::SparsityPattern "
This class implements the GenericSparsityPattern interface.
It is used by most linear algebra backends.
";

%feature("docstring")  dolfin::SparsityPattern::SparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::SparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::SparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::SparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::SparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::SparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range for dimension 0
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_diagonal "
Fill array with number of nonzeros for diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_off_diagonal "
Fill array with number of nonzeros for off-diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for off-diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::SparsityPattern::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::SparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::SparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

// Documentation extracted from: (module=la, header=EpetraSparsityPattern.h)
%feature("docstring")  dolfin::EpetraSparsityPattern "
This class implements the GenericSparsityPattern interface for
the Epetra backend. The common interface is mostly
ignored. Instead, the sparsity pattern is represented as an
Epetra_FECrsGraph and a dynamic_cast is used to retrieve the
underlying representation when creating Epetra matrices.
";

%feature("docstring")  dolfin::EpetraSparsityPattern::EpetraSparsityPattern "
Constructor
";

%feature("docstring")  dolfin::EpetraSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::EpetraSparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::EpetraSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::EpetraSparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::EpetraSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::EpetraSparsityPattern::num_nonzeros "
Return total number of nonzeros in local rows
";

%feature("docstring")  dolfin::EpetraSparsityPattern::num_nonzeros_diagonal "
Fill array with number of nonzeros for diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for diagonal block
";

%feature("docstring")  dolfin::EpetraSparsityPattern::num_nonzeros_off_diagonal "
Fill array with number of nonzeros for off-diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for off-diagonal block
";

%feature("docstring")  dolfin::EpetraSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::EpetraSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::EpetraSparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::EpetraSparsityPattern::pattern "
Return Epetra CRS graph
";

// Documentation extracted from: (module=la, header=LinearAlgebraFactory.h)
%feature("docstring")  dolfin::LinearAlgebraFactory::LinearAlgebraFactory "
Constructor
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_pattern "
Create empty sparsity pattern (returning zero if not used/needed)
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_krylov_solver "
Create Krylov solver
";

// Documentation extracted from: (module=la, header=DefaultFactory.h)
%feature("docstring")  dolfin::DefaultFactory::DefaultFactory "
Constructor
";

%feature("docstring")  dolfin::DefaultFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::DefaultFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::DefaultFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::DefaultFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::DefaultFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::DefaultFactory::create_krylov_solver "
Create Krylov solver
";

// Documentation extracted from: (module=la, header=PETScUserPreconditioner.h)
%feature("docstring")  dolfin::PETScUserPreconditioner "
This class specifies the interface for user-defined Krylov
method PETScPreconditioners. A user wishing to implement her own
PETScPreconditioner needs only supply a function that approximately
solves the linear system given a right-hand side.
";

%feature("docstring")  dolfin::PETScUserPreconditioner::PETScUserPreconditioner "
Constructor
";

%feature("docstring")  dolfin::PETScUserPreconditioner::solve "
Solve linear system approximately for given right-hand side b
";

// Documentation extracted from: (module=la, header=PETScFactory.h)
%feature("docstring")  dolfin::PETScFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::PETScFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::PETScFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::PETScFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::PETScFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::PETScFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::PETScFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::PETScFactory::PETScFactory "
Private constructor
";

// Documentation extracted from: (module=la, header=EpetraFactory.h)
%feature("docstring")  dolfin::EpetraFactory::create_matrix "
--- LinearAlgebraFactory interface
Create empty matrix
";

%feature("docstring")  dolfin::EpetraFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::EpetraFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::EpetraFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::EpetraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::EpetraFactory::create_krylov_solver "
Create Krylov solver
";

// Documentation extracted from: (module=la, header=MTL4Factory.h)
%feature("docstring")  dolfin::MTL4Factory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::MTL4Factory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::MTL4Factory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::MTL4Factory::create_pattern "
Dummy sparsity pattern
";

%feature("docstring")  dolfin::MTL4Factory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::MTL4Factory::create_krylov_solver "
Create Krylov solver
";

// Documentation extracted from: (module=la, header=STLFactory.h)
%feature("docstring")  dolfin::STLFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::STLFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::STLFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::STLFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::STLFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::STLFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::STLFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::STLFactory::STLFactory "
Private Constructor
";

// Documentation extracted from: (module=la, header=SLEPcEigenSolver.h)
%feature("docstring")  dolfin::SLEPcEigenSolver "
This class provides an eigenvalue solver for PETSc matrices.
It is a wrapper for the SLEPc eigenvalue solver.

The following parameters may be specified to control the solver.

1. \"spectrum\"

This parameter controls which part of the spectrum to compute.
Possible values are

  \"largest magnitude\"   (eigenvalues with largest magnitude)
  \"smallest magnitude\"  (eigenvalues with smallest magnitude)
  \"largest real\"        (eigenvalues with largest double part)
  \"smallest real\"       (eigenvalues with smallest double part)
  \"largest imaginary\"   (eigenvalues with largest imaginary part)
  \"smallest imaginary\"  (eigenvalues with smallest imaginary part)

For SLEPc versions >= 3.1 , the following values are also possible

  \"target magnitude\"    (eigenvalues closest to target in magnitude)
  \"target real\"         (eigenvalues closest to target in real part)
  \"target imaginary\"    (eigenvalues closest to target in imaginary part)

The default is \"largest magnitude\"

2. \"solver\"

This parameter controls which algorithm is used by SLEPc.
Possible values are

  \"power\"               (power iteration)
  \"subspace\"            (subspace iteration)
  \"arnoldi\"             (Arnoldi)
  \"lanczos\"             (Lanczos)
  \"krylov-schur\"        (Krylov-Schur)
  \"lapack\"              (LAPACK, all values, direct, small systems only)

The default is \"krylov-schur\"

3. \"tolerance\"

This parameter controls the tolerance used by SLEPc.
Possible values are positive double numbers.

The default is 1e-15;

4. \"maximum_iterations\"

This parameter controls the maximum number of iterations used by SLEPc.
Possible values are positive integers.

Note that both the tolerance and the number of iterations must be
specified if either one is specified.

5. \"problem_type\"

This parameter can be used to give extra information about the
type of the eigenvalue problem. Some solver types require this
extra piece of information. Possible values are:

  \"hermitian\"               (Hermitian)
  \"non_hermitian\"           (Non-Hermitian)
  \"gen_hermitian\"           (Generalized Hermitian)
  \"gen_non_hermitian\"       (Generalized Non-Hermitian)

6. \"spectral_transform\"

This parameter controls the application of a spectral transform. A
spectral transform can be used to enhance the convergence of the
eigensolver and in particular to only compute eigenvalues in the
interior of the spectrum. Possible values are:

  \"shift-and-invert\"      (A shift-and-invert transform)

Note that if a spectral transform is given, then also a non-zero
spectral shift parameter has to be provided.

The default is no spectral transform.

7. \"spectral_shift\"

This parameter controls the spectral shift used by the spectral
transform and must be provided if a spectral transform is given. The
possible values are real numbers.

";

%feature("docstring")  dolfin::SLEPcEigenSolver::SLEPcEigenSolver "
**Overloaded versions**

* SLEPcEigenSolver\ **(A)**

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ **(A, B)**

  Create eigenvalue solver Ax = \lambda Bx

* SLEPcEigenSolver\ **(A)**

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ **(A, B)**

  Create eigenvalue solver for Ax = \lambda x
";

%feature("docstring")  dolfin::SLEPcEigenSolver::solve "
**Overloaded versions**

* solve\ **()**

  Compute all eigenpairs of the matrix A (solve Ax = \lambda x)

* solve\ **(n)**

  Compute the n first eigenpairs of the matrix A (solve Ax = \lambda x)
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenvalue "
**Overloaded versions**

* get_eigenvalue\ **(lr, lc)**

  Get the first eigenvalue

* get_eigenvalue\ **(lr, lc, i)**

  Get eigenvalue i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenpair "
**Overloaded versions**

* get_eigenpair\ **(lr, lc, r, c)**

  Get the first eigenpair

* get_eigenpair\ **(lr, lc, r, c, i)**

  Get eigenpair i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::SLEPcEigenSolver::read_parameters "
Callback for changes in parameter values
";

// Documentation extracted from: (module=la, header=TrilinosPreconditioner.h)
%feature("docstring")  dolfin::TrilinosPreconditioner "
This class is a wrapper for configuring Epetra preconditioners. It does
not own a preconditioner. It can take a EpetraKrylovSolver and set the
preconditioner type and parameters.
";

%feature("docstring")  dolfin::TrilinosPreconditioner::TrilinosPreconditioner "
Create Krylov solver for a particular method and preconditioner
";

%feature("docstring")  dolfin::TrilinosPreconditioner::set "
Set the precondtioner and matrix used in preconditioner
";

%feature("docstring")  dolfin::TrilinosPreconditioner::name "
Return preconditioner name
";

%feature("docstring")  dolfin::TrilinosPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TrilinosPreconditioner::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::TrilinosPreconditioner::set_ml "
Setup the ML precondtioner
";

// Documentation extracted from: (module=la, header=uBLASSparseMatrix.h)
// Documentation extracted from: (module=la, header=uBLASDenseMatrix.h)
// Documentation extracted from: (module=la, header=uBLASPreconditioner.h)
%feature("docstring")  dolfin::uBLASPreconditioner "
This class specifies the interface for preconditioners for the
uBLAS Krylov solver.
";

%feature("docstring")  dolfin::uBLASPreconditioner::uBLASPreconditioner "
Constructor
";

%feature("docstring")  dolfin::uBLASPreconditioner::init "
**Overloaded versions**

* init\ **(P)**

  Initialise preconditioner (sparse matrix)

* init\ **(P)**

  Initialise preconditioner (dense matrix)

* init\ **(P)**

  Initialise preconditioner (virtual matrix)
";

%feature("docstring")  dolfin::uBLASPreconditioner::solve "
Solve linear system (M^-1)Ax = y
";

// Documentation extracted from: (module=la, header=uBLASKrylovSolver.h)
%feature("docstring")  dolfin::uBLASKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b using uBLAS data types.
";

%feature("docstring")  dolfin::uBLASKrylovSolver::uBLASKrylovSolver "
**Overloaded versions**

* uBLASKrylovSolver\ **(solver_type=\"default\", pc_type=\"default\")**

  Create Krylov solver for a particular method and preconditioner

* uBLASKrylovSolver\ **(pc)**

  Create Krylov solver for a particular uBLASPreconditioner

* uBLASKrylovSolver\ **(solver_type, preconditioner)**

  Create Krylov solver for a particular method and uBLASPreconditioner
";

%feature("docstring")  dolfin::uBLASKrylovSolver::set_operator "
Solve the operator (matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "
**Overloaded versions**

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations (dense matrix)

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations (sparse matrix)

* solve\ **(A, x, b)**

  Solve linear system Ax = b and return number of iterations (virtual matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve_krylov "
Select solver and solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveCG "
Solve linear system Ax = b using CG
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveGMRES "
Solve linear system Ax = b using restarted GMRES
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveBiCGStab "
Solve linear system Ax = b using BiCGStab
";

%feature("docstring")  dolfin::uBLASKrylovSolver::select_preconditioner "
Select and create named preconditioner
";

%feature("docstring")  dolfin::uBLASKrylovSolver::read_parameters "
Read solver parameters
";

// Documentation extracted from: (module=la, header=uBLASILUPreconditioner.h)
%feature("docstring")  dolfin::uBLASILUPreconditioner "
This class implements an incomplete LU factorization (ILU)
preconditioner for the uBLAS Krylov solver.
";

%feature("docstring")  dolfin::uBLASILUPreconditioner::uBLASILUPreconditioner "
Constructor
";

%feature("docstring")  dolfin::uBLASILUPreconditioner::solve "
Solve linear system Ax = b approximately
";

// Documentation extracted from: (module=la, header=Vector.h)
%feature("docstring")  dolfin::Vector "
This class provides the default DOLFIN vector class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Vector::Vector "
**Overloaded versions**

* Vector\ **()**

  Create empty vector

* Vector\ **(N)**

  Create vector of size N

* Vector\ **(x)**

  Copy constructor

* Vector\ **(x)**

  Create a Vector from a GenericVetor
";

%feature("docstring")  dolfin::Vector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::Vector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Vector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Vector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Vector::resize "
**Overloaded versions**

* resize\ **(N)**

  Resize vector to size N

* resize\ **(std::pair<uint, range)**

  Resize vector with given ownership range

* resize\ **(std::pair<uint, range, ghost_indices)**

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::Vector::size "
Return size of vector
";

%feature("docstring")  dolfin::Vector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::Vector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::Vector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::Vector::get_local "
**Overloaded versions**

* get_local\ **(block, m, rows)**

  Get block of values (values must all live on the local process)

* get_local\ **(values)**

  Get all values on local process
";

%feature("docstring")  dolfin::Vector::set "
Set block of values
";

%feature("docstring")  dolfin::Vector::add "
Add block of values
";

%feature("docstring")  dolfin::Vector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::Vector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::Vector::gather "
**Overloaded versions**

* gather\ **(x, indices)**

  Gather entries into local vector x

* gather\ **(x, indices)**

  Gather entries into Array x
";

%feature("docstring")  dolfin::Vector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::Vector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::Vector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::Vector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::Vector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::Vector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::Vector::sum "
Return sum of values of vector
";

%feature("docstring")  dolfin::Vector::operator*= "
**Overloaded versions**

* operator*=\ **(a)**

  Multiply vector by given number

* operator*=\ **(x)**

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::Vector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::Vector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::Vector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::Vector::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(a)**

  Assignment operator

* operator=\ **(x)**

  Assignment operator
";

%feature("docstring")  dolfin::Vector::data "
**Overloaded versions**

* data\ **()**

  Return pointer to underlying data (const version)

* data\ **()**

  Return pointer to underlying data
";

%feature("docstring")  dolfin::Vector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Vector::instance "
**Overloaded versions**

* instance\ **()**

  Return concrete instance / unwrap (const version)

* instance\ **()**

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Matrix.h)
%feature("docstring")  dolfin::Matrix "
This class provides the default DOLFIN matrix class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Matrix::Matrix "
**Overloaded versions**

* Matrix\ **()**

  Create empty matrix

* Matrix\ **(A)**

  Copy constructor
";

%feature("docstring")  dolfin::Matrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::Matrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::Matrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Matrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Matrix::zero "
**Overloaded versions**

* zero\ **()**

  Set all entries to zero and keep any sparse structure

* zero\ **(m, rows)**

  Set given rows to zero
";

%feature("docstring")  dolfin::Matrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Matrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Matrix::resize "
Resize vector y such that is it compatible with matrix for
multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::Matrix::get "
Get block of values
";

%feature("docstring")  dolfin::Matrix::set "
Set block of values
";

%feature("docstring")  dolfin::Matrix::add "
Add block of values
";

%feature("docstring")  dolfin::Matrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::Matrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::Matrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::Matrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::Matrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::Matrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator= "
**Overloaded versions**

* operator=\ **(A)**

  Assignment operator

* operator=\ **(A)**

  Assignment operator
";

%feature("docstring")  dolfin::Matrix::data "
Return pointers to underlying compressed storage data.
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::Matrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Matrix::instance "
**Overloaded versions**

* instance\ **()**

  Return concrete instance / unwrap (const version)

* instance\ **()**

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Scalar.h)
%feature("docstring")  dolfin::Scalar "
This class represents a real-valued scalar quantity and
implements the GenericTensor interface for scalars.
";

%feature("docstring")  dolfin::Scalar::Scalar "
Create zero scalar
";

%feature("docstring")  dolfin::Scalar::resize "
Resize tensor to given dimensions
";

%feature("docstring")  dolfin::Scalar::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::Scalar::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::Scalar::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::Scalar::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Scalar::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Scalar::get "
Get block of values
";

%feature("docstring")  dolfin::Scalar::set "
Set block of values
";

%feature("docstring")  dolfin::Scalar::add "
**Overloaded versions**

* add\ **(block, num_rows, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values

* add\ **(block, rows)**

  Add block of values
";

%feature("docstring")  dolfin::Scalar::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Scalar::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Scalar::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Scalar::operator double "
Cast to real
";

%feature("docstring")  dolfin::Scalar::operator= "
Assignment from real
";

%feature("docstring")  dolfin::Scalar::factory "
Return a factory for the default linear algebra backend
";

%feature("docstring")  dolfin::Scalar::getval "
Get value
";

// Documentation extracted from: (module=la, header=LinearSolver.h)
%feature("docstring")  dolfin::LinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::LinearSolver::LinearSolver "
Create linear solver
";

%feature("docstring")  dolfin::LinearSolver::set_operator "
Set the operator (matrix)
";

%feature("docstring")  dolfin::LinearSolver::set_operators "
Set the operator (matrix) and preconitioner matrix
";

%feature("docstring")  dolfin::LinearSolver::get_operator "
Get the operator (matrix)
";

%feature("docstring")  dolfin::LinearSolver::solve "
**Overloaded versions**

* solve\ **(A, x, b)**

  Solve linear system Ax = b

* solve\ **(x, b)**

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::LinearSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=KrylovSolver.h)
%feature("docstring")  dolfin::KrylovSolver "
This class defines an interface for a Krylov solver. The approproiate solver
is chosen on the basis of the matrix/vector type.
";

%feature("docstring")  dolfin::KrylovSolver::KrylovSolver "
Create Krylov solver
";

%feature("docstring")  dolfin::KrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::KrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::KrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::KrylovSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::KrylovSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=LUSolver.h)
%feature("docstring")  dolfin::LUSolver::LUSolver "
Constructor
";

%feature("docstring")  dolfin::LUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::LUSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::LUSolver::solve "
**Overloaded versions**

* solve\ **(x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b)**

  Solve linear system
";

%feature("docstring")  dolfin::LUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=SingularSolver.h)
%feature("docstring")  dolfin::SingularSolver "
This class provides a linear solver for singular linear systems
Ax = b where A has a one-dimensional null-space (kernel). This
may happen for example when solving Poisson's equation with
pure Neumann boundary conditions.

The solver attempts to create an extended non-singular system
by adding the constraint [1, 1, 1, ...]^T x = 0.

If an optional mass matrix M is supplied, the solver attempts
to create an extended non-singular system by adding the
constraint m^T x = 0 where m is the lumped mass matrix. This
corresponds to setting the average (integral) of the finite
element function with coefficients x to zero.

The solver makes not attempt to check that the null-space is
indeed one-dimensional. It is also assumed that the system
Ax = b retains its sparsity pattern between calls to solve().
";

%feature("docstring")  dolfin::SingularSolver::SingularSolver "
Create linear solver
";

%feature("docstring")  dolfin::SingularSolver::solve "
**Overloaded versions**

* solve\ **(A, x, b)**

  Solve linear system Ax = b

* solve\ **(A, x, b, M)**

  Solve linear system Ax = b using mass matrix M for setting constraint
";

%feature("docstring")  dolfin::SingularSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=solve.h)
%feature("docstring")  dolfin::solve "
Solve linear system Ax = b
";

%feature("docstring")  dolfin::residual "
Compute residual ||Ax - b||
";

%feature("docstring")  dolfin::normalize "
Normalize vector according to given normalization type
";

// Documentation extracted from: (module=la, header=BlockVector.h)
%feature("docstring")  dolfin::BlockVector::BlockVector "
Constructor
";

%feature("docstring")  dolfin::BlockVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::BlockVector::set_block "
Set function
";

%feature("docstring")  dolfin::BlockVector::get_block "
**Overloaded versions**

* get_block\ **(i)**

  Get sub-vector (const)

* get_block\ **(uint)**

  Get sub-vector (non-const)
";

%feature("docstring")  dolfin::BlockVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::BlockVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::BlockVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::BlockVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::BlockVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::BlockVector::operator*= "
Multiply vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::BlockVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::BlockVector::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(a)**

  Assignment operator
";

%feature("docstring")  dolfin::BlockVector::size "
Number of vectors
";

%feature("docstring")  dolfin::BlockVector::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=BlockMatrix.h)
%feature("docstring")  dolfin::BlockMatrix::set_block "
Set block
";

%feature("docstring")  dolfin::BlockMatrix::get_block "
**Overloaded versions**

* get_block\ **(i, j)**

  Get block (const version)

* get_block\ **(i, j)**

  Get block
";

%feature("docstring")  dolfin::BlockMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::BlockMatrix::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::BlockMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::BlockMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::BlockMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::BlockMatrix::schur_approximation "
Create a crude explicit Schur approximation of S = D - C A^-1 B of (A B; C D)
If symmetry != 0, then the caller promises that B = symmetry * transpose(C).
";

// Documentation extracted from: (module=graph, header=MatrixRenumbering.h)
%feature("docstring")  dolfin::MatrixRenumbering "
This class computes re-ordering based on a SparsityPattern graph
representation of a sparse matrix. It uses Zoltan, which is part of
Trilinos.
";

%feature("docstring")  dolfin::MatrixRenumbering::num_global_objects "
Number of global graph vertices
";

%feature("docstring")  dolfin::MatrixRenumbering::num_local_objects "
Number of local graph vertices
";

%feature("docstring")  dolfin::MatrixRenumbering::num_edges_per_vertex "
Number of edges per vertex
";

%feature("docstring")  dolfin::MatrixRenumbering::edges "
Vertex edges
";

// Documentation extracted from: (module=ale, header=ALEType.h)
// Documentation extracted from: (module=ale, header=ALE.h)
%feature("docstring")  dolfin::ALE "
This class provides functionality useful for implementation of
ALE (Arbitrary Lagrangian-Eulerian) methods, in particular
moving the boundary vertices of a mesh and then interpolating
the new coordinates for the interior vertices accordingly.
";

%feature("docstring")  dolfin::ALE::move "
**Overloaded versions**

* move\ **(mesh, new_boundary, method=lagrange)**

  Move coordinates of mesh according to new boundary coordinates

* move\ **(mesh0, mesh1, method=lagrange)**

  Move coordinates of mesh0 according to mesh1 with common global vertices

* move\ **(mesh, displacement)**

  Move coordinates of mesh according to displacement function
";

// Documentation extracted from: (module=refinement, header=refine.h)
%feature("docstring")  dolfin::refine "
**Overloaded versions**

* refine\ **(mesh)**

  Create uniformly refined mesh

* refine\ **(refined_mesh, mesh)**

  Create uniformly refined mesh

* refine\ **(mesh, cell_markers)**

  Create locally refined mesh

* refine\ **(refined_mesh, mesh, cell_markers)**

  Create locally refined mesh
";

// Documentation extracted from: (module=quadrature, header=Quadrature.h)
%feature("docstring")  dolfin::Quadrature::Quadrature "
Constructor
";

%feature("docstring")  dolfin::Quadrature::size "
Return number of quadrature points
";

%feature("docstring")  dolfin::Quadrature::point "
Return quadrature point
";

%feature("docstring")  dolfin::Quadrature::weight "
Return quadrature weight
";

%feature("docstring")  dolfin::Quadrature::measure "
Return sum of weights (length, area, volume)
";

// Documentation extracted from: (module=quadrature, header=GaussianQuadrature.h)
%feature("docstring")  dolfin::GaussianQuadrature "
Gaussian-type quadrature rule on the double line,
including Gauss, Radau, and Lobatto quadrature.

Points and weights are computed to be exact within a tolerance
of DOLFIN_EPS. Comparing with known exact values for n <= 3 shows
that we obtain full precision (16 digits, error less than 2e-16).
";

// Documentation extracted from: (module=quadrature, header=GaussQuadrature.h)
%feature("docstring")  dolfin::GaussQuadrature "
Gauss (Gauss-Legendre) quadrature on the interval [-1,1].
The n quadrature points are given by the zeros of the
n:th Legendre Pn(x).

The quadrature points are computed using Newton's method, and
the quadrature weights are computed by solving a linear system
determined by the condition that Gauss quadrature with n points
should be exact for polynomials of degree 2n-1.
";

%feature("docstring")  dolfin::GaussQuadrature::GaussQuadrature "
Create Gauss quadrature with n points
";

%feature("docstring")  dolfin::GaussQuadrature::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=quadrature, header=RadauQuadrature.h)
%feature("docstring")  dolfin::RadauQuadrature "
Radau (Gauss-Radau) quadrature on the interval [-1,1].
The n quadrature points are given by the zeros of

    ( Pn-1(x) + Pn(x) ) / (1+x)

where Pn is the n:th Legendre polynomial.

The quadrature points are computed using Newton's method, and
the quadrature weights are computed by solving a linear system
determined by the condition that Radau quadrature with n points
should be exact for polynomials of degree 2n-2.
";

%feature("docstring")  dolfin::RadauQuadrature::RadauQuadrature "
Create Radau quadrature with n points
";

%feature("docstring")  dolfin::RadauQuadrature::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=quadrature, header=LobattoQuadrature.h)
%feature("docstring")  dolfin::LobattoQuadrature "
Lobatto (Gauss-Lobatto) quadrature on the interval [-1,1].
The n quadrature points are given by the end-points -1 and 1,
and the zeros of P{n-1}'(x), where P{n-1}(x) is the (n-1):th
Legendre polynomial.

The quadrature points are computed using Newton's method, and
the quadrature weights are computed by solving a linear system
determined by the condition that Lobatto quadrature with n points
should be exact for polynomials of degree 2n-3.
";

%feature("docstring")  dolfin::LobattoQuadrature::LobattoQuadrature "
Create Lobatto quadrature with n points
";

%feature("docstring")  dolfin::LobattoQuadrature::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=quadrature, header=BarycenterQuadrature.h)
%feature("docstring")  dolfin::BarycenterQuadrature "
This class computes the barycenter of an arbitrary polyhedron or
polygon in 3D and therefore allows for barycenter quadrature on
complex polyhedrons. Note: barycenter quadrature is exact for
polynom deg <= 1.
";

%feature("docstring")  dolfin::BarycenterQuadrature::BarycenterQuadrature "
Create barycenter quadrature rule for given polyhedron
";

%feature("docstring")  dolfin::BarycenterQuadrature::points "
Return points
";

%feature("docstring")  dolfin::BarycenterQuadrature::weights "
Return weights
";

%feature("docstring")  dolfin::BarycenterQuadrature::size "
Return number of quadrature points/weights
";

%feature("docstring")  dolfin::BarycenterQuadrature::compute_quadrature "
Computes barycenter and weight.
";

// Documentation extracted from: (module=mesh, header=CellType.h)
%feature("docstring")  dolfin::CellType "
This class provides a common interface for different cell types.
Each cell type implements mesh functionality that is specific to
a certain type of cell.
";

%feature("docstring")  dolfin::CellType::CellType "
Constructor
";

%feature("docstring")  dolfin::CellType::create "
**Overloaded versions**

* create\ **(type)**

  Create cell type from type (factory function)

* create\ **(type)**

  Create cell type from string (factory function)
";

%feature("docstring")  dolfin::CellType::string2type "
Convert from string to cell type
";

%feature("docstring")  dolfin::CellType::type2string "
Convert from cell type to string
";

%feature("docstring")  dolfin::CellType::cell_type "
Return type of cell
";

%feature("docstring")  dolfin::CellType::facet_type "
Return type of cell for facets
";

%feature("docstring")  dolfin::CellType::dim "
Return topological dimension of cell
";

%feature("docstring")  dolfin::CellType::num_entities "
Return number of entitites of given topological dimension
";

%feature("docstring")  dolfin::CellType::num_vertices "
Return number of vertices for entity of given topological dimension
";

%feature("docstring")  dolfin::CellType::orientation "
Return orientation of the cell
";

%feature("docstring")  dolfin::CellType::create_entities "
Create entities e of given topological dimension from vertices v
";

%feature("docstring")  dolfin::CellType::refine_cell "
Refine cell uniformly
";

%feature("docstring")  dolfin::CellType::volume "
Compute (generalized) volume of mesh entity
";

%feature("docstring")  dolfin::CellType::diameter "
Compute diameter of mesh entity
";

%feature("docstring")  dolfin::CellType::normal "
**Overloaded versions**

* normal\ **(cell, facet, i)**

  Compute component i of normal of given facet with respect to the cell

* normal\ **(cell, facet)**

  Compute of given facet with respect to the cell
";

%feature("docstring")  dolfin::CellType::facet_area "
Compute the area/length of given facet with respect to the cell
";

%feature("docstring")  dolfin::CellType::order "
Order entities locally
";

%feature("docstring")  dolfin::CellType::ordered "
Check if entities are ordered
";

%feature("docstring")  dolfin::CellType::description "
Return description of cell type
";

// Documentation extracted from: (module=mesh, header=MeshTopology.h)
%feature("docstring")  dolfin::MeshTopology "
MeshTopology stores the topology of a mesh, consisting of mesh entities
and connectivity (incidence relations for the mesh entities). Note that
the mesh entities don't need to be stored, only the number of entities
and the connectivity. Any numbering scheme for the mesh entities is
stored separately in a MeshFunction over the entities.

A mesh entity e may be identified globally as a pair e = (dim, i), where
dim is the topological dimension and i is the index of the entity within
that topological dimension.
";

%feature("docstring")  dolfin::MeshTopology::MeshTopology "
**Overloaded versions**

* MeshTopology\ **()**

  Create empty mesh topology

* MeshTopology\ **(topology)**

  Copy constructor
";

%feature("docstring")  dolfin::MeshTopology::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshTopology::dim "
Return topological dimension
";

%feature("docstring")  dolfin::MeshTopology::size "
Return number of entities for given dimension
";

%feature("docstring")  dolfin::MeshTopology::clear "
**Overloaded versions**

* clear\ **()**

  Clear all data

* clear\ **(d0, d1)**

  Clear data for given pair of topological dimensions
";

%feature("docstring")  dolfin::MeshTopology::init "
**Overloaded versions**

* init\ **(dim)**

  Initialize topology of given maximum dimension

* init\ **(dim, size)**

  Set number of entities (size) for given topological dimension
";

%feature("docstring")  dolfin::MeshTopology::operator "
**Overloaded versions**

* operator\ **(d0, d1)**

  Return connectivity for given pair of topological dimensions

* operator\ **(d0, d1)**

  Return connectivity for given pair of topological dimensions
";

%feature("docstring")  dolfin::MeshTopology::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshGeometry.h)
%feature("docstring")  dolfin::MeshGeometry::MeshGeometry "
**Overloaded versions**

* MeshGeometry\ **()**

  Create empty set of coordinates

* MeshGeometry\ **(geometry)**

  Copy constructor
";

%feature("docstring")  dolfin::MeshGeometry::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshGeometry::dim "
Return Euclidean dimension of coordinate system
";

%feature("docstring")  dolfin::MeshGeometry::size "
Return number of coordinates
";

%feature("docstring")  dolfin::MeshGeometry::x "
**Overloaded versions**

* x\ **(n, i)**

  Return value of coordinate n in direction i

* x\ **(n, i)**

  Return value of coordinate n in direction i

* x\ **(n)**

  Return array of values for coordinate n

* x\ **(n)**

  Return array of values for coordinate n

* x\ **()**

  Return array of values for all coordinates

* x\ **()**

  Return array of values for all coordinates
";

%feature("docstring")  dolfin::MeshGeometry::higher_order_x "
**Overloaded versions**

* higher_order_x\ **(n)**

  Return array of values for higher order coordinate n

* higher_order_x\ **(n)**

  Return array of values for higher order coordinate n

* higher_order_x\ **()**

  Return array of values for all higher order coordinates

* higher_order_x\ **()**

  Return array of values for all higher order coordinates
";

%feature("docstring")  dolfin::MeshGeometry::num_higher_order_vertices_per_cell "
Return number of vertices used (per cell) to represent the higher order geometry
";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cell "
**Overloaded versions**

* higher_order_cell\ **(c)**

  Return array of higher order vertex indices for a specific higher order cell

* higher_order_cell\ **(c)**

  Return array of higher order vertex indices for a specific higher order cell
";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cells "
**Overloaded versions**

* higher_order_cells\ **()**

  Return array of values for all higher order cell data

* higher_order_cells\ **()**

  Return array of values for all higher order cell data
";

%feature("docstring")  dolfin::MeshGeometry::point "
Return coordinate n as a 3D point value
";

%feature("docstring")  dolfin::MeshGeometry::affine_cell_bool "
Return pointer to boolean affine indicator array
";

%feature("docstring")  dolfin::MeshGeometry::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshGeometry::init "
Initialize coordinate list to given dimension and size
";

%feature("docstring")  dolfin::MeshGeometry::init_higher_order_vertices "
Initialize higher order coordinate list to given dimension and size
";

%feature("docstring")  dolfin::MeshGeometry::init_higher_order_cells "
Initialize higher order cell data list to given number of cells and dofs
";

%feature("docstring")  dolfin::MeshGeometry::init_affine_indicator "
Initialize the affine indicator array
";

%feature("docstring")  dolfin::MeshGeometry::set_affine_indicator "
set affine indicator at index i
";

%feature("docstring")  dolfin::MeshGeometry::set "
Set value of coordinate n in direction i
";

%feature("docstring")  dolfin::MeshGeometry::set_higher_order_coordinates "
Set value of higher order coordinate N in direction i
";

%feature("docstring")  dolfin::MeshGeometry::set_higher_order_cell_data "
Set higher order cell data for cell # N in direction i
";

%feature("docstring")  dolfin::MeshGeometry::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshData.h)
%feature("docstring")  dolfin::MeshData "
The class MeshData is a container for auxiliary mesh data,
represented either as MeshFunctions over topological mesh
entities, arrays or maps. Each dataset is identified by a unique
user-specified string. Only uint-valued data are currently
supported.

The following named mesh data are recognized by DOLFIN:

Boundary indicators

  \"boundary_facet_cells\"   - Array<uint> of size num_facets
  \"boundary_facet_numbers\" - Array<uint> of size num_facets
  \"boundary_indicators\"    - Array<uint> of size num_facets
  \"material_indicators\"    - MeshFunction<uint> of dimension D

Subdomain indicators

  \"cell_domains\"           - MeshFunction<uint> of dimension D
  \"interior_facet_domains\" - MeshFunction<uint> of dimension D - 1
  \"exterior_facet_domains\" - MeshFunction<uint> of dimension D - 1

Facet orientation (used for assembly over interior facets)

  \"facet orientation\" - MeshFunction<uint> of dimension D - 1

Boundary extraction

  \"vertex map\" - MeshFunction<uint> of dimension 0
  \"cell map\"   - MeshFunction<uint> of dimension D

Mesh partitioning

  (moved to ParallelData) \"global entity indices %d\" - MeshFunction<uint> of dimension 0, 1, ..., D
  (moved to ParallelData) \"exterior facets\"          - MeshFunction<uint> of dimension D - 1
  (moved to ParallelData) \"num global entities\"      - Array<uint> of size D + 1
  (moved to ParallelData) \"overlap\"                  - vector mapping

Sub meshes

  \"global vertex indices\" - MeshFunction<uint> of dimension 0

Mesh coloring

  \"colors-%D-%d-%1\"   - MeshFunction<uint> of dimension D with colors based on connectivity %d
  \"num colored cells\" - Array<uint> listing the number of cells of each color
  \"colored cells %d\"  - Array<uint> of cell indices with colors 0, 1, 2, ...
";

%feature("docstring")  dolfin::MeshData::MeshData "
Constructor
";

%feature("docstring")  dolfin::MeshData::operator= "
Assignment operator
";

%feature("docstring")  dolfin::MeshData::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshData::create_mesh_function "
**Overloaded versions**

* create_mesh_function\ **(name)**

  Create MeshFunction with given name (uninitialized)

* create_mesh_function\ **(name, dim)**

  Create MeshFunction with given name and dimension
";

%feature("docstring")  dolfin::MeshData::create_array "
**Overloaded versions**

* create_array\ **(name)**

  Create empty array (vector) with given name

* create_array\ **(name, size)**

  Create array (vector) with given name and size
";

%feature("docstring")  dolfin::MeshData::create_mapping "
Create mapping from uint to uint with given name
";

%feature("docstring")  dolfin::MeshData::create_vector_mapping "
Create mapping from uint to vector of uint with given name
";

%feature("docstring")  dolfin::MeshData::mesh_function "
Return MeshFunction with given name (returning zero if data is not available)
";

%feature("docstring")  dolfin::MeshData::array "
**Overloaded versions**

* array\ **(name)**

  Return array with given name (returning zero if data is not available)

* array\ **(name, number)**

  Return array with given name postfixed by \" %d\" (returning zero if data is not available)
";

%feature("docstring")  dolfin::MeshData::mapping "
Return mapping with given name (returning zero if data is not available)
";

%feature("docstring")  dolfin::MeshData::vector_mapping "
Return vector mapping with given name (returning zero if data is not available)
";

%feature("docstring")  dolfin::MeshData::erase_mesh_function "
Erase MeshFunction with given name
";

%feature("docstring")  dolfin::MeshData::erase_array "
Erase array with given name
";

%feature("docstring")  dolfin::MeshData::erase_mapping "
Erase mapping with given name
";

%feature("docstring")  dolfin::MeshData::erase_vector_mapping "
Erase vector mapping with given name
";

%feature("docstring")  dolfin::MeshData::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=IntersectionOperator.h)
%feature("docstring")  dolfin::IntersectionOperator::IntersectionOperator "
Create intersection detector for the mesh \em mesh.
@param kernel_type The CGAL geometric kernel is used to compute predicates,
intersections and such. Depending on this choice the kernel
(kernel_type = \"ExcactPredicates\") can compute predicates excactly
(without roundoff error) or only approximately (default, kernel_type =
\"SimpleCartesian\").
";

%feature("docstring")  dolfin::IntersectionOperator::all_intersected_entities "
**Overloaded versions**

* all_intersected_entities\ **(point, ids_result)**

  Compute all id of all cells which are intersects by a \em point.
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ **(points, ids_result)**

  Compute all id of all cells which are intersects any point in \em points.
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ **(entity, ids_result)**

  Compute all id of all cells which are intersects by a \em entity.
  \param[out] ids_result The ids of the intersected entities are saved in a vector.
  This allows is more efficent than using a set and allows a map between
  the (external) cell and the intersected cell of the mesh. If you
  are only interested in intersection with a list of cells without caring about which
  cell what intersected by which one, use
  void IntersectionOperator::all_intersected_entities(const std::vector<Cell> &, uint_set &) const;
  @internal
  @todo This function has to improved: 1) it requires the object the
  mesh is to be cut with to be another mesh entitiy instead of being just a
  kind of geometric object. 2) Requires a runtime switch 3) would require a
  implementation for each geometric  primitive if they have no common base
  class.

* all_intersected_entities\ **(entities, ids_result)**

  Compute all id of all cells which are intersects by any of the entities in \em entities. This
  \param[out] ids_result The ids of the intersected set are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ **(another_mesh, ids_result)**

  Compute all id of all cells which are intersects by the given mesh \em another_mesh;
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.
";

%feature("docstring")  dolfin::IntersectionOperator::any_intersected_entity "
Computes only the first id of the entity, which contains the point. Returns -1 if no cell is intersected.
@internal @remark This makes the function evaluation significantly faster.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_point "
Computes the point inside the mesh which is closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_cell "
Computes the index of the cell inside the mesh which are closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_point_and_cell "
Computes the point inside the mesh and the corresponding cell index
that are closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::reset_kernel "
Rebuilds the underlying search structure from scratch and uses
the kernel kernel_type underlying CGAL Geometry kernel.
";

%feature("docstring")  dolfin::IntersectionOperator::clear "
Clears search structure. Should be used if the mesh has changed
";

// Documentation extracted from: (module=mesh, header=Mesh.h)
%feature("docstring")  dolfin::Mesh "
A :py:class:`Mesh` consists of a set of connected and numbered mesh entities.

Both the representation and the interface are
dimension-independent, but a concrete interface is also provided
for standard named mesh entities:

.. tabularcolumns:: |c|c|c|

+--------+-----------+-------------+
| Entity | Dimension | Codimension |
+========+===========+=============+
| Vertex |  0        |             |
+--------+-----------+-------------+
| Edge   |  1        |             |
+--------+-----------+-------------+
| Face   |  2        |             |
+--------+-----------+-------------+
| Facet  |           |      1      |
+--------+-----------+-------------+
| Cell   |           |      0      |
+--------+-----------+-------------+

When working with mesh iterators, all entities and connectivity
are precomputed automatically the first time an iterator is
created over any given topological dimension or connectivity.

Note that for efficiency, only entities of dimension zero
(vertices) and entities of the maximal dimension (cells) exist
when creating a :py:class:`Mesh`. Other entities must be explicitly created
by calling init(). For example, all edges in a mesh may be
created by a call to mesh.init(1). Similarly, connectivities
such as all edges connected to a given vertex must also be
explicitly created (in this case by a call to mesh.init(0, 1)).
";

%feature("docstring")  dolfin::Mesh::Mesh "
**Overloaded versions**

* Mesh\ **()**

  Create empty mesh

* Mesh\ **(mesh)**

  Copy constructor.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          Object to be copied.

* Mesh\ **(filename)**

  Create mesh from data file.
  
  *Arguments*
      filename (str)
          Name of file to load.
";

%feature("docstring")  dolfin::Mesh::operator= "
Assignment operator

*Arguments*
    mesh (:py:class:`Mesh`)
        Another :py:class:`Mesh` object.
";

%feature("docstring")  dolfin::Mesh::num_vertices "
Get number of vertices in mesh.

*Returns*
    int
        Number of vertices.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_vertices()
        9
";

%feature("docstring")  dolfin::Mesh::num_edges "
Get number of edges in mesh.

*Returns*
    int
        Number of edges.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_edges()
        0
        >>> mesh.init(1)
        16
        >>> mesh.num_edges()
        16
";

%feature("docstring")  dolfin::Mesh::num_faces "
Get number of faces in mesh.

*Returns*
    int
        Number of faces.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_faces()
        8
";

%feature("docstring")  dolfin::Mesh::num_facets "
Get number of facets in mesh.

*Returns*
    int
        Number of facets.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_facets()
        0
        >>> mesh.init(0,1)
        >>> mesh.num_facets()
        16
";

%feature("docstring")  dolfin::Mesh::num_cells "
Get number of cells in mesh.

*Returns*
    int
        Number of cells.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_cells()
        8
";

%feature("docstring")  dolfin::Mesh::num_entities "
Get number of entities of given topological dimension.

*Arguments*
    d (int)
        Topological dimension.

*Returns*
    int
        Number of entities of topological dimension d.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.init(0,1)
        >>> mesh.num_entities(0)
        9
        >>> mesh.num_entities(1)
        16
        >>> mesh.num_entities(2)
        8
";

%feature("docstring")  dolfin::Mesh::coordinates "
**Overloaded versions**

* coordinates\ **()**

  Get vertex coordinates.
  
  *Returns*
      numpy.array(float)
          Coordinates of all vertices.
  
  *Example*
      .. code-block:: python
      
          >>> mesh = dolfin.UnitSquare(1,1)
          >>> mesh.coordinates()
          array([[ 0.,  0.],
                 [ 1.,  0.],
                 [ 0.,  1.],
                 [ 1.,  1.]])

* coordinates\ **()**

  Return coordinates of all vertices (const version).
";

%feature("docstring")  dolfin::Mesh::cells "
Get cell connectivity.

*Returns*
    numpy.array(int)
        Connectivity for all cells.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(1,1)
        >>> mesh.cells()
        array([[0, 1, 3],
              [0, 2, 3]])
";

%feature("docstring")  dolfin::Mesh::size "
Get number of entities of given topological dimension.

*Arguments*
    dim (int)
        Topological dimension.

*Returns*
    int
        Number of entities of topological dimension d.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.init(0,1)
        >>> mesh.size(0)
        9
        >>> mesh.size(1)
        16
        >>> mesh.size(2)
        8
";

%feature("docstring")  dolfin::Mesh::topology "
**Overloaded versions**

* topology\ **()**

  Get topology associated with mesh.
  
  *Returns*
      :py:class:`MeshTopology`
          The topology object associated with the mesh.

* topology\ **()**

  Get mesh topology (const version).
";

%feature("docstring")  dolfin::Mesh::geometry "
**Overloaded versions**

* geometry\ **()**

  Get mesh geometry.
  
  *Returns*
      :py:class:`MeshGeometry`
          The geometry object associated with the mesh.

* geometry\ **()**

  Get mesh geometry (const version).
";

%feature("docstring")  dolfin::Mesh::id "
Get unique mesh identifier.

*Returns*
    _uint_
        The unique integer identifier associated with the mesh.
";

%feature("docstring")  dolfin::Mesh::intersection_operator "
**Overloaded versions**

* intersection_operator\ **()**

  Get intersection operator.
  
  *Returns*
      :py:class:`IntersectionOperator`
          The intersection operator object associated with the mesh.

* intersection_operator\ **()**

  Return intersection operator (const version);
";

%feature("docstring")  dolfin::Mesh::data "
**Overloaded versions**

* data\ **()**

  Get mesh data.
  
  *Returns*
      :py:class:`MeshData`
          The mesh data object associated with the mesh.

* data\ **()**

  Get mesh data (const version).
";

%feature("docstring")  dolfin::Mesh::parallel_data "
**Overloaded versions**

* parallel_data\ **()**

  Get parallel mesh data.
  
  *Returns*
      _ParallelData_
          The parallel data object associated with the mesh.

* parallel_data\ **()**

  Get parallel mesh data (const version).
";

%feature("docstring")  dolfin::Mesh::type "
**Overloaded versions**

* type\ **()**

  Get mesh cell type.
  
  *Returns*
      :py:class:`CellType`
          The cell type object associated with the mesh.

* type\ **()**

  Get mesh cell type (const version).
";

%feature("docstring")  dolfin::Mesh::init "
**Overloaded versions**

* init\ **(dim)**

  Compute entities of given topological dimension.
  
  *Arguments*
      dim (int)
          Topological dimension.
  
  *Returns*
      int
          Number of created entities.

* init\ **(d0, d1)**

  Compute connectivity between given pair of dimensions.
  
  *Arguments*
      d0 (int)
          Topological dimension.
  
      d1 (int)
          Topological dimension.

* init\ **()**

  Compute all entities and connectivity.
";

%feature("docstring")  dolfin::Mesh::clear "
Clear all mesh data.
";

%feature("docstring")  dolfin::Mesh::clean "
Clean out all auxiliary topology data. This clears all
topological data, except the connectivity between cells and
vertices.
";

%feature("docstring")  dolfin::Mesh::order "
Order all mesh entities.

.. seealso::

    UFC documentation (put link here!)
";

%feature("docstring")  dolfin::Mesh::ordered "
Check if mesh is ordered according to the UFC numbering convention.

*Returns*
    bool
        The return values is true iff the mesh is ordered.
";

%feature("docstring")  dolfin::Mesh::move "
**Overloaded versions**

* move\ **(boundary, method=hermite)**

  Move coordinates of mesh according to new boundary coordinates.
  
  *Arguments*
      boundary (:py:class:`BoundaryMesh`)
          A mesh containing just the boundary cells.
  
      method (int)
          Method which defines how the coordinates should be
          moved, default is *hermite*.

* move\ **(mesh, method=hermite)**

  Move coordinates of mesh according to adjacent mesh with common global
  vertices.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          A :py:class:`Mesh` object.
  
      method (int)
          Method which defines how the coordinates should be
          moved, default is *hermite*.

* move\ **(displacement)**

  Move coordinates of mesh according to displacement function.
  
  *Arguments*
      displacement (:py:class:`Function`)
          A :py:class:`Function` object.
";

%feature("docstring")  dolfin::Mesh::smooth "
Smooth internal vertices of mesh by local averaging.

*Arguments*
    num_iterations (int)
        Number of iterations to perform smoothing,
        default value is 1.
";

%feature("docstring")  dolfin::Mesh::smooth_boundary "
Smooth boundary vertices of mesh by local averaging.

*Arguments*
    num_iterations (int)
        Number of iterations to perform smoothing,
        default value is 1.

    harmonic_smoothing (bool)
        Flag to turn on harmonics smoothing, default
        value is true.
";

%feature("docstring")  dolfin::Mesh::snap_boundary "
Snap boundary vertices of mesh to match given sub domain.

*Arguments*
    sub_domain (:py:class:`SubDomain`)
        A :py:class:`SubDomain` object.

    harmonic_smoothing (bool)
        Flag to turn on harmonics smoothing, default
        value is true.
";

%feature("docstring")  dolfin::Mesh::color "
**Overloaded versions**

* color\ **(coloring_type)**

  Color the cells of the mesh such that no two neighboring cells
  share the same color. A colored mesh keeps a
  CellFunction<unsigned int> named \"cell colors\" as mesh data which
  holds the colors of the mesh.
  
  *Arguments*
      coloring_type (str)
          Coloring type, specifying what relation makes two
          cells neighbors, can be one of \"vertex\", \"edge\" or
          \"facet\".
  
  *Returns*
      MeshFunction<unsigned int>
          The colors as a mesh function over the cells of the mesh.

* color\ **(coloring_type)**

  Color the cells of the mesh such that no two neighboring cells
  share the same color. A colored mesh keeps a
  CellFunction<unsigned int> named \"cell colors\" as mesh data which
  holds the colors of the mesh.
  
  *Arguments*
      coloring_type (numpy.array(int))
          Coloring type given as list of topological dimensions,
          specifying what relation makes two mesh entinties neighbors.
  
  *Returns*
      MeshFunction<unsigned int>
          The colors as a mesh function over entities of the mesh.
";

%feature("docstring")  dolfin::Mesh::all_intersected_entities "
**Overloaded versions**

* all_intersected_entities\ **(point, ids_result)**

  Compute all ids of all cells which are intersected by the
  given point.
  
  *Arguments*
      point (:py:class:`Point`)
          A :py:class:`Point` object.
  
      ids_result (set of int)
          The cell ids which are intersected are stored in a set for
          efficiency reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ **(points, ids_result)**

  Compute all ids of all cells which are intersected by any
  point in points.
  
  *Arguments*
      points (list of :py:class:`Point`)
          A vector of :py:class:`Point` objects.
  
      ids_result (set of int)
          The cell ids which are intersected are stored in a set
          for efficiency reasons, to avoid to sort out
          duplicates later on.

* all_intersected_entities\ **(entity, ids_result)**

  Compute all ids of all cells which are intersected by the given
  entity.
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          A :py:class:`MeshEntity` object.
  
      ids_result (numpy.array(int))
          The ids of the intersected cells are saved in a list.
          This is more efficent than using a set and allows a
          map between the (external) cell and the intersected
          cell of the mesh.

* all_intersected_entities\ **(entities, ids_result)**

  Compute all id of all cells which are intersected by any entity in the
  vector entities.
  
  *Arguments*
      entities (list of :py:class:`MeshEntity`)
          A vector of :py:class:`MeshEntity` objects.
  
      ids_result (set of int)
          The cell ids which are intersected are stored in a set for
          efficiency reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ **(another_mesh, ids_result)**

  Compute all ids of all cells which are intersected by
  another_mesh.
  
  *Arguments*
      another_mesh (:py:class:`Mesh`)
          A :py:class:`Mesh` object.
  
      ids_result (set of int)
          The cell ids which are intersected are stored in a set for
          efficiency reasons, to avoid to sort out duplicates later on.
";

%feature("docstring")  dolfin::Mesh::any_intersected_entity "
Computes only the first id of the entity, which contains the
point.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    int
        The first id of the cell, which contains the point,
        returns -1 if no cell is intersected.
";

%feature("docstring")  dolfin::Mesh::closest_point "
Computes the point inside the mesh and the corresponding cell
index which are closest to the point query.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    :py:class:`Point`
        The point inside the mesh which is closest to the
        point.
";

%feature("docstring")  dolfin::Mesh::closest_cell "
Computes the index of the cell in the mesh which is closest to the
point query.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    int
        The index of the cell in the mesh which is closest to point.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(1, 1)
        >>> point = dolfin.Point(0.0, 2.0)
        >>> mesh.closest_cell(point)
        1
";

%feature("docstring")  dolfin::Mesh::closest_point_and_cell "
Computes the point inside the mesh and the corresponding cell
index which are closest to the point query.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    Swig Object< std::pair<:py:class:`Point`, int> >
        The point inside the mesh and the corresponding cell
        index which is closest to the point query.
";

%feature("docstring")  dolfin::Mesh::hmin "
Compute minimum cell diameter.

*Returns*
    float
        The minimum cell diameter, the diameter is computed as
        two times the circumradius
        (http://mathworld.wolfram.com).

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.hmin()
        0.70710678118654757
";

%feature("docstring")  dolfin::Mesh::hmax "
Compute maximum cell diameter.

*Returns*
    float
        The maximum cell diameter, the diameter is computed as
        two times the circumradius
        (http://mathworld.wolfram.com).

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.hmax()
        0.70710678118654757
";

%feature("docstring")  dolfin::Mesh::str "
Informal string representation.

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the mesh.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.str(False)
        '<Mesh of topological dimension 2 (triangles) with 9 vertices and 8 cells, ordered>'
";

// Documentation extracted from: (module=mesh, header=MeshEntity.h)
%feature("docstring")  dolfin::MeshEntity "
A MeshEntity represents a mesh entity associated with
a specific topological dimension of some mesh.
";

%feature("docstring")  dolfin::MeshEntity::MeshEntity "
**Overloaded versions**

* MeshEntity\ **()**

  Default Constructor

* MeshEntity\ **(mesh, dim, index)**

  Constructor
";

%feature("docstring")  dolfin::MeshEntity::operator== "
Comparision Operator
";

%feature("docstring")  dolfin::MeshEntity::mesh "
Return mesh associated with mesh entity
";

%feature("docstring")  dolfin::MeshEntity::dim "
Return topological dimension
";

%feature("docstring")  dolfin::MeshEntity::index "
**Overloaded versions**

* index\ **()**

  Return index of mesh entity

* index\ **(entity)**

  Compute local index of given incident entity (error if not found)
";

%feature("docstring")  dolfin::MeshEntity::num_entities "
Return number of incident mesh entities of given topological dimension
";

%feature("docstring")  dolfin::MeshEntity::entities "
Return array of indices for incident mesh entitites of given topological dimension
";

%feature("docstring")  dolfin::MeshEntity::mesh_id "
Return unique mesh ID
";

%feature("docstring")  dolfin::MeshEntity::incident "
Check if given entity is indicent
";

%feature("docstring")  dolfin::MeshEntity::intersects "
**Overloaded versions**

* intersects\ **(point)**

  Check if given point intersects (using inexact but fast numerics)

* intersects\ **(entity)**

  Check if given entity intersects (using inexact but fast numerics)
";

%feature("docstring")  dolfin::MeshEntity::intersects_exactly "
**Overloaded versions**

* intersects_exactly\ **(point)**

  Check if given point intersects (using exact numerics)

* intersects_exactly\ **(entity)**

  Check if given entity intersects (using exact numerics)
";

%feature("docstring")  dolfin::MeshEntity::midpoint "
Compute midpoint of cell
";

%feature("docstring")  dolfin::MeshEntity::bbox "
Returns a 3D bounding box of the mesh entity. For lower dimension it may be a degenerated box.
";

%feature("docstring")  dolfin::MeshEntity::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshEntityIterator.h)
%feature("docstring")  dolfin::MeshEntityIterator "
MeshEntityIterator provides a common iterator for mesh entities
over meshes, boundaries and incidence relations. The basic use
is illustrated below.

*Example*
    The following example shows how to iterate over all mesh entities
    of a mesh of topological dimension dim:
    
    .. code-block:: python
    
        >>> for e in dolfin.cpp.entities(mesh, 1):
        ...     print e.index()
    
    The following example shows how to iterate over mesh entities of
    topological dimension dim connected (incident) to some mesh entity f:
    
    .. code-block:: python
    
        >>> f = dolfin.cpp.MeshEntity(mesh, 0, 0)
        >>> for e in dolfin.cpp.entities(f, 1):
        ...     print e.index()
In addition to the general iterator, a set of specific named iterators
are provided for entities of type :py:class:`Vertex`, :py:class:`Edge`, :py:class:`Face`, :py:class:`Facet`
and :py:class:`Cell`. These iterators are defined along with their respective
classes.
";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator "
**Overloaded versions**

* MeshEntityIterator\ **()**

  Default constructor

* MeshEntityIterator\ **(mesh, dim)**

  Create iterator for mesh entities over given topological dimension

* MeshEntityIterator\ **(entity, dim)**

  Create iterator for entities of given dimension connected to given entity

* MeshEntityIterator\ **(it)**

  Copy constructor
";

%feature("docstring")  dolfin::MeshEntityIterator::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::MeshEntityIterator::operator-- "
Step to the previous mesh entity (prefix decrease)
";

%feature("docstring")  dolfin::MeshEntityIterator::pos "
Return current position
";

%feature("docstring")  dolfin::MeshEntityIterator::operator== "
Comparison operator.
";

%feature("docstring")  dolfin::MeshEntityIterator::operator!= "
Comparison operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator-> "
Member access operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator[] "
Random access operator.
";

%feature("docstring")  dolfin::MeshEntityIterator::end "
Check if iterator has reached the end
";

%feature("docstring")  dolfin::MeshEntityIterator::end_iterator "
Provide a safeguard iterator pointing beyond the end of an iteration
process, either iterating over the mesh /or incident entities. Added to
be bit more like STL iterators, since many algorithms rely on a kind of
beyond iterator.
";

%feature("docstring")  dolfin::MeshEntityIterator::set_end "
Set pos to end position. To create a kind of mesh.end() iterator.
";

// Documentation extracted from: (module=mesh, header=SubsetIterator.h)
%feature("docstring")  dolfin::SubsetIterator "
A :py:class:`SubsetIterator` is similar to a :py:class:`MeshEntityIterator` but
iterates over a specified subset of the range of entities as
specified by a :py:class:`MeshFunction` that labels the entites.
";

%feature("docstring")  dolfin::SubsetIterator::SubsetIterator "
Create iterator for given mesh function. The iterator visits
all entities that match the given label.
";

%feature("docstring")  dolfin::SubsetIterator::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::SubsetIterator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::SubsetIterator::operator-> "
Member access operator
";

%feature("docstring")  dolfin::SubsetIterator::end "
Check if iterator has reached the end
";

// Documentation extracted from: (module=mesh, header=Point.h)
%feature("docstring")  dolfin::Point "
A Point represents a point in R^3 with coordinates x, y, z, or,
alternatively, a vector in R^3, supporting standard operations
like the norm, distances, scalar and vector products etc.
";

%feature("docstring")  dolfin::Point::Point "
**Overloaded versions**

* Point\ **(0.0, 0.0, =0.0)**

  Create a point at (x, y, z)

* Point\ **(dim, x)**

  Create point from array

* Point\ **(p)**

  Copy constructor

* Point\ **(point)**

  Constructor taking a CGAL::Point_3. Allows conversion from CGAL Point_3 class to Point class.
";

%feature("docstring")  dolfin::Point::operator[] "
**Overloaded versions**

* operator[]\ **(i)**

  Return address of coordinate in direction i

* operator[]\ **(i)**

  Return coordinate in direction i
";

%feature("docstring")  dolfin::Point::x "
Return x-coordinate
";

%feature("docstring")  dolfin::Point::y "
Return y-coordinate
";

%feature("docstring")  dolfin::Point::z "
Return z-coordinate
";

%feature("docstring")  dolfin::Point::coordinates "
Return coordinate array
";

%feature("docstring")  dolfin::Point::operator+ "
Compute sum of two points
";

%feature("docstring")  dolfin::Point::operator- "
Compute difference of two points
";

%feature("docstring")  dolfin::Point::operator+= "
Add given point
";

%feature("docstring")  dolfin::Point::operator-= "
Subtract given point
";

%feature("docstring")  dolfin::Point::operator* "
**Overloaded versions**

* operator*\ **(a)**

  Multiplication with scalar

* operator*\ **(a, p)**

  Multiplication with scalar
";

%feature("docstring")  dolfin::Point::operator*= "
Incremental multiplication with scalar
";

%feature("docstring")  dolfin::Point::operator/ "
Division by scalar
";

%feature("docstring")  dolfin::Point::operator/= "
Incremental division by scalar
";

%feature("docstring")  dolfin::Point::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Point::operator CGAL::Point_3<Kernel> "
Conversion operator to appropriate CGAL Point_3 class.
";

%feature("docstring")  dolfin::Point::bbox "
Provides a CGAL bounding box, using conversion operator.
";

%feature("docstring")  dolfin::Point::distance "
Compute distance to given point
";

%feature("docstring")  dolfin::Point::norm "
Compute norm of point representing a vector from the origin
";

%feature("docstring")  dolfin::Point::cross "
Compute cross product with given vector
";

%feature("docstring")  dolfin::Point::dot "
Compute dot product with given vector
";

%feature("docstring")  dolfin::Point::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=Vertex.h)
%feature("docstring")  dolfin::Vertex "
A Vertex is a MeshEntity of topological dimension 0.
";

%feature("docstring")  dolfin::Vertex::Vertex "
**Overloaded versions**

* Vertex\ **(mesh, index)**

  Create vertex on given mesh

* Vertex\ **(entity)**

  Create vertex from mesh entity
";

%feature("docstring")  dolfin::Vertex::x "
**Overloaded versions**

* x\ **(i)**

  Return value of vertex coordinate i

* x\ **()**

  Return array of vertex coordinates (const version)
";

%feature("docstring")  dolfin::Vertex::point "
Return vertex coordinates as a 3D point value
";

%feature("docstring")  dolfin::VertexIterator "
A VertexIterator is a MeshEntityIterator of topological dimension 0.
";

%feature("docstring")  dolfin::VertexFunction "
A VertexFunction is a MeshFunction of topological dimension 0.
";

// Documentation extracted from: (module=mesh, header=Edge.h)
%feature("docstring")  dolfin::Edge "
An Edge is a MeshEntity of topological dimension 1.
";

%feature("docstring")  dolfin::Edge::Edge "
**Overloaded versions**

* Edge\ **(mesh, index)**

  Create edge on given mesh

* Edge\ **(entity)**

  Create edge from mesh entity
";

%feature("docstring")  dolfin::Edge::length "
Compute Euclidean length of edge
";

%feature("docstring")  dolfin::Edge::dot "
Compute dot product between edge and other edge
";

%feature("docstring")  dolfin::EdgeIterator "
An EdgeIterator is a MeshEntityIterator of topological dimension 1.
";

%feature("docstring")  dolfin::EdgeFunction "
An EdgeFunction is a MeshFunction of topological dimension 1.
";

// Documentation extracted from: (module=mesh, header=Face.h)
%feature("docstring")  dolfin::Face "
A Face is a MeshEntity of topological dimension 2.
";

%feature("docstring")  dolfin::Face::Face "
Constructor
";

%feature("docstring")  dolfin::Face::area "
Calculate the area of the face (triangle)
";

%feature("docstring")  dolfin::Face::normal "
**Overloaded versions**

* normal\ **(i)**

  Compute component i of the normal to the face

* normal\ **()**

  Compute normal to the face
";

%feature("docstring")  dolfin::FaceIterator "
A FaceIterator is a MeshEntityIterator of topological dimension 2.
";

%feature("docstring")  dolfin::FaceFunction "
A FaceFunction is a MeshFunction of topological dimension 2.
";

// Documentation extracted from: (module=mesh, header=Facet.h)
%feature("docstring")  dolfin::Facet "
A Facet is a MeshEntity of topological codimension 1.
";

%feature("docstring")  dolfin::Facet::Facet "
Constructor
";

%feature("docstring")  dolfin::Facet::normal "
**Overloaded versions**

* normal\ **(i)**

  Compute component i of the normal to the facet

* normal\ **()**

  Compute normal to the facet
";

%feature("docstring")  dolfin::Facet::exterior "
Return true if facet is an exterior facet (relative to global mesh,
so this function will return false for facets on partition boundaries)
Facet connectivity must be initialized before calling this function.
";

%feature("docstring")  dolfin::Facet::adjacent_cells "
Return adjacent cells. An optional argument that lists for
each facet the index of the first cell may be given to specify
the ordering of the two cells. If not specified, the ordering
will depend on the (arbitrary) ordering of the mesh
connectivity.
";

%feature("docstring")  dolfin::FacetIterator "
A FacetIterator is a MeshEntityIterator of topological codimension 1.
";

%feature("docstring")  dolfin::FacetFunction "
A FacetFunction is a MeshFunction of topological codimension 1.
";

// Documentation extracted from: (module=mesh, header=Cell.h)
%feature("docstring")  dolfin::Cell "
A Cell is a MeshEntity of topological codimension 0.
";

%feature("docstring")  dolfin::Cell::Cell "
**Overloaded versions**

* Cell\ **()**

  Create empty cell

* Cell\ **(mesh, index)**

  Create cell on given mesh with given index
";

%feature("docstring")  dolfin::Cell::type "
Return type of cell
";

%feature("docstring")  dolfin::Cell::orientation "
Compute orientation of cell (0 is right, 1 is left)
";

%feature("docstring")  dolfin::Cell::volume "
Compute (generalized) volume of cell
";

%feature("docstring")  dolfin::Cell::diameter "
Compute diameter of cell
";

%feature("docstring")  dolfin::Cell::normal "
**Overloaded versions**

* normal\ **(facet, i)**

  Compute component i of normal of given facet with respect to the cell

* normal\ **(facet)**

  Compute normal of given facet with respect to the cell
";

%feature("docstring")  dolfin::Cell::facet_area "
Compute the area/length of given facet with respect to the cell
";

%feature("docstring")  dolfin::Cell::order "
Order entities locally
";

%feature("docstring")  dolfin::Cell::ordered "
Check if entities are ordered
";

%feature("docstring")  dolfin::CellIterator "
A CellIterator is a MeshEntityIterator of topological codimension 0.
";

%feature("docstring")  dolfin::CellFunction "
A CellFunction is a MeshFunction of topological codimension 0.
";

// Documentation extracted from: (module=mesh, header=FacetCell.h)
%feature("docstring")  dolfin::FacetCell "
This class represents a cell in a mesh incident to a facet on
the boundary. It is useful in cases where one needs to iterate
over a boundary mesh and access the corresponding cells in the
original mesh.
";

%feature("docstring")  dolfin::FacetCell::FacetCell "
Create cell on mesh corresponding to given facet (cell) on boundary
";

%feature("docstring")  dolfin::FacetCell::facet_index "
Return local index of facet with respect to the cell
";

// Documentation extracted from: (module=mesh, header=PrimitiveIntersector.h)
%feature("docstring")  dolfin::PrimitiveIntersector "
This class implements an intersection detection, detecting
whether two given (arbitrary) meshentities intersect.
";

%feature("docstring")  dolfin::PrimitiveIntersector::do_intersect "
**Overloaded versions**

* do_intersect\ **(entity_1, entity_2)**

  Computes whether two mesh entities intersect using an inexact
  geometry kernel which is fast but may suffer from floating
  point precision

* do_intersect\ **(entity_1, point)**

  Computes whether a mesh entity and point intersect using an
  inexact geometry kernel which is fast but may suffer from
  floating point precision
";

%feature("docstring")  dolfin::PrimitiveIntersector::do_intersect_exact "
**Overloaded versions**

* do_intersect_exact\ **(entity_1, entity_2)**

  Computes whether two mesh entities intersect using an exact
  geometry kernel which is slow but always correct

* do_intersect_exact\ **(entity_1, point)**

  Computes whether a mesh entity and point intersect using an
  exact geometry kernel which is slow but always correct
";

// Documentation extracted from: (module=mesh, header=MeshConnectivity.h)
%feature("docstring")  dolfin::MeshConnectivity "
Mesh connectivity stores a sparse data structure of connections
(incidence relations) between mesh entities for a fixed pair of
topological dimensions.

The connectivity can be specified either by first giving the
number of entities and the number of connections for each entity,
which may either be equal for all entities or different, or by
giving the entire (sparse) connectivity pattern.
";

%feature("docstring")  dolfin::MeshConnectivity::MeshConnectivity "
**Overloaded versions**

* MeshConnectivity\ **(d0, d1)**

  Create empty connectivity between given dimensions (d0 -- d1)

* MeshConnectivity\ **(connectivity)**

  Copy constructor
";

%feature("docstring")  dolfin::MeshConnectivity::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshConnectivity::size "
**Overloaded versions**

* size\ **()**

  Return total number of connections

* size\ **(entity)**

  Return number of connections for given entity
";

%feature("docstring")  dolfin::MeshConnectivity::operator "
**Overloaded versions**

* operator\ **(entity)**

  Return array of connections for given entity

* operator\ **()**

  Return contiguous array of connections for all entities
";

%feature("docstring")  dolfin::MeshConnectivity::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshConnectivity::init "
**Overloaded versions**

* init\ **(num_entities, num_connections)**

  Initialize number of entities and number of connections (equal for all)

* init\ **(num_connections)**

  Initialize number of entities and number of connections (individually)
";

%feature("docstring")  dolfin::MeshConnectivity::set "
**Overloaded versions**

* set\ **(entity, connection, pos)**

  Set given connection for given entity

* set\ **(entity, connections)**

  Set all connections for given entity

* set\ **(entity, connections)**

  Set all connections for given entity

* set\ **(connectivity)**

  Set all connections for all entities
";

%feature("docstring")  dolfin::MeshConnectivity::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshEditor.h)
%feature("docstring")  dolfin::MeshEditor "
A simple mesh editor for creating simplicial meshes in 1D, 2D and 3D.
";

%feature("docstring")  dolfin::MeshEditor::MeshEditor "
Constructor
";

%feature("docstring")  dolfin::MeshEditor::open "
**Overloaded versions**

* open\ **(mesh, tdim, gdim)**

  Open mesh of given topological and geometrical dimension

* open\ **(mesh, type, tdim, gdim)**

  Open mesh of given cell type, topological and geometrical dimension

* open\ **(mesh, type, tdim, gdim)**

  Open mesh of given cell type, topological and geometrical dimension
";

%feature("docstring")  dolfin::MeshEditor::init_vertices "
Specify number of vertices
";

%feature("docstring")  dolfin::MeshEditor::init_higher_order_vertices "
Specify number of vertices
";

%feature("docstring")  dolfin::MeshEditor::init_cells "
Specify number of cells
";

%feature("docstring")  dolfin::MeshEditor::init_higher_order_cells "
Specify number of cells
";

%feature("docstring")  dolfin::MeshEditor::set_affine_cell_indicator "
Set boolean indicator inside MeshGeometry
";

%feature("docstring")  dolfin::MeshEditor::add_vertex "
**Overloaded versions**

* add_vertex\ **(v, p)**

  Add vertex v at given point p

* add_vertex\ **(v, x)**

  Add vertex v at given coordinate x

* add_vertex\ **(v, x, y)**

  Add vertex v at given coordinate (x, y)

* add_vertex\ **(v, x, y, z)**

  Add vertex v at given coordinate (x, y, z)
";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_vertex "
**Overloaded versions**

* add_higher_order_vertex\ **(v, p)**

  Add vertex v at given point p

* add_higher_order_vertex\ **(v, x)**

  Add vertex v at given coordinate x

* add_higher_order_vertex\ **(v, x, y)**

  Add vertex v at given coordinate (x, y)

* add_higher_order_vertex\ **(v, x, y, z)**

  Add vertex v at given coordinate (x, y, z)
";

%feature("docstring")  dolfin::MeshEditor::add_cell "
**Overloaded versions**

* add_cell\ **(c, v)**

  Add cell with given vertices

* add_cell\ **(c, v0, v1)**

  Add cell (interval) with given vertices

* add_cell\ **(c, v0, v1, v2)**

  Add cell (triangle) with given vertices

* add_cell\ **(c, v0, v1, v2, v3)**

  Add cell (tetrahedron) with given vertices
";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_cell_data "
Add higher order cell data (assume P2 triangle for now)
";

%feature("docstring")  dolfin::MeshEditor::close "
Close mesh, finish editing, and order entities locally
";

// Documentation extracted from: (module=mesh, header=DynamicMeshEditor.h)
%feature("docstring")  dolfin::DynamicMeshEditor "
This class provides an interface for dynamic editing of meshes,
that is, when the number of vertices and cells are not known
a priori. If the number of vertices and cells are known a priori,
it is more efficient to use the default editor MeshEditor.
";

%feature("docstring")  dolfin::DynamicMeshEditor::DynamicMeshEditor "
Constructor
";

%feature("docstring")  dolfin::DynamicMeshEditor::open "
**Overloaded versions**

* open\ **(mesh, type, tdim, gdim)**

  Open mesh of given cell type, topological and geometrical dimension

* open\ **(mesh, type, tdim, gdim)**

  Open mesh of given cell type, topological and geometrical dimension
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "
**Overloaded versions**

* add_vertex\ **(v, p)**

  Add vertex v at given point p

* add_vertex\ **(v, x)**

  Add vertex v at given coordinate x

* add_vertex\ **(v, x, y)**

  Add vertex v at given coordinate (x, y)

* add_vertex\ **(v, x, y, z)**

  Add vertex v at given coordinate (x, y, z)
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "
**Overloaded versions**

* add_cell\ **(c, v)**

  Add cell with given vertices

* add_cell\ **(c, v0, v1)**

  Add cell (interval) with given vertices

* add_cell\ **(c, v0, v1, v2)**

  Add cell (triangle) with given vertices

* add_cell\ **(c, v0, v1, v2, v3)**

  Add cell (tetrahedron) with given vertices
";

%feature("docstring")  dolfin::DynamicMeshEditor::close "
Close mesh, finish editing, and order entities locally
";

// Documentation extracted from: (module=mesh, header=MeshFunction.h)
%feature("docstring")  dolfin::MeshFunction "
A MeshFunction is a function that can be evaluated at a set of
mesh entities. A MeshFunction is discrete and is only defined
at the set of mesh entities of a fixed topological dimension.
A MeshFunction may for example be used to store a global
numbering scheme for the entities of a (parallel) mesh, marking
sub domains or boolean markers for mesh refinement.
";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "
**Overloaded versions**

* MeshFunction\ **()**

  Create empty mesh function

* MeshFunction\ **(mesh)**

  Create empty mesh function on given mesh

* MeshFunction\ **(mesh, dim)**

  Create mesh function on given mesh of given dimension

* MeshFunction\ **(mesh, dim, value)**

  Create mesh function on given mesh of given dimension and initialise
  to a value

* MeshFunction\ **(mesh, filename)**

  Create function from data file

* MeshFunction\ **(f)**

  Copy constructor
";

%feature("docstring")  dolfin::MeshFunction::mesh "
Return mesh associated with mesh function
";

%feature("docstring")  dolfin::MeshFunction::dim "
Return topological dimension
";

%feature("docstring")  dolfin::MeshFunction::size "
Return size (number of entities)
";

%feature("docstring")  dolfin::MeshFunction::values "
**Overloaded versions**

* values\ **()**

  Return array of values

* values\ **()**

  Return array of values
";

%feature("docstring")  dolfin::MeshFunction::operator[] "
**Overloaded versions**

* operator[]\ **(entity)**

  Return value at given entity

* operator[]\ **(entity)**

  Return value at given entity (const version)

* operator[]\ **(index)**

  Return value at given index

* operator[]\ **(index)**

  Return value at given index  (const version)
";

%feature("docstring")  dolfin::MeshFunction::operator= "
**Overloaded versions**

* operator=\ **(f)**

  Assign mesh function

* operator=\ **(value)**

  Set all values to given value
";

%feature("docstring")  dolfin::MeshFunction::init "
**Overloaded versions**

* init\ **(dim)**

  Initialize mesh function for given topological dimension

* init\ **(dim, size)**

  Initialize mesh function for given topological dimension of given size

* init\ **(mesh, dim)**

  Initialize mesh function for given topological dimension

* init\ **(mesh, dim, size)**

  Initialize mesh function for given topological dimension of given size
";

%feature("docstring")  dolfin::MeshFunction::set_all "
Set all values to given value
";

%feature("docstring")  dolfin::MeshFunction::set "
Set values
";

%feature("docstring")  dolfin::MeshFunction::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshPartitioning.h)
%feature("docstring")  dolfin::MeshPartitioning "
This class partitions and distributes a mesh based on
partitioned local mesh data. Note that the local mesh data will
also be repartitioned and redistributed during the computation
of the mesh partitioning.

After partitioning, each process has a local mesh and set of
mesh data that couples the meshes together.

The following mesh data is created:

1. \"global entity indices 0\" (MeshFunction<uint>)

This maps each local vertex to its global index.

2. \"overlap\" (std::map<uint, std::vector<uint> >)

This maps each shared vertex to a list of the processes sharing
the vertex.

3. \"global entity indices %d\" (MeshFunction<uint>)

After partitioning, the function number_entities() may be called
to create global indices for all entities of a given topological
dimension. These are stored as mesh data (MeshFunction<uint>)
named

   \"global entity indices 1\"
   \"global entity indices 2\"
   etc

4. \"num global entities\" (std::vector<uint>)

The function number_entities also records the number of global
entities for the dimension of the numbered entities in the array
named \"num global entities\". This array has size D + 1, where D
is the topological dimension of the mesh. This array is
initially created by the mesh and then contains only the number
entities of dimension 0 (vertices) and dimension D (cells).
";

%feature("docstring")  dolfin::MeshPartitioning::partition "
**Overloaded versions**

* partition\ **(mesh)**

  Create a partitioned mesh based on local meshes

* partition\ **(mesh, data)**

  Create a partitioned mesh based on local mesh data
";

%feature("docstring")  dolfin::MeshPartitioning::number_entities "
Create global entity indices for entities of dimension d
";

// Documentation extracted from: (module=mesh, header=MeshColoring.h)
%feature("docstring")  dolfin::MeshColoring "
This class computes colorings for a local mesh. It supports
vertex, edge, and facet-based colorings.
";

%feature("docstring")  dolfin::MeshColoring::color_cells "
Color the cells of a mesh for given coloring type, which can
be one of \"vertex\", \"edge\" or \"facet\".
";

%feature("docstring")  dolfin::MeshColoring::color "
Color the cells of a mesh for given coloring type specified by
topological dimension, which can be one of 0, 1 or D - 1.
";

%feature("docstring")  dolfin::MeshColoring::compute_colors "
Compute cell colors for given coloring type specified by
topological dimension, which can be one of 0, 1 or D - 1.
";

%feature("docstring")  dolfin::MeshColoring::type_to_dim "
Convert coloring type to topological dimension
";

// Documentation extracted from: (module=mesh, header=MeshRenumbering.h)
%feature("docstring")  dolfin::MeshRenumbering "
This class implements renumbering algorithms for meshes.
";

// Documentation extracted from: (module=mesh, header=MeshPrimitive.h)
// Documentation extracted from: (module=mesh, header=PrimitiveTraits.h)
// Documentation extracted from: (module=mesh, header=LocalMeshData.h)
%feature("docstring")  dolfin::LocalMeshData::LocalMeshData "
**Overloaded versions**

* LocalMeshData\ **()**

  Create empty local mesh data

* LocalMeshData\ **(mesh)**

  Create local mesh data for given mesh
";

%feature("docstring")  dolfin::LocalMeshData::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::LocalMeshData::clear "
Clear all data
";

%feature("docstring")  dolfin::LocalMeshData::extract_mesh_data "
Copy data from mesh
";

%feature("docstring")  dolfin::LocalMeshData::broadcast_mesh_data "
Broadcast mesh data from main process
";

%feature("docstring")  dolfin::LocalMeshData::receive_mesh_data "
Receive mesh data from main process
";

// Documentation extracted from: (module=mesh, header=SubDomain.h)
%feature("docstring")  dolfin::SubDomain "
This class defines the interface for definition of sub domains.
Alternatively, sub domains may be defined by a Mesh and a
MeshFunction<uint> over the mesh.
";

%feature("docstring")  dolfin::SubDomain::SubDomain "
Constructor
";

%feature("docstring")  dolfin::SubDomain::inside "
Return true for points inside the subdomain
";

%feature("docstring")  dolfin::SubDomain::map "
Map coordinate x in domain H to coordinate y in domain G (used for
periodic boundary conditions)
";

%feature("docstring")  dolfin::SubDomain::snap "
Snap coordinate to boundary of sub domain
";

%feature("docstring")  dolfin::SubDomain::mark "
**Overloaded versions**

* mark\ **(sub_domains, sub_domain)**

  Set sub domain markers (uint) for given subdomain

* mark\ **(sub_domains, sub_domain)**

  Set sub domain markers (int) for given subdomain

* mark\ **(sub_domains, sub_domain)**

  Set sub domain markers (double) for given subdomain

* mark\ **(sub_domains, sub_domain)**

  Set sub domain markers (bool) for given subdomain
";

%feature("docstring")  dolfin::SubDomain::geometric_dimension "
Return geometric dimension
";

%feature("docstring")  dolfin::SubDomain::mark_meshfunction "
Set sub domain markers for given subdomain
";

// Documentation extracted from: (module=mesh, header=SubMesh.h)
%feature("docstring")  dolfin::SubMesh "
A SubMesh is a mesh defined as a subset of a given mesh. It
provides a convenient way to create matching meshes for
multiphysics applications by creating meshes for subdomains as
subsets of a single global mesh.
";

%feature("docstring")  dolfin::SubMesh::SubMesh "
**Overloaded versions**

* SubMesh\ **(mesh, sub_domain)**

  Create subset of given mesh marked by sub domain

* SubMesh\ **(mesh, sub_domains, sub_domain)**

  Create subset of given mesh marked by mesh function
";

%feature("docstring")  dolfin::SubMesh::init "
Create sub mesh
";

// Documentation extracted from: (module=mesh, header=DomainBoundary.h)
%feature("docstring")  dolfin::DomainBoundary "
This class provides a SubDomain which picks out the boundary of
a mesh, and provides a convenient way to specify boundary
conditions on the entire boundary of a mesh.
";

%feature("docstring")  dolfin::DomainBoundary::DomainBoundary "
Constructor
";

%feature("docstring")  dolfin::DomainBoundary::inside "
Return true for points on the boundary
";

// Documentation extracted from: (module=mesh, header=BoundaryMesh.h)
%feature("docstring")  dolfin::BoundaryMesh "
A BoundaryMesh is a mesh over the boundary of some given mesh.
";

%feature("docstring")  dolfin::BoundaryMesh::BoundaryMesh "
**Overloaded versions**

* BoundaryMesh\ **()**

  Create an empty boundary mesh

* BoundaryMesh\ **(mesh)**

  Create (interior) boundary mesh from given mesh
";

%feature("docstring")  dolfin::BoundaryMesh::init_exterior_boundary "
Initialize exterior boundary of given mesh
";

%feature("docstring")  dolfin::BoundaryMesh::init_interior_boundary "
Initialize interior boundary of given mesh
";

// Documentation extracted from: (module=mesh, header=UnitTetrahedron.h)
%feature("docstring")  dolfin::UnitTetrahedron "
A mesh consisting of a single tetrahedron with vertices at

  (0, 0, 0)
  (1, 0, 0)
  (0, 1, 0)
  (0, 0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTetrahedron::UnitTetrahedron "
Create mesh of unit tetrahedron
";

// Documentation extracted from: (module=mesh, header=UnitCube.h)
%feature("docstring")  dolfin::UnitCube "
Tetrahedral mesh of the 3D unit cube (0,1) x (0,1) x (0,1).
Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

// Documentation extracted from: (module=mesh, header=UnitInterval.h)
%feature("docstring")  dolfin::UnitInterval "
A mesh of the unit interval (0, 1) with a given number of cells
(nx) in the axial direction. The total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::UnitInterval::UnitInterval "
Create mesh of unit interval
";

// Documentation extracted from: (module=mesh, header=Interval.h)
%feature("docstring")  dolfin::Interval "
Interval mesh of the 1D line (a,b).
Given the number of cells (nx) in the axial direction,
the total number of intervals will be nx and the
total number of vertices will be (nx + 1).
";

// Documentation extracted from: (module=mesh, header=UnitTriangle.h)
%feature("docstring")  dolfin::UnitTriangle "
A mesh consisting of a single triangle with vertices at

  (0, 0)
  (1, 0)
  (0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTriangle::UnitTriangle "
Create mesh of unit triangle
";

// Documentation extracted from: (module=mesh, header=UnitSquare.h)
%feature("docstring")  dolfin::UnitSquare "
Triangular mesh of the 2D unit square (0,1) x (0,1).
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).
std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\", or \"crossed\")
indicates the direction of the diagonals.
";

// Documentation extracted from: (module=mesh, header=UnitCircle.h)
%feature("docstring")  dolfin::UnitCircle "
Triangular mesh of the 2D unit circle.
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).
std::string diagonal (\"left\", \"right\" or \"crossed\") indicates the
direction of the diagonals.
std:string transformation (\"maxn\", \"sumn\" or \"rotsumn\")
";

// Documentation extracted from: (module=mesh, header=Box.h)
%feature("docstring")  dolfin::Box "
Tetrahedral mesh of the 3D  rectangular prism (x0, y0) x (x1, y1) x (x2, y2).
Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

// Documentation extracted from: (module=mesh, header=Rectangle.h)
%feature("docstring")  dolfin::Rectangle "
Triangular mesh of the 2D rectangle (x0, y0) x (x1, y1).
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\", or \"crossed\")
indicates the direction of the diagonals.
";

// Documentation extracted from: (module=mesh, header=UnitSphere.h)
%feature("docstring")  dolfin::UnitSphere "
Triangular mesh of the 3D unit sphere.

Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

// Documentation extracted from: (module=common, header=init.h)
%feature("docstring")  dolfin::init "
Initialize DOLFIN (and PETSc) with command-line arguments. This
should not be needed in most cases since the initialization is
otherwise handled automatically.
";

// Documentation extracted from: (module=common, header=types.h)
// Documentation extracted from: (module=common, header=real.h)
%feature("docstring")  dolfin::real_sqrt "
Square root
";

%feature("docstring")  dolfin::real_pi "
Compute pi
";

%feature("docstring")  dolfin::real_exp "
Exponential function (note: not full precision!)
";

%feature("docstring")  dolfin::real_log "
Logarithmic function (note: not full precision!)
";

// Documentation extracted from: (module=common, header=constants.h)
// Documentation extracted from: (module=common, header=timing.h)
%feature("docstring")  dolfin::tic "
Timing functions measure CPU time as determined by clock(),
the precision of which seems to be 0.01 seconds.
Start timing (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::toc "
Return elapsed CPU time (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::time "
Return current CPU time used by process
";

// Documentation extracted from: (module=common, header=Array.h)
%feature("docstring")  dolfin::Array "
This class provides a simple wrapper for a pointer to an array. A purpose
of this class is to enable the simple and safe exchange of data between
C++ and Python.
";

%feature("docstring")  dolfin::Array::Array "
**Overloaded versions**

* Array\ **(N)**

  Create array of size N

* Array\ **(other)**

  Copy constructor (arg name need to have a different name that 'x')

* Array\ **(N, x)**

  Construct array from a shared pointer

* Array\ **(N, x)**

  Construct array from a pointer. Array will not take ownership.
";

%feature("docstring")  dolfin::Array::operator= "
**Overloaded versions**

* operator=\ **(x)**

  Assignment operator

* operator=\ **(x)**

  Assign value to all entries
";

%feature("docstring")  dolfin::Array::update "
Construct array from a pointer. Array will not take ownership.
";

%feature("docstring")  dolfin::Array::str "
Return informal string representation (pretty-print).
Note that the Array class is not a subclass of Variable (for
efficiency) which means that one needs to call str() directly
instead of using the info() function on Array objects.
";

%feature("docstring")  dolfin::Array::resize "
Resize array to size N. If size changes, contents will be destroyed.
";

%feature("docstring")  dolfin::Array::size "
Return size of array
";

%feature("docstring")  dolfin::Array::zero "
Zero array
";

%feature("docstring")  dolfin::Array::zero_eps "
Set entries which meet (abs(x[i]) < eps) to zero
";

%feature("docstring")  dolfin::Array::min "
Return minimum value of array
";

%feature("docstring")  dolfin::Array::max "
Return maximum value of array
";

%feature("docstring")  dolfin::Array::operator[] "
**Overloaded versions**

* operator[]\ **(i)**

  Access value of given entry (const version)

* operator[]\ **(i)**

  Access value of given entry (non-const version)
";

%feature("docstring")  dolfin::Array::data "
**Overloaded versions**

* data\ **()**

  Return pointer to data (const version)

* data\ **()**

  Return pointer to data (non-const version)
";

// Documentation extracted from: (module=common, header=IndexSet.h)
%feature("docstring")  dolfin::IndexSet "
This class provides an efficient data structure for index sets.
The cost of checking whether a given index is in the set is O(1)
and very very fast (optimal) at the cost of extra storage.
";

%feature("docstring")  dolfin::IndexSet::IndexSet "
Create index set of given size
";

%feature("docstring")  dolfin::IndexSet::size "
Return size of set
";

%feature("docstring")  dolfin::IndexSet::has_index "
Check whether index is in set
";

%feature("docstring")  dolfin::IndexSet::find "
Return position (if any) for given index
";

%feature("docstring")  dolfin::IndexSet::operator[] "
**Overloaded versions**

* operator[]\ **(i)**

  Return given index

* operator[]\ **(i)**

  Return given index (const version)
";

%feature("docstring")  dolfin::IndexSet::insert "
Insert index into set
";

%feature("docstring")  dolfin::IndexSet::fill "
Fill index set with indices 0, 1, 2, ..., size - 1
";

%feature("docstring")  dolfin::IndexSet::clear "
Clear set
";

// Documentation extracted from: (module=common, header=Set.h)
%feature("docstring")  dolfin::Set::Set "
**Overloaded versions**

* Set\ **()**

  Create empty set

* Set\ **(x)**

  Wrap std::vectpr as a set. Contents will be erased.

* Set\ **(x)**

  Copy constructor
";

%feature("docstring")  dolfin::Set::find "
**Overloaded versions**

* find\ **(x)**

  Find entry in set and return an iterator to the entry

* find\ **(x)**

  Find entry in set and return an iterator to the entry (const)
";

%feature("docstring")  dolfin::Set::insert "
**Overloaded versions**

* insert\ **(x)**

  Insert entry

* insert\ **(first, last)**

  Insert entries
";

%feature("docstring")  dolfin::Set::size "
Set size
";

%feature("docstring")  dolfin::Set::erase "
Erase an entry
";

%feature("docstring")  dolfin::Set::sort "
Sort set
";

%feature("docstring")  dolfin::Set::clear "
Clear set
";

%feature("docstring")  dolfin::Set::operator[] "
Index the nth entry in the set
";

%feature("docstring")  dolfin::Set::set "
**Overloaded versions**

* set\ **()**

  Return the vector that stores the data in the Set

* set\ **()**

  Return the vector that stores the data in the Set
";

// Documentation extracted from: (module=common, header=Timer.h)
%feature("docstring")  dolfin::Timer "
A timer can be used for timing tasks. The basic usage is

  Timer timer(\"Assembling over cells\");

The timer is started at construction and timing ends
when the timer is destroyed (goes out of scope). It is
also possible to start and stop a timer explicitly by

  timer.start();
  timer.stop();

Timings are stored globally and a summary may be printed
by calling

  summary();
";

%feature("docstring")  dolfin::Timer::Timer "
Create timer
";

%feature("docstring")  dolfin::Timer::start "
Start timer
";

%feature("docstring")  dolfin::Timer::stop "
Stop timer
";

%feature("docstring")  dolfin::Timer::value "
Return value of timer (or time at start if not stopped)
";

// Documentation extracted from: (module=common, header=Variable.h)
%feature("docstring")  dolfin::Variable "
Common base class for DOLFIN variables.
";

%feature("docstring")  dolfin::Variable::Variable "
**Overloaded versions**

* Variable\ **()**

  Create unnamed variable

* Variable\ **(name, label)**

  Create variable with given name and label
";

%feature("docstring")  dolfin::Variable::rename "
Rename variable
";

%feature("docstring")  dolfin::Variable::name "
Return name
";

%feature("docstring")  dolfin::Variable::label "
Return label (description)
";

%feature("docstring")  dolfin::Variable::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Variable::disp "
Deprecated, to be removed
";

// Documentation extracted from: (module=common, header=Hierarchical.h)
%feature("docstring")  dolfin::Hierarchical "
This class provides storage and data access for hierarchical
classes; that is, classes where an object may have a child
and a parent.

Note to developers: each subclass of Hierarchical that
implements an assignment operator must call the base class
assignment operator at the *end* of the subclass assignment
operator. See the Mesh class for an example.
";

%feature("docstring")  dolfin::Hierarchical::Hierarchical "
Constructor
";

%feature("docstring")  dolfin::Hierarchical::depth "
Return depth of the hierarchy; that is, the total number of
objects in the hierarchy linked to the current object via
child-parent relationships, including the object itself.

*Returns*
    int
        The depth of the hierarchy.
";

%feature("docstring")  dolfin::Hierarchical::has_parent "
Check if the object has a parent.

*Returns*
    bool
        The return value is true iff the object has a parent.
";

%feature("docstring")  dolfin::Hierarchical::has_child "
Check if the object has a child.

*Returns*
    bool
        The return value is true iff the object has a child.
";

%feature("docstring")  dolfin::Hierarchical::parent "
**Overloaded versions**

* parent\ **()**

  Return parent in hierarchy. An error is thrown if the object
  has no parent.
  
  *Returns*
      _Object_
          The parent object.

* parent\ **()**

  Return parent in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::parent_shared_ptr "
**Overloaded versions**

* parent_shared_ptr\ **()**

  Return shared pointer to parent. A zero pointer is returned if
  the object has no parent.
  
  *Returns*
      shared_ptr<T>
          The parent object.

* parent_shared_ptr\ **()**

  Return shared pointer to parent (const version).
";

%feature("docstring")  dolfin::Hierarchical::child "
**Overloaded versions**

* child\ **()**

  Return child in hierarchy. An error is thrown if the object
  has no child.
  
  *Returns*
      _T_
          The child object.

* child\ **()**

  Return child in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::child_shared_ptr "
**Overloaded versions**

* child_shared_ptr\ **()**

  Return shared pointer to child. A zero pointer is returned if
  the object has no child.
  
  *Returns*
      shared_ptr<T>
          The child object.

* child_shared_ptr\ **()**

  Return shared pointer to child (const version).
";

%feature("docstring")  dolfin::Hierarchical::coarse "
**Overloaded versions**

* coarse\ **()**

  Return coarsest object in hierarchy.
  
  *Returns*
      _T_
          The coarse object.

* coarse\ **()**

  Return coarsest object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::coarse_shared_ptr "
**Overloaded versions**

* coarse_shared_ptr\ **()**

  Return shared pointer to coarsest object in hierarchy.
  
  *Returns*
      _T_
          The coarse object.

* coarse_shared_ptr\ **()**

  Return shared pointer to coarsest object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::fine "
**Overloaded versions**

* fine\ **()**

  Return finest object in hierarchy.
  
  *Returns*
      _T_
          The fine object.

* fine\ **()**

  Return finest object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::fine_shared_ptr "
**Overloaded versions**

* fine_shared_ptr\ **()**

  Return shared pointer to finest object in hierarchy.
  
  *Returns*
      _T_
          The fine object.

* fine_shared_ptr\ **()**

  Return shared pointer to finest object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::set_parent "
Set parent
";

%feature("docstring")  dolfin::Hierarchical::set_child "
Set child
";

%feature("docstring")  dolfin::Hierarchical::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Hierarchical::_debug "
Function useful for debugging the hierarchy
";

// Documentation extracted from: (module=common, header=MPI.h)
%feature("docstring")  dolfin::MPICommunicator::MPICommunicator "
Create communicator (copy of MPI_COMM_WORLD)
";

%feature("docstring")  dolfin::MPICommunicator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MPI "
This class provides utility functions for easy communcation with MPI.
";

%feature("docstring")  dolfin::MPI::process_number "
Return proccess number
";

%feature("docstring")  dolfin::MPI::num_processes "
Return number of processes
";

%feature("docstring")  dolfin::MPI::is_broadcaster "
Determine whether we should broadcast (based on current parallel policy)
";

%feature("docstring")  dolfin::MPI::is_receiver "
Determine whether we should receive (based on current parallel policy)
";

%feature("docstring")  dolfin::MPI::barrier "
Set a barrier (synchronization point)
";

%feature("docstring")  dolfin::MPI::distribute "
**Overloaded versions**

* distribute\ **(values, partition)**

  Distribute local arrays on all processors according to given partition

* distribute\ **(values, partition)**

  Distribute local arrays on all processors according to given partition
";

%feature("docstring")  dolfin::MPI::scatter "
**Overloaded versions**

* scatter\ **(values, sending_process=0)**

  Scatter values, one to each process

* scatter\ **(values, sending_process=0)**

  Scatter values (wrapper for MPI_Scatterv)

* scatter\ **(values, sending_process=0)**

  Scatter values (wrapper for MPI_Scatterv)
";

%feature("docstring")  dolfin::MPI::gather "
**Overloaded versions**

* gather\ **(value)**

  Gather values, one from each process (wrapper for MPI_Allgather)

* gather\ **(values)**

  Gather values, one from each process (wrapper for MPI_Allgather)

* gather\ **(values)**

  Gather values, one from each process (wrapper for MPI_Allgather)
";

%feature("docstring")  dolfin::MPI::gather_all "
Gather values, one from each process (wrapper for boost::mpi::all_gather)
";

%feature("docstring")  dolfin::MPI::global_maximum "
Find global max value (wrapper for MPI_Allredue with MPI_MAX as
reduction op)
";

%feature("docstring")  dolfin::MPI::sum "
Sum values and return sum
";

%feature("docstring")  dolfin::MPI::global_offset "
Find global offset (index) (wrapper for MPI_(Ex)Scan with MPI_SUM as
reduction op)
";

%feature("docstring")  dolfin::MPI::send_recv "
**Overloaded versions**

* send_recv\ **(send_buffer, send_size, dest, recv_buffer, recv_size, source)**

  Send-receive and return number of received values (wrapper for MPI_Sendrecv)

* send_recv\ **(send_buffer, send_size, dest, recv_buffer, recv_size, source)**

  Send-receive and return number of received values (wrapper for MPI_Sendrecv)
";

%feature("docstring")  dolfin::MPI::local_range "
**Overloaded versions**

* local_range\ **(N)**

  Return local range for local process, splitting [0, N - 1] into
   num_processes() portions of almost equal size

* local_range\ **(process, N)**

  Return local range for given process, splitting [0, N - 1] into
  num_processes() portions of almost equal size

* local_range\ **(process, N, num_processes)**

  Return local range for given process, splitting [0, N - 1] into
  num_processes portions of almost equal size
";

%feature("docstring")  dolfin::MPI::index_owner "
Return which process owns index (inverse of local_range)
";

// Documentation extracted from: (module=common, header=SubSystemsManager.h)
%feature("docstring")  dolfin::SubSystemsManager "
This is a singleton class which manages the initialisation and
finalisation of various sub systems, such as MPI and PETSc.
";

%feature("docstring")  dolfin::SubSystemsManager::init_mpi "
Initialise MPI
";

%feature("docstring")  dolfin::SubSystemsManager::init_petsc "
**Overloaded versions**

* init_petsc\ **()**

  Initialize PETSc without command-line arguments

* init_petsc\ **(argc, argv[])**

  Initialize PETSc with command-line arguments. Note that PETSc
  command-line arguments may also be filtered and sent to PETSc
  by parameters.parse(argc, argv).
";

%feature("docstring")  dolfin::SubSystemsManager::finalize "
Finalize subsytems. This will be called by the destructor, but in
special cases it may be necessary to call finalize() explicitly.
";

// Documentation extracted from: (module=io, header=File.h)
%feature("docstring")  dolfin::File "
A File represents a data file for reading and writing objects.
Unless specified explicitly, the format is determined by the
file name suffix.
A list of objects that can be read/written to file can be found in
GenericFile.h
";

%feature("docstring")  dolfin::File::File "
**Overloaded versions**

* File\ **(filename, \"ascii\")**

  Create a file with given name

* File\ **(filename, type, \"ascii\")**

  Create a file with given name and type (format)

* File\ **(outstream)**

  Create a outfile object writing to stream
";

%feature("docstring")  dolfin::File::operator>> "
Read from file
";

%feature("docstring")  dolfin::File::operator<< "
**Overloaded versions**

* operator<<\ **(u)**

  Write Function to file

* operator<<\ **(Function*, u)**

  Write Function to file (with time)

* operator<<\ **(t)**

  Write to file
";

%feature("docstring")  dolfin::File::exists "
Check if file exists
";

// Documentation extracted from: (module=adaptivity, header=ErrorControl.h)
%feature("docstring")  dolfin::ErrorControl "
(Goal-oriented) Error Control class.
The notation used here follows the notation in \"Automated
goal-oriented error control I: stationary variational problems\",
ME Rognes and A Logg, 2010-2011.
";

%feature("docstring")  dolfin::ErrorControl::ErrorControl "
Create error control
";

%feature("docstring")  dolfin::ErrorControl::estimate_error "
Estimate the error relative to the goal M of the discrete
approximation 'u' relative to the variational formulation by
evaluating the weak residual at an approximation to the dual
solution.

*Arguments*
    u (:py:class:`Function`)
       the primal approximation

    bcs (std::vector<const :py:class:`BoundaryCondition`*>)
        the primal boundary conditions

*Returns*
    float
        error estimate
";

%feature("docstring")  dolfin::ErrorControl::compute_indicators "
Compute error indicators

*Arguments*
    indicators (:py:class:`Vector`)
        the error indicators (to be computed)

    u (:py:class:`Function`)
        the primal approximation
";

%feature("docstring")  dolfin::ErrorControl::residual_representation "
Compute strong representation (strong cell and facet
residuals) of the weak residual.

*Arguments*
    R_T (:py:class:`Function`)
        the strong cell residual (to be computed)

    R_dT (_SpecialFacetFunction_)
        the strong facet residual (to be computed)

    u (:py:class:`Function`)
        the primal approximation
";

%feature("docstring")  dolfin::ErrorControl::compute_cell_residual "
Compute representation for the strong cell residual
from the weak residual

*Arguments*
    R_T (:py:class:`Function`)
        the strong cell residual (to be computed)

    u (:py:class:`Function`)
        the primal approximation
";

%feature("docstring")  dolfin::ErrorControl::compute_facet_residual "
Compute representation for the strong facet residual from the
weak residual and the strong cell residual

*Arguments*
    R_dT (_SpecialFacetFunction_)
        the strong facet residual (to be computed)

    u (:py:class:`Function`)
        the primal approximation

    R_T (:py:class:`Function`)
        the strong cell residual
";

%feature("docstring")  dolfin::ErrorControl::compute_dual "
Compute dual approximation defined by dual variational
problem and dual boundary conditions given by homogenized primal
boundary conditions.

*Arguments*
    z (:py:class:`Function`)
        the dual approximation (to be computed)

    bcs (std::vector<const :py:class:`BoundaryCondition`*>)
        the primal boundary conditions
";

%feature("docstring")  dolfin::ErrorControl::compute_extrapolation "
Compute extrapolation with boundary conditions

*Arguments*
    z (:py:class:`Function`)
        the extrapolated function (to be computed)

    bcs (std::vector<const :py:class:`BoundaryCondition`*>)
        the dual boundary conditions
";

// Documentation extracted from: (module=adaptivity, header=TimeSeries.h)
%feature("docstring")  dolfin::TimeSeries "
This class stores a time series of objects to file(s) in a
binary format which is efficient for reading and writing.

When objects are retrieved, the object stored at the time
closest to the given time will be used.

A new time series will check if values have been stored to
file before (for a series with the same name) and in that
case reuse those values. If new values are stored, old
values will be cleared.
";

%feature("docstring")  dolfin::TimeSeries::TimeSeries "
Create empty time series
";

%feature("docstring")  dolfin::TimeSeries::store "
**Overloaded versions**

* store\ **(vector, t)**

  Store vector at given time

* store\ **(mesh, t)**

  Store mesh at given time
";

%feature("docstring")  dolfin::TimeSeries::retrieve "
**Overloaded versions**

* retrieve\ **(vector, t, interpolate=true)**

  Retrieve vector at given time

* retrieve\ **(mesh, t)**

  Retrieve mesh at given time
";

%feature("docstring")  dolfin::TimeSeries::vector_times "
Return array of sample times for vectors
";

%feature("docstring")  dolfin::TimeSeries::mesh_times "
Return array of sample times for meshes
";

%feature("docstring")  dolfin::TimeSeries::clear "
Clear time series
";

%feature("docstring")  dolfin::TimeSeries::filename_data "
Return filename for data
";

%feature("docstring")  dolfin::TimeSeries::filename_times "
Return filename for times
";

%feature("docstring")  dolfin::TimeSeries::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TimeSeries::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=adaptivity, header=adapt.h)
%feature("docstring")  dolfin::adapt "
**Overloaded versions**

* adapt\ **(mesh)**

  Refine mesh uniformly

* adapt\ **(mesh, cell_markers)**

  Refine mesh based on cell markers

* adapt\ **(space)**

  Refine function space uniformly

* adapt\ **(space, cell_markers)**

  Refine function space based on cell markers

* adapt\ **(space, refined_mesh)**

  Refine function space based on refined mesh

* adapt\ **(function, refined_mesh)**

  Refine coefficient based on refined mesh

* adapt\ **(mesh_function, refined_mesh)**

  Refine mesh function<uint> based on mesh

* adapt\ **(bc, refined_mesh, S)**

  Refine Dirichlet bc based on refined mesh

* adapt\ **(form, refined_mesh)**

  Refine form based on refined mesh

* adapt\ **(problem, refined_mesh)**

  Refine variational problem based on mesh

* adapt\ **(ec, refined_mesh)**

  Refine error control object based on mesh
";

%feature("docstring")  dolfin::adapt_markers "
Helper function for refinement of boundary conditions
";

// Documentation extracted from: (module=parameter, header=Parameter.h)
%feature("docstring")  dolfin::Parameter "
Base class for parameters.
";

%feature("docstring")  dolfin::Parameter::Parameter "
Create parameter for given key
";

%feature("docstring")  dolfin::Parameter::key "
Return parameter key
";

%feature("docstring")  dolfin::Parameter::description "
Return parameter description
";

%feature("docstring")  dolfin::Parameter::is_set "
Return true if parameter is set, return false otherwise
";

%feature("docstring")  dolfin::Parameter::access_count "
Return access count (number of times parameter has been accessed)
";

%feature("docstring")  dolfin::Parameter::change_count "
Return change count (number of times parameter has been changed)
";

%feature("docstring")  dolfin::Parameter::set_range "
**Overloaded versions**

* set_range\ **(min_value, max_value)**

  Set range for int-valued parameter

* set_range\ **(min_value, max_value)**

  Set range for double-valued parameter

* set_range\ **(range)**

  Set range for string-valued parameter
";

%feature("docstring")  dolfin::Parameter::get_range "
**Overloaded versions**

* get_range\ **(min_value, max_value)**

  Get range for int-valued parameter

* get_range\ **(min_value, max_value)**

  Get range for double-valued parameter

* get_range\ **(range)**

  Get range for string-valued parameter
";

%feature("docstring")  dolfin::Parameter::operator= "
**Overloaded versions**

* operator=\ **(value)**

  Assignment from int

* operator=\ **(value)**

  Assignment from double

* operator=\ **(value)**

  Assignment from GMP type

* operator=\ **(value)**

  Assignment from string

* operator=\ **(value)**

  Assignment from string

* operator=\ **(value)**

  Assignment from bool
";

%feature("docstring")  dolfin::Parameter::operator int "
Cast parameter to int
";

%feature("docstring")  dolfin::Parameter::operator dolfin::uint "
Cast parameter to uint
";

%feature("docstring")  dolfin::Parameter::operator double "
Cast parameter to double
";

%feature("docstring")  dolfin::Parameter::operator std::string "
Cast parameter to string
";

%feature("docstring")  dolfin::Parameter::operator bool "
Cast parameter to bool
";

%feature("docstring")  dolfin::Parameter::get_real "
Get real value of parameter with (possibly) extended precision
";

%feature("docstring")  dolfin::Parameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::Parameter::value_str "
Return value string
";

%feature("docstring")  dolfin::Parameter::range_str "
Return range string
";

%feature("docstring")  dolfin::Parameter::str "
Return short string description
";

%feature("docstring")  dolfin::IntParameter "
Parameter with value type int
";

%feature("docstring")  dolfin::IntParameter::IntParameter "
**Overloaded versions**

* IntParameter\ **(key)**

  Create unset int-valued

* IntParameter\ **(key, value)**

  Create int-valued parameter
";

%feature("docstring")  dolfin::IntParameter::set_range "
Set range
";

%feature("docstring")  dolfin::IntParameter::get_range "
Get range
";

%feature("docstring")  dolfin::IntParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::IntParameter::operator int "
Cast parameter to int
";

%feature("docstring")  dolfin::IntParameter::operator dolfin::uint "
Cast parameter to uint
";

%feature("docstring")  dolfin::IntParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::IntParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::IntParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::IntParameter::str "
Return short string description
";

%feature("docstring")  dolfin::RealParameter "
Parameter with value type double
";

%feature("docstring")  dolfin::RealParameter::RealParameter "
**Overloaded versions**

* RealParameter\ **(key)**

  Create unset double-valued parameter

* RealParameter\ **(key, value)**

  Create double-valued parameter
";

%feature("docstring")  dolfin::RealParameter::set_range "
Set range
";

%feature("docstring")  dolfin::RealParameter::get_range "
Get range
";

%feature("docstring")  dolfin::RealParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::RealParameter::operator double "
Cast parameter to double
";

%feature("docstring")  dolfin::RealParameter::get_real "
Get real value (possibly with extended precision)
";

%feature("docstring")  dolfin::RealParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::RealParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::RealParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::RealParameter::str "
Return short string description
";

%feature("docstring")  dolfin::StringParameter "
Parameter with value type string
";

%feature("docstring")  dolfin::StringParameter::StringParameter "
**Overloaded versions**

* StringParameter\ **(key)**

  Create unset string-valued parameter

* StringParameter\ **(key, value)**

  Create string-valued parameter
";

%feature("docstring")  dolfin::StringParameter::set_range "
Set range
";

%feature("docstring")  dolfin::StringParameter::get_range "
Get range
";

%feature("docstring")  dolfin::StringParameter::operator= "
**Overloaded versions**

* operator=\ **(value)**

  Assignment

* operator=\ **(value)**

  Assignment
";

%feature("docstring")  dolfin::StringParameter::operator std::string "
Cast parameter to string
";

%feature("docstring")  dolfin::StringParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::StringParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::StringParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::StringParameter::str "
Return short string description
";

%feature("docstring")  dolfin::BoolParameter "
Parameter with value type bool
";

%feature("docstring")  dolfin::BoolParameter::BoolParameter "
**Overloaded versions**

* BoolParameter\ **(key)**

  Create usnet bool-valued parameter

* BoolParameter\ **(key, value)**

  Create bool-valued parameter
";

%feature("docstring")  dolfin::BoolParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::BoolParameter::operator bool "
Cast parameter to bool
";

%feature("docstring")  dolfin::BoolParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::BoolParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::BoolParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::BoolParameter::str "
Return short string description
";

// Documentation extracted from: (module=parameter, header=Parameters.h)
%feature("docstring")  dolfin::Parameters "
This class stores a set of parameters. Each parameter is
identified by a unique string (the key) and a value of some
given value type. Parameter sets can be nested at arbitrary
depths.

A parameter may be either int, double, string or boolean valued.

Parameters may be added as follows:

  Parameters p(\"my_parameters\");
  p.add(\"relative_tolerance\",  1e-15);
  p.add(\"absolute_tolerance\",  1e-15);
  p.add(\"gmres_restart\",       30);
  p.add(\"monitor_convergence\", false);

Parameters may be changed as follows:

  p[\"gmres_restart\"] = 50;

Parameter values may be retrieved as follows:

  int gmres_restart = p[\"gmres_restart\"];

Parameter sets may be nested as follows:

  Parameters q(\"nested_parameters\");
  p.add(q);

Nested parameters may then be accessed by

  p(\"nested_parameters\")[\"...\"]

Parameters may be nested at arbitrary depths.

Parameters may be parsed from the command-line as follows:

  p.parse(argc, argv);

Note: spaces in parameter keys are not allowed (to simplify
usage from command-line).
";

%feature("docstring")  dolfin::Parameters::Parameters "
**Overloaded versions**

* Parameters\ **(\"parameters\")**

  Create empty parameter set

* Parameters\ **(parameters)**

  Copy constructor
";

%feature("docstring")  dolfin::Parameters::name "
Return name for parameter set
";

%feature("docstring")  dolfin::Parameters::rename "
Rename parameter set
";

%feature("docstring")  dolfin::Parameters::clear "
Clear parameter set
";

%feature("docstring")  dolfin::Parameters::add "
**Overloaded versions**

* add\ **(key)**

  Add an unset parameter of type T. For example, to create a unset
  parameter of type bool, do parameters.add<bool>(\"my_setting\")

* add\ **(key, value)**

  Add int-valued parameter

* add\ **(key, value, min_value, max_value)**

  Add int-valued parameter with given range

* add\ **(key, value)**

  Add double-valued parameter

* add\ **(key, value, min_value, max_value)**

  Add double-valued parameter with given range

* add\ **(key, value)**

  Add double-valued parameter

* add\ **(key, value, min_value, max_value)**

  Add double-valued parameter with given range

* add\ **(key, value)**

  Add string-valued parameter

* add\ **(key, value)**

  Add string-valued parameter

* add\ **(key, value, range)**

  Add string-valued parameter with given range

* add\ **(key, value, range)**

  Add string-valued parameter with given range

* add\ **(key, value)**

  Add bool-valued parameter

* add\ **(parameters)**

  Add nested parameter set
";

%feature("docstring")  dolfin::Parameters::parse "
Parse parameters from command-line
";

%feature("docstring")  dolfin::Parameters::update "
Update parameters with another set of parameters
";

%feature("docstring")  dolfin::Parameters::operator[] "
**Overloaded versions**

* operator[]\ **(key)**

  Return parameter for given key

* operator[]\ **(key)**

  Return parameter for given key (const version)
";

%feature("docstring")  dolfin::Parameters::operator "
**Overloaded versions**

* operator\ **(key)**

  Return nested parameter set for given key

* operator\ **(key)**

  Return nested parameter set for given key (const)
";

%feature("docstring")  dolfin::Parameters::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Parameters::has_key "
Check if parameter set has given key
";

%feature("docstring")  dolfin::Parameters::get_parameter_keys "
Return a vector of parameter keys
";

%feature("docstring")  dolfin::Parameters::get_parameter_set_keys "
Return a vector of parameter set keys
";

%feature("docstring")  dolfin::Parameters::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Parameters::parse_dolfin "
Parse filtered options (everything except PETSc options)
";

%feature("docstring")  dolfin::Parameters::parse_petsc "
Parse filtered options (only PETSc options)
";

// Documentation extracted from: (module=parameter, header=GlobalParameters.h)
%feature("docstring")  dolfin::GlobalParameters "
This class defines the global DOLFIN parameter database.
";

%feature("docstring")  dolfin::GlobalParameters::GlobalParameters "
Constructor
";

%feature("docstring")  dolfin::GlobalParameters::parse "
Parse parameters from command-line
";

%feature("docstring")  dolfin::GlobalParameters::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=ode, header=Sample.h)
%feature("docstring")  dolfin::Sample "
Sample of solution values at a given point.
";

%feature("docstring")  dolfin::Sample::Sample "
Constructor
";

%feature("docstring")  dolfin::Sample::size "
Return number of components
";

%feature("docstring")  dolfin::Sample::t "
Return time t
";

%feature("docstring")  dolfin::Sample::u "
Return value of component with given index
";

%feature("docstring")  dolfin::Sample::k "
Return time step for component with given index
";

%feature("docstring")  dolfin::Sample::r "
Return residual for component with given index
";

// Documentation extracted from: (module=ode, header=ODE.h)
%feature("docstring")  dolfin::ODE "
An ODE represents an initial value problem of the form

    u'(t) = f(u(t), t) on [0, T],

    u(0)  = u0,

where u(t) is a vector of length N.

To define an ODE, a user must create a subclass of ODE and
create the function u0() defining the initial condition, as well
the function f() defining the right-hand side.

DOLFIN provides two types of ODE solvers: a set of standard
mono-adaptive solvers with equal adaptive time steps for all
components as well as a set of multi-adaptive solvers with
individual and adaptive time steps for the different
components. The right-hand side f() is defined differently for
the two sets of methods, with the multi-adaptive solvers
requiring a component-wise evaluation of the right-hand
side. Only one right-hand side function f() needs to be defined
for use of any particular solver.

It is also possible to solve implicit systems of the form

    M(u(t), t) u'(t) = f(u(t),t) on (0,T],

    u(0)  = u0,

by setting the option \"implicit\" to true and defining the
function M().

Two different solve() functions are provided, one to solve the
ODE on the time interval [0, T], including the solution of a
dual problem for error control:

    ode.solve();

Alternatively, a time interval may be given in which case the
solution will be computed in a single sweep over the given time
interval without solution of dual problems:

    ode.solve(t0, t1);

This mode allows the state to be specified and retrieved in
between intervals by calling set_state() and get_state().
";

%feature("docstring")  dolfin::ODE::ODE "
Create an ODE of size N with final time T
";

%feature("docstring")  dolfin::ODE::u0 "
Set initial values
";

%feature("docstring")  dolfin::ODE::f "
**Overloaded versions**

* f\ **(u, t, y)**

  Evaluate right-hand side y = f(u, t), mono-adaptive version (default, optional)

* f\ **(u, t, i)**

  Evaluate right-hand side f_i(u, t), multi-adaptive version (optional)
";

%feature("docstring")  dolfin::ODE::M "
Compute product dy = M dx for implicit system (optional)
";

%feature("docstring")  dolfin::ODE::J "
Compute product dy = J dx for Jacobian J (optional)
";

%feature("docstring")  dolfin::ODE::JT "
Compute product dy = tranpose(J) dx for Jacobian J (optional, for dual problem)
";

%feature("docstring")  dolfin::ODE::dfdu "
Compute entry of Jacobian (optional)
";

%feature("docstring")  dolfin::ODE::timestep "
**Overloaded versions**

* timestep\ **(t, k0)**

  Time step to use for the whole system at a given time t (optional)

* timestep\ **(t, i, k0)**

  Time step to use for a given component at a given time t (optional)
";

%feature("docstring")  dolfin::ODE::update "
Update ODE, return false to stop (optional)
";

%feature("docstring")  dolfin::ODE::save "
Save sample (optional)
";

%feature("docstring")  dolfin::ODE::size "
Return number of components N
";

%feature("docstring")  dolfin::ODE::time "
**Overloaded versions**

* time\ **()**

  Return current time

* time\ **(t)**

  Return real time (might be flipped backwards for dual)
";

%feature("docstring")  dolfin::ODE::endtime "
Return end time (final time T)
";

%feature("docstring")  dolfin::ODE::sparse "
Automatically detect sparsity (optional)
";

%feature("docstring")  dolfin::ODE::solve "
**Overloaded versions**

* solve\ **()**

  Solve ODE on [0, T]

* solve\ **(t0, t1)**

  Solve ODE on [t0, t1]

* solve\ **(u)**

  Solve ODE on [0, T]. Save solution in u

* solve\ **(u, t0, t1)**

  Solve ODE on [t0, t1]. Save solution in u
";

%feature("docstring")  dolfin::ODE::solve_dual "
**Overloaded versions**

* solve_dual\ **(u)**

  Solve dual problem given an approximate solution u of the primal problem

* solve_dual\ **(u, z)**

  Solve dual and save soution in z
";

%feature("docstring")  dolfin::ODE::analyze_stability "
Compute stability factors as function of T (including solving the dual problem).
The stability factor is the integral of the norm of the q'th derivative of the dual.
";

%feature("docstring")  dolfin::ODE::analyze_stability_discretization "
Compute stability factors as function of T (including solving the dual problem).
The stability factor accounts for stability wrt the discretization scheme.
";

%feature("docstring")  dolfin::ODE::analyze_stability_computation "
Compute stability factors as function of T (including solving the dual problem).
The stability factor accounts for stability wrt the round-off errors.
";

%feature("docstring")  dolfin::ODE::analyze_stability_initial "
Compute stability factors as function of T (including solving the dual problem).
The stability factor accounts for stability wrt errors in initial data.
";

%feature("docstring")  dolfin::ODE::set_state "
Set state for ODE (only available during interval stepping)
";

%feature("docstring")  dolfin::ODE::get_state "
Get state for ODE (only available during interval stepping)
";

%feature("docstring")  dolfin::ODE::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=ode, header=ODECollection.h)
%feature("docstring")  dolfin::ODECollection "
An ODECollection represents a collection of initial value
problems of the form

    u'(t) = f(u(t), t) on (0, T],

    u(0)  = u0,

where u(t) is a vector of length N.

Each ODE is governed by the same equation but a separate
state is maintained for each ODE. Using ODECollection is
recommended when solving a large number of ODEs and the
overhead of instantiating a large number of ODE objects
should be avoided.
";

%feature("docstring")  dolfin::ODECollection::ODECollection "
Create a collection of ODEs
";

%feature("docstring")  dolfin::ODECollection::solve "
Solve ODE collection on [t0, t1]
";

%feature("docstring")  dolfin::ODECollection::set_state "
**Overloaded versions**

* set_state\ **(system, u)**

  Set state for given ODE system

* set_state\ **(u)**

  Set states for all ODE systems
";

%feature("docstring")  dolfin::ODECollection::get_state "
**Overloaded versions**

* get_state\ **(system, u)**

  Get state for given ODE system

* get_state\ **(u)**

  Get states for all ODE systems
";

%feature("docstring")  dolfin::ODECollection::update "
Optional user-defined update, called between solves
";

// Documentation extracted from: (module=ode, header=ComplexODE.h)
%feature("docstring")  dolfin::ComplexODE "
A ComplexODE represents an initial value problem for a system of
complex-valued ordinary differential equations:

    M(z, t) z'(t) = f(z(t), t) on (0,T]

    z(0) = z0,

where z(t) is a complex-valued vector of length n. The imaginary
unit is provided by the member variable j satisfying j^2 = -1.

This class is a wrapper for a standard real-valued ODE, and
provides an interface that automatically translates the given
complex-valued ODE of size n to a standard real-valued ODE of
size N = 2n.

The double and imaginary parts of the solution are stored in the
following order in the solution vector u(t):

u = (Re z0, Im z0, Re z1, Im z1, ..., Re z_n-1, Im z_n-1).
";

%feature("docstring")  dolfin::ComplexODE::ComplexODE "
Constructor
";

%feature("docstring")  dolfin::ComplexODE::z0 "
Set initial values
";

%feature("docstring")  dolfin::ComplexODE::f "
**Overloaded versions**

* f\ **(z[], t, i)**

  Evaluate right-hand side (multi-adaptive version)

* f\ **(z[], t, y[])**

  Evaluate right-hand side (mono-adaptive version)

* f\ **(u, t, i)**

  Return right-hand side for real-valued ODE

* f\ **(u, t, y)**

  Evaluate right-hand side for real-valued ODE
";

%feature("docstring")  dolfin::ComplexODE::M "
**Overloaded versions**

* M\ **(x[], y[], z[], t)**

  Compute product y = Mx for implicit system

* M\ **(x, y, u, t)**

  Compute product y = Mx for real-valued ODE
";

%feature("docstring")  dolfin::ComplexODE::J "
**Overloaded versions**

* J\ **(x[], y[], u[], t)**

  Compute product y = Jx for Jacobian J

* J\ **(x, y, u, t)**

  Compute product y = Jx for real-valued ODE
";

%feature("docstring")  dolfin::ComplexODE::k "
Return time step for component i (optional)
";

%feature("docstring")  dolfin::ComplexODE::update "
**Overloaded versions**

* update\ **(z[], t, end)**

  Update ODE, return false to stop (optional)

* update\ **(u, t, end)**

  Update for real-valued ODE
";

%feature("docstring")  dolfin::ComplexODE::u0 "
Return initial value for real-valued ODE
";

%feature("docstring")  dolfin::ComplexODE::timestep "
Return time step for real-valued ODE
";

%feature("docstring")  dolfin::DummyComplexODE "
Dummy implementation of ComplexODE used when DOLFIN is compiled
with GMP support in which case ComplexODE is not available
";

// Documentation extracted from: (module=ode, header=Method.h)
%feature("docstring")  dolfin::Method "
Base class for cGqMethod and dGqMethod, which contain all numeric constants,
such as nodal points and nodal weights, needed for the method.
";

%feature("docstring")  dolfin::Method::Method "
Constructor
";

%feature("docstring")  dolfin::Method::type "
Return type (inline optimized)
";

%feature("docstring")  dolfin::Method::degree "
Return degree (inline optimized)
";

%feature("docstring")  dolfin::Method::order "
Return order (inline optimized)
";

%feature("docstring")  dolfin::Method::nsize "
Return number of nodal points (inline optimized)
";

%feature("docstring")  dolfin::Method::qsize "
Return number of quadrature points (inline optimized)
";

%feature("docstring")  dolfin::Method::npoint "
Return nodal point (inline optimized)
";

%feature("docstring")  dolfin::Method::qpoint "
Return quadrature point (inline optimized)
";

%feature("docstring")  dolfin::Method::nweight "
Return nodal weight j for node i, including quadrature (inline optimized)
";

%feature("docstring")  dolfin::Method::qweight "
Return quadrature weight, including only quadrature (inline optimized)
";

%feature("docstring")  dolfin::Method::eval "
Evaluation of trial space basis function i at given tau (inline optimized)
";

%feature("docstring")  dolfin::Method::derivative "
Evaluation of derivative of basis function i at t = 1 (inline optimized)
";

%feature("docstring")  dolfin::Method::update "
**Overloaded versions**

* update\ **(x0, f[], k, values[])**

  Update solution values using fixed-point iteration

* update\ **(x0, f[], k, values[], alpha)**

  Update solution values using fixed-point iteration (damped version)
";

%feature("docstring")  dolfin::Method::ueval "
**Overloaded versions**

* ueval\ **(x0, values[], tau)**

  Evaluate solution at given point

* ueval\ **(x0, values[], i)**

  Evaluate solution at given node
";

%feature("docstring")  dolfin::Method::residual "
Compute residual at right end-point
";

%feature("docstring")  dolfin::Method::timestep "
Compute new time step based on the given residual
";

%feature("docstring")  dolfin::Method::error "
Compute error estimate (modulo stability factor)
";

%feature("docstring")  dolfin::Method::get_nodal_values "
Get nodal values
";

%feature("docstring")  dolfin::Method::get_trial "
Get trial functions
";

%feature("docstring")  dolfin::Method::get_quadrature_weights "
Get quadrature weights
";

%feature("docstring")  dolfin::Method::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=ode, header=cGqMethod.h)
%feature("docstring")  dolfin::cGqMethod "
Contains all numeric constants, such as nodal points and nodal weights,
needed for the cG(q) method. The order q must be at least 1. Note that
q refers to the polynomial order and not the order of convergence for
the method, which is 2q.
";

%feature("docstring")  dolfin::cGqMethod::ueval "
**Overloaded versions**

* ueval\ **(x0, values[], tau)**

  Evaluate solution at given point

* ueval\ **(x0, values[], i)**

  Evaluate solution at given node (inline optimized)
";

%feature("docstring")  dolfin::cGqMethod::residual "
Compute residual at right end-point
";

%feature("docstring")  dolfin::cGqMethod::timestep "
Compute new time step based on the given residual
";

%feature("docstring")  dolfin::cGqMethod::error "
Compute error estimate (modulo stability factor)
";

%feature("docstring")  dolfin::cGqMethod::get_nodal_values "
Replace the solution values with the nodal values solution polynomial
";

%feature("docstring")  dolfin::cGqMethod::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=ode, header=dGqMethod.h)
%feature("docstring")  dolfin::dGqMethod "
Contains all numeric constants, such as nodal points and nodal weights,
needed for the dG(q) method. The order q must be at least 0. Note that
q refers to the polynomial order and not the order of convergence for
the method, which is 2q + 1.
";

%feature("docstring")  dolfin::dGqMethod::ueval "
**Overloaded versions**

* ueval\ **(x0, values[], tau)**

  Evaluate solution at given point

* ueval\ **(x0, values[], i)**

  Evaluate solution at given node (inline optimized)
";

%feature("docstring")  dolfin::dGqMethod::residual "
Compute residual at right end-point
";

%feature("docstring")  dolfin::dGqMethod::timestep "
Compute new time step based on the given residual
";

%feature("docstring")  dolfin::dGqMethod::error "
Compute error estimate (modulo stability factor)
";

%feature("docstring")  dolfin::dGqMethod::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=ode, header=ODESolution.h)
%feature("docstring")  dolfin::ODESolution::ODESolution "
Create solution data for given ODE
";

%feature("docstring")  dolfin::ODESolution::flush "
Make object ready for evaluating, set to read mode
";

%feature("docstring")  dolfin::ODESolution::eval "
Evaluate (interpolate) value of solution at given time
";

%feature("docstring")  dolfin::ODESolution::get_timeslab "
Get timeslab (used when iterating)
";

%feature("docstring")  dolfin::ODESolution::get_weights "
Get pointer to weights
";

// Documentation extracted from: (module=ode, header=StabilityAnalysis.h)
%feature("docstring")  dolfin::StabilityAnalysis::StabilityAnalysis "
Constructor
";

%feature("docstring")  dolfin::StabilityAnalysis::analyze_integral "
Compute the integral of the q'th derivative of the dual as function of (primal) endtime T
";

%feature("docstring")  dolfin::StabilityAnalysis::analyze_endpoint "
Compute z(0) (the endpoint of the dual) as function of (primal) endtime T
";

// Documentation extracted from: (module=math, header=basic.h)
%feature("docstring")  dolfin::sqr "
Return the square of x
";

%feature("docstring")  dolfin::ipow "
Return a to the power n
";

%feature("docstring")  dolfin::rand "
Return a random number, uniformly distributed between [0.0, 1.0)
";

%feature("docstring")  dolfin::seed "
Seed random number generator
";

%feature("docstring")  dolfin::near "
Return true if x is within DOLFIN_EPS of x0
";

%feature("docstring")  dolfin::between "
Return true if x is between x0 and x1 (inclusive)
";

// Documentation extracted from: (module=math, header=Lagrange.h)
%feature("docstring")  dolfin::Lagrange "
Lagrange polynomial (basis) with given degree q determined by n = q + 1 nodal points.

Example: q = 1 (n = 2)

  Lagrange p(1);
  p.set(0, 0.0);
  p.set(1, 1.0);

It is the callers reponsibility that the points are distinct.

This creates a Lagrange polynomial (actually two Lagrange polynomials):

  p(0,x) = 1 - x   (one at x = 0, zero at x = 1)
  p(1,x) = x       (zero at x = 0, one at x = 1)

";

%feature("docstring")  dolfin::Lagrange::Lagrange "
**Overloaded versions**

* Lagrange\ **(q)**

  Constructor

* Lagrange\ **(p)**

  Copy constructor
";

%feature("docstring")  dolfin::Lagrange::set "
Specify point
";

%feature("docstring")  dolfin::Lagrange::size "
Return number of points
";

%feature("docstring")  dolfin::Lagrange::degree "
Return degree
";

%feature("docstring")  dolfin::Lagrange::point "
Return point
";

%feature("docstring")  dolfin::Lagrange::operator "
Return value of polynomial i at given point x
";

%feature("docstring")  dolfin::Lagrange::eval "
Return value of polynomial i at given point x
";

%feature("docstring")  dolfin::Lagrange::ddx "
Return derivate of polynomial i at given point x
";

%feature("docstring")  dolfin::Lagrange::dqdx "
Return derivative q (a constant) of polynomial
";

%feature("docstring")  dolfin::Lagrange::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=math, header=Legendre.h)
%feature("docstring")  dolfin::Legendre "
Legendre polynomial of given degree n on the interval [-1,1].

  P0(x) = 1
  P1(x) = x
  P2(x) = (3x^2 - 1) / 2
  ...

The function values and derivatives are computed using
three-term recurrence formulas.
";

%feature("docstring")  dolfin::Legendre::operator "
Evaluation at given point
";

%feature("docstring")  dolfin::Legendre::ddx "
Evaluation of derivative at given point
";

%feature("docstring")  dolfin::Legendre::d2dx "
Evaluation of second derivative at given point
";

%feature("docstring")  dolfin::Legendre::eval "
Evaluation of arbitrary order, nn <= n (useful ie in RadauQuadrature)
";

