// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON3D_4_H
#define __POISSON3D_4_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_4_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_4_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 35;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.000000000000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980706, -0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.006719368409053, -0.005678902799999, -0.004918074090422, -0.004398859193826, -0.003809523809524, -0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, 0.012080526019262, 0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, 0.007908560702593, 0.007073631734073, 0.006125944778723, 0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980705, 0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006719368409053, -0.005678902799999, -0.004918074090422, 0.004398859193826, 0.003809523809524, 0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, -0.012080526019262, -0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, -0.007908560702593, -0.007073631734073, -0.006125944778723, -0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980705, 0.000000000000000, 0.016731627831579, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010158730158730, -0.006598288790739, 0.003591653491741, -0.001269841269841, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022830048252724, -0.016335852743261, 0.010610447601109, -0.005775596125612, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980705, 0.000000000000000, 0.000000000000000, 0.017746571249998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012698412698413, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, 0.004398859193826, -0.014366613966965, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, -0.042441790404437, 0.030321879659465, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, 0.000000000000000, -0.020077953397895, -0.014197256999999, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009698572899377, 0.071269664509980, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.046188021535170, 0.010774960475224, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.049515422138510, -0.060643759318929, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035916534917412, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.050536466099108, -0.040839631858152};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.023184023598102, -0.013385302265263, 0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.026877473636212, -0.022715611199998, 0.003278716060281, 0.017595436775303, -0.002539682539683, -0.012441852661756, -0.010158730158730, 0.001466286397942, 0.007183306983482, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.024311589644723, 0.000000000000000, -0.020547043427451, -0.031634242810373, 0.000000000000000, 0.015915671401664, 0.024503779114891, 0.026259518075591, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, -0.017388017698577, 0.010038976698947, -0.014197256999999, -0.007228889429248, 0.005599473674211, 0.061721339984837, -0.003232857633126, -0.035634832254990, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.034426518632955, 0.000000000000000, -0.026666666666667, 0.009331389496317, 0.000000000000000, 0.015396007178390, -0.005387480237612, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036906616612102, 0.000000000000000, 0.000000000000000, -0.028587742300706, -0.052519036151182, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.023184023598102, -0.013385302265263, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031104631654390, 0.000000000000000, 0.000000000000000, -0.017958267458706, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043765863459318, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025268233049554, -0.040839631858152};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.023184023598102, 0.013385302265263, -0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.026877473636212, 0.000000000000000, -0.022951012421970, -0.011730291183535, 0.007619047619048, 0.016589136882341, 0.010158730158730, -0.001466286397942, -0.007183306983482, -0.007619047619048, 0.000000000000000, 0.024161052038524, -0.002701287738303, -0.035734677875883, -0.011415024126362, 0.003954280351297, 0.035588523161670, 0.015915671401664, 0.003062972389361, -0.003751359725084, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, -0.017388017698577, -0.010038976698947, 0.014197256999999, -0.007228889429248, 0.061594210416318, -0.006857926664982, -0.061424295029390, -0.003959425806110, 0.005599473674211, 0.000000000000000, 0.034073416799997, -0.004918074090422, 0.000000000000000, -0.026666666666667, 0.009331389496317, -0.015238095238095, 0.017595436775303, 0.005387480237612, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035734677875883, -0.009132019301089, 0.001318093450432, -0.059314205269449, 0.000000000000000, 0.007146935575177, -0.002500906483390, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.023184023598102, 0.013385302265263, -0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029325727958838, -0.010158730158730, 0.002073642110293, 0.010158730158730, -0.021994295969129, 0.017958267458706, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039542803512966, -0.017684079335182, 0.006125944778723, -0.001250453241695, -0.045660096505447, 0.014293871150353, 0.000000000000000, -0.003609747578508, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, -0.023184023598102, -0.013385302265263, 0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.026877473636212, -0.022715611199998, 0.003278716060281, -0.017595436775303, 0.002539682539683, 0.012441852661756, -0.010158730158730, 0.001466286397942, 0.007183306983482, 0.007619047619048, 0.000000000000000, 0.000000000000000, -0.024311589644723, 0.000000000000000, -0.020547043427451, -0.031634242810373, 0.000000000000000, -0.015915671401664, -0.024503779114891, -0.026259518075591, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, 0.017388017698577, 0.010038976698947, -0.014197256999999, -0.007228889429248, -0.005599473674211, -0.061721339984837, -0.003232857633126, -0.035634832254990, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.034426518632955, 0.000000000000000, 0.026666666666667, -0.009331389496317, 0.000000000000000, 0.015396007178390, -0.005387480237612, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036906616612102, 0.000000000000000, 0.000000000000000, 0.028587742300706, 0.052519036151182, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, -0.023184023598102, -0.013385302265263, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067193684090529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.031104631654390, 0.000000000000000, 0.000000000000000, -0.017958267458706, 0.025396825396825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043765863459318, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025268233049554, -0.040839631858152};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, -0.023184023598102, 0.013385302265263, -0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.026877473636212, 0.000000000000000, -0.022951012421970, 0.011730291183535, -0.007619047619048, -0.016589136882341, 0.010158730158730, -0.001466286397942, -0.007183306983482, -0.007619047619048, 0.000000000000000, -0.024161052038524, 0.002701287738303, -0.035734677875883, -0.011415024126362, 0.003954280351297, -0.035588523161670, -0.015915671401664, -0.003062972389361, 0.003751359725084, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, 0.017388017698577, -0.010038976698947, 0.014197256999999, -0.007228889429248, -0.061594210416319, 0.006857926664982, -0.061424295029390, -0.003959425806110, 0.005599473674211, 0.000000000000000, 0.034073416799997, -0.004918074090422, 0.000000000000000, 0.026666666666667, -0.009331389496317, -0.015238095238095, 0.017595436775303, 0.005387480237612, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035734677875883, -0.009132019301089, 0.001318093450432, 0.059314205269449, 0.000000000000000, -0.007146935575177, 0.002500906483390, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, -0.023184023598102, 0.013385302265263, -0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.029325727958838, 0.010158730158730, -0.002073642110293, 0.010158730158730, -0.021994295969129, 0.017958267458706, -0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039542803512966, 0.017684079335182, -0.006125944778723, 0.001250453241695, -0.045660096505447, 0.014293871150353, 0.000000000000000, -0.003609747578508, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, -0.026770604530526, -0.018929675999998, 0.043373336575490, 0.033596842045265, 0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, 0.013438736818106, -0.011357805599999, -0.009836148180844, -0.020528009571187, -0.017777777777778, -0.014515494772048, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, -0.054792115806537, -0.024161052038524, -0.021610301906420, -0.005104953982269, -0.004566009650545, -0.003954280351297, 0.003954280351297, 0.003536815867036, 0.003062972389361, 0.002500906483390, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, 0.000000000000000, 0.020077953397895, 0.014197256999999, -0.086746673150981, 0.000000000000000, 0.000000000000000, 0.009698572899377, 0.007918851612220, 0.005599473674211, 0.000000000000000, 0.034073416799997, 0.029508444542533, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, 0.082188173709805, 0.000000000000000, 0.000000000000000, -0.010209907964538, -0.009132019301089, -0.007908560702593, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, -0.026770604530526, -0.018929675999998, 0.043373336575490, -0.033596842045265, -0.027431706659927, 0.019397145798755, 0.015837703224440, 0.011198947348422, -0.013438736818106, -0.011357805599999, -0.009836148180844, 0.020528009571187, 0.017777777777778, 0.014515494772048, -0.015238095238095, -0.013196577581477, -0.010774960475224, -0.007619047619048, -0.054792115806537, 0.024161052038524, 0.021610301906420, -0.005104953982269, -0.004566009650545, -0.003954280351297, -0.003954280351297, -0.003536815867036, -0.003062972389361, -0.002500906483390, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, 0.057831115433987, 0.033596842045265, 0.027431706659927, -0.042027149230636, -0.047513109673320, -0.016798421022632, 0.000000000000000, 0.045431222399996, 0.039344592723377, -0.058651455917676, 0.002539682539683, -0.060135621198486, 0.040634920634921, -0.010997147984564, 0.017958267458706, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.041094086854902, -0.010544747603458, 0.000000000000000, -0.053052238005546, -0.024503779114891, 0.017506345383727, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.000000000000000, 0.078392631438951, -0.027431706659927, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058651455917676, 0.033015873015873, -0.014515494772048, -0.060952380952381, 0.024193725566041, -0.061058109359600, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053052238005546, -0.032671705486522, 0.008753172691864, 0.000000000000000, -0.055133503008505, 0.014147263468146, 0.015160939829732, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.000000000000000, -0.011198947348422, 0.082295119979782, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053333333333333, 0.043546484316145, 0.000000000000000, -0.046188021535170, 0.025141574442188, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.057175484601413, -0.026259518075591, 0.000000000000000, 0.000000000000000, -0.049515422138510, -0.015160939829732, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, 0.057831115433987, -0.033596842045265, -0.027431706659927, -0.042027149230636, -0.047513109673320, -0.016798421022632, 0.000000000000000, 0.045431222399996, 0.039344592723377, 0.058651455917676, -0.002539682539683, 0.060135621198487, 0.040634920634921, -0.010997147984564, 0.017958267458706, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.041094086854902, -0.010544747603458, 0.000000000000000, 0.053052238005546, 0.024503779114891, -0.017506345383727, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.000000000000000, -0.078392631438951, 0.027431706659927, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.058651455917676, -0.033015873015873, 0.014515494772048, -0.060952380952381, 0.024193725566041, -0.061058109359600, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053052238005546, 0.032671705486522, -0.008753172691864, 0.000000000000000, -0.055133503008505, 0.014147263468146, 0.015160939829732, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.000000000000000, 0.011198947348422, -0.082295119979782, 0.009698572899377, 0.047513109673320, -0.016798421022632, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053333333333333, -0.043546484316145, 0.000000000000000, -0.046188021535170, 0.025141574442188, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.057175484601413, 0.026259518075591, 0.000000000000000, 0.000000000000000, -0.049515422138510, -0.015160939829732, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938258, -0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, 0.044795789393686, -0.054863413319855, 0.048492864496887, 0.000000000000000, -0.016798421022632, 0.080632420908635, 0.022715611199998, -0.003278716060281, -0.005865145591768, 0.030476190476190, 0.045620126426438, -0.010158730158730, 0.027126298361925, 0.043099841900894, 0.039365079365079, 0.000000000000000, 0.000000000000000, 0.072934768934168, 0.000000000000000, 0.020547043427451, 0.031634242810373, 0.000000000000000, -0.005305223800555, -0.008167926371630, -0.008753172691864, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, -0.044795789393686, 0.054863413319855, 0.048492864496887, 0.000000000000000, -0.016798421022632, -0.080632420908635, 0.022715611199998, -0.003278716060281, 0.005865145591768, -0.030476190476190, -0.045620126426438, -0.010158730158730, 0.027126298361925, 0.043099841900894, 0.039365079365079, 0.000000000000000, 0.000000000000000, -0.072934768934168, 0.000000000000000, 0.020547043427451, 0.031634242810373, 0.000000000000000, 0.005305223800555, 0.008167926371630, 0.008753172691864, 0.000000000000000, -0.009188917168084, -0.014147263468146, -0.015160939829732, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.000000000000000, 0.170367083999984, 0.014457778858497, 0.000000000000000, 0.000000000000000, -0.003232857633126, -0.095026219346640, -0.016798421022632, 0.000000000000000, 0.000000000000000, -0.068853037265910, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.015396007178390, -0.050283148884377, -0.082539682539683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.073813233224204, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.016505140712837, 0.030321879659465, 0.030629723893614};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, -0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, -0.044795789393686, 0.054863413319855, -0.009698572899377, 0.031675406448880, 0.039196315719475, 0.080632420908635, 0.000000000000000, 0.022951012421970, 0.052786310325909, 0.010158730158730, -0.012441852661756, 0.060952380952381, 0.016862293576332, -0.007183306983482, -0.013968253968254, 0.000000000000000, 0.072483156115573, -0.008103863214908, 0.035734677875883, 0.011415024126362, -0.003954280351297, -0.011862841053890, -0.005305223800555, -0.001020990796454, 0.001250453241695, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.056789027999995, -0.043373336575490, 0.044795789393686, -0.054863413319855, -0.009698572899377, 0.031675406448880, 0.039196315719475, -0.080632420908635, 0.000000000000000, 0.022951012421970, -0.052786310325909, -0.010158730158730, 0.012441852661756, 0.060952380952381, 0.016862293576332, -0.007183306983482, -0.013968253968254, 0.000000000000000, -0.072483156115573, 0.008103863214908, 0.035734677875883, 0.011415024126362, -0.003954280351297, 0.011862841053890, 0.005305223800555, 0.001020990796454, -0.001250453241695, -0.022830048252724, -0.011230898760992, -0.003536815867036, 0.000721949515702, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.160623627183156, -0.056789027999995, 0.014457778858497, 0.000000000000000, 0.000000000000000, -0.061424295029390, -0.063350812897760, 0.039196315719475, 0.000000000000000, -0.068146833599994, 0.009836148180844, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.091428571428571, 0.028592584759867, 0.014366613966965, -0.013968253968254, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.071469355751766, 0.018264038602179, -0.002636186900864, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.045660096505447, 0.004083963185815, -0.004715754489382, -0.001443899031403, 0.002041981592908};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.351908735506058, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.115662230867974, 0.000000000000000, 0.000000000000000, -0.129314305325033, 0.000000000000000, -0.134387368181059, 0.000000000000000, -0.090862444799991, -0.078689185446754, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, -0.087977183876514, 0.000000000000000, 0.071111111111111, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.082188173709805, 0.021089495206915, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, 0.023578772446909, 0.000000000000000, -0.012251889557446};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 35; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980706, -0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.006719368409053, -0.005678902799999, -0.004918074090422, -0.004398859193826, -0.003809523809524, -0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, 0.012080526019262, 0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, 0.007908560702593, 0.007073631734073, 0.006125944778723, 0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000015, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.582575694955846, 0.000000000000000, 8.366600265340757, -1.183215956619919, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713676, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.499090833946989, 0.000000000000000, -3.346640106136303, -2.366431913239847, 15.491933384829673, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949244, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439074, -0.828078671210814, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000022, 4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012749, 0.000000000000000, 0.000000000000012, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.600000000000005, 0.000000000000000, 8.763560920082664, -1.549193338482967, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832535, -1.481312159636085, 0.261861468283198, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.117691453623980, 0.000000000000000, 3.162277660168386, 4.919349550499540, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 10.690449676496987, -2.418972627259045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.545584412271586, 0.000000000000000, 0.000000000000000, 7.668115805072332, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 10.369185117452595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360416, -3.433032811627989, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348575, 0.000000000000000, 0.000000000000000, 0.611677741841197, 0.529728463363978, 0.432521479156786, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.531372124791041, 0.000000000000000, 3.545621041711674, -2.507132682112038, 4.787135538781693, 0.000000000000000, 0.000000000000000, -5.566267450754891, -1.048808848170150, 0.741619848709561, 0.000000000000000, 18.803495115840249, -0.603122387046457, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744170, 0.701283781217658, 0.132137494528681, -0.093435318430234, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.052982440952155, 0.000000000000000, -1.585649934344182, 4.484895284651103, 4.281744192888372, 0.000000000000000, 0.000000000000014, 0.191485421551267, -3.752332607858732, -4.311612227462033, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570558, 1.044638617546682, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448128, -0.767649473578741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611578, 0.096714742912336, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.321153829895993, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604781, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556546, -1.730085916627139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.010178182781469, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 8.919280880686049, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.966479394838264, 0.000000000000000, 8.124038404635964, -1.641303613296584, 0.000000000000000, 0.000000000000019, 0.000000000000000, 11.772850122209158, -2.403122968139590, 0.485504156227610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419140, 0.302765035409750, -0.061167774184119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.653299832284321, 0.000000000000000, 4.152206199905147, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000012, 2.632489316217646, 9.825913261807854, -2.822612771377404, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243895, -3.094871773194642, 0.683876505540237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.297825058615216, 0.000000000000000, 1.498298354528788, 5.509176018985353, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, 6.648039453209416, 4.136768925484869, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384183, -3.553526561095072, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000010, 0.000000000000000},
      {1.876166303929381, 0.000000000000000, 0.000000000000000, 6.228309299857693, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 11.054152419533846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477930, 7.245688373094714, 4.183300132670375, -0.591607978309958, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856838, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.645751311064588, 0.000000000000000, 9.660917830792961, 0.683130051063973, 0.000000000000000, -0.000000000000012, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806686, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724439, 2.449489742783176, 2.828427124746188, -1.000000000000000, 9.165151389911681, 7.099295739719528, -0.414039335605404, -2.049390153191921, -0.478091443733753, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749821, 2.121320343559639, -0.408248290463867, 3.175426480542948, 0.000000000000000, 0.000000000000000, 7.171371656006367, 0.000000000000000, -1.380131118684707, -1.561440116717645, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.799999999999991, -5.692099788303085, 4.381780460041330, -0.774596669241485, 0.000000000000000, 10.998181667894016, 0.962140470884738, 4.762352359916262, -0.740656079818044, 0.130930734141592, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726812004, 2.738612787525827, 1.581138830084190, 2.459674775249773, 0.000000000000000, 0.000000000000000, 9.258200997725526, 0.000000000000000, 5.345224838248503, -1.209486313629514, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135793, 0.000000000000000, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726298, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.196152422706633, 0.000000000000000, -3.162277660168380, -2.236067977499793, 0.000000000000000, 0.000000000000019, 0.000000000000000, 13.747727084867531, 0.534522483824850, 0.377964473009229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.799999999999995, 0.000000000000000, 3.651483716701115, -2.840187787218778, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967382, 1.396594497510367, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.204540768504874, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 8.979977728257483, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395517, 3.070597894314957, 1.772810520855838, -1.253566341056019, 2.393567769390846, 6.303768714031311, -0.908295106229247, -2.783133725377445, -0.524404424085076, 0.370809924354775, 11.124297730643494, 9.401747557920128, -0.301561193523228, -2.427520781138059, -0.794200206656966, 0.114434427054268, 0.840917865872084, 0.350641890608829, 0.066068747264341, -0.046717659215116, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476090, 2.746426249302381, -0.792824967172095, 2.242447642325554, 2.140872096444193, -0.331662479035539, 6.499230723708785, 0.095742710775635, -1.876166303929359, -2.155806113731007, 0.000000000000000, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565358, -2.047065262876643, 0.000000000000000, 0.422185670932518, 0.590936840285276, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512682, 1.297564437470358, 3.745745886321972, -1.059456926727953, -8.091735937126879, 5.014265364224070, -0.383824736789362, 1.809367161139368, -1.108006575534899, 0.313391585264004, 0.000000000000000, 12.713483120735424, 1.019462903068663, 8.206518066482904, -0.631738055305790, 0.048357371456164, -2.842821248876059, -0.227958835180083, 0.139595707137605, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155341, 1.160576914947996, 1.340118788520980, 1.895214165917369, 2.533114025595109, 1.962141687034856, 2.746426249302398, -0.566421515598880, 3.171299868688391, -1.821988709389511, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278271, -0.865042958313574, 0.000000000000000, -2.497684112518216, -0.998865569685860, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419144, 1.005089091390737, -0.193429485824666, 3.556157828809262, 0.000000000000000, 0.000000000000000, 4.459640440343021, 0.000000000000000, -0.858258202906996, 2.670272859251876, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837941, -2.293791531904487, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419135, 7.035623639735146, 4.062019202317985, -0.820651806648288, 0.000000000000000, -6.797058187186559, -2.081165538826753, 5.886425061104583, -1.201561484069790, 0.242752078113812, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191315, 0.856348838577677, 0.262202212042537, 5.138093031466055, -0.741619848709572, 0.151382517704875, -0.030583887092061, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142149, -2.696937038151818, 2.076103099952576, 1.468026580418868, 0.000000000000000, 3.039736830714131, -6.382117875081014, 1.316244658108819, 4.912956630903924, -1.411306385688709, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588737, 2.010178182781474, 0.000000000000000, 5.804093383121951, -1.547435886597320, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307613, 1.297564437470354, 0.749149177264397, 2.754588009492676, 0.000000000000000, 0.000000000000014, 5.757371051840542, 0.000000000000000, 3.324019726604708, 2.068384462742436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637450, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547538, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964691, 0.000000000000000, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739974, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.425395354310717, 0.000000000000000, 9.380831519646852, 1.895214165917370, 0.000000000000000, 0.000000000000014, -0.000000000000011, -3.398529093593296, -2.774887385102335, -0.560611910581403, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288837, 0.349602949390049, 0.070630461781863, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.829708431025348, 0.000000000000000, -1.498298354528785, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.799671038392669, -3.545621041711684, -4.074090608432072, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735906, 1.116765657100820, 0.987090711415291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.326649916142165, 0.000000000000000, 1.730085916627145, -3.180724257574227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787415, -2.388364652703959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849925, 2.051629516620721, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.624807680927203, 0.000000000000000, 0.000000000000000, 5.393874076303637, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 9.573176812621536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907356, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477925, 1.449137674618941, 4.183300132670376, -0.591607978309959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386981, 7.099295739719543, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.080123449734647, 0.000000000000000, 7.099295739719539, 2.509980079602229, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.818813079129868, 0.000000000000000, 0.000000000000000, 8.874119674649423, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724452, 2.449489742783174, 2.828427124746189, -0.999999999999998, 1.309307341415954, 7.099295739719525, -0.414039335605411, -2.049390153191916, -0.478091443733754, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749807, 2.121320343559641, -0.408248290463868, 3.175426480542944, 9.071147352221457, 0.000000000000000, 7.171371656006376, 0.000000000000000, -1.380131118684704, -1.561440116717650, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.800000000000003, 0.632455532033676, 4.381780460041331, -0.774596669241484, 0.000000000000000, 3.142337619398289, -0.106904496764963, 4.762352359916268, -0.740656079818041, 0.130930734141599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726811988, 0.547722557505165, 1.581138830084189, 2.459674775249768, 0.000000000000000, 9.071147352221443, 1.851640199545105, 0.000000000000000, 5.345224838248499, -1.209486313629522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135797, -6.260990336999408, 0.000000000000000, 3.834057902536167, 0.000000000000000, 0.000000000000012, 10.583005244258372, 0.000000000000000, 0.000000000000000, 5.184592558726301, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011},
      {1.039230484541326, 0.000000000000000, 3.162277660168380, -0.447213595499958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371797, -0.534522483824851, 0.075592894601844, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.899999999999998, 0.000000000000000, 1.460593486680449, 1.420093893609383, 0.000000000000000, 0.000000000000011, 0.000000000000000, 9.071147352221454, 4.937707198786950, -0.698297248755173, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.734846922834953, 0.000000000000000, -6.260990336999408, 2.213594362117863, 0.000000000000000, 0.000000000000014, -0.000000000000016, 0.000000000000000, 10.583005244258382, 2.993325909419166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.715767664977308, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395520, 3.070597894314956, 1.772810520855835, -1.253566341056019, 2.393567769390845, 6.303768714031312, -0.908295106229243, -2.783133725377444, -0.524404424085074, 0.370809924354780, 1.236033081182610, 9.401747557920134, -0.301561193523228, -2.427520781138059, -0.794200206656968, 0.114434427054267, 0.840917865872086, 0.350641890608830, 0.066068747264339, -0.046717659215117, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476083, 2.746426249302381, -0.792824967172091, 2.242447642325554, 2.140872096444190, -0.331662479035538, 6.499230723708781, 0.095742710775632, -1.876166303929363, -2.155806113731011, 11.055415967851332, 0.000000000000000, 9.440358593314686, 0.000000000000000, -1.462494064565356, -2.047065262876641, 0.000000000000000, 0.422185670932516, 0.590936840285277, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512674, 1.297564437470355, 3.745745886321972, -1.059456926727951, 0.404586796856338, 5.014265364224058, -0.383824736789359, 1.809367161139370, -1.108006575534898, 0.313391585264005, 0.000000000000000, 2.825218471274539, -0.050973145153432, 8.206518066482897, -0.631738055305789, 0.048357371456164, -2.842821248876057, -0.227958835180083, 0.139595707137604, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155349, 1.160576914947998, 1.340118788520980, 1.895214165917371, 0.361873432227875, 1.962141687034864, 2.746426249302388, -0.566421515598880, 3.171299868688374, -1.821988709389514, 0.000000000000000, 11.055415967851328, 1.595711846260563, 0.000000000000000, 8.652231568278273, -0.865042958313569, 0.000000000000000, -2.497684112518217, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419142, 1.005089091390738, -0.193429485824662, 3.556157828809255, -8.461572802128115, 0.000000000000000, 4.459640440343024, 0.000000000000000, -0.858258202906988, 2.670272859251874, 0.000000000000000, 0.000000000000000, 12.437342963832752, 0.000000000000000, 0.000000000000000, 8.427928244224427, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904485, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419127, 0.335029697130247, 4.062019202317982, -0.820651806648292, 0.000000000000000, 1.699264546796649, -0.099103120896516, 5.886425061104582, -1.201561484069795, 0.242752078113805, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730439, -0.214087209644416, 0.012485819621074, 5.138093031466054, -0.741619848709571, 0.151382517704876, -0.030583887092059, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142157, 0.299659670905759, 2.076103099952574, 1.468026580418872, 0.000000000000000, 0.868496237346892, 0.709124208342343, 1.316244658108825, 4.912956630903930, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851330, 3.829708431025353, -0.223353131420165, 0.000000000000000, 5.804093383121946, -1.547435886597321, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307614, 0.259512887494073, 0.749149177264397, 2.754588009492679, 0.000000000000000, -8.461572802128112, 1.151474210368101, 0.000000000000000, 3.324019726604706, 2.068384462742438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832752, 2.176081715527491, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964684, 7.628089872441255, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, -7.521398046336119, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.856348838577673, 0.000000000000000, 2.680237577041958, -0.473803541479346, 0.000000000000000, 0.000000000000015, 0.000000000000000, 5.097793640389933, -0.792824967172092, 0.140152977645346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568710, -0.642261628933261, 0.099886556968584, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.765941686205059, 0.000000000000000, 1.498298354528793, 0.847565541382358, 0.000000000000000, 0.000000000000021, 0.000000000000000, 1.628430445025429, 3.545621041711666, -0.814818121686421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851339, 7.180703308172532, -1.116765657100815, 0.197418142283058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.663324958071082, 0.000000000000000, 0.692034366650859, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128122, 3.070597894314962, 1.194182326351982, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832743, 5.802884574739972, -1.025814758310363, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.541602560309067, 0.000000000000000, 7.628089872441246, 1.797958025434548, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540503, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380282, 3.350296971302450, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-5.361591803435499, 0.000000000000000, 0.000000000000000, 8.899438184514789, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, -5.264978632435287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951776997, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980705, 0.014490014748814, -0.008365813915789, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006719368409053, -0.005678902799999, -0.004918074090422, 0.004398859193826, 0.003809523809524, 0.003110463165439, -0.002539682539683, -0.002199429596913, -0.001795826745871, -0.001269841269841, 0.013698028951634, -0.012080526019262, -0.010805150953210, 0.010209907964538, 0.009132019301089, 0.007908560702593, -0.007908560702593, -0.007073631734073, -0.006125944778723, -0.005001812966779, 0.004566009650545, 0.004083963185815, 0.003536815867036, 0.002887798062806, 0.002041981592908};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000015, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.582575694955846, 0.000000000000000, 8.366600265340757, -1.183215956619919, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713676, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.499090833946989, 0.000000000000000, -3.346640106136303, -2.366431913239847, 15.491933384829673, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949244, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439074, -0.828078671210814, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000022, 4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012749, 0.000000000000000, 0.000000000000012, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.600000000000005, 0.000000000000000, 8.763560920082664, -1.549193338482967, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832535, -1.481312159636085, 0.261861468283198, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.117691453623980, 0.000000000000000, 3.162277660168386, 4.919349550499540, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 10.690449676496987, -2.418972627259045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.545584412271586, 0.000000000000000, 0.000000000000000, 7.668115805072332, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 10.369185117452595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360416, -3.433032811627989, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348575, 0.000000000000000, 0.000000000000000, 0.611677741841197, 0.529728463363978, 0.432521479156786, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.531372124791041, 0.000000000000000, 3.545621041711674, -2.507132682112038, 4.787135538781693, 0.000000000000000, 0.000000000000000, -5.566267450754891, -1.048808848170150, 0.741619848709561, 0.000000000000000, 18.803495115840249, -0.603122387046457, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744170, 0.701283781217658, 0.132137494528681, -0.093435318430234, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.052982440952155, 0.000000000000000, -1.585649934344182, 4.484895284651103, 4.281744192888372, 0.000000000000000, 0.000000000000014, 0.191485421551267, -3.752332607858732, -4.311612227462033, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570558, 1.044638617546682, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448128, -0.767649473578741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611578, 0.096714742912336, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.321153829895993, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604781, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556546, -1.730085916627139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.010178182781469, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 8.919280880686049, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.966479394838264, 0.000000000000000, 8.124038404635964, -1.641303613296584, 0.000000000000000, 0.000000000000019, 0.000000000000000, 11.772850122209158, -2.403122968139590, 0.485504156227610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419140, 0.302765035409750, -0.061167774184119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.653299832284321, 0.000000000000000, 4.152206199905147, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000012, 2.632489316217646, 9.825913261807854, -2.822612771377404, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243895, -3.094871773194642, 0.683876505540237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.297825058615216, 0.000000000000000, 1.498298354528788, 5.509176018985353, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, 6.648039453209416, 4.136768925484869, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384183, -3.553526561095072, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000010, 0.000000000000000},
      {1.876166303929381, 0.000000000000000, 0.000000000000000, 6.228309299857693, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 11.054152419533846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477930, 7.245688373094714, 4.183300132670375, -0.591607978309958, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856838, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.645751311064588, 0.000000000000000, 9.660917830792961, 0.683130051063973, 0.000000000000000, -0.000000000000012, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806686, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724439, 2.449489742783176, 2.828427124746188, -1.000000000000000, 9.165151389911681, 7.099295739719528, -0.414039335605404, -2.049390153191921, -0.478091443733753, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749821, 2.121320343559639, -0.408248290463867, 3.175426480542948, 0.000000000000000, 0.000000000000000, 7.171371656006367, 0.000000000000000, -1.380131118684707, -1.561440116717645, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.799999999999991, -5.692099788303085, 4.381780460041330, -0.774596669241485, 0.000000000000000, 10.998181667894016, 0.962140470884738, 4.762352359916262, -0.740656079818044, 0.130930734141592, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726812004, 2.738612787525827, 1.581138830084190, 2.459674775249773, 0.000000000000000, 0.000000000000000, 9.258200997725526, 0.000000000000000, 5.345224838248503, -1.209486313629514, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135793, 0.000000000000000, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726298, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.196152422706633, 0.000000000000000, -3.162277660168380, -2.236067977499793, 0.000000000000000, 0.000000000000019, 0.000000000000000, 13.747727084867531, 0.534522483824850, 0.377964473009229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.799999999999995, 0.000000000000000, 3.651483716701115, -2.840187787218778, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967382, 1.396594497510367, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.204540768504874, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 8.979977728257483, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395517, 3.070597894314957, 1.772810520855838, -1.253566341056019, 2.393567769390846, 6.303768714031311, -0.908295106229247, -2.783133725377445, -0.524404424085076, 0.370809924354775, 11.124297730643494, 9.401747557920128, -0.301561193523228, -2.427520781138059, -0.794200206656966, 0.114434427054268, 0.840917865872084, 0.350641890608829, 0.066068747264341, -0.046717659215116, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476090, 2.746426249302381, -0.792824967172095, 2.242447642325554, 2.140872096444193, -0.331662479035539, 6.499230723708785, 0.095742710775635, -1.876166303929359, -2.155806113731007, 0.000000000000000, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565358, -2.047065262876643, 0.000000000000000, 0.422185670932518, 0.590936840285276, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512682, 1.297564437470358, 3.745745886321972, -1.059456926727953, -8.091735937126879, 5.014265364224070, -0.383824736789362, 1.809367161139368, -1.108006575534899, 0.313391585264004, 0.000000000000000, 12.713483120735424, 1.019462903068663, 8.206518066482904, -0.631738055305790, 0.048357371456164, -2.842821248876059, -0.227958835180083, 0.139595707137605, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155341, 1.160576914947996, 1.340118788520980, 1.895214165917369, 2.533114025595109, 1.962141687034856, 2.746426249302398, -0.566421515598880, 3.171299868688391, -1.821988709389511, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278271, -0.865042958313574, 0.000000000000000, -2.497684112518216, -0.998865569685860, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419144, 1.005089091390737, -0.193429485824666, 3.556157828809262, 0.000000000000000, 0.000000000000000, 4.459640440343021, 0.000000000000000, -0.858258202906996, 2.670272859251876, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837941, -2.293791531904487, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419135, 7.035623639735146, 4.062019202317985, -0.820651806648288, 0.000000000000000, -6.797058187186559, -2.081165538826753, 5.886425061104583, -1.201561484069790, 0.242752078113812, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191315, 0.856348838577677, 0.262202212042537, 5.138093031466055, -0.741619848709572, 0.151382517704875, -0.030583887092061, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142149, -2.696937038151818, 2.076103099952576, 1.468026580418868, 0.000000000000000, 3.039736830714131, -6.382117875081014, 1.316244658108819, 4.912956630903924, -1.411306385688709, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588737, 2.010178182781474, 0.000000000000000, 5.804093383121951, -1.547435886597320, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307613, 1.297564437470354, 0.749149177264397, 2.754588009492676, 0.000000000000000, 0.000000000000014, 5.757371051840542, 0.000000000000000, 3.324019726604708, 2.068384462742436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637450, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547538, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964691, 0.000000000000000, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739974, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.425395354310717, 0.000000000000000, 9.380831519646852, 1.895214165917370, 0.000000000000000, 0.000000000000014, -0.000000000000011, -3.398529093593296, -2.774887385102335, -0.560611910581403, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288837, 0.349602949390049, 0.070630461781863, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.829708431025348, 0.000000000000000, -1.498298354528785, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.799671038392669, -3.545621041711684, -4.074090608432072, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735906, 1.116765657100820, 0.987090711415291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.326649916142165, 0.000000000000000, 1.730085916627145, -3.180724257574227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787415, -2.388364652703959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849925, 2.051629516620721, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.624807680927203, 0.000000000000000, 0.000000000000000, 5.393874076303637, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 9.573176812621536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907356, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477925, 1.449137674618941, 4.183300132670376, -0.591607978309959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386981, 7.099295739719543, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.080123449734647, 0.000000000000000, 7.099295739719539, 2.509980079602229, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.818813079129868, 0.000000000000000, 0.000000000000000, 8.874119674649423, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724452, 2.449489742783174, 2.828427124746189, -0.999999999999998, 1.309307341415954, 7.099295739719525, -0.414039335605411, -2.049390153191916, -0.478091443733754, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749807, 2.121320343559641, -0.408248290463868, 3.175426480542944, 9.071147352221457, 0.000000000000000, 7.171371656006376, 0.000000000000000, -1.380131118684704, -1.561440116717650, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.800000000000003, 0.632455532033676, 4.381780460041331, -0.774596669241484, 0.000000000000000, 3.142337619398289, -0.106904496764963, 4.762352359916268, -0.740656079818041, 0.130930734141599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726811988, 0.547722557505165, 1.581138830084189, 2.459674775249768, 0.000000000000000, 9.071147352221443, 1.851640199545105, 0.000000000000000, 5.345224838248499, -1.209486313629522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135797, -6.260990336999408, 0.000000000000000, 3.834057902536167, 0.000000000000000, 0.000000000000012, 10.583005244258372, 0.000000000000000, 0.000000000000000, 5.184592558726301, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011},
      {1.039230484541326, 0.000000000000000, 3.162277660168380, -0.447213595499958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371797, -0.534522483824851, 0.075592894601844, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.899999999999998, 0.000000000000000, 1.460593486680449, 1.420093893609383, 0.000000000000000, 0.000000000000011, 0.000000000000000, 9.071147352221454, 4.937707198786950, -0.698297248755173, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.734846922834953, 0.000000000000000, -6.260990336999408, 2.213594362117863, 0.000000000000000, 0.000000000000014, -0.000000000000016, 0.000000000000000, 10.583005244258382, 2.993325909419166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.715767664977308, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395520, 3.070597894314956, 1.772810520855835, -1.253566341056019, 2.393567769390845, 6.303768714031312, -0.908295106229243, -2.783133725377444, -0.524404424085074, 0.370809924354780, 1.236033081182610, 9.401747557920134, -0.301561193523228, -2.427520781138059, -0.794200206656968, 0.114434427054267, 0.840917865872086, 0.350641890608830, 0.066068747264339, -0.046717659215117, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476083, 2.746426249302381, -0.792824967172091, 2.242447642325554, 2.140872096444190, -0.331662479035538, 6.499230723708781, 0.095742710775632, -1.876166303929363, -2.155806113731011, 11.055415967851332, 0.000000000000000, 9.440358593314686, 0.000000000000000, -1.462494064565356, -2.047065262876641, 0.000000000000000, 0.422185670932516, 0.590936840285277, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512674, 1.297564437470355, 3.745745886321972, -1.059456926727951, 0.404586796856338, 5.014265364224058, -0.383824736789359, 1.809367161139370, -1.108006575534898, 0.313391585264005, 0.000000000000000, 2.825218471274539, -0.050973145153432, 8.206518066482897, -0.631738055305789, 0.048357371456164, -2.842821248876057, -0.227958835180083, 0.139595707137604, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155349, 1.160576914947998, 1.340118788520980, 1.895214165917371, 0.361873432227875, 1.962141687034864, 2.746426249302388, -0.566421515598880, 3.171299868688374, -1.821988709389514, 0.000000000000000, 11.055415967851328, 1.595711846260563, 0.000000000000000, 8.652231568278273, -0.865042958313569, 0.000000000000000, -2.497684112518217, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419142, 1.005089091390738, -0.193429485824662, 3.556157828809255, -8.461572802128115, 0.000000000000000, 4.459640440343024, 0.000000000000000, -0.858258202906988, 2.670272859251874, 0.000000000000000, 0.000000000000000, 12.437342963832752, 0.000000000000000, 0.000000000000000, 8.427928244224427, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904485, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419127, 0.335029697130247, 4.062019202317982, -0.820651806648292, 0.000000000000000, 1.699264546796649, -0.099103120896516, 5.886425061104582, -1.201561484069795, 0.242752078113805, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730439, -0.214087209644416, 0.012485819621074, 5.138093031466054, -0.741619848709571, 0.151382517704876, -0.030583887092059, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142157, 0.299659670905759, 2.076103099952574, 1.468026580418872, 0.000000000000000, 0.868496237346892, 0.709124208342343, 1.316244658108825, 4.912956630903930, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851330, 3.829708431025353, -0.223353131420165, 0.000000000000000, 5.804093383121946, -1.547435886597321, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307614, 0.259512887494073, 0.749149177264397, 2.754588009492679, 0.000000000000000, -8.461572802128112, 1.151474210368101, 0.000000000000000, 3.324019726604706, 2.068384462742438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832752, 2.176081715527491, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964684, 7.628089872441255, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, -7.521398046336119, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.856348838577673, 0.000000000000000, 2.680237577041958, -0.473803541479346, 0.000000000000000, 0.000000000000015, 0.000000000000000, 5.097793640389933, -0.792824967172092, 0.140152977645346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568710, -0.642261628933261, 0.099886556968584, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.765941686205059, 0.000000000000000, 1.498298354528793, 0.847565541382358, 0.000000000000000, 0.000000000000021, 0.000000000000000, 1.628430445025429, 3.545621041711666, -0.814818121686421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851339, 7.180703308172532, -1.116765657100815, 0.197418142283058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.663324958071082, 0.000000000000000, 0.692034366650859, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128122, 3.070597894314962, 1.194182326351982, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832743, 5.802884574739972, -1.025814758310363, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.541602560309067, 0.000000000000000, 7.628089872441246, 1.797958025434548, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540503, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380282, 3.350296971302450, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-5.361591803435499, 0.000000000000000, 0.000000000000000, 8.899438184514789, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, -5.264978632435287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951776997, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980705, 0.000000000000000, 0.016731627831579, -0.005915523749999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010158730158730, -0.006598288790739, 0.003591653491741, -0.001269841269841, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022830048252724, -0.016335852743261, 0.010610447601109, -0.005775596125612, 0.002041981592908};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000015, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.582575694955846, 0.000000000000000, 8.366600265340757, -1.183215956619919, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713676, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.499090833946989, 0.000000000000000, -3.346640106136303, -2.366431913239847, 15.491933384829673, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949244, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439074, -0.828078671210814, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000022, 4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012749, 0.000000000000000, 0.000000000000012, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.600000000000005, 0.000000000000000, 8.763560920082664, -1.549193338482967, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832535, -1.481312159636085, 0.261861468283198, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.117691453623980, 0.000000000000000, 3.162277660168386, 4.919349550499540, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 10.690449676496987, -2.418972627259045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.545584412271586, 0.000000000000000, 0.000000000000000, 7.668115805072332, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 10.369185117452595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360416, -3.433032811627989, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348575, 0.000000000000000, 0.000000000000000, 0.611677741841197, 0.529728463363978, 0.432521479156786, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.531372124791041, 0.000000000000000, 3.545621041711674, -2.507132682112038, 4.787135538781693, 0.000000000000000, 0.000000000000000, -5.566267450754891, -1.048808848170150, 0.741619848709561, 0.000000000000000, 18.803495115840249, -0.603122387046457, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744170, 0.701283781217658, 0.132137494528681, -0.093435318430234, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.052982440952155, 0.000000000000000, -1.585649934344182, 4.484895284651103, 4.281744192888372, 0.000000000000000, 0.000000000000014, 0.191485421551267, -3.752332607858732, -4.311612227462033, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570558, 1.044638617546682, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448128, -0.767649473578741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611578, 0.096714742912336, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.321153829895993, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604781, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556546, -1.730085916627139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.010178182781469, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 8.919280880686049, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.966479394838264, 0.000000000000000, 8.124038404635964, -1.641303613296584, 0.000000000000000, 0.000000000000019, 0.000000000000000, 11.772850122209158, -2.403122968139590, 0.485504156227610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419140, 0.302765035409750, -0.061167774184119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.653299832284321, 0.000000000000000, 4.152206199905147, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000012, 2.632489316217646, 9.825913261807854, -2.822612771377404, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243895, -3.094871773194642, 0.683876505540237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.297825058615216, 0.000000000000000, 1.498298354528788, 5.509176018985353, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, 6.648039453209416, 4.136768925484869, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384183, -3.553526561095072, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000010, 0.000000000000000},
      {1.876166303929381, 0.000000000000000, 0.000000000000000, 6.228309299857693, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 11.054152419533846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477930, 7.245688373094714, 4.183300132670375, -0.591607978309958, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856838, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.645751311064588, 0.000000000000000, 9.660917830792961, 0.683130051063973, 0.000000000000000, -0.000000000000012, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806686, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724439, 2.449489742783176, 2.828427124746188, -1.000000000000000, 9.165151389911681, 7.099295739719528, -0.414039335605404, -2.049390153191921, -0.478091443733753, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749821, 2.121320343559639, -0.408248290463867, 3.175426480542948, 0.000000000000000, 0.000000000000000, 7.171371656006367, 0.000000000000000, -1.380131118684707, -1.561440116717645, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.799999999999991, -5.692099788303085, 4.381780460041330, -0.774596669241485, 0.000000000000000, 10.998181667894016, 0.962140470884738, 4.762352359916262, -0.740656079818044, 0.130930734141592, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726812004, 2.738612787525827, 1.581138830084190, 2.459674775249773, 0.000000000000000, 0.000000000000000, 9.258200997725526, 0.000000000000000, 5.345224838248503, -1.209486313629514, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135793, 0.000000000000000, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726298, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.196152422706633, 0.000000000000000, -3.162277660168380, -2.236067977499793, 0.000000000000000, 0.000000000000019, 0.000000000000000, 13.747727084867531, 0.534522483824850, 0.377964473009229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.799999999999995, 0.000000000000000, 3.651483716701115, -2.840187787218778, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967382, 1.396594497510367, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.204540768504874, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 8.979977728257483, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395517, 3.070597894314957, 1.772810520855838, -1.253566341056019, 2.393567769390846, 6.303768714031311, -0.908295106229247, -2.783133725377445, -0.524404424085076, 0.370809924354775, 11.124297730643494, 9.401747557920128, -0.301561193523228, -2.427520781138059, -0.794200206656966, 0.114434427054268, 0.840917865872084, 0.350641890608829, 0.066068747264341, -0.046717659215116, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476090, 2.746426249302381, -0.792824967172095, 2.242447642325554, 2.140872096444193, -0.331662479035539, 6.499230723708785, 0.095742710775635, -1.876166303929359, -2.155806113731007, 0.000000000000000, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565358, -2.047065262876643, 0.000000000000000, 0.422185670932518, 0.590936840285276, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512682, 1.297564437470358, 3.745745886321972, -1.059456926727953, -8.091735937126879, 5.014265364224070, -0.383824736789362, 1.809367161139368, -1.108006575534899, 0.313391585264004, 0.000000000000000, 12.713483120735424, 1.019462903068663, 8.206518066482904, -0.631738055305790, 0.048357371456164, -2.842821248876059, -0.227958835180083, 0.139595707137605, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155341, 1.160576914947996, 1.340118788520980, 1.895214165917369, 2.533114025595109, 1.962141687034856, 2.746426249302398, -0.566421515598880, 3.171299868688391, -1.821988709389511, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278271, -0.865042958313574, 0.000000000000000, -2.497684112518216, -0.998865569685860, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419144, 1.005089091390737, -0.193429485824666, 3.556157828809262, 0.000000000000000, 0.000000000000000, 4.459640440343021, 0.000000000000000, -0.858258202906996, 2.670272859251876, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837941, -2.293791531904487, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419135, 7.035623639735146, 4.062019202317985, -0.820651806648288, 0.000000000000000, -6.797058187186559, -2.081165538826753, 5.886425061104583, -1.201561484069790, 0.242752078113812, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191315, 0.856348838577677, 0.262202212042537, 5.138093031466055, -0.741619848709572, 0.151382517704875, -0.030583887092061, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142149, -2.696937038151818, 2.076103099952576, 1.468026580418868, 0.000000000000000, 3.039736830714131, -6.382117875081014, 1.316244658108819, 4.912956630903924, -1.411306385688709, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588737, 2.010178182781474, 0.000000000000000, 5.804093383121951, -1.547435886597320, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307613, 1.297564437470354, 0.749149177264397, 2.754588009492676, 0.000000000000000, 0.000000000000014, 5.757371051840542, 0.000000000000000, 3.324019726604708, 2.068384462742436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637450, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547538, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964691, 0.000000000000000, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739974, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.425395354310717, 0.000000000000000, 9.380831519646852, 1.895214165917370, 0.000000000000000, 0.000000000000014, -0.000000000000011, -3.398529093593296, -2.774887385102335, -0.560611910581403, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288837, 0.349602949390049, 0.070630461781863, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.829708431025348, 0.000000000000000, -1.498298354528785, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.799671038392669, -3.545621041711684, -4.074090608432072, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735906, 1.116765657100820, 0.987090711415291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.326649916142165, 0.000000000000000, 1.730085916627145, -3.180724257574227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787415, -2.388364652703959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849925, 2.051629516620721, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.624807680927203, 0.000000000000000, 0.000000000000000, 5.393874076303637, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 9.573176812621536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907356, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477925, 1.449137674618941, 4.183300132670376, -0.591607978309959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386981, 7.099295739719543, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.080123449734647, 0.000000000000000, 7.099295739719539, 2.509980079602229, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.818813079129868, 0.000000000000000, 0.000000000000000, 8.874119674649423, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724452, 2.449489742783174, 2.828427124746189, -0.999999999999998, 1.309307341415954, 7.099295739719525, -0.414039335605411, -2.049390153191916, -0.478091443733754, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749807, 2.121320343559641, -0.408248290463868, 3.175426480542944, 9.071147352221457, 0.000000000000000, 7.171371656006376, 0.000000000000000, -1.380131118684704, -1.561440116717650, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.800000000000003, 0.632455532033676, 4.381780460041331, -0.774596669241484, 0.000000000000000, 3.142337619398289, -0.106904496764963, 4.762352359916268, -0.740656079818041, 0.130930734141599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726811988, 0.547722557505165, 1.581138830084189, 2.459674775249768, 0.000000000000000, 9.071147352221443, 1.851640199545105, 0.000000000000000, 5.345224838248499, -1.209486313629522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135797, -6.260990336999408, 0.000000000000000, 3.834057902536167, 0.000000000000000, 0.000000000000012, 10.583005244258372, 0.000000000000000, 0.000000000000000, 5.184592558726301, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011},
      {1.039230484541326, 0.000000000000000, 3.162277660168380, -0.447213595499958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371797, -0.534522483824851, 0.075592894601844, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.899999999999998, 0.000000000000000, 1.460593486680449, 1.420093893609383, 0.000000000000000, 0.000000000000011, 0.000000000000000, 9.071147352221454, 4.937707198786950, -0.698297248755173, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.734846922834953, 0.000000000000000, -6.260990336999408, 2.213594362117863, 0.000000000000000, 0.000000000000014, -0.000000000000016, 0.000000000000000, 10.583005244258382, 2.993325909419166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.715767664977308, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395520, 3.070597894314956, 1.772810520855835, -1.253566341056019, 2.393567769390845, 6.303768714031312, -0.908295106229243, -2.783133725377444, -0.524404424085074, 0.370809924354780, 1.236033081182610, 9.401747557920134, -0.301561193523228, -2.427520781138059, -0.794200206656968, 0.114434427054267, 0.840917865872086, 0.350641890608830, 0.066068747264339, -0.046717659215117, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476083, 2.746426249302381, -0.792824967172091, 2.242447642325554, 2.140872096444190, -0.331662479035538, 6.499230723708781, 0.095742710775632, -1.876166303929363, -2.155806113731011, 11.055415967851332, 0.000000000000000, 9.440358593314686, 0.000000000000000, -1.462494064565356, -2.047065262876641, 0.000000000000000, 0.422185670932516, 0.590936840285277, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512674, 1.297564437470355, 3.745745886321972, -1.059456926727951, 0.404586796856338, 5.014265364224058, -0.383824736789359, 1.809367161139370, -1.108006575534898, 0.313391585264005, 0.000000000000000, 2.825218471274539, -0.050973145153432, 8.206518066482897, -0.631738055305789, 0.048357371456164, -2.842821248876057, -0.227958835180083, 0.139595707137604, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155349, 1.160576914947998, 1.340118788520980, 1.895214165917371, 0.361873432227875, 1.962141687034864, 2.746426249302388, -0.566421515598880, 3.171299868688374, -1.821988709389514, 0.000000000000000, 11.055415967851328, 1.595711846260563, 0.000000000000000, 8.652231568278273, -0.865042958313569, 0.000000000000000, -2.497684112518217, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419142, 1.005089091390738, -0.193429485824662, 3.556157828809255, -8.461572802128115, 0.000000000000000, 4.459640440343024, 0.000000000000000, -0.858258202906988, 2.670272859251874, 0.000000000000000, 0.000000000000000, 12.437342963832752, 0.000000000000000, 0.000000000000000, 8.427928244224427, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904485, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419127, 0.335029697130247, 4.062019202317982, -0.820651806648292, 0.000000000000000, 1.699264546796649, -0.099103120896516, 5.886425061104582, -1.201561484069795, 0.242752078113805, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730439, -0.214087209644416, 0.012485819621074, 5.138093031466054, -0.741619848709571, 0.151382517704876, -0.030583887092059, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142157, 0.299659670905759, 2.076103099952574, 1.468026580418872, 0.000000000000000, 0.868496237346892, 0.709124208342343, 1.316244658108825, 4.912956630903930, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851330, 3.829708431025353, -0.223353131420165, 0.000000000000000, 5.804093383121946, -1.547435886597321, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307614, 0.259512887494073, 0.749149177264397, 2.754588009492679, 0.000000000000000, -8.461572802128112, 1.151474210368101, 0.000000000000000, 3.324019726604706, 2.068384462742438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832752, 2.176081715527491, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964684, 7.628089872441255, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, -7.521398046336119, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.856348838577673, 0.000000000000000, 2.680237577041958, -0.473803541479346, 0.000000000000000, 0.000000000000015, 0.000000000000000, 5.097793640389933, -0.792824967172092, 0.140152977645346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568710, -0.642261628933261, 0.099886556968584, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.765941686205059, 0.000000000000000, 1.498298354528793, 0.847565541382358, 0.000000000000000, 0.000000000000021, 0.000000000000000, 1.628430445025429, 3.545621041711666, -0.814818121686421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851339, 7.180703308172532, -1.116765657100815, 0.197418142283058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.663324958071082, 0.000000000000000, 0.692034366650859, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128122, 3.070597894314962, 1.194182326351982, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832743, 5.802884574739972, -1.025814758310363, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.541602560309067, 0.000000000000000, 7.628089872441246, 1.797958025434548, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540503, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380282, 3.350296971302450, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-5.361591803435499, 0.000000000000000, 0.000000000000000, 8.899438184514789, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, -5.264978632435287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951776997, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.013746434980705, 0.000000000000000, 0.000000000000000, 0.017746571249998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012698412698413, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.030629723893614};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000015, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.582575694955846, 0.000000000000000, 8.366600265340757, -1.183215956619919, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713676, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.499090833946989, 0.000000000000000, -3.346640106136303, -2.366431913239847, 15.491933384829673, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949244, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439074, -0.828078671210814, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000022, 4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012749, 0.000000000000000, 0.000000000000012, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.600000000000005, 0.000000000000000, 8.763560920082664, -1.549193338482967, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832535, -1.481312159636085, 0.261861468283198, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.117691453623980, 0.000000000000000, 3.162277660168386, 4.919349550499540, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 10.690449676496987, -2.418972627259045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.545584412271586, 0.000000000000000, 0.000000000000000, 7.668115805072332, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 10.369185117452595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360416, -3.433032811627989, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348575, 0.000000000000000, 0.000000000000000, 0.611677741841197, 0.529728463363978, 0.432521479156786, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.531372124791041, 0.000000000000000, 3.545621041711674, -2.507132682112038, 4.787135538781693, 0.000000000000000, 0.000000000000000, -5.566267450754891, -1.048808848170150, 0.741619848709561, 0.000000000000000, 18.803495115840249, -0.603122387046457, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744170, 0.701283781217658, 0.132137494528681, -0.093435318430234, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.052982440952155, 0.000000000000000, -1.585649934344182, 4.484895284651103, 4.281744192888372, 0.000000000000000, 0.000000000000014, 0.191485421551267, -3.752332607858732, -4.311612227462033, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570558, 1.044638617546682, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448128, -0.767649473578741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611578, 0.096714742912336, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.321153829895993, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604781, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556546, -1.730085916627139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.010178182781469, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 8.919280880686049, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.966479394838264, 0.000000000000000, 8.124038404635964, -1.641303613296584, 0.000000000000000, 0.000000000000019, 0.000000000000000, 11.772850122209158, -2.403122968139590, 0.485504156227610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419140, 0.302765035409750, -0.061167774184119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.653299832284321, 0.000000000000000, 4.152206199905147, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000012, 2.632489316217646, 9.825913261807854, -2.822612771377404, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243895, -3.094871773194642, 0.683876505540237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.297825058615216, 0.000000000000000, 1.498298354528788, 5.509176018985353, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, 6.648039453209416, 4.136768925484869, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384183, -3.553526561095072, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000010, 0.000000000000000},
      {1.876166303929381, 0.000000000000000, 0.000000000000000, 6.228309299857693, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 11.054152419533846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477930, 7.245688373094714, 4.183300132670375, -0.591607978309958, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856838, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.645751311064588, 0.000000000000000, 9.660917830792961, 0.683130051063973, 0.000000000000000, -0.000000000000012, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806686, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724439, 2.449489742783176, 2.828427124746188, -1.000000000000000, 9.165151389911681, 7.099295739719528, -0.414039335605404, -2.049390153191921, -0.478091443733753, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749821, 2.121320343559639, -0.408248290463867, 3.175426480542948, 0.000000000000000, 0.000000000000000, 7.171371656006367, 0.000000000000000, -1.380131118684707, -1.561440116717645, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.799999999999991, -5.692099788303085, 4.381780460041330, -0.774596669241485, 0.000000000000000, 10.998181667894016, 0.962140470884738, 4.762352359916262, -0.740656079818044, 0.130930734141592, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726812004, 2.738612787525827, 1.581138830084190, 2.459674775249773, 0.000000000000000, 0.000000000000000, 9.258200997725526, 0.000000000000000, 5.345224838248503, -1.209486313629514, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135793, 0.000000000000000, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726298, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.196152422706633, 0.000000000000000, -3.162277660168380, -2.236067977499793, 0.000000000000000, 0.000000000000019, 0.000000000000000, 13.747727084867531, 0.534522483824850, 0.377964473009229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.799999999999995, 0.000000000000000, 3.651483716701115, -2.840187787218778, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967382, 1.396594497510367, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.204540768504874, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 8.979977728257483, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395517, 3.070597894314957, 1.772810520855838, -1.253566341056019, 2.393567769390846, 6.303768714031311, -0.908295106229247, -2.783133725377445, -0.524404424085076, 0.370809924354775, 11.124297730643494, 9.401747557920128, -0.301561193523228, -2.427520781138059, -0.794200206656966, 0.114434427054268, 0.840917865872084, 0.350641890608829, 0.066068747264341, -0.046717659215116, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476090, 2.746426249302381, -0.792824967172095, 2.242447642325554, 2.140872096444193, -0.331662479035539, 6.499230723708785, 0.095742710775635, -1.876166303929359, -2.155806113731007, 0.000000000000000, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565358, -2.047065262876643, 0.000000000000000, 0.422185670932518, 0.590936840285276, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512682, 1.297564437470358, 3.745745886321972, -1.059456926727953, -8.091735937126879, 5.014265364224070, -0.383824736789362, 1.809367161139368, -1.108006575534899, 0.313391585264004, 0.000000000000000, 12.713483120735424, 1.019462903068663, 8.206518066482904, -0.631738055305790, 0.048357371456164, -2.842821248876059, -0.227958835180083, 0.139595707137605, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155341, 1.160576914947996, 1.340118788520980, 1.895214165917369, 2.533114025595109, 1.962141687034856, 2.746426249302398, -0.566421515598880, 3.171299868688391, -1.821988709389511, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278271, -0.865042958313574, 0.000000000000000, -2.497684112518216, -0.998865569685860, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419144, 1.005089091390737, -0.193429485824666, 3.556157828809262, 0.000000000000000, 0.000000000000000, 4.459640440343021, 0.000000000000000, -0.858258202906996, 2.670272859251876, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837941, -2.293791531904487, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419135, 7.035623639735146, 4.062019202317985, -0.820651806648288, 0.000000000000000, -6.797058187186559, -2.081165538826753, 5.886425061104583, -1.201561484069790, 0.242752078113812, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191315, 0.856348838577677, 0.262202212042537, 5.138093031466055, -0.741619848709572, 0.151382517704875, -0.030583887092061, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142149, -2.696937038151818, 2.076103099952576, 1.468026580418868, 0.000000000000000, 3.039736830714131, -6.382117875081014, 1.316244658108819, 4.912956630903924, -1.411306385688709, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588737, 2.010178182781474, 0.000000000000000, 5.804093383121951, -1.547435886597320, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307613, 1.297564437470354, 0.749149177264397, 2.754588009492676, 0.000000000000000, 0.000000000000014, 5.757371051840542, 0.000000000000000, 3.324019726604708, 2.068384462742436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637450, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547538, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964691, 0.000000000000000, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739974, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.425395354310717, 0.000000000000000, 9.380831519646852, 1.895214165917370, 0.000000000000000, 0.000000000000014, -0.000000000000011, -3.398529093593296, -2.774887385102335, -0.560611910581403, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288837, 0.349602949390049, 0.070630461781863, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.829708431025348, 0.000000000000000, -1.498298354528785, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.799671038392669, -3.545621041711684, -4.074090608432072, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735906, 1.116765657100820, 0.987090711415291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.326649916142165, 0.000000000000000, 1.730085916627145, -3.180724257574227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787415, -2.388364652703959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849925, 2.051629516620721, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.624807680927203, 0.000000000000000, 0.000000000000000, 5.393874076303637, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 9.573176812621536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907356, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477925, 1.449137674618941, 4.183300132670376, -0.591607978309959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386981, 7.099295739719543, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.080123449734647, 0.000000000000000, 7.099295739719539, 2.509980079602229, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.818813079129868, 0.000000000000000, 0.000000000000000, 8.874119674649423, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724452, 2.449489742783174, 2.828427124746189, -0.999999999999998, 1.309307341415954, 7.099295739719525, -0.414039335605411, -2.049390153191916, -0.478091443733754, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749807, 2.121320343559641, -0.408248290463868, 3.175426480542944, 9.071147352221457, 0.000000000000000, 7.171371656006376, 0.000000000000000, -1.380131118684704, -1.561440116717650, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.800000000000003, 0.632455532033676, 4.381780460041331, -0.774596669241484, 0.000000000000000, 3.142337619398289, -0.106904496764963, 4.762352359916268, -0.740656079818041, 0.130930734141599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726811988, 0.547722557505165, 1.581138830084189, 2.459674775249768, 0.000000000000000, 9.071147352221443, 1.851640199545105, 0.000000000000000, 5.345224838248499, -1.209486313629522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135797, -6.260990336999408, 0.000000000000000, 3.834057902536167, 0.000000000000000, 0.000000000000012, 10.583005244258372, 0.000000000000000, 0.000000000000000, 5.184592558726301, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011},
      {1.039230484541326, 0.000000000000000, 3.162277660168380, -0.447213595499958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371797, -0.534522483824851, 0.075592894601844, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.899999999999998, 0.000000000000000, 1.460593486680449, 1.420093893609383, 0.000000000000000, 0.000000000000011, 0.000000000000000, 9.071147352221454, 4.937707198786950, -0.698297248755173, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.734846922834953, 0.000000000000000, -6.260990336999408, 2.213594362117863, 0.000000000000000, 0.000000000000014, -0.000000000000016, 0.000000000000000, 10.583005244258382, 2.993325909419166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.715767664977308, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395520, 3.070597894314956, 1.772810520855835, -1.253566341056019, 2.393567769390845, 6.303768714031312, -0.908295106229243, -2.783133725377444, -0.524404424085074, 0.370809924354780, 1.236033081182610, 9.401747557920134, -0.301561193523228, -2.427520781138059, -0.794200206656968, 0.114434427054267, 0.840917865872086, 0.350641890608830, 0.066068747264339, -0.046717659215117, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476083, 2.746426249302381, -0.792824967172091, 2.242447642325554, 2.140872096444190, -0.331662479035538, 6.499230723708781, 0.095742710775632, -1.876166303929363, -2.155806113731011, 11.055415967851332, 0.000000000000000, 9.440358593314686, 0.000000000000000, -1.462494064565356, -2.047065262876641, 0.000000000000000, 0.422185670932516, 0.590936840285277, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512674, 1.297564437470355, 3.745745886321972, -1.059456926727951, 0.404586796856338, 5.014265364224058, -0.383824736789359, 1.809367161139370, -1.108006575534898, 0.313391585264005, 0.000000000000000, 2.825218471274539, -0.050973145153432, 8.206518066482897, -0.631738055305789, 0.048357371456164, -2.842821248876057, -0.227958835180083, 0.139595707137604, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155349, 1.160576914947998, 1.340118788520980, 1.895214165917371, 0.361873432227875, 1.962141687034864, 2.746426249302388, -0.566421515598880, 3.171299868688374, -1.821988709389514, 0.000000000000000, 11.055415967851328, 1.595711846260563, 0.000000000000000, 8.652231568278273, -0.865042958313569, 0.000000000000000, -2.497684112518217, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419142, 1.005089091390738, -0.193429485824662, 3.556157828809255, -8.461572802128115, 0.000000000000000, 4.459640440343024, 0.000000000000000, -0.858258202906988, 2.670272859251874, 0.000000000000000, 0.000000000000000, 12.437342963832752, 0.000000000000000, 0.000000000000000, 8.427928244224427, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904485, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419127, 0.335029697130247, 4.062019202317982, -0.820651806648292, 0.000000000000000, 1.699264546796649, -0.099103120896516, 5.886425061104582, -1.201561484069795, 0.242752078113805, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730439, -0.214087209644416, 0.012485819621074, 5.138093031466054, -0.741619848709571, 0.151382517704876, -0.030583887092059, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142157, 0.299659670905759, 2.076103099952574, 1.468026580418872, 0.000000000000000, 0.868496237346892, 0.709124208342343, 1.316244658108825, 4.912956630903930, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851330, 3.829708431025353, -0.223353131420165, 0.000000000000000, 5.804093383121946, -1.547435886597321, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307614, 0.259512887494073, 0.749149177264397, 2.754588009492679, 0.000000000000000, -8.461572802128112, 1.151474210368101, 0.000000000000000, 3.324019726604706, 2.068384462742438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832752, 2.176081715527491, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964684, 7.628089872441255, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, -7.521398046336119, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.856348838577673, 0.000000000000000, 2.680237577041958, -0.473803541479346, 0.000000000000000, 0.000000000000015, 0.000000000000000, 5.097793640389933, -0.792824967172092, 0.140152977645346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568710, -0.642261628933261, 0.099886556968584, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.765941686205059, 0.000000000000000, 1.498298354528793, 0.847565541382358, 0.000000000000000, 0.000000000000021, 0.000000000000000, 1.628430445025429, 3.545621041711666, -0.814818121686421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851339, 7.180703308172532, -1.116765657100815, 0.197418142283058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.663324958071082, 0.000000000000000, 0.692034366650859, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128122, 3.070597894314962, 1.194182326351982, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832743, 5.802884574739972, -1.025814758310363, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.541602560309067, 0.000000000000000, 7.628089872441246, 1.797958025434548, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540503, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380282, 3.350296971302450, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-5.361591803435499, 0.000000000000000, 0.000000000000000, 8.899438184514789, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, -5.264978632435287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951776997, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {0.043988591938257, 0.000000000000000, 0.026770604530526, 0.018929675999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.058191437396265, -0.031675406448880, 0.011198947348422, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040634920634921, 0.004398859193826, -0.014366613966965, 0.007619047619048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036755668672337, -0.042441790404437, 0.030321879659465, -0.012251889557446};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000015, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.582575694955846, 0.000000000000000, 8.366600265340757, -1.183215956619919, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713676, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.499090833946989, 0.000000000000000, -3.346640106136303, -2.366431913239847, 15.491933384829673, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949244, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439074, -0.828078671210814, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000022, 4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012749, 0.000000000000000, 0.000000000000012, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.600000000000005, 0.000000000000000, 8.763560920082664, -1.549193338482967, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832535, -1.481312159636085, 0.261861468283198, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.117691453623980, 0.000000000000000, 3.162277660168386, 4.919349550499540, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 10.690449676496987, -2.418972627259045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.545584412271586, 0.000000000000000, 0.000000000000000, 7.668115805072332, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 10.369185117452595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360416, -3.433032811627989, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348575, 0.000000000000000, 0.000000000000000, 0.611677741841197, 0.529728463363978, 0.432521479156786, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.531372124791041, 0.000000000000000, 3.545621041711674, -2.507132682112038, 4.787135538781693, 0.000000000000000, 0.000000000000000, -5.566267450754891, -1.048808848170150, 0.741619848709561, 0.000000000000000, 18.803495115840249, -0.603122387046457, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744170, 0.701283781217658, 0.132137494528681, -0.093435318430234, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.052982440952155, 0.000000000000000, -1.585649934344182, 4.484895284651103, 4.281744192888372, 0.000000000000000, 0.000000000000014, 0.191485421551267, -3.752332607858732, -4.311612227462033, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570558, 1.044638617546682, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448128, -0.767649473578741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611578, 0.096714742912336, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.321153829895993, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604781, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556546, -1.730085916627139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.010178182781469, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 8.919280880686049, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.966479394838264, 0.000000000000000, 8.124038404635964, -1.641303613296584, 0.000000000000000, 0.000000000000019, 0.000000000000000, 11.772850122209158, -2.403122968139590, 0.485504156227610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419140, 0.302765035409750, -0.061167774184119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.653299832284321, 0.000000000000000, 4.152206199905147, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000012, 2.632489316217646, 9.825913261807854, -2.822612771377404, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243895, -3.094871773194642, 0.683876505540237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.297825058615216, 0.000000000000000, 1.498298354528788, 5.509176018985353, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, 6.648039453209416, 4.136768925484869, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384183, -3.553526561095072, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000010, 0.000000000000000},
      {1.876166303929381, 0.000000000000000, 0.000000000000000, 6.228309299857693, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 11.054152419533846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477930, 7.245688373094714, 4.183300132670375, -0.591607978309958, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856838, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.645751311064588, 0.000000000000000, 9.660917830792961, 0.683130051063973, 0.000000000000000, -0.000000000000012, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806686, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724439, 2.449489742783176, 2.828427124746188, -1.000000000000000, 9.165151389911681, 7.099295739719528, -0.414039335605404, -2.049390153191921, -0.478091443733753, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749821, 2.121320343559639, -0.408248290463867, 3.175426480542948, 0.000000000000000, 0.000000000000000, 7.171371656006367, 0.000000000000000, -1.380131118684707, -1.561440116717645, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.799999999999991, -5.692099788303085, 4.381780460041330, -0.774596669241485, 0.000000000000000, 10.998181667894016, 0.962140470884738, 4.762352359916262, -0.740656079818044, 0.130930734141592, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726812004, 2.738612787525827, 1.581138830084190, 2.459674775249773, 0.000000000000000, 0.000000000000000, 9.258200997725526, 0.000000000000000, 5.345224838248503, -1.209486313629514, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135793, 0.000000000000000, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726298, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.196152422706633, 0.000000000000000, -3.162277660168380, -2.236067977499793, 0.000000000000000, 0.000000000000019, 0.000000000000000, 13.747727084867531, 0.534522483824850, 0.377964473009229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.799999999999995, 0.000000000000000, 3.651483716701115, -2.840187787218778, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967382, 1.396594497510367, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.204540768504874, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 8.979977728257483, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395517, 3.070597894314957, 1.772810520855838, -1.253566341056019, 2.393567769390846, 6.303768714031311, -0.908295106229247, -2.783133725377445, -0.524404424085076, 0.370809924354775, 11.124297730643494, 9.401747557920128, -0.301561193523228, -2.427520781138059, -0.794200206656966, 0.114434427054268, 0.840917865872084, 0.350641890608829, 0.066068747264341, -0.046717659215116, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476090, 2.746426249302381, -0.792824967172095, 2.242447642325554, 2.140872096444193, -0.331662479035539, 6.499230723708785, 0.095742710775635, -1.876166303929359, -2.155806113731007, 0.000000000000000, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565358, -2.047065262876643, 0.000000000000000, 0.422185670932518, 0.590936840285276, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512682, 1.297564437470358, 3.745745886321972, -1.059456926727953, -8.091735937126879, 5.014265364224070, -0.383824736789362, 1.809367161139368, -1.108006575534899, 0.313391585264004, 0.000000000000000, 12.713483120735424, 1.019462903068663, 8.206518066482904, -0.631738055305790, 0.048357371456164, -2.842821248876059, -0.227958835180083, 0.139595707137605, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155341, 1.160576914947996, 1.340118788520980, 1.895214165917369, 2.533114025595109, 1.962141687034856, 2.746426249302398, -0.566421515598880, 3.171299868688391, -1.821988709389511, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278271, -0.865042958313574, 0.000000000000000, -2.497684112518216, -0.998865569685860, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419144, 1.005089091390737, -0.193429485824666, 3.556157828809262, 0.000000000000000, 0.000000000000000, 4.459640440343021, 0.000000000000000, -0.858258202906996, 2.670272859251876, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837941, -2.293791531904487, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419135, 7.035623639735146, 4.062019202317985, -0.820651806648288, 0.000000000000000, -6.797058187186559, -2.081165538826753, 5.886425061104583, -1.201561484069790, 0.242752078113812, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191315, 0.856348838577677, 0.262202212042537, 5.138093031466055, -0.741619848709572, 0.151382517704875, -0.030583887092061, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142149, -2.696937038151818, 2.076103099952576, 1.468026580418868, 0.000000000000000, 3.039736830714131, -6.382117875081014, 1.316244658108819, 4.912956630903924, -1.411306385688709, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588737, 2.010178182781474, 0.000000000000000, 5.804093383121951, -1.547435886597320, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307613, 1.297564437470354, 0.749149177264397, 2.754588009492676, 0.000000000000000, 0.000000000000014, 5.757371051840542, 0.000000000000000, 3.324019726604708, 2.068384462742436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637450, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547538, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964691, 0.000000000000000, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739974, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.425395354310717, 0.000000000000000, 9.380831519646852, 1.895214165917370, 0.000000000000000, 0.000000000000014, -0.000000000000011, -3.398529093593296, -2.774887385102335, -0.560611910581403, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288837, 0.349602949390049, 0.070630461781863, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.829708431025348, 0.000000000000000, -1.498298354528785, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.799671038392669, -3.545621041711684, -4.074090608432072, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735906, 1.116765657100820, 0.987090711415291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.326649916142165, 0.000000000000000, 1.730085916627145, -3.180724257574227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787415, -2.388364652703959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849925, 2.051629516620721, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.624807680927203, 0.000000000000000, 0.000000000000000, 5.393874076303637, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 9.573176812621536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907356, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477925, 1.449137674618941, 4.183300132670376, -0.591607978309959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386981, 7.099295739719543, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.080123449734647, 0.000000000000000, 7.099295739719539, 2.509980079602229, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.818813079129868, 0.000000000000000, 0.000000000000000, 8.874119674649423, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724452, 2.449489742783174, 2.828427124746189, -0.999999999999998, 1.309307341415954, 7.099295739719525, -0.414039335605411, -2.049390153191916, -0.478091443733754, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749807, 2.121320343559641, -0.408248290463868, 3.175426480542944, 9.071147352221457, 0.000000000000000, 7.171371656006376, 0.000000000000000, -1.380131118684704, -1.561440116717650, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.800000000000003, 0.632455532033676, 4.381780460041331, -0.774596669241484, 0.000000000000000, 3.142337619398289, -0.106904496764963, 4.762352359916268, -0.740656079818041, 0.130930734141599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726811988, 0.547722557505165, 1.581138830084189, 2.459674775249768, 0.000000000000000, 9.071147352221443, 1.851640199545105, 0.000000000000000, 5.345224838248499, -1.209486313629522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135797, -6.260990336999408, 0.000000000000000, 3.834057902536167, 0.000000000000000, 0.000000000000012, 10.583005244258372, 0.000000000000000, 0.000000000000000, 5.184592558726301, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011},
      {1.039230484541326, 0.000000000000000, 3.162277660168380, -0.447213595499958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371797, -0.534522483824851, 0.075592894601844, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.899999999999998, 0.000000000000000, 1.460593486680449, 1.420093893609383, 0.000000000000000, 0.000000000000011, 0.000000000000000, 9.071147352221454, 4.937707198786950, -0.698297248755173, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.734846922834953, 0.000000000000000, -6.260990336999408, 2.213594362117863, 0.000000000000000, 0.000000000000014, -0.000000000000016, 0.000000000000000, 10.583005244258382, 2.993325909419166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.715767664977308, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395520, 3.070597894314956, 1.772810520855835, -1.253566341056019, 2.393567769390845, 6.303768714031312, -0.908295106229243, -2.783133725377444, -0.524404424085074, 0.370809924354780, 1.236033081182610, 9.401747557920134, -0.301561193523228, -2.427520781138059, -0.794200206656968, 0.114434427054267, 0.840917865872086, 0.350641890608830, 0.066068747264339, -0.046717659215117, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476083, 2.746426249302381, -0.792824967172091, 2.242447642325554, 2.140872096444190, -0.331662479035538, 6.499230723708781, 0.095742710775632, -1.876166303929363, -2.155806113731011, 11.055415967851332, 0.000000000000000, 9.440358593314686, 0.000000000000000, -1.462494064565356, -2.047065262876641, 0.000000000000000, 0.422185670932516, 0.590936840285277, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512674, 1.297564437470355, 3.745745886321972, -1.059456926727951, 0.404586796856338, 5.014265364224058, -0.383824736789359, 1.809367161139370, -1.108006575534898, 0.313391585264005, 0.000000000000000, 2.825218471274539, -0.050973145153432, 8.206518066482897, -0.631738055305789, 0.048357371456164, -2.842821248876057, -0.227958835180083, 0.139595707137604, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155349, 1.160576914947998, 1.340118788520980, 1.895214165917371, 0.361873432227875, 1.962141687034864, 2.746426249302388, -0.566421515598880, 3.171299868688374, -1.821988709389514, 0.000000000000000, 11.055415967851328, 1.595711846260563, 0.000000000000000, 8.652231568278273, -0.865042958313569, 0.000000000000000, -2.497684112518217, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419142, 1.005089091390738, -0.193429485824662, 3.556157828809255, -8.461572802128115, 0.000000000000000, 4.459640440343024, 0.000000000000000, -0.858258202906988, 2.670272859251874, 0.000000000000000, 0.000000000000000, 12.437342963832752, 0.000000000000000, 0.000000000000000, 8.427928244224427, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904485, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419127, 0.335029697130247, 4.062019202317982, -0.820651806648292, 0.000000000000000, 1.699264546796649, -0.099103120896516, 5.886425061104582, -1.201561484069795, 0.242752078113805, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730439, -0.214087209644416, 0.012485819621074, 5.138093031466054, -0.741619848709571, 0.151382517704876, -0.030583887092059, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142157, 0.299659670905759, 2.076103099952574, 1.468026580418872, 0.000000000000000, 0.868496237346892, 0.709124208342343, 1.316244658108825, 4.912956630903930, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851330, 3.829708431025353, -0.223353131420165, 0.000000000000000, 5.804093383121946, -1.547435886597321, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307614, 0.259512887494073, 0.749149177264397, 2.754588009492679, 0.000000000000000, -8.461572802128112, 1.151474210368101, 0.000000000000000, 3.324019726604706, 2.068384462742438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832752, 2.176081715527491, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964684, 7.628089872441255, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, -7.521398046336119, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.856348838577673, 0.000000000000000, 2.680237577041958, -0.473803541479346, 0.000000000000000, 0.000000000000015, 0.000000000000000, 5.097793640389933, -0.792824967172092, 0.140152977645346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568710, -0.642261628933261, 0.099886556968584, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.765941686205059, 0.000000000000000, 1.498298354528793, 0.847565541382358, 0.000000000000000, 0.000000000000021, 0.000000000000000, 1.628430445025429, 3.545621041711666, -0.814818121686421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851339, 7.180703308172532, -1.116765657100815, 0.197418142283058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.663324958071082, 0.000000000000000, 0.692034366650859, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128122, 3.070597894314962, 1.194182326351982, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832743, 5.802884574739972, -1.025814758310363, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.541602560309067, 0.000000000000000, 7.628089872441246, 1.797958025434548, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540503, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380282, 3.350296971302450, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-5.361591803435499, 0.000000000000000, 0.000000000000000, 8.899438184514789, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, -5.264978632435287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951776997, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[35] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
      double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 1; t < 4 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          for (unsigned int t = 0; t < 5 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[35] = \
      {-0.032991443953693, 0.000000000000000, -0.020077953397895, -0.014197256999999, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009698572899377, 0.071269664509980, -0.050395263067897, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.046188021535170, 0.010774960475224, -0.019047619047619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.049515422138510, -0.060643759318929, 0.030629723893614};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000015, 11.224972160321826, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.582575694955846, 0.000000000000000, 8.366600265340757, -1.183215956619919, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.741657386773943, 0.000000000000000, 0.000000000000000, 8.694826047713676, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.499090833946989, 0.000000000000000, -3.346640106136303, -2.366431913239847, 15.491933384829673, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949244, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439074, -0.828078671210814, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000022, 4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012749, 0.000000000000000, 0.000000000000012, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.600000000000005, 0.000000000000000, 8.763560920082664, -1.549193338482967, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832535, -1.481312159636085, 0.261861468283198, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.117691453623980, 0.000000000000000, 3.162277660168386, 4.919349550499540, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 10.690449676496987, -2.418972627259045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.545584412271586, 0.000000000000000, 0.000000000000000, 7.668115805072332, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 10.369185117452595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360416, -3.433032811627989, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348575, 0.000000000000000, 0.000000000000000, 0.611677741841197, 0.529728463363978, 0.432521479156786, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.531372124791041, 0.000000000000000, 3.545621041711674, -2.507132682112038, 4.787135538781693, 0.000000000000000, 0.000000000000000, -5.566267450754891, -1.048808848170150, 0.741619848709561, 0.000000000000000, 18.803495115840249, -0.603122387046457, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.681835731744170, 0.701283781217658, 0.132137494528681, -0.093435318430234, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.052982440952155, 0.000000000000000, -1.585649934344182, 4.484895284651103, 4.281744192888372, 0.000000000000000, 0.000000000000014, 0.191485421551267, -3.752332607858732, -4.311612227462033, 0.000000000000000, 0.000000000000000, 18.880717186629369, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570558, 1.044638617546682, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.595128874940712, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.028530728448128, -0.767649473578741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.413036132965797, -1.263476110611578, 0.096714742912336, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.321153829895993, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069717, 5.492852498604781, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.304463136556546, -1.730085916627139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 2.010178182781469, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 8.919280880686049, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.855856488448861, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.966479394838264, 0.000000000000000, 8.124038404635964, -1.641303613296584, 0.000000000000000, 0.000000000000019, 0.000000000000000, 11.772850122209158, -2.403122968139590, 0.485504156227610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.276186062932107, -1.483239697419140, 0.302765035409750, -0.061167774184119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.653299832284321, 0.000000000000000, 4.152206199905147, 2.936053160837740, 0.000000000000000, 0.000000000000000, 0.000000000000012, 2.632489316217646, 9.825913261807854, -2.822612771377404, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.608186766243895, -3.094871773194642, 0.683876505540237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.297825058615216, 0.000000000000000, 1.498298354528788, 5.509176018985353, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, 6.648039453209416, 4.136768925484869, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.563613642384183, -3.553526561095072, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000010, 0.000000000000000},
      {1.876166303929381, 0.000000000000000, 0.000000000000000, 6.228309299857693, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 11.054152419533846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479947, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477930, 7.245688373094714, 4.183300132670375, -0.591607978309958, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856838, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.645751311064588, 0.000000000000000, 9.660917830792961, 0.683130051063973, 0.000000000000000, -0.000000000000012, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806686, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724439, 2.449489742783176, 2.828427124746188, -1.000000000000000, 9.165151389911681, 7.099295739719528, -0.414039335605404, -2.049390153191921, -0.478091443733753, 0.169030850945701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749821, 2.121320343559639, -0.408248290463867, 3.175426480542948, 0.000000000000000, 0.000000000000000, 7.171371656006367, 0.000000000000000, -1.380131118684707, -1.561440116717645, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.799999999999991, -5.692099788303085, 4.381780460041330, -0.774596669241485, 0.000000000000000, 10.998181667894016, 0.962140470884738, 4.762352359916262, -0.740656079818044, 0.130930734141592, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726812004, 2.738612787525827, 1.581138830084190, 2.459674775249773, 0.000000000000000, 0.000000000000000, 9.258200997725526, 0.000000000000000, 5.345224838248503, -1.209486313629514, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135793, 0.000000000000000, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726298, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.196152422706633, 0.000000000000000, -3.162277660168380, -2.236067977499793, 0.000000000000000, 0.000000000000019, 0.000000000000000, 13.747727084867531, 0.534522483824850, 0.377964473009229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.799999999999995, 0.000000000000000, 3.651483716701115, -2.840187787218778, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967382, 1.396594497510367, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.204540768504874, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 8.979977728257483, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395517, 3.070597894314957, 1.772810520855838, -1.253566341056019, 2.393567769390846, 6.303768714031311, -0.908295106229247, -2.783133725377445, -0.524404424085076, 0.370809924354775, 11.124297730643494, 9.401747557920128, -0.301561193523228, -2.427520781138059, -0.794200206656966, 0.114434427054268, 0.840917865872084, 0.350641890608829, 0.066068747264341, -0.046717659215116, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476090, 2.746426249302381, -0.792824967172095, 2.242447642325554, 2.140872096444193, -0.331662479035539, 6.499230723708785, 0.095742710775635, -1.876166303929359, -2.155806113731007, 0.000000000000000, 0.000000000000000, 9.440358593314683, 0.000000000000000, -1.462494064565358, -2.047065262876643, 0.000000000000000, 0.422185670932518, 0.590936840285276, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512682, 1.297564437470358, 3.745745886321972, -1.059456926727953, -8.091735937126879, 5.014265364224070, -0.383824736789362, 1.809367161139368, -1.108006575534899, 0.313391585264004, 0.000000000000000, 12.713483120735424, 1.019462903068663, 8.206518066482904, -0.631738055305790, 0.048357371456164, -2.842821248876059, -0.227958835180083, 0.139595707137605, -0.039483628456610, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155341, 1.160576914947996, 1.340118788520980, 1.895214165917369, 2.533114025595109, 1.962141687034856, 2.746426249302398, -0.566421515598880, 3.171299868688391, -1.821988709389511, 0.000000000000000, 0.000000000000000, 11.169982923823946, 0.000000000000000, 8.652231568278271, -0.865042958313574, 0.000000000000000, -2.497684112518216, -0.998865569685860, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419144, 1.005089091390737, -0.193429485824666, 3.556157828809262, 0.000000000000000, 0.000000000000000, 4.459640440343021, 0.000000000000000, -0.858258202906996, 2.670272859251876, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.427928244224431, 0.000000000000000, 0.000000000000000, -1.621955546837941, -2.293791531904487, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419135, 7.035623639735146, 4.062019202317985, -0.820651806648288, 0.000000000000000, -6.797058187186559, -2.081165538826753, 5.886425061104583, -1.201561484069790, 0.242752078113812, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191315, 0.856348838577677, 0.262202212042537, 5.138093031466055, -0.741619848709572, 0.151382517704875, -0.030583887092061, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142149, -2.696937038151818, 2.076103099952576, 1.468026580418868, 0.000000000000000, 3.039736830714131, -6.382117875081014, 1.316244658108819, 4.912956630903924, -1.411306385688709, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588737, 2.010178182781474, 0.000000000000000, 5.804093383121951, -1.547435886597320, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307613, 1.297564437470354, 0.749149177264397, 2.754588009492676, 0.000000000000000, 0.000000000000014, 5.757371051840542, 0.000000000000000, 3.324019726604708, 2.068384462742436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.880408577637450, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547538, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964691, 0.000000000000000, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739974, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.425395354310717, 0.000000000000000, 9.380831519646852, 1.895214165917370, 0.000000000000000, 0.000000000000014, -0.000000000000011, -3.398529093593296, -2.774887385102335, -0.560611910581403, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.798876369029596, 0.428174419288837, 0.349602949390049, 0.070630461781863, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.829708431025348, 0.000000000000000, -1.498298354528785, 4.237827706911806, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.799671038392669, -3.545621041711684, -4.074090608432072, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.754974385735906, 1.116765657100820, 0.987090711415291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-1.326649916142165, 0.000000000000000, 1.730085916627145, -3.180724257574227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.676494735787415, -2.388364652703959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.507211436849925, 2.051629516620721, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.624807680927203, 0.000000000000000, 0.000000000000000, 5.393874076303637, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 9.573176812621536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907356, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[35][35] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168382, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.958039891549814, 5.612486080160909, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.291287847477925, 1.449137674618941, 4.183300132670376, -0.591607978309959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.870828693386981, 7.099295739719543, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.080123449734647, 0.000000000000000, 7.099295739719539, 2.509980079602229, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-3.818813079129868, 0.000000000000000, 0.000000000000000, 8.874119674649423, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.749545416973501, 5.796550698475775, -1.673320053068152, -1.183215956619922, 7.745966692414836, -1.200000000000003, -0.979795897113270, 0.346410161513777, 0.282842712474624, 0.200000000000004, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.323790007724452, 2.449489742783174, 2.828427124746189, -0.999999999999998, 1.309307341415954, 7.099295739719525, -0.414039335605411, -2.049390153191916, -0.478091443733754, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.012461179749807, 2.121320343559641, -0.408248290463868, 3.175426480542944, 9.071147352221457, 0.000000000000000, 7.171371656006376, 0.000000000000000, -1.380131118684704, -1.561440116717650, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.800000000000003, 0.632455532033676, 4.381780460041331, -0.774596669241484, 0.000000000000000, 3.142337619398289, -0.106904496764963, 4.762352359916268, -0.740656079818041, 0.130930734141599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.558845726811988, 0.547722557505165, 1.581138830084189, 2.459674775249768, 0.000000000000000, 9.071147352221443, 1.851640199545105, 0.000000000000000, 5.345224838248499, -1.209486313629522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.272792206135797, -6.260990336999408, 0.000000000000000, 3.834057902536167, 0.000000000000000, 0.000000000000012, 10.583005244258372, 0.000000000000000, 0.000000000000000, 5.184592558726301, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011},
      {1.039230484541326, 0.000000000000000, 3.162277660168380, -0.447213595499958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371797, -0.534522483824851, 0.075592894601844, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.899999999999998, 0.000000000000000, 1.460593486680449, 1.420093893609383, 0.000000000000000, 0.000000000000011, 0.000000000000000, 9.071147352221454, 4.937707198786950, -0.698297248755173, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.734846922834953, 0.000000000000000, -6.260990336999408, 2.213594362117863, 0.000000000000000, 0.000000000000014, -0.000000000000016, 0.000000000000000, 10.583005244258382, 2.993325909419166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.715767664977308, 0.000000000000000, 0.000000000000000, -4.695742752749554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
      {2.569046515733015, 5.802884574739969, -2.010178182781467, -1.421410624438026, 8.142152225127145, -2.102294664680207, -1.716516405813993, 0.728256234341420, 0.594618725379071, 0.420458932936042, 9.810708435174291, -1.184508853698360, -1.025814758310364, 0.305838870920597, 0.264864231681990, 0.216260739578393, -0.105945692672794, -0.091751661276180, -0.074914917726440, -0.052972846336399, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.265686062395520, 3.070597894314956, 1.772810520855835, -1.253566341056019, 2.393567769390845, 6.303768714031312, -0.908295106229243, -2.783133725377444, -0.524404424085074, 0.370809924354780, 1.236033081182610, 9.401747557920134, -0.301561193523228, -2.427520781138059, -0.794200206656968, 0.114434427054267, 0.840917865872086, 0.350641890608830, 0.066068747264339, -0.046717659215117, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.026491220476083, 2.746426249302381, -0.792824967172091, 2.242447642325554, 2.140872096444190, -0.331662479035538, 6.499230723708781, 0.095742710775632, -1.876166303929363, -2.155806113731011, 11.055415967851332, 0.000000000000000, 9.440358593314686, 0.000000000000000, -1.462494064565356, -2.047065262876641, 0.000000000000000, 0.422185670932516, 0.590936840285277, 0.522319308773342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.914854215512674, 1.297564437470355, 3.745745886321972, -1.059456926727951, 0.404586796856338, 5.014265364224058, -0.383824736789359, 1.809367161139370, -1.108006575534898, 0.313391585264005, 0.000000000000000, 2.825218471274539, -0.050973145153432, 8.206518066482897, -0.631738055305789, 0.048357371456164, -2.842821248876057, -0.227958835180083, 0.139595707137604, -0.039483628456611, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.712697677155349, 1.160576914947998, 1.340118788520980, 1.895214165917371, 0.361873432227875, 1.962141687034864, 2.746426249302388, -0.566421515598880, 3.171299868688374, -1.821988709389514, 0.000000000000000, 11.055415967851328, 1.595711846260563, 0.000000000000000, 8.652231568278273, -0.865042958313569, 0.000000000000000, -2.497684112518217, -0.998865569685860, 0.441440386136646, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419142, 1.005089091390738, -0.193429485824662, 3.556157828809255, -8.461572802128115, 0.000000000000000, 4.459640440343024, 0.000000000000000, -0.858258202906988, 2.670272859251874, 0.000000000000000, 0.000000000000000, 12.437342963832752, 0.000000000000000, 0.000000000000000, 8.427928244224427, 0.000000000000000, 0.000000000000000, -1.621955546837942, -2.293791531904485, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.483239697419127, 0.335029697130247, 4.062019202317982, -0.820651806648292, 0.000000000000000, 1.699264546796649, -0.099103120896516, 5.886425061104582, -1.201561484069795, 0.242752078113805, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730439, -0.214087209644416, 0.012485819621074, 5.138093031466054, -0.741619848709571, 0.151382517704876, -0.030583887092059, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.326649916142157, 0.299659670905759, 2.076103099952574, 1.468026580418872, 0.000000000000000, 0.868496237346892, 0.709124208342343, 1.316244658108825, 4.912956630903930, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851330, 3.829708431025353, -0.223353131420165, 0.000000000000000, 5.804093383121946, -1.547435886597321, 0.341938252770120, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.148912529307614, 0.259512887494073, 0.749149177264397, 2.754588009492679, 0.000000000000000, -8.461572802128112, 1.151474210368101, 0.000000000000000, 3.324019726604706, 2.068384462742438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832752, 2.176081715527491, 0.000000000000000, 0.000000000000000, 6.281806821192093, -1.776763280547536, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.938083151964684, 7.628089872441255, 0.000000000000000, 3.114154649928846, 0.000000000000000, 0.000000000000000, -7.521398046336119, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380289, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739970, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.856348838577673, 0.000000000000000, 2.680237577041958, -0.473803541479346, 0.000000000000000, 0.000000000000015, 0.000000000000000, 5.097793640389933, -0.792824967172092, 0.140152977645346, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568710, -0.642261628933261, 0.099886556968584, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.765941686205059, 0.000000000000000, 1.498298354528793, 0.847565541382358, 0.000000000000000, 0.000000000000021, 0.000000000000000, 1.628430445025429, 3.545621041711666, -0.814818121686421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851339, 7.180703308172532, -1.116765657100815, 0.197418142283058, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.663324958071082, 0.000000000000000, 0.692034366650859, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128122, 3.070597894314962, 1.194182326351982, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832743, 5.802884574739972, -1.025814758310363, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.541602560309067, 0.000000000000000, 7.628089872441246, 1.797958025434548, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.521398046336106, 3.191058937540503, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380282, 3.350296971302450, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-5.361591803435499, 0.000000000000000, 0.000000000000000, 8.899438184514789, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, -5.264978632435287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.583123951776997, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.0000000000000