/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;

using Microsoft.Scripting;
using Microsoft.Scripting.Runtime;

using IronPython.Runtime.Operations;
using IronPython.Runtime.Types;

// This generated code is updated by the generate_exceptions.py script.
namespace IronPython.Runtime.Exceptions {
    public static partial class PythonExceptions {
        
        #region Generated Python New-Style Exceptions

        // *** BEGIN GENERATED CODE ***
        // generated by function: newstyle_gen from: generate_exceptions.py

        [MultiRuntimeAware]
        private static PythonType GeneratorExitStorage;
        public static PythonType GeneratorExit {
            get {
                if (GeneratorExitStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        GeneratorExitStorage = CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "GeneratorExit");
                    }
                }
                return GeneratorExitStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SystemExitStorage;
        public static PythonType SystemExit {
            get {
                if (SystemExitStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        SystemExitStorage = CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), typeof(_SystemExit));
                    }
                }
                return SystemExitStorage;
            }
        }

        [PythonType("SystemExit"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _SystemExit : BaseException {
            private object _code;

            public _SystemExit() : base(SystemExit) { }
            public _SystemExit(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object code {
                get { return _code; }
                set { _code = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType KeyboardInterruptStorage;
        public static PythonType KeyboardInterrupt {
            get {
                if (KeyboardInterruptStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        KeyboardInterruptStorage = CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "KeyboardInterrupt");
                    }
                }
                return KeyboardInterruptStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ExceptionStorage;
        public static PythonType Exception {
            get {
                if (ExceptionStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ExceptionStorage = CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "Exception");
                    }
                }
                return ExceptionStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType StopIterationStorage;
        public static PythonType StopIteration {
            get {
                if (StopIterationStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        StopIterationStorage = CreateSubType(Exception, "StopIteration");
                    }
                }
                return StopIterationStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType StandardErrorStorage;
        public static PythonType StandardError {
            get {
                if (StandardErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        StandardErrorStorage = CreateSubType(Exception, "StandardError");
                    }
                }
                return StandardErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BufferErrorStorage;
        public static PythonType BufferError {
            get {
                if (BufferErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        BufferErrorStorage = CreateSubType(StandardError, "BufferError");
                    }
                }
                return BufferErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ArithmeticErrorStorage;
        public static PythonType ArithmeticError {
            get {
                if (ArithmeticErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ArithmeticErrorStorage = CreateSubType(StandardError, "ArithmeticError");
                    }
                }
                return ArithmeticErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FloatingPointErrorStorage;
        public static PythonType FloatingPointError {
            get {
                if (FloatingPointErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        FloatingPointErrorStorage = CreateSubType(ArithmeticError, "FloatingPointError");
                    }
                }
                return FloatingPointErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType OverflowErrorStorage;
        public static PythonType OverflowError {
            get {
                if (OverflowErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        OverflowErrorStorage = CreateSubType(ArithmeticError, "OverflowError");
                    }
                }
                return OverflowErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ZeroDivisionErrorStorage;
        public static PythonType ZeroDivisionError {
            get {
                if (ZeroDivisionErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ZeroDivisionErrorStorage = CreateSubType(ArithmeticError, "ZeroDivisionError");
                    }
                }
                return ZeroDivisionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType AssertionErrorStorage;
        public static PythonType AssertionError {
            get {
                if (AssertionErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        AssertionErrorStorage = CreateSubType(StandardError, "AssertionError");
                    }
                }
                return AssertionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType AttributeErrorStorage;
        public static PythonType AttributeError {
            get {
                if (AttributeErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        AttributeErrorStorage = CreateSubType(StandardError, "AttributeError");
                    }
                }
                return AttributeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType EnvironmentErrorStorage;
        public static PythonType EnvironmentError {
            get {
                if (EnvironmentErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        EnvironmentErrorStorage = CreateSubType(StandardError, typeof(_EnvironmentError));
                    }
                }
                return EnvironmentErrorStorage;
            }
        }

        [PythonType("EnvironmentError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _EnvironmentError : BaseException {
            private object _errno;
            private object _strerror;
            private object _filename;

            public _EnvironmentError() : base(EnvironmentError) { }
            public _EnvironmentError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object errno {
                get { return _errno; }
                set { _errno = value; }
            }

            public object strerror {
                get { return _strerror; }
                set { _strerror = value; }
            }

            public object filename {
                get { return _filename; }
                set { _filename = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType IOErrorStorage;
        public static PythonType IOError {
            get {
                if (IOErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        IOErrorStorage = CreateSubType(EnvironmentError, "IOError");
                    }
                }
                return IOErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType OSErrorStorage;
        public static PythonType OSError {
            get {
                if (OSErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        OSErrorStorage = CreateSubType(EnvironmentError, "OSError");
                    }
                }
                return OSErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType WindowsErrorStorage;
        public static PythonType WindowsError {
            get {
                if (WindowsErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        WindowsErrorStorage = CreateSubType(OSError, typeof(_WindowsError));
                    }
                }
                return WindowsErrorStorage;
            }
        }

        [PythonType("WindowsError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _WindowsError : _EnvironmentError {
            private object _winerror;

            public _WindowsError() : base(WindowsError) { }
            public _WindowsError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object winerror {
                get { return _winerror; }
                set { _winerror = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType EOFErrorStorage;
        public static PythonType EOFError {
            get {
                if (EOFErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        EOFErrorStorage = CreateSubType(StandardError, "EOFError");
                    }
                }
                return EOFErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ImportErrorStorage;
        public static PythonType ImportError {
            get {
                if (ImportErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ImportErrorStorage = CreateSubType(StandardError, "ImportError");
                    }
                }
                return ImportErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType LookupErrorStorage;
        public static PythonType LookupError {
            get {
                if (LookupErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        LookupErrorStorage = CreateSubType(StandardError, "LookupError");
                    }
                }
                return LookupErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType IndexErrorStorage;
        public static PythonType IndexError {
            get {
                if (IndexErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        IndexErrorStorage = CreateSubType(LookupError, "IndexError");
                    }
                }
                return IndexErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType KeyErrorStorage;
        public static PythonType KeyError {
            get {
                if (KeyErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        KeyErrorStorage = CreateSubType(LookupError, "KeyError");
                    }
                }
                return KeyErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType MemoryErrorStorage;
        public static PythonType MemoryError {
            get {
                if (MemoryErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        MemoryErrorStorage = CreateSubType(StandardError, "MemoryError");
                    }
                }
                return MemoryErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NameErrorStorage;
        public static PythonType NameError {
            get {
                if (NameErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        NameErrorStorage = CreateSubType(StandardError, "NameError");
                    }
                }
                return NameErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnboundLocalErrorStorage;
        public static PythonType UnboundLocalError {
            get {
                if (UnboundLocalErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UnboundLocalErrorStorage = CreateSubType(NameError, "UnboundLocalError");
                    }
                }
                return UnboundLocalErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ReferenceErrorStorage;
        public static PythonType ReferenceError {
            get {
                if (ReferenceErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ReferenceErrorStorage = CreateSubType(StandardError, "ReferenceError");
                    }
                }
                return ReferenceErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RuntimeErrorStorage;
        public static PythonType RuntimeError {
            get {
                if (RuntimeErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        RuntimeErrorStorage = CreateSubType(StandardError, "RuntimeError");
                    }
                }
                return RuntimeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NotImplementedErrorStorage;
        public static PythonType NotImplementedError {
            get {
                if (NotImplementedErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        NotImplementedErrorStorage = CreateSubType(RuntimeError, "NotImplementedError");
                    }
                }
                return NotImplementedErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SyntaxErrorStorage;
        public static PythonType SyntaxError {
            get {
                if (SyntaxErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        SyntaxErrorStorage = CreateSubType(StandardError, typeof(_SyntaxError));
                    }
                }
                return SyntaxErrorStorage;
            }
        }

        [PythonType("SyntaxError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _SyntaxError : BaseException {
            private object _text;
            private object _print_file_and_line;
            private object _filename;
            private object _lineno;
            private object _offset;
            private object _msg;

            public _SyntaxError() : base(SyntaxError) { }
            public _SyntaxError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object text {
                get { return _text; }
                set { _text = value; }
            }

            public object print_file_and_line {
                get { return _print_file_and_line; }
                set { _print_file_and_line = value; }
            }

            public object filename {
                get { return _filename; }
                set { _filename = value; }
            }

            public object lineno {
                get { return _lineno; }
                set { _lineno = value; }
            }

            public object offset {
                get { return _offset; }
                set { _offset = value; }
            }

            public object msg {
                get { return _msg; }
                set { _msg = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType IndentationErrorStorage;
        public static PythonType IndentationError {
            get {
                if (IndentationErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        IndentationErrorStorage = CreateSubType(SyntaxError, "IndentationError");
                    }
                }
                return IndentationErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TabErrorStorage;
        public static PythonType TabError {
            get {
                if (TabErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        TabErrorStorage = CreateSubType(IndentationError, "TabError");
                    }
                }
                return TabErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SystemErrorStorage;
        public static PythonType SystemError {
            get {
                if (SystemErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        SystemErrorStorage = CreateSubType(StandardError, "SystemError");
                    }
                }
                return SystemErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TypeErrorStorage;
        public static PythonType TypeError {
            get {
                if (TypeErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        TypeErrorStorage = CreateSubType(StandardError, "TypeError");
                    }
                }
                return TypeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ValueErrorStorage;
        public static PythonType ValueError {
            get {
                if (ValueErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ValueErrorStorage = CreateSubType(StandardError, "ValueError");
                    }
                }
                return ValueErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeErrorStorage;
        public static PythonType UnicodeError {
            get {
                if (UnicodeErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UnicodeErrorStorage = CreateSubType(ValueError, "UnicodeError");
                    }
                }
                return UnicodeErrorStorage;
            }
        }


#if !SILVERLIGHT
        [MultiRuntimeAware]
        private static PythonType UnicodeDecodeErrorStorage;
        public static PythonType UnicodeDecodeError {
            get {
                if (UnicodeDecodeErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UnicodeDecodeErrorStorage = CreateSubType(UnicodeError, typeof(_UnicodeDecodeError));
                    }
                }
                return UnicodeDecodeErrorStorage;
            }
        }

        [PythonType("UnicodeDecodeError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _UnicodeDecodeError : BaseException {
            private object _start;
            private object _reason;
            private object _object;
            private object _end;
            private object _encoding;

            public _UnicodeDecodeError() : base(UnicodeDecodeError) { }
            public _UnicodeDecodeError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public void __init__(object encoding, object @object, object start, object end, object reason) {
                _encoding = encoding;
                _object = @object;
                _start = start;
                _end = end;
                _reason = reason;
                args = PythonTuple.MakeTuple(encoding, @object, start, end, reason);
            }

            public override void __init__(params object[] args) {
                if (args == null || args.Length != 5) {
                    throw PythonOps.TypeError("__init__ takes exactly 5 arguments ({0} given)", args.Length);
                }
                __init__(encoding, @object, start, end, reason);
            }

            public object start {
                get { return _start; }
                set { _start = value; }
            }

            public object reason {
                get { return _reason; }
                set { _reason = value; }
            }

            public object @object {
                get { return _object; }
                set { _object = value; }
            }

            public object end {
                get { return _end; }
                set { _end = value; }
            }

            public object encoding {
                get { return _encoding; }
                set { _encoding = value; }
            }

        }

#endif // !SILVERLIGHT


#if !SILVERLIGHT
        [MultiRuntimeAware]
        private static PythonType UnicodeEncodeErrorStorage;
        public static PythonType UnicodeEncodeError {
            get {
                if (UnicodeEncodeErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UnicodeEncodeErrorStorage = CreateSubType(UnicodeError, typeof(_UnicodeEncodeError));
                    }
                }
                return UnicodeEncodeErrorStorage;
            }
        }

        [PythonType("UnicodeEncodeError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _UnicodeEncodeError : BaseException {
            private object _start;
            private object _reason;
            private object _object;
            private object _end;
            private object _encoding;

            public _UnicodeEncodeError() : base(UnicodeEncodeError) { }
            public _UnicodeEncodeError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public void __init__(object encoding, object @object, object start, object end, object reason) {
                _encoding = encoding;
                _object = @object;
                _start = start;
                _end = end;
                _reason = reason;
                args = PythonTuple.MakeTuple(encoding, @object, start, end, reason);
            }

            public override void __init__(params object[] args) {
                if (args == null || args.Length != 5) {
                    throw PythonOps.TypeError("__init__ takes exactly 5 arguments ({0} given)", args.Length);
                }
                __init__(encoding, @object, start, end, reason);
            }

            public object start {
                get { return _start; }
                set { _start = value; }
            }

            public object reason {
                get { return _reason; }
                set { _reason = value; }
            }

            public object @object {
                get { return _object; }
                set { _object = value; }
            }

            public object end {
                get { return _end; }
                set { _end = value; }
            }

            public object encoding {
                get { return _encoding; }
                set { _encoding = value; }
            }

        }

#endif // !SILVERLIGHT

        [MultiRuntimeAware]
        private static PythonType UnicodeTranslateErrorStorage;
        public static PythonType UnicodeTranslateError {
            get {
                if (UnicodeTranslateErrorStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UnicodeTranslateErrorStorage = CreateSubType(UnicodeError, typeof(_UnicodeTranslateError));
                    }
                }
                return UnicodeTranslateErrorStorage;
            }
        }

        [PythonType("UnicodeTranslateError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _UnicodeTranslateError : BaseException {
            private object _start;
            private object _reason;
            private object _object;
            private object _end;
            private object _encoding;

            public _UnicodeTranslateError() : base(UnicodeTranslateError) { }
            public _UnicodeTranslateError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object start {
                get { return _start; }
                set { _start = value; }
            }

            public object reason {
                get { return _reason; }
                set { _reason = value; }
            }

            public object @object {
                get { return _object; }
                set { _object = value; }
            }

            public object end {
                get { return _end; }
                set { _end = value; }
            }

            public object encoding {
                get { return _encoding; }
                set { _encoding = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType WarningStorage;
        public static PythonType Warning {
            get {
                if (WarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        WarningStorage = CreateSubType(Exception, "Warning");
                    }
                }
                return WarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType DeprecationWarningStorage;
        public static PythonType DeprecationWarning {
            get {
                if (DeprecationWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        DeprecationWarningStorage = CreateSubType(Warning, "DeprecationWarning");
                    }
                }
                return DeprecationWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType PendingDeprecationWarningStorage;
        public static PythonType PendingDeprecationWarning {
            get {
                if (PendingDeprecationWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        PendingDeprecationWarningStorage = CreateSubType(Warning, "PendingDeprecationWarning");
                    }
                }
                return PendingDeprecationWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RuntimeWarningStorage;
        public static PythonType RuntimeWarning {
            get {
                if (RuntimeWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        RuntimeWarningStorage = CreateSubType(Warning, "RuntimeWarning");
                    }
                }
                return RuntimeWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SyntaxWarningStorage;
        public static PythonType SyntaxWarning {
            get {
                if (SyntaxWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        SyntaxWarningStorage = CreateSubType(Warning, "SyntaxWarning");
                    }
                }
                return SyntaxWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UserWarningStorage;
        public static PythonType UserWarning {
            get {
                if (UserWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UserWarningStorage = CreateSubType(Warning, "UserWarning");
                    }
                }
                return UserWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FutureWarningStorage;
        public static PythonType FutureWarning {
            get {
                if (FutureWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        FutureWarningStorage = CreateSubType(Warning, "FutureWarning");
                    }
                }
                return FutureWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ImportWarningStorage;
        public static PythonType ImportWarning {
            get {
                if (ImportWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        ImportWarningStorage = CreateSubType(Warning, "ImportWarning");
                    }
                }
                return ImportWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeWarningStorage;
        public static PythonType UnicodeWarning {
            get {
                if (UnicodeWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        UnicodeWarningStorage = CreateSubType(Warning, "UnicodeWarning");
                    }
                }
                return UnicodeWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BytesWarningStorage;
        public static PythonType BytesWarning {
            get {
                if (BytesWarningStorage == null) {
                    lock (typeof(PythonExceptions)) {
                        BytesWarningStorage = CreateSubType(Warning, "BytesWarning");
                    }
                }
                return BytesWarningStorage;
            }
        }


        // *** END GENERATED CODE ***

        #endregion

        #region Generated ToPython Exception Helper

        // *** BEGIN GENERATED CODE ***
        // generated by function: gen_topython_helper from: generate_exceptions.py

        private static BaseException/*!*/ ToPythonHelper(System.Exception clrException) {
            if (clrException is BytesWarningException) return new BaseException(BytesWarning);
            #if !SILVERLIGHT
            if (clrException is DecoderFallbackException) return new _UnicodeDecodeError();
            #endif
            if (clrException is DeprecationWarningException) return new BaseException(DeprecationWarning);
            if (clrException is DivideByZeroException) return new BaseException(ZeroDivisionError);
            #if !SILVERLIGHT
            if (clrException is EncoderFallbackException) return new _UnicodeEncodeError();
            #endif
            if (clrException is EndOfStreamException) return new BaseException(EOFError);
            if (clrException is FutureWarningException) return new BaseException(FutureWarning);
            if (clrException is ImportWarningException) return new BaseException(ImportWarning);
            if (clrException is MissingMemberException) return new BaseException(AttributeError);
            if (clrException is OverflowException) return new BaseException(OverflowError);
            if (clrException is PendingDeprecationWarningException) return new BaseException(PendingDeprecationWarning);
            if (clrException is RuntimeWarningException) return new BaseException(RuntimeWarning);
            if (clrException is SyntaxWarningException) return new BaseException(SyntaxWarning);
            if (clrException is TabException) return new _SyntaxError(TabError);
            if (clrException is UnicodeWarningException) return new BaseException(UnicodeWarning);
            if (clrException is UserWarningException) return new BaseException(UserWarning);
            if (clrException is Win32Exception) return new _WindowsError();
            if (clrException is ArgumentException) return new BaseException(ValueError);
            if (clrException is ArithmeticException) return new BaseException(ArithmeticError);
            if (clrException is ExternalException) return new _EnvironmentError();
            if (clrException is IOException) return new _EnvironmentError(IOError);
            if (clrException is IndentationException) return new _SyntaxError(IndentationError);
            if (clrException is IndexOutOfRangeException) return new BaseException(IndexError);
            if (clrException is KeyNotFoundException) return new BaseException(KeyError);
            if (clrException is NotImplementedException) return new BaseException(NotImplementedError);
            if (clrException is OSException) return new _EnvironmentError(OSError);
            if (clrException is OutOfMemoryException) return new BaseException(MemoryError);
            if (clrException is UnboundLocalException) return new BaseException(UnboundLocalError);
            if (clrException is UnicodeTranslateException) return new _UnicodeTranslateError();
            if (clrException is WarningException) return new BaseException(Warning);
            if (clrException is ApplicationException) return new BaseException(StandardError);
            if (clrException is ArgumentTypeException) return new BaseException(TypeError);
            if (clrException is AssertionException) return new BaseException(AssertionError);
            if (clrException is BufferException) return new BaseException(BufferError);
            if (clrException is FloatingPointException) return new BaseException(FloatingPointError);
            if (clrException is GeneratorExitException) return new BaseException(GeneratorExit);
            if (clrException is ImportException) return new BaseException(ImportError);
            if (clrException is KeyboardInterruptException) return new BaseException(KeyboardInterrupt);
            if (clrException is LookupException) return new BaseException(LookupError);
            if (clrException is ReferenceException) return new BaseException(ReferenceError);
            if (clrException is RuntimeException) return new BaseException(RuntimeError);
            if (clrException is StopIterationException) return new BaseException(StopIteration);
            if (clrException is SyntaxErrorException) return new _SyntaxError();
            if (clrException is SystemException) return new BaseException(SystemError);
            if (clrException is SystemExitException) return new _SystemExit();
            if (clrException is UnboundNameException) return new BaseException(NameError);
            if (clrException is UnicodeException) return new BaseException(UnicodeError);
            return new BaseException(Exception);
        }
        private static System.Exception/*!*/ ToClrHelper(PythonType/*!*/ type, string message) {
            if (type == BytesWarning) return new BytesWarningException(message);
            #if !SILVERLIGHT
            if (type == UnicodeDecodeError) return new DecoderFallbackException(message);
            #endif
            if (type == DeprecationWarning) return new DeprecationWarningException(message);
            if (type == ZeroDivisionError) return new DivideByZeroException(message);
            #if !SILVERLIGHT
            if (type == UnicodeEncodeError) return new EncoderFallbackException(message);
            #endif
            if (type == EOFError) return new EndOfStreamException(message);
            if (type == FutureWarning) return new FutureWarningException(message);
            if (type == ImportWarning) return new ImportWarningException(message);
            if (type == AttributeError) return new MissingMemberException(message);
            if (type == OverflowError) return new OverflowException(message);
            if (type == PendingDeprecationWarning) return new PendingDeprecationWarningException(message);
            if (type == RuntimeWarning) return new RuntimeWarningException(message);
            if (type == SyntaxWarning) return new SyntaxWarningException(message);
            if (type == TabError) return new TabException(message);
            if (type == UnicodeWarning) return new UnicodeWarningException(message);
            if (type == UserWarning) return new UserWarningException(message);
            if (type == WindowsError) return new Win32Exception(message);
            if (type == ValueError) return new ArgumentException(message);
            if (type == ArithmeticError) return new ArithmeticException(message);
            if (type == EnvironmentError) return new ExternalException(message);
            if (type == IOError) return new IOException(message);
            if (type == IndentationError) return new IndentationException(message);
            if (type == IndexError) return new IndexOutOfRangeException(message);
            if (type == KeyError) return new KeyNotFoundException(message);
            if (type == NotImplementedError) return new NotImplementedException(message);
            if (type == OSError) return new OSException(message);
            if (type == MemoryError) return new OutOfMemoryException(message);
            if (type == UnboundLocalError) return new UnboundLocalException(message);
            if (type == UnicodeTranslateError) return new UnicodeTranslateException(message);
            if (type == Warning) return new WarningException(message);
            if (type == StandardError) return new ApplicationException(message);
            if (type == TypeError) return new ArgumentTypeException(message);
            if (type == AssertionError) return new AssertionException(message);
            if (type == BufferError) return new BufferException(message);
            if (type == FloatingPointError) return new FloatingPointException(message);
            if (type == GeneratorExit) return new GeneratorExitException(message);
            if (type == ImportError) return new ImportException(message);
            if (type == KeyboardInterrupt) return new KeyboardInterruptException(message);
            if (type == LookupError) return new LookupException(message);
            if (type == ReferenceError) return new ReferenceException(message);
            if (type == RuntimeError) return new RuntimeException(message);
            if (type == StopIteration) return new StopIterationException(message);
            if (type == SyntaxError) return new SyntaxErrorException(message);
            if (type == SystemError) return new SystemException(message);
            if (type == SystemExit) return new SystemExitException(message);
            if (type == NameError) return new UnboundNameException(message);
            if (type == UnicodeError) return new UnicodeException(message);
            if (type == Exception) return new Exception(message);
            return new Exception(message);
        }

        // *** END GENERATED CODE ***

        #endregion
    }
}
