#ifndef _VIRLIST_H_INCLUDED
#define _VIRLIST_H_INCLUDED

#include <qwidget.h>
#include "list.h"

class QListView;
class QListViewItem;
class QPixmap;
class Playlist;
class DragSortList;

class VirList : public List
{
Q_OBJECT
public:
	enum Type {PLL=0, M3U=1, PLS=2};
	VirList(QWidget *parent, Playlist *pl, const char *name = 0, WFlags f = 0);
	virtual ~VirList();
	virtual void setDir(QString i_dir);
	virtual void setFile(QString i_file);
	virtual QString getDir();
	virtual void addFile(QString file, bool save=true);
	virtual void addFile(QString file, QString runtime, bool save=true);
	virtual Type type();
	virtual void setType(Type t);
protected:
	Type s_type;
	QString file;
	virtual void load();
protected slots:
	virtual void resizeEvent(QResizeEvent *e);
	virtual void lv_doubleClicked(QListViewItem *it);
	virtual void lv_rightClicked(QListViewItem *it, const QPoint& pos, int col);
	virtual void removeItem();
	virtual void moveToList(int arg);
	virtual void setAutoList(int arg);
	virtual void save();
};

#endif
