/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component.dialogs;

import de.xeinfach.kafenio.component.dialogs.ImageDialog;
import de.xeinfach.kafenio.util.LeanLogger;
import de.xeinfach.kafenio.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class ImageDialogControls
extends JPanel
implements ActionListener,
KeyListener {
    private static LeanLogger log = new LeanLogger("ImageDialogControls.class");
    public static final int DEFAULT_SCALE = 8;
    public static final String SET_SCALE = "SET_SCALE";
    public static final String SET_ALIGN = "SET_ALIGN";
    public static final String SET_SIZE = "SET_SIZE";
    public static final String[] BORDER_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public static final String[] ALIGNMENTS = new String[]{"none", "left", "right", "top", "middle", "bottom"};
    public static final String[] SCALE = new String[]{"1000", "750", "500", "400", "300", "200", "175", "150", "100", "75", "50", "25", "10", "5"};
    private JComboBox borderSizeList;
    private JComboBox alignmentList;
    private JComboBox imageScale;
    private JLabel originalHeightLabel2;
    private JLabel originalWidthLabel2;
    private JTextField imageHeight;
    private JTextField imageWidth;
    private JCheckBox imageConstrainProps;
    private ImageDialog parent;

    public ImageDialogControls() {
    }

    public ImageDialogControls(ImageDialog imageDialog) {
        this.parent = imageDialog;
        this.initComponents();
    }

    private void initComponents() {
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.imageScale = new JComboBox<String>(SCALE);
        this.imageScale.addActionListener(this);
        this.imageScale.setActionCommand(SET_SCALE);
        this.imageScale.setSelectedIndex(8);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(this.parent.getString("InsertImageDialogScaleField"));
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(jLabel);
        jPanel.add(this.imageScale);
        this.imageConstrainProps = new JCheckBox(this.parent.getString("InsertImageDialogConstrainPropsField"));
        this.imageConstrainProps.setSelected(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jPanel);
        jPanel2.add(this.imageConstrainProps);
        this.imageWidth = new JTextField("");
        this.imageWidth.addKeyListener(this);
        this.imageHeight = new JTextField("");
        this.imageHeight.addKeyListener(this);
        JLabel jLabel2 = new JLabel(this.parent.getString("InsertImageDialogWidthField"));
        JLabel jLabel3 = new JLabel(this.parent.getString("InsertImageDialogHeightField"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(jLabel2);
        jPanel3.add(this.imageWidth);
        jPanel3.add(jLabel3);
        jPanel3.add(this.imageHeight);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 2));
        JLabel jLabel4 = new JLabel(this.parent.getString("InsertImageDialogOriginalWidthField"));
        JLabel jLabel5 = new JLabel(this.parent.getString("InsertImageDialogOriginalHeightField"));
        this.originalWidthLabel2 = new JLabel("");
        this.originalHeightLabel2 = new JLabel("");
        jPanel4.add(jLabel4);
        jPanel4.add(this.originalWidthLabel2);
        jPanel4.add(jLabel5);
        jPanel4.add(this.originalHeightLabel2);
        JLabel jLabel6 = new JLabel(this.parent.getString("InsertImageDialogAlignmentField"));
        this.alignmentList = new JComboBox<String>(ALIGNMENTS);
        this.alignmentList.addActionListener(this);
        this.alignmentList.setActionCommand(SET_ALIGN);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(jLabel6);
        jPanel5.add(this.alignmentList);
        JLabel jLabel7 = new JLabel(this.parent.getString("InsertImageDialogBorderWidthField"));
        this.borderSizeList = new JComboBox<String>(BORDER_SIZES);
        this.borderSizeList.addActionListener(this);
        this.borderSizeList.setActionCommand(SET_SIZE);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(jLabel7);
        jPanel6.add(this.borderSizeList);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(border);
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setBorder(border);
        jPanel7.add(jPanel2);
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel4);
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        this.setLayout(new BorderLayout());
        this.add((Component)new JPanel(), "Center");
        this.add((Component)jPanel7, "South");
    }

    public void setNewImage(int n, int n2) {
        try {
            this.originalHeightLabel2.setText("" + n2);
            this.originalWidthLabel2.setText("" + n);
            this.imageWidth.setText("" + n);
            this.imageHeight.setText("" + n2);
            this.imageScale.setSelectedIndex(8);
            this.performUpdatePreview();
        }
        catch (Exception exception) {
            log.error("an error ocurred while trying to set new image: " + exception.fillInStackTrace());
        }
    }

    public void performUpdatePreview() {
        this.parent.updatePreview();
    }

    private void updateScale() {
        try {
            BigDecimal bigDecimal = new BigDecimal("" + this.imageScale.getSelectedItem());
            if (this.imageConstrainProps.isSelected()) {
                this.imageWidth.setText("" + this.calcScaledLength(new BigDecimal(this.originalWidthLabel2.getText()), bigDecimal));
                this.imageHeight.setText("" + this.calcScaledLength(new BigDecimal(this.originalHeightLabel2.getText()), bigDecimal));
            } else {
                this.imageWidth.setText("" + this.calcScaledLength(new BigDecimal(this.imageWidth.getText()), bigDecimal));
                this.imageHeight.setText("" + this.calcScaledLength(new BigDecimal(this.imageHeight.getText()), bigDecimal));
            }
        }
        catch (Exception exception) {
            log.error("An error ocurred while trying to scale the preview image: " + exception.fillInStackTrace());
        }
    }

    private void updateWidth() {
        try {
            if (this.imageConstrainProps.isSelected()) {
                int n = this.calcAspectRatioLength(new BigDecimal(this.imageWidth.getText()), false);
                this.imageHeight.setText("" + n);
            }
        }
        catch (Exception exception) {
            log.error("error while trying to update the image width: " + exception.fillInStackTrace());
        }
    }

    private void updateHeight() {
        try {
            if (this.imageConstrainProps.isSelected()) {
                int n = this.calcAspectRatioLength(new BigDecimal(this.imageHeight.getText()), true);
                this.imageWidth.setText("" + n);
            }
        }
        catch (Exception exception) {
            log.error("error while trying to update the image height: " + exception.fillInStackTrace());
        }
    }

    private int calcScaledLength(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = bigDecimal2.divide(new BigDecimal("100"), 10, 4);
        return bigDecimal.multiply(bigDecimal3).intValue();
    }

    private int calcAspectRatioLength(BigDecimal bigDecimal, boolean bl) {
        BigDecimal bigDecimal2 = new BigDecimal(this.originalHeightLabel2.getText());
        BigDecimal bigDecimal3 = new BigDecimal(this.originalWidthLabel2.getText());
        BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, 10, 4);
        BigDecimal bigDecimal5 = bl ? bigDecimal.divide(bigDecimal4, 4) : bigDecimal.multiply(bigDecimal4);
        bigDecimal5.setScale(0, 4);
        return bigDecimal5.intValue();
    }

    public String getHtmlImgString(String string, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (Utils.checkNullOrEmpty(this.imageHeight.getText()) != null) {
            stringBuffer.append("HEIGHT=\"" + this.imageHeight.getText() + "\" ");
        }
        if (Utils.checkNullOrEmpty(this.imageWidth.getText()) != null) {
            stringBuffer.append("WIDTH=\"" + this.imageWidth.getText() + "\" ");
        }
        if (Utils.checkNullOrEmpty(string) != null) {
            stringBuffer.append("ALT=\"" + string + "\" ");
        }
        if (Utils.checkNullOrEmpty("" + this.alignmentList.getSelectedItem()) != null && !(string3 = ALIGNMENTS[this.alignmentList.getSelectedIndex()]).equals("none")) {
            stringBuffer.append("ALIGN=\"" + string3 + "\" ");
        }
        string3 = null;
        if (!this.borderSizeList.getSelectedItem().equals("0")) {
            string3 = this.borderSizeList.getSelectedItem().toString();
            stringBuffer.append("BORDER=\"" + string3 + "\" ");
        }
        if (string2 != null) {
            return "<IMG SRC=" + string2 + " " + stringBuffer.toString() + ">";
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SET_ALIGN) || string.equals(SET_SIZE)) {
            this.performUpdatePreview();
        }
        if (string.equals(SET_SCALE)) {
            this.updateScale();
            this.performUpdatePreview();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        this.validate();
        if (object.equals(this.imageHeight)) {
            this.updateHeight();
        } else if (object.equals(this.imageWidth)) {
            this.updateWidth();
        } else if (object.equals(this.imageScale)) {
            this.updateScale();
        }
        this.performUpdatePreview();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

