/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_test_suite_traversal.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta]
 */


#include <diagnostics/util/dummy_test_suite_traversal.ts.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

Dummy_Test_Suite_Traversal::Dummy_Test_Suite_Traversal(::std::ostream & stream) 
    : m_stream(stream)
{
}

void Dummy_Test_Suite_Traversal::traverse(Test_Suite const & test_suite,
					  ::std::string mask,
					  Level_t const level)
{
    m_indent=0;
    Super::traverse(test_suite,mask,level);
}
    

void Dummy_Test_Suite_Traversal::enter_hook(Test_Suite const & test_suite,
					    ::std::string const & mask,
					    Level_t const level)
{
    m_stream << "ENTER: " << mask << " " 
	     << level_to_string(level)
	     << ::std::endl;
}

void Dummy_Test_Suite_Traversal::exit_hook(Test_Suite const & test_suite,
					   ::std::string const & mask,
					   Level_t const level,
					   bool const exception_going_through)
{
    m_stream << "EXIT: " << mask << " " 
	     << level_to_string(level) 
	     << (exception_going_through ? " EXCEP" : " no EXCEP")
	     << ::std::endl;
}


void Dummy_Test_Suite_Traversal::visit_hook(Test_Suite const & test_suite,
					    Path_t const & path,
					    Level_t const level)
{
    m_stream << level_to_string(level) << ' ';
    for(int i=0;i<m_indent*2;++i) m_stream << ' ';
    m_stream << "VISIT_SUITE: /";
    Path_t::const_iterator cur(path.begin());
    Path_t::const_iterator const end(path.end());
    for(;cur!=end;++cur) m_stream << *cur << '/';
    m_stream << test_suite.name() << ::std::endl; 
    m_indent+=1;
}


void Dummy_Test_Suite_Traversal::leave_hook(Test_Suite const & test_suite,
					    Path_t const & path,
					    Level_t const level)
{
    m_indent-=1;
    m_stream << level_to_string(level) << ' ';
    for(int i=0;i<m_indent*2;++i) m_stream << ' ';
    m_stream << "LEAVE_SUITE: /";
    Path_t::const_iterator cur(path.begin());
    Path_t::const_iterator const end(path.end());
    for(;cur!=end;++cur) m_stream << *cur << '/';
    m_stream << test_suite.name() << ::std::endl;
}


void Dummy_Test_Suite_Traversal::visit_hook(Test_Case const & test_case,
					    Path_t const & path,
					    Level_t const level)
{
    m_stream << level_to_string(level) << ' ';
    for(int i=0;i<m_indent*2;++i) m_stream << ' ';
    m_stream << "VISIT_CASE: /";
    Path_t::const_iterator cur(path.begin());
    Path_t::const_iterator const end(path.end());
    for(;cur!=end;++cur) m_stream << *cur << '/';
    m_stream << test_case.name() << ::std::endl;
}

TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
