/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/diff_generator.hpp
 *
 * @brief [LEVEL: alpha] @ref diagnostics::internal::Diff_Generator
 * implements a diff algorithm.
 *
 * $Id: diff_generator.hpp 827 2007-12-16 17:54:51Z tautschn $
 * 
 * @author Piotr Esden-Tempski
 *
 * @test diagnostics/util/diff_generator.t.cpp
 */

#ifndef DIAGNOSTICS__UTIL__DIFF_GENERATOR_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DIFF_GENERATOR_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

// Needed for the interface
#include <vector>
#include <string>
#include <utility>

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

/**
 * @class Diff_Generator diagnostics/util/diff_generator.hpp
 *
 * @brief
 *
 * @nosubgrouping
 *
 * @todo document
 */
class Diff_Generator 
{
public:
    Diff_Generator();
    ~Diff_Generator();
    
    void texta(::std::string const & texta);
    void textb(::std::string const & textb);
    void diff_text(::std::string & diff_text, bool const use_color);
    
private:
    typedef ::std::vector< ::std::string> VText_t;
    typedef ::std::vector<unsigned long int> Hash_t;
    typedef ::std::pair<int, int> Match_t;
    typedef ::std::vector<Match_t> VMatch_t;
    
    VText_t m_vtexta;
    VText_t m_vtextb;
    Hash_t m_hasha;
    Hash_t m_hashb;
    
    bool m_diff_done;
    
    VMatch_t m_diff_tupel;

    /* the diff algorithm itself */
    void p_do_diff(); 
    
    /* helper functions */
    static void p_split_hash(VText_t & vtext, 
			     Hash_t & hashmap, 
			     ::std::string const & text);
    static void p_append_composed_line(::std::string & target, 
				       char prefix, 
				       ::std::string const & line, 
				       bool const use_color);
};

INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
	
#endif

// vim:ts=4:sw=4
