# Copyright 2009-2010 Canonical Ltd.
#
# This file is part of desktopcouch-contacts.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Nicola Larosa <nicola.larosa@canonical.com>
#          Vincenzo Di Somma <vincenzo.di.somma@canonical.com>

"""Tests for the ContactDocument class"""

from unittest import TestCase

from desktopcouch.recordtypes.contacts import Contact

SINGLE_FIELDS = frozenset((
    'first_name', 'middle_name', 'last_name', 'title', 'suffix', 'birth_date',
    'nick_name', 'spouse_name', 'wedding_date', 'company', 'department',
    'job_title', 'manager_name', 'assistant_name', 'office'))
LIST_FIELDS = frozenset((
    'addresses', 'phone_numbers', 'email_addresses', 'urls', 'im_addresses'))
ALL_FIELDS = SINGLE_FIELDS | LIST_FIELDS


class TestContactRecord(TestCase):
    """Test the Contact Record object."""

    def test_contact_record(self):
        """Test that we get the correct record type."""
        contact = Contact()
        for field_name in SINGLE_FIELDS:
            self.assert_(hasattr(contact, field_name))
            # direct access to internal representation
        for field_name in LIST_FIELDS:
            self.assert_(hasattr(contact, field_name))
            # direct access to internal representation
        first_name = 'manuel'
        contact.first_name = first_name
        self.assertEqual(first_name, contact.first_name)
        self.assertEqual(set(['first_name']), set(contact.keys()))
