/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 *
 *  Copyright (C) 2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */

#include <regdef.h>

#include "dec_prom.h"

/*
 * This is the bootloader's execution entry.
 */
	.text
	.globl	__start
	.ent	__start
__start:
	# Set up gp, sp (for PIC code)
	.frame	fp, 32, ra
	.set noreorder
	bltzal	zero, 1f
	 nop
1:
	.cpload ra
	.set reorder
	la	sp, _stack_start - 32
	sw	ra, 20(sp)
	.cprestore 16
	move	fp, sp

	la	t9, t_rex_main
	jalr	t9

	# If we ever return, jump to the reset vector.
	lw	t9, 0xbfc00000
	jalr	t9
	.end	__start
