/* ConfigList.c generated by valac 0.12.0, the Vala compiler
 * generated from ConfigList.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009,2010,2011 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;

#define DEJA_DUP_TYPE_CONFIG_LIST (deja_dup_config_list_get_type ())
#define DEJA_DUP_CONFIG_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigList))
#define DEJA_DUP_CONFIG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListClass))
#define DEJA_DUP_IS_CONFIG_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LIST))
#define DEJA_DUP_IS_CONFIG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LIST))
#define DEJA_DUP_CONFIG_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListClass))

typedef struct _DejaDupConfigList DejaDupConfigList;
typedef struct _DejaDupConfigListClass DejaDupConfigListClass;
typedef struct _DejaDupConfigListPrivate DejaDupConfigListPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _DejaDupConfigListSetFromConfigData DejaDupConfigListSetFromConfigData;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	DejaDupSimpleSettings* settings;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigList {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigListPrivate * priv;
};

struct _DejaDupConfigListClass {
	DejaDupConfigWidgetClass parent_class;
};

struct _DejaDupConfigListPrivate {
	GtkSizeGroup* _size_group;
	GtkTreeView* tree;
	GtkButton* add_button;
	GtkButton* remove_button;
};

struct _DejaDupConfigListSetFromConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigList* self;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* slist_val;
	size_t _tmp2_;
	const gchar** _tmp3_;
	const gchar** slist;
	gint slist_length1;
	gint _slist_size_;
	gint _tmp4_;
	GFile** _tmp5_;
	GFile** list;
	gint list_length1;
	gint _list_size_;
	GtkListStore* model;
	gint i;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* home;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* trash;
	GFile** f_collection;
	int f_collection_length1;
	int f_it;
	GFile* _tmp12_;
	GFile* f;
	gchar* s;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkTreeIter iter;
	gint _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkTreeIter _tmp25_;
	GIcon* icon;
	gboolean _tmp26_;
	GThemedIcon* _tmp27_;
	GFileInfo* _tmp28_;
	GFileInfo* info;
	GIcon* _tmp29_;
	GIcon* _tmp30_;
	GError * err;
	GError * _inner_error_;
};


static gpointer deja_dup_config_list_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_list_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListPrivate))
enum  {
	DEJA_DUP_CONFIG_LIST_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_LIST_SIZE_GROUP
};
DejaDupConfigList* deja_dup_config_list_new (const gchar* key, GtkSizeGroup* sg, const gchar* ns);
DejaDupConfigList* deja_dup_config_list_construct (GType object_type, const gchar* key, GtkSizeGroup* sg, const gchar* ns);
static gboolean deja_dup_config_list_on_key_press_event (DejaDupConfigList* self, GtkWidget* w, GdkEventKey* e);
static void deja_dup_config_list_handle_remove (DejaDupConfigList* self);
static void deja_dup_config_list_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_list_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_config_list_real_set_from_config_co (DejaDupConfigListSetFromConfigData* data);
const gchar* deja_dup_config_widget_get_key (DejaDupConfigWidget* self);
static void deja_dup_config_list_handle_selection_change (DejaDupConfigList* self, GtkTreeSelection* sel);
static void deja_dup_config_list_handle_add (DejaDupConfigList* self);
static void _vala_array_add1 (const gchar*** array, int* length, int* size, const gchar* value);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
GtkSizeGroup* deja_dup_config_list_get_size_group (DejaDupConfigList* self);
static void deja_dup_config_list_set_size_group (DejaDupConfigList* self, GtkSizeGroup* value);
static GObject * deja_dup_config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void deja_dup_config_widget_set_mnemonic_widget (DejaDupConfigWidget* self, GtkWidget* value);
static void _deja_dup_config_list_handle_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _deja_dup_config_list_handle_remove_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _deja_dup_config_list_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_);
static void _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void deja_dup_config_list_finalize (GObject* obj);
static void _vala_deja_dup_config_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_config_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


DejaDupConfigList* deja_dup_config_list_construct (GType object_type, const gchar* key, GtkSizeGroup* sg, const gchar* ns) {
	DejaDupConfigList * self = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	self = (DejaDupConfigList*) g_object_new (object_type, "size-group", sg, "key", key, "ns", ns, NULL);
	return self;
}


DejaDupConfigList* deja_dup_config_list_new (const gchar* key, GtkSizeGroup* sg, const gchar* ns) {
	return deja_dup_config_list_construct (DEJA_DUP_TYPE_CONFIG_LIST, key, sg, ns);
}


static gboolean deja_dup_config_list_on_key_press_event (DejaDupConfigList* self, GtkWidget* w, GdkEventKey* e) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint modifiers;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	_tmp0_ = gtk_accelerator_get_default_mod_mask ();
	modifiers = _tmp0_;
	if ((*e).keyval == 0xffff) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = (*e).keyval == 0xff9f;
	}
	if (_tmp2_) {
		_tmp1_ = modifiers == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		deja_dup_config_list_handle_remove (self);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void deja_dup_config_list_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigListSetFromConfigData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupConfigListSetFromConfigData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_config_list_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigList * self;
	DejaDupConfigListSetFromConfigData* _data_;
	self = (DejaDupConfigList*) base;
	_data_ = g_slice_new0 (DejaDupConfigListSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_list_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_list_real_set_from_config_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_config_list_real_set_from_config_co (_data_);
}


static void deja_dup_config_list_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigListSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_config_list_real_set_from_config_co (DejaDupConfigListSetFromConfigData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) data->self);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_settings_get_value ((GSettings*) ((DejaDupConfigWidget*) data->self)->settings, data->_tmp0_);
	data->slist_val = data->_tmp1_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_variant_get_strv (data->slist_val, &data->_tmp2_);
	data->slist = data->_tmp3_;
	data->slist_length1 = data->_tmp2_;
	data->_slist_size_ = data->_tmp2_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = deja_dup_parse_dir_list (data->slist, data->slist_length1, &data->_tmp4_);
	data->list = data->_tmp5_;
	data->list_length1 = data->_tmp4_;
	data->_list_size_ = data->_tmp4_;
	g_object_get ((GObject*) data->self->priv->tree, "model", &data->model, NULL);
	gtk_list_store_clear (data->model);
	data->i = 0;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_get_home_dir ();
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_file_new_for_path (data->_tmp6_);
	data->home = data->_tmp7_;
	data->_tmp8_ = NULL;
	data->_tmp8_ = deja_dup_get_trash_path ();
	data->_tmp9_ = data->_tmp8_;
	data->_tmp10_ = NULL;
	data->_tmp10_ = g_file_new_for_path (data->_tmp9_);
	data->_tmp11_ = data->_tmp10_;
	_g_free0 (data->_tmp9_);
	data->trash = data->_tmp11_;
	{
		data->f_collection = data->list;
		data->f_collection_length1 = data->list_length1;
		for (data->f_it = 0; data->f_it < data->list_length1; data->f_it = data->f_it + 1) {
			data->_tmp12_ = _g_object_ref0 (data->f_collection[data->f_it]);
			data->f = data->_tmp12_;
			{
				data->_tmp13_ = g_file_equal (data->f, data->home);
				if (data->_tmp13_) {
					data->_tmp14_ = NULL;
					data->_tmp14_ = _ ("Home Folder");
					data->_tmp15_ = g_strdup (data->_tmp14_);
					_g_free0 (data->s);
					data->s = data->_tmp15_;
				} else {
					data->_tmp16_ = g_file_equal (data->f, data->trash);
					if (data->_tmp16_) {
						data->_tmp17_ = NULL;
						data->_tmp17_ = _ ("Trash");
						data->_tmp18_ = g_strdup (data->_tmp17_);
						_g_free0 (data->s);
						data->s = data->_tmp18_;
					} else {
						data->_tmp19_ = g_file_has_prefix (data->f, data->home);
						if (data->_tmp19_) {
							data->_tmp20_ = NULL;
							data->_tmp20_ = g_file_get_relative_path (data->home, data->f);
							_g_free0 (data->s);
							data->s = data->_tmp20_;
						} else {
							data->_tmp21_ = NULL;
							data->_tmp21_ = g_file_get_path (data->f);
							_g_free0 (data->s);
							data->s = data->_tmp21_;
						}
					}
				}
				data->_tmp22_ = data->i;
				data->i = data->_tmp22_ + 1;
				data->_tmp23_ = NULL;
				data->_tmp23_ = g_file_get_path (data->f);
				data->_tmp24_ = data->_tmp23_;
				memset (&data->_tmp25_, 0, sizeof (GtkTreeIter));
				gtk_list_store_insert_with_values (data->model, &data->_tmp25_, data->_tmp22_, 0, data->_tmp24_, 1, data->s, -1);
				data->iter = data->_tmp25_;
				_g_free0 (data->_tmp24_);
				data->icon = NULL;
				data->_tmp26_ = g_file_equal (data->f, data->trash);
				if (data->_tmp26_) {
					data->_tmp27_ = NULL;
					data->_tmp27_ = (GThemedIcon*) g_themed_icon_new ("user-trash");
					_g_object_unref0 (data->icon);
					data->icon = (GIcon*) data->_tmp27_;
					g_themed_icon_append_name (G_THEMED_ICON (data->icon), "folder");
				} else {
					data->_tmp28_ = NULL;
					data->_tmp28_ = g_file_query_info (data->f, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &data->_inner_error_);
					data->info = data->_tmp28_;
					if (data->_inner_error_ != NULL) {
						goto __catch2_g_error;
					}
					data->_tmp29_ = NULL;
					data->_tmp29_ = g_file_info_get_icon (data->info);
					data->_tmp30_ = _g_object_ref0 (data->_tmp29_);
					_g_object_unref0 (data->icon);
					data->icon = data->_tmp30_;
					_g_object_unref0 (data->info);
					goto __finally2;
					__catch2_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						g_warning ("ConfigList.vala:139: %s\n", data->err->message);
						_g_error_free0 (data->err);
					}
					__finally2:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->icon);
						_g_free0 (data->s);
						_g_object_unref0 (data->f);
						_g_object_unref0 (data->trash);
						_g_object_unref0 (data->home);
						_g_object_unref0 (data->model);
						data->list = (_vala_array_free (data->list, data->list_length1, (GDestroyNotify) g_object_unref), NULL);
						data->slist = (g_free (data->slist), NULL);
						_g_variant_unref0 (data->slist_val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				}
				if (data->icon != NULL) {
					gtk_list_store_set (data->model, &data->iter, 2, data->icon, -1);
				}
				_g_object_unref0 (data->icon);
				_g_free0 (data->s);
				_g_object_unref0 (data->f);
			}
		}
	}
	_g_object_unref0 (data->trash);
	_g_object_unref0 (data->home);
	_g_object_unref0 (data->model);
	data->list = (_vala_array_free (data->list, data->list_length1, (GDestroyNotify) g_object_unref), NULL);
	data->slist = (g_free (data->slist), NULL);
	_g_variant_unref0 (data->slist_val);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_config_list_handle_selection_change (DejaDupConfigList* self, GtkTreeSelection* sel) {
	gint _tmp0_;
	gboolean empty;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sel != NULL);
	_tmp0_ = gtk_tree_selection_count_selected_rows (sel);
	empty = _tmp0_ == 0;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->remove_button, !empty);
}


static void _vala_array_add1 (const gchar*** array, int* length, int* size, const gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (const gchar*, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static void deja_dup_config_list_handle_add (DejaDupConfigList* self) {
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileChooserDialog* dlg;
	gint _tmp4_;
	GSList* _tmp5_ = NULL;
	GSList* files;
	const gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* slist_val;
	size_t _tmp8_;
	const gchar** _tmp9_ = NULL;
	const gchar** slist;
	gint slist_length1;
	gint _slist_size_;
	const gchar* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Choose folders");
	_tmp1_ = gtk_widget_get_ancestor ((GtkWidget*) self, GTK_TYPE_WINDOW);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, GTK_IS_WINDOW (_tmp2_) ? ((GtkWindow*) _tmp2_) : NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	dlg = g_object_ref_sink (_tmp3_);
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) dlg, TRUE);
	_tmp4_ = gtk_dialog_run ((GtkDialog*) dlg);
	if (_tmp4_ != GTK_RESPONSE_ACCEPT) {
		hacks_widget_destroy ((GtkWidget*) dlg);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp5_ = gtk_file_chooser_get_filenames ((GtkFileChooser*) dlg);
	files = _tmp5_;
	hacks_widget_destroy ((GtkWidget*) dlg);
	_tmp6_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp7_ = g_settings_get_value ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp6_);
	slist_val = _tmp7_;
	_tmp9_ = g_variant_get_strv (slist_val, &_tmp8_);
	slist = _tmp9_;
	slist_length1 = _tmp8_;
	_slist_size_ = _tmp8_;
	{
		GSList* file_collection;
		GSList* file_it;
		file_collection = files;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			gchar* _tmp10_;
			gchar* file;
			_tmp10_ = g_strdup ((const gchar*) file_it->data);
			file = _tmp10_;
			{
				GFile* _tmp11_ = NULL;
				GFile* folder;
				gboolean found;
				_tmp11_ = g_file_new_for_path (file);
				folder = _tmp11_;
				found = FALSE;
				{
					const gchar** s_collection;
					int s_collection_length1;
					int s_it;
					s_collection = slist;
					s_collection_length1 = slist_length1;
					for (s_it = 0; s_it < slist_length1; s_it = s_it + 1) {
						gchar* _tmp12_;
						gchar* s;
						_tmp12_ = g_strdup ((gchar*) s_collection[s_it]);
						s = _tmp12_;
						{
							GFile* _tmp13_ = NULL;
							GFile* sfile;
							gboolean _tmp14_ = FALSE;
							_tmp13_ = deja_dup_parse_dir (s);
							sfile = _tmp13_;
							if (sfile != NULL) {
								gboolean _tmp15_;
								_tmp15_ = g_file_equal (sfile, folder);
								_tmp14_ = _tmp15_;
							} else {
								_tmp14_ = FALSE;
							}
							if (_tmp14_) {
								found = TRUE;
								_g_object_unref0 (sfile);
								_g_free0 (s);
								break;
							}
							_g_object_unref0 (sfile);
							_g_free0 (s);
						}
					}
				}
				if (!found) {
					gchar* _tmp16_ = NULL;
					_tmp16_ = g_file_get_parse_name (folder);
					_vala_array_add1 (&slist, &slist_length1, &_slist_size_, _tmp16_);
				}
				_g_object_unref0 (folder);
				_g_free0 (file);
			}
		}
	}
	_tmp17_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp18_ = g_variant_new_strv (slist, slist_length1);
	_tmp19_ = g_variant_ref_sink (_tmp18_);
	g_settings_set_value ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp17_, _tmp19_);
	_g_variant_unref0 (_tmp19_);
	slist = (g_free (slist), NULL);
	_g_variant_unref0 (slist_val);
	__g_slist_free__g_free0_0 (files);
	_g_object_unref0 (dlg);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void deja_dup_config_list_handle_remove (DejaDupConfigList* self) {
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* sel;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* paths;
	const gchar* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* slist_val;
	size_t _tmp6_;
	const gchar** _tmp7_ = NULL;
	const gchar** before;
	gint before_length1;
	gint _before_size_;
	gchar** _tmp8_ = NULL;
	gchar** after;
	gint after_length1;
	gint _after_size_;
	const gchar* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->tree);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sel = _tmp1_;
	_tmp3_ = gtk_tree_selection_get_selected_rows (sel, &_tmp2_);
	model = _tmp2_;
	paths = _tmp3_;
	if (paths == NULL) {
		__g_list_free__gtk_tree_path_free0_0 (paths);
		_g_object_unref0 (sel);
		return;
	}
	_tmp4_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp5_ = g_settings_get_value ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp4_);
	slist_val = _tmp5_;
	_tmp7_ = g_variant_get_strv (slist_val, &_tmp6_);
	before = _tmp7_;
	before_length1 = _tmp6_;
	_before_size_ = _tmp6_;
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	after = _tmp8_;
	after_length1 = 0;
	_after_size_ = 0;
	{
		const gchar** file_collection;
		int file_collection_length1;
		int file_it;
		file_collection = before;
		file_collection_length1 = before_length1;
		for (file_it = 0; file_it < before_length1; file_it = file_it + 1) {
			gchar* _tmp9_;
			gchar* file;
			_tmp9_ = g_strdup ((gchar*) file_collection[file_it]);
			file = _tmp9_;
			{
				GFile* _tmp10_ = NULL;
				GFile* sfile;
				gboolean to_remove;
				_tmp10_ = deja_dup_parse_dir (file);
				sfile = _tmp10_;
				if (sfile == NULL) {
					_g_object_unref0 (sfile);
					_g_free0 (file);
					continue;
				}
				to_remove = FALSE;
				{
					GList* path_collection;
					GList* path_it;
					path_collection = paths;
					for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
						GtkTreePath* _tmp11_;
						GtkTreePath* path;
						_tmp11_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
						path = _tmp11_;
						{
							GtkTreeIter iter = {0};
							GtkTreeIter _tmp12_ = {0};
							gboolean _tmp13_;
							gchar* current = NULL;
							GFile* _tmp14_ = NULL;
							GFile* current_file;
							gboolean _tmp15_;
							_tmp13_ = gtk_tree_model_get_iter (model, &_tmp12_, path);
							iter = _tmp12_;
							if (!_tmp13_) {
								_gtk_tree_path_free0 (path);
								continue;
							}
							gtk_tree_model_get (model, &iter, 0, &current, -1);
							_tmp14_ = g_file_new_for_path (current);
							current_file = _tmp14_;
							_tmp15_ = g_file_equal (sfile, current_file);
							if (_tmp15_) {
								to_remove = TRUE;
							}
							_g_object_unref0 (current_file);
							_g_free0 (current);
							_gtk_tree_path_free0 (path);
						}
					}
				}
				if (!to_remove) {
					gchar* _tmp16_;
					_tmp16_ = g_strdup (file);
					_vala_array_add2 (&after, &after_length1, &_after_size_, _tmp16_);
				}
				_g_object_unref0 (sfile);
				_g_free0 (file);
			}
		}
	}
	_tmp17_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp18_ = g_variant_new_strv ((const gchar**) after, after_length1);
	_tmp19_ = g_variant_ref_sink (_tmp18_);
	g_settings_set_value ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp17_, _tmp19_);
	_g_variant_unref0 (_tmp19_);
	after = (_vala_array_free (after, after_length1, (GDestroyNotify) g_free), NULL);
	before = (g_free (before), NULL);
	_g_variant_unref0 (slist_val);
	__g_list_free__gtk_tree_path_free0_0 (paths);
	_g_object_unref0 (sel);
}


GtkSizeGroup* deja_dup_config_list_get_size_group (DejaDupConfigList* self) {
	GtkSizeGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_size_group;
	return result;
}


static void deja_dup_config_list_set_size_group (DejaDupConfigList* self, GtkSizeGroup* value) {
	GtkSizeGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_size_group);
	self->priv->_size_group = _tmp0_;
	g_object_notify ((GObject *) self, "size-group");
}


static void _deja_dup_config_list_handle_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	deja_dup_config_list_handle_add (self);
}


static void _deja_dup_config_list_handle_remove_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	deja_dup_config_list_handle_remove (self);
}


static gboolean _deja_dup_config_list_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = deja_dup_config_list_on_key_press_event (self, _sender, event);
	return result;
}


static void _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	deja_dup_config_list_handle_selection_change (self, _sender);
}


static GObject * deja_dup_config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigList * self;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* model;
	GtkTreeView* _tmp1_ = NULL;
	GtkCellRendererPixbuf* _tmp2_ = NULL;
	GtkCellRendererPixbuf* _tmp3_;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* renderer;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkScrolledWindow* _tmp7_ = NULL;
	GtkScrolledWindow* scroll;
	GtkHBox* _tmp8_ = NULL;
	GtkHBox* hbox;
	GtkVBox* _tmp9_ = NULL;
	GtkVBox* vbox;
	GtkTreeSelection* _tmp10_ = NULL;
	GtkTreeSelection* _tmp11_;
	GtkTreeSelection* selection;
	parent_class = G_OBJECT_CLASS (deja_dup_config_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_LIST (obj);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_ICON);
	model = _tmp0_;
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new ();
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) self->priv->tree, "model", model, "headers-visible", FALSE, NULL);
	deja_dup_config_widget_set_mnemonic_widget ((DejaDupConfigWidget*) self, (GtkWidget*) self->priv->tree);
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) _tmp3_, "gicon", 2, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp4_);
	gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) renderer, "text", 1, NULL);
	_tmp5_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_ADD);
	_g_object_unref0 (self->priv->add_button);
	self->priv->add_button = g_object_ref_sink (_tmp5_);
	g_signal_connect_object (self->priv->add_button, "clicked", (GCallback) _deja_dup_config_list_handle_add_gtk_button_clicked, self, 0);
	_tmp6_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_REMOVE);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->remove_button = g_object_ref_sink (_tmp6_);
	g_signal_connect_object (self->priv->remove_button, "clicked", (GCallback) _deja_dup_config_list_handle_remove_gtk_button_clicked, self, 0);
	if (self->priv->_size_group != NULL) {
		gtk_size_group_add_widget (self->priv->_size_group, (GtkWidget*) self->priv->add_button);
		gtk_size_group_add_widget (self->priv->_size_group, (GtkWidget*) self->priv->remove_button);
	}
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scroll = g_object_ref_sink (_tmp7_);
	g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	g_object_set (scroll, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	_tmp8_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp8_);
	_tmp9_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp9_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->add_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->remove_button, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->tree);
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) scroll);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
	_tmp10_ = gtk_tree_view_get_selection (self->priv->tree);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	selection = _tmp11_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _deja_dup_config_list_on_key_press_event_gtk_widget_key_press_event, self, 0);
	deja_dup_config_widget_set_from_config ((DejaDupConfigWidget*) self, NULL, NULL);
	deja_dup_config_list_handle_selection_change (self, selection);
	g_signal_connect_object (selection, "changed", (GCallback) _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed, self, 0);
	_g_object_unref0 (selection);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (scroll);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	return obj;
}


static void deja_dup_config_list_class_init (DejaDupConfigListClass * klass) {
	deja_dup_config_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigListPrivate));
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config = deja_dup_config_list_real_set_from_config;
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config_finish = deja_dup_config_list_real_set_from_config_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_config_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_config_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_LIST_SIZE_GROUP, g_param_spec_object ("size-group", "size-group", "size-group", GTK_TYPE_SIZE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_config_list_instance_init (DejaDupConfigList * self) {
	self->priv = DEJA_DUP_CONFIG_LIST_GET_PRIVATE (self);
}


static void deja_dup_config_list_finalize (GObject* obj) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (obj);
	_g_object_unref0 (self->priv->_size_group);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->remove_button);
	G_OBJECT_CLASS (deja_dup_config_list_parent_class)->finalize (obj);
}


GType deja_dup_config_list_get_type (void) {
	static volatile gsize deja_dup_config_list_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigList), 0, (GInstanceInitFunc) deja_dup_config_list_instance_init, NULL };
		GType deja_dup_config_list_type_id;
		deja_dup_config_list_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_WIDGET, "DejaDupConfigList", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_list_type_id__volatile, deja_dup_config_list_type_id);
	}
	return deja_dup_config_list_type_id__volatile;
}


static void _vala_deja_dup_config_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LIST_SIZE_GROUP:
		g_value_set_object (value, deja_dup_config_list_get_size_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_config_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LIST_SIZE_GROUP:
		deja_dup_config_list_set_size_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



