/* monitor.c generated by valac 0.12.0, the Vala compiler
 * generated from monitor.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>,
    © 2009 Andrew Fister <temposs@gmail.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libnotify/notify.h>
#include <gio/gio.h>
#include <common.h>
#include <config.h>
#include <string.h>
#include <time.h>
#include <glib/gi18n-lib.h>


#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _Monitor {
	GObject parent_instance;
	MonitorPrivate * priv;
};

struct _MonitorClass {
	GObjectClass parent_class;
};


static gpointer monitor_parent_class = NULL;
static guint monitor_timeout_id;
static guint monitor_timeout_id = 0U;
static GPid monitor_pid;
static GPid monitor_pid = 0;
static gboolean monitor_op_active;
static gboolean monitor_op_active = FALSE;
static gboolean monitor_reactive_check;
static gboolean monitor_reactive_check = FALSE;
static gboolean monitor_testing;
static gboolean monitor_testing = FALSE;
static gboolean monitor_first_check;
static gboolean monitor_first_check = FALSE;
static gboolean monitor_show_version;
static gboolean monitor_show_version = FALSE;
static NotifyNotification* monitor_note;
static NotifyNotification* monitor_note = NULL;

GType monitor_get_type (void) G_GNUC_CONST;
enum  {
	MONITOR_DUMMY_PROPERTY
};
static void monitor_op_started (GDBusConnection* conn, const gchar* name, const gchar* name_owner);
static void monitor_op_ended (GDBusConnection* conn, const gchar* name);
static void monitor_network_changed (void);
static void monitor_prepare_next_run (void);
static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol);
static gboolean monitor_is_ready (gchar** when);
static gboolean monitor_handle_options (gint* status);
static void monitor_today (GDate* result);
static void monitor_most_recent_scheduled_date (gint period, GDate* result);
static void monitor_next_run_date (GDate* result);
static void monitor_date_to_timeval (GDate* date, GTimeVal* result);
static glong monitor_seconds_until (GDate* date);
static void monitor_close_pid (GPid child_pid, gint status);
static void monitor_notify_delay (const gchar* header, const gchar* reason);
static void _lambda0_ (NotifyNotification* n);
static void __lambda0__notify_notification_closed (NotifyNotification* _sender, gpointer self);
static gboolean monitor_kickoff (void);
static gboolean monitor_seconds_until_next_run (glong* secs);
static void monitor_prepare_tomorrow (void);
static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self);
static void monitor_prepare_run (glong wait_time);
static gboolean _monitor_kickoff_gsource_func (gpointer self);
static void monitor_prepare_if_necessary (const gchar* key);
static void monitor_make_first_check (void);
static void monitor_watch_settings (void);
static void _monitor_prepare_if_necessary_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gint monitor_main (gchar** args, int args_length1);
static void _monitor_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _monitor_op_started_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _monitor_op_ended_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static gboolean _lambda1_ (void);
static gboolean __lambda1__gsource_func (gpointer self);
Monitor* monitor_new (void);
Monitor* monitor_construct (GType object_type);
static void monitor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MONITOR_options[3] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &monitor_show_version, "Show version", NULL}, {"testing", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &monitor_testing, NULL, NULL}, {NULL}};

static void monitor_op_started (GDBusConnection* conn, const gchar* name, const gchar* name_owner) {
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	monitor_op_active = TRUE;
}


static void monitor_op_ended (GDBusConnection* conn, const gchar* name) {
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	monitor_op_active = FALSE;
}


static void monitor_network_changed (void) {
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	monitor_reactive_check = TRUE;
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		monitor_prepare_next_run ();
	}
	monitor_reactive_check = FALSE;
}


static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol) {
	g_return_if_fail (vm != NULL);
	g_return_if_fail (vol != NULL);
	monitor_reactive_check = TRUE;
	monitor_prepare_next_run ();
	monitor_reactive_check = FALSE;
}


static gboolean monitor_is_ready (gchar** when) {
	gchar* _when = NULL;
	gboolean result = FALSE;
	DejaDupBackend* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_;
	DejaDupBackend* _tmp2_;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	_tmp0_ = deja_dup_backend_get_default (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_tmp2_ = _tmp1_;
	_tmp4_ = deja_dup_backend_is_ready (_tmp2_, &_tmp3_);
	_g_free0 (_when);
	_when = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	if (when) {
		*when = _when;
	} else {
		_g_free0 (_when);
	}
	return result;
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = TRUE;
		_g_error_free0 (e);
		if (when) {
			*when = _when;
		} else {
			_g_free0 (_when);
		}
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gboolean monitor_handle_options (gint* status) {
	gint _status = 0;
	gboolean result = FALSE;
	_status = 0;
	if (monitor_show_version) {
		g_print ("%s %s\n", "deja-dup-monitor", VERSION);
		result = FALSE;
		if (status) {
			*status = _status;
		}
		return result;
	}
	result = TRUE;
	if (status) {
		*status = _status;
	}
	return result;
}


static void monitor_today (GDate* result) {
	GTimeVal cur_time = {0};
	GDate cur_date = {0};
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	memset (&cur_date, 0, sizeof (GDate));
	g_date_set_time_val (&cur_date, &cur_time);
	*result = cur_date;
	return;
}


static void monitor_most_recent_scheduled_date (gint period, GDate* result) {
	GDate epoch = {0};
	GDate _tmp0_ = {0};
	GDate _tmp1_ = {0};
	GDate cur_date;
	gint _tmp2_;
	gint between;
	gint mod;
	memset (&epoch, 0, sizeof (GDate));
	g_date_set_dmy (&epoch, (GDateDay) 1, 1, (GDateYear) 1970);
	monitor_today (&_tmp0_);
	_tmp1_ = _tmp0_;
	cur_date = _tmp1_;
	_tmp2_ = g_date_days_between (&epoch, &cur_date);
	between = _tmp2_;
	mod = between % period;
	g_date_subtract_days (&cur_date, (guint) mod);
	*result = cur_date;
	return;
}


static void monitor_next_run_date (GDate* result) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gboolean _tmp1_;
	gboolean periodic;
	gchar* _tmp2_ = NULL;
	gchar* last_run_string;
	gint _tmp3_;
	gint period_days;
	GDate last_run = {0};
	GTimeVal last_run_tval = {0};
	gboolean _tmp8_;
	gboolean _tmp11_;
	GDate _tmp14_ = {0};
	GDate _tmp15_ = {0};
	GDate last_scheduled;
	gint _tmp16_;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_PERIODIC_KEY);
	periodic = _tmp1_;
	_tmp2_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_RUN_KEY);
	last_run_string = _tmp2_;
	_tmp3_ = g_settings_get_int ((GSettings*) settings, DEJA_DUP_PERIODIC_PERIOD_KEY);
	period_days = _tmp3_;
	if (!periodic) {
		GDate _tmp4_ = {0};
		GDate _tmp5_ = {0};
		memset (&_tmp4_, 0, sizeof (GDate));
		_tmp5_ = _tmp4_;
		*result = _tmp5_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return;
	}
	if (last_run_string == NULL) {
		GDate _tmp6_ = {0};
		GDate _tmp7_ = {0};
		monitor_today (&_tmp6_);
		_tmp7_ = _tmp6_;
		*result = _tmp7_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return;
	}
	if (period_days <= 0) {
		period_days = 1;
	}
	memset (&last_run, 0, sizeof (GDate));
	g_get_current_time (&last_run_tval);
	_tmp8_ = g_time_val_from_iso8601 (last_run_string, &last_run_tval);
	if (!_tmp8_) {
		GDate _tmp9_ = {0};
		GDate _tmp10_ = {0};
		monitor_today (&_tmp9_);
		_tmp10_ = _tmp9_;
		*result = _tmp10_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return;
	}
	g_date_set_time_val (&last_run, &last_run_tval);
	_tmp11_ = g_date_valid (&last_run);
	if (!_tmp11_) {
		GDate _tmp12_ = {0};
		GDate _tmp13_ = {0};
		monitor_today (&_tmp12_);
		_tmp13_ = _tmp12_;
		*result = _tmp13_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return;
	}
	monitor_most_recent_scheduled_date (period_days, &_tmp14_);
	_tmp15_ = _tmp14_;
	last_scheduled = _tmp15_;
	_tmp16_ = g_date_compare (&last_scheduled, &last_run);
	if (_tmp16_ <= 0) {
		g_date_add_days (&last_scheduled, (guint) period_days);
	}
	*result = last_scheduled;
	_g_free0 (last_run_string);
	_g_object_unref0 (settings);
	return;
}


static void monitor_date_to_timeval (GDate* date, GTimeVal* result) {
	struct tm time = {0};
	struct tm _tmp0_ = {0};
	time_t _tmp1_;
	time_t timet;
	GTimeVal tval = {0};
	g_date_to_struct_tm (date, &_tmp0_);
	time = _tmp0_;
	time.tm_hour = 0;
	time.tm_min = 0;
	time.tm_sec = 0;
	_tmp1_ = mktime (&time);
	timet = _tmp1_;
	g_get_current_time (&tval);
	tval.tv_sec = (glong) timet;
	tval.tv_usec = (glong) 0;
	*result = tval;
	return;
}


static glong monitor_seconds_until (GDate* date) {
	glong result = 0L;
	GTimeVal cur_time = {0};
	GTimeVal _tmp0_ = {0};
	GTimeVal _tmp1_ = {0};
	GTimeVal next_time;
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	monitor_date_to_timeval (date, &_tmp0_);
	_tmp1_ = _tmp0_;
	next_time = _tmp1_;
	if (monitor_testing) {
		result = (glong) 5;
		return result;
	} else {
		result = next_time.tv_sec - cur_time.tv_sec;
		return result;
	}
}


static void monitor_close_pid (GPid child_pid, gint status) {
	g_spawn_close_pid (child_pid);
	monitor_pid = (GPid) 0;
}


static void _lambda0_ (NotifyNotification* n) {
	g_return_if_fail (n != NULL);
	_g_object_unref0 (monitor_note);
	monitor_note = NULL;
}


static void __lambda0__notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	_lambda0_ (_sender);
}


static void monitor_notify_delay (const gchar* header, const gchar* reason) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (header != NULL);
	g_return_if_fail (reason != NULL);
	if (monitor_note == NULL) {
		const gchar* _tmp0_ = NULL;
		NotifyNotification* _tmp1_ = NULL;
		_tmp0_ = g_get_application_name ();
		notify_init (_tmp0_);
		_tmp1_ = notify_notification_new (header, reason, "deja-dup-backup");
		_g_object_unref0 (monitor_note);
		monitor_note = _tmp1_;
		g_signal_connect (monitor_note, "closed", (GCallback) __lambda0__notify_notification_closed, NULL);
	} else {
		notify_notification_update (monitor_note, header, reason, "deja-dup-backup");
	}
	notify_notification_show (monitor_note, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("monitor.vala:202: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self) {
	monitor_close_pid (pid, status);
}


static gboolean monitor_kickoff (void) {
	gboolean result = FALSE;
	glong wait_time = 0L;
	glong _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar* when = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp1_ = monitor_seconds_until_next_run (&_tmp0_);
	wait_time = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	if (!monitor_testing) {
		_tmp2_ = wait_time > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		monitor_prepare_next_run ();
		result = FALSE;
		return result;
	}
	if (!monitor_reactive_check) {
		monitor_prepare_tomorrow ();
	}
	_tmp4_ = monitor_is_ready (&_tmp3_);
	_g_free0 (when);
	when = _tmp3_;
	if (!_tmp4_) {
		g_debug ("monitor.vala:228: Postponing the backup.");
		if (!monitor_reactive_check) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _ ("Scheduled backup delayed");
			monitor_notify_delay (_tmp5_, when);
		}
		result = FALSE;
		_g_free0 (when);
		return result;
	}
	if (monitor_pid == ((GPid) 0)) {
		_tmp6_ = !monitor_op_active;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar** _tmp7_ = NULL;
		gchar** argv;
		gint argv_length1;
		gint _argv_size_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GPid _tmp13_;
		_tmp7_ = g_new0 (gchar*, 3 + 1);
		argv = _tmp7_;
		argv_length1 = 3;
		_argv_size_ = 3;
		_tmp8_ = g_strdup ("deja-dup");
		_tmp9_ = _tmp8_;
		_g_free0 (argv[0]);
		argv[0] = _tmp9_;
		_tmp10_ = g_strdup ("--backup");
		_tmp11_ = _tmp10_;
		_g_free0 (argv[1]);
		argv[1] = _tmp11_;
		_tmp12_ = NULL;
		_g_free0 (argv[2]);
		argv[2] = _tmp12_;
		g_spawn_async (NULL, argv, NULL, ((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp13_, &_inner_error_);
		monitor_pid = _tmp13_;
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, monitor_pid, _monitor_close_pid_gchild_watch_func, NULL, NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("monitor.vala:250: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (when);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	} else {
		g_debug ("monitor.vala:254: Not rerunning deja-dup, already doing so.");
	}
	result = FALSE;
	_g_free0 (when);
	return result;
}


static gboolean monitor_seconds_until_next_run (glong* secs) {
	glong _secs = 0L;
	gboolean result = FALSE;
	GDate _tmp0_ = {0};
	GDate _tmp1_ = {0};
	GDate next_date;
	gboolean _tmp2_;
	glong _tmp3_;
	monitor_next_run_date (&_tmp0_);
	_tmp1_ = _tmp0_;
	next_date = _tmp1_;
	_tmp2_ = g_date_valid (&next_date);
	if (!_tmp2_) {
		g_debug ("monitor.vala:263: Invalid next run date.  Not scheduling a backup.");
		result = FALSE;
		if (secs) {
			*secs = _secs;
		}
		return result;
	}
	_tmp3_ = monitor_seconds_until (&next_date);
	_secs = _tmp3_;
	result = TRUE;
	if (secs) {
		*secs = _secs;
	}
	return result;
}


static gboolean _monitor_kickoff_gsource_func (gpointer self) {
	gboolean result;
	result = monitor_kickoff ();
	return result;
}


static void monitor_prepare_run (glong wait_time) {
	if (monitor_timeout_id != 0) {
		g_source_remove (monitor_timeout_id);
	}
	if (wait_time > 0) {
		guint _tmp0_;
		g_debug ("monitor.vala:278: Waiting %ld seconds until next backup.", wait_time);
		_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) wait_time, _monitor_kickoff_gsource_func, NULL, NULL);
		monitor_timeout_id = _tmp0_;
	} else {
		g_debug ("monitor.vala:282: Late by %ld seconds.  Backing up now.", wait_time * (-1));
		monitor_kickoff ();
	}
}


static void monitor_prepare_tomorrow (void) {
	GDate _tmp0_ = {0};
	GDate _tmp1_ = {0};
	GDate tomorrow;
	glong _tmp2_;
	glong secs;
	monitor_today (&_tmp0_);
	_tmp1_ = _tmp0_;
	tomorrow = _tmp1_;
	g_date_add_days (&tomorrow, (guint) 1);
	_tmp2_ = monitor_seconds_until (&tomorrow);
	secs = _tmp2_;
	monitor_prepare_run (secs);
}


static void monitor_prepare_next_run (void) {
	glong wait_time = 0L;
	glong _tmp0_;
	gboolean _tmp1_;
	if (!monitor_first_check) {
		return;
	}
	_tmp1_ = monitor_seconds_until_next_run (&_tmp0_);
	wait_time = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	monitor_prepare_run (wait_time);
}


static void monitor_prepare_if_necessary (const gchar* key) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, DEJA_DUP_LAST_RUN_KEY) == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, DEJA_DUP_PERIODIC_KEY) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, DEJA_DUP_PERIODIC_PERIOD_KEY) == 0;
	}
	if (_tmp0_) {
		monitor_prepare_next_run ();
	}
}


static void monitor_make_first_check (void) {
	monitor_first_check = TRUE;
	monitor_prepare_next_run ();
}


static void _monitor_prepare_if_necessary_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	monitor_prepare_if_necessary (key);
}


static void monitor_watch_settings (void) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	g_signal_connect ((GSettings*) settings, "changed", (GCallback) _monitor_prepare_if_necessary_g_settings_changed, NULL);
	_g_object_unref0 (settings);
}


static void _monitor_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	monitor_network_changed ();
}


static void _monitor_op_started_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	monitor_op_started (connection, name, name_owner);
}


static void _monitor_op_ended_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	monitor_op_ended (connection, name);
}


static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	monitor_volume_added (_sender, volume);
}


static gboolean _lambda1_ (void) {
	gboolean result = FALSE;
	monitor_make_first_check ();
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ ();
	return result;
}


static gint monitor_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* context;
	gint status = 0;
	gint _tmp4_;
	gboolean _tmp5_;
	DejaDupNetwork* _tmp6_ = NULL;
	DejaDupNetwork* _tmp7_;
	GVolumeMonitor* _tmp8_ = NULL;
	GVolumeMonitor* mon;
	GMainLoop* _tmp9_ = NULL;
	GMainLoop* loop;
	GError * _inner_error_ = NULL;
	deja_dup_i18n_setup ();
	_tmp0_ = _ ("Déjà Dup Monitor");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_option_context_new ("");
	context = _tmp1_;
	g_option_context_add_main_entries (context, MONITOR_options, GETTEXT_PACKAGE);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_option_context_get_help (context, TRUE, NULL);
		_tmp3_ = _tmp2_;
		g_printerr ("%s\n\n%s", e->message, _tmp3_);
		_g_free0 (_tmp3_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = monitor_handle_options (&_tmp4_);
	status = _tmp4_;
	if (!_tmp5_) {
		result = status;
		_g_option_context_free0 (context);
		return result;
	}
	deja_dup_initialize ();
	_tmp6_ = deja_dup_network_get ();
	_tmp7_ = _tmp6_;
	g_signal_connect ((GObject*) _tmp7_, "notify::connected", (GCallback) _monitor_network_changed_g_object_notify, NULL);
	_g_object_unref0 (_tmp7_);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Operation", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_monitor_op_started_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _monitor_op_started_gbus_name_appeared_callback, NULL, NULL)), (GClosure*) ((_monitor_op_ended_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _monitor_op_ended_gbus_name_vanished_callback, NULL, NULL)));
	_tmp8_ = g_volume_monitor_get ();
	mon = _tmp8_;
	g_object_ref ((GObject*) mon);
	g_signal_connect (mon, "volume-added", (GCallback) _monitor_volume_added_g_volume_monitor_volume_added, NULL);
	_tmp9_ = g_main_loop_new (NULL, FALSE);
	loop = _tmp9_;
	if (monitor_testing) {
		monitor_make_first_check ();
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 120, __lambda1__gsource_func, NULL, NULL);
	}
	monitor_watch_settings ();
	g_main_loop_run (loop);
	result = 0;
	_g_main_loop_unref0 (loop);
	_g_object_unref0 (mon);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return monitor_main (argv, argc);
}


Monitor* monitor_construct (GType object_type) {
	Monitor * self = NULL;
	self = (Monitor*) g_object_new (object_type, NULL);
	return self;
}


Monitor* monitor_new (void) {
	return monitor_construct (TYPE_MONITOR);
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
}


static void monitor_finalize (GObject* obj) {
	Monitor * self;
	self = MONITOR (obj);
	G_OBJECT_CLASS (monitor_parent_class)->finalize (obj);
}


GType monitor_get_type (void) {
	static volatile gsize monitor_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, NULL };
		GType monitor_type_id;
		monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "Monitor", &g_define_type_info, 0);
		g_once_init_leave (&monitor_type_id__volatile, monitor_type_id);
	}
	return monitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



