/* DuplicityInstance.c generated by valac, the Vala compiler
 * generated from DuplicityInstance.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>,
    © 2009 Andrew Fister <temposs@gmail.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gconf/gconf-client.h>
#include <signal.h>
#include <sys/types.h>
#include <gio/gunixinputstream.h>
#include <sys/wait.h>


#define DEJA_DUP_TYPE_DUPLICITY_INSTANCE (deja_dup_duplicity_instance_get_type ())
#define DEJA_DUP_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstance))
#define DEJA_DUP_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))

typedef struct _DejaDupDuplicityInstance DejaDupDuplicityInstance;
typedef struct _DejaDupDuplicityInstanceClass DejaDupDuplicityInstanceClass;
typedef struct _DejaDupDuplicityInstancePrivate DejaDupDuplicityInstancePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _DejaDupDuplicityInstanceReadLogLinesData DejaDupDuplicityInstanceReadLogLinesData;
typedef struct _DejaDupDuplicityInstanceReadLogData DejaDupDuplicityInstanceReadLogData;

struct _DejaDupDuplicityInstance {
	GObject parent_instance;
	DejaDupDuplicityInstancePrivate * priv;
};

struct _DejaDupDuplicityInstanceClass {
	GObjectClass parent_class;
	void (*start) (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
};

struct _DejaDupDuplicityInstancePrivate {
	gboolean _verbose;
	guint watch_id;
	GPid child_pid;
	gint* pipes;
	gint pipes_length1;
	gint _pipes_size_;
	GDataInputStream* reader;
	GFile* logfile;
	GFile* scriptfile;
	gboolean process_done;
	gint status;
	gboolean processed_a_message;
};

struct _DejaDupDuplicityInstanceReadLogLinesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupDuplicityInstance* self;
	GList* stanza;
	char* line;
	GList* _tmp0_;
	GError * err;
	GDataInputStream* _tmp1_;
	GError * e2;
	GError * _inner_error_;
};

struct _DejaDupDuplicityInstanceReadLogData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupDuplicityInstance* self;
	GInputStream* stream;
	GFileInputStream* _tmp0_;
	GInputStream* _tmp1_;
	GInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GError * e;
	GError * _inner_error_;
};


static gpointer deja_dup_duplicity_instance_parent_class = NULL;

GType deja_dup_duplicity_instance_get_type (void);
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstancePrivate))
enum  {
	DEJA_DUP_DUPLICITY_INSTANCE_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE
};
static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value);
GType deja_dup_duplicity_info_get_type (void);
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_get_has_fixed_log_file (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_use_empty_gpg_options (DejaDupDuplicityInfo* self);
static void _g_list_free_g_free (GList* self);
GConfClient* deja_dup_get_gconf_client (void);
#define DEJA_DUP_ROOT_PROMPT_KEY "/apps/deja-dup/root-prompt"
static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status);
static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self);
static void deja_dup_duplicity_instance_read_log (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_duplicity_instance_read_log_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_);
void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_stop_child (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_pause (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_cont_child (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_resume (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_read_log_lines_data_free (gpointer _data);
static void deja_dup_duplicity_instance_read_log_lines_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_duplicity_instance_send_done_for_status (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_read_log_lines (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_duplicity_instance_read_log_lines_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_);
static gboolean _lambda0_ (DejaDupDuplicityInstance* self);
static gboolean __lambda0__gsource_func (gpointer self);
gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza);
static gboolean deja_dup_duplicity_instance_read_log_lines_co (DejaDupDuplicityInstanceReadLogLinesData* data);
static void deja_dup_duplicity_instance_read_log_data_free (gpointer _data);
static void deja_dup_duplicity_instance_read_log_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_duplicity_instance_read_log_co (DejaDupDuplicityInstanceReadLogData* data);
static gint deja_dup_duplicity_instance_num_suffix (const char* word, gchar ch, glong start);
static char* deja_dup_duplicity_instance_validated_string (const char* s);
static char* deja_dup_duplicity_instance_compress_string (const char* s_in);
static void deja_dup_duplicity_instance_split_line (const char* line, char*** split, int* split_length1);
static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza);
static char* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type);
static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_duplicity_instance_finalize (GObject* obj);
static void deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self) {
	deja_dup_duplicity_instance_spawn_finished (self, pid, status);
}


static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error) {
	GError * _inner_error_;
	char* verbose_str;
	gboolean _tmp0_ = FALSE;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	char** _tmp4_;
	gint _myenv_size_;
	gint myenv_length1;
	char** _tmp3_;
	char** myenv;
	gint myenv_len;
	guint env_len;
	char** _tmp5_;
	gint _real_envp_size_;
	gint real_envp_length1;
	char** real_envp;
	gint i;
	char* _tmp10_;
	GList* argv;
	DejaDupDuplicityInfo* _tmp11_;
	gboolean _tmp12_;
	char* cache_dir;
	DejaDupDuplicityInfo* _tmp16_;
	gboolean _tmp17_;
	char* user_cmd;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	char* _tmp41_;
	gboolean _tmp42_;
	char* _tmp43_;
	gboolean _tmp44_;
	char** _tmp46_;
	gint _real_argv_size_;
	gint real_argv_length1;
	gint _tmp45_;
	char** real_argv;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	verbose_str = g_strdup (g_getenv ("DEJA_DUP_DEBUG"));
	if (verbose_str != NULL) {
		_tmp0_ = atoi (verbose_str) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		deja_dup_duplicity_instance_set_verbose (self, TRUE);
	}
	if ((_tmp2_ = !deja_dup_duplicity_info_get_has_fixed_log_file (_tmp1_ = deja_dup_duplicity_info_get_default ()), _g_object_unref0 (_tmp1_), _tmp2_)) {
		as_root = FALSE;
	}
	myenv = (_tmp4_ = _tmp3_ = g_listenv (), myenv_length1 = _vala_array_length (_tmp3_), _myenv_size_ = myenv_length1, _tmp4_);
	myenv_len = 0;
	while (TRUE) {
		if (!(myenv[myenv_len] != NULL)) {
			break;
		}
		myenv_len = myenv_len + 1;
	}
	env_len = myenv_len + g_list_length (envp_in);
	real_envp = (_tmp5_ = g_new0 (char*, (env_len + 1) + 1), real_envp_length1 = env_len + 1, _real_envp_size_ = real_envp_length1, _tmp5_);
	i = 0;
	{
		gboolean _tmp6_;
		_tmp6_ = TRUE;
		while (TRUE) {
			char* _tmp7_;
			if (!_tmp6_) {
				i = i + 1;
			}
			_tmp6_ = FALSE;
			if (!(i < myenv_len)) {
				break;
			}
			real_envp[i] = (_tmp7_ = g_strdup_printf ("%s=%s", myenv[i], g_getenv (myenv[i])), _g_free0 (real_envp[i]), _tmp7_);
		}
	}
	{
		GList* env_collection;
		GList* env_it;
		env_collection = envp_in;
		for (env_it = env_collection; env_it != NULL; env_it = env_it->next) {
			char* env;
			env = g_strdup ((const char*) env_it->data);
			{
				char* _tmp9_;
				char* *_tmp8_;
				_tmp8_ = &real_envp[i++];
				(*_tmp8_) = (_tmp9_ = g_strdup (env), _g_free0 ((*_tmp8_)), _tmp9_);
				_g_free0 (env);
			}
		}
	}
	real_envp[i] = (_tmp10_ = NULL, _g_free0 (real_envp[i]), _tmp10_);
	argv = NULL;
	{
		GList* arg_collection;
		GList* arg_it;
		arg_collection = argv_in;
		for (arg_it = arg_collection; arg_it != NULL; arg_it = arg_it->next) {
			char* arg;
			arg = g_strdup ((const char*) arg_it->data);
			{
				argv = g_list_append (argv, g_strdup (arg));
				_g_free0 (arg);
			}
		}
	}
	argv = g_list_append (argv, g_strdup ("--verbosity=9"));
	if ((_tmp12_ = deja_dup_duplicity_info_get_use_empty_gpg_options (_tmp11_ = deja_dup_duplicity_info_get_default ()), _g_object_unref0 (_tmp11_), _tmp12_)) {
		argv = g_list_append (argv, g_strdup ("--gpg-options= "));
	}
	cache_dir = g_strdup (g_get_user_cache_dir ());
	if (cache_dir != NULL) {
		gboolean add_dir;
		GFile* cache_file;
		GFile* _tmp13_;
		add_dir = FALSE;
		cache_file = g_file_new_for_path (cache_dir);
		cache_file = (_tmp13_ = g_file_get_child (cache_file, PACKAGE), _g_object_unref0 (cache_file), _tmp13_);
		{
			gboolean _tmp14_;
			_tmp14_ = g_file_make_directory_with_parents (cache_file, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					goto __catch24_g_io_error_exists;
				}
				goto __catch24_g_error;
			}
			if (_tmp14_) {
				add_dir = TRUE;
			}
		}
		goto __finally24;
		__catch24_g_io_error_exists:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				add_dir = TRUE;
				_g_error_free0 (e);
			}
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:81: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally24:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (cache_file);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				return;
			} else {
				_g_object_unref0 (cache_file);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (add_dir) {
			char* _tmp15_;
			argv = g_list_append (argv, g_strconcat ("--archive-dir=", _tmp15_ = g_file_get_path (cache_file), NULL));
			_g_free0 (_tmp15_);
		}
		_g_object_unref0 (cache_file);
	}
	if ((_tmp17_ = deja_dup_duplicity_info_get_has_fixed_log_file (_tmp16_ = deja_dup_duplicity_info_get_default ()), _g_object_unref0 (_tmp16_), _tmp17_)) {
		gint logfd;
		char* _tmp23_;
		logfd = 0;
		{
			char* logname;
			char* _tmp20_;
			gint _tmp19_;
			char* _tmp18_ = NULL;
			gint _tmp21_;
			GFile* _tmp22_;
			logname = NULL;
			_tmp21_ = (_tmp19_ = g_file_open_tmp (PACKAGE "-XXXXXX", &_tmp18_, &_inner_error_), logname = (_tmp20_ = _tmp18_, _g_free0 (logname), _tmp20_), _tmp19_);
			if (_inner_error_ != NULL) {
				_g_free0 (logname);
				goto __catch25_g_error;
			}
			logfd = _tmp21_;
			self->priv->logfile = (_tmp22_ = g_file_new_for_path (logname), _g_object_unref0 (self->priv->logfile), _tmp22_);
			_g_free0 (logname);
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:97: %s\n", e->message);
				g_signal_emit_by_name (self, "done", FALSE, FALSE);
				_g_error_free0 (e);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				return;
			}
		}
		__finally25:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				return;
			} else {
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		argv = g_list_append (argv, g_strdup_printf ("--log-file=%s", _tmp23_ = g_file_get_path (self->priv->logfile)));
		_g_free0 (_tmp23_);
	} else {
		if (pipe (self->priv->pipes) != 0) {
			g_signal_emit_by_name (self, "done", FALSE, FALSE);
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			return;
		}
		argv = g_list_append (argv, g_strdup_printf ("--log-fd=%d", self->priv->pipes[1]));
	}
	argv = g_list_prepend (argv, g_strdup ("duplicity"));
	user_cmd = NULL;
	{
		GList* a_collection;
		GList* a_it;
		a_collection = argv;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			char* a;
			a = g_strdup ((const char*) a_it->data);
			{
				if (a == NULL) {
					_g_free0 (a);
					break;
				}
				if (user_cmd == NULL) {
					char* _tmp24_;
					user_cmd = (_tmp24_ = g_strdup (a), _g_free0 (user_cmd), _tmp24_);
				} else {
					char* _tmp25_;
					user_cmd = (_tmp25_ = g_strdup_printf ("%s %s", user_cmd, a), _g_free0 (user_cmd), _tmp25_);
				}
				_g_free0 (a);
			}
		}
	}
	if (as_root) {
		{
			GConfClient* client;
			gboolean _tmp26_;
			client = deja_dup_get_gconf_client ();
			_tmp26_ = gconf_client_get_bool (client, DEJA_DUP_ROOT_PROMPT_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (client);
				goto __catch26_g_error;
			}
			if (!_tmp26_) {
				as_root = FALSE;
			}
			_g_object_unref0 (client);
		}
		goto __finally26;
		__catch26_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:134: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally26:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				_g_free0 (user_cmd);
				return;
			} else {
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				_g_free0 (user_cmd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if (as_root) {
		char* _tmp29_;
		_tmp28_ = (_tmp29_ = g_find_program_in_path ("gksu")) != NULL;
		_g_free0 (_tmp29_);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		char* _tmp30_;
		_tmp27_ = (_tmp30_ = g_find_program_in_path ("sh")) != NULL;
		_g_free0 (_tmp30_);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		{
			char* scriptname;
			char* _tmp33_;
			gint _tmp32_;
			char* _tmp31_ = NULL;
			gint scriptfd;
			GFile* _tmp34_;
			GString* args;
			GList* _tmp38_;
			char* _tmp40_;
			char* _tmp39_;
			scriptname = NULL;
			scriptfd = (_tmp32_ = g_file_open_tmp (PACKAGE "-XXXXXX", &_tmp31_, &_inner_error_), scriptname = (_tmp33_ = _tmp31_, _g_free0 (scriptname), _tmp33_), _tmp32_);
			if (_inner_error_ != NULL) {
				_g_free0 (scriptname);
				goto __catch27_g_error;
			}
			self->priv->scriptfile = (_tmp34_ = g_file_new_for_path (scriptname), _g_object_unref0 (self->priv->scriptfile), _tmp34_);
			close (scriptfd);
			args = g_string_new ("");
			{
				GList* a_collection;
				GList* a_it;
				a_collection = argv;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					char* a;
					a = g_strdup ((const char*) a_it->data);
					{
						if (a == NULL) {
							_g_free0 (a);
							break;
						}
						if (args->len == 0) {
							char* _tmp35_;
							g_string_append (args, _tmp35_ = g_shell_quote (a));
							_g_free0 (_tmp35_);
						} else {
							char* _tmp37_;
							char* _tmp36_;
							g_string_append (args, _tmp37_ = g_strconcat (" ", _tmp36_ = g_shell_quote (a), NULL));
							_g_free0 (_tmp37_);
							_g_free0 (_tmp36_);
						}
						_g_free0 (a);
					}
				}
			}
			g_file_replace_contents (self->priv->scriptfile, args->str, (gsize) args->len, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (scriptname);
				_g_string_free0 (args);
				goto __catch27_g_error;
			}
			argv = (_tmp38_ = NULL, __g_list_free_g_free0 (argv), _tmp38_);
			argv = g_list_prepend (argv, g_strdup_printf ("sh %s", _tmp40_ = g_shell_quote (_tmp39_ = g_file_get_path (self->priv->scriptfile))));
			_g_free0 (_tmp40_);
			_g_free0 (_tmp39_);
			argv = g_list_prepend (argv, g_strdup (g_get_application_name ()));
			argv = g_list_prepend (argv, g_strdup ("--description"));
			argv = g_list_prepend (argv, g_strdup ("gksu"));
			_g_free0 (scriptname);
			_g_string_free0 (args);
		}
		goto __finally27;
		__catch27_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:173: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally27:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				_g_free0 (user_cmd);
				return;
			} else {
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				_g_free0 (user_cmd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if ((_tmp42_ = (_tmp41_ = g_find_program_in_path ("ionice")) != NULL, _g_free0 (_tmp41_), _tmp42_)) {
		argv = g_list_prepend (argv, g_strdup ("-n7"));
		argv = g_list_prepend (argv, g_strdup ("-c2"));
		argv = g_list_prepend (argv, g_strdup ("ionice"));
	}
	if ((_tmp44_ = (_tmp43_ = g_find_program_in_path ("nice")) != NULL, _g_free0 (_tmp43_), _tmp44_)) {
		argv = g_list_prepend (argv, g_strdup ("nice"));
	}
	real_argv = (_tmp46_ = g_new0 (char*, (_tmp45_ = g_list_length (argv)) + 1), real_argv_length1 = _tmp45_, _real_argv_size_ = real_argv_length1, _tmp46_);
	i = 0;
	{
		GList* a_collection;
		GList* a_it;
		a_collection = argv;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			char* a;
			a = g_strdup ((const char*) a_it->data);
			{
				char* _tmp48_;
				char* *_tmp47_;
				_tmp47_ = &real_argv[i++];
				(*_tmp47_) = (_tmp48_ = g_strdup (a), _g_free0 ((*_tmp47_)), _tmp48_);
				_g_free0 (a);
			}
		}
	}
	g_spawn_async_with_pipes (NULL, real_argv, real_envp, (((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_LEAVE_DESCRIPTORS_OPEN) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &self->priv->child_pid, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			_g_free0 (user_cmd);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			_g_free0 (user_cmd);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("DuplicityInstance.vala:199: Running the following duplicity (%i) comma" \
"nd: %s\n", (gint) self->priv->child_pid, user_cmd);
	self->priv->watch_id = g_child_watch_add (self->priv->child_pid, _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func, self);
	if (self->priv->pipes[1] != (-1)) {
		close (self->priv->pipes[1]);
	}
	deja_dup_duplicity_instance_read_log (self, NULL, NULL);
	_g_free0 (verbose_str);
	myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
	real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_free0 (argv);
	_g_free0 (cache_dir);
	_g_free0 (user_cmd);
	real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
}


void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error) {
	DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS (self)->start (self, argv_in, envp_in, as_root, error);
}


gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = ((gint) self->priv->child_pid) > 0;
	return result;
}


void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	if (deja_dup_duplicity_instance_is_started (self)) {
		deja_dup_duplicity_instance_kill_child (self);
	} else {
		g_signal_emit_by_name (self, "done", FALSE, TRUE);
	}
}


void deja_dup_duplicity_instance_pause (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	if (deja_dup_duplicity_instance_is_started (self)) {
		deja_dup_duplicity_instance_stop_child (self);
	}
}


void deja_dup_duplicity_instance_resume (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	if (deja_dup_duplicity_instance_is_started (self)) {
		deja_dup_duplicity_instance_cont_child (self);
	}
}


static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGKILL);
}


static void deja_dup_duplicity_instance_stop_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGSTOP);
}


static void deja_dup_duplicity_instance_cont_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGCONT);
}


static void deja_dup_duplicity_instance_read_log_lines_data_free (gpointer _data) {
	DejaDupDuplicityInstanceReadLogLinesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupDuplicityInstanceReadLogLinesData, data);
}


static void deja_dup_duplicity_instance_read_log_lines (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogLinesData* _data_;
	_data_ = g_slice_new0 (DejaDupDuplicityInstanceReadLogLinesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_duplicity_instance_read_log_lines);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_duplicity_instance_read_log_lines_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_duplicity_instance_read_log_lines_co (_data_);
}


static void deja_dup_duplicity_instance_read_log_lines_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_) {
	DejaDupDuplicityInstanceReadLogLinesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_duplicity_instance_read_log_lines_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogLinesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_duplicity_instance_read_log_lines_co (data);
}


static gboolean _lambda0_ (DejaDupDuplicityInstance* self) {
	gboolean result = FALSE;
	deja_dup_duplicity_instance_read_log_lines (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	return _lambda0_ (self);
}


static gboolean deja_dup_duplicity_instance_read_log_lines_co (DejaDupDuplicityInstanceReadLogLinesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->stanza = NULL;
		while (TRUE) {
			if (!(data->self->priv->reader != NULL)) {
				break;
			}
			{
				data->_state_ = 10;
				g_data_input_stream_read_line_async (data->self->priv->reader, G_PRIORITY_DEFAULT, NULL, deja_dup_duplicity_instance_read_log_lines_ready, data);
				return FALSE;
				_state_10:
				data->line = g_data_input_stream_read_line_finish (data->self->priv->reader, data->_res_, NULL, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch28_g_error;
				}
				if (data->line == NULL) {
					if (data->self->priv->process_done) {
						deja_dup_duplicity_instance_send_done_for_status (data->self);
						_g_free0 (data->line);
						break;
					} else {
						g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda0__gsource_func, g_object_ref (data->self), g_object_unref);
						_g_free0 (data->line);
						__g_list_free_g_free0 (data->stanza);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
					}
				}
				if (_vala_strcmp0 (data->line, "") != 0) {
					if (data->self->priv->_verbose) {
						g_print ("DUPLICITY: %s\n", data->line);
					}
					data->stanza = g_list_append (data->stanza, g_strdup (data->line));
				} else {
					if (data->stanza != NULL) {
						if (data->self->priv->_verbose) {
							g_print ("\n");
						}
						deja_dup_duplicity_instance_process_stanza (data->self, data->stanza);
						data->stanza = (data->_tmp0_ = NULL, __g_list_free_g_free0 (data->stanza), data->_tmp0_);
					}
				}
				_g_free0 (data->line);
			}
			goto __finally28;
			__catch28_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_warning ("DuplicityInstance.vala:309: %s\n", data->err->message);
					_g_error_free0 (data->err);
					break;
				}
			}
			__finally28:
			if (data->_inner_error_ != NULL) {
				__g_list_free_g_free0 (data->stanza);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->self->priv->reader = (data->_tmp1_ = NULL, _g_object_unref0 (data->self->priv->reader), data->_tmp1_);
		if (data->self->priv->logfile != NULL) {
			{
				g_file_delete (data->self->priv->logfile, NULL, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch29_g_error;
				}
			}
			goto __finally29;
			__catch29_g_error:
			{
				data->e2 = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_warning ("DuplicityInstance.vala:319: %s\n", data->e2->message);
					_g_error_free0 (data->e2);
				}
			}
			__finally29:
			if (data->_inner_error_ != NULL) {
				__g_list_free_g_free0 (data->stanza);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		g_object_unref ((GObject*) data->self);
		__g_list_free_g_free0 (data->stanza);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_duplicity_instance_read_log_data_free (gpointer _data) {
	DejaDupDuplicityInstanceReadLogData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupDuplicityInstanceReadLogData, data);
}


static void deja_dup_duplicity_instance_read_log (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogData* _data_;
	_data_ = g_slice_new0 (DejaDupDuplicityInstanceReadLogData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_duplicity_instance_read_log);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_duplicity_instance_read_log_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_duplicity_instance_read_log_co (_data_);
}


static void deja_dup_duplicity_instance_read_log_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_) {
	DejaDupDuplicityInstanceReadLogData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_duplicity_instance_read_log_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_duplicity_instance_read_log_co (data);
}


static gboolean deja_dup_duplicity_instance_read_log_co (DejaDupDuplicityInstanceReadLogData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 11:
		goto _state_11;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			if (data->self->priv->logfile != NULL) {
				data->_state_ = 11;
				g_file_read_async (data->self->priv->logfile, G_PRIORITY_DEFAULT, NULL, deja_dup_duplicity_instance_read_log_ready, data);
				return FALSE;
				_state_11:
				data->_tmp0_ = g_file_read_finish (data->self->priv->logfile, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->stream);
					goto __catch30_g_error;
				}
				data->stream = (data->_tmp1_ = (GInputStream*) data->_tmp0_, _g_object_unref0 (data->stream), data->_tmp1_);
			} else {
				data->stream = (data->_tmp2_ = (GInputStream*) ((GUnixInputStream*) g_unix_input_stream_new (data->self->priv->pipes[0], TRUE)), _g_object_unref0 (data->stream), data->_tmp2_);
			}
			data->self->priv->reader = (data->_tmp3_ = g_data_input_stream_new (data->stream), _g_object_unref0 (data->self->priv->reader), data->_tmp3_);
			_g_object_unref0 (data->stream);
		}
		goto __finally30;
		__catch30_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:338: %s\n", data->e->message);
				g_signal_emit_by_name (data->self, "done", FALSE, FALSE);
				_g_error_free0 (data->e);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally30:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		g_object_ref ((GObject*) data->self);
		deja_dup_duplicity_instance_read_log_lines (data->self, NULL, NULL);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gint deja_dup_duplicity_instance_num_suffix (const char* word, gchar ch, glong start) {
	gint result = 0;
	gint rv;
	g_return_val_if_fail (word != NULL, 0);
	rv = 0;
	if (start < 0) {
		start = ((glong) strlen (word)) - 1;
	}
	{
		glong i;
		i = start;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i = i - 1;
					rv = rv + 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (word, i)) != ch) {
					break;
				}
			}
		}
	}
	result = rv;
	return result;
}


static char* deja_dup_duplicity_instance_validated_string (const char* s) {
	char* result = NULL;
	GString* rv;
	const char* p;
	g_return_val_if_fail (s != NULL, NULL);
	rv = g_string_new ("");
	p = s;
	while (TRUE) {
		gunichar ch;
		gboolean _tmp0_ = FALSE;
		if (!(g_utf8_get_char (g_utf8_offset_to_pointer (p, 0)) != 0)) {
			break;
		}
		ch = g_utf8_get_char_validated (p, -1);
		if (ch == ((guint) (-1))) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = ch == ((guint) (-2));
		}
		if (_tmp0_) {
			g_string_append (rv, "�");
			p = g_utf8_offset_to_pointer (p, (glong) 1);
		} else {
			g_string_append_unichar (rv, ch);
			p = g_utf8_next_char (p);
		}
	}
	result = g_strdup (rv->str);
	_g_string_free0 (rv);
	return result;
}


static char* deja_dup_duplicity_instance_compress_string (const char* s_in) {
	char* result = NULL;
	gchar* _tmp1_;
	gint _rv_size_;
	gint rv_length1;
	gint _tmp0_;
	gchar* rv;
	gchar* _tmp2_;
	gint _s_size_;
	gint s_length1;
	gchar* s;
	gint i;
	gint j;
	g_return_val_if_fail (s_in != NULL, NULL);
	rv = (_tmp1_ = g_new0 (gchar, _tmp0_ = strlen (s_in) + 1), rv_length1 = _tmp0_, _rv_size_ = rv_length1, _tmp1_);
	s = (_tmp2_ = (gchar*) s_in, s_length1 = -1, _s_size_ = s_length1, _tmp2_);
	i = 0;
	j = 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		if (!(s[i] != 0)) {
			break;
		}
		if (s[i] == '\\') {
			_tmp3_ = s[i + 1] != 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gboolean bare_escape;
			bare_escape = FALSE;
			switch (s[i + 1]) {
				case 'b':
				{
					rv[j++] = '\b';
					i = i + 2;
					break;
				}
				case 'f':
				{
					rv[j++] = '\014';
					i = i + 2;
					break;
				}
				case 't':
				{
					rv[j++] = '\t';
					i = i + 2;
					break;
				}
				case 'n':
				{
					rv[j++] = '\n';
					i = i + 2;
					break;
				}
				case 'r':
				{
					rv[j++] = '\r';
					i = i + 2;
					break;
				}
				case 'v':
				{
					rv[j++] = '\013';
					i = i + 2;
					break;
				}
				case 'a':
				{
					rv[j++] = '\007';
					i = i + 2;
					break;
				}
				case 'x':
				{
					gboolean _tmp4_ = FALSE;
					if (s[i + 2] != 0) {
						_tmp4_ = s[i + 3] != 0;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						gchar* _tmp5_;
						gint _tmpstr_size_;
						gint tmpstr_length1;
						gchar* tmpstr;
						gulong val;
						tmpstr = (_tmp5_ = g_new0 (gchar, 3), tmpstr_length1 = 3, _tmpstr_size_ = tmpstr_length1, _tmp5_);
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						val = strtoul ((const char*) tmpstr, NULL, 16);
						rv[j++] = (gchar) val;
						i = i + 4;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_ = FALSE;
					if (s[i + 2] != 0) {
						_tmp7_ = s[i + 3] != 0;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						_tmp6_ = s[i + 4] != 0;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						gchar* _tmp8_;
						gint _tmpstr_size_;
						gint tmpstr_length1;
						gchar* tmpstr;
						gulong val;
						tmpstr = (_tmp8_ = g_new0 (gchar, 4), tmpstr_length1 = 4, _tmpstr_size_ = tmpstr_length1, _tmp8_);
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						tmpstr[2] = s[i + 4];
						val = strtoul ((const char*) tmpstr, NULL, 8);
						rv[j++] = (gchar) val;
						i = i + 5;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				default:
				{
					bare_escape = TRUE;
					break;
				}
			}
			if (bare_escape) {
				rv[j++] = s[i + 1];
				i = i + 2;
			}
		} else {
			rv[j++] = s[i++];
		}
	}
	result = g_strdup ((const char*) rv);
	rv = (g_free (rv), NULL);
	return result;
}


static char* string_chomp (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void deja_dup_duplicity_instance_split_line (const char* line, char*** split, int* split_length1) {
	char** _tmp1_;
	gint _firstsplit_size_;
	gint firstsplit_length1;
	char** _tmp0_;
	char** firstsplit;
	GList* splitlist;
	gint i = 0;
	gboolean in_group;
	char* group_word;
	char** _tmp13_;
	gint _tmp12_;
	g_return_if_fail (line != NULL);
	if (split != NULL) {
		*split = NULL;
	}
	firstsplit = (_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0), firstsplit_length1 = _vala_array_length (_tmp0_), _firstsplit_size_ = firstsplit_length1, _tmp1_);
	splitlist = NULL;
	in_group = FALSE;
	group_word = g_strdup ("");
	{
		gboolean _tmp2_;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			char* word;
			gboolean _tmp4_ = FALSE;
			if (!_tmp2_) {
				i = i + 1;
			}
			_tmp2_ = FALSE;
			if (!(firstsplit[i] != NULL)) {
				break;
			}
			word = g_strdup (firstsplit[i]);
			if (firstsplit[i + 1] == NULL) {
				char* _tmp3_;
				word = (_tmp3_ = string_chomp (word), _g_free0 (word), _tmp3_);
			}
			if (!in_group) {
				_tmp4_ = g_str_has_prefix (word, "\'");
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				in_group = TRUE;
			}
			if (in_group) {
				gboolean _tmp5_ = FALSE;
				char* _tmp7_;
				if (g_str_has_suffix (word, "\'")) {
					_tmp5_ = (deja_dup_duplicity_instance_num_suffix (word, '\\', ((glong) strlen (word)) - 2) % 2) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					in_group = FALSE;
				} else {
					if ((deja_dup_duplicity_instance_num_suffix (word, '\\', -1) % 2) == 1) {
						char* _tmp6_;
						word = (_tmp6_ = string_substring (word, (glong) 0, g_utf8_strlen (word, -1) - 2), _g_free0 (word), _tmp6_);
					}
				}
				word = (_tmp7_ = deja_dup_duplicity_instance_compress_string (word), _g_free0 (word), _tmp7_);
				if (_vala_strcmp0 (group_word, "") == 0) {
					char* _tmp8_;
					group_word = (_tmp8_ = g_strdup (word), _g_free0 (group_word), _tmp8_);
				} else {
					char* _tmp10_;
					char* _tmp9_;
					group_word = (_tmp10_ = g_strconcat (group_word, _tmp9_ = g_strconcat (" ", word, NULL), NULL), _g_free0 (group_word), _tmp10_);
					_g_free0 (_tmp9_);
				}
				if (!in_group) {
					char* _tmp11_;
					splitlist = g_list_append (splitlist, string_substring (group_word, (glong) 1, g_utf8_strlen (group_word, -1) - 2));
					group_word = (_tmp11_ = g_strdup (""), _g_free0 (group_word), _tmp11_);
				}
			} else {
				splitlist = g_list_append (splitlist, g_strdup (word));
			}
			_g_free0 (word);
		}
	}
	*split = (_tmp13_ = g_new0 (char*, (_tmp12_ = g_list_length (splitlist)) + 1), *split = (_vala_array_free (*split, *split_length1, (GDestroyNotify) g_free), NULL), *split_length1 = _tmp12_, _tmp13_);
	i = 0;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = splitlist;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			char* s;
			s = g_strdup ((const char*) s_it->data);
			{
				char* _tmp15_;
				char* *_tmp14_;
				_tmp14_ = &(*split)[i++];
				(*_tmp14_) = (_tmp15_ = g_strdup (s), _g_free0 ((*_tmp14_)), _tmp15_);
				_g_free0 (s);
			}
		}
	}
	firstsplit = (_vala_array_free (firstsplit, firstsplit_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_free0 (splitlist);
	_g_free0 (group_word);
}


static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza) {
	gint _control_line_size_;
	gint control_line_length1;
	char** control_line;
	GList* data;
	char* text;
	g_return_if_fail (self != NULL);
	control_line = (control_line_length1 = 0, NULL);
	deja_dup_duplicity_instance_split_line ((const char*) stanza->data, &control_line, &control_line_length1);
	data = deja_dup_duplicity_instance_grab_stanza_data (self, stanza);
	text = deja_dup_duplicity_instance_grab_stanza_text (self, stanza);
	self->priv->processed_a_message = TRUE;
	g_signal_emit_by_name (self, "message", control_line, control_line_length1, data, text);
	control_line = (_vala_array_free (control_line, control_line_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_free0 (data);
	_g_free0 (text);
}


static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza) {
	GList* result = NULL;
	GList* list;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	stanza = stanza->next;
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			char* line;
			line = g_strdup ((const char*) line_it->data);
			{
				if (!g_str_has_prefix (line, ". ")) {
					char* _tmp0_;
					list = g_list_append (list, deja_dup_duplicity_instance_validated_string (_tmp0_ = string_chomp (line)));
					_g_free0 (_tmp0_);
				}
				_g_free0 (line);
			}
		}
	}
	result = list;
	return result;
}


static char* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza) {
	char* result = NULL;
	char* text;
	g_return_val_if_fail (self != NULL, NULL);
	text = g_strdup ("");
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			char* line;
			line = g_strdup ((const char*) line_it->data);
			{
				if (g_str_has_prefix (line, ". ")) {
					char** _tmp1_;
					gint _split_size_;
					gint split_length1;
					char** _tmp0_;
					char** split;
					char* _tmp3_;
					char* _tmp2_;
					split = (_tmp1_ = _tmp0_ = g_strsplit (line, ". ", 2), split_length1 = _vala_array_length (_tmp0_), _split_size_ = split_length1, _tmp1_);
					text = (_tmp3_ = g_strdup_printf ("%s%s\n", text, _tmp2_ = deja_dup_duplicity_instance_validated_string (split[1])), _g_free0 (text), _tmp3_);
					_g_free0 (_tmp2_);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (line);
			}
		}
	}
	result = string_chomp (text);
	_g_free0 (text);
	return result;
}


static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status) {
	g_return_if_fail (self != NULL);
	self->priv->status = status;
	if (WIFEXITED (status)) {
		gint exitval;
		exitval = WEXITSTATUS (status);
		g_debug ("DuplicityInstance.vala:552: duplicity (%i) exited with value %i\n", (gint) pid, exitval);
	} else {
		g_debug ("DuplicityInstance.vala:555: duplicity (%i) process killed\n", (gint) pid);
	}
	self->priv->watch_id = (guint) 0;
	g_spawn_close_pid (pid);
	self->priv->process_done = TRUE;
	if (self->priv->reader == NULL) {
		deja_dup_duplicity_instance_send_done_for_status (self);
	}
}


static void deja_dup_duplicity_instance_send_done_for_status (DejaDupDuplicityInstance* self) {
	gboolean _tmp0_ = FALSE;
	gboolean success;
	gboolean cancelled;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (WIFEXITED (self->priv->status)) {
		_tmp0_ = WEXITSTATUS (self->priv->status) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	success = _tmp0_;
	cancelled = !WIFEXITED (self->priv->status);
	if (WIFEXITED (self->priv->status)) {
		_tmp2_ = !self->priv->processed_a_message;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		if (WEXITSTATUS (self->priv->status) == 255) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = WEXITSTATUS (self->priv->status) == 3;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		cancelled = TRUE;
	}
	self->priv->child_pid = (GPid) 0;
	g_signal_emit_by_name (self, "done", success, cancelled);
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type) {
	DejaDupDuplicityInstance * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void) {
	return deja_dup_duplicity_instance_construct (DEJA_DUP_TYPE_DUPLICITY_INSTANCE);
}


gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose;
	return result;
}


static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose = value;
	g_object_notify ((GObject *) self, "verbose");
}


static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupDuplicityInstance * self;
	parent_class = G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	{
		gint* _tmp0_;
		self->priv->pipes = (_tmp0_ = g_new0 (gint, 2), self->priv->pipes = (g_free (self->priv->pipes), NULL), self->priv->pipes_length1 = 2, self->priv->_pipes_size_ = self->priv->pipes_length1, _tmp0_);
		self->priv->pipes[0] = self->priv->pipes[1] = -1;
	}
	return obj;
}


static void deja_dup_duplicity_instance_class_init (DejaDupDuplicityInstanceClass * klass) {
	deja_dup_duplicity_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInstancePrivate));
	DEJA_DUP_DUPLICITY_INSTANCE_CLASS (klass)->start = deja_dup_duplicity_instance_real_start;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_instance_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_instance_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_duplicity_instance_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_instance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE, g_param_spec_boolean ("verbose", "verbose", "verbose", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("done", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("message", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_STRING);
}


static void deja_dup_duplicity_instance_instance_init (DejaDupDuplicityInstance * self) {
	self->priv = DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE (self);
	self->priv->_verbose = FALSE;
}


static void deja_dup_duplicity_instance_finalize (GObject* obj) {
	DejaDupDuplicityInstance * self;
	GError * _inner_error_;
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	_inner_error_ = NULL;
	{
		if (self->priv->watch_id != 0) {
			g_source_remove (self->priv->watch_id);
		}
		if (deja_dup_duplicity_instance_is_started (self)) {
			g_debug ("DuplicityInstance.vala:254: duplicity (%i) process killed\n", (gint) self->priv->child_pid);
			deja_dup_duplicity_instance_kill_child (self);
		}
		{
			if (self->priv->scriptfile != NULL) {
				g_file_delete (self->priv->scriptfile, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch31_g_error;
				}
			}
		}
		goto __finally31;
		__catch31_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:262: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally31:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	self->priv->pipes = (g_free (self->priv->pipes), NULL);
	_g_object_unref0 (self->priv->reader);
	_g_object_unref0 (self->priv->logfile);
	_g_object_unref0 (self->priv->scriptfile);
	G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_instance_get_type (void) {
	static volatile gsize deja_dup_duplicity_instance_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_instance_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInstance), 0, (GInstanceInitFunc) deja_dup_duplicity_instance_instance_init, NULL };
		GType deja_dup_duplicity_instance_type_id;
		deja_dup_duplicity_instance_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInstance", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_duplicity_instance_type_id__volatile, deja_dup_duplicity_instance_type_id);
	}
	return deja_dup_duplicity_instance_type_id__volatile;
}


static void deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		g_value_set_boolean (value, deja_dup_duplicity_instance_get_verbose (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		deja_dup_duplicity_instance_set_verbose (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_string (param_values + 4), data2);
}



