#!/usr/bin/env python
#
# see LICENSE.txt for license information
#
# $Id: split_cache_for_all.py 362 2008-01-27 21:29:50Z camrdale-guest $

import os
from re import subn
from sys import argv

try:
    from debian_bundle import debfile
except:
    raise ImportError, 'You must install the python-debian and python-apt packages to use this script'

def run(dirs):
    if not dirs:
        dirs = ['/var/cache/debtorrent']
        
    for dir in dirs:
        process(os.path.abspath(dir))

def process(dir):
    print "processing", dir
    for subdir in os.listdir(dir):
        (subdir_all, n) = subn(r'binary-[a-zA-Z0-9-]+([^a-zA-Z0-9-]?)', r'binary-all\1', subdir)
        if n > 0 and subdir != subdir_all:
            print "  trying to move from", subdir
            print "                   to", subdir_all
            move(os.path.join(dir, subdir), os.path.join(dir, subdir_all))
            
def move(subdir, subdir_all):
    for root, dirs, files in os.walk(subdir):
        for file in files:
            if file.endswith('.deb'):
                filename = os.path.join(root, file)
                all = False
                try:
                    deb = debfile.DebFile(filename)
                    if deb.debcontrol().get('Architecture', '') == 'all':
                        all = True
                except:
                    if file.endswith('_all.deb'):
                        all = True

                if all:
                    newfile = subdir_all + filename[len(subdir):]
                    if os.path.exists(newfile):
                        print "    not moving (destination exists)", os.path.basename(filename)
                    else:
                        print "    moving", os.path.basename(filename)
                        os.renames(filename, newfile)

if __name__ == '__main__':
    if argv[1:2] == ['--help']:
        print "Usage:", argv[0], "[directory directory ...]"
        print
        print "    Will move all architecture:all files from the binary-arch"
        print "    directories in each directory, into the appropriate"
        print "    binary-all directory. If no directories are specified on"
        print "    the command-line, then it will use /var/cache/debtorrent"
        exit(0)
    else:
        run(argv[1:])
