# Debreaper
# copyright (c) 2007 Josselin Mouette
# Licensed under the GPL (v2 only)

import os, sys
from subprocess import Popen, PIPE, call

debreaper_version = "@VERSION@"

def gdb_output (pid):
  gdbproc = Popen ([ "gdb", "--batch", "--quiet", "--pid=%d"%pid,
		     "--eval-command=bt",
		     "--eval-command=thread apply all bt full" ],
		   stdin=PIPE, stdout=PIPE)
  (gdbout, gdberr) = gdbproc.communicate()
  return gdbout

def has_x11 ():
  return os.environ.has_key ("DISPLAY")

def has_tty ():
  return os.isatty(2)

def is_hacker ():
  return os.environ.has_key ('DEBREAPER_HACKER') or \
  	 os.environ.has_key ('GNOME_HACKER') or \
  	 os.environ.has_key ('DEBREAPER_DEBUGGER')

def has_de ():
  if not os.environ.has_key ('DISPLAY'):
    return False
  if os.environ.has_key ('GNOME_DESKTOP_SESSION_ID') or \
     os.environ.has_key ('KDE_FULL_SESSION'):
    return True
  xprop = Popen ([ "xprop", "-root", "_DT_SAVE_MODE" ],
  		 stdin=PIPE, stdout=PIPE)
  (xpout, xperr) = xprop.communicate ()
  return "xfce4" in xpout

def signal_text (signum):
  import signal
  signals = { signal.SIGSEGV: "Invalid memory reference",
	      signal.SIGABRT: "Program committed suicide",
	      signal.SIGTRAP: "Breakpoint trap",
	      signal.SIGFPE:  "Floating point exception",
	      signal.SIGBUS:  "Bad memory access" }
  try:
    return signals[signum]
  except KeyError:
    return "Abnormal termination"

def configured_client ():
  if os.environ.has_key ('DEBREAPER_MAILER'):
    return os.environ['DEBREAPER_MAILER'].split()
  if has_de ():
    return ["xdg-email"]
  res = None
  for (client, config) in [("mutt", ".muttrc"),
  			   ("muttng", ".muttngrc"),
  			   ("madmutt", ".madmuttrc")]:
    if os.path.exists ("/usr/bin/"+client):
      if os.path.exists (os.getenv("HOME")+"/"+config):
        res = client
        break
      if not res:
        res = client
  if res:
    if has_tty ():
      return [res]
    if has_x11 ():
      return ["x-terminal-emulator", "-e", client]
  return None

def launch_email_client (package, signum, report):
  import urllib
  from bug_iface import bug_version
  subject = urllib.quote ("%s: %s"%(package,signal_text(signum)))
  body = urllib.quote (report)
  version = urllib.quote ("%s (debreaper %s)"%(bug_version, debreaper_version))
  uri = 'mailto:submit@bugs.debian.org?subject=%s&body=%s&X-Reportbug-Version=%s'%(subject,body,version)
  client = configured_client ()
  if client:
    client.append (uri)
    if has_tty ():
      call (client)
    else:
      Popen (client)
    return True
  return False

def attach_debugger (binary, pid):
  if has_tty ():
    debugger = ['gdb']
  elif has_x11 ():
    debugger = ["x-terminal-emulator", "-e", 'gdb']
  else:
    return False
  if os.environ.has_key ('DEBREAPER_DEBUGGER'):
    debugger = os.environ['DEBREAPER_DEBUGGER'].split()
  debugger.append (binary)
  debugger.append (`pid`)
  call (debugger)
  return True
