# Debreaper
# copyright (c) 2007 Josselin Mouette
# Licensed under the GPL (v2 only)

import gobject,gtk,pango,os,sys,threading
from gettext import gettext as _

_icon_name="/usr/share/pixmaps/debreaper.png"

class ReaperUI:
  def finalize (self, foo=None, bar=None):
    self.dialog.destroy ()
    os._exit (0)
  def __init__ (self, name, pid, subtitle):
    self.name = name
    self.pid = pid
    gobject.threads_init()
    self.dialog = gtk.Dialog (title=name+" - "+_("Debian application reaper"),
			      buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_OK))
    self.dialog.action_area.foreach (lambda x: x.connect ("clicked", self.finalize))
    self.dialog.connect ("delete-event", self.finalize)
    self.dialog.set_icon_from_file (_icon_name)
    self.dialog.vbox.set_spacing (5)
    hbox = gtk.HBox ()
    hbox.show ()
    self.dialog.vbox.pack_start (hbox, expand=False)
    image = gtk.Image ()
    image.set_from_file (_icon_name)
    image.show ()
    hbox.pack_start (image, expand=False)
    vbox = gtk.VBox ()
    vbox.show ()
    hbox.pack_start (vbox, expand=False)
    label = gtk.Label ()
    label.set_markup ("<span size='large' weight='bold'>"+_("Application %s crashed")%name+"</span>")
    label.set_alignment (0.1, 0.5)
    label.show ()
    vbox.add (label)
    self.sublabel = gtk.Label ()
    self.sublabel.set_markup ("<i>"+subtitle+"</i>")
    self.sublabel.set_alignment (0, 0.5)
    self.sublabel.set_line_wrap (True)
    self.sublabel.show ()
    vbox.add (self.sublabel)
    self.progressbar = gtk.ProgressBar ()
    self.do_pulse = True
    self.progressbar.set_pulse_step (0.05)
    self.progressbar.show ()
    self.dialog.vbox.add (self.progressbar)
    gobject.timeout_add(50, self.pulse)
    self.dialog.show ()
    threading.Thread (target = gtk.main).start()
  def pulse (self):
    if self.do_pulse:
      self.progressbar.pulse ()
    return self.pulse
  def info_text(self, text):
    self.progressbar.set_text (text)
    self.progressbar.pulse ()
  def summary_dialog (self, intro, fulltrace):
    self.do_pulse = False
    self.dialog.vbox.remove (self.progressbar)
    self.sublabel.set_markup (intro)
    buffer = gtk.TextBuffer ()
    buffer.set_text (fulltrace)
    textview = gtk.TextView (buffer)
    textview.modify_font (pango.FontDescription ("monospace"))
    scroll = gtk.ScrolledWindow ()
    scroll.set_shadow_type (gtk.SHADOW_IN)
    scroll.set_policy (gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
    scroll.add (textview)
    textview.show ()
    self.dialog.vbox.add (scroll)
    scroll.show ()
    self.dialog.action_area.foreach (self.dialog.action_area.remove)
    save_button = gtk.Button (stock=gtk.STOCK_SAVE_AS)
    save_button.connect("clicked", save_buffer, fulltrace, self.name+"."+`self.pid`+".RIP")
    self.dialog.action_area.add (save_button)
    save_button.show ()
    close_button = gtk.Button (stock=gtk.STOCK_CLOSE)
    close_button.connect("clicked", self.finalize)
    self.dialog.action_area.add (close_button)
    close_button.show ()
    (width, height) = self.dialog.get_size ()
    self.dialog.resize (width, max(height,600))

def save_buffer (button, buffer, filename):
  dialog = gtk.FileChooserDialog (_("Save as"),
			    	  action=gtk.FILE_CHOOSER_ACTION_SAVE,
				  buttons = (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
					     gtk.STOCK_SAVE, gtk.RESPONSE_OK))
  dialog.set_default_response (gtk.RESPONSE_OK)
  dialog.set_current_name (filename)
  dialog.set_do_overwrite_confirmation (True)
  response = dialog.run ()
  if response == gtk.RESPONSE_OK:
    filename = dialog.get_filename ()
    file(filename,"w").write(buffer)
  dialog.destroy ()
