' Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com 

Imports System
Imports System.IO
Imports System.IO.IsolatedStorage
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Ext

Namespace Db4objects.Db4odoc.IsolatedStorage

    Public Class Db4oIsolatedStorageFile
        Private _stream As IsolatedStorageFileStream

        <System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError:=True)> _
        Private Shared Function FlushFileBuffers(ByVal fileHandle As IntPtr) As Integer
        End Function

        Public Sub New(ByVal file As String, ByVal fMode As String)
            Try
                Dim isf As IsolatedStorageFile = IsolatedStorageFile.GetUserStoreForAssembly()
                _stream = New IsolatedStorageFileStream(file, FileMode.OpenOrCreate, IIf(fMode.Equals("rw"), FileAccess.ReadWrite, FileAccess.Read), isf)
            Catch x As IOException
                Throw New DatabaseFileLockedException(file, x)
            End Try
        End Sub
        ' end Db4oIsolatedStorageFile

        Public ReadOnly Property Stream() As FileStream
            Get
                Return _stream
            End Get
        End Property
        ' end Stream

        Public Sub Close()
            _stream.Close()
        End Sub
        ' end Close

        Public Function Length() As Long
            Return _stream.Length
        End Function
        ' end Length

        Public Function Read(ByVal bytes As Byte(), ByVal offset As Integer, ByVal length As Integer) As Integer
            Return _stream.Read(bytes, offset, length)
        End Function
        ' end Read

        Public Sub Read(ByVal bytes As Byte())
            _stream.Read(bytes, 0, bytes.Length)
        End Sub
        ' end Read

        Public Sub Seek(ByVal pos As Long)
            _stream.Seek(pos, SeekOrigin.Begin)
        End Sub
        ' end Seek

        Public Sub Sync()
            _stream.Flush()

            FlushFileBuffers(_stream.SafeFileHandle.DangerousGetHandle())

        End Sub
        ' end Sync

        Public Function GetFD() As Db4oIsolatedStorageFile
            Return Me
        End Function
        ' end GetFD

        Public Sub Write(ByVal bytes As Byte())
            Me.Write(bytes, 0, bytes.Length)
        End Sub
        ' end Write

        Public Sub Write(ByVal bytes As Byte(), ByVal offset As Integer, ByVal length As Integer)
            _stream.Write(bytes, offset, length)
        End Sub
        ' end Write
    End Class
End Namespace