<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:output method="html"/>
  <xsl:param name="DashboardPath"/>
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:param name="PreviousDashboardStamp" select="string('')"/>
  <xsl:param name="CreationDate" select="string('')"/>
  <xsl:variable name="DashboardDir" select="concat('../', $DashboardStamp)"/>
  <xsl:variable name="IconDir" select="string('../../Icons')"/>

  <xsl:include href="DashboardConfig.xsl"/>
  <xsl:param name="BuildTestOverview" />
  <xsl:param name="BuildBuildOverview" />

  <!-- Index the file so that we can access all the builds that ran a
       particular test quickly -->
  <xsl:key name="TestNames" match="Test" use="FullName"/>
  <xsl:variable name="TestNames" select="/Dashboard/BuildStamp/Testing/Tests/Test[count(.|key('TestNames', FullName)[1]) = 1]"/>
  <xsl:variable name="NumberOfTests" select="count($TestNames)"/>
  <xsl:key name="Files" match="BuildStamp/Build/Files/File" use="Name"/>
  <xsl:key name="FilesName" match="BuildStamp/Build/Files/File/Name" use="."/>
 
  <!-- Index the file so that we can access test/sitename combinations
       quickly -->
  <xsl:key name="TestCrossReference" match="Test" 
           use="concat(../../SiteName,'::',../../BuildName,'::',../../BuildStamp,'::',FullName)"/>

  <xsl:template match="/Dashboard">
    <xsl:if test="$BuildBuildOverview='ON'">
      <xsl:call-template name="BuildOverview"/>
    </xsl:if>
    <xsl:if test="$BuildTestOverview='ON'">
        <xsl:call-template name="TestOverview"/>
    </xsl:if>
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Dashboard - <xsl:value-of select="$CreationDate"/></xsl:with-param>
      <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      <xsl:with-param name="UseCalendar">1</xsl:with-param>
    </xsl:call-template>
    <xsl:choose>
      <xsl:when test="count(BuildStamp/Site/DashboardNotes)">
	<xsl:call-template name="Notes"/>
      </xsl:when>
    </xsl:choose>
    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa"><tr class="table-heading"><td>
    <h3>
      <xsl:choose>
        <xsl:when test="Update/ChangedFileCount != ''">
          <a href="Update.html">
            <xsl:value-of select="Update/ChangedFileCount"/> Files Changed
          </a>
          by <xsl:value-of select="Update/AuthorCount"/> Authors
          as of <xsl:value-of select="Update/StartDateTime"/>
        </xsl:when>
        <xsl:otherwise>
          No Update information available!
        </xsl:otherwise>
      </xsl:choose>
    </h3>
    </td></tr></table>
    <br/>

    <xsl:if test="$BuildDoxygen='ON'">
    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa"><tr class="table-heading"><td>
    <h3>
      <xsl:choose>
        <xsl:when test="string-length(Doxygen/StartDateTime) != 0">
          <a href="Doxygen.html">
            Doxygen:
          </a>
          <xsl:value-of select="Doxygen/ErrorCount"/> Errors
          and <xsl:value-of select="Doxygen/WarningCount"/> Warnings
        </xsl:when>
        <xsl:otherwise>
          No Doxygen information available!
        </xsl:otherwise>
      </xsl:choose>
    </h3>
    </td></tr></table>
    <br/>
    </xsl:if>
     
    <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
    <xsl:choose>
      <xsl:when test="count(BuildStamp[contains(@value,'Nightly')])">
        <tr class="table-heading"><td colspan="14" valign="middle"><h3>Nightly Builds</h3></td></tr>
        <xsl:call-template name="BuildTableHeader"/>
        <xsl:for-each select="BuildStamp">
          <xsl:sort select="BuildName"/>
          <xsl:sort select="SiteName"/>
          <xsl:choose>
            <xsl:when test="count(MissingBuild)">
                <xsl:call-template name="MissingBuild"/>
            </xsl:when>
            <xsl:when test="contains(@value,'Nightly')">
                <xsl:call-template name="BuildStamp"/>
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr class="table-heading"><td colspan="14"><h3>No Nightly Builds</h3></td></tr>
      </xsl:otherwise>        
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="count(BuildStamp[contains(@value,'Continuous')])">
        <tr class="table-heading"><td colspan="14" valign="middle"><h3>Continuous Builds</h3></td></tr>
          <xsl:call-template name="BuildTableHeader"/>
          <xsl:for-each select="BuildStamp">
            <xsl:sort select="@value" order="descending"/>
            <xsl:sort select="BuildName"/>
            <xsl:sort select="SiteName"/>
            <xsl:if test="contains(@value,'Continuous')">
              <xsl:call-template name="BuildStamp"/>
            </xsl:if>
          </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr class="table-heading"><td colspan="14"><h3>No Continuous Builds</h3></td></tr>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="count(BuildStamp[contains(@value,'Experimental')])">
        <tr class="table-heading"><td colspan="14" valign="middle"><h3>Experimental Builds</h3></td></tr>
          <xsl:call-template name="BuildTableHeader"/>
          <xsl:for-each select="BuildStamp">
            <xsl:sort select="@value" order="descending"/>
            <xsl:sort select="BuildName"/>
            <xsl:sort select="SiteName"/>
            <xsl:if test="contains(@value,'Experimental')">
              <xsl:call-template name="BuildStamp"/>
            </xsl:if>
          </xsl:for-each>
      
      </xsl:when>
      <xsl:otherwise>
        <tr class="table-heading"><td colspan="14"><h3>No Experimental Builds</h3></td></tr>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:variable name="BuildCount" select="count(BuildStamp/Build)"/>
    <xsl:if test="$BuildCount">
      <tr>
        <td align="left" bgcolor="#ffffff">
          Totals
        </td>
        <td align="center" bgcolor="#ffffff">
          <b><xsl:value-of select="$BuildCount"/> Builds</b>
        </td>
        <td bgcolor="#ffffff"><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></td>
        <xsl:variable name="ConfigurationStatus" select="sum(/Dashboard/BuildStamp/Configure/ConfigureStatus)"/>
        <td align="right">
          <xsl:choose>
            <xsl:when test="$ConfigurationStatus &gt; 0">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="$ConfigurationStatus"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;
</xsl:text>
        </td>
        <xsl:variable name="ErrorCount" select="sum(/Dashboard/BuildStamp/Build/ErrorCount)"/>
        <td align="right">
          <xsl:choose>
            <xsl:when test="$ErrorCount &gt; 0">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="$ErrorCount"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <xsl:variable name="WarningCount" select="sum(/Dashboard/BuildStamp/Build/WarningCount)" />
        <td align="right">
          <xsl:choose>
            <xsl:when test="$WarningCount &gt; 0">
              <xsl:attribute name="class">warning</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="$WarningCount"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td bgcolor="#ffffff"><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></td>
        <xsl:variable name="NotRunCount" select="sum(/Dashboard/BuildStamp/Testing/NotRunCount)"/>
        <td align="right">
          <xsl:choose>
            <xsl:when test="$NotRunCount &gt; 0">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="$NotRunCount"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <xsl:variable name="FailedCount" select="sum(/Dashboard/BuildStamp/Testing/FailedCount)" />
        <td align="right">
          <xsl:choose>
            <xsl:when test="$FailedCount &gt; 0">
              <xsl:attribute name="class">warning</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="$FailedCount"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td align="right">
          <xsl:choose>
            <xsl:when test="$FailedCount + $NotRunCount &gt; 0">
              <xsl:attribute name="class">warning</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">normal</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <b><xsl:value-of select="sum(/Dashboard/BuildStamp/Testing/PassedCount)"/></b>
          <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
        </td>
        <td bgcolor="#ffffff"/><td bgcolor="#ffffff"/><td bgcolor="#ffffff"/>
        <td bgcolor="#ffffff"><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></td>
      </tr>
    </xsl:if>

        </table>
        <br/>    
        <xsl:choose>
          <xsl:when test="count(BuildStamp/Coverage)">
            <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
              <tr class="table-heading"><td colspan="8">
	        <h3>Coverage</h3>
	      </td></tr>
              <tr class="table-heading">
                <th align="center" >Site</th>
                <th align="center" >Build Name</th>
                <th align="center" width="80">Percentage</th>
                <th align="center" >Passed</th>
                <th align="center" >Failed</th>
                <th align="center" >Date</th>
                <th align="center" >Submission Date</th>
              </tr>
                    <!--
                         Loop over each instance
                         -->
                    <xsl:for-each select="BuildStamp">
                      <xsl:sort select="Build/BuildName"/>
                      <xsl:sort select="Build/SiteName"/>
                      <xsl:if test="Coverage/LOC != ''">
                        <xsl:variable name="URLBase">../../Sites/<xsl:value-of select="Coverage/SiteName"/>/<xsl:value-of select="Coverage/BuildName"/>/<xsl:value-of select="Coverage/BuildStamp"/></xsl:variable>
                        <tr>
                          <td align="left" bgcolor="#ffffff">
                           <xsl:call-template name="SoftHyphenStringAtDot">
                 	     <xsl:with-param name="src">
		                <xsl:value-of select="Coverage/SiteName"/>
		             </xsl:with-param>
	                   </xsl:call-template>
                          </td>
                          <td align="left" bgcolor="#ffffff"><xsl:value-of select="Coverage/BuildName"/></td>
                          <td align="center">
                            <xsl:choose>
                              <xsl:when test="Coverage/PercentCoverage &lt; 70">
                                <xsl:attribute name="class">warning</xsl:attribute>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:attribute name="class">normal</xsl:attribute>
                              </xsl:otherwise>
                            </xsl:choose>
                            <a>
                              <xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/CoverageByName.html</xsl:attribute><b><xsl:value-of select="Coverage/PercentCoverage"/>%</b>
                            </a>
                          </td>
                          <td align="right" bgcolor="#ffffff">
                            <b><xsl:value-of select="Coverage/Passed"/></b>
                          </td>
                          <td align="right" bgcolor="#ffffff">
                            <b><xsl:value-of select="Coverage/Failed"/></b>
                          </td>
                          <td align="left" bgcolor="#ffffff"><xsl:value-of select="Coverage/StartDateTime"/></td>
                          <td align="left" bgcolor="#ffffff"><xsl:value-of select="CoverageSubmissionDateTime"/></td>
                        </tr>
                      </xsl:if>
                    </xsl:for-each>
                  </table>
	          <br/>
                </xsl:when>
                <xsl:otherwise>
         	  <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
	            <tr class="table-heading"><td>
                      <h3>No coverage information</h3>
	            </td></tr>
                  </table>
		  <br/>
                </xsl:otherwise>
              </xsl:choose>


        <xsl:choose>
          <xsl:when test="count(BuildStamp/DynamicAnalysis)">
            <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
              <tr class="table-heading"><td colspan="6">
                <h3>Dynamic Analysis</h3>
              </td></tr>
              <tr class="table-heading">
                <th align="center" >Site</th>
                <th align="center" >Build Name</th>
                <th align="center" >Checker</th>
                <th align="center" >Defect Count</th>
                <th align="center" >Date</th>
                <th align="center" >Submission Date</th>
              </tr>
              <!--
                   Loop over each instance
                   -->
              <xsl:for-each select="BuildStamp">
                <xsl:sort select="DynamicAnalysis/BuildName"/>
                <xsl:sort select="DynamicAnalysis/SiteName"/>
                <xsl:variable name="URLBase">../../Sites/<xsl:value-of select="DynamicAnalysis/SiteName"/>/<xsl:value-of select="DynamicAnalysis/BuildName"/>/<xsl:value-of select="DynamicAnalysis/BuildStamp"/></xsl:variable>
                <xsl:if test="DynamicAnalysis/SiteName != ''">
                  <tr>
                    <td align="left" bgcolor="#ffffff">
                      <xsl:call-template name="SoftHyphenStringAtDot">
                         <xsl:with-param name="src">
                           <xsl:value-of select="DynamicAnalysis/SiteName"/>
                         </xsl:with-param>
                      </xsl:call-template>
                    </td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="DynamicAnalysis/BuildName"/></td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="DynamicAnalysis/Checker"/></td>
                    <td align="center">
                      <xsl:choose>
                        <xsl:when test="DynamicAnalysis/DefectCount != 0">
                          <xsl:attribute name="class">warning</xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:attribute name="class">normal</xsl:attribute>
                        </xsl:otherwise>
                      </xsl:choose>
                      <a>
                        <xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/DynamicAnalysis.html</xsl:attribute><b><xsl:value-of select="DynamicAnalysis/DefectCount"/></b>
                      </a>
                    </td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="DynamicAnalysis/StartDateTime"/></td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="DynamicAnalysisSubmissionDateTime"/></td>
                  </tr>
                </xsl:if>
              </xsl:for-each>
            </table>
            <br/>
          </xsl:when>
          <xsl:otherwise>
            <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
              <tr class="table-heading"><td>
                <h3>No DynamicAnalysis information</h3>
              </td></tr>
            </table>
            <br/>
          </xsl:otherwise>
        </xsl:choose>



<!-- The Purify.xml processing has been deprecated. But still do it for old clients -->
        <xsl:choose>
          <xsl:when test="count(BuildStamp/Purify)">
            <table border="0" width="100%" cellpadding="3" cellspacing="1" bgcolor="#0000aa">
              <tr class="table-heading"><td colspan="6">
                <h3>Purify</h3>
              </td></tr>
              <tr class="table-heading">
                <th align="center" >Site</th>
                <th align="center" >Build Name</th>
                <th align="center" >Defect Count</th>
                <th align="center" >Date</th>
                <th align="center" >Submission Date</th>
              </tr>
              <!--
                   Loop over each instance
                   -->
              <xsl:for-each select="BuildStamp">
                <xsl:sort select="Purify/BuildName"/>
                <xsl:sort select="Purify/SiteName"/>
                <xsl:variable name="URLBase">../../Sites/<xsl:value-of select="Purify/SiteName"/>/<xsl:value-of select="Purify/BuildName"/>/<xsl:value-of select="Purify/BuildStamp"/></xsl:variable>
                <xsl:if test="Purify/SiteName != ''">
                  <tr>
                    <td align="left" bgcolor="#ffffff">
                      <xsl:call-template name="SoftHyphenStringAtDot">
                         <xsl:with-param name="src">
                           <xsl:value-of select="Purify/SiteName"/>
                         </xsl:with-param>
                      </xsl:call-template>
                    </td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="Purify/BuildName"/></td>
                    <td align="center">
                      <xsl:choose>
                        <xsl:when test="Purify/DefectCount != 0">
                          <xsl:attribute name="class">warning</xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:attribute name="class">normal</xsl:attribute>
                        </xsl:otherwise>
                      </xsl:choose>
                      <a>
                        <xsl:attribute name="HREF"><xsl:value-of select="$URLBase"/>/Purify.html</xsl:attribute><b><xsl:value-of select="Purify/DefectCount"/></b>
                      </a>
                    </td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="Purify/StartDateTime"/></td>
                    <td align="left" bgcolor="#ffffff"><xsl:value-of select="PurifySubmissionDateTime"/></td>
                  </tr>
                </xsl:if>
              </xsl:for-each>
            </table>
            <br/>
          </xsl:when>
        </xsl:choose>


              <xsl:call-template name="DashboardFooter"/>
  </xsl:template>


  <xsl:template name="BuildStamp">
    <xsl:variable name="BuildURLBase">../../Sites/<xsl:value-of select="Build/SiteName"/>/<xsl:value-of select="Build/BuildName"/>/<xsl:value-of select="Build/BuildStamp"/></xsl:variable>
    <xsl:variable name="ConfigureURLBase">../../Sites/<xsl:value-of select="Configure/SiteName"/>/<xsl:value-of select="Configure/BuildName"/>/<xsl:value-of select="Configure/BuildStamp"/></xsl:variable>
    <xsl:variable name="TestingURLBase">../../Sites/<xsl:value-of select="Testing/SiteName"/>/<xsl:value-of select="Testing/BuildName"/>/<xsl:value-of select="Testing/BuildStamp"/></xsl:variable>
    <xsl:variable name="UpdateURLBase">../../Sites/<xsl:value-of select="Update/SiteName"/>/<xsl:value-of select="Update/BuildName"/>/<xsl:value-of select="Update/BuildStamp"/></xsl:variable>

    <tr valign="top">
      <td align="left" bgcolor="#ffffff">
        <xsl:if test="contains(., 'Nightly') and @expected='no'">
           <img alt="Unexpected nightly build submission" align="ABSMIDDLE"><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/New.gif</xsl:attribute></img><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
        </xsl:if>
        <xsl:call-template name="SoftHyphenStringAtDot">
          <xsl:with-param name="src">
            <xsl:value-of select="SiteName"/>
          </xsl:with-param>
        </xsl:call-template>
     </td>
      <td align="left" bgcolor="#ffffff">
        <xsl:call-template name="SoftHyphenStringAtUnderscore">
          <xsl:with-param name="src">
            <xsl:call-template name="SoftHyphenStringAtDot">
              <xsl:with-param name="src">
                <xsl:value-of select="BuildName"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
	<xsl:choose>
	  <xsl:when test="count(Notes)">
             <xsl:text disable-output-escaping="yes"> &amp;nbsp;&amp;nbsp;</xsl:text>
	     <a><xsl:attribute name="HREF"><xsl:value-of select="$BuildURLBase"/>/Notes.html</xsl:attribute><img><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Document.gif</xsl:attribute><xsl:attribute name="ALT">Notes</xsl:attribute><xsl:attribute name="border">0</xsl:attribute></img></a>
	  </xsl:when>
	</xsl:choose>
        <xsl:choose>
          <xsl:when test="Testing/Generator != ''">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <a><xsl:attribute name="HREF">javascript:alert("Generator: <xsl:value-of select="Testing/Generator" />");</xsl:attribute>
              <img>
                <xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Generator.png</xsl:attribute>
                <xsl:attribute name="ALT"><xsl:value-of select="Testing/Generator" /></xsl:attribute>
                <xsl:attribute name="border">0</xsl:attribute>
              </img>
            </a>
          </xsl:when>
           <xsl:when test="Build/Generator != ''">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <a><xsl:attribute name="HREF">javascript:alert("Generator: <xsl:value-of select="Build/Generator" />");</xsl:attribute>
              <img>
                <xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Generator.png</xsl:attribute>
                <xsl:attribute name="ALT"><xsl:value-of select="Build/Generator" /></xsl:attribute>
                <xsl:attribute name="border">0</xsl:attribute>
              </img>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <!-- Nothing -->
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <xsl:choose>
        <xsl:when test="count(Update)=0">
          <td align="right" class="na">
             <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>          
        </xsl:when>
        <xsl:when test="not(Update/UpdateReturnStatus='')">
          <td align="right" class="nr">
             <b><a><xsl:attribute name="HREF"><xsl:value-of select="$UpdateURLBase"/>/Update.html</xsl:attribute><xsl:value-of select="Update/ChangedFileCount"/></a></b>
             <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td align="right" bgcolor="#ffffff">
             <b><a><xsl:attribute name="HREF"><xsl:value-of select="$UpdateURLBase"/>/Update.html</xsl:attribute><xsl:value-of select="Update/ChangedFileCount"/></a></b>
             <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="count(Configure/ConfigureStatus)=0">
          <td align="right" class="na">
             <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
        </xsl:when>
        <xsl:when test="Configure/ConfigureStatus = 0">
          <td align="right" class="normal">
             <b><a><xsl:attribute name="HREF"><xsl:value-of select="$ConfigureURLBase"/>/Configure.html</xsl:attribute><xsl:value-of select="Configure/ConfigureStatus"/></a></b>
             <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td align="right" class="error">
             <b><a><xsl:attribute name="HREF"><xsl:value-of select="$ConfigureURLBase"/>/Configure.html</xsl:attribute><xsl:value-of select="Configure/ConfigureStatus"/></a></b>
             <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
        </xsl:otherwise>
      </xsl:choose>
      <td align="right">
        <xsl:choose>
          <xsl:when test="Build/ErrorCount > 0">
            <xsl:attribute name="class">error</xsl:attribute>
          </xsl:when>
          <xsl:when test="count(Build/ErrorCount)">
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$BuildURLBase"/>/BuildError.html</xsl:attribute><xsl:value-of select="Build/ErrorCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="Build/WarningCount > 0">
            <xsl:attribute name="class">warning</xsl:attribute>
          </xsl:when>
          <xsl:when test="count(Build/WarningCount)">
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$BuildURLBase"/>/BuildWarning.html</xsl:attribute><xsl:value-of select="Build/WarningCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>

      <td align="right">
        <xsl:choose>
          <xsl:when test="count(Testing/ElapsedMinutes)">
            <xsl:attribute name="bgcolor">#FFFFFF</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="Build/ElapsedMinutes"/>
      </td>

      <td align="right">
        <xsl:choose>
          <xsl:when test="Testing/NotRunCount > 0">
            <xsl:attribute name="class">error</xsl:attribute>
          </xsl:when>
          <xsl:when test="count(Testing/NotRunCount)">
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$TestingURLBase"/>/Test.html</xsl:attribute><xsl:value-of select="Testing/NotRunCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="Testing/FailedCount > 0">
            <xsl:attribute name="class">warning</xsl:attribute>
          </xsl:when>
          <xsl:when test="count(Testing/FailedCount)">
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$TestingURLBase"/>/Test.html</xsl:attribute><xsl:value-of select="Testing/FailedCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="(Testing/NotRunCount + Testing/FailedCount) > 0">
            <xsl:attribute name="class">warning</xsl:attribute>
          </xsl:when>
          <xsl:when test="count(Testing/NotRunCount) + count(Testing/FailedCount)">
            <xsl:attribute name="class">normal</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <b><a><xsl:attribute name="HREF"><xsl:value-of select="$TestingURLBase"/>/Test.html</xsl:attribute><xsl:value-of select="Testing/PassedCount"/></a></b>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:attribute name="class">na</xsl:attribute>
	<xsl:choose>
	  <xsl:when test="(Testing/NotRunCount + Testing/FailedCount + Testing/PassedCount) > 0">
            <b><a><xsl:attribute name="HREF"><xsl:value-of select="$TestingURLBase"/>/Test.html</xsl:attribute><xsl:value-of select="$NumberOfTests - Testing/PassedCount - Testing/FailedCount - Testing/NotRunCount"/></a></b>
          </xsl:when>
          <xsl:otherwise>
	    <b><xsl:value-of select="$NumberOfTests"/></b>
	  </xsl:otherwise>
	</xsl:choose>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right">
        <xsl:choose>
          <xsl:when test="count(Testing/ElapsedMinutes)">
            <xsl:attribute name="bgcolor">#FFFFFF</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">na</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="Testing/ElapsedMinutes"/>
      </td>
      <td bgcolor="#ffffff">
        <xsl:choose>
          <xsl:when test="count(Build/StartDateTime)">
            <xsl:value-of select="Build/StartDateTime"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="Testing/StartDateTime"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td bgcolor="#ffffff">
        <xsl:choose>
          <xsl:when test="count(TestSubmissionDateTime)">
	    <xsl:value-of select="TestSubmissionDateTime"/>
          </xsl:when>
          <xsl:otherwise>
	    <xsl:value-of select="BuildSubmissionDateTime"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    
  </xsl:template>

  <xsl:template name="MissingBuild">
    <tr>
      <td align="left" bgcolor="#ffffff">
        <xsl:call-template name="SoftHyphenStringAtDot">
             <xsl:with-param name="src">
                 <xsl:value-of select="MissingBuild/SiteName"/>
	     </xsl:with-param>
	</xsl:call-template>
      </td>
      <td align="left" bgcolor="#ffffff">
        <xsl:call-template name="SoftHyphenStringAtUnderscore">
             <xsl:with-param name="src">
                <xsl:call-template name="SoftHyphenStringAtDot">
	           <xsl:with-param name="src">
		      <xsl:value-of select="MissingBuild/BuildName"/>
       	           </xsl:with-param>
                </xsl:call-template>
              </xsl:with-param>
	 </xsl:call-template>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="right" bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td bgcolor="#ffffff">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
      </td>
      <td align="center">
        <xsl:attribute name="class">warning</xsl:attribute>
        <b>No submission</b>
      </td>
    </tr>

  </xsl:template>
  
  <xsl:template name="BuildTableHeader">
    <tr class="table-heading">
      <th align="center" rowspan="2">Site</th>
      <th align="center" rowspan="2">Build Name</th>
      <th align="center" rowspan="2">Update</th>
      <th align="center" rowspan="2">Cfg</th>
      <th align="center" colspan="3">Build</th>
      <th align="center" colspan="5">Test</th>
      <th align="center" rowspan="2">Build Date</th>
      <th align="center" rowspan="2">Submit Date</th>
    </tr>
    <tr class="table-heading">
      <th align="center">Error</th>
      <th align="center">Warn</th>
      <th align="center">Min</th> 
      <th align="center">NotRun</th>
      <th align="center">Fail</th>
      <th align="center">Pass</th>
      <th align="center">NA</th>
      <th align="center">Min</th> 
    </tr>
  </xsl:template>

  <xsl:template name="BuildOverview">
    <xsl:variable name="uri" select="concat ( 'file:///', $DashboardPath, '/BuildOverview.xml' )"/>
    <xsl:result-document href="{$uri}" >
      <BuildOverview>
        <xsl:for-each select="BuildStamp/Build/Files/File/Name[generate-id()=generate-id(key('FilesName',.)[1])]">
          <File>
            <Name><xsl:value-of select="."/></Name>
              <xsl:for-each select="key('Files',.)">
                <xsl:sort select="Name"/>
                <xsl:sort select="@Type"/>
                <xsl:sort select="SourceLineNumber" data-type="number"/>
                <Comment>
                  <Type><xsl:value-of select="@Type"/></Type>
                  <SiteName><xsl:value-of select="../../SiteName"/></SiteName>
                  <BuildName><xsl:value-of select="../../BuildName"/></BuildName>
                  <BuildStamp><xsl:value-of select="../../BuildStamp"/></BuildStamp>
                  <Text><xsl:value-of select="Text"/></Text>
                  <SourceLineNumber><xsl:value-of select="SourceLineNumber"/></SourceLineNumber>
                  <BuildLogLine><xsl:value-of select="BuildLogLine"/></BuildLogLine>
                </Comment>
              </xsl:for-each>
          </File>
        </xsl:for-each>
      </BuildOverview>
    </xsl:result-document>
  </xsl:template>

  <xsl:template name="TestOverviewOLD">
    <xsl:variable name="uri" select="concat ('file:///', $DashboardPath, '/TestOverview.xml' )"/>
    <xsl:result-document href="{$uri}" >
      <TestOverview>
        <xsl:variable name="BuildStamps" select="BuildStamp"/>
        <xsl:for-each select="$TestNames">
          <xsl:sort select="."/>
          <xsl:variable name="TestName" select="FullName"/>
            <Test>
              <Name><xsl:value-of select="$TestName"/></Name>
              <xsl:for-each select="$BuildStamps/Testing">
                <xsl:variable name="Test"
                              select="key('TestCrossReference', concat(SiteName, '::', BuildName, '::', BuildStamp, '::', $TestName))"/>
                <Result>
                   <xsl:copy-of select="SiteName"/>
                   <xsl:copy-of select="BuildName"/>
                   <xsl:copy-of select="BuildStamp"/>
                   <xsl:choose>
                      <xsl:when test="$Test">
                         <xsl:copy-of select="$Test/Status"/>
                         <xsl:copy-of select="$Test/CompletionStatus"/>
                         <xsl:copy-of select="$Test/ExitCode"/>
                         <xsl:copy-of select="$Test/ExecutionTime"/>
                      </xsl:when>
                      <xsl:otherwise><Status>na</Status></xsl:otherwise>
                   </xsl:choose>
                </Result>
              </xsl:for-each>
            </Test>
        </xsl:for-each>
      </TestOverview>
    </xsl:result-document>
  </xsl:template>

  <xsl:template name="TestOverviewNEW">
    <xsl:variable name="uri" select="concat ('file:///', $DashboardPath, '/TestOverview.xml' )"/>
    <xsl:result-document href="{$uri}" >
      <TestOverview>
        <xsl:for-each-group select="BuildStamp/Testing/Tests/Test/FullName" group-by=".">
          <xsl:variable name="TestName" select="current-group()[1]"/>
          <Test>
            <Name><xsl:value-of select="$TestName"/></Name>
            <xsl:for-each select="/Dashboard/BuildStamp">
              <xsl:variable name="Test"
                select="key('TestCrossReference', concat(SiteName, '::', BuildName, '::', @value, '::', $TestName))"/>
              <Result>
                <xsl:copy-of select="SiteName"/>
                <xsl:copy-of select="BuildName"/>
                <BuildStamp><xsl:value-of select="@value"/></BuildStamp>
                <xsl:choose>
                  <xsl:when test="$Test">
                    <xsl:copy-of select="$Test/Status"/>
                    <xsl:copy-of select="$Test/CompletionStatus"/>
                    <xsl:copy-of select="$Test/ExitCode"/>
                    <xsl:copy-of select="$Test/ExecutionTime"/>
                  </xsl:when>
                  <xsl:otherwise><Status>na</Status></xsl:otherwise>
                </xsl:choose>
              </Result>
            </xsl:for-each>
          </Test>
        </xsl:for-each-group>
      </TestOverview>
    </xsl:result-document>
  </xsl:template>

  <xsl:template name="TestOverview">
    <xsl:variable name="uri" select="concat ('file:///', $DashboardPath, '/TestOverview.xml' )"/>
    <xsl:result-document href="{$uri}" >
      <TestOverview>
        <xsl:for-each select="$TestNames">
          <xsl:sort select="FullName"/>
          <xsl:variable name="TestName" select="FullName"/>
          <Test>
            <Name><xsl:value-of select="$TestName"/></Name>
            <xsl:for-each select="/Dashboard/BuildStamp">
              <xsl:variable name="BuildStamp" select="@value"/>
              <xsl:variable name="Test"
                select="key('TestCrossReference', concat(SiteName, '::', BuildName, '::', $BuildStamp, '::', $TestName))"/>
              <Result>
                <xsl:copy-of select="SiteName"/>
                <xsl:copy-of select="BuildName"/>
                <BuildStamp><xsl:value-of select="$BuildStamp"/></BuildStamp>
                <xsl:choose>
                  <xsl:when test="count($Test)=1">
                    <xsl:copy-of select="$Test/Status"/>
                    <xsl:copy-of select="$Test/CompletionStatus"/>
                    <xsl:copy-of select="$Test/ExitCode"/>
                    <xsl:copy-of select="$Test/ExecutionTime"/>
                  </xsl:when>
                  <xsl:when test="count($Test)>1">
                    <Status>na</Status>
                    <Reason>Multiple tests with the same name.</Reason>
                  </xsl:when>
                  <xsl:otherwise><Status>na</Status></xsl:otherwise>
                </xsl:choose>
              </Result>
            </xsl:for-each>
          </Test>
        </xsl:for-each>
      </TestOverview>
    </xsl:result-document>
  </xsl:template>

<xsl:template name="Notes">
<xsl:for-each select="BuildStamp/Site/DashboardNotes/Note">
   <p>
   <img><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Alert.gif</xsl:attribute><xsl:attribute name="ALT">Notes</xsl:attribute><xsl:attribute name="border">0</xsl:attribute><xsl:attribute name="ALIGN">texttop</xsl:attribute></img><xsl:text disable-output-escaping="yes"> &amp;nbsp;&amp;nbsp;</xsl:text>
   <b><xsl:value-of select="DateTime"/></b>
   <xsl:if test="count(@Name)">
     <b> -- <xsl:value-of select="@Name"/></b>
   </xsl:if>
   <br/>
   <xsl:value-of select="Text"/>
   </p>	
</xsl:for-each>
</xsl:template>

  
</xsl:stylesheet>
