/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.ObjectValue;

public class ExternalObjectType
extends AtomicType {
    private Class javaClass;

    public ExternalObjectType(Class clazz) {
        this.javaClass = clazz;
    }

    public boolean isBuiltIn() {
        return true;
    }

    public boolean matchesItem(Item item) {
        if (item instanceof ObjectValue) {
            Object object = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(object.getClass());
        }
        return false;
    }

    public void validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver) throws ValidationException {
        throw new ValidationException("Cannot use an external object type for validation");
    }

    public ItemType getSuperType() {
        return Type.ANY_ATOMIC_TYPE;
    }

    public int getFingerprint() {
        return 285;
    }

    public String toString() {
        String string = this.javaClass.getName();
        string = string.replace('$', '-');
        return "java:" + string;
    }
}

