/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Loader;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public class SaxonScript
extends StyleElement {
    private Class javaClass = null;
    private String implementsURI = null;
    private String language = null;

    public void prepareAttributes() throws TransformerConfigurationException {
        Object transformerException;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int s = attributeCollection.getNameCode(n);
            transformerException = this.getNamePool().getClarkName(s);
            if (transformerException == "language") {
                string = attributeCollection.getValue(n).trim();
            } else if (transformerException == "implements-prefix") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (transformerException == "src") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (transformerException == "archive") {
                string4 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(s);
            }
            ++n;
        }
        if (string2 == null) {
            this.reportAbsence("implements-prefix");
            return;
        }
        try {
            short namespaceException = this.getURICodeForPrefix(string2);
            this.implementsURI = this.getNamePool().getURIFromURICode(namespaceException);
        }
        catch (NamespaceException string5) {
            this.compileError(string5.getMessage());
        }
        if (string == null) {
            this.reportAbsence("language");
            return;
        }
        this.language = string;
        if (this.language.equals("java")) {
            if (string3 == null) {
                this.compileError("For java, the src attribute is mandatory");
                return;
            }
            if (!string3.startsWith("java:")) {
                this.compileError("The src attribute must be a URI of the form java:full.class.Name");
                return;
            }
            String string5 = string3.substring(5);
            if (string4 == null) {
                try {
                    this.javaClass = Loader.getClass(string5);
                }
                catch (TransformerException transformerException2) {
                    this.compileError(transformerException2);
                    return;
                }
            }
            try {
                transformerException = new URL(this.getBaseURI());
            }
            catch (MalformedURLException stringTokenizer) {
                this.compileError("Invalid base URI " + this.getBaseURI());
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n2;
                stringTokenizer.nextToken();
            }
            URL[] uRLArray = new URL[n2];
            n2 = 0;
            stringTokenizer = new StringTokenizer(string4);
            while (stringTokenizer.hasMoreTokens()) {
                String classNotFoundException = stringTokenizer.nextToken();
                try {
                    uRLArray[n2++] = new URL((URL)transformerException, classNotFoundException);
                }
                catch (MalformedURLException noClassDefFoundError) {
                    this.compileError("Invalid URL " + classNotFoundException);
                    return;
                }
            }
            try {
                this.javaClass = new URLClassLoader(uRLArray).loadClass(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.compileError("Cannot find class " + string5 + " in the specified archive" + (n2 > 1 ? "s" : ""));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.compileError("Cannot use the archive attribute with this Java VM");
            }
        } else {
            this.compileError("The only language supported for Saxon extension functions is 'java'");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        return null;
    }

    public Class getJavaClass(String string) {
        if (this.language == null) {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                return null;
            }
        }
        if (this.language.equals("java") && this.implementsURI.equals(string)) {
            return this.javaClass;
        }
        return null;
    }
}

