/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.Validation;
import net.sf.saxon.type.GlobalValidationContext;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationContext;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;

public class CopyOf
extends ExprInstruction {
    private Expression select;
    private boolean copyNamespaces;
    private int validation;
    private SchemaType schemaType;
    private ValidationContext validationContext = GlobalValidationContext.getInstance();
    private boolean requireDocumentOrElement = false;

    public CopyOf(Expression expression, boolean bl, int n, SchemaType schemaType) {
        this.select = expression;
        this.copyNamespaces = bl;
        this.validation = n;
        this.schemaType = schemaType;
    }

    public String getInstructionName() {
        return "copy-of";
    }

    public void setRequireDocumentOrElement(boolean bl) {
        this.requireDocumentOrElement = bl;
    }

    public void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        int n = this.copyNamespaces ? 2 : 0;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        block15: while (true) {
            try {
                Item item;
                while ((item = sequenceIterator.next()) != null) {
                    if (item instanceof NodeInfo) {
                        NodeInfo nodeInfo = (NodeInfo)item;
                        int n2 = nodeInfo.getNodeKind();
                        if (this.requireDocumentOrElement && n2 != 1 && n2 != 9) {
                            throw new TransformerException("Operand of validate expression must be a document or element node");
                        }
                        switch (n2) {
                            case 1: {
                                Receiver receiver = controller.getConfiguration().getElementValidator(sequenceReceiver, nodeInfo.getNameCode(), this.schemaType, this.validation, this.validationContext, controller.getNamePool());
                                nodeInfo.copy(receiver, n, true);
                                continue block15;
                            }
                            case 2: {
                                try {
                                    CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, controller);
                                }
                                catch (NoOpenStartTagException noOpenStartTagException) {
                                    Instruction.recoverableError(this, "Cannot write an attribute node when no element start tag is open", controller);
                                }
                                continue block15;
                            }
                            case 3: {
                                sequenceReceiver.characters(nodeInfo.getStringValue(), 0);
                                continue block15;
                            }
                            case 7: {
                                sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValue(), 0);
                                continue block15;
                            }
                            case 8: {
                                sequenceReceiver.comment(nodeInfo.getStringValue(), 0);
                                continue block15;
                            }
                            case 13: {
                                try {
                                    nodeInfo.copy(sequenceReceiver, 0, false);
                                }
                                catch (NoOpenStartTagException noOpenStartTagException) {
                                    Instruction.recoverableError(this, "Cannot write a namespace node when no element start tag is open", controller);
                                }
                                continue block15;
                            }
                            case 9: {
                                Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), controller.getNamePool(), this.validation);
                                receiver.setConfiguration(controller.getConfiguration());
                                nodeInfo.copy(receiver, n, true);
                                continue block15;
                            }
                        }
                        throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
                    }
                    sequenceReceiver.append(item);
                }
            }
            catch (SkipInstructionException skipInstructionException) {
                Instruction.recoverableError(this, skipInstructionException.getMessage(), controller);
                continue;
            }
            break;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void copyAttribute(NodeInfo nodeInfo, SchemaType schemaType, int n, Controller controller) throws TransformerException {
        int n2 = nodeInfo.getNameCode();
        int n3 = -1;
        int n4 = 0;
        String string = nodeInfo.getStringValue();
        if (schemaType != null) {
            if (!(schemaType instanceof SimpleType)) throw new TransformerException("Cannot validate an attribute against a complex type");
            try {
                ((SimpleType)schemaType).validateContent(string, DummyNamespaceResolver.getInstance());
                if (((SimpleType)schemaType).isNamespaceSensitive()) {
                    n4 |= 0x200;
                }
                n3 = schemaType.getFingerprint();
            }
            catch (ValidationException validationException) {
                throw new ValidationException("Attribute being copied does not match the required type. " + validationException.getMessage());
            }
        } else if (n == 1 || n == 2) {
            long l = controller.getConfiguration().validateAttribute(n2, string, n);
            n3 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            n4 |= (int)(l >> 32);
        }
        controller.getReceiver().attribute(n2, n3, string, n4);
    }

    public Expression simplify() throws XPathException {
        return super.simplify();
    }

    public ItemType getItemType() {
        return this.select.getItemType();
    }

    public int getCardinality() {
        return this.select.getCardinality();
    }

    public int getDependencies() {
        return this.select.getDependencies();
    }

    public int getSpecialProperties() {
        return 0;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.select.promote(promotionOffer);
    }

    protected void getXPathExpressions(List list) {
        list.add(this.select);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.select = this.select.analyze(staticContext);
        return this;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "copyOf " + "validation=" + Validation.toString(this.validation));
        this.select.display(n + 1, namePool);
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.select};
        return expressionArray;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return super.evaluateItem(xPathContext);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return super.effectiveBooleanValue(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        sequenceOutputter.setConfiguration(controller.getConfiguration());
        controller.setReceiver(sequenceOutputter);
        try {
            this.process(xPathContext);
            controller.resetOutputDestination(sequenceReceiver);
            return sequenceOutputter.getSequence().iterate(xPathContext);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof ValidationException) {
                ((ValidationException)transformerException).setSourceLocator(this);
                ((ValidationException)transformerException).setSystemId(this.getSystemId());
            }
            if (transformerException.getLocator() == null) {
                transformerException.setLocator(this);
            }
            if (transformerException.getException() instanceof XPathException) {
                throw (XPathException)transformerException.getException();
            }
            throw new XPathException.Dynamic(transformerException);
        }
    }
}

