/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class MinimaxComparison
extends BinaryExpression {
    public MinimaxComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public int computeCardinality() {
        return 512;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        NumericValue[] numericValueArray;
        super.analyze(staticContext);
        if (this.operands[0] instanceof Value) {
            numericValueArray = MinimaxComparison.getRange(this.operands[0].iterate(null));
            if (numericValueArray == null) {
                return BooleanValue.FALSE;
            }
            this.operands[0] = this.operator == 12 || this.operator == 14 ? numericValueArray[0] : numericValueArray[1];
        }
        if (this.operands[1] instanceof Value) {
            numericValueArray = MinimaxComparison.getRange(this.operands[1].iterate(null));
            if (numericValueArray == null) {
                return BooleanValue.FALSE;
            }
            this.operands[1] = this.operator == 11 || this.operator == 13 ? numericValueArray[0] : numericValueArray[1];
        }
        return this;
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NumericValue[] numericValueArray = MinimaxComparison.getRange(this.operands[0].iterate(xPathContext));
        NumericValue[] numericValueArray2 = MinimaxComparison.getRange(this.operands[1].iterate(xPathContext));
        if (numericValueArray == null) {
            return false;
        }
        if (numericValueArray2 == null) {
            return false;
        }
        switch (this.operator) {
            case 12: {
                return numericValueArray[0].compareTo(numericValueArray2[1]) < 0;
            }
            case 14: {
                return numericValueArray[0].compareTo(numericValueArray2[1]) <= 0;
            }
            case 11: {
                return numericValueArray[1].compareTo(numericValueArray2[0]) > 0;
            }
            case 13: {
                return numericValueArray[1].compareTo(numericValueArray2[0]) >= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    private static NumericValue[] getRange(SequenceIterator sequenceIterator) throws XPathException {
        NumericValue numericValue;
        NumericValue[] numericValueArray = null;
        while ((numericValue = (NumericValue)sequenceIterator.next()) != null) {
            if (numericValue.isNaN()) continue;
            if (numericValueArray == null) {
                numericValueArray = new NumericValue[]{numericValue, numericValue};
                continue;
            }
            if (numericValue.compareTo(numericValueArray[0]) < 0) {
                numericValueArray[0] = numericValue;
            }
            if (numericValue.compareTo(numericValueArray[1]) <= 0) continue;
            numericValueArray[1] = numericValue;
        }
        return numericValueArray;
    }
}

