/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    Configuration config;

    public Sender(Configuration configuration) {
        this.config = configuration;
    }

    public void send(Source source, Receiver receiver) throws TransformerException {
        Object object;
        receiver.setConfiguration(this.config);
        receiver.setSystemId(source.getSystemId());
        boolean bl = this.config.isSchemaValidation();
        if (source instanceof AugmentedSource) {
            object = ((AugmentedSource)source).getSchemaValidation();
            if (object != null) {
                bl = (Boolean)object;
            }
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (source instanceof NodeInfo) {
            int n;
            if (bl) {
                this.config.getErrorListener().warning(new TransformerException("Validation request ignored for a NodeInfo source"));
            }
            if ((n = (object = (NodeInfo)source).getNodeKind()) != 9 && n != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            this.sendDocumentInfo((NodeInfo)object, receiver, this.config.getNamePool());
        } else if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, receiver, this.config.getNamePool(), bl);
        } else if (source instanceof DOMSource) {
            this.sendDOMSource((DOMSource)source, receiver, this.config.getNamePool(), bl);
        } else if (source instanceof StreamSource) {
            object = (StreamSource)source;
            String string = source.getSystemId();
            InputSource inputSource = new InputSource(string);
            inputSource.setCharacterStream(((StreamSource)object).getReader());
            inputSource.setByteStream(((StreamSource)object).getInputStream());
            SAXSource sAXSource = new SAXSource(this.config.getSourceParser(), inputSource);
            sAXSource.setSystemId(source.getSystemId());
            this.sendSAXSource(sAXSource, receiver, this.config.getNamePool(), bl);
        } else {
            throw new IllegalArgumentException("Unknown type of source " + source.getClass());
        }
    }

    private void sendDocumentInfo(NodeInfo nodeInfo, Receiver object, NamePool namePool) throws TransformerException {
        Object object2;
        if (nodeInfo.getNamePool() != namePool) {
            object2 = new NamePoolConverter(nodeInfo.getNamePool(), namePool);
            ((NamePoolConverter)object2).setUnderlyingReceiver((Receiver)object);
            object = object2;
        }
        object2 = new DocumentSender(nodeInfo);
        ((DocumentSender)object2).send((Receiver)object);
    }

    private void sendDOMSource(DOMSource dOMSource, Receiver receiver, NamePool namePool, boolean bl) throws TransformerException {
        Node node = dOMSource.getNode();
        if (node instanceof DocumentInfo) {
            this.sendDocumentInfo((DocumentInfo)((Object)node), receiver, namePool);
        } else {
            if (bl) {
                receiver = this.config.getDocumentValidator(receiver, dOMSource.getSystemId(), namePool, 1);
            }
            DOMSender dOMSender = new DOMSender();
            dOMSender.setStartNode(node);
            dOMSender.setReceiver(receiver);
            dOMSender.setNamePool(namePool);
            dOMSender.setSystemId(dOMSource.getSystemId());
            dOMSender.send();
        }
    }

    private void sendSAXSource(SAXSource sAXSource, Receiver receiver, NamePool namePool, boolean bl) throws TransformerException {
        Object object;
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            object = new SAXSource();
            ((SAXSource)object).setInputSource(sAXSource.getInputSource());
            ((SAXSource)object).setSystemId(sAXSource.getSystemId());
            xMLReader = this.config.getSourceParser();
            ((SAXSource)object).setXMLReader(xMLReader);
            sAXSource = object;
        }
        if (xMLReader.getErrorHandler() == null) {
            xMLReader.setErrorHandler(new StandardErrorHandler(this.config.getErrorListener()));
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerException("The SAX2 parser does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerException("The SAX2 parser does not support setting the 'namespaces' feature to true");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerException("The SAX2 parser does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerException("The SAX2 parser does not support setting the 'namespace-prefixes' feature to false");
        }
        if (bl) {
            receiver = this.config.getDocumentValidator(receiver, sAXSource.getSystemId(), namePool, 1);
        }
        object = new ReceivingContentHandler();
        ((ReceivingContentHandler)object).setReceiver(receiver);
        ((ReceivingContentHandler)object).setNamePool(namePool);
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof TransformerException) {
                throw (TransformerException)exception;
            }
            throw new TransformerException(sAXException);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }
}

