/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;
    private int m_blocksize;
    Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeSet() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeSet(int n) {
        this.m_blocksize = n;
        this.m_mapSize = 0;
    }

    public NodeSet(NodeSet nodeSet) {
        this(32);
        this.addNodes((NodeIterator)nodeSet);
    }

    public NodeSet(Node node) {
        this(32);
        this.addNode(node);
    }

    public NodeSet(NodeList nodeList) {
        this(32);
        this.addNodes(nodeList);
    }

    public NodeSet(NodeIterator nodeIterator) {
        this(32);
        this.addNodes(nodeIterator);
    }

    public void addElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[this.m_firstFree] = node;
        ++this.m_firstFree;
    }

    public void addNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.addElement(node);
    }

    public int addNodeInDocOrder(Node node, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        return this.addNodeInDocOrder(node, true, xPathContext);
    }

    public int addNodeInDocOrder(Node node, boolean bl, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        int n = -1;
        if (bl) {
            int n2 = this.size();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                Node node2 = this.elementAt(n3);
                if (node2 == node) {
                    n3 = -2;
                    break;
                }
                if (!DOM2Helper.isNodeAfter(node, node2)) break;
                --n3;
            }
            if (n3 != -2) {
                n = n3 + 1;
                this.insertElementAt(node, n);
            }
        } else {
            n = this.size();
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < n) {
                if (this.item(n4).equals(node)) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (!bl2) {
                this.addElement(node);
            }
        }
        return n;
    }

    public void addNodes(NodeSet nodeSet) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.addNodes((NodeIterator)nodeSet);
    }

    public void addNodes(NodeList nodeList) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node != null) {
                    this.addElement(node);
                }
                ++n2;
            }
        }
    }

    public void addNodes(NodeIterator nodeIterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (nodeIterator != null) {
            Node node;
            while ((node = nodeIterator.nextNode()) != null) {
                this.addElement(node);
            }
        }
    }

    private boolean addNodesInDocOrder(int n, int n2, int n3, NodeList nodeList, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        boolean bl = false;
        Node node = nodeList.item(n3);
        int n4 = n2;
        while (n4 >= n) {
            Node node2 = this.elementAt(n4);
            if (node2 == node) {
                n4 = -2;
                break;
            }
            if (!DOM2Helper.isNodeAfter(node, node2)) {
                boolean bl2;
                this.insertElementAt(node, n4 + 1);
                if (--n3 <= 0 || (bl2 = this.addNodesInDocOrder(0, n4, n3, nodeList, xPathContext))) break;
                this.addNodesInDocOrder(n4, this.size() - 1, n3, nodeList, xPathContext);
                break;
            }
            --n4;
        }
        if (n4 == -1) {
            this.insertElementAt(node, 0);
        }
        return bl;
    }

    public void addNodesInDocOrder(NodeList nodeList, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node != null) {
                this.addNodeInDocOrder(node, xPathContext);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(NodeIterator var1_1, XPathContext var2_2) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder(var3_3, var2_2);
lbl5:
            // 2 sources

            ** while ((var3_3 = var1_1.nextNode()) != null)
        }
lbl6:
        // 1 sources

    }

    public void appendNodes(NodeSet nodeSet) {
        int n = nodeSet.size();
        if (this.m_map == null) {
            this.m_mapSize = n + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + n);
            this.m_map = nodeArray;
        }
        System.arraycopy(nodeSet.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)super.clone();
        if (this.m_map != null && this.m_map == nodeSet.m_map) {
            nodeSet.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeSet.m_map, 0, this.m_map.length);
        }
        return nodeSet;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)this.clone();
        nodeSet.reset();
        return nodeSet;
    }

    public boolean contains(Node node) {
        this.runTo(-1);
        if (this.m_map == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void detach() {
    }

    public Node elementAt(int n) {
        if (this.m_map == null) {
            return null;
        }
        return this.m_map[n];
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        int n = this.m_next;
        Node node = this.m_next < this.m_firstFree ? this.elementAt(this.m_next) : null;
        this.m_next = n;
        return node;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public Node getRoot() {
        return null;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public int getWhatToShow() {
        return -17;
    }

    public int indexOf(Node node) {
        this.runTo(-1);
        if (this.m_map == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(Node node, int n) {
        this.runTo(-1);
        if (this.m_map == null) {
            return -1;
        }
        int n2 = n;
        while (n2 < this.m_firstFree) {
            Node node2 = this.m_map[n2];
            if (node2 != null && node2.equals(node)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void insertElementAt(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (n <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n, this.m_map, n + 1, this.m_firstFree - n);
        }
        this.m_map[n] = node;
        ++this.m_firstFree;
    }

    public void insertNode(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.insertElementAt(node, n);
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node item(int n) {
        this.runTo(n);
        return this.elementAt(n);
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node node = this.elementAt(this.m_next);
            ++this.m_next;
            return node;
        }
        return null;
    }

    public final Node peepOrNull() {
        return this.m_map != null && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final Node pop() {
        --this.m_firstFree;
        Node node = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return node;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public final void push(Node node) {
        int n = this.m_firstFree;
        if (n + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, n + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[n] = node;
        this.m_firstFree = ++n;
    }

    public final void pushPair(Node node, Node node2) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree);
            this.m_map = nodeArray;
        }
        this.m_map[this.m_firstFree] = node;
        this.m_map[this.m_firstFree + 1] = node2;
        this.m_firstFree += 2;
    }

    public void removeAllElements() {
        if (this.m_map == null) {
            return;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            this.m_map[n] = null;
            ++n;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_map == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                if (n > this.m_firstFree) {
                    System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
                } else {
                    this.m_map[n] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeElementAt(int n) {
        if (this.m_map == null) {
            return;
        }
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
        } else {
            this.m_map[n] = null;
        }
    }

    public void removeNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.removeElement(node);
    }

    public void reset() {
        this.m_next = 0;
    }

    public void runTo(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = n >= 0 && this.m_next < this.m_firstFree ? n : this.m_firstFree - 1;
    }

    public void setCurrentPos(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = n;
    }

    public void setElementAt(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[n] = node;
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public void setShouldCacheNodes(boolean bl) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = bl;
        this.m_mutable = true;
    }

    public final void setTail(Node node) {
        this.m_map[this.m_firstFree - 1] = node;
    }

    public final void setTailSub1(Node node) {
        this.m_map[this.m_firstFree - 2] = node;
    }

    public int size() {
        return this.m_firstFree;
    }
}

