/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;

public class NodeVector
implements Serializable,
Cloneable {
    private int m_blocksize;
    private int[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = 0;
    }

    public void RemoveAllNoClear() {
        if (this.m_map == null) {
            return;
        }
        this.m_firstFree = 0;
    }

    public void addElement(int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[this.m_firstFree] = n;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodeVector) {
        int n = nodeVector.size();
        if (this.m_map == null) {
            this.m_mapSize = n + this.m_blocksize;
            this.m_map = new int[this.m_mapSize];
        } else if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + n);
            this.m_map = nArray;
        }
        System.arraycopy(nodeVector.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector nodeVector = (NodeVector)super.clone();
        if (this.m_map != null && this.m_map == nodeVector.m_map) {
            nodeVector.m_map = new int[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeVector.m_map, 0, this.m_map.length);
        }
        return nodeVector;
    }

    public boolean contains(int n) {
        if (this.m_map == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            int n3 = this.m_map[n2];
            if (n3 == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int elementAt(int n) {
        if (this.m_map == null) {
            return -1;
        }
        return this.m_map[n];
    }

    public int indexOf(int n) {
        if (this.m_map == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            int n3 = this.m_map[n2];
            if (n3 == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(int n, int n2) {
        if (this.m_map == null) {
            return -1;
        }
        int n3 = n2;
        while (n3 < this.m_firstFree) {
            int n4 = this.m_map[n3];
            if (n4 == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void insertElementAt(int n, int n2) {
        if (this.m_map == null) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
        }
        this.m_map[n2] = n;
        ++this.m_firstFree;
    }

    public void insertInOrder(int n) {
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            if (n < this.m_map[n2]) {
                this.insertElementAt(n, n2);
                return;
            }
            ++n2;
        }
        this.addElement(n);
    }

    public final int peepOrNull() {
        return this.m_map != null && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : -1;
    }

    public final int peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final int peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final int pop() {
        --this.m_firstFree;
        int n = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = -1;
        return n;
    }

    public final int popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
        return this.m_firstFree == 0 ? -1 : this.m_map[this.m_firstFree - 1];
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = -1;
        this.m_map[this.m_firstFree + 1] = -1;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
    }

    public final void push(int n) {
        int n2 = this.m_firstFree;
        if (n2 + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, n2 + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[n2] = n;
        this.m_firstFree = ++n2;
    }

    public final void pushPair(int n, int n2) {
        if (this.m_map == null) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n;
        this.m_map[this.m_firstFree + 1] = n2;
        this.m_firstFree += 2;
    }

    public void removeAllElements() {
        if (this.m_map == null) {
            return;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            this.m_map[n] = -1;
            ++n;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(int n) {
        if (this.m_map == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            int n3 = this.m_map[n2];
            if (n3 == n) {
                if (n2 > this.m_firstFree) {
                    System.arraycopy(this.m_map, n2 + 1, this.m_map, n2 - 1, this.m_firstFree - n2);
                } else {
                    this.m_map[n2] = -1;
                }
                --this.m_firstFree;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeElementAt(int n) {
        if (this.m_map == null) {
            return;
        }
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
        } else {
            this.m_map[n] = -1;
        }
    }

    public void setElementAt(int n, int n2) {
        if (this.m_map == null) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[n2] = n;
    }

    public final void setTail(int n) {
        this.m_map[this.m_firstFree - 1] = n;
    }

    public final void setTailSub1(int n) {
        this.m_map[this.m_firstFree - 2] = n;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void sort() throws Exception {
        this.sort(this.m_map, 0, this.m_firstFree - 1);
    }

    /*
     * Unable to fully structure code
     */
    public void sort(int[] var1_1, int var2_2, int var3_3) throws Exception {
        var4_4 = var2_2;
        var5_5 = var3_3;
        if (var4_4 >= var5_5) {
            return;
        }
        if (var4_4 == var5_5 - 1) {
            if (var1_1[var4_4] > var1_1[var5_5]) {
                var6_6 = var1_1[var4_4];
                var1_1[var4_4] = var1_1[var5_5];
                var1_1[var5_5] = var6_6;
            }
            return;
        }
        var6_7 = var1_1[(var4_4 + var5_5) / 2];
        var1_1[(var4_4 + var5_5) / 2] = var1_1[var5_5];
        var1_1[var5_5] = var6_7;
        ** GOTO lbl25
        {
            ++var4_4;
            do {
                if (var1_1[var4_4] <= var6_7 && var4_4 < var5_5) continue block0;
                while (var6_7 <= var1_1[var5_5] && var4_4 < var5_5) {
                    --var5_5;
                }
                if (var4_4 >= var5_5) continue;
                var7_8 = var1_1[var4_4];
                var1_1[var4_4] = var1_1[var5_5];
                var1_1[var5_5] = var7_8;
lbl25:
                // 3 sources

            } while (var4_4 < var5_5);
        }
        var1_1[var3_3] = var1_1[var5_5];
        var1_1[var5_5] = var6_7;
        this.sort(var1_1, var2_2, var4_4 - 1);
        this.sort(var1_1, var5_5 + 1, var3_3);
    }
}

