#!/usr/bin/env bash
. lib

rm -rf temp1 temp2

mkdir temp1
cd temp1
darcs init
echo "Conflict, Base ." > child_of_conflict
darcs add child_of_conflict
darcs record -am 'Conflict Base'
cd ..
darcs get temp1 temp2

# Add and record differing lines to both repos
cd temp1
echo "Conflict, Part 1." > child_of_conflict
darcs record -A author -am 'Conflict Part 1'
cd ..
cd temp2
echo "Conflict, Part 2." > child_of_conflict
darcs record -A author -am 'Conflict Part 2'
cd ..

cd temp1
echo | darcs pull -a ../temp2 --external-merge 'cp %2 %o'
cd ..

diff -u temp1/child_of_conflict temp2/child_of_conflict

rm -rf temp1 temp2
