#!/usr/bin/env perl

# test for working dir woes

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use strict;
use Cwd;
use File::Temp 'tempdir';
chdir tempdir( CLEANUP => 1 );

sub reset_chmod {
  my $d = shift;
  `chmod -R u+w $d` if (-d $d);
}

mkdir 'wtemp0';
chdir 'wtemp0';
darcs 'init';
mkdir 'a';
`echo wtemp0 > a/x`;
darcs 'add a';
darcs 'add a/x';
darcs 'record -am "aa" ';
chdir '..';

darcs 'get wtemp0 wtemp1';
chdir 'wtemp1';
darcs 'mv a/x a/y';
darcs 'record -am "x to y" ';
`echo wtemp1 > b`;
darcs 'add b';
darcs 'record -am "bb" ';
mkdir 'd';
darcs 'add d';
darcs 'record -am "dd" ';
my $out = darcs 'tag 1 ';
`echo 1-b2 > b`;
darcs 'record -am "b2" ';
chdir '..';

# try to move a file that we don't have the right to do
darcs 'get wtemp1 wtemp2 --to-patch aa';
chdir 'wtemp2';
`chmod u-w a`;
darcs 'pull -a';
ok((-e 'b'), "managed to do pull b despite problems with x to y");
chdir '..';
cleanup('wtemp2');

{ # [issue319] try to overwrite file(s) in our working dir
  darcs 'get wtemp1 wtemp2 --to-patch aa';
  chdir 'wtemp2';
  `echo wtemp2 > b`;
  `echo wtemp2 > d`;
  darcs 'pull -a -t 1';
  open TEMP2, 'b'; my $b = (<TEMP2>); close TEMP2;
  open TEMP2, 'b-darcs-backup0'; my $b0 = (<TEMP2>); close TEMP2;
  open TEMP2, 'd-darcs-backup0'; my $d0 = (<TEMP2>); close TEMP2;
  like ($b, qr/wtemp1/, "working dir now contains pulled file");
  like ($b0, qr/wtemp2/, "backup properly created");
  like ($d0, qr/wtemp2/, "backup properly created");
  # now make sure we didn't overdo it
  darcs 'pull -a';
  open TEMP2, 'b'; my $bb = (<TEMP2>); close TEMP2;
  like ($bb, qr/1-b2/, "working dir now contains pulled file");
  ok(-e 'b-darcs-backup0',   "sanity check");
  ok(! -e 'b-darcs-backup1', "no gratuitous backing up");
  chdir '..';
  cleanup('wtemp2');
}

{ # [issue298] backup working dir files with conflicts
  darcs 'get wtemp1 wtemp2 --tag 1';
  chdir 'wtemp2';
  `echo 2-b2 > b`;
  darcs 'pull -a';
  open TEMP2, 'b'; my $b = (<TEMP2>); close TEMP2;
  open TEMP2, 'b-darcs-backup0'; my $b0 = (<TEMP2>); close TEMP2;
  like ($b, qr/v v v/, "working dir now contains conflicts");
  like ($b0, qr/2-b2/, "backup properly created");
  unlike ($b0, qr/v v v/, "backup properly created");
  chdir '..';
  cleanup('wtemp2');
}

{ # [issue440] a) try to overwrite a file in our working dir
  darcs 'get wtemp1 wtemp2 --to-patch a';
  chdir 'wtemp2';
  `echo wtemp2 > a/y`;
  `echo old-bak > a/y-darcs-backup0`;
  darcs 'pull -a';
  open TEMP2, 'a/y'; my $ay = (<TEMP2>); close TEMP2;
  open TEMP2, 'a/y-darcs-backup0'; my $ay0 = (<TEMP2>); close TEMP2;
  open TEMP2, 'a/y-darcs-backup1'; my $ay1 = (<TEMP2>); close TEMP2;
  like ($ay, qr/wtemp0/, "working dir now contains pulled file");
  like ($ay0, qr/old-bak/, "old backup not clobbered");
  like ($ay1, qr/wtemp2/,  "new backup properly created");
  chdir '..';
  cleanup('wtemp2');
}

{ # [issue440] b) try to overwrite a directory in our working dir
  darcs 'get wtemp1 wtemp2 --to-patch a';
  chdir 'wtemp2';
  mkdir 'a/y';
  `echo old-bak > a/y-darcs-backup0`;
  darcs 'pull -a';
  open TEMP2, 'a/y'; my $ay = (<TEMP2>); close TEMP2;
  open TEMP2, 'a/y-darcs-backup0'; my $ay0 = (<TEMP2>); close TEMP2;
  like ($ay, qr/wtemp0/, "working dir now contains pulled file");
  like ($ay0, qr/old-bak/, "old backup not clobbered");
  ok(-d 'a/y-darcs-backup1');
  chdir '..';
  cleanup('wtemp2');
}
