#!/usr/bin/env perl

# Some tests for 'darcs whatsnew '

use lib 'lib/perl';
use Test::More 'no_plan';
use Shell::Command;
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use strict;
use Cwd 'abs_path';

init_tmp_repo();

{
  my $testname = "RT#505 whatsnew -s after removal of file without a newline";
  write_file('foo',"foobar");
  like ( darcs('record -la -m "add foo"'), qr/Finished record/,
         'recorded patch adding foo');
  rm_rf 'foo';
  like ( darcs('whatsnew -s'), qr/R/, $testname );
  darcs 'record -a -m "remove foo"';
}

{
    my $test_name = 'RT#245 --look-for-adds implies --summary';
    touch('look_summary.txt');
    like( darcs('whatsnew -l'), qr!a ./look_summary.txt!i, $test_name);
}


my $test_name = 'whatsnew works with uncommon file names';

if ($^O =~ /(msys|win32)/i) {
    pass 'test does not work on windows';
} else {
    touch(qw/\\/);

    my $before  = darcs(qw/add \\\\/);
    my $what = darcs 'whatsnew';
    unlike($what, qr/no changes/i, $test_name);
}

{
    my $test_name = 'whatsnew works with absolute paths';
    my $abs_repo_path = abs_path();
    write_file('date.t','date.t');
    touch 'date.t';
    darcs 'add date.t';
    like( darcs(qq{whatsnew  "$abs_repo_path/date.t"}), qr/hunk/i, $test_name);
}
