DACSKEY(1)                   DACS Commands Manual                   DACSKEY(1)



NNAAMMEE
       dacskey - generate encryption keys for DDAACCSS

SSYYNNOOPPSSIISS
       ddaaccsskkeeyy [ddaaccssooppttiioonnss[1]] [--cchheecckk | --ggeenn | --pprriivv | --pprriivvaattee | --ppuubb |
               --ppuubblliicc]
               [--pp | --ppff _p_a_s_s_p_h_r_a_s_e_-_f_i_l_e] [--ppeemm] [--vvffss] [--rrssaa__kkeeyy__bbiittss _n_u_m_b_e_r]
               [----] _k_e_y_f_i_l_e

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccsskkeeyy utility generates encryption keys for DDAACCSS that are
       cryptographically sound. Keys are represented externally as an XML
       document called a keyfile. The program can also validate a keyfile or
       display a key.

       Keys are created for at least two different purposes, although every
       keyfile has the same format:

       +o   Keys that are shared by all of the jurisdictions within the same
           DDAACCSS federation, identified by the virtual filestore item type
           federation_keys. It is through these "master" keys that any
           jurisdiction is able to decrypt and validate credentials created by
           any other jurisdiction within the same federation quickly and
           without any additional communication. These keys are generated
           initially by a designated federation administrator at the time a
           federation is created. These keys can be generated at any
           jurisdiction within the federation.

           Ideally, new keys should be generated at regular intervals and also
           whenever warranted to maintain security, such as when a
           jurisdiction leaves the federation or if a key may have been
           compromised. When a jurisdiction joins a federation, it must
           receive a copy of the current keys. There is currently no automated
           key management support; administrators must distribute these keys
           to all jurisdictions over a secure channel whenever they are
           changed. Besides using some method of encryption to ensure the keys
           remain private during distribution, take care not to mangle the
           document (e.g., through line breaks or truncation).

       +o   Keys that are used by a jurisdiction for its own purposes,
           identified by the virtual filestore item type jurisdiction_keys.
           These keys are kept private to the jurisdiction (they are not
           shared with any other jurisdiction) and are ordinarily generated at
           that jurisdiction. These keys should be regenerated periodically
           are a routine security measure.

       +o   Keys that are used by a DDAACCSS application at a particular
           jurisdiction for its own purposes (ddaaccssggrriidd((11))[2], for instance).
           These keys should be regenerated periodically, but take care to
           retain the old keys so that they can be used for decryption before
           information is re-encrypted using the new keys.


       The program ordinarily uses OOppeennSSSSLL's ssssll((33))[3] library to acquire
       high-quality random material. In certain situations, an experienced
       administrator might find the --pp and --ppff options useful; others should
       avoid them, however.

       When keys are generated, the output is written to _k_e_y_f_i_l_e, which is
       either created or truncated. In this context, _k_e_y_f_i_l_e must be a
       pathname. Unless directly written to where federation_keys (or
       jurisdiction_keys) points, _k_e_y_f_i_l_e must be copied there.

       Assuming that the default site configuration file (conf/site.conf-std,
       which establishes default locations for these files) has been
       installed:

           % dacskey -u mysite.example.com -q fkeys
           % install -o root -g www -m 0640 fkeys \
                 /usr/local/dacs/federations/example.com/federation_keyfile
           % dacskey -u mysite.example.com -q jkeys
           % install -o root -g www -m 0640 jkeys \
                 /usr/local/dacs/federations/example.com/mysite/jurisdiction_keyfile

       The owner, group, and mode assigned to these files in this example are
       typical but are only suggestions.

           SSeeccuurriittyy
           A keyfile generated by this command must be accessible (readable
           and writable) _o_n_l_y by DDAACCSS web services and the DDAACCSS administrator.
           It must be kept unreadable and unwritable by all others.

       When not generating keys, by default _k_e_y_f_i_l_e is a pathname. If the --vvffss
       flag is given, then _k_e_y_f_i_l_e is a DDAACCSS URI, item type, or absolute
       pathname.

OOPPTTIIOONNSS
       In addition to the standard _d_a_c_s_o_p_t_i_o_n_s[1], ddaaccsskkeeyy recognizes these
       options:

       --ggeenn
           Generate new keys. This is the default operation.

       --cchheecckk
           Validate _k_e_y_f_i_l_e, an existing keyfile. The _k_e_y_f_i_l_e is expressed as
           a vfs-ref or an absolute filename (see ddaaccss..ccoonnff((55))[4]).

       --pprriivv
       --pprriivvaattee
           Print the private key found in _k_e_y_f_i_l_e, an existing keyfile, to
           stdout. The private key is _n_o_t encrypted. If the --ppeemm flag is
           present, the PEM format is used, otherwise the DDAACCSS base-64
           encoding is used (the latter is used when keys appear in XML
           attribute values).

       --ppuubb
       --ppuubblliicc
           Print the public key found in _k_e_y_f_i_l_e, an existing keyfile, to
           stdout. If the --ppeemm flag is present, the PEM format is used,
           otherwise the DDAACCSS base-64 encoding is used (the latter is used
           when keys appear in XML attribute values).

       --pp
           Rather than using the default source for generating random strings,
           derive the random strings from material read from the standard
           input. The user is prompted for input. This option should not be
           used under normal circumstances.

       --ppeemm
           When printing a key, use the PEM format.

       --ppff _p_a_s_s_p_h_r_a_s_e_-_f_i_l_e
           Rather than using the default source for generating random strings,
           derive the random strings from material read from _p_a_s_s_p_h_r_a_s_e_-_f_i_l_e.
           If the filename argument is "--", the standard input is read. This
           option should not be used under normal circumstances.

       --rrssaa__kkeeyy__bbiittss _n_u_m_b_e_r
           This specifies the length of the RSA modulus, in bits, used for
           asymmetric key generation. Used as the _n_u_m argument to
           RRSSAA__ggeenneerraattee__kkeeyy((33))[5], the value must satisfy that function's
           constraints.

       ----
           This argument explicitly marks the end of the flags.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccssaauutthh((11))[6], ddaaccssggrriidd((11))[2], ddaaccssiinniitt((11))[7], ddaaccssrrlliinnkk((11))[8]
       ddaaccssttookkeenn((11))[9], ddaaccss..iinnssttaallll((77))[10], ddaaccss__aaccss((88))[11]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[12])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[13] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacsgrid(1)
           http://dacs.dss.ca/man/dacsgrid.1.html

        3. ssl(3)
           http://www.freebsd.org/cgi/man.cgi?query=ssl&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        5. RSA_generate_key(3)
           http://www.freebsd.org/cgi/man.cgi?query=RSA_generate_key&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        6. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        7. dacsinit(1)
           http://dacs.dss.ca/man/dacsinit.1.html

        8. dacsrlink(1)
           http://dacs.dss.ca/man/dacsrlink.1.html

        9. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       10. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

       11. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       12. www.dss.ca
           http://www.dss.ca

       13. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                        DACSKEY(1)
