DACSINFOCARD(1)              DACS Commands Manual              DACSINFOCARD(1)



NNAAMMEE
       dacsinfocard - manage InfoCard accounts

SSYYNNOOPPSSIISS
       ddaaccssiinnffooccaarrdd [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssiinnffooccaarrdd command manages accounts that are used by the
       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[2] authentication module. This utility
       serves a similar purpose for these authentication modules that the
       ddaaccssppaasssswwdd((11))[3] command does for its llooccaall__ppaasssswwdd__aauutthheennttiiccaattee[4]
       module.

       Apart from their use by llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee, _t_h_e_s_e _a_c_c_o_u_n_t_s _a_r_e
       _c_o_m_p_l_e_t_e_l_y _s_e_p_a_r_a_t_e _f_r_o_m _a_n_y _o_t_h_e_r _a_c_c_o_u_n_t_s.

           SSeeccuurriittyy
           The digest algorithm used depends on the IINNFFOOCCAARRDD__DDIIGGEESSTT[5]
           directive in effect.

           Plaintext PPIDs are not stored. This makes it more difficult for an
           attacker that gains access to the InfoCard account file to discover
           PPIDs.

           Only a DDAACCSS administrator should be able to successfully run this
           program from the command line. Because DDAACCSS keys and configuration
           files, including the file used to store accounts, must be
           restricted to an administrator, this will normally be the case, but
           a careful administrator will set file permissions to deny access to
           all other users. An ordinary user is able to change his own
           InfoCard registration using the ddaaccss__iinnffooccaarrdd((88))[6] web service.

       This program is also available as a DDAACCSS web service,
       ddaaccss__iinnffooccaarrdd((88))[6].

OOPPTTIIOONNSS
       The ddaaccssiinnffooccaarrdd command recognizes these command line flags:

EEXXAAMMPPLLEESS
       To list all of the InfoCard accounts configured for the jurisdiction
       named INFOCARDS:

           % dacsinfocard -uj INFOCARDS -list
           DSS::INFOCARDS:bob managed,istatic,enabled,passwd
           DSS::INFOCARDS:alice managed,istatic,disabled,passwd

       To re-enable the alice account:

           % dacsinfocard -uj INFOCARDS -ena alice

       To test if alice's account is enabled:

           % dacsinfocard -uj INFOCARDS -test ena alice
           % echo $status
           0

       To test if there are accounts for usernames bob and carol:

           % dacsinfocard -uj INFOCARDS -test exists carol
           % echo $status
           0
           % dacsinfocard -uj INFOCARDS -test exists bob
           % echo $status
           1

       To get the private data for username bob:

           % set x=`dacsinfocard -uj INFOCARDS -pdg bob`
           % echo "$x"
           On vacation


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, and non-zero otherwise. A
       "false" outcome from the --tteesstt operation is reflected by an exit status
       of 1. An error condition is indicated by an exit status of 2.

BBUUGGSS
       As this is a relatively new and complicated feature, please test
       carefully.

SSEEEE AALLSSOO
       ddaaccss__iinnffooccaarrdd((88))[6], ddaaccssaauutthh((11))[7], ddaaccss__aauutthheennttiiccaattee((88))[8],
       ddaaccss__aaddmmiinn((88))[9], ddaaccss..ccoonnff((55))[10], UUssiinngg IInnffooCCaarrddss WWiitthh DDAACCSS[11]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[12])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[13] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

        3. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

        4. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

        5. INFOCARD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_DIGEST

        6. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

        7. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        8. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        9. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       10. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       11. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       12. www.dss.ca
           http://www.dss.ca

       13. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                   DACSINFOCARD(1)
