DACSGRID(1)                  DACS Commands Manual                  DACSGRID(1)



NNAAMMEE
       dacsgrid - administer grid-based one-time passwords

SSYYNNOOPPSSIISS
       ddaaccssggrriidd [ddaaccssooppttiioonnss[1]] [--cchhaalllleennggee] [--cclleenn _n_u_m] [--ccooppyy _v_f_s___u_r_i]
                [--ddeecc _t_o_k_e_n] [--ddeelleettee] [--ddiissaabbllee] [--eennaabbllee] [--eenncc _c_h_a_l_l_e_n_g_e]
                [--eexxppiirreedd]
                [--ffllaatt] [--ggeett] [--ggrriidd _s_t_r] [--hh | --hheellpp] [--hhttmmll] [--hhttmmllccssss]
                [--iinnkkeeyyss _i_t_e_m___t_y_p_e] [--lliiffeettiimmee _n_d_a_y_s] [--lliisstt] [--lloonngg]
                [--nnccoollss _n_u_m]
                [--nnrroowwss _n_u_m] [--oouuttkkeeyyss _i_t_e_m___t_y_p_e] [--ppiinn [_n_u_m]] [--rreeffrreesshh]
                [--rrnndd] [--sseeeedd _s_t_r]
                [--sseerriiaall] [--sseett] [--ssiizzee] [--tteesstt] [--tteexxtt]
                [--vvaalliiddaattee _c_h_a_l_l_e_n_g_e _r_e_s_p_o_n_s_e]
                [--vvffss _v_f_s___u_r_i]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssggrriidd utility provides software-based one-time passwords for
       DDAACCSS authentication using a challenge-response architecture. It
       administers accounts that are used by the llooccaall__ggrriidd__aauutthheennttiiccaattee[2]
       authentication module. These accounts are completely separate from the
       accounts used by llooccaall__ppaasssswwdd__aauutthheennttiiccaattee[3] or any other DDAACCSS
       authentication module.

       ddaaccssggrriidd generates a rectangular grid of cells. Each cell consists of a
       letter, followed by a digit, followed by a letter, yielding 6,760
       (26*10*26) possible three-character-long strings. The contents of each
       cell are generated from cryptographically-strong pseudo-random bytes.
       The maximum grid size is 99 rows by 26 columns, and the minimum grid
       size is 3 by 3. The columns are labelled A through Z and the rows are
       labelled 1 through 99. For recommended grid sizes, it is highly likely
       that each grid that is generated is unique and therefore that each user
       will be assigned a different grid.

       Here is a 10x10 grid (the default size):

                A   B   C   D   E   F   G   H   I   J
            1  x7m p7m k4c q9s q2k d9l s5m r8c y3v g2m
            2  o0c t6h q7k l3w p8a q3e b9c l0w z8y c8v
            3  v8n n1w r6i i0g e9y q1n p0g g9v x4y c5u
            4  z8a o9d l1e e8n u8z h3y p2s b9z c6w d5f
            5  x8y o2a y4g d9i s4p c9n c1e m5z o6j m0f
            6  p2s x4c a2x p4f w7y b8k e6c q9g q5v s4z
            7  b8k r4s r2p z5x v3e s0h h5l z6y e9o g6m
            8  r5x m4r a1w f8c f5g l2z q7j r4m w0c x9a
            9  p7s r3g i7c p8a t5x c4h h0k k9d i7k r9n
           10  w4l v0a p9g i0l v2n b8h v9j s0y r3k v0m

           Serial: 2497a62a83ad4bc4
           Created: Mon Aug 14 10:25:03 2006 PDT

       A cell is identified by its column label followed by its row label;
       e.g., in the example above, cell F6 has the value b8k.

       Each grid is assigned a random (and presumably unique) identification
       string (labelled "Serial" in the example above); this string is stored
       on the server with other grid account data. It can be displayed by a
       jurisdiction at login time as a way of authenticating itself to a user,
       provided it is kept confidential (one approach might be for each of the
       parties to supply a different half of the identification string to the
       other).

       After a configurable period, a grid expires and will not be accepted
       for authentication purposes by llooccaall__ggrriidd__aauutthheennttiiccaattee. A grid's
       lifetime might depend on several factors, such as how often a grid is
       used at a jurisdiction, the size of a grid, the degree of security
       required, and how difficult or expensive it is to distribute a grid.

       At the time a grid is generated, ddaaccssggrriidd can associate a randomly
       chosen PIN with it. A PIN, which acts as a secondary password, consists
       of a sequence of letter-digit-letter cells. The default PIN length of
       two cells (6 characters) can be overridden on the command line. If a
       user has been provided with a PIN, it should be entered at the start of
       the user's response to the challenge, immediately before the contents
       of the first cell of the challenge are entered.

           SSeeccuurriittyy
           When used properly, this authentication method can be comparatively
           secure. The main challenge is that it is essential that grids and
           PINs are distributed to users via a sufficiently secure method;
           e.g., by printing them and mailing a hardcopy directly to the user,
           or by using existing secure channels. Each user must understand
           that a grid is essentially a list of passwords and, accordingly,
           must be kept secret during its validity period. When PINs are used,
           they must be distributed using a secure channel different from the
           one used to distribute grids. How this distribution is done is left
           to the DDAACCSS administrator.

           Information is encrypted before being written to the grid account
           file. By default, the virtual filestore item type auth_grid_keys
           identifies the encryption keys to use; the --iinnkkeeyyss and --oouuttkkeeyyss
           flags specify alternatives (see ddaaccsskkeeyy((11))[4]). File permissions
           must be set so that the encryption keys are readable only by
           ddaaccssggrriidd. If the encryption keys are lost, the account entries are
           practically unrecoverable.

           Only the DDAACCSS administrator should be able to successfully run this
           program from the command line. Because DDAACCSS keys and configuration
           files, including the file used to store accounts, must be
           restricted to the administrator, this will normally be the case,
           but a careful administrator will set file permissions to deny
           access to all other users.

       This authentication method has the following advantages:

       +o   Each time a user authenticates, a different password will be
           requested (with high probability)

       +o   The password that is required is not known prior to authentication,
           so a user cannot tell someone else what his password is other than
           by sharing the entire grid (and the PIN, if any)

       +o   Because the password is unlikely to be an easily-guessed word or
           phrase, it should be stronger than a user-selected password

       +o   Should a key sniffer be installed on the user's computer, a sniffed
           password does not do an attacker any good, since it is highly
           unlikely to be reused. If the corresponding challenge can also be
           obtained by an attacker, such as through a phishing attack, a
           portion of the grid will be revealed

       +o   The length of the challenge (which determines the length of the
           password) is configurable by the administrator and can be changed
           at will

       +o   A user's grid can easily be changed by an administrator as often as
           practical

       +o   The method is cheaper than hardware-based one-time passwords,
           provided distribution costs are low


       This authentication method has the following potential disadvantages:

       +o   The authentication method is inherently interactive in that the
           password is not known _a _p_r_i_o_r_i, although this does not guarantee
           that the user is physically present

       +o   Secure channels are needed to distribute grids and PINs

       +o   An authentication grid can be easily copied and so it is best used
           in conjunction with PINs or at least one other authentication
           method; the challenge of keeping grids secret in all situations is
           the main reason why the method is not as strong as hardware
           token-based methods, which are more difficult to copy and can be
           protected by a PIN. The method is best employed in situations where
           a grid is not likely to be stolen, easily copied, or even
           recognized, such as for remote access.


       This authentication method falls somewhere between the "something you
       know" form and the "something you have" form. One might be able to
       memorize a smaller grid, putting it into the former category, but few
       are capable of memorizing a large grid, which makes it necessary to
       have a copy in one's possession. Using PINs provides something closer
       to two-factor authentication and strengthens the method since a
       captured grid is not directly usable.

           NNoottee
           It is possible for different users to be assigned grids of
           different sizes. To prevent generation of a challenge that is
           impossible to satisfy, when the challenge is requested either the
           corresponding grid must be of the default size, the dimensions of
           the grid must be specified, or the username must be specified.

   AAuutthheennttiiccaattiioonn PPrroocceedduurree
       At authentication time, the user is presented with a random challenge
       that is appropriate for the user's grid. The challenge is displayed to
       the user; e.g., "A3, C9, B1, F9". The grid's serial number, or a
       portion of it, might also be displayed. The user must consult his grid
       to locate each of the cells for the given challenge and enter their
       contents as the password. Letters are case insensitive, blanks, tabs,
       and commas are ignored. For the grid and challenge above, the user
       would enter as the password:

           v8ni7cp7mc4h

       Note that a challenge may ask for the same cell more than once.

       A challenge is valid for a configurable length of time after which it
       can no longer be used for authentication.

       To judge how long a challenge should be, assume that user-selected
       passwords are chosen randomly and uniformly from approximately 100
       characters available on a keyboard. This is a very generous assumption
       that is seldom realized in practice. A grid challenge of four cells is
       much stronger than a user-selected password of six characters (69604
       vs. 1006) and a grid challenge of five cells is much stronger than a
       user-selected password of nine characters (69605 vs. 1009). When
       compared to typical user passwords, however, a grid challenge of three
       cells is probably about as strong as a user-chosen password of seven or
       eight characters.

       Grids are accessed through DDAACCSS''ss virtual filestore using item type
       auth_grid. It is assumed that file permissions on the database of grids
       are such that all access is limited to the administrator and
       llooccaall__ggrriidd__aauutthheennttiiccaattee.

OOPPTTIIOONNSS
       In addition to the standard _d_a_c_s_o_p_t_i_o_n_s[1], the following command line
       flags are recognized:

       --cchhaalllleennggee
           Emit a random challenge. If _u_s_e_r_n_a_m_e was specified, a
           size-appropriate challenge will be produced; otherwise, if grid
           dimensions have been specified, a suitable challenge will be
           produced; otherwise, the default grid dimensions will be used when
           producing a challenge.

       --cclleenn _n_u_m
           Set the challenge length to _n_u_m cells. The minimum length is 3
           cells and the default length is 4 cells.

       --ccooppyy _v_f_s___u_r_i
           Copy the input grids to the grids specified by _v_f_s___u_r_i, deleting
           any existing contents.

       --ddeecc _t_o_k_e_n
           Decrypt a challenge token produced by the --eenncc option and print it.

       --ddeelleettee
           Delete the account for _u_s_e_r_n_a_m_e.

       --ddiissaabbllee
           Disable logins for _u_s_e_r_n_a_m_e. Implies --sseett.

       --eennaabbllee
           Enable logins for _u_s_e_r_n_a_m_e. Implies --sseett.

       --eenncc _c_h_a_l_l_e_n_g_e
           Encrypt a challenge (typically, produced by the --cchhaalllleennggee option)
           and print it. The item type federation_keys is used for this
           purpose, which means that any jurisdiction in the federation can
           decrypt the challenge.

       --eexxppiirreedd
           List only expired grids, relative to the grid lifetime in effect.
           Implies --lliisstt.

       --ffllaatt
           Print a grid in a concise textual representation that consists of
           three comma-separated fields: the serial number, enabled/disabled
           flag (non-zero means enabled), the grid (as an ordered sequence of
           space-separated rows), a PIN (or zero if there is no PIN), and the
           creation date (as the number of seconds since the epoch).

       --ggeett
           Retrieve the grid for _u_s_e_r_n_a_m_e and make it the "current" grid for
           display purposes.

       --ggrriidd _s_t_r
           Make _s_t_r, a grid in the flattened representation, the "current"
           grid for display purposes or the --sseett flag.

       --hh
       --hheellpp
           Display a help message and exit.

       --hhttmmll
           Emit a grid as a fragment of an HTML document.

       --hhttmmllccssss
           Emit a grid as a fragment of an HTML document with some CSS.

       --iinnkkeeyyss _i_t_e_m___t_y_p_e
           For decrypting account information, use the store identified by
           _i_t_e_m___t_y_p_e.

       --lliiffeettiimmee _n_d_a_y_s
           Consider the lifetime of grids to be _n_d_a_y_s days. Grids do not have
           a fixed lifetime; only their date of creation is recorded. The
           default lifetime is 7 days.

       --lliisstt
           List _u_s_e_r_n_a_m_e, if given, otherwise all usernames.

       --lloonngg
           Produce more detailed listing output. Implies --lliisstt.

       --nnccoollss _n_u_m
           Set the number of grid columns to _n_u_m, which is between 3 and 26.
           This is used when generating grids and challenges.

       --nnrroowwss _n_u_m
           Set the number of grid rows to _n_u_m, which is between 3 and 99. This
           is used when generating grids and challenges.

       --oouuttkkeeyyss _i_t_e_m___t_y_p_e
           For encrypting account information, use the store identified by
           _i_t_e_m___t_y_p_e.

       --ppiinn[_n_u_m]
           If no other operation is specified, print the PIN, if any, for
           _u_s_e_r_n_a_m_e. With the --sseett flag, generate a new PIN for _u_s_e_r_n_a_m_e. If a
           non-negative integer is appended to the flag (e.g., --ppiinn00, --ppiinn44),
           the PIN length (in cell units) is set to that number with respect
           to PIN generation. The default PIN length is 2 cells. Setting the
           PIN length to zero turns off PIN generation.

       --rreeffrreesshh
           If a _u_s_e_r_n_a_m_e is given, generate a new grid for that user. If no
           _u_s_e_r_n_a_m_e is given, generate a new grid for each user that already
           has a grid. Any existing grid immediately becomes invalid. All of
           these grids will have the same dimensions. If the --ggrriidd flag is
           given, it is ignored. By default, any existing PIN is retained. The
           old grid's enabled/disabled status is retained. If the --ppiinn flag is
           given, a new PIN will be generated; if --ppiinn00 is given, however, new
           grids will not have a PIN.

       --rrnndd
           Reserved for future use.

       --sseeeedd _s_t_r
           Reserved for future use.

       --sseerriiaall
           Print the serial number of the current grid.

       --sseett
           Set or replace the grid for _u_s_e_r_n_a_m_e.

       --ssiizzee
           Display the grid dimensions in terms of the command line flags
           --nnccoollss and --nnrroowwss. Implies --lliisstt.

       --tteesstt
           Emit a grid and a challenge, prompt from a response, and verify the
           response.

       --tteexxtt
           Emit a pretty-printed grid.

       --vvaalliiddaattee _c_h_a_l_l_e_n_g_e _r_e_s_p_o_n_s_e
           Validate _r_e_s_p_o_n_s_e against _c_h_a_l_l_e_n_g_e.

       --vvffss _v_f_s___u_r_i
           Instead of using the item type auth_grid to specify which grids to
           act on, use _v_f_s___u_r_i (see the VVFFSS[5] configuration directive).

       The default action is to display the current grid. Apart from error
       messages, which are printed to the standard error, all output goes to
       the standard output.

       Ordinarily, a _d_a_c_s_o_p_t_i_o_n will be specified to select the jurisdiction
       on behalf of which grids are being created.

EEXXAAMMPPLLEESS
       These examples assume that the jurisdiction name to use is EXAMPLE and
       its domain is example.com.

       To use this authentication method, a DDAACCSS administrator would perform
       the following steps:

       +o   After reviewing the way the method operates, decide how grids will
           be securely distributed to users, select the grid parameters,
           decide whether PINs will be used and how they will be securely
           distributed, and determine a schedule for refreshing grids (and
           perhaps PINs).

       +o   Decide where the grids will be stored and add a suitable VFS
           directive to dacs.conf, for example:

               VFS "[auth_grid]dacs-kwv-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/grids"


       +o   Generate keys, decide where they will be stored, and add a suitable
           VFS directive to dacs.conf, for example (your user ID, groupID, and
           path may vary):

               % cd /usr/local/dacs/federations_root/example.com/EXAMPLE
               % dacskey -uj EXAMPLE -q auth_grid_keys
               % chgrp www auth_grid_keys
               % chmod 0640 auth_grid_keys



               VFS "[auth_grid_keys]dacs-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_grid_keys"


       +o   Configure a suitable Auth clause in dacs.conf, for example:

               <Auth id="grid">
               URL "https://example.com/cgi-bin/dacs/local_grid_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               </Auth>


       +o   For each user that will be capable of authenticating using this
           method: a) generate a grid of the necessary dimensions, with or
           without a PIN (as required); b) obtain the grid in the most
           suitable format and give it to its owner; and c) if there is a PIN,
           obtain the PIN and give it to its owner.

       +o   Refresh the grid (and, optionally, the PIN) as scheduled and give
           the user the replacement grid.


       To create and display a grid (but not create an account):

           % dacsgrid -uj EXAMPLE

       To generate a grid of default dimensions and assign it to username bobo
       (replacing any existing grid for that user):

           % dacsgrid -uj EXAMPLE -set bobo

       To generate a 6x6 grid and assign it to username bobo (replacing any
       existing grid):

           % dacsgrid -uj EXAMPLE -nrows 6 -ncols 6 -set bobo

       To retrieve and print a grid (as HTML) for the username bobo:

           % dacsgrid -uj EXAMPLE -get -html bobo

       To display the PIN for username bobo:

           % dacsgrid -uj EXAMPLE -pin bobo

       The exit status will be non-zero if this user does not have a grid or
       if the grid does not have a PIN.

       To copy the current set of grids to the file /secure/grids:

           % dacsgrid -uj EXAMPLE -copy "dacs-kwv-fs:/secure/grids"

       To refresh an alternate set of grids in the file /secure/grids:

           % dacsgrid -uj EXAMPLE -copy "dacs-kwv-fs:/secure/grids"
           % dacsgrid -uj EXAMPLE -vfs "dacs-kwv-fs:/secure/grids" -refresh

       An example shell script that generates a minimal HTML login page for
       grid authentication is included in the distribution. It assumes that
       all grids are the default size.

       If different users may have grids of different sizes, or if a
       jurisdiction wants to display a user's grid's serial number as a form
       of jurisdictional authentication, then the login procedure must
       determine the username before it can acquire a challenge or serial
       number.

FFIILLEESS
       ddaaccss__ggrriidd..ccssss[6]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0, or 1 if an error occurred.

NNOOTTEESS
       To help thwart automated responses, should some assurance be required
       that a person rather than software is answering a challenge, the
       challenge might be presented as a CCAAPPTTCCHHAA[7] or something similar.

       A hardware device could be used to store and access grids, which could
       boost the method's security and possibly even offer advantages over the
       PRNG methods used by most commercial tokens.

       Another idea is to supply users with software to run on their personal
       workstations that would securely store and manage grids and, given a
       challenge, display the response. This may not provide the same level of
       confidence as hardware token or hard-copy based methods, however,
       because it is difficult to be certain that a computer, file, or program
       hasn't been compromised. If sufficiently secure, a password-protected
       USB flash memory device might be acceptable for transporting and
       storing grids.

       The login interface should consider providing a menu or image map to
       enter the PIN, rather than the keyboard, to defeat keylogging spyware.

       Using this authentication method makes you feel like you are a secret
       agent. Consider printing grids on an edible substrate.

BBUUGGSS
       There should be a clean way of flipping from one set of grids to
       another at a specified date and time. This can currently be done by
       pre-generating a set of grids with appropriate file names (e.g., based
       on the date the set becomes effective) and configuring the VFS
       directive for the grids to form the file name based on the current
       date.

       Users cannot select their own PINs. This may be a feature.

       An alternate mode of operation based on strong but repeatable pseudo
       random numbers described by NNIISSTT SSPP 880000--9900[8] is pending. The current
       implementation does not employ a reproducible sequence of pseudo random
       numbers; this has advantages and disadvantages.

       The account file should probably be an XML document.

SSEEEE AALLSSOO
       ddaaccssttookkeenn((11))[9], ddaaccss__aauutthheennttiiccaattee((88))[10], ooppiiee((44))[11]. Grid-based
       methods are also used by ciphers; e.g., the VVIICC cciipphheerr[12].

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[13])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[14] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_grid_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#grid

        3. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#passwd

        4. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

        5. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        6. dacs_grid.css
           http://dacs.dss.ca/man//css/dacs_grid.css

        7. CAPTCHA
           http://en.wikipedia.org/wiki/CAPTCHA

        8. NIST SP 800-90
           http://csrc.nist.gov/publications/nistpubs/800-90/SP800-90revised_March2007.pdf

        9. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       10. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       11. opie(4)
           http://www.freebsd.org/cgi/man.cgi?query=opie&apropos=0&sektion=0&manpath=FreeBSD+7.2-RELEASE&format=html

       12. VIC cipher
           http://en.wikipedia.org/wiki/VIC_cipher

       13. www.dss.ca
           http://www.dss.ca

       14. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACSGRID(1)
