DACSEXPR(1)                  DACS Commands Manual                  DACSEXPR(1)



NNAAMMEE
       dacsexpr - DDAACCSS expression language shell and interpreter

SSYYNNOOPPSSIISS
       ddaaccsseexxpprr [--xx] [ddaaccssooppttiioonnss[1]] [--ddll] [--ee _e_x_p_r] [--nn] [--pp] [--ss] [--hh |
                --hheellpp] [--tteesstt]
                [----] [_f_i_l_e_n_a_m_e] [_s_c_r_i_p_t_-_a_r_g...]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccsseexxpprr utility evaluates DDAACCSS expressions (see ddaaccss..eexxpprrss((55))[2]).
       It is often a useful aid when composing or testing expressions to be
       used in access control rules, or when debugging ACLs and configuration
       directives. While they continue to be referred to as "expressions" for
       historical reasons, it has become possible to write small programs, and
       the language can also be useful as a simple scripting language
       independent of the rest of DDAACCSS.

       If an expression is provided, it is evaluated and the result is printed
       to the standard output. At most one expression can be specified. If the
       --qq flag is given (one of the _d_a_c_s_o_p_t_i_o_n_s[1]), nothing is printed,
       expression evaluation errors are suppressed, and the program terminates
       with an appropriate eexxiitt ssttaattuuss[3]; otherwise the result is written to
       the standard output. If neither a --qq flag is given nor any flag that
       controls the logging level, then the logging level is set to warn
       overriding any configuration file logging level directive; this
       behaviour is usually convenient.

       If no expression is provided, the program reads its standard input. If
       the input is not coming from a terminal type device, the program runs
       in "batch mode" and prompting is suppressed; otherwise, the program
       runs in "interactive mode". When prompted in interactive mode, enter
       hheellpp for assistance. If the rreeaaddlliinnee((33))[4] functionality was configured
       when the program was built, command line editing and history are
       available in interactive mode.

       If the program is executed through the system's "#!" mechanism, one or
       more command line arguments can be given:

           #!/usr/local/dacs/bin/dacsexpr -test
           // expect-exact:17
           ${x} = 17;

       Such programs always use the script file as input, therefore no
       expression or other file can be specified on the "#!" line.

       The _E_n_v namespace is initialized from the program's environment. For
       example, if the value of the environment variable LLOOGGNNAAMMEE is bobo, then
       _$_{_E_n_v_:_:_L_O_G_N_A_M_E_} will be instantiated with that value. Syntactically
       invalid variable names are silently ignored.

           NNoottee
           Configuration directives and the _C_o_n_f variable namespace are
           available only if a configuration file is processed (e.g., by
           giving the --uujj command line flag). This is relevant, for example,
           if the hhttttpp(())[5] function is called using the https scheme because
           proper operation will require the SSSSLL__PPRROOGG[6] directive to be
           configured. See ddaaccss..ccoonnff((55))[7].

OOPPTTIIOONNSS
       If an expression or file has not already been specified, a filename may
       appear as the last argument. If _f_i_l_e_n_a_m_e is "-", the standard input is
       read.

       --ddll
           Print debugging information to stderr.

       --ee _e_x_p_r
           The given expression is evaluated.

       --hh
       --hheellpp
           Display a help message and exit.

       --nn
           Do not evaluate any expressions, only check for syntax errors.

       --pp
           Print the final result to the standard output, unless it has been
           suppressed by --qq or --nn. Without this flag, the result would have to
           be output by the program.

       -s
           If a single expression is being evaluated from the command line or
           a file and the result of evaluation is a string or bstring, the
           output will be surrounded by quotes unless this flag is specified.

       --tteesstt
           The input is a test case. A test case consists of options followed
           by an expression. There can be zero or more options, one per line,
           embedded within a // style comment:

               { whitespace* "//" whitespace* _o_p_t_i_o_n_-_n_a_m_e ":" _o_p_t_i_o_n_-_v_a_l_u_e end-of-line }*

           No whitespace is allowed before or after the ":". As a special
           case, lines having the following format are ignored:

               whitespace* "///" .* end-of-line

           The first non-option line terminates the options and is the first
           line of the expression to be evaluated.

           Here is an example:

               /// Test bitwise shifts
               // expect-exact:1024
               1 << 10

           An option controls how the test is to be performed and gives the
           expected result:

           expect:_r_e_g_e_x
           expect-regex:_r_e_g_e_x
               The result string must match _r_e_g_e_x. These two option names are
               equivalent.

           expect-identical:_s_t_r_i_n_g
               The result string must match _s_t_r_i_n_g exactly.

           expect-exact:_s_t_r_i_n_g
               The result string must match _s_t_r_i_n_g exactly, except that
               C-style character constants (preceded by a backslash) in _s_t_r_i_n_g
               are interpolated.

           expect-code:_c_o_d_e
               The result code must match _c_o_d_e, which is 0 if the result is
               TTrruuee, 1 if the result is FFaallssee, and 2 if an error occurs. If
               this option is not given, a default code of 0 is assumed.

           expect-type:_t_y_p_e
               The type of the result must match _t_y_p_e, which can be integer,
               real, string, bstring, literal, or undef.

           expect-flags:_f_l_a_g_s
               Currently, the only recognized values for _f_l_a_g_s are
               rw_namespaces and ro_namespaces. The former allows the test to
               create or modify variables in the _D_A_C_S, _A_r_g_s, or _E_n_v namespace;
               by default, these namespaces are read-only. This might be
               useful when testing ffrroomm(())[8], for instance, because it allows
               the test to set a value for _$_{_D_A_C_S_:_:_R_E_M_O_T_E___A_D_D_R_}. The default
               behaviour can be explicitly selected by specifying
               ro_namespaces.

           show-result:{yes | no}
               The result is printed to the standard output only if the option
               value is yes.

           If the test fails, a descriptive message is printed to the standard
           error. The program's exit status will be 0 if the test was
           successful, 1 otherwise.

           This example should succeed without displaying the result:

               // expect-exact:2
               // expect-type:integer
               /// show-result:yes
               1 + 1


               NNoottee
               The DDAACCSS distribution includes a set of test cases in the
               src/tests directory that can be run for regression testing (do
               "make tests" from the src directory). Some of the functions
               provided by ddaaccss..eexxpprrss((55))[2] are also used internally by DDAACCSS,
               so it is critical that all tests are successful even for
               functions that are not used from the user level.

       -x
           If this is the very first flag it indicates that ddaaccsseexxpprr is being
           executed as a script via the system's "#!" mechanism. This might be
           useful if the program's heuristic for determining this is
           incorrect. The last argument must be a filename.

       --
           This argument explicitly marks the last flag argument. A filename
           argument might follow.

EEXXAAMMPPLLEESS
       The following command evaluates the expression argument (note that it
       is a single argument to the command) and outputs the result to stdout:

           % dacsexpr -e "1+1"
           2
           % dacsexpr -e '${Env::USER}'
           "bobo"
           % dacsexpr -u example.com -e '"FEDERATION_NAME=" . ${Conf::FEDERATION_NAME}'
           "FEDERATION_NAME=EXAMPLE"
           % dacsexpr - a b c <<HERE
           ? print("First arg is \"\${Argv::1}\"")
           ? HERE
           First arg is "a"
           % cat ex
           #!/usr/local/dacs/bin/dacsexpr

           print("Argv[2] is ${Argv::2}");
           % chmod 0755 ex
           % ./ex foo bar baz
           Argv[2] is bar


DDIIAAGGNNOOSSTTIICCSS
       If an error occurs, a message may be written to stderr, depending on
       the logging level. In general, the program exits 0 if and only if
       everything was fine. If a command line expression is evaluated, the
       program exits 0 if the expression evaluates to TTrruuee, 1 if it evaluates
       to FFaallssee, and 2 if an error occurs. If an explicit call to eexxiitt(()) is
       made and no true error condition occurred, then the program will exit
       with the argument value.

SSEEEE AALLSSOO
       ddaaccss..eexxpprrss((55))[2]

BBUUGGSS
       New and little-used features should be used with care. This advice
       applies to all software.

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[9])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[10] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

        3. exit status
           http://dacs.dss.ca/man/#diagnostics

        4. readline(3)
           http://www.freebsd.org/cgi/man.cgi?query=readline&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        5. http()
           http://dacs.dss.ca/man/dacs.exprs.5.html#http

        6. SSL_PROG
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG

        7. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        8. from()
           http://dacs.dss.ca/man/dacs.exprs.5.html#from

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACSEXPR(1)
