DACSCRED(1)                  DACS Commands Manual                  DACSCRED(1)



NNAAMMEE
       dacscred - acquire and manage DDAACCSS credentials

SSYYNNOOPPSSIISS
       ddaaccssccrreedd [--dddd _d_i_r] [--llll _l_o_g___l_e_v_e_l] [--vv] _o_p [_o_p_a_r_g_s]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssccrreedd utility supports simple DDAACCSS authentication, optionally
       storing the returned DDAACCSS identities securely for future use by
       non-browser applications. Basic maintenance operations are provided for
       this cache of credentials.

       DDAACCSS per-user information, including the cache, is kept within a
       directory that must be owned by the user. Additionally, the directory
       must be accessible only by the user.  DDAACCSS will refuse to use any
       per-user information if file permissions are inappropriate.

       If this directory is not specified on the command line, the following
       is the default behaviour. If an environment variable named DDAACCSSDDIIRR is
       available, its value is used for the name of this directory; otherwise,
       DDAACCSS will use a directory named .dacs in the user's home directory.

       The contents of the cache file are encrypted. A password must be
       provided when the cache is created and before each subsequent access.
       Currently, AES-128-CFB is used along with a SHA1-based HHMMAACC[1].

           SSeeccuurriittyy
           A jurisdiction may reject credentials that are used from an IP
           address that does not match the IP address from which the
           credentials were initially requested (see the VERIFY_IP
           configuration directive). This means that if a cache is moved to a
           different host, the credentials may be treated as invalid if they
           are used from that host.

OOPPTTIIOONNSS
       The following command line flags are common to all operations:

       --dddd _d_i_r_e_c_t_o_r_y
           The DDAACCSS directory to use instead of the default is _d_i_r_e_c_t_o_r_y.

       --llll _l_o_g___l_e_v_e_l
           Set the debugging output level to _l_o_g___l_e_v_e_l (see ddaaccss((11))[2]). The
           default level is warn.

       --vv
           The --vv flag bumps the debugging output level to debug or (if
           repeated) trace.

       The _o_p argument specifies the operation to be performed. The following
       operations are available:

           Try to authenticate as _u_s_e_r_n_a_m_e by invoking ddaaccss__aauutthheennttiiccaattee[3] at
           the URL _a_u_t_h_-_U_R_L.  _u_s_e_r_n_a_m_e has the syntax
           [[_f_e_d_e_r_a_t_i_o_n]::]_j_u_r_i_s_d_i_c_t_i_o_n:_u_s_e_r_n_a_m_e (the jurisdiction component
           of the name must be provided; see ddaaccss((11))[4]). An SSL connection is
           always used for this purpose.

           If authentication is successful and the --ss flag is not given, the
           (_u_s_e_r_n_a_m_e, _a_u_t_h_-_U_R_L) pair will be recorded; subsequent invocations
           of the command can omit the _a_u_t_h_-_U_R_L argument if it is unchanged.
           If the --pp flag is given, the user is prompted for a password to
           pass to ddaaccss__aauutthheennttiiccaattee; if --ppff is given instead, a password is
           read from _f_i_l_e (stdin is read if _f_i_l_e is "-"). If _a_u_x is given, it
           is used as the value of the _A_U_X_I_L_I_A_R_Y argument to
           ddaaccss__aauutthheennttiiccaattee. The --ccaaff (--ccccff) flag identifies _f_i_l_e as a file
           of CA certificates (client certificates) in PEM format,
           respectively; see ssssllcclliieenntt((11))[5].

           New credentials replace old credentials in the cache. Credentials
           and authentication mappings in the cache are not automatically
           managed, so the cache may contain credentials that have expired.

           The following example prompts the user for a password before trying
           to authenticate as DSS:smith:

               % dacscred auth -p DSS:smith \
                   https://dss.example.com/cgi-bin/dacs/dacs_authenticate

           The following example might be used within a script to test if
           $passwd is the correct password for DSS:smith:

               % echo $passwd | dacscred auth -s -pf - DSS:smith \
                   https://dss.example.com/cgi-bin/dacs/dacs_authenticate

           The exit status will be 0 only if the password is correct.

           Delete all credentials with a name that matches a regular
           expression (see rreeggeexx((33))[6]).

           Print all credentials to stdout that should be sent along with a
           service request to the given URL. If no URL is given, print all
           credentials in the cache. Note that these credentials represent
           DDAACCSS identities and should be kept secret.

           List the names of all credentials in the cache, by default. This is
           equivalent to providing the cred argument. If the auth argument is
           given, a list of identities and the _a_u_t_h_-_U_R_L arguments that were
           used to authenticate those identities is displayed. If a _r_e_g_e_x is
           given, the list is limited to those identities matched by it (cred
           behaviour) or those "_u_s_e_r_n_a_m_e _a_u_t_h_-_U_R_L" strings that match it (auth
           behaviour).

           Change the password that protects the cache. The current password
           must first be provided.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       This command only supplies partial support for interacting with
       ddaaccss__aauutthheennttiiccaattee.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[3]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[7])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[8] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. HMAC
           http://www.rfc-editor.org/rfc/rfc2104.txt

        2. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        3. dacs_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        4. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

        5. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

        6. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACSCRED(1)
