DACS_TOKEN(8)              DACS Web Services Manual              DACS_TOKEN(8)



NNAAMMEE
       dacs_token - manage DACS one-time password token accounts

SSYYNNOOPPSSIISS
       ddaaccss__ttookkeenn [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccss__ttookkeenn web service provides limited account management
       operations on accounts recognized by llooccaall__ttookkeenn__aauutthheennttiiccaattee[2], a
       DDAACCSS authentication module. Full administrative functionality is
       provided by ddaaccssttookkeenn; refer to ddaaccssttookkeenn((11))[3] for detailed
       information about one-time passwords, token devices, and user accounts.
       These accounts are completely separate from any other accounts and
       passwords.

       Subject to configuration and valid authorization, this web service
       lets:

       +o   users set an initial PIN for their account (note that his presents
           a window of opportunity for an attacker that has obtained a
           PIN-less token);

       +o   users change the PIN on their account;

       +o   users synchronize their account with their token; and

       +o   DDAACCSS administrators (see AADDMMIINN__IIDDEENNTTIITTYY[4]) set, change, or remove
           the PIN on any account, synchronize an account with a token
           (removal depends on TTOOKKEENN__RREEQQUUIIRREESS__PPIINN[5]), or obtain the next OTP
           for a specified account;

       +o   anyone create and test a demonstration account (visit
           ddaaccss..ddssss..ccaa[6] to try a live demonstration).


       Outside of demonstration mode operation, accounts are managed
       identically to ddaaccssttookkeenn((11))[3] using the item types auth_token,
       auth_hotp_token, and auth_totp_token.

           SSeeccuurriittyy
           The same account security stipulations as ddaaccssttookkeenn apply.

           The web service applies access controls internally; a DDAACCSS ACL can
           be added to further restrict its use. The internal rules are:

           +o   A DDAACCSS administrator can synchronize any account without
               providing the account's PIN; other users must provide the
               account's PIN, if there is one.

           +o   A DDAACCSS administrator can set, change, or remove (depending on
               TTOOKKEENN__RREEQQUUIIRREESS__PPIINN[5]) any account's PIN; other users can set
               or change their account's PIN by:

               +o   authenticating as the username of the account being
                   accessed (if the account has a PIN and the user has
                   forgotten it, presumably a different authentication method
                   must be used); or

               +o   contacting a DDAACCSS administrator.

               +o   Demonstration mode is enabled if the item type
                   auth_token_demo is defined; otherwise, if
                   auth_token_hotp_demo is defined, then demonstration mode
                   for HOTP is enabled, and if auth_token_totp_demo is
                   defined, then demonstration mode for TOTP is enabled. If
                   none of these item types is enabled, which is the default,
                   then demonstration mode is inoperative.


       When validating a HOTP one-time password, the
       TTOOKKEENN__HHOOTTPP__AACCCCEEPPTT__WWIINNDDOOWW[7] configuration directive can be used to
       allow an account's counter value to automatically "catch up" to the
       token's.

OOPPTTIIOONNSS
   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[8], ddaaccss__ttookkeenn understands
       the following CGI arguments:

       _C_O_N_F_I_R_M___N_E_W___P_I_N
           Required with the SET_PIN operation, the value of this argument
           must be the same as the value of _C_O_N_F_I_R_M___N_E_W___P_I_N.

       _O_P_E_R_A_T_I_O_N
           The following operations are supported:

           +o   CURRENT

               Unlike the other operations, this operation returns a
               text/plain MIME type, consisting of the current _m_o_v_i_n_g _f_a_c_t_o_r
               (i.e., the HOTP counter value or the TOTP interval value),
               followed by a space and the corresponding OTP for _U_S_E_R_N_A_M_E.
               This facilitates an easy-to-use, REST-type interface. In the
               case of HOTP, the counter value is advanced, "consuming" the
               OTP. Only an administrator is allowed to perform this
               operation, which can be used to build a simple mutual
               authentication capability:

                1. The user gives a username to the sign-on procedure;

                2. The sign-on procedure asks DDAACCSS for the OTP it expects the
                   user's token to produce, based on the user's account
                   parameters;

                3. The sign-on procedure presents the OTP to the user, who
                   verifies its correctness by matching the presented OTP with
                   the one actually produced by the token;

                4. The user continues the authentication procedure, perhaps by
                   providing the token's next OTP or using another
                   authentication method, such as a password.
                   The appropriateness of TOTP mode for mutual authentication
                   depends on the OTP lifetime and other configuration
                   parameters.

               +o   SET_PIN

                   Set or change the PIN associated with the account for
                   _U_S_E_R_N_A_M_E. This operation requires the _N_E_W___P_I_N,
                   _C_O_N_F_I_R_M___N_E_W___P_I_N, _M_O_D_E, and _U_S_E_R_N_A_M_E arguments.

               +o   SYNC

                   Synchronize the account for _U_S_E_R_N_A_M_E so that the next
                   password produced by the token is expected to be valid.
                   This operation requires the _P_A_S_S_W_O_R_D, _M_O_D_E, and _U_S_E_R_N_A_M_E
                   arguments.

               +o   DEMO_CREATE

                   Create a demonstration account according to the given
                   arguments, configuration values, and defaults. Required
                   arguments: _M_O_D_E, _K_E_Y. Optional arguments: _N_E_W___P_I_N,
                   _C_O_N_F_I_R_M___N_E_W___P_I_N, _N_D_I_G_I_T_S, _B_A_S_E, _S_E_R_I_A_L. Optional HOTP
                   argument: _C_O_U_N_T_E_R. Optional TOTP arguments: _D_I_G_E_S_T___N_A_M_E,
                   _T_I_M_E___S_T_E_P.

               +o   DEMO_SYNC

                   Synchronize a demonstration account using _U_S_E_R_N_A_M_E, a
                   one-time password or password sequence (_S_Y_N_C), and optional
                   _P_I_N.

               +o   DEMO_VALIDATE

                   Validate the given demonstration account (_U_S_E_R_N_A_M_E),
                   one-time password (_P_A_S_S_W_O_R_D), and PIN (_P_I_N) in
                   demonstration mode. No credentials are actually issued.

               _M_O_D_E
                   This argument is the device mode, which may be (case
                   insensitively) counter or hotp for counter mode, or time or
                   totp for time-based mode.

               _N_E_W___P_I_N
                   With the SET_PIN operation, this is the new PIN to
                   associate with the account. An administrator can remove the
                   PIN entirely, provided it is allowed by
                   TTOOKKEENN__RREEQQUUIIRREESS__PPIINN[5], by omitting (or not providing a
                   value for) both _N_E_W___P_I_N and _C_O_N_F_I_R_M___N_E_W___P_I_N.

               _P_A_S_S_W_O_R_D
                   If the request is not accompanied by credentials for
                   _U_S_E_R_N_A_M_E or an administrator identity, this one-time
                   password must validate against the expected value for
                   _U_S_E_R_N_A_M_E.

               _P_I_N

               _U_S_E_R_N_A_M_E
                   The DDAACCSS username of interest.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       This version only provides self-service operations for users and
       limited account management for a DDAACCSS administrator; administrators
       must use ddaaccssttookkeenn((11))[3] for everything else. Full-blown web-based
       token account management should either be provided by ddaaccss__ttookkeenn or
       ddaaccss__aaddmmiinn[9].

       Demonstration mode accounts should be manually deleted from time to
       time.

       The _F_O_R_M_A_T is not understood. XML responses should be implemented.

SSEEEE AALLSSOO
       ddaaccssttookkeenn((11))[3], ddaaccss..ccoonnff((55))[10], ddaaccss__aauutthheennttiiccaattee((88))[11]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[12])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[13] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_token_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_token_authenticate

        3. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

        4. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

        5. TOKEN_REQUIRES_PIN
           http://dacs.dss.ca/man/dacs.conf.5.html#TOKEN_REQUIRES_PIN

        6. dacs.dss.ca
           http://dacs.dss.ca

        7. TOKEN_HOTP_ACCEPT_WINDOW
           http://dacs.dss.ca/man/dacs.conf.html#TOKEN_HOTP_ACCEPT_WINDOW

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. dacs_admin
           http://dacs.dss.ca/man/dacs_admin.8.html

       10. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       11. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       12. www.dss.ca
           http://www.dss.ca

       13. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                     DACS_TOKEN(8)
