DACS_SELECT_CREDENTI(8)    DACS Web Services Manual    DACS_SELECT_CREDENTI(8)



NNAAMMEE
       dacs_select_credentials - temporarily disable DDAACCSS credentials

SSYYNNOOPPSSIISS
       ddaaccss__sseelleecctt__ccrreeddeennttiiaallss [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       A user may concurrently possess more than one set of DDAACCSS credentials
       during a session, with each representing a different identity. Zero or
       more credentials may be submitted with a request for a DDAACCSS-wrapped web
       service. It is sometimes desirable or necessary for a user to switch
       between identities, or to be considered unauthenticated. Middleware
       (software situated between a user agent and a DDAACCSS-capable web server)
       and more sophisticated user agents might provide this functionality
       simply by sending some DDAACCSS HTTP cookies and not sending others, under
       user control. With standard browsers or in other situations where this
       functionality is not available, achieving this by repeatedly
       authenticating and signing off (or by manually deleting cookies) would
       be inconvenient at best.

       The ddaaccss__sseelleecctt__ccrreeddeennttiiaallss web service can be used to temporarily
       disable credentials, leaving the remaining credentials selected for
       access control purposes. The user agent continues to send all DDAACCSS HTTP
       cookies as usual, but ddaaccss__aaccss((88))[2] will ignore disabled identities
       before deciding to grant or deny access. This feature can be used to
       work around the maximum number of identities that DDAACCSS allows to be
       associated with a request - determined by the AACCSS__CCRREEDDEENNTTIIAALLSS__LLIIMMIITT[3]
       directive - or for administrative, testing, or other reasons. There are
       similarities between ddaaccss__sseelleecctt__ccrreeddeennttiiaallss and ssuu((11))[4].

       A selected identity is handled normally, but a disabled identity is
       "hidden"; it is not considered for access control purposes and is not
       reported by ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[5]. A disabled identity may be
       re-enabled by ddaaccss__sseelleecctt__ccrreeddeennttiiaallss, however, and ddaaccss__ssiiggnnoouutt((88))[6]
       will work with disabled identities. All identities are considered for
       the purposes of revoking access, however, and in other situations
       described below.

       The selected credentials are identified by a cryptographically
       protected cookie that is issued by ddaaccss__sseelleecctt__ccrreeddeennttiiaallss. The HTTP
       cookie name has the following format:

           DACS:_F_e_d_e_r_a_t_i_o_n_-_N_a_m_e:::SELECTED

       where _F_e_d_e_r_a_t_i_o_n_-_N_a_m_e is the official name assigned to the federation
       for which the cookie is valid. This cookie confers no identity or
       access control rights to its possessor. If this cookie is deleted, or
       just not sent with a request, all credentials accompanying the request
       are used for access control. If ddaaccss__ssiiggnnoouutt((88))[6] asks the browser to
       delete all credentials (i.e., no more credentials exist that
       ddaaccss__ssiiggnnoouutt is aware of), it will also ask the browser to delete the
       selected credentials cookie.

       The _F_O_R_M_A_T argument (see ddaaccss((11))[7]) determines the type of output,
       with the default being HTML, using the style sheet
       ddaaccss__sseelleecctt__ccrreeddeennttiiaallss..ccssss[8]. If XML output is selected, a document
       conforming to ddaaccss__sseelleecctt__ccrreeddeennttiiaallss..ddttdd[9] is returned.

OOPPTTIIOONNSS
   WWeebb SSeerrvviiccee AArrgguummeennttss
       ddaaccss__sseelleecctt__ccrreeddeennttiiaallss accepts the following arguments in addition to
       the ssttaannddaarrdd CCGGII aarrgguummeennttss[10].

       _O_P_E_R_A_T_I_O_N
           This parameter is required and must be one of (case-insensitively):

           SELECT
               This operation replaces the current set of selected
               credentials, if any, with the set that match the _D_A_C_S___U_S_E_R_N_A_M_E
               and _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N arguments. It is an error if no
               credentials match the arguments.

           DESELECT
               This operation disables the specified enabled credentials. If
               no credentials remain selected, the user is effectively
               unauthenticated as if by the _S_E_L_E_C_T___U_N_A_U_T_H operation.
               Non-matching arguments are ignored.

           ADD
               The _A_D_D operation adds the specified disabled credentials to
               the set of enabled credentials.

           LIST
               This operation lists the selection status.

           CLEAR
               This operation results in no selection, with all credentials
               available again.

           SELECT_UNAUTH
               This operation makes the user effectively unauthenticated; all
               credentials are disabled.

           DESELECT_UNAUTH
               This operation reverses _S_E_L_E_C_T___U_N_A_U_T_H, resulting in there being
               no selection and all credentials are again available. It is an
               error if the user is not effectively unauthenticated when the
               operation is invoked.


       _D_A_C_S___U_S_E_R_N_A_M_E
           This argument specifies a username to match against existing
           credentials for the SELECT, DESELECT, and ADD operations. Exact
           string matching is used. If this argument is absent, all usernames
           will be selected.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           This argument specifies a jurisdiction name to match against
           existing credentials for the SELECT, DESELECT, and ADD operations.
           Exact string matching is used. If this argument is absent, all
           jurisdictions will be selected.

       _C_O_O_K_I_E___S_Y_N_T_A_X
           This parameter has the same semantics as with the
           ddaaccss__aauutthheennttiiccaattee((88))[11] service.

           TTiipp
           The ddaaccss__aauutthheennttiiccaattee((88))[12] web service takes an optional
           argument, _O_P_E_R_A_T_I_O_N, that can have the value SELECT. If
           authentication succeeds and this argument is present, the resulting
           credentials are selected as described above.

FFIILLEESS
       ddaaccss__sseelleecctt__ccrreeddeennttiiaallss..ccssss[8]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       It might be useful to be able to temporarily suppress one or more
       specific roles of a given identity.

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[13])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[14] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        3. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_CREDENTIALS_LIMIT

        4. su(1)
           http://www.freebsd.org/cgi/man.cgi?query=su&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

        5. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

        6. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

        7. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        8. dacs_select_credentials.css
           http://dacs.dss.ca/man//css/dacs_select_credentials.css

        9. dacs_select_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_select_credentials.dtd

       10. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       11. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#COOKIE_SYNTAX

       12. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       13. www.dss.ca
           http://www.dss.ca

       14. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012           DACS_SELECT_CREDENTI(8)
