DACS.QUICK(7)           DACS Miscellaneous Information           DACS.QUICK(7)



NNAAMMEE
       dacs.quick - DDAACCSS Quick Start Tutorial

DDEESSCCRRIIPPTTIIOONN
       The purpose of DDAACCSS Quick Start is to explain, step-by-step, how to
       configure a very basic DDAACCSS-enabled web site from scratch so that you
       can try DDAACCSS with minimal effort. We hope that by performing the entire
       example configuration yourself, you will gain a better understanding of
       how DDAACCSS works and how to go about configuring it to meet your needs.
       By following along with some simple examples, you will create a
       completely stand-alone, single jurisdiction DDAACCSS federation on one of
       your hosts. You will become familiar with some of the DDAACCSS utilities
       and web services. When you are done, you can simply delete a few
       directories to uninstall everything. The tutorial should take about 30
       minutes to complete the first time.

       This tutorial will be useful for those who want Those upgrading from
       pre-1.4 releases of DDAACCSS may benefit from Quick Start by noticing
       important changes in DDAACCSS 1.4, thereby easing the transition. After
       successfully completing Quick Start, you should understand DDAACCSS well
       enough that you can proceed to experiment with configuration and
       features, and perhaps use the example configuration as a starting point
       to meet your requirements.

       We do not provide much background or technical information about DDAACCSS
       here, or tell you how to set up a fully functional, production-quality
       DDAACCSS system. You may find it worthwhile to review the FFAAQQ[1] before
       beginning, but if you're itching to get started right away you may do
       so. For technical details, please refer to the mmaannuuaall ppaaggeess[2] and
       other documentation.

       We assume that you've got some hands-on experience configuring and
       using AAppaacchhee, although Quick Start tells you exactly what to do.  _T_o
       _a_v_o_i_d _f_r_u_s_t_r_a_t_i_n_g _p_r_o_b_l_e_m_s_, _w_e _r_e_c_o_m_m_e_n_d _t_h_a_t _y_o_u _r_e_s_i_s_t _t_h_e _t_e_m_p_t_a_t_i_o_n
       _t_o _s_t_r_a_y _f_r_o_m _t_h_e _i_n_s_t_r_u_c_t_i_o_n_s _e_x_c_e_p_t _a_s _i_n_d_i_c_a_t_e_d. Experienced AAppaacchhee
       administrators may recognize the opportunity for some shortcuts, but
       since we're trying to keep things simple for a wide audience, we'd
       rather not get sidetracked by mentioning them. Likewise, experienced
       DDAACCSS administrators may recognize alternative ways - maybe even better
       ways - of doing things. But our goal is to get beginners started
       quickly, so we'll progress in small steps, explaining what is being
       done, and providing assurance that everything is correct so far. That
       way if you run into a problem, you should be able to isolate and fix it
       more easily.

       We'll assume that you've already obtained the latest version of DDAACCSS,
       unpacked it, and at least skimmed through ddaaccss..rreeaaddmmee((77))[3] and
       ddaaccss..iinnssttaallll((77))[4]. The document you are reading should have come from
       that version of DDAACCSS.

           NNoottee
            1. You will be installing and configuring a basic AAppaacchhee server
               (hhttttppdd) as part of this tutorial. You may perform this
               installation on your desktop Unix host or on a host other than
               your desktop, such as a remote server. You will find the former
               somewhat easier and safer to do, so it is recommended when
               possible. If doing the installation on a particular host may
               expose the tutorial's web server to requests from the Internet,
               be sure to carefully consider the security implications and
               take appropriate precautions before proceeding. Nothing in the
               tutorial ought to make the host running the web server more
               vulnerable, but if you experiment with DDAACCSS on your own there
               could be unintended consequences. It is probably a good idea to
               stop AAppaacchhee when you are no longer using it.

            2. You will find it much easier to follow along if you use the
               HTML version of this document because it includes links that
               save you from having to type examples. Obviously these links
               will only work if you have configured the tutorial's
               environment. Some links from this document to other
               documentation point at the tutorial environment, so they will
               not function if that environment is not available. Also, your
               web browser must be capable of handling cookies and have that
               feature enabled.

            3. Make sure that this document came with the DDAACCSS release that
               you are working with.

            4. The Quick Start procedure has been performed successfully on
               FreeBSD and CentOS Linux, but we expect it to work on most
               Unix-like systems. If you run into a problem, you should not
               proceed until you have fixed it.

            5. Depending on your environment, some tasks may need to be done
               as root (in particular, editing /etc/hosts, setting file
               ownership and permissions, and each "make install"). No program
               or web service used in the examples needs to run as root.
               Except for one or two optional DDAACCSS web services, none of the
               DDAACCSS web services needs to run set-uid or set-gid.

            6. Ordinarily, all DDAACCSS-related network communication _m_u_s_t be done
               over SSL. Setting up SSL appropriately is primarily aann AAppaacchhee
               ccoonnffiigguurraattiioonn ttaasskk[5], requiring a server certificate; anyone
               who has done this before will likely understand what needs to
               be done after completing Quick Start. To help keep this
               document simpler and because our goal is not to create a
               production-quality DDAACCSS installation, we will neither use SSL
               in the examples nor mention SSL again.

            7. It's a challenge to write instructions that will work
               everywhere, everytime, for everyone, so please accept our
               apologies for any deficiencies in this document. We are keen to
               improve it, so if you encounter any problems while trying this
               tutorial, or if you have any questions, please ccoonnttaacctt uuss[6].
               Our goal is to make it as easy as possible to get started with
               DDAACCSS.


       Quick Start Steps:

        1. Step 1: Install required third-party packages

        2. Step 2: Install and configure Apache

        3. Step 3: Build and install DACS

        4. Step 4: DACS-enable Apache

        5. Step 5: Do basic DACS configuration

        6. Step 6: Do basic Apache configuration for DACS

        7. Step 7: Test basic DACS services

        8. Step 8: Try DACS authentication

        9. Step 9: DACS-wrapping a web service

       10. Step 10: What's next?

       11. Step 11: Clean up

   SStteepp 11:: IInnssttaallll rreeqquuiirreedd tthhiirrdd--ppaarrttyy ppaacckkaaggeess
       Obtain the versions of AAppaacchhee[7], OOppeennSSSSLL[8], and EExxppaatt[9] that are
       specified in ddaaccss..iinnssttaallll((77))[4]. The instructions here assume that
       AAppaacchhee 2.0 is being used; you can use 2.2 if you are able to adapt the
       instructions on your own.

       For the purposes of this exercise, those are the only third-party
       packages that you need, other than ggmmaakkee, GGCCCC, and the usual software
       development tools. Install OOppeennSSSSLL and EExxppaatt now; we will deal with
       AAppaacchhee in the next step.

           NNoottee
           We will assume that these packages are installed under /usr/local.
           In the examples below, be sure to adjust paths appropriately for
           your environment.

           Some administrators prefer to use a particular file extension, such
           as ".cgi", for CGI executables. The easiest way to make DDAACCSS
           accomodate this is to pass the ----wwiitthh--ccggii--ssuuffffiixx flag to ccoonnffiigguurree
           (see ddaaccss..iinnssttaallll((77))[4]). This results in the configuration
           variable _$_{_C_o_n_f_:_:_d_a_c_s___c_g_i___b_i_n___s_u_f_f_i_x_} being set to the suffix. In
           this document, we will assume that no special file extension is
           required.

   SStteepp 22:: IInnssttaallll aanndd ccoonnffiigguurree AAppaacchhee
       Because you probably do not want to use a production web server for
       this exercise, so that we're on the same page to begin with, and to
       make it easier for you to clean up later, we'll build and install a
       fresh AAppaacchhee server. It will be best if you start from scratch by
       unpacking an AAppaacchhee distribution into a new directory, building and
       installing it, and then verifying that the default AAppaacchhee configuration
       works. We will install this AAppaacchhee in /usr/local/apache-dacs so that it
       does not interfere with anything already on your system - you may
       change this path, but remember to make appropriate changes to the
       instructions that follow.

        1. From the root of the AAppaacchhee distribution, build AAppaacchhee. Review the
           AAppaacchhee INSTALL file. You will run commands like the following
           (again, adjust the paths for your environment):

               % ./configure --enable-ssl --with-ssl=/usr/local/ssl \
                    --prefix=/usr/local/apache-dacs
               % make
               % make install

           Do not configure any AAppaacchhee modules or customizations. We want to
           create a vanilla web server. The path /usr/local/apache-dacs is
           being used to avoid any existing AAppaacchhee installation; when you are
           finished with the tutorial, you will remove this directory.

        2. We will soon configure a virtual host for a (fake) domain name that
           we have reserved for this purpose, but first we must make
           dodgers.dacstest.dss.ca an alias for the host that will run hhttttppdd.
           Choose one of the following two options:

            1. If you are installing AAppaacchhee on the same machine from which you
               are running your web browser, edit /etc/hosts as follows:

                   127.0.0.1     localhost dodgers.dacstest.dss.ca


            2. If you will be running your browser on a host different from
               where AAppaacchhee is running, you will need to add an alias in
               /etc/hosts for that host's IP address _o_n _b_o_t_h _m_a_c_h_i_n_e_s. The
               entry will have the format:

                   _h_o_s_t_i_p       _h_o_s_t_n_a_m_e dodgers.dacstest.dss.ca

               For example, on my system I used:

                   10.0.0.5     bsd5.dss.ca bsd5 dodgers.dacstest.dss.ca


                   NNootteess
                    1. If your desktop is a Windows platform rather than
                       Unix-based, you will need to edit
                       C:\Windows\system32\drivers\etc\hosts or
                       C:\WINNT\system32\drivers\etc\hosts (or similar)
                       instead of /etc/hosts.

                    2. You can use the domain dodgers.dacstest.dss.ca and the
                       others in this document no matter where your host is
                       located. These domain names will not be visible outside
                       of the hosts on which you define them by hand.

                    3. After you have completed this exercise, please remember
                       to delete the aliases.
                   To verify the change, use ppiinngg:

                       % ping dodgers.dacstest.dss.ca

                   (You may need to run it as /sbin/ping or something similar
                   on your system.)

                3. We need to make a few changes to AAppaacchhee''ss default
                   configuration, in case you are already running a web server
                   on this machine and as a first step towards some
                   customization that we will need shortly. We will add a
                   virtual host definition and do some initial set up for
                   DDAACCSS. Edit /usr/local/apache-dacs/conf/httpd.conf, advance
                   to the bottom of the file, and insert the text that appears
                   below:

                       # Permit access to the DACS documents
                       <Directory /usr/local/dacs/www/*>
                         Options Indexes FollowSymLinks
                         Order allow,deny
                         Allow from all
                       </Directory>

                       # Configure a virtual host and make the DACS documents available
                       NameVirtualHost 127.0.0.1:18123
                       Listen 127.0.0.1:18123
                       <VirtualHost 127.0.0.1:18123>
                         ServerName dodgers.dacstest.dss.ca
                         DocumentRoot "/usr/local/apache-dacs/htdocs"
                         ErrorLog     "/usr/local/apache-dacs/logs/error_log"
                         TransferLog  "/usr/local/apache-dacs/logs/access_log"
                         ScriptAlias /cgi-bin/ "/usr/local/apache-dacs/cgi-bin/"

                         Alias /css       "/usr/local/dacs/www/css/"
                         Alias /dacs      "/usr/local/dacs/www/"
                         Alias /dtd-xsd   "/usr/local/dacs/www/dtd-xsd/"
                         Alias /examples  "/usr/local/dacs/www/examples/"
                         Alias /handlers  "/usr/local/dacs/www/handlers/"
                         Alias /infocards "/usr/local/dacs/www/infocards/"
                         Alias /man       "/usr/local/dacs/www/man/"
                         Alias /misc      "/usr/local/dacs/www/misc/"
                         Alias /mod       "/usr/local/dacs/www/mod/"
                       </VirtualHost>

                   As discussed earlier, if necessary, replace each occurrence
                   of 127.0.0.1 with the _h_o_s_t_i_p. Or, use a configuration like:

                       ...
                       NameVirtualHost 127.0.0.1:18123
                       NameVirtualHost _h_o_s_t_i_p:18123
                       Listen 127.0.0.1:18123
                       Listen _h_o_s_t_i_p:18123
                       <VirtualHost 127.0.0.1:18123 _h_o_s_t_i_p:18123>
                       ...

                   This VViirrttuuaallHHoosstt[10] section is going to correspond to the
                   DDAACCSS jurisdiction that we will define shortly. The purpose
                   of the DDiirreeccttoorryy[11] and AAlliiaass[12] directives is to make
                   various web resources available without having to copy them
                   under your DDooccuummeennttRRoooott[13].

                       NNoottee
                        1. In our examples, we use port 18123, which we're
                           guessing is unlikely to already be in use on your
                           machine. If you are unlucky and it is in use,
                           AAppaacchhee will complain when you start it and you will
                           obviously need to select a different port number.
                           So that the examples will continue to work,
                           consider creating a copy of this document and
                           changing all occurrences of "18123" to the port
                           number you have selected. If available, commands
                           such as nneettssttaatt((11))[14] and ssoocckkssttaatt((11))[15] can tell
                           you which ports are currently in use. In the event
                           that you will be accessing your server from the
                           other side of a firewall (which is not recommended,
                           as previously mentioned), keep in mind that traffic
                           may not ordinarily be passed through on this port.

                        2. If you are already running AAppaacchhee on port 80 (the
                           default) or if you are not root whenever you run
                           aappaacchheeccttll in any of the following steps, you must
                           comment out (or delete) all LLiisstteenn[16] directives
                           for port 80 in httpd.conf. Therefore, comment out
                           all directives that look like any of the following:

                               Listen 80
                               Listen 0.0.0.0:80
                               Listen [::]:80


                    4. It is good practice to run hhttttppdd as an unprivileged
                       user id and AAppaacchhee does this by default through the
                       UUsseerr[17] directive in httpd.conf:

                           User nobody


                       DDAACCSS web services are run as the same user id as hhttttppdd,
                       but they must be able to read and sometimes write files
                       within the DDAACCSS installation directory. These files
                       should not be readable or writable by other processes
                       or anyone other than a DDAACCSS administrator. Using
                       mmoodd__ssuueexxeecc[18] is one approach, but for the purpose of
                       this tutorial we want to keep things simple. Note that
                       setting UUsseerr[17] (or GGrroouupp[19]) to root is not a good
                       idea.

                       The AAppaacchhee documentation recommends setting up a new
                       group specifically for running the server, and we will
                       take this approach. We will assume in our examples that
                       this group is called www. You may need to create this
                       group (see ggrroouupp((55))[20]) or you may already have a
                       different but suitable group name to use (e.g.,
                       webservd). Whatever group name you choose, when DDAACCSS is
                       installed in the next step you will be prompted for
                       this group id and you must make the appropriate change
                       to httpd.conf:

                           Group www


                           NNoottee
                           Because we will refer to this group name often in
                           later steps, save its name as the value of the
                           shell variable _d_a_c_s_g_r_o_u_p (we will use ccsshh/ttccsshh
                           syntax - use the syntax preferred by your shell):

                               % set dacsgroup=www
                       Change the group id of files in the AAppaacchhee installation
                       directory to this group and adjust permissions (you may
                       have to do this as root):

                           % chgrp -R $dacsgroup /usr/local/apache-dacs
                           % chmod -R g+w /usr/local/apache-dacs


                    5. Start your httpd...

                           % /usr/local/apache-dacs/bin/apachectl start


                    6. Use your favourite browser to verify that AAppaacchhee is
                       serving content:

                           hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233


                    7. You should now check that your hhttttppdd was built
                       properly. First, make sure that tteesstt--ccggii is executable
                       (a CGI that is installed by AAppaacchhee):

                           % chmod 0750 /usr/local/apache-dacs/cgi-bin/test-cgi

                       And then invoke it:

                           hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//tteesstt--ccggii

                       Look for the _S_E_R_V_E_R___S_O_F_T_W_A_R_E variable in its output and
                       ensure that its value shows the correct versions of
                       AAppaacchhee, mmoodd__ssssll, and OOppeennSSSSLL; if you find something
                       unexpected, you probably didn't configure and/or
                       install AAppaacchhee or OOppeennSSSSLL correctly.

                    8. You have confirmed that AAppaacchhee is properly installed,
                       so stop the web server:

                           % /usr/local/apache-dacs/bin/apachectl stop


   SStteepp 33:: BBuuiilldd aanndd iinnssttaallll DDAACCSS
       Now it is time to build and install the DDAACCSS utilities and web
       services. Make your working directory the src subdirectory of the DDAACCSS
       distribution.

        1. Build and install DDAACCSS web services and utilities (note: ggmmaakkee is
           the GNU Make utility, which you must use):

               % ./configure --prefix=/usr/local/dacs --disable-shared \
                  --enable-static --enable-passwd-auth \
                  --disable-bdb --with-apache=/usr/local/apache-dacs \
                  --with-expat=/usr/local
               % gmake

           If all goes well,

               % gmake install

           You will be prompted for the user id and group id to be used for
           DDAACCSS files and directories. The group id you give should match the
           value you used for AAppaacchhee''ss Group directive (that is, the value of
           _$_d_a_c_s_g_r_o_u_p). The user id can be your user id. You will need to do
           gmake install as root if your account has insufficient privileges
           to set the user and group ids that you specify. The installation
           procedure will remember your answers to the prompts; if you make a
           mistake or want to change them, do:

               % conftools/setaccess-sh reset

           and try gmake install again.

   SStteepp 44:: DDAACCSS--eennaabbllee AAppaacchhee
       We'll continue by installing the mmoodd__aauutthh__ddaaccss[21] module for AAppaacchhee.
       Make your working directory the apache subdirectory of the DDAACCSS
       distribution.

        1. Compile and install the mmoodd__aauutthh__ddaaccss module:

               % gmake tag
               % gmake install

           If this succeeds, your AAppaacchhee hhttttppdd..ccoonnff[22] file should now
           contain the following directive:

               LoadModule auth_dacs_module modules/mod_auth_dacs.so

           Please check that this is so. If you cannot find that directive,
           add it manually near the part of httpd.conf that talks about the
           LLooaaddMMoodduullee[23] directive.

        2. Start AAppaacchhee again:



               % /usr/local/apache-dacs/bin/apachectl start

           and take another look at the _S_E_R_V_E_R___S_O_F_T_W_A_R_E variable, this time
           using the DDAACCSS web service ddaaccss__pprreennvv, which displays its
           environment:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__pprreennvv[24]

           The _S_E_R_V_E_R___S_O_F_T_W_A_R_E variable ought to look the same as before,
           except it should now also mention mmoodd__aauutthh__ddaaccss.

           Congratulations - you are now running a DDAACCSS-enabled web server!
           DDAACCSS is not configured to do anything at the moment, mind you, but
           your web server is now capable of DDAACCSS-wrapping web services. You
           should be able to view the DDAACCSS manual pages served from the web
           server you just installed:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//mmaann


   SStteepp 55:: DDoo bbaassiicc DDAACCSS ccoonnffiigguurraattiioonn
       Although your AAppaacchhee is now DDAACCSS-enabled, a little more configuration
       of both DDAACCSS and AAppaacchhee are necessary before you can do anything
       interesting. We'll continue by working with the DDAACCSS configuration (see
       ddaaccss..ccoonnff((55))[25]).

       We begin this step by defining a new DDAACCSS federation that consists of
       one jurisdiction. We will call the new federation DACSTEST and
       associate it with the domain name dacstest.dss.ca. We will call our
       jurisdiction LA. Incidentally, the names that we are using in this
       tutorial for our federation and jurisdiction ("DACSTEST", "LA", and
       "dacstest.dss.ca") are not "special"; there's an underlying theme that
       should be apparent to any baseball fan but we could have chosen any
       syntactically valid names. The domain name for our jurisdiction
       (dodgers.dacstest.dss.ca) is only special in that it is a subdomain of
       dacstest.dss.ca; this must be the case for all jurisdictions in our
       example federation.

           SSeeccuurriittyy
           All of the files and directories that we create in this and future
           steps must be readable by DDAACCSS web services. This means that they
           must have their group ownership set to _$_d_a_c_s_g_r_o_u_p and have group
           read and write permissions, as discussed earlier.

       We're going to be using a few long pathnames in this step and later on,
       so to help unclutter the instructions, and for your convenience, we
       will represent them as shell variables. For example, the pathname
       /usr/local/dacs/federations will be referred to as $feds and the
       pathname $feds/dacstest.dss.ca/LA will be $la. You may find it useful
       at this time to define the following variables in your shell using the
       particular syntax it prefers (we use ttccsshh):

           % set dacs=/usr/local/dacs
           % set bin=$dacs/bin
           % set feds=$dacs/federations
           % set la=$feds/dacstest.dss.ca/LA


           TTiipp
           At this point you can use the ddaaccssiinniitt((11))[26] program, found in the
           distribution's src directory, to perform the operations in this
           step for you. By default, the program uses the default paths that
           were established when DDAACCSS was built and the example paths used in
           this step. When prompted, simply use the ddaaccssiinniitt default values
           (just hit Return/Enter), which should result in the same
           configuration as you would obtain by manually following the
           directions in this step.

           You can also use ddaaccssiinniitt to create a configuration for a
           federation with one very basic jurisdiction based on names of your
           choosing. You can later extend or customize this configuration
           manually. Also see IInniittiiaall CCoonnffiigguurraattiioonn[27].

        1. Although you can get away with having a single DDAACCSS configuration
           file on a host, we recommend a hierarchical organization. The file
           site.conf, although optional, holds standard default configuration
           directives as well as site-specific directives for all federations
           configured on this host. One or more files named dacs.conf can be
           used on a per-jurisdiction, per-federation, or per-host basis; that
           is, each jurisdiction on a host can have its own dacs.conf, or all
           (or some) of the jurisdictions on a host can share a dacs.conf, or
           everything can just be lumped into one dacs.conf. It's entirely up
           to you.

           When ccoonnffiigguurree is run to build DDAACCSS, you can specify default
           locations for various configuration files, including site.conf and
           dacs.conf. We did not change the defaults when we built DDAACCSS, so
           our examples will use the default paths.

               TTiipp
               We recommend that you always use the site.conf-std that comes
               with your DDAACCSS distribution as your site.conf file and that you
               do not make any modifications to it, instead putting
               customizations in your dacs.conf file. This will make upgrades
               easier and less error-prone.
           Proceed by installing the default site configuration file as
           $feds/site.conf:

               % install -c -g $dacsgroup -m 0640 $feds/site.conf-std $feds/site.conf


               NNoottee
               If the iinnssttaallll command is unavailable on your system, you can
               use src/conftools/install-sh relative to your DDAACCSS distribution
               directory. Or just use ccpp (or mmkkddiirr), cchhggrrpp, and cchhmmoodd.

        2. Since we are not using SSL in this tutorial, edit $feds/site.conf
           and change the value of the SSEECCUURREE__MMOODDEE[28] directive to "off". For
           production use, the directive's value should always be "on":

               SECURE_MODE "off"


        3. It is convenient - though not required - to collect the
           configuration directives for all jurisdictions on this host in a
           single file. It's not unusual for a host to be associated with just
           one jurisdiction (and one federation), but this is certainly not
           always the case.

               % install -c -g $dacsgroup -m 0660 /dev/null $feds/dacs.conf


        4. We will create a directory where most of the files associated with
           our new federation will live:

               % install -d -g $dacsgroup -m 0770 $feds/dacstest.dss.ca


        5. And a subdirectory within it where most of the files associated
           with our new jurisdiction will live:

               % install -d -g $dacsgroup -m 0770 $la


        6. Create a directory where we will put access control rules (also
           called ACLs, access control lists, or simply rules) for our
           jurisdiction, and we also need an empty revocation file:

               % install -d -g $dacsgroup -m 0770 $la/acls
               % install -c -g $dacsgroup -m 0660 /dev/null $la/acls/revocations


        7. Create directories where we will put group definitions for our
           jurisdiction and define the membership of our federation:

               % install -d -g $dacsgroup -m 0770 $la/groups $la/groups/LA $la/groups/DACS
               % install -c -g $dacsgroup -m 0660 /dev/null $la/groups/DACS/jurisdictions.grp

           Paste the following text into $la/groups/DACS/jurisdictions.grp:

               <groups xmlns="http://dss.ca/dacs/v1.4">
                <group_definition jurisdiction="LA" name="jurisdictions"
                    mod_date="Tue, 14-Jun-2005 16:06:00 GMT" type="public">
                  <group_member jurisdiction="LA" name="LA Jurisdiction" type="meta"
                    alt_name="Test Jurisdiction for the LA Dodgers"
                    dacs_url="http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs"
                    authenticates="yes" prompts="no"/>
                </group_definition>
               </groups>

           (Change 18123 if you are using a different port.) The purpose of
           jurisdictions.grp is to provide DDAACCSS with information about the
           jurisdictions in this federation. All jurisdictions in a federation
           should use identical jurisdictions.grp files. We're not going to
           make much use of this in this document, but if you add a
           jurisdiction or if any of this information changes, this file would
           ordinarily be updated. For instance, if you were to add a
           jurisdiction to your federation, you should add another
           group_member element to the group_definition that describes the new
           jurisdiction, and then copy the updated jurisdictions.grp file to
           each jurisdiction. Please see ddaaccss..ggrroouuppss((55))[29] for additional
           information.

        8. We need some basic configuration directives for the jurisdiction
           LA. Paste the following text into $feds/dacs.conf:

               <Configuration xmlns="http://dss.ca/dacs/v1.4">

                <Default>
                  FEDERATION_DOMAIN "dacstest.dss.ca"
                  FEDERATION_NAME "DACSTEST"
                  LOG_LEVEL "info"
                </Default>

                <Jurisdiction uri="dodgers.dacstest.dss.ca">
                  JURISDICTION_NAME "LA"
                </Jurisdiction>

               </Configuration>


        9. And let's make this the default configuration file for DDAACCSS
           jurisdictions at this site:

               % rm -f $la/dacs.conf
               % ln -s $feds/dacs.conf $la/dacs.conf


       10. Now, let's ask DDAACCSS to display its configuration by running the
           ddaaccssccoonnff((11))[30] utility:

               % $bin/dacsconf -uj LA -q

           This configuration is the result of merging the contents of
           $la/dacs.conf (which points to $feds/dacs.conf) and
           $feds/site.conf, with directives in the former file overriding
           directives in the latter.

       11. We must create encryption keys for this federation using the
           ddaaccsskkeeyy((11))[31] utility:

               % install -c -g $dacsgroup -m 0640 /dev/null $feds/dacstest.dss.ca/federation_keyfile
               % $bin/dacskey -uj LA -q $feds/dacstest.dss.ca/federation_keyfile
               % ls -l $feds/dacstest.dss.ca/federation_keyfile

           We could not do this until after the jurisdiction had been
           configured because ddaaccsskkeeyy needs to look at dacs.conf.

               SSeeccuurriittyy
               _T_h_e _f_e_d_e_r_a_t_i_o_n _k_e_y _f_i_l_e _m_u_s_t _b_e _k_e_p_t _s_e_c_r_e_t. Any person or
               process that can read the federation key file can create DDAACCSS
               identities. It should be readable _o_n_l_y by its owner and DDAACCSS
               and _n_o_t readable by anyone else.

       12. Similarly, we should create encryption keys for our jurisdiction:

               % install -c -g $dacsgroup -m 0640 /dev/null $la/jurisdiction_keyfile
               % $bin/dacskey -uj LA -q $la/jurisdiction_keyfile
               % ls -l $la/jurisdiction_keyfile

           Like the federation keys, these keys must also be kept secret. But
           the jurisdiction keys are private to their jurisdiction and are not
           shared among federation members.

       13. Make sure that all of the files and directories starting with
           /usr/local/dacs have appropriate permissions, as discussed earlier.

           NNoottee
           If you modify httpd.conf you must restart AAppaacchhee for the changes to
           take effect. If you modify dacs.conf, site.conf, or any other DDAACCSS
           configuration file, the changes take effect immediately and do not
           require restarting AAppaacchhee.

   SStteepp 66:: DDoo bbaassiicc AAppaacchhee ccoonnffiigguurraattiioonn ffoorr DDAACCSS
       Your AAppaacchhee is now DDAACCSS-enabled and we've configured DDAACCSS. Before we
       can do anything interesting we must make some changes to the AAppaacchhee
       configuration. We will begin by DDAACCSS-wrapping DDAACCSS web services, which
       is required.

        1. Edit /usr/local/apache-dacs/conf/httpd.conf and locate the
           VViirrttuuaallHHoosstt[10] section that you added earlier. Inside that
           VirtualHost section and near its end, add the following text
           (remember to adjust paths as necessary):

               AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"
               SetDACSAuthMethod dacs-acs external
               SetDACSAuthConf dacs-acs "/usr/local/dacs/federations/dacs.conf"

               <Location /cgi-bin/dacs>
                 AllowOverride AuthConfig
                 Require valid-user
                 Options ExecCGI
                 AuthType DACS
                 AuthDACS dacs-acs
               </Location>

           These directives configure the virtual host to DDAACCSS-wrap the
           contents of all URLs that fall under the /cgi-bin/dacs namespace.
           The first three directives tell mmoodd__aauutthh__ddaaccss where to find the
           external DDAACCSS access control program (ddaaccss__aaccss((88))[32]) and the DDAACCSS
           configuration file.

        2. Restart AAppaacchhee so that it uses its new configuration:

               % /usr/local/apache-dacs/bin/apachectl restart


           DDAACCSS should now be enforcing access control on the /cgi-bin/dacs
           part of the server's URL space.

        3. Check that you can still access tteesstt--ccggii (which you have not
           DDAACCSS-wrapped):

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//tteesstt--ccggii


        4. Now, let's see what happens when we try to access ddaaccss__pprreennvv:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__pprreennvv[24]

           You should get a "403 Forbidden" error, which will cause DDAACCSS to
           display an "Access Denied by DACS" page (actually, it is the
           contents of the file /usr/local/dacs/www/handlers/acs_failed.html).
           This happens because the default rules do not grant access to
           ddaaccss__pprreennvv, so all access will be denied.

        5. To finish up this step, let's add a rule that will grant everyone
           access to ddaaccss__pprreennvv. Create $la/acls/acl-prenv.0 with appropriate
           permissions:

               % install -c -g $dacsgroup -m 0660 /dev/null $la/acls/acl-prenv.0

           and then paste the following text into it:

               <acl_rule status="enabled">
                 <services>
                   <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_prenv${Conf::dacs_cgi_bin_suffix}"'/>
                 </services>

                 <rule order="allow,deny">
                   <allow>
                     user("any")
                   </allow>
                 </rule>
               </acl_rule>

           Whenever you add or change an access rule, you must rebuild the
           rule index for the jurisdiction:

               % dacsacl -uj LA

           (It's currently only really necessary to run ddaaccssaaccll if you add a
           rule or modify any part of a rule's services element, but this may
           change in a future release so just do it always.)

           This rule grants everyone access, so invoking ddaaccss__pprreennvv should
           work now:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__pprreennvv[24]

           This output includes some new environment variables that are passed
           to all DDAACCSS-wrapped programs. These variables begin with "DACS_",
           such as DDAACCSS__VVEERRSSIIOONN - see ddaaccss__aaccss((88))[33] for additional
           information.

   SStteepp 77:: TTeesstt bbaassiicc DDAACCSS sseerrvviicceess
       There's still not too much you can do at this point, but there are a
       few DDAACCSS services that you can try. If one of these requests fails,
       take a look at the DDAACCSS log files in the /usr/local/dacs/logs directory
       for clues. The most likely cause is incorrect permissions on a file or
       directory, or possibly you made an editing mistake.

        1. The ddaaccss__vveerrssiioonn((88))[34] web service displays various version
           information, naturally enough:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__vveerrssiioonn


        2. The ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[35] web service displays information
           about jurisdictions:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__lliisstt__jjuurriissddiiccttiioonnss

           You may recognize some of this material from the jurisdictions.grp
           file.

        3. We saw the ccoonnff utility earlier. We can get the same information
           from a web service:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__ccoonnff

           Ooops! You should have been denied access to this web service. If
           you examine the default ACL (see ddaaccss..aaccllss((55))[36]) for this web
           service, which can be found in /usr/local/dacs/acls/acl-conf.0, you
           might suspect that access to ddaaccss__ccoonnff will only be granted to
           identities that satisfy the expression "dacs_admin()" (see
           ddaaccss..eexxpprrss((55))[37]). And since you have not established a DDAACCSS
           identity yet, the ACL should deny access. After we do a little more
           DDAACCSS configuration work in the next step, we will give this another
           try.

   SStteepp 88:: TTrryy DDAACCSS aauutthheennttiiccaattiioonn
       It is possible to create "accounts" specifically for DDAACCSS users. These
       identities are managed by the ddaaccssppaasssswwdd((11))[38] utility and are
       "private" in that they are unrelated to any other identities you might
       have on your system, unless you tie them together (similar to AAppaacchhee''ss
       hhttppaasssswwdd[39] command). For example, we can create a DDAACCSS identity named
       "root" that has no relationship to a Unix system's superuser - perhaps
       you are creating a DDAACCSS account for actor SStteepphheenn RRoooott[40].

        1. We begin this step by creating an empty password file for
           ddaaccssppaasssswwdd (to ensure correct permissions). Then we create a DDAACCSS
           account for username "sandy".

               % install -c -g $dacsgroup -m 0660 /dev/null $la/passwd
               % $bin/dacspasswd -uj LA -q -a sandy

           You will be prompted for a password to assign to sandy's account.
           Choose any password you like as long as it is at least six
           characters long. You can change sandy's password by running this
           command again.

        2. Next, we edit $la/dacs.conf and add the following text in the
           Jurisdiction section for dodgers.dacstest.dss.ca:

               <Auth id="passwd">
                  URL \
               "http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/local_passwd_authenticate"
                  STYLE "pass"
                  CONTROL "sufficient"
                </Auth>

           This configuration enables authentication (see
           ddaaccss__aauutthheennttiiccaattee((88))[41]) for accounts managed by the ddaaccssppaasssswwdd
           utility. Check again that all files starting with /usr/local/dacs
           have appropriate permissions, as discussed earlier.

        3. We should now be able to authenticate ("login") as sandy by
           providing the password you set up earlier. If successful, your
           browser will be sent credentials (in an HTTP cookie) for the
           identity DDAACCSS calls LA:sandy. Note that the cookies DDAACCSS creates
           are deleted when your browser exits. Even if a cookie is not
           deleted, DACS credentials have a limited lifetime and will become
           useless when they expire.

           DDAACCSS comes with examples of simple HTML login pages with which you
           can authenticate:

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//eexxaammpplleess//llooggiinn..hhttmmll

           Your browser must have JavaScript enabled to use this page. Select
           the jurisdiction (LA), enter the username (sandy) and password, and
           then click "Login". If all is well, you should see the "DACS
           Authentication Succeeded" page, which is the contents of
           /usr/local/dacs/www/handlers/auth_ok.html. Of course in a
           production environment you would write custom login and signout
           pages, or integrate the functionality with a portal or in whatever
           way you prefer for your site.

        4. Things get a bit more interesting now that you are able to
           authenticate. You can follow one link on the "DACS Authentication
           Succeeded" page to see your current credentials (using
           ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss[42]) or another to visit a page that will
           allow you to signout (ddaaccss__ssiiggnnoouutt((88))[43]) from all or some
           identities (you can also iinnvvookkee ddaaccss__ssiiggnnoouutt ddiirreeccttllyy[44] to
           signout from all identities). If you signout, there will be a link
           that you can follow to login again.

        5. Use ddaaccssppaasssswwdd to create another account:

               % $bin/dacspasswd -uj LA -q -a don

           You can now authenticate as sandy or don. You can also have both
           identities active at the same time (try it)!

        6. Now that you're able to authenticate, let's have another try at
           running ddaaccss__ccoonnff (recall you were not granted access to it
           earlier). We must first make one of the identities that you have
           created a DDAACCSS administrator identity. Edit $la/dacs.conf and add
           the following text in the Jurisdiction section for
           dodgers.dacstest.dss.ca (but _n_o_t within the Auth section):

               ADMIN_IDENTITY "LA:sandy"

           As you might assume, this confers special privileges to LA:sandy.

           Authenticate as sandy using the llooggiinn ppaaggee and then try this link
           again (it should work this time):

               hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__ccoonnff

           If you ssiiggnnoouutt[45] as sandy, then aauutthheennttiiccaattee as don, and try
           hhttttpp::////ddooddggeerrss..ddaaccsstteesstt..ddssss..ccaa::1188112233//ccggii--bbiinn//ddaaccss//ddaaccss__ccoonnff again,
           you should be denied access.

        7. In an earlier step, you created an ACL ($la/acls/acl-prenv.0) that
           grants access to ddaaccss__pprreennvv to any user, whether authenticated or
           not. Edit that rule and replace:

               user("any")

           with:

               user("auth")

           Try invoking ddaaccss__pprreennvv[46] when you are not authenticated - you
           should be denied access. Now authenticate and try ddaaccss__pprreennvv[46]
           again - it should work. Edit the rule again and replace:

               user("auth")

           with:

               user("LA:don")

           Now you should only be granted access if you've authenticated as
           the DDAACCSS username LA:don.

   SStteepp 99:: DDAACCSS--wwrraappppiinngg aa wweebb sseerrvviiccee
       To use DDAACCSS to control access to a resource, there are just a few
       things you need to do:

       +o   Make the URL space in which the resource lies within the scope of a
           LLooccaattiioonn[47] directive for the VirtualHost that corresponds to the
           DDAACCSS jurisdiction responsible for the resource.

       +o   Make an appropriate DDAACCSS access control rule for the jurisdiction
           responsible for the URL space in which the resource lies.

       Basically, you have to configure AAppaacchhee to allow DDAACCSS to perform access
       control for the resource, and you have to configure DDAACCSS to enforce the
       selective access that you want. This is ordinarily both easy to do and
       something that is done infrequently because closely related resources
       are typically grouped together within the URL space you have defined
       (for example, all image files may be collected under /images in the URL
       space, related applications are collected somewhere under /cgi-bin, and
       so on) and because ACLs can be written with wildcard patterns that will
       match everything "under" a given URL space prefix.

           SSeeccuurriittyy
           It is important to verify that all resources that you intend to be
           DDAACCSS-wrapped really are access controlled and that DDAACCSS cannot be
           bypassed (e.g., by using different URLs for the same resource). For
           instance, despite many improvements, getting AAppaacchhee''ss VViirrttuuaall
           HHoossttss[48] configured exactly as you require can be challenging -
           make sure that security cannot be bypassed through selection of a
           particular hostname or port number.

           Also, note that DDAACCSS performs access control on resource names
           rather than on the resources themselves. This means that if a
           particular resource is known by multiple names, because of symbolic
           links, for example, then to correctly manage access to the resource
           all of its names must be DDAACCSS-wrapped.

   SStteepp 1100:: WWhhaatt''ss nneexxtt??
       Having successfully completed all of the previous steps, you should
       have a feel for some of the things that you can do with DDAACCSS. Of
       course, there's much more to DDAACCSS than what we've covered. You should
       be capable of using the system you've configured to this point to try
       some things on your own. Here are a few ideas (in order of increasing
       difficulty):

       +o   Add a DDAACCSS-wrapped resource and experiment with access control
           rules. It might be a static web page or a CGI program. Remember
           that by default, your site-specific ACLs for the jurisdiction LA
           are files in the $la/acls directory. Review ddaaccss..aaccllss((55))[49] before
           beginning.

       +o   Assign a few roles to DDAACCSS user sandy and modify an access control
           rule to consider roles when granting or denying access. Roles
           provide a convenient way to classify users so that access control
           rules can be concisely written to grant (or deny) access to a set
           of users that are related in some way. For example, you might
           assign some users to "students", some to "staff", and some to
           "faculty", and then write rules that reference those roles rather
           than individual DDAACCSS usernames. Roles only have meaning with
           respect to how they are used in ACLs, so you can make up any
           syntactically valid words you want.

           Here are some hints to get you started. You'll need to do two
           things: assign roles to users and enable roles. Once enabled, your
           DDAACCSS will look for roles in the file $la/roles. Each line of that
           file assigns roles to a user and consists of the username, a colon,
           and a comma-separated list of roles. For example:

               sandy:pitchers,retired-players
               don:pitchers,retired-players
               eric:pitchers,active-players
               cesar:infielders,active-players

           The other thing you'll need is some DDAACCSS configuration to enable
           roles. Add the following to the Jurisdiction section of dacs.conf:

               <Roles id="roles">
                 URL "http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/local_roles"
               </Roles>

           Now you can create rules that depend on the user making the request
           having certain roles. For example, a rule can be written to grant
           access to a resource only if the user making the request has the
           role "pitchers" by using the predicate (see ddaaccss..eexxpprrss((55))[50]):

               user("%LA:pitchers")

           Or you can create a rule that will grant access only if the user
           has the roles "active-players" _a_n_d "pitchers"; use the predicate:

               user("%LA:pitchers") and user("%LA:active-players")


       +o   If you create a DDAACCSS account for a username that corresponds to a
           user on your system, you can configure DDAACCSS to assign roles to that
           user based on the Unix groups that she belongs to. This is very
           easy to do: instead of using llooccaall__rroolleess as in the example above,
           use llooccaall__uunniixx__rroolleess instead. If you create a DDAACCSS account for
           alice, for example, and the account "alice" has group membership on
           your system (see group(5)), then alice would authenticate using her
           DDAACCSS password and be assigned roles from her Unix group membership.

           Instead of using a DDAACCSS account to authenticate alice, you can
           easily configure DDAACCSS to use alice's Unix password. The DDAACCSS module
           llooccaall__uunniixx__aauutthheennttiiccaattee, which must be installed set-uid root so
           that it can access passwords, provides this functionality.

       +o   Add a DDAACCSS jurisdiction named NY (yankees.dacstest.dss.ca) on the
           same host where you configured dodgers.dacstest.dss.ca. You do not
           have to configure authentication at the new jurisdiction. Notice
           that you can authenticate at dodgers.dacstest.dss.ca and then
           access resources at yankees.dacstest.dss.ca. This is "single
           sign-on".

       +o   Run DDAACCSS on an additional host. The procedure is basically the same
           as what you already did in this tutorial. Name the jurisdiction
           BOSTON and assign it the domain name redsox.dacstest.dss.ca. You
           won't be able to use the IP address 127.0.0.1 for this; you'll have
           to alias the domain names to the IP addresses of real interfaces
           and make the same changes to /etc/hosts on both hosts. You'll also
           have to use the identical federation_keyfile on both hosts (simply
           copy the file you've already made).

       +o   Configure a different (or additional) authentication method for
           your jurisdiction. See ddaaccss__aauutthheennttiiccaattee((88))[51]. For the password
           style of authentication, you might try the NTLM authentication
           method. For a bit more of a challenge, see if you can make the expr
           or cert style of authentication work.

   SStteepp 1111:: CClleeaann uupp
       If you are done, you may want to do some clean up now. First, stop
       AAppaacchhee:

           % /usr/local/apache-dacs/bin/apachectl stop

       Next, delete dodgers.dacstest.dss.ca and any other domain names you
       created for this exercise from /etc/hosts. Remove
       /usr/local/apache-dacs, /usr/local/dacs, and everything underneath
       them.

   TTrroouubblleesshhoooottiinngg
       The first thing to do if you encounter a problem is to check that
       you've got the latest version of DDAACCSS; a newer version might fix your
       problem. Also, visit the PPoosstt--RReelleeaassee NNootteess[52] area for your release
       in case a newer edition of this document is available or a bug fix has
       been posted.

       By default, the DDAACCSS log files are put in the /usr/local/dacs/logs
       directory. If you encounter any problems or just want to see what's
       going on, examine the log files in that directory. Depending on the
       DDAACCSS LLOOGG__LLEEVVEELL[53] and LLOOGG__FFIILLTTEERR[54] directives in effect, log files
       can quickly become big. It is safe to delete them or truncate them at
       any time.

       In the event of problems, you should also take a look at the AAppaacchhee
       logs (in /usr/local/apache-dacs/logs).

       There are five main sources of problems:

        1. Typos (you got the spelling or punctuation incorrect),

        2. File permissions are incorrect (DDAACCSS cannot read or write its files
           or directories),

        3. You didn't follow the instructions correctly (you skipped something
           or misunderstood something),

        4. You ran into unexpected platform dependencies, or

        5. We goofed.

       If you're sure the problem is either of the last two types, please
       ccoonnttaacctt uuss[6]. and tell us what happened. Be sure to mention which
       steps succeeded and which one failed.

SSEEEE AALLSSOO
       ddaaccss((11))[55], ddaaccssiinniitt((11))[26], ddaaccss..rreeaaddmmee((77))[3], ddaaccss..iinnssttaallll((77))[4]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[56])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[57] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. FAQ
           http://dacs.dss.ca/faq.html

        2. manual pages
           http://dacs.dss.ca/man

        3. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

        4. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        5. an Apache configuration task
           http://httpd.apache.org/docs-2.2/ssl/

        6. contact us
           http://www.dss.ca/contactus.html

        7. Apache
           http://httpd.apache.org

        8. OpenSSL
           http://www.openssl.org

        9. Expat
           http://expat.sourceforge.net

       10. VirtualHost
           http://httpd.apache.org/docs-2.2/mod/core.html#virtualhost

       11. Directory
           http://httpd.apache.org/docs-2.2/mod/core.html#directory

       12. Alias
           http://httpd.apache.org/docs-2.2/mod/mod_alias.html#alias

       13. DocumentRoot
           http://httpd.apache.org/docs-2.2/mod/core.html#documentroot

       14. netstat(1)
           http://www.freebsd.org/cgi/man.cgi?query=netstat&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       15. sockstat(1)
           http://www.freebsd.org/cgi/man.cgi?query=sockstat&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       16. Listen
           http://httpd.apache.org/docs/2.0/mod/mpm_common.html#listen

       17. User
           http://httpd.apache.org/docs-2.2/mod/mpm_common.html#user

       18. mod_suexec
           http://httpd.apache.org/docs-2.2/mod/mod_suexec.html

       19. Group
           http://httpd.apache.org/docs-2.2/mod/mpm_common.html#group

       20. group(5)
           http://www.freebsd.org/cgi/man.cgi?query=group&apropos=0&sektion=5&manpath=FreeBSD+7.2-RELEASE&format=html

       21. mmoodd__aauutthh__ddaaccss
           http://dacs.dss.ca/man/mod_auth_dacs.html

       22. httpd.conf
           file:///usr/local/apache-dacs/conf/httpd.conf

       23. LoadModule
           http://httpd.apache.org/docs-2.2/mod/mod_so.html#loadmodule

       24. http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv?FORMAT=html

       25. dacs.conf(5)
           http://dodgers.dacstest.dss.ca:18123/man/dacs.conf.5.html

       26. dacsinit(1)
           http://dacs.dss.ca/man/dacsinit.1.html

       27. Initial Configuration
           http://dacs.dss.ca/man/dacs.install.7.html#initial_config

       28. SECURE_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#SECURE_MODE

       29. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#dacs_metadata

       30. ddaaccssccoonnff((11))
           http://dodgers.dacstest.dss.ca:18123/man/dacsconf.1.html

       31. ddaaccsskkeeyy((11))
           http://dodgers.dacstest.dss.ca:18123/man/dacskey.1.html

       32. ddaaccss__aaccss((88))
           http://dodgers.dacstest.dss.ca:18123/man/dacs_acs.8.html

       33. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#exported_envars

       34. dacs_version(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_version.8.html

       35. dacs_list_jurisdictions(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_list_jurisdictions.8.html

       36. dacs.acls(5)
           http://dodgers.dacstest.dss.ca:18123/man/dacs.acls.5.html

       37. dacs.exprs(5)
           http://dodgers.dacstest.dss.ca:18123/man/dacs.exprs.5.html

       38. dacspasswd(1)
           http://dodgers.dacstest.dss.ca:18123/man/dacspasswd.1.html

       39. htpasswd
           http://httpd.apache.org/docs-2.2/programs/htpasswd.html

       40. Stephen Root
           http://us.imdb.com/name/nm0740535/

       41. dacs_authenticate(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_authenticate.8.html

       42. dacs_current_credentials
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_current_credentials

       43. dacs_signout(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_signout.8.html

       44. invoke dacs_signout directly
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_signout

       45. signout
           http://dodgers.dacstest.dss.ca:18123/examples/signout.html

       46. dacs_prenv
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv

       47. Location
           http://httpd.apache.org/docs-2.2/mod/core.html#location

       48. Virtual Hosts
           http://httpd.apache.org/docs/2.2/vhosts/

       49. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       50. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       51. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       52. Post-Release Notes
           http://dacs.dss.ca/download.html

       53. LOG_LEVEL
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_LEVEL

       54. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

       55. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       56. www.dss.ca
           http://www.dss.ca

       57. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                     DACS.QUICK(7)
