DACS.CONF(5)                  DACS Formats Manual                 DACS.CONF(5)



NNAAMMEE
       dacs.conf - DDAACCSS configuration files and directives

DDEESSCCRRIIPPTTIIOONN
       These files are part of the DDAACCSS suite.

       Nearly all DDAACCSS services and utilities consult a configuration file
       when they start up. Such things as the per-jurisdiction locations of
       access control files and log files, authentication processing, error
       handling, and run-time limits are specified in the configuration file.
       The recommended name for this file is dacs.conf and the DDAACCSS
       documentation will generally refer to it by that name. Site-wide
       configuration, which is optional, is typically put in a file named
       site.conf. Both files are XML documents, and consist of various
       sections, clauses, and directives, not unlike the httpd.conf
       configuration file used by AAppaacchhee. Different federations and
       jurisdictions running on the same host may share these files or each
       might have its own separate configuration file; the former is more
       common since it reduces duplication and helps to prevent
       inconsistencies.

           NNoottee
           Unlike the "passive" configuration files found in most systems, the
           DDAACCSS configuration files are "active"; that is, configuration
           directives are evaluated as expressions within a run-time context
           that includes information related to the current request, web
           server, operating system, and DDAACCSS itself. By specifying the value
           of a directive as an expression rather than a simple string, the
           configuration under which a request is processed can adapt to, or
           depend on, the context in which it is made. Administrators do not
           need to use this capability, but it is available when flexibility
           is needed.

           NNoottee
           Each configuration file is completely read and processed once, each
           time a DDAACCSS web service or utility is executed. Changes to the
           files take effect the next time the files are read; no
           recompilation or special action needs to be taken, and neither
           AAppaacchhee nor any other server needs to be restarted. In general, it
           is safe to change the configuration files while DDAACCSS is
           operational. Because DDAACCSS components abort if they encounter a
           configuration error (e.g., leading to all access to be denied, all
           authentication to fail, or a utility to become non-operational),
           temporarily introducing a configuration error will not usually
           cause any serious problems. Under heavy load or if complex
           authentication methods have been configured, however, it is prudent
           to stop the web server briefly while the old configuration files
           are replaced with the new ones.

           TTiipp
           While it may at first seem that DDAACCSS is difficult to configure, in
           practice the default configuration that comes with the DDAACCSS
           distribution is sufficient in many cases, and leaves only a few
           straightforward, site-dependent directives to be specified. Many
           administrators will never need to use the more advanced
           configuration features.

           TTiipp
           +o   The DDAACCSS distribution includes a prototype version of
               site.conf, found in conf/site.conf-std, which establishes
               reasonable defaults based on DDAACCSS build-time arguments. It may
               need some customization for the local environment. By default,
               DDAACCSS looks for the site configuration file in
               federations/site.conf, relative to the DDAACCSS installation
               directory; conf/site.conf-std can be copied there and any
               necessary customizations made.

           +o   A command to validate and display configuration, ddaaccssccoonnff((11))[1]
               is available, as is a simple web service, ddaaccss__ccoonnff((88))[2].
               Until you become comfortable with configuration files, consider
               running one of them after making changes. A fatal configuration
               error will prevent DDAACCSS from running and access to all
               DDAACCSS-wrapped resources will be denied.

   LLooccaattiinngg ddaaccss..ccoonnff aanndd ssiittee..ccoonnff
       The locations of dacs.conf and site.conf may be specified with the web
       server configuration, in an environment variable, through a command
       line flag, or at compile time. A single configuration file can provide
       directives for multiple DDAACCSS jurisdictions. For example, if a machine
       is hosting more than one DDAACCSS jurisdiction, they can each use the same
       DDAACCSS binaries.

           NNoottee
           Most DDAACCSS commands and web services require the dacs.conf file to
           exist; the exceptions are a few "standalone" programs, such as
           hhttttpp((11))[3]. The site.conf file is not required; if a location has
           been configured and the file exists, however, it must be readable
           and by convention should contain default values appropriate for the
           installed release.

       Command line flags common to many DDAACCSS programs are described in
       ddaaccss((11))[4].

       So that ddaaccss__aaccss((88))[5] (which is invoked by the mmoodd__aauutthh__ddaaccss[6]
       module) can find its configuration, the location of dacs.conf can be
       specified in AAppaacchhee''ss httpd.conf file using the SetDACSAuthConf
       directive. It may instead, however, be specified through the DDAACCSS__CCOONNFF
       environment variable, on the command line, or using a build-time
       default. Similarly, the location of site.conf can be specified in
       AAppaacchhee''ss httpd.conf file using the SetDACSAuthSiteConf directive,
       through the DDAACCSS__SSIITTEE__CCOONNFF environment variable, on the command line,
       or using a build-time default.

       If the location of dacs.conf (site.conf) is not given at run-time, a
       compile-time value of the symbol DACS_CONF (DACS_SITE_CONF) will be
       used if possible. This is the usual case for programs other than
       ddaaccss__aaccss. It is a fatal error if a DDAACCSS service can't locate dacs.conf.

       Regardless of how the location of dacs.conf is specified, DDAACCSS performs
       string interpolation on the pathname. If interpolation fails, DDAACCSS will
       encounter a fatal error because it will not be able to locate its
       configuration file.

       PPaatthh IInntteerrppoollaattiioonn
           Path interpolation is available using a syntax and method similar
           to AAppaacchhee''ss mmoodd__vvhhoosstt__aalliiaass[7] module. Interpolation is always
           performed to determine the locations of several resources used by
           DDAACCSS, such as dacs.conf and site.conf, and with DDAACCSS''ss LLOOGG__FFIILLEE[8]
           directive, regardless of the manner in which the location is
           provided to DDAACCSS. It is applied whether the location of dacs.conf
           is specified using the --uu command line flag or the AAppaacchhee
           (mmoodd__aauutthh__ddaaccss) SetDACSAuthConf directive, for instance.

           The functionality can also be accessed using the ppaatthhnnaammee(())[9]
           function.

           The strings that may be interpolated into the pathname are obtained
           from the execution environment, in particular the URI authority
           information (based on AAppaacchhee's SSEERRVVEERR__NNAAMMEE and SSEERRVVEERR__PPOORRTT
           environment variables), the URI service path (described below),
           build-time configuration, and the applicable Jurisdiction section's
           distinguishing URI.

           Interpolation is controlled by pprriinnttff-like format specifiers, as
           follows:

           %%
               Insert a literal percent character

           %a
               Insert the application name, which is obtained from the
               filename component of the program's _a_r_g_v_[_0_] argument

           %bA
               Insert the absolute pathname of the root of the Apache
               installation directory, specified at build-time (_A_P_A_C_H_E___H_O_M_E)

           %bD
               Insert the absolute pathname of the root of the DDAACCSS
               installation directory, specified at build-time (_D_A_C_S___H_O_M_E)

           %p
               Insert the port number of the virtual host (SSEERRVVEERR__PPOORRTT)

           %_N._M
               Insert one or more components of the name, or a substring of
               those subcomponents.  _N and _M are numbers used to select part
               of the SSEERRVVEERR__NNAAMMEE string (a domain name or IP address).  _N
               selects from the dot-separated components of SSEERRVVEERR__NNAAMMEE, while
               _M selects characters within whatever _N has selected.  _M is
               optional and defaults to zero if it isn't present. The dot must
               be present if and only if _M is also present. If _N or _M are
               greater than the number of parts available, a single underscore
               is interpolated. The numbers are interpreted as follows:

               0 or 1+ or -1+
                   the whole name

               1
                   the first part

               2
                   the second name

               -1
                   the last part

               -2
                   the next-to-last part

               2+
                   the second and all following parts

               -2+
                   the next-to-last and all preceding parts


           %s[_N._M]
               This is a synonym for %_N._M, with %s being equivalent to %0.

                   NNoottee
                   In cases where the character following %s should not be
                   interpreted as part of the format, it must be escaped
                   (e.g., %s%2).

           %u[_N._M]
               This functions like the %s specifier except that it is applied
               to the URI service path (described below) for the current
               request, which has slash-separated components.  %u is
               equivalent to %u0. For example, if the URI service path is
               "example.com/metalogic", %u1 would be "example.com", %u2 would
               be "metalogic", and %u0 (and %u and %u1+) would be
               "example.com/metalogic".

                   NNoottee
                   In cases where the character following %u should be
                   interpolated verbatim and not interpreted as part of the
                   specifier, it must be escaped (e.g., %u%2).

           %U[_N._M]
               This functions like the %u specifier except that it is applied
               to the applicable JJuurriissddiiccttiioonn sseeccttiioonn''ss[10] distinguishing URI
               (described below).  %U is equivalent to %U0.

                   NNoottee
                   +o   Because the applicable Jurisdiction section is not
                       known until after configuration processing has started,
                       this specifier cannot be used to describe the location
                       of configuration files.

                   +o   In cases where the character following %U should be
                       interpolated verbatim and not interpreted as part of
                       the specifier, it must be escaped (e.g., %U%2).

               Other format specifiers
                   If a % is followed by an unrecognized specifier, that
                   character is inserted verbatim.

               Other characters
                   All other characters are inserted verbatim

               For example, if SSEERRVVEERR__NNAAMMEE is dss.example.com and SSEERRVVEERR__PPOORRTT
               is 8080, then the AAppaacchhee directive:

                   SetDACSAuthConf dacs-acs "/usr/local/apache2/conf/dacs/%2+/dacs.conf"

               will expand the path to
               /usr/local/apache2/conf/dacs/example.com/dacs.conf. The command
               line flag:

                   -c /usr/local/dacs/%1%.%p/dacs.conf

               specifies the location of the configuration file to be
               /usr/local/dacs/dss.8080/dacs.conf.

               The %u specifier interpolates the URI service path, or portions
               thereof, which is the string HHTTTTPP__HHOOSSTT/RREEQQUUEESSTT__UURRII (without a
               query component). When a DDAACCSS service is invoked as a CGI, this
               will be the usual case; the URI service path is undefined if
               either of those environment variables is unavailable, however.

   FFiillee FFoorrmmaatt
       dacs.conf is an XML document that conforms to CCoonnffiigguurraattiioonn..ddttdd[11].

       A dacs.conf file consists of an optional Default section followed by
       zero or more Jurisdiction sections. Either type of section consists of
       DDAACCSS directives or XML elements, called clauses, that contain DDAACCSS
       directives. There are three kinds of clauses: Auth clauses, Roles
       clauses, and Transfer clauses.

       Just to give its flavour, here's an incomplete dacs.conf file:

           <Configuration>
             <Default>
               LOG_FILE "${Conf::DACS_HOME}/logs/logfile"
               FEDERATION_DOMAIN "example.com"
               FEDERATION_NAME "ROOT"
               LOG_LEVEL "notice"
               SSL_PROG "/usr/local/dacs/bin/sslclient"
             </Default>

             <!-- Configuration of first jurisdiction -->
             <Jurisdiction uri="dss.example.com">
               JURISDICTION_NAME "DSS"
               <Auth id="auth_name">
                 URL "https://dss.example.com/cgi-bin/dacs/local_unix_authenticate"
                 STYLE "pass"
                 CONTROL "sufficient"
               </Auth>
              </Jurisdiction>

             <!-- Configuration of second jurisdiction -->
              <Jurisdiction uri="dss.example.com/foo">
                JURISDICTION_NAME "FOO"
              </Jurisdiction>

             <!-- Configuration of third jurisdiction -->
              <Jurisdiction uri="metalogic.example.com">
                JURISDICTION_NAME "METALOGIC"
              </Jurisdiction>
            </Configuration>

       The structure of site.conf is only slightly different. The Default
       section is mandatory in site.conf and no Jurisdiction sections are
       allowed.

           NNoottee
           Because the configuration files are XML documents, characters
           special to XML must be properly escaped. In particular, an
           ampersand character must always be written as &amp; and a <
           character must be written as &lt;.

       Although the XML format of the DDAACCSS configuration files is easily
       understood and fairly readable, and they can be modified using any text
       editor, there is nothing to prevent a special-purpose tool from being
       used.

   TThhee DDeeffaauulltt SSeeccttiioonn
       The purpose of the Default section in dacs.conf is to establish default
       values for directives that tend to be shared amongst all of the
       Jurisdiction sections that appear in dacs.conf. The Default section is
       optional; if present, it must appear before any Jurisdiction section in
       dacs.conf.

       The site.conf file, if it exists, consists of only a Default section.
       Directives that are common to all of a site's dacs.conf files might be
       put in site.conf.

       Any configuration directive or clause may appear in the Default
       section.

   TThhee JJuurriissddiiccttiioonn SSeeccttiioonn
       Each Jurisdiction section contains configuration directives that are
       associated with a particular jurisdiction. These directives override
       those found anywhere else, as described below.

   SSeeccttiioonn MMeerrggiinngg aanndd DDiirreeccttiivvee EEvvaalluuaattiioonn
       The three types of configuration sections are merged as follows. First,
       directives and clauses that appear in the site.conf Default section are
       overridden by those that appear in the dacs.conf Default section. The
       resulting directives and clauses are in turn overridden by those that
       appear in the selected Jurisdiction section. Usually, site.conf will
       contain the standard default directives that come with the installed
       release of DDAACCSS, the dacs.conf Default section will contain directives
       common to all of the jurisdictions defined on the host that are in the
       same federation, and each Jurisdiction section will contain directives
       specific to that jurisdiction.

       The exception to this merging procedure is directives in the SSttaacckk
       ccaatteeggoorryy[12]. Instead of overriding, these directives accumulate.

       The order in which directives (but not clauses) appear within a section
       is not significant, even with respect to references to variables in the
       _C_o_n_f nnaammeessppaaccee[13], with the exception of the EEVVAALL ddiirreeccttiivvee[14].

       Only after directives in the three sections are merged are their
       right-hand sides evaluated (again, with the exception of EEVVAALL[14]) to
       determine the value of each directive. Therefore, if a directive
       appears in both the Default section and the Jurisdiction section, the
       instances in the Default section will not have their directive values
       evaluated; they will simply be discarded (with the exception of the
       Stack directive category).

       TThhee uunnddeeff(()) ddiirreeccttiivvee
           As a special case, if a directive is given the special value
           returned by uunnddeeff(())[15], the instance of the directive is deleted.
           This provides a way to conditionally include or exclude a directive
           depending on the execution environment. For example, this directive
           increases the debugging level for DDAACCSS web services but not for
           commands:

               LOG_LEVEL ${Env::REMOTE_ADDR:e} ? "TRACE" : undef()


               NNoottee
               Because of the way configuration files are currently processed,
               the check for directive category satisfaction happens _b_e_f_o_r_e
               right-hand side evaluation. This means that in any particular
               section only one instance of a Required1 directive may appear,
               even if just one would be included after the evaluation step.

       FFaattaall eerrrroorrss
           It is a fatal error to reference an undefined variable unless the e
           or ?  modifier flag is used in the variable reference. Recursive
           variable references are detected and result in a fatal error. If a
           directive ends up not being evaluated, it does not matter whether
           its right-hand side is invalid (or would be if evaluated).

               NNoottee
               When a fatal error occurs during configuration processing, a
               DDAACCSS web service tries to terminate gracefully. But because
               directives (including error handling directives) may not have
               been processed correctly, or even at all, there is no guarantee
               that an error handler (such as one defined by the
               AACCSS__EERRRROORR__HHAANNDDLLEERR[16] directive) will be invoked or a requested
               output format will be honoured during abnormal termination. A
               non-zero exit process status is always returned.

       AAnn eexxaammppllee
           Consider the following configuration excerpts:

               In site.conf:
                 LOG_LEVEL "debug"

               In dacs.conf:
                 Default section:
                 LOG_LEVEL "notice"

                 Jurisdiction section:
                 LOG_LEVEL "trace"

           After configuration processing, the directive LOG_LEVEL will be set
           to "trace", and the variable _$_{_C_o_n_f_:_:_L_O_G___L_E_V_E_L_} will have that
           value during configuration processing.

           Here are some excerpts from dacs.conf:

                 Default section:
                 FEDERATION_DOMAIN "example.com"
                 FEDERATION_NAME "EXAMPLE"

                 Jurisdiction section:
                 JURISDICTION_NAME "DEMO"
                 VFS "[abc]dacs-fs:${Conf::FEDERATIONS_ROOT}/${Conf::FEDERATION_DOMAIN}\
               /${Conf::JURISDICTION_NAME}/abc"

           When computing the VFS directive's value in the example above, the
           values of the _F_E_D_E_R_A_T_I_O_N_S___R_O_O_T variable (determined at build-time)
           and the FEDERATION_DOMAIN and JURISDICTION_NAME configuration
           directives are interpolated. Directives in site.conf may reference
           configuration variables that are defined in dacs.conf.

           Given the configuration:

               In site.conf:
                 VFS "[dtds]dacs-fs:/usr/local/dacs/www/dtd-xsd"

               In dacs.conf:
                 Default section:
                 VFS "[dtds]dacs-fs:/usr/local/dacs/dtd-xsd"

                 Jurisdiction section:
                 VFS "[dtds]dacs-fs:/export/dacs/dtd-xsd"
                 VFS "[xxx]dacs-fs:/export/dacs/xxx"

           All four VFS directives will be in effect, but they will be ordered
           such that the first one in the Jurisdiction section is at the top
           of the stack, the second one in that section is next on the stack,
           the directive in the dacs.conf Default section follows, and the one
           from site.conf is last.

   JJuurriissddiiccttiioonn SSeeccttiioonn SSeelleeccttiioonn
       DDAACCSS web services and commands do not have any federation or
       jurisdiction information compiled into them, so that a single set of
       DDAACCSS binaries can be shared by many jurisdictions (e.g., by multiple
       real or virtual web servers on the same host, or using NFS or some
       other file sharing mechanism). But it means that (most) web services
       and commands need a run-time mechanism to determine "who they are" -
       which federation and jurisdiction are they acting on behalf of? For web
       services, this usually depends on the server name, hostname, port,
       scheme, URI path, some other context associated with the request, or a
       combination of these things. But it is sometimes most convenient to
       specify a jurisdiction name and have DDAACCSS work out what the request
       URIs to that jurisdiction look like, if it needs to.

       Most DDAACCSS web services and commands need to obtain run-time
       configuration information for the jurisdiction they represent. Because
       dacs.conf may specify the configuration of more than one jurisdiction,
       how do they know which Jurisdiction section they should use? In cases
       where DDAACCSS does not know the jurisdiction name, it searches for the
       correct Jurisdiction section and then determines the name of the
       jurisdiction; in cases where it is given the jurisdiction name, it
       searches Jurisdiction sections to find one with a directive that
       identifies the jurisdiction that it was given.

       The applicable Jurisdiction section to use for a particular web service
       request or command can be determined in a variety of ways, using:

       +o   the --uu command line flag to specify a _c_o_n_f_i_g_-_u_r_i that is matched
           against eeffffeeccttiivvee jjuurriissddiiccttiioonnaall UURRIIss[17];

       +o   the --uujj command line flag to specify a _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e that is
           matched against Jurisdiction sections' JURISDICTION_NAME directive;

       +o   the --uuss command line flag to indicate that there is only one
           Jurisdiction section, so that section should be selected; or

       +o   by matching a request URI against eeffffeeccttiivvee jjuurriissddiiccttiioonnaall
           UURRIIss[17].


       Command line flags are described in ddaaccss((11))[4], as is the
       DDEEFFAAUULLTT__JJUURRIISSDDIICCTTIIOONN environment variable.

       These methods will be described individually shortly.

           TTiipp
           Because selection of the applicable Jurisdiction section is quite
           flexible, it may seem complicated. In practice, however, it is
           often rather simple, and particularly so if only one jurisdiction
           is being configured. It may be sufficient to read this section and
           skip the detail presented in the remainder of the discussion on how
           the Jurisdiction section is selected.

       If there is only one jurisdiction, its uri attribute value can simply
       be the domain name associated with the jurisdiction. Any of the command
       line flags could then be used (or none). If the jurisdiction's domain
       name is foo.example.com, for instance, the Jurisdiction section in
       dacs.conf might look like:

           <Configuration>
             <Jurisdiction uri="foo.example.com">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       In the AAppaacchhee configuration file (httpd.conf), one might specify:

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-u foo.example.com"

       (which tells DDAACCSS that all web service requests from the web server or
       virtual host to which this directive applies should be associated with
       the domain foo.example.com for configuration purposes), or

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-us"

       (telling DDAACCSS that all web service requests from the web server or
       virtual host to which this directive applies should be associated with
       the only jurisdiction described in the configuration file, whatever
       that jurisdiction may be), or

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-uj FOO"

       (telling DDAACCSS that all web service requests from the web server or
       virtual host to which this directive applies should be associated with
       jurisdiction FOO), or simply

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs

       In the last case, DDAACCSS will match the request URI (which presumably
       looks like https://foo.example.com/...) against foo.example.com.

       Multiple jurisdictions that are identified by distinct domain names are
       also easily configured once a DDAACCSS administrator decides how he would
       like request URIs to identify them. This is usually done much like
       this:

           <Configuration>
             <Jurisdiction uri="foo.example.com">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="baz.example.com">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       And so that the domain name in the request URI is matched against the
       jurisdiction's effective URI, one would use:

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs

       Multiple jurisdictions that share a domain name but are distinguished
       by a portion of the request URI pathname component, are often
       configured something like:

           <Configuration>
             <Jurisdiction uri="example.com/foo">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="example.com/baz">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       And again using:

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs

       With this style of configuration, a request for
       https://example.com/foo/cgi-bin/dacs/blah would be directed to the
       configuration for the FOO jurisdiction.

       Similarly, port numbers can also be used for Jurisdiction section
       selection:

           <Configuration>
             <Jurisdiction uri="example.com:443">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="example.com:8443">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       Lastly, a hostname wildcard syntax can be useful:

           <Configuration>
             <Jurisdiction uri="*.foo.example.com">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="*.baz.example.com">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>


           IImmppoorrttaanntt
           No check is made to ensure that the jurisdiction sections are
           unique. This is sometimes a useful feature but can also cause
           unexpected behaviour. It is probably best for all but the most
           advanced administrators to make sure that the same
           JURISDICTION_NAME directive doesn't appear in multiple Jurisdiction
           sections and that each section has a different effective
           jurisdictional URI.

       If your particular requirement has been covered, it is probably safe to
       skip the detail that follows.

       TThhee EEffffeeccttiivvee JJuurriissddiiccttiioonnaall UURRII
           A Jurisdiction element must have either a uri attribute or a
           uri_expr attribute, but not both. If the latter is given, it
           specifies an eexxpprreessssiioonn[18] that is evaluated at configuration
           processing time. The effective jurisdictional URI (or the
           jurisdiction's effective URI) is either the value of the uri
           attribute or the value obtained by evaluating the uri_expr
           attribute. The effective jurisdictional URI can be matched against
           a request's URI or the --uu flag's _c_o_n_f_i_g_-_u_r_i to find the applicable
           Jurisdiction section.

           The standard set of ccoonnffiigguurraattiioonn vvaarriiaabblleess[19] in the _C_o_n_f and _E_n_v
           nnaammeessppaaccee[13] (but no others) are accessible during evaluation of
           uri_expr. Consider this partial configuration:

               <Jurisdiction uri_expr="${Env::SERVER_NAME}">

           Here, the effective jurisdictional URI is the value of the
           SSEERRVVEERR__NNAAMMEE environment variable.

               NNoottee
               +o   The environment established for a DDAACCSS web service and the
                   environment of a DDAACCSS command are typically different, so
                   programs run from the command line may fail if uri_expr
                   references an undefined variable.

               +o   Any error that occurs during evaluation of uri_expr is
                   fatal.

               +o   One application of the uri_expr attribute is constructing a
                   generic or "template" Jurisdiction section. For example, if
                   multiple domain names need to map to the same jurisdiction,
                   a uri_expr like the following can be used:

                       <Jurisdiction uri_expr="regmatch(${Env::SERVER_NAME}, '(foo.example.com)|(baz.example.com)')">



       The effective jurisdictional URI has the following syntax:

           uri         -> [scheme-spec] [domain-spec] [":" port-spec] [path-spec]
           scheme-spec -> "http://" | "https://"
           domain-spec -> domain-name | "*." domain-name | IP-address
           port-spec   -> positive-integer | positive-integer "," port-spec
           path-spec   -> "/" path-segment | "/" path-segment path-spec


       JJuurriissddiiccttiioonn SSeelleeccttiioonn bbyy UURRII
           Whether the Jurisdiction section is selected based on the --uu flag's
           explicit _c_o_n_f_i_g_-_u_r_i or the request URI provided to DDAACCSS through
           environment variables, the effective jurisdictional URIs are
           matched against the provided URI.

           An effective jurisdictional URI has the following semantics for
           matching against the provided URI:

           +o   If uri specifies the http scheme, the provided UR must not have
               used SSL; if uri specifies the https scheme, the provided URI
               must have used SSL; if neither scheme is specified, the scheme
               is immaterial.

           +o   The optional _d_o_m_a_i_n_-_s_p_e_c specifies a domain name to match
               (case-insensitively) against the provided URI. If the initial
               component of _d_o_m_a_i_n_-_s_p_e_c is "*.", then only the components that
               follow it in _d_o_m_a_i_n_-_s_p_e_c need to match the domain name in the
               provided URI. For example, *.example.com matches example.com
               and foo.baz.example.com. If the _d_o_m_a_i_n_-_s_p_e_c is omitted, the
               domain name in the provided URI is immaterial.

                   NNoottee
                   The matching algorithm does not consider domain names that
                   map to the same IP address (i.e., aliases) to be
                   equivalent.

               The _d_o_m_a_i_n_-_s_p_e_c can be an IP address, but in this case the
               provided URI must also use an IP address for the two to match.
               That is, no mapping between IP addresses and domain names is
               performed.

           +o   The optional _p_o_r_t_-_s_p_e_c consists of one or more port numbers,
               any one of which must match the one specified _e_x_p_l_i_c_i_t_l_y (i.e.,
               not by default) in the provided URI. If the provided URI does
               not contain a port, it will not match any _p_o_r_t_-_s_p_e_c. Port
               numbers are separated by a comma (with no embedded whitespace).
               If the _p_o_r_t_-_s_p_e_c is omitted, the port number in the provided
               URI is immaterial.

           +o   The optional _p_a_t_h_-_s_p_e_c must match the prefix of the provided
               URI's path component. Matching is case-sensitive and is
               performed on corresponding _p_a_t_h_-_s_e_g_m_e_n_t elements.


       The matching algorithm first rejects any Jurisdiction section having an
       effective jurisdictional URI that does not satisfy the _s_c_h_e_m_e_-_s_p_e_c or
       the _d_o_m_a_i_n_-_s_p_e_c. It looks for the section that contains a matching
       _p_o_r_t_-_s_p_e_c and that has the longest matching _p_a_t_h_-_s_p_e_c; the first such
       section will be selected. If no such section is found, however, it
       looks for the section that does not contain a _p_o_r_t_-_s_p_e_c and that has
       the longest matching _p_a_t_h_-_s_p_e_c; the first such section will be
       selected. It is a fatal error if no section can be selected.

           TTiipp
           While configuration of the uri attribute may appear to be complex,
           its value will typically be a simple hostname, or a simple hostname
           followed by a jurisdiction-distinguishing initial path element, as
           in the example above. The flexible syntax allows jurisdictions to
           be associated with requests based on port numbers, use of SSL, etc.
           and lets dissimilar requests map to the same jurisdiction.

       For example, given the eexxaammppllee ccoonnffiigguurraattiioonn[20] above, if the request
       URL is:

           https://dss.example.com/foo/cgi-bin/dacs_authenticate

       then the second Jurisdiction section will be used.

       If the request URL is:

           https://dss.example.com/cgi-bin/dacs_authenticate

       then the first Jurisdiction section will be used.

       If a DDAACCSS utility is invoked with the command line flag --uu
       metalogic.example.com, the third Jurisdiction section will be used.

       JJuurriissddiiccttiioonn SSeelleeccttiioonn bbyy JJuurriissddiiccttiioonn NNaammee
           The applicable Jurisdiction section can be selected by providing
           the jurisdiction's name. The --uujj flag's _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e argument
           is compared against the _u_n_e_v_a_l_u_a_t_e_d value of each section's
           JURISDICTION_NAME directive until the first exact string match is
           found; the section containing the directive will be selected.

               NNoottee
               Because the unevaluated value of the directive is used, if the
               value of a JURISDICTION_NAME is not a simple string, this
               option will not work unless _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e is that
               expression, not its value. Appropriate quotes are implied
               around _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e, so they should be omitted on the
               command line.

               For example, given the (partial) configuration file entry:

                   <Jurisdiction uri="demo.example.com">
                   JURISDICTION_NAME "DEMO"
                   ...
                   </Jurisdiction>


               the command line argument "--uujj DEMO" would select that
               jurisdiction section. If instead JURISDICTION_NAME were an
               expression that _e_v_a_l_u_a_t_e_d to the string DEMO, the argument
               would not select that jurisdiction section.

       JJuurriissddiiccttiioonn SSeelleeccttiioonn bbyy DDeeffaauulltt
           If dacs.conf contains a single Jurisdiction section, the --uuss flag
           can be used to select it without regard to the jurisdiction's name
           or effective jurisdictional URI. This can be particularly useful
           during testing.

           Should there be more than one Jurisdiction section when this flag
           is used, a fatal error will occur.

       TThhee DDiissttiinngguuiisshhiinngg UURRII
           Regardless of how the Jurisdiction section is selected, that
           section's effective jurisdictional URI is matched against the --uu
           flag's _c_o_n_f_i_g_-_u_r_i, if given, or the request URI according to the
           method described for JJuurriissddiiccttiioonn SSeelleeccttiioonn bbyy UURRII[21]. The
           resulting string is called the distinguishing URI. This string is
           another way of identifying the selected Jurisdiction section and
           can be used for ssttrriinngg iinntteerrppoollaattiioonn[22]. It is also related to the
           shared attribute used in aacccceessss ccoonnttrrooll rruulleess[23].

           For example, if the request URI is http://foo.example.com/a/b/c and
           the matching effective jurisdictional URI is *.example.com/a/b,
           then the distinguishing URI is foo.example.com/a/b.

   DDiirreeccttiivveess
       Each directive consists of a directive name, followed by whitespace
       (spaces and/or tabs), followed by its value. Directive names are
       case-sensitive and comprised of printable characters, except the space
       character, and are upper case.

       A directive value is an expression or sequence of expressions
       (ddaaccss..eexxpprrss((55))[18]) that is evaluated at run time during configuration
       processing. Here are some directives that are equivalent (on a
       Saturday):

           AUTH_FAIL_DELAY_SECS 2
           AUTH_FAIL_DELAY_SECS "2"
           AUTH_FAIL_DELAY_SECS 1 + 1
           AUTH_FAIL_DELAY_SECS strftime("%a") eq:i "Sat" ? 2 : 17

       Blank lines, leading white space, and lines whose first non-white space
       character is a # character (i.e., comments) are ignored.

       Any directive line may be split over physical lines by escaping the
       newline character, for example:

           ACS_ERROR_HANDLER "902 'Access denied, \
           user not authenticated'"

       An unrecognized directive name is a fatal error, as is an error
       encountered during expression evaluation.

       EEvvaalluuaatteedd DDiirreeccttiivveess
           Some directive names end with a * character. By convention, this
           means that the directive's value will be evaluated a second time,
           in the context of a particular module or service request, but only
           if the directive value is actually needed. This allows a
           configuration directive to reference a variable that cannot be
           instantiated until normal configuration file processing has been
           performed, for instance. The values of these directives usually
           appear within single quotes so that they initially evaluate to the
           string between the quotes.

           Consider this IINNIITT**[24] directive, which might appear within an
           AAuutthh ccllaauussee[25]:


                 INIT* '${Auth::CURRENT_USERNAME} = "goa\\" . ${Auth::CURRENT_USERNAME}'

           Because the directive's value appears within single quotes, the
           quoted expression is not evaluated during the first scan of the
           directive (or more accurately, it evaluates to an unquoted
           expression); this is as it should be because the value of the
           referenced variable is not known at that time, nor has it been
           determined whether the directive will even be needed. Later, if the
           Auth clause containing this directive is used, the variable's value
           is presumably known and the formerly quoted expression is
           evaluated, yielding a final value for the directive.

       DDiirreeccttiivvee CCaatteeggoorriieess
           After sseeccttiioonn mmeerrggiinngg[26] is performed, some directives must be
           specified while others are optional. Some may appear at most once
           and others may be repeated. The following labels are used to
           categorize directives:

           Required1:
               Directives of this type must be defined and appear only once
               after merging.

           Required1-C:
               Under certain conditions, these directives must be defined and
               appear only once after merging, otherwise they need not appear.
               For example, some directives are required if and only if the
               module that requires them is configured.

           Required:
               These directives must always be specified at least once after
               merging, and may be repeated.

           Optional1:
               These directives may appear at most once after merging.

           Optional:
               These directives may appear zero or more times after merging.

           Stack:
               This is like the Optional type, in that the directive may
               appear multiple times in any section, except the usual section
               merging algorithm is not used. Instead, all occurrences of the
               directive in the Jurisdiction section, then in the Default
               section of dacs.conf, and then in site.conf will be "stacked",
               in the order in which they appear in each section. Selection is
               dependent on the particular directive, which will effectively
               search the directives in the Jurisdiction section first to find
               an applicable directive, then search the directives in the
               Default section of dacs.conf if necessary, and finally search
               site.conf if necessary.

               NNoottee
               A directive marked Deprecated will be removed in a future
               version and should not be used.

           Some directives have more complicated constraints on their usage;
           they might be allowed only in certain contexts or are required only
           in certain situations (e.g., directives associated with proxied
           operation are only required if that mode of operation is being
           used).

           Required directives must be present and assigned a valid value,
           although the validity of a value is only checked if the directive
           is actually used. It is okay to define directives that are not
           used; for example, directives related to InfoCards may appear in a
           configuration file even if InfoCard support is not enabled at the
           time DDAACCSS is built. Some configuration directives may appear
           multiple times, others only once. The order in which configuration
           directives appear within a section is not usually significant,
           although it may be in cases where the directive is repeated (e.g.,
           ACS_ERROR_HANDLER) and for clauses (e.g., the Auth clause).

               NNoottee
               Directives that expect to be assigned a value of yes, no, on,
               or off recognize these keywords case-insensitively.

       GGeenneerraall DDiirreeccttiivveess
           The following general directives are provided. If present, they
           must appear within any Default section or Jurisdiction section, but
           outside of any clauses.

           DDiirreeccttiivvee IInnddeexx::

            1. ACCEPT_ALIEN_CREDENTIALS (Optional1)

            2. ACS_ACCESS_TOKEN_ENABLE (Optional1)

            3. ACS_ACCESS_TOKEN_LIFETIME_LIMIT (Required1-C)

            4. ACS_ACCESS_TOKEN_LIFETIME_SECS (Required1-C)

            5. ACS_AUTHENTICATED_ONLY (Optional1)

            6. ACS_CREDENTIALS_LIMIT (Optional1)

            7. ACS_EMIT_APPROVAL (Optional1)

            8. ACS_ERROR_HANDLER (Stack)

            9. ACS_FAIL (Optional1)

           10. ACS_INACTIVITY_LIMIT_SECS (Optional1)

           11. ACS_POST_BUFFER_LIMIT (Optional1)

           12. ACS_POST_EXCEPTION_MODE (Optional1)

           13. ACS_PRE_AUTH (Optional)

           14. ACS_SUCCESS (Optional)

           15. ACS_TRACK_ACTIVITY (Optional1)

           16. ADMIN_IDENTITY (Optional)

           17. ALLOW_HTTP_COOKIE (Optional1)

           18. AUTH_AGENT_ALLOW_ADMIN_IDENTITY (Optional1)

           19. AUTH_CREDENTIALS_ADMIN_LIFETIME_SECS (Optional1)

           20. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS (Required1)

           21. AUTH_ERROR_HANDLER (Stack)

           22. AUTH_FAIL (Optional1)

           23. AUTH_FAIL_DELAY_SECS (Optional1)

           24. AUTH_SINGLE_COOKIE (Optional1)

           25. AUTH_SUCCESS (Optional)

           26. AUTH_SUCCESS_HANDLER (Optional1)

           27. AUTH_TRANSFER_EXPORT (Optional)

           28. AUTH_TRANSFER_TOKEN_LIFETIME_SECS (Optional1)

           29. COMPAT_MODE (Optional1)

           30. COOKIE_HTTPONLY (Optional1)

           31. COOKIE_NO_DOMAIN (Optional1)

           32. COOKIE_PATH (Optional1)

           33. CSS_PATH (Optional1)

           34. DTD_BASE_URL (Optional1)

           35. EVAL (Optional)

           36. FEDERATION_DOMAIN (Required1)

           37. FEDERATION_NAME (Required1)

           38. HTTP_AUTH (Stack)

           39. HTTP_AUTH_ENABLE (Optional1)

           40. HTTP_PROG (Required1)

           41. INFOCARD_AUDIENCE (Optional)

           42. INFOCARD_AUDIENCE_RESTRICTION (Optional)

           43. INFOCARD_CARD_DEFS_URL (Optional1)

           44. INFOCARD_CARD_FILL_URL (Optional1)

           45. INFOCARD_CARD_IMAGE_BASE_URL (Required1-C)

           46. INFOCARD_CARD_LIFETIME_SECS (Optional1)

           47. INFOCARD_CARD_OUTPUTDIR (Optional1)

           48. INFOCARD_CARD_VERSION (Optional1)

           49. INFOCARD_CARDID_BASE_URL (Required1-C)

           50. INFOCARD_CARDID_SUFFIX (Optional1)

           51. INFOCARD_CARD_DATETIME_EXPIRES (Optional1)

           52. INFOCARD_DIGEST (Optional1)

           53. INFOCARD_IP_PRIVACY_URL (Required1-C)

           54. INFOCARD_IP_PRIVACY_VERSION (Optional1)

           55. INFOCARD_ISSUER_INFO_ENTRY (Optional)

           56. INFOCARD_MEX_URL (Required1-C)

           57. INFOCARD_REQUIRE_APPLIES_TO (Optional1)

           58. INFOCARD_STRONG_RP_IDENTITY (Optional1)

           59. INFOCARD_STS_AUTH_TYPE (Required1-C)

           60. INFOCARD_STS_CACERTFILE (Required1-C)

           61. INFOCARD_STS_CERTFILE (Required1-C)

           62. INFOCARD_STS_KEYFILE (Required1-C)

           63. INFOCARD_STS_KEYFILE_PASSWORD (Required1-C)

           64. INFOCARD_STS_PASSWORD_METHOD (Required1-C)

           65. INFOCARD_STS_RP_ENDPOINT (Optional)

           66. INFOCARD_TOKEN_DRIFT_SECS (Optional1)

           67. INFOCARD_TOKEN_ISSUER (Required1-C)

           68. INFOCARD_TOKEN_LIFETIME_SECS (Optional1)

           69. INFOCARD_TOKEN_MAX_LENGTH (Optional1)

           70. INFOCARD_USERNAME_SELECTOR (Optional1)

           71. JURISDICTION_NAME (Required1)

           72. LOGINGEN_FILE (Optional1)

           73. LOGINGEN_PROG (Optional1)

           74. LOG_FILE (Optional1)

           75. LOG_FILTER (Stack)

           76. LOG_FORMAT (Optional1)

           77. LOG_LEVEL (Optional1)

           78. LOG_SENSITIVE (Optional1)

           79. NAME_COMPARE (Optional1)

           80. NOTICES_ACCEPT_HANDLER (Optional1)

           81. NOTICES_ACK_HANDLER (Optional1)

           82. NOTICES_DECLINE_HANDLER (Optional1)

           83. NOTICES_NAT_NAME_PREFIX (Optional1)

           84. NOTICES_SECURE_HANDLER (Optional1)

           85. NOTICES_WORKFLOW_LIFETIME_SECS (Optional1)

           86. PAMD_HOST (Optional1)

           87. PAMD_PORT (Optional1)

           88. PASSWORD_CONSTRAINTS (Optional1)

           89. PASSWORD_DIGEST (Optional1)

           90. PASSWORD_OPS_NEED_PASSWORD (Optional1)

           91. PASSWORD_SALT_PREFIX (Optional1)

           92. PERMIT_CHAINING (Optional1)

           93. PROXY_EXEC_DOCUMENT_ROOT (Optional1)

           94. PROXY_EXEC_MAPPER_DEFAULT_ACTION (Optional1)

           95. PROXY_EXEC_MAPPER_LOGGING (Optional1)

           96. PROXY_EXEC_MAPPER_LOG_FILE (Optional1)

           97. PROXY_EXEC_MAPPER_RULES_FILE (Optional1)

           98. PROXY_EXEC_PROG_URI (Optional1)

           99. RLINK (Optional)

           100. ROLE_STRING_MAX_LENGTH (Optional1)

           101. SECURE_MODE (Optional1)

           102. SIGNOUT_HANDLER (Optional1)

           103. SSL_PROG (Optional1)

           104. SSL_PROG_ARGS (Optional1)

           105. SSL_PROG_CA_CRT (Optional1)

           106. SSL_PROG_CLIENT_CRT (Optional1)

           107. STATUS_LINE (Optional1)

           108. TEMP_DIRECTORY (Optional1)

           109. TOKEN_REQUIRES_PIN (Optional1)

           110. TOKEN_HOTP_ACCEPT_WINDOW (Optional1)

           111. TRACE_LEVEL (Optional1)

           112. UNAUTH_ROLES (Optional1)

           113. UPROXY_APPROVED (Stack)

           114. VERBOSE_LEVEL (Optional1)

           115. VERIFY_IP (Required1)

           116. VERIFY_UA (Optional1)

           117. VFS (Stack)

           118. XSD_BASE_URL (Optional1)

           ACCEPT_ALIEN_CREDENTIALS (Optional1)
               If "yes", DDAACCSS will honour credentials imported (by any means)
               from a different federation. As a security precaution, such
               credentials are not used by default.

                   SSeeccuurriittyy
                   In federations where ddaaccss__aauutthh__ttrraannssffeerr((88))[27] is used,
                   jurisdictions will likely enable this capability.

           ACS_ACCESS_TOKEN_ENABLE (Optional1)
               If "yes", AACCSS's access token mechanism will be enabled. By
               default, this feature is disabled. Please see AAuutthhoorriizzaattiioonn
               CCaacchhiinngg[28] for details.

           ACS_ACCESS_TOKEN_LIFETIME_LIMIT (Required1-C)
               If AACCSS's access token mechanism has been enabled, this is the
               number of times that an access token may be used. It must be an
               integer greater than zero. There is no default value. This
               value, ACS_ACCESS_TOKEN_LIFETIME_SECS, or both must be
               configured properly if the mechanism is enabled. Because it
               requires updating a database entry, this method of enforcing a
               limit on the lifetime of an access token is inherently less
               efficient than using ACS_ACCESS_TOKEN_LIFETIME_SECS. Changes to
               this limit do not affect access tokens that have already been
               issued. Please see AAuutthhoorriizzaattiioonn CCaacchhiinngg[28] for details.

           ACS_ACCESS_TOKEN_LIFETIME_SECS (Required1-C)
               If AACCSS's access token mechanism has been enabled, this is the
               lifetime in seconds of an access token, and must be an integer
               greater than zero. There is no default value. This value,
               ACS_ACCESS_TOKEN_LIFETIME_LIMIT, or both must be configured
               properly if the mechanism is enabled. Please see AAuutthhoorriizzaattiioonn
               CCaacchhiinngg[28] for details.

           ACS_AUTHENTICATED_ONLY (Optional1)
               If "yes", AACCSS will deny all requests that are not accompanied
               by valid credentials, regardless of any access control rules or
               other directives.

                   NNoottee
                   Since this restriction also applies to DDAACCSS services, if
                   this mode is enabled an unauthenticated user will not be
                   able to access DDAACCSS services by which he might authenticate
                   himself. Users must therefore have authenticated before
                   this directive is enabled, authenticate using an off-line
                   method (such as ddaaccssccooookkiiee((11))[29] or ddaaccssaauutthh((11))[30]), or
                   authenticate at some other jurisdiction.

           ACS_CREDENTIALS_LIMIT (Optional1)
               The value of this directive is either an unsigned integer
               greater than zero, or the keyword "none" (case insensitive). In
               the former case, if a request is submitted with more than this
               number of valid credentials, the request will be denied with
               the REVOKED error (equivalent to error code 990033).

               Probably the most common application of this directive is to
               limit each request to being associated with at most one
               identity. The standard site configuration sets
               ACS_CREDENTIALS_LIMIT to one. This eliminates confusion about
               which identity invoked a web service (i.e., which identity
               RREEMMOOTTEE__UUSSEERR should be set to, for instance) and ambiguity
               regarding the semantics of rules, and in some cases may
               simplify access control rules and log file audits.

               A user denied access at a jurisdiction due to this directive
               will be denied access to ddaaccss__ssiiggnnoouutt((88))[31] at the
               jurisdiction. To regain access to the jurisdiction, the user
               will either need to signout from a different jurisdiction or
               delete one or more sets of credentials (cookies) from his
               browser, either using the browser's cookie manager or by
               terminating the browser session.

                   NNoottee
                   It is possible for a user that is not denied access at a
                   jurisdiction due to this directive to successfully
                   authenticate, after which he will have "too many"
                   credentials and subsequently be denied access. Similarly, a
                   DDAACCSS administrator may reduce the limit at any time,
                   potentially causing access to be denied to users holding a
                   number of credentials in excess of the limit.

                   SSeeccuurriittyy
                   This directive only limits the number of credentials
                   associated with a single request. It does not prevent the
                   same individual from sending different requests, from the
                   same browser or different browsers, each associated with a
                   different identity. Also, it does not limit the number of
                   concurrent logins of the same identity (such as by
                   different individuals sharing the same account).


                   DDAACCSS does not limit a user's number of concurrent logins or
                   the number of concurrent logins of the same identity
                   because of the inherent drawbacks of a general
                   implementation of such a feature. In simple cases, however,
                   an administrator may be able to add a custom solution to
                   DDAACCSS.

           ACS_EMIT_APPROVAL (Optional1)
               If "yes", DDAACCSS will generate a DDAACCSS__AAPPPPRROOVVAALL environment
               variable that can be inspected by an invoked program to verify
               that its use in the current context was authorized by DDAACCSS.
               Before this feature is enabled, additional configuration is
               necessary; see TThhee DDAACCSS__AAPPPPRROOVVAALL eennvviirroonnmmeenntt vvaarriiaabbllee[32] for
               details.

           ACS_ERROR_HANDLER (Stack)
               If DDAACCSS denies a service request, the web server's DDAACCSS module
               will be so informed and will return a 440033 ("Forbidden") status
               code to the web server. By using AAppaacchhee''ss ErrorDocument
               directive, the resulting action taken by AAppaacchhee can be
               customized.

               In some situations following denial of a request, however, it
               is desirable to initiate an action that depends on the reason
               for denial. For example, if access is denied because the user
               is not authenticated, the DDAACCSS administrator might want users
               to be redirected to a login page; if access is denied because
               an access control rule denies access although the user is
               authenticated, the administrator might want users to be
               redirected to a page that displays a custom error message. It
               is sometimes useful for the action to depend on the resource
               being requested.

               The ACS_ERROR_HANDLER directive defines (or overrides) AAppaacchhee's
               behaviour with respect to an ErrorDocument directive for 440033
               errors if DDAACCSS denies a service request. The syntax and meaning
               of this directive are similar to that of AAppaacchhee's ErrorDocument
               directive. Please refer to the AAppaacchhee documentation for a
               ddeessccrriippttiioonn ooff tthhee EErrrroorrDDooccuummeenntt ddiirreeccttiivvee[33].

               Also refer to the description of the rreeddiirreecctt(())[34] function.

               The syntax of the directive is:

                   [_u_r_l___p_a_t_t_e_r_n] _e_r_r_o_r_-_c_o_d_e [_h_a_n_d_l_e_r_-_t_y_p_e] [_e_r_r_o_r_-_a_c_t_i_o_n]

               The optional _u_r_l___p_a_t_t_e_r_n is a URI path component that is
               matched against the request for which access was denied. It
               must begin with a '/'. It is like the _u_r_l___p_a_t_t_e_r_n used in
               aacccceessss ccoonnttrrooll rruulleess[35] in that it can require an exact match
               or end in "/*"; no query argument component is allowed. If it
               is absent, the _u_r_l___p_a_t_t_e_r_n defaults to "/*", which matches any
               path.

               The _e_r_r_o_r_-_c_o_d_e is either a numeric error code, an equivalent
               case-insensitive _e_r_r_o_r_-_n_a_m_e, or the special symbol "*", which
               means the directive applies to any DDAACCSS error code for which
               there is no explicit directive.

               The following _e_r_r_o_r_-_n_a_m_e and _e_r_r_o_r_-_c_o_d_e values are defined:

               NO_RULE (990000)
               Access denied, no applicable rule
                   All rules were examined but no rule applies to the service
                   request.

               BY_RULE (990011)
               Access denied, forbidden by rule
                   The closest matching rule does not grant the service
                   request.

               NO_AUTH (990022)
               Access denied, user not authenticated
                   No valid credentials were provided and either a) no rule
                   applies or b) the rule does not grant the service request.

               REVOKED (990033)
               Access denied, user access revoked
                   Credentials were explicitly revoked.

               BY_REDIRECT (990044)
               Access denied, redirect
                   A rule has explicitly redirected the user.

               ACK_NEEDED (990055)
               Access denied, acknowledgement needed
                   One or more notices associated with the request must be
                   acknowledged.

               LOW_AUTH (990066)
               Access denied, low authentication level
                   Although valid credentials were provided, they were
                   obtained by an authentication method not strong enough for
                   the requested resource.

               BY_SIMPLE_REDIRECT (990077)
               Access denied, simple redirect
                   A rule has explicitly redirected the user; do not append
                   DDAACCSS query arguments.

               CREDENTIALS_LIMIT (990088)
               Access denied, too many credentials were submitted
                   Too many selected credentials accompanied the request.

               INACTIVITY (990099)
               Access denied, inactivity timeout
                   No authenticated requests were made within a designated
                   time interval.

               UNKNOWN (999988)
               Access denied, reason unknown
                   An error occurred during processing but no additional
                   information is available.

               DEFAULT (*)
               Control symbol
                   Not an error name, but a keyword used with
                   ACS_ERROR_HANDLER to configure a handler to invoke if no
                   handler is explicitly configured for the event.

               No blanks may precede the code, any number of blanks may follow
               it. The descriptive-text consists only of printable characters
               (e.g., no tabs or newlines) and may not contain a colon. The
               descriptive-text is subject to change, but the meaning of the
               code number is fixed. When DDAACCSS returns a numeric error code, a
               program only needs to examine the three digit code to determine
               why access was denied. Optionally, the standard text may be
               followed by a single space, a colon, at least one space, and a
               more detailed error message.

               If a _h_a_n_d_l_e_r_-_t_y_p_e keyword appears, it selects the action the
               handler should take and disables the heuristics that would
               otherwise be used to decide the type based on the syntax of the
               _e_r_r_o_r_-_a_c_t_i_o_n. The reason and default keywords are the only
               _h_a_n_d_l_e_r_-_t_y_p_e keyword that are not followed by an _e_r_r_o_r_-_a_c_t_i_o_n.

               The following _h_a_n_d_l_e_r_-_t_y_p_e keywords and _e_r_r_o_r_-_a_c_t_i_o_n arguments
               are recognized:

                1. reason

                   DDAACCSS will cause AAppaacchhee to display the DDAACCSS error code that
                   identifies the reason for denying access followed by the
                   corresponding textual message.  AAppaacchhee might display
                   messages like the following:

                       900 Access denied, no applicable access control rule
                       998 Access denied, internal error: Cookie parse error


                2. default

                   This form instructs DDAACCSS not to alter AAppaacchhee''ss behaviour
                   (as if there was no ACS_ERROR_HANDLER specified at all).

                3. [url] _U_R_L

                   This form will cause AAppaacchhee to redirect the client to _U_R_L
                   using the GET method. If the url keyword is absent, _U_R_L
                   must begin with the four characters "http". An invalid _U_R_L
                   may be rejected by Apache and treated as a message. The _U_R_L
                   may contain a properly escaped query string; DDAACCSS will
                   append the following parameters, in the order given, to _U_R_L
                   (unless the error name is BY_SIMPLE_REDIRECT, in which case
                   none of these parameters is passed):

                    1. _D_A_C_S___E_R_R_O_R___C_O_D_E, the DDAACCSS error code.

                    2. _D_A_C_S___V_E_R_S_I_O_N, the version number of DDAACCSS (e.g., "1.4").

                    3. _D_A_C_S___F_E_D_E_R_A_T_I_O_N, the federation that received the
                       service request, if available.

                    4. _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N, the jurisdiction that received the
                       service request, if available.

                    5. _D_A_C_S___H_O_S_T_N_A_M_E, the domain name of the host that
                       received the service request, if available.

                    6. _D_A_C_S___U_S_E_R___A_G_E_N_T, if provided by the user agent, this is
                       an identifying string, such as:

                           Mozilla/3.01 (X11; U; Linux 2.4.2 i386)


                    7. _D_A_C_S___R_E_Q_U_E_S_T___M_E_T_H_O_D, the method used to invoke the
                       service request, if available. For example, "GET" or
                       "POST".

                    8. _D_A_C_S___E_R_R_O_R___U_R_L, the service request URL, including any
                       query string component. The values of these parameters
                       are URL encoded.

                4. [localurl] /_l_o_c_a_l_-_U_R_L

                   This form is similar to the absolute URL form except that
                   redirection is to a local URL-path. The _e_r_r_o_r_-_a_c_t_i_o_n must
                   begin with a slash. The URL may contain a properly escaped
                   query string; DDAACCSS will append additional parameters as in
                   the absolute URL form.

                5. [message] \"_a _m_e_s_s_a_g_e\"

                   This form causes AAppaacchhee to emit the given string as the
                   error document. If the message keyword is absent, the
                   string must be surrounded by double quote characters (the
                   quotes do not appear in the final output message).

                       NNoottee
                       Apache always sets the Content-Type for this message to
                       text/html. Although reported quite some time ago, BBuugg
                       33664411[36] is still open. There may be a bug in Apache
                       2.X that prevents the initial double quote in the
                       message from being stripped; see BBuugg 4422443300[37].

                6. expr _e_x_p_r_e_s_s_i_o_n

                   The expr keyword, which cannot be omitted, indicates that
                   the _e_r_r_o_r_-_a_c_t_i_o_n is an expression. The _e_x_p_r_e_s_s_i_o_n is
                   evaluated and its value (a string) is used as the Apache
                   error response. If an error occurs during evaluation, the
                   Apache ErrorDocument or default behaviour will be used.

                   This directive may appear multiple times. Because these
                   directives are stacked, during handler processing
                   directives are examined "backwards", starting from the last
                   one that appears in the relevant jurisdiction section
                   through to the first one that appears in the default
                   section of dacs.conf and backwards through site.conf. The
                   first directive having a _u_r_l___p_a_t_t_e_r_n _a_n_d _e_r_r_o_r_-_c_o_d_e that
                   match the error condition exactly is used. Otherwise, if no
                   such exact match if found, the first directive encountered
                   having the closest _u_r_l___p_a_t_t_e_r_n match and exact _e_r_r_o_r_-_c_o_d_e
                   match is used; failing that, the first directive with the
                   closest _u_r_l___p_a_t_t_e_r_n match and default ("*") _e_r_r_o_r_-_c_o_d_e
                   match is used.

                   Consider these example directives:

                       ACS_ERROR_HANDLER "* reason"
                       ACS_ERROR_HANDLER '903 "Your access has been revoked"'
                       ACS_ERROR_HANDLER "/foo/* * /cgi-bin/dacs/foohandler"
                       ACS_ERROR_HANDLER "/foo/foo.html NO_AUTH /cgi-bin/foo-login.cgi"

                   A request for /foo/foo.html that is denied because the user
                   is not authenticated will cause a redirect to
                   /cgi-bin/foo-login.cgi. If the request is denied for a
                   different reason, the third directive will be used, causing
                   a redirect to /cgi-bin/dacs/foohandler. A request for
                   something not located under /foo that is denied because
                   access is revoked will cause the message specified in the
                   second directive to be displayed to the user, while any
                   other type of error will cause an appropriate explanatory
                   message to be displayed.

                   Here is an example of the expr handler form:

                       ACS_ERROR_HANDLER "* expr '\"&lt;em>Today is&lt;/em> \" . strftime(\"%D\")'"

                   If triggered, this directive will emit a message similar to
                   the following as Apache's custom error response:

                       <em>Today is</em> 05/16/07

                   As with all such messages, Apache forces the Content-Type
                   to be text/html.

                   These two directives are equivalent:

                       ACS_ERROR_HANDLER "* message 'Hello world.'"
                       ACS_ERROR_HANDLER "* \"Hello world.\""

                   The error response returned by Apache will be:

                       Hello world.

                   Any invalid directive will result in AAppaacchhee following its
                   configured behaviour. A directive with a syntactically
                   valid but undefined _e_r_r_o_r_-_c_o_d_e is ignored, however.

                   In the case where the service request was issued by
                   IInntteerrnneett EExxpplloorreerr, if the length of the error response by
                   the server isn't greater than some magic value and IIEE's
                   "Show friendly HTTP error messages" is enabled, which it is
                   by default, then IIEE will ignore the custom message. When
                   the "message" and "reason" handler types are used, DDAACCSS
                   adds some padding to thwart IIEE's "cleverness". For other
                   handler types, the administrator is responsible for working
                   around this problem.

                       NNoottee
                       Care must be taken to avoid improper operation (such as
                       a potentially infinite regress) if a CGI program
                       invoked to handle an error is itself protected by DDAACCSS.
                       One example is the situation where a user's access has
                       been revoked and is therefore unable to access any
                       DDAACCSS-protected resource. If an error occurs while DDAACCSS
                       is processing a request for a handler, DDAACCSS will fall
                       back to AAppaacchhee's default behaviour, ignoring any
                       normally applicable ACS_ERROR_HANDLER directives.

               ACS_FAIL (Optional1)
                   If ddaaccss__aaccss denies access, the given expression is
                   evaluated just before the AACCSS__EERRRROORR__HHAANNDDLLEERR[16] directive,
                   if any, is processed. This directive provides a hook for
                   post-authorization actions to be performed. The namespaces
                   in effect during authorization processing are accessible to
                   the expression. The value of the expression is discarded
                   and any errors are ignored.

               ACS_INACTIVITY_LIMIT_SECS (Optional1)
                   This directive enables inactivity detection if it is set to
                   a non-zero unsigned integer. Inactivity detection is
                   applicable only when valid selected credentials accompany a
                   request (i.e., at least one identity is associated with the
                   request - see ddaaccss__sseelleecctt__ccrreeddeennttiiaallss((88))[38]).

                   There are two cases. If an activity tracking cookie is not
                   sent with the current request (see AACCSS__TTRRAACCKK__AACCTTIIVVIITTYY[39]),
                   the user is deemed to be inactive if the newest credentials
                   are older than ACS_INACTIVITY_LIMIT_SECS seconds. If an
                   activity tracking cookie is received, the user is deemed to
                   be inactive if the date/time that it asserts is older than
                   ACS_INACTIVITY_LIMIT_SECS seconds. If inactivity is
                   detected by ddaaccss__aaccss((88))[5], access is denied and an
                   INACTIVITY error (990099) is raised; see
                   AACCSS__EERRRROORR__HHAANNDDLLEERR[16]. At present, the only way for a user
                   to continue after an inactivity error is to explicitly
                   delete DDAACCSS cookies or implicitly delete them by restarting
                   the browser. A non-DDAACCSS-wrapped web page or CGI program
                   might be invoked as an error handler to assist.

                   Different jurisdictions may independently configure
                   different inactivity thresholds, disable inactivity
                   detection, or disable activity tracking - the degree to
                   which this feature improves security or is annoying to
                   users depends on thoughtful cooperation amongst
                   jurisdictions and adequate clock synchronization.

               ACS_POST_BUFFER_LIMIT (Optional1)
                   This is the counterpart to the SSeettDDAACCSSAAuutthhPPoossttBBuuffffeerr[40]
                   directive of DDAACCSS''ss mmoodd__aauutthh__ddaaccss[6] AAppaacchhee module. It
                   establishes the maximum number of bytes of environment and
                   POST stream that DDAACCSS should read from mmoodd__aauutthh__ddaaccss[6],
                   overriding the compile-time default. To allow for encoding
                   overhead when serializing the message body,
                   ACS_POST_BUFFER_LIMIT should be at least 50% larger than
                   the SetDACSAuthPostBuffer size. A value of zero imposes no
                   limit. (Ideally, only one of these values would need to be
                   configured but you must currently ensure that both of them
                   are set to reasonable values.)

               ACS_POST_EXCEPTION_MODE (Optional1)
                   In the event that the web server has not made all of the
                   request's arguments available to DDAACCSS for access control
                   processing (see SSEERRVVIICCEE__AARRGGSS__TTRRUUNNCCAATTEEDD[41]), this directive
                   tells ddaaccss__aaccss((88))[5] what to do. The following keywords are
                   recognized values:

                   abort
                       Access control processing stops and access is denied.

                   default
                       This is equivalent to discard.

                   discard
                       Processing continues, but all web service arguments are
                       ignored and none will be available to access control
                       rules.

                   proceed
                       Continue processing, even though one or more arguments
                       may be corrupted or missing. This may result in a
                       segmentation fault or other unrecoverable error.

                   query
                       Continue processing, discarding all POST arguments but
                       including any arguments that were passed in the request
                       URI's query component.


               ACS_PRE_AUTH (Optional)
                   Similar to the pre-authorization authentication feature
                   configured through the HHTTTTPP__AAUUTTHH[42] directive, this
                   directive provides a way to authenticate - or identify - a
                   user at access control time. Rather than involving HTTP
                   Basic or Digest authentication, however, the value of the
                   directive is an expression that is evaluated. If the result
                   is a ssyynnttaaccttiiccaallllyy vvaalliidd uusseerrnnaammee[43], credentials are
                   created that (normally) exist only for the duration of the
                   authorization check and which are associated with the
                   ccuurrrreenntt jjuurriissddiiccttiioonn[44]. This directive provides a hook
                   for associating an identity with a request _b_a_s_e_d _o_n _t_h_e
                   _r_e_q_u_e_s_t _i_t_s_e_l_f (such as the request URI, its arguments, and
                   other context).

                   As a simple example, the following directive checks if the
                   request includes a _U_S_E_R_N_A_M_E argument, and if so, just uses
                   it:

                       ACS_PRE_AUTH '${Args::USERNAME:e} ? ${Args::USERNAME} : ""'

                   Note the single quotes around the expression so that it is
                   evaluated at access control time instead of configuration
                   processing time.

                   The ACS_PRE_AUTH directives are processed if a request is
                   received that does not include valid credentials and if not
                   disabled by AACCSS__AAUUTTHHEENNTTIICCAATTEEDD__OONNLLYY[45]. If more than one
                   ACS_PRE_AUTH directive is given, they are evaluated in the
                   order in which they appear until one returns a valid
                   username. If that expression sets the variable
                   _$_{_A_u_t_h_:_:_R_O_L_E_S_} to a valid role string, it will be included
                   in the credentials (see ddaaccss__aauutthheennttiiccaattee((88))[46]).
                   Evaluation errors are ignored. If no expression returns a
                   valid username, access control processing continues.

                   These directives are processed before any HTTP_AUTH
                   directives; if a ACS_PRE_AUTH directive is successful, the
                   user will effectively be authenticated and so no HTTP_AUTH
                   directives will be processed.

                   If the request includes a --rrnnaammee flag with the DDAACCSS__AACCSS[47]
                   argument, its value is _$_{_A_r_g_s_:_:_R_N_A_M_E_}.

                   Unlike when authentication is done through
                   ddaaccss__aauutthheennttiiccaattee((88))[48], _c_r_e_d_e_n_t_i_a_l_s _a_r_e _n_o_t _r_e_t_u_r_n_e_d _t_o
                   _t_h_e _c_l_i_e_n_t. This means that no DDAACCSS session state exists
                   outside of ddaaccss__aaccss and therefore some DDAACCSS web services
                   may be unavailable or may not operate in the same way they
                   would if credentials were provided by the client. This
                   mechanism may also be less efficient than one that returns
                   credentials because authentication will be performed each
                   and every time the client makes a request that triggers it.

               ACS_SUCCESS (Optional)
                   If ddaaccss__aaccss grants access, immediately before it terminates
                   it evaluates the given expression. This directive provides
                   a hook for post-authorization actions to be performed,
                   which can be user-specific. The namespaces in effect during
                   authorization processing are accessible to the expression.
                   The value of the expression is discarded and any errors are
                   ignored.

                   Also see the oonn__ssuucccceessss(())[49] function.

                       NNoottee
                       While it is typically true that if DDAACCSS grants a
                       request, the web server will go on to process the
                       request (and eventually return a web page to the user
                       agent, execute a program, etc.), it is not necessarily
                       so. For example, access may still be denied by the web
                       server for other reasons, or an error can occur during
                       subsequent processing. This may be relevant in
                       situations where ACS_SUCCESS is used to decrement a
                       ccoouunntteerr[50], for instance, because it is possible that
                       the user may not actually see a successful result, in
                       which case the counter value should not have been
                       changed and so corrective action would be required.

               ACS_TRACK_ACTIVITY (Optional1)
                   This directive is associated with the inactivity timeout
                   feature whereby an authenticated user is denied access (at
                   any jurisdiction where it is enabled within the ccuurrrreenntt
                   ffeeddeerraattiioonn[51]) if no web service request is made within a
                   certain time period (also at any jurisdiction where it is
                   enabled within the ccuurrrreenntt ffeeddeerraattiioonn[51]). See
                   AACCSS__IINNAACCTTIIVVIITTYY__LLIIMMIITT__SSEECCSS[52]. This feature is disabled by
                   default. It is enabled on a per-jurisdiction basis, and in
                   the usual configuration all jurisdictions within a
                   federation will enable the feature if it is required.

                   If the directive's value is "yes", ddaaccss__aaccss((88))[5] emits a
                   federation-wide HTTP cookie that notes the jurisdiction and
                   date/time at which each DDAACCSS-wrapped service request is
                   processed. The cookie is emitted regardless of whether
                   access was granted, although some error conditions may
                   prevent a cookie from being sent. No cookie is set for an
                   effectively unauthenticated request.

                   The name of the activity tracking cookie has the following
                   format:

                       DACS:_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e::::ACTIVITY

                   where _f_e_d_e_r_a_t_i_o_n_-_n_a_m_e is the official name assigned to the
                   federation for which the cookie is valid
                   (FFEEDDEERRAATTIIOONN__NNAAMMEE[53]). Activity tracking may be enabled
                   without enabling inactivity detection (via
                   AACCSS__IINNAACCTTIIVVIITTYY__LLIIMMIITT__SSEECCSS[52]). This feature depends on an
                   appropriate level of clock synchronization at all
                   participating jurisdictions.

               ADMIN_IDENTITY (Optional)
                   This repeatable directive specifies a DDAACCSS identity (group
                   names are currently not allowed) that DDAACCSS grants special
                   privileges. If omitted, the ccuurrrreenntt ffeeddeerraattiioonn aanndd
                   jjuurriissddiiccttiioonn[51] are implied. The usernames "unauth" and
                   "unauthenticated" are disallowed, whether qualified with a
                   jurisdiction or not. The function ddaaccss__aaddmmiinn(())[54] tests
                   whether the user making a service request has any
                   credentials that match any ADMIN_IDENTITY. This enables
                   boilerplate access control rules to be written that need to
                   restrict access to an administrator - the rules need only
                   invoke ddaaccss__aaddmmiinn(()). Changes to the list of DDAACCSS
                   administrators take effect immediately. Comparison of these
                   identities with credentials is controlled by the
                   NNAAMMEE__CCOOMMPPAARREE[55] directive.

                   Some DDAACCSS services call an internal version of this
                   function to ensure certain operations are limited to a DDAACCSS
                   administrator.

                       SSeeccuurriittyy
                       Consider requiring more secure authentication for
                       administrator identities, such as using a two-factor
                       authentication method or combining two different
                       authentication methods.

               ALLOW_HTTP_COOKIE (Optional1)
                   If "yes", DDAACCSS components will allow the environment
                   variable HHTTTTPP__CCOOOOKKIIEE to be used to pass DDAACCSS credentials.
                   This is currently necessary when DDAACCSS components are
                   invoked through IIS (except in conjunction with DDAACCSS
                   proxied operation). On secure systems, this method of
                   passing credentials may be acceptable, but in general it is
                   not secure and must not be allowed because environment
                   variables are essentially public on some systems. If
                   undefined or not "yes", DDAACCSS components will fail if
                   HHTTTTPP__CCOOOOKKIIEE is present.

               AUTH_AGENT_ALLOW_ADMIN_IDENTITY (Optional1)
                   Unless this directive has the value "yes", ddaaccss__aauutthh__aaggeenntt
                   will not return credentials that have been designated as an
                   ADMIN_IDENTITY.

               AUTH_CREDENTIALS_ADMIN_LIFETIME_SECS (Optional1)
                   The lifetime, in seconds, of all credentials created by
                   this jurisdiction for internal use. These credentials are
                   used in certain internal transactions, such as when
                   ddaaccss__aauutthheennttiiccaattee sends an HTTP request to an
                   authentication or roles module. Although they are only
                   supposed to be held by trusted components, because these
                   credentials can convey special privileges their lifetime
                   should not be much longer than required. It is sometimes
                   necessary to increase this lifetime when debugging or if a
                   recipient server is slow.

               AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS (Required1)
                   The default lifetime, in seconds, of all credentials
                   created by this jurisdiction for users. The jurisdiction's
                   authentication services may override this value on a
                   case-by-case basis, either through an authentication module
                   (see aauutthh__rreeppllyy..ddttdd[56]) or by setting
                   _$_{_A_u_t_h_:_:_C_R_E_D_E_N_T_I_A_L_S___L_I_F_E_T_I_M_E___S_E_C_S_} (see
                   ddaaccss__aauutthheennttiiccaattee((88))[48]).

                       SSeeccuurriittyy
                       The lifetime should be chosen such that it strikes a
                       balance between security and user convenience that is
                       appropriate for the jurisdiction and federation.

               AUTH_ERROR_HANDLER (Stack)
                   If ddaaccss__aauutthheennttiiccaattee((88))[48] is not able to successfully
                   authenticate a user, the resulting action can be customized
                   in ways that depend on the reason for the failure. This
                   provides a way for the system administrator to display a
                   custom error message or redirect the user's browser.

                       NNoottee
                       This feature is activated only if ddaaccss__aauutthheennttiiccaattee is
                       passed an _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S parameter that has a
                       value of 1.
                   The following error code numbers and corresponding
                   descriptive text are defined:

                       800 Authentication failed, invalid authenticating information
                       801 Authentication failed, invalid argument
                       802 Authentication failed, internal error
                       899 Authentication failed, reason unknown

                   When this type of response is returned, a program needs to
                   only examine the three digit code to determine why access
                   was denied. No blanks may precede the code, any number of
                   blanks may follow it. The descriptive-text consists only of
                   printable characters (e.g., no tabs or newlines) and may
                   not contain a colon. The descriptive-text is subject to
                   change, but the meaning of the code number is fixed.
                   Optionally, the standard text may be followed by a single
                   space, a colon, at least one space, and a more detailed
                   error message.

                   The ddaaccss__aauutthheennttiiccaattee service recognizes a _F_O_R_M_A_T argument
                   that is used to select between an XML-aware user agent
                   (FORMAT=XML) and an HTML capable user agent (_F_O_R_M_A_T is not
                   specified or is not XML). In the case of an XML result,
                   ddaaccss__aauutthh__rreeppllyy..ddttdd[57] is used. The behaviour of this
                   directive with respect to _F_O_R_M_A_T is described below on a
                   case-by-case basis.

                   The following directives are supported:

                    1. AUTH_ERROR_HANDLER "_A_U_T_H_-_e_r_r_o_r_-_c_o_d_e reason"

                       DDAACCSS will return an HTML (or XML, if FORMAT=XML)
                       document that describes why authentication failed, such
                       as the following:

                           800 Authentication failed, invalid authenticating information

                       This is the default behaviour.

                    2. AUTH_ERROR_HANDLER "_A_U_T_H_-_e_r_r_o_r_-_c_o_d_e [url] _U_R_L"

                       This form causes DDAACCSS to redirect the client to the
                       specified URL, which may be a relative or absolute URL.
                       If the keyword url is absent, _U_R_L must begin with the
                       four characters http. The GET method will be used. The
                       URL may contain a properly escaped query string; DDAACCSS
                       will append the following parameters, in the order
                       given, to the URL:

                        1. _D_A_C_S___E_R_R_O_R___C_O_D_E, the AUTH-error-code that
                           identifies the failure.

                        2. _D_A_C_S___V_E_R_S_I_O_N, the version number of DDAACCSS (e.g.,
                           "1.4").

                        3. _D_A_C_S___F_E_D_E_R_A_T_I_O_N, the federation that received the
                           service request, if available.

                        4. _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N The jurisdiction that received
                           the service request, if available.

                        5. _F_O_R_M_A_T, the value of this parameter will be either
                           HTML or XML, as determined by the value of the
                           parameter of the same name passed to
                           ddaaccss__aauutthheennttiiccaattee or the default (HTML if _F_O_R_M_A_T
                           was not specified).
                           The values of these parameters are URL encoded.

                        3. AUTH_ERROR_HANDLER "_A_U_T_H_-_e_r_r_o_r_-_c_o_d_e [file]
                           _f_u_l_l_-_p_a_t_h_n_a_m_e"

                           This form causes the contents of the file named by
                           _f_u_l_l_-_p_a_t_h_n_a_m_e to be returned without regard to the
                           presence of a _F_O_R_M_A_T argument.

                               NNoottee
                               The file must include any header lines it
                               requires, such as a Content-Type line, a
                               header-terminating blank line, and then the
                               document content. Note also that the
                               "full-pathname" usage differs from the
                               "local-URL" usage of the ACS_ERROR_HANDLER
                               directive, though both elements begin with a
                               slash character; the former specifies the
                               absolute pathname of a file, while the latter
                               specifies a URL local to the receiving web
                               server.

                        4. AUTH_ERROR_HANDLER "_A_U_T_H_-_e_r_r_o_r_-_c_o_d_e [message]
                           \"_m_e_s_s_a_g_e\""

                           This form causes the given message, surrounded by
                           escaped double quote characters, to be returned as
                           HTML (or XML if FORMAT=XML).
                           The optional keywords are treated
                           case-insensitively.

                           The _A_U_T_H_-_e_r_r_o_r_-_c_o_d_e is either a defined
                           authentication error code (listed above) or the
                           special symbol "*", which means the directive
                           applies to any authentication error code for which
                           there is no explicit directive.

                           This directive may appear multiple times, although
                           multiple directives for the same _A_U_T_H_-_e_r_r_o_r_-_c_o_d_e
                           are not allowed. Any invalid directive will
                           generally be treated as a fatal error. A directive
                           with a syntactically valid but undefined
                           _A_U_T_H_-_e_r_r_o_r_-_c_o_d_e is ignored, however.

                       AUTH_FAIL (Optional1)
                           If ddaaccss__aauutthheennttiiccaattee fails to authenticates a user,
                           the given expression is evaluated just before the
                           AAUUTTHH__EERRRROORR__HHAANNDDLLEERR[58] directive, if any, is
                           processed. This directive provides a hook for
                           post-authentication actions to be performed. The
                           namespaces in effect during authentication
                           processing are accessible to the expression. The
                           value of the expression is discarded and any errors
                           are ignored. Note that since authentication failed,
                           only the user's purported identity may be available
                           (_$_{_A_r_g_s_:_:_U_S_E_R_N_A_M_E_}), or if the user was previously
                           authenticated successfully, as _$_{_E_n_v_:_:_R_E_M_O_T_E___U_S_E_R_}.

                       AUTH_FAIL_DELAY_SECS (Optional1)
                           If assigned a positive integer value, a particular
                           user (ordinarily the one identified by the _U_S_E_R_N_A_M_E
                           argument to ddaaccss__aauutthheennttiiccaattee) will not be allowed
                           to reauthenticate following a failed attempt within
                           this many seconds. If assigned the value of zero
                           seconds, this feature is disabled. If this
                           directive is absent or assigned an illegal value, a
                           compile-time value is used instead. Authentication
                           modules may indirectly impose their own delays
                           following unsuccessful authentication; this is
                           system dependent and not under the control of DDAACCSS.

                       AUTH_SINGLE_COOKIE (Optional1)
                           By default, each set of credentials that is
                           returned in an HTTP cookie is assigned a ccooookkiiee
                           nnaammee[59] that corresponds to the identity
                           represented by the credentials. If a user
                           authenticates as two different identities through
                           ddaaccss__aauutthheennttiiccaattee, for example, he will be given
                           two cookies with different names. Because in some
                           situations multiple credentials can be problematic,
                           this directive provides a way to effectively limit
                           a request to a single set of credentials by using
                           one cookie name for all credentials. When an
                           already-authenticated user authenticates again,
                           either at the same jurisdiction or any
                           jurisdiction, the user's browser will replace the
                           previous cookie with the new one.

                           This directive also controls cookie names
                           associated with credentials generated by
                           ddaaccssccooookkiiee((11))[29], ddaaccss__aauutthh__aaggeenntt((88))[60], and
                           ddaaccss__aauutthh__ttrraannssffeerr((88))[27]. Also see
                           AACCSS__CCRREEDDEENNTTIIAALLSS__LLIIMMIITT[61].

                           By setting AUTH_SINGLE_COOKIE to "jurisdiction"
                           (case insensitive), the username component of an
                           authentication cookie issued by the jurisdiction is
                           suppressed. This means that every authentication
                           cookie it creates will have the same name. By
                           setting it to "federation" (case insensitive), the
                           jurisdiction and username components of an
                           authentication cookie issued by the jurisdiction
                           are suppressed. This means that every
                           authentication cookie that it creates will have the
                           same name, but also that any two jurisdictions that
                           use this configuration will create cookies with the
                           same name. Any other value results in the default
                           behaviour, which is to include both the
                           jurisdiction name and the username in the names of
                           authentication cookies. The directive has no effect
                           on the name of the identity encapsulated within an
                           HTTP cookie.

                           If an authentication cookie is received that was
                           created by the jurisdiction and has a cookie name
                           with a component that it has been configured to
                           suppress, the cookie is ignored. A cookie issued by
                           a different jurisdiction with a suppressed cookie
                           name component is acceptable regardless of how this
                           directive is configured at this jurisdiction.  DDAACCSS
                           will reject all credentials if a request includes
                           more than one cookie with the same cookie name.

                           In typical use, each jurisdiction that performs
                           authentication will configure this directive
                           identically. To limit each user to associating a
                           single identity with their request, simply set
                           AUTH_SINGLE_COOKIE to "federation" at each
                           jurisdiction in the federation.

                               SSeeccuurriittyy
                               This directive indirectly limits the number of
                               credentials that can be associated with a
                               single request. It does not prevent the same
                               individual from sending different requests,
                               from the same browser or different browsers,
                               each associated with a different identity.
                               Also, it does not limit the number of
                               concurrent logins of the same identity (such as
                               by different individuals sharing the same
                               account).

                               Changing this directive's value may render
                               existing credentials invalid at this
                               jurisdiction. For example, after changing the
                               directive it is possible for a user to obtain
                               two authentication cookies with different names
                               for the same identity.  DDAACCSS does not allow a
                               request to include multiple credentials for the
                               same identity.

                       AUTH_SUCCESS (Optional)
                           If ddaaccss__aauutthheennttiiccaattee successfully authenticates a
                           user, the given expression is evaluated just before
                           the AAUUTTHH__SSUUCCCCEESSSS__HHAANNDDLLEERR[62] directive, if any, is
                           processed. This directive provides a hook for
                           post-authentication actions to be performed, which
                           can be user-specific. The namespaces in effect
                           during authentication processing are accessible to
                           the expression. The value of the expression is
                           discarded and any errors are ignored.

                           Also see the oonn__ssuucccceessss(())[49] function.

                           As an example, the following directive will run a
                           web service after every successful login:

                               AUTH_SUCCESS 'https://internal.example.com/cgi-bin/userlogin?USERNAME=${Auth::IDENTITY}'


                       AUTH_SUCCESS_HANDLER (Optional1)
                           If ddaaccss__aauutthheennttiiccaattee successfully authenticates a
                           user, the resulting action can be customized. This
                           provides a way for the DDAACCSS administrator to
                           redirect a user's browser after login.

                               NNoottee
                               This feature is enabled only if
                               ddaaccss__aauutthheennttiiccaattee is passed an
                               _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S parameter that has a value
                               of 1.
                           The ddaaccss__aauutthheennttiiccaattee service recognizes a _F_O_R_M_A_T
                           argument that is used to select between an
                           XML-aware user agent (FORMAT=XML) and an HTML
                           capable user agent (_F_O_R_M_A_T is not specified or is
                           not XML). In the case of an XML result,
                           ddaaccss__aauutthh__rreeppllyy..ddttdd[57] is used. The behaviour of
                           this directive with respect to _F_O_R_M_A_T is described
                           below on a case-by-case basis.

                           The following syntaxes are supported:

                            1. AUTH_SUCCESS_HANDLER "[url] _U_R_L"

                               This form causes DDAACCSS to redirect the client to
                               _U_R_L, which may be a relative or absolute URL.
                               If the keyword url is absent, _U_R_L must begin
                               with the four characters http. The GET method
                               will be used. The URL may contain a properly
                               escaped query string; DDAACCSS will append the
                               following parameters, in the order given, to
                               the URL:

                               _D_A_C_S___V_E_R_S_I_O_N
                                   The version number of DDAACCSS (e.g., "1.4").

                               _D_A_C_S___F_E_D_E_R_A_T_I_O_N
                                   The federation that received the service
                                   request, if available.

                               _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
                                   The jurisdiction that received the service
                                   request, if available.

                               _D_A_C_S___U_S_E_R_N_A_M_E
                                   The username associated with the new
                                   credentials.

                               _F_O_R_M_A_T
                                   The value of this parameter will be either
                                   HTML or XML, as determined by the value of
                                   the parameter of the same name passed to
                                   ddaaccss__aauutthheennttiiccaattee or the default (HTML if
                                   _F_O_R_M_A_T was not specified).

                               The values of these parameters are URL encoded.

                            2. AUTH_SUCCESS_HANDLER "[file] _f_u_l_l_-_p_a_t_h_n_a_m_e"

                               This form causes the contents of the file named
                               by _f_u_l_l_-_p_a_t_h_n_a_m_e to be returned without regard
                               to the presence of a _F_O_R_M_A_T argument. The file
                               must include any header lines it requires, such
                               as a Content-Type line, a header-terminating
                               blank line, and then the document content.

                                   NNoottee
                                   The "full-pathname" usage differs from the
                                   "local-URL" usage of the ACS_ERROR_HANDLER
                                   directive, though both elements begin with
                                   a slash character; the former specifies the
                                   absolute pathname of a file, while the
                                   latter specifies a URL local to the
                                   receiving web server. To specify a relative
                                   URL, use the url keyword.

                            3. AUTH_SUCCESS_HANDLER "[message] \"_m_e_s_s_a_g_e\""

                               This form causes the given message, surrounded
                               by escaped double quote characters, to be
                               returned as HTML (or XML if FORMAT=XML).

                            4. AUTH_SUCCESS_HANDLER "credentials"

                               This form causes the user's credentials to be
                               displayed, either as an HTML or XML (if
                               FORMAT=XML) document. This is the default
                               behaviour.
                               The optional keywords are treated
                               case-insensitively.

                           AUTH_TRANSFER_EXPORT (Optional)
                               Each use of this directive identifies a target
                               federation and the corresponding URL of a
                               program to invoke the TOKEN operation phase of
                               the protocol in that federation. The federation
                               identifier is simply a label; it must be a
                               syntactically valid federation name. Whitespace
                               separates the federation name from the URL.
                               Please refer to ddaaccss__aauutthh__ttrraannssffeerr((88))[27] for
                               details.

                           AUTH_TRANSFER_TOKEN_LIFETIME_SECS (Optional1)
                               This is the lifetime, in seconds, of a token
                               produced by the TOKEN operation of
                               ddaaccss__aauutthh__ttrraannssffeerr((88))[27] and consumed by its
                               IMPORT operation. That is, it is the time a
                               user (or middleware) has to submit the token
                               before it becomes invalid. It should be on the
                               order of a few seconds.

                           COMPAT_MODE (Optional1)
                               This indicates that, to the extent possible,
                               credentials issued by a different release of
                               DDAACCSS should be accepted. At present, the only
                               supported values are off (the default, which
                               disables this mode) and 1.2.

                                   IImmppoorrttaanntt
                                   This directive is _n_o_t intended to provide
                                   complete interoperability among DDAACCSS
                                   releases and in fact it does not in certain
                                   situations. Old releases of DDAACCSS may
                                   contain security-related bugs, or may rely
                                   on third-party software that contains
                                   security-related bugs.  DDAACCSS installations
                                   are urged to upgrade rather than to depend
                                   on the limited backward compatibility
                                   supplied by this directive.  _T_h_e_r_e _i_s _n_o
                                   _g_u_a_r_a_n_t_e_e _t_h_a_t _a_n_y _p_a_r_t_i_c_u_l_a_r _l_e_v_e_l _o_f
                                   _b_a_c_k_w_a_r_d _c_o_m_p_a_t_i_b_i_l_i_t_y _w_i_l_l _b_e _c_a_r_r_i_e_d
                                   _f_o_r_w_a_r_d _i_n _s_u_b_s_e_q_u_e_n_t _r_e_l_e_a_s_e_s _o_f DDAACCSS.

                           COOKIE_HTTPONLY (Optional1)
                               If "yes", the HttpOnly attribute will be
                               included with cookies produced by DDAACCSS. This
                               attribute is a Microsoft extension that is used
                               to "mmiittiiggaattee tthhee rriisskk ooff iinnffoorrmmaattiioonn ddiisscclloossuurree
                               wwiitthh aa ccrroossss--ssiittee ssccrriippttiinngg ((XXSSSS)) aattttaacckk[63]".
                               This attribute is not recognized by all
                               browsers but these browsers should ignore it.
                               The default is "no".

                                   SSeeccuurriittyy
                                   Methods of defeating this attribute
                                    aarree kknnoowwnn[64], so administrators may need
                                   to take additional precautions against XSS
                                   attacks.

                           COOKIE_NO_DOMAIN (Optional1)
                               If "yes", no domain attribute will appear when
                               DDAACCSS returns a cookie, such as after
                               authenticating successfully from a browser. The
                               browser will take the default action, which is
                               to associate the cookie with the domain name or
                               IP address of the request that returned the
                               cookie. This will obviously limit DDAACCSS''ss single
                               sign-on feature since the cookie (credentials)
                               will only be sent with requests made to that
                               domain name or IP address.

                               This directive is sometimes useful when DDAACCSS is
                               deployed in an environment where fully
                               qualified domain names are not used. In this
                               case, FEDERATION_DOMAIN must still be
                               configured, although it will not be used in
                               conjunction with the domain of cookies.

                               The default is "no".

                           COOKIE_PATH (Optional1)
                               This allows the path component of a Set-Cookie
                               (and Set-Cookie2) HTTP response header to be
                               specified for the jurisdiction. These headers
                               are sent to a user agent after successful
                               authentication or signout. Refer to the
                               NNeettssccaappee HHTTTTPP CCooookkiieess SSppeecciiffiiccaattiioonn[65] and RRFFCC
                               22996655[66] for details.

                                   SSeeccuurriittyy
                                   The default value is "/", which means that
                                   the cookie will be sent by a user agent
                                   along with _e_v_e_r_y request sent to the
                                   jurisdiction's host. The value should be
                                   set to the most specific URL path under
                                   which all DDAACCSS-wrapped services appear so
                                   that DDAACCSS credentials will only be sent
                                   with requests to those URLs. It is critical
                                   to do this if your server runs arbitrary
                                   user CGI programs because a malicious user
                                   might be able to cause a DDAACCSS-authenticated
                                   user to visit a service that is not
                                   DDAACCSS-wrapped and capture cookies that
                                   represent DDAACCSS identities. For example, if
                                   a jurisdiction segregated its DDAACCSS-wrapped
                                   static content under /dacs/content and its
                                   DDAACCSS-wrapped CGI programs under
                                   /dacs/cgi-bin, then COOKIE_PATH should have
                                   the value "/dacs".

                           CSS_PATH (Optional1)
                               This path is used as the value of the href
                               attribute of the HTML link element used to
                               specify the root location of style files used
                               by HTML-producing DDAACCSS web services and
                               utilities. The mapping between this path and a
                               local directory, if any, depends on AAppaacchhee''ss
                               configuration; for example, if its value is
                               "/css", the location of the corresponding
                               directory will depend on the location of the
                               server's document root and any applicable Alias
                               directive.

                               If this directive is not used, a compile-time
                               default of "/css" is used, which assumes that
                               an AAppaacchhee directive like this one is used:

                                   Alias /css "/usr/local/dacs/www/css/"

                               Please refer to ddaaccss..iinnssttaallll((77))[67] for
                               additional information about use of the Alias
                               directive.

                           DTD_BASE_URL (Optional1)
                               When DDAACCSS services are asked to send an XML
                               response (FORMAT=XML) and DTD_BASE_URL is
                               configured, services will emit a DOCTYPE with
                               the keyword SYSTEM followed by a value derived
                               from DTD_BASE_URL; e.g.,

                                   <!DOCTYPE foo SYSTEM "http://example.com/dacs/dtd-xsd/foo.dtd">

                               If DTD_BASE_URL is not configured, an internal
                               DTD will be emitted. Also see the description
                               of the _F_O_R_M_A_T web service argument[68].

                           EVAL (Optional)
                               The EVAL directive is special in that it may
                               appear in any clause and because it is _a_l_w_a_y_s
                               _e_v_a_l_u_a_t_e_d _w_h_e_n _i_t _i_s _f_i_r_s_t _s_e_e_n during
                               processing of site.conf, the Default section of
                               dacs.conf, or the applicable Jurisdiction
                               section of dacs.conf (i.e., before any section
                               merging occurs). The purpose of the directive
                               is purely for its side effect, such as
                               initializing a configuration variable (see
                               AAddvvaanncceedd TTeecchhnniiqquueess[69]). Because these
                               directives are scanned early during
                               configuration processing, their right-hand
                               sides cannot reference directives as
                               configuration variables because those
                               directives have not yet been evaluated (so they
                               cannot reference _$_{_C_o_n_f_:_:_F_E_D_E_R_A_T_I_O_N___D_O_M_A_I_N_},
                               for example). Example:

                                   EVAL ${Conf::a_special_path} = "/my/path"


                           FEDERATION_DOMAIN (Required1)
                               The suffix of the domain name (RRFFCC 11003355[70]
                               2.3.1) that is common to all jurisdictions in
                               the federation. Note that the domain name
                               associated with a jurisdiction is not
                               explicitly configured (but see dacs_url in
                               ddaaccss..ggrroouuppss((55))[71]), and that this is a
                               one-to-many association (see ddaaccss..ccoonnff((55))[72]).
                               Example: example.com

                           FEDERATION_NAME (Required1)
                               The name for the federation of jurisdictions.
                               The syntax is the same as for
                               JJUURRIISSDDIICCTTIIOONN__NNAAMMEE[73]: an alphabetic followed
                               by zero or more alphanumeric characters, '-',
                               or '_'. By convention, this is in all-caps,
                               however. Please see ddaaccss((11))[74] for additional
                               information. Example: FEDROOT

                           HTTP_AUTH (Stack)
                               This directive is used to perform user
                               authentication at access control time rather
                               than in a separate step. This authentication is
                               triggered through DDAACCSS''ss internal
                               implementation of HTTP Basic or Digest
                               authentication (see RRFFCC 22661177[75]). If prompting
                               is enabled, the user will be asked for his
                               username and password by the user agent's usual
                               prompting method. If prompting is disabled, the
                               user agent must know how to send an
                               Authorization request header without first
                               receiving a WWW-Authenticate response header.
                               The username and password obtained from the
                               user can be directed to any suitable DDAACCSS
                               authentication method for validation. The
                               resulting identity is associated with the
                               ccuurrrreenntt jjuurriissddiiccttiioonn[44].

                               Other than by placing the resource or resources
                               specified by this directive under the control
                               of DDAACCSS, no additional AAppaacchhee configuration
                               needs to be done to use this feature. Please
                               refer to the section on HHTTTTPP AAuutthheennttiiccaattiioonn[76]
                               for additional information about this feature
                               and how it is used. Also consult the
                               HHTTTTPP__AAUUTTHH__EENNAABBLLEE[77] directive.

                               Two different mechanisms are available:
                               _p_r_e_-_a_u_t_h_o_r_i_z_a_t_i_o_n testing and
                               _p_o_s_t_-_a_u_t_h_o_r_i_z_a_t_i_o_n testing. The
                               HTTP_AUTH_ENABLE directive is used to enable
                               one or both mechanisms.

                               The _p_r_e_-_a_u_t_h_o_r_i_z_a_t_i_o_n testing mechanism is used
                               if:

                                1. a request is received that does not include
                                   valid credentials;

                                2. the feature is enabled by HTTP_AUTH_ENABLE
                                   (i.e., it is set to "pre_acs_only" or
                                   "both") and not disabled by
                                   AACCSS__AAUUTTHHEENNTTIICCAATTEEDD__OONNLLYY[45];

                                3. no AACCSS__PPRREE__AAUUTTHH[78] directive is
                                   successful;

                                4. the applicable directive includes the --pprree
                                   flag (sseeee bbeellooww[79]); and

                                5. either the request includes an
                                   Authorization request header or the return
                                   of an HTTP WWW-Authenticate response header
                                   is enabled.
                                   This mechanism can be useful with simple
                                   user agents that understand Basic
                                   authentication but cannot handle
                                   redirection or sometimes even the
                                   WWW-Authenticate response header. It may
                                   also be appropriate in situations where a
                                   user agent cannot or will not handle HTTP
                                   cookies. If ddaaccss__aaccss is allowed to respond
                                   with a WWW-Authenticate response header,
                                   the configuration variable
                                   _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___4_0_1_} must be set to
                                   "yes".

                                   The _p_o_s_t_-_a_u_t_h_o_r_i_z_a_t_i_o_n testing mechanism is
                                   used if:

                                    1. a request is denied because the user
                                       was not authenticated;

                                    2. the feature is enabled by
                                       HTTP_AUTH_ENABLE (i.e., it is set to
                                       "post_acs_only" or "both") and not
                                       disabled by ACS_AUTHENTICATED_ONLY;

                                    3. the applicable directive does not
                                       include a --pprree flag (see below).

                                       One important difference between the
                                       two mechanisms is that while the
                                       post-authorization mechanism works by
                                       redirecting the user to
                                       ddaaccss__aauutthheennttiiccaattee((88))[48] after
                                       authorization checking denies a
                                       request, the pre-authorization
                                       mechanism does not involve any
                                       redirection and ddaaccss__aauutthheennttiiccaattee is
                                       not used. Instead, ddaaccss__aaccss performs
                                       authentication internally (by calling
                                       ddaaccssaauutthh as a function) and _c_r_e_d_e_n_t_i_a_l_s
                                       _a_r_e _n_o_t _r_e_t_u_r_n_e_d _t_o _t_h_e _c_l_i_e_n_t;
                                       credentials are created that (normally)
                                       exist only for the duration of the
                                       authorization check, which means that
                                       no DDAACCSS session state exists outside of
                                       ddaaccss__aaccss and therefore some DDAACCSS web
                                       services will either be unavailable or
                                       not operate in the same way they would
                                       if credentials were provided by the
                                       client. Pre-authorization may also be
                                       less efficient than returning
                                       credentials because authentication will
                                       be performed each and every time the
                                       client makes a request that triggers
                                       it. Note that only authentication
                                       modules that implement the password or
                                       expr aauutthheennttiiccaattiioonn ssttyylleess[80] can be
                                       used by this mechanism, and only if no
                                       redirection of the client is necessary.
                                       Because web browsers only prompt for a
                                       username and password, if an _A_U_X_I_L_I_A_R_Y
                                       argument is also required it must be
                                       entered with either the username or
                                       password (i.e., combined in some way,
                                       perhaps separated by punctuation) and
                                       then parsed into an _A_U_X_I_L_I_A_R_Y argument
                                       using a run-time configuration
                                       directive. With pre-authorization,
                                       roles can be assigned to the temporary
                                       credentials (refer to the description
                                       of the --rr flag and the _r_o_l_e_-_m_o_d_u_l_e_-_s_p_e_c
                                       in ddaaccssaauutthh((11))[30] for details).

                                           SSeeccuurriittyy
                                           Like ddaaccssaauutthh and
                                           ddaaccss__aauutthheennttiiccaattee, if ddaaccss__aaccss uses
                                           a built-in module to perform
                                           authentication, it must run setuid
                                           or setgid (cchhmmoodd((22))[81]). to obtain
                                           sufficient privileges to access the
                                           required files; this is true for
                                           Unix password authentication, for
                                           example.

                                       The value of the HTTP_AUTH directive
                                       follows any one of the following three
                                       forms:

                                        1.

                                               _a_u_t_h___s_c_h_e_m_e _a_u_t_h___r_e_a_l_m _u_r_l___p_a_t_t_e_r_n+

                                        2.

                                               _a_u_t_h___s_c_h_e_m_e _a_u_t_h___r_e_a_l_m _u_r_l___p_a_t_t_e_r_n+ -pre [[-param] _p_a_r_a_m_-_s_t_r_i_n_g]
                                                   {-m _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c [_a_u_t_h_-_f_l_a_g]*}+ {-r _r_o_l_e_s_-_m_o_d_u_l_e_-_s_p_e_c}*

                                        3.

                                               except _u_r_l___p_a_t_t_e_r_n+

                                           The first syntactical form is for
                                           the post-authentication mechanism:

                                           +o   _a_u_t_h___s_c_h_e_m_e is the
                                               (case-insensitive)
                                               authentication scheme to use
                                               (e.g., Basic);

                                           +o   _a_u_t_h___r_e_a_l_m is the
                                               (case-sensitive) realm-value
                                               string associated with the
                                               resource (see RRFFCC 22661177[75]);

                                           +o   _u_r_l___p_a_t_t_e_r_n+ is a list of one
                                               or more URI path components
                                               that are matched against the
                                               request for which access was
                                               denied to an unauthenticated
                                               user. Each of these components
                                               is like the _u_r_l___p_a_t_t_e_r_n
                                               attribute used in aacccceessss
                                               ccoonnttrrooll rruulleess[35] in that it
                                               can either specify an exact
                                               match or, by ending in "/*", a
                                               wildcard match; no query
                                               argument component is allowed.
                                               Each _u_r_l___p_a_t_t_e_r_n begins with a
                                               / character.

                                               The second syntactical form is
                                               for the pre-authentication
                                               mechanism. Its first three
                                               components are like those for
                                               the first form, and must appear
                                               in the order specified above.
                                               The following components are
                                               then added, and may follow the
                                               three initial components in any
                                               order:

                                               +o   --pprree selects the
                                                   pre-authorization testing
                                                   mechanism; the default is
                                                   to use post-authorization
                                                   testing. Because each
                                                   _u_r_l___p_a_t_t_e_r_n begins with a /
                                                   character, the --pprree flag
                                                   implicitly ends the
                                                   _u_r_l___p_a_t_t_e_r_n list.

                                               +o   _p_a_r_a_m_-_s_t_r_i_n_g is an optional
                                                   string consisting of
                                                   authentication parameters
                                                   as per RFC 2617 (note:
                                                   Basic auth does not permit
                                                   any optional parameters).
                                                   For clarity, or if
                                                   _p_a_r_a_m_-_s_t_r_i_n_g might be
                                                   confused with another
                                                   syntactic element, it can
                                                   be preceded by a --ppaarraamm
                                                   flag. In the absence of the
                                                   --ppaarraamm flag, any non-flag
                                                   argument is assumed to be
                                                   the _p_a_r_a_m_-_s_t_r_i_n_g. Only one
                                                   _p_a_r_a_m_-_s_t_r_i_n_g is allowed.

                                               +o   --mm _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c
                                                   specifies an authentication
                                                   module using the
                                                   command-line syntax of
                                                   ddaaccssaauutthh((11))[30]. This
                                                   argument must occur at
                                                   least once. Following the
                                                   _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c can be
                                                   zero or more _a_u_t_h_-_f_l_a_g
                                                   arguments to apply to the
                                                   module's authentication
                                                   context. The
                                                   --DD_d_i_r_e_c_t_i_v_e==_v_a_l_u_e flag, --ffjj
                                                   _j_u_r_n_a_m_e flag, and the --ffnn
                                                   _f_e_d_n_a_m_e flag are recognized
                                                   and have the same semantics
                                                   as when used by
                                                   ddaaccssaauutthh((11))[30].

                                               +o   --rr _r_o_l_e_s_-_m_o_d_u_l_e___s_p_e_c
                                                   specifies a roles module.
                                                   This argument may occur
                                                   zero or more times.

                                                   In the third syntactical
                                                   form, the except keyword
                                                   identifies portions of the
                                                   URL space that should _n_o_t
                                                   trigger HTTP
                                                   authentication.

                                                   The HTTP_AUTH directives
                                                   "stack", like the
                                                   AACCSS__EERRRROORR__HHAANNDDLLEERR[16]
                                                   directive.  DDAACCSS will
                                                   search for the first exact
                                                   _u_r_l___p_a_t_t_e_r_n that matches or
                                                   will select the closest
                                                   wildcard _u_r_l___p_a_t_t_e_r_n. Two
                                                   or more directives with the
                                                   same _u_r_l___p_a_t_t_e_r_n should not
                                                   be configured.

                                                   The first of the two
                                                   directives in the following
                                                   example may trigger Basic
                                                   authentication for the
                                                   realm called "Info Realm"
                                                   when either
                                                   /cgi-bin/dacs/dacs_prenv or
                                                   /cgi-bin/dacs/dacs_version
                                                   (relative to the ccuurrrreenntt
                                                   jjuurriissddiiccttiioonn[44]) is
                                                   requested. The second
                                                   directive may trigger Basic
                                                   authentication for the
                                                   realm called "CGI Realm"
                                                   for any other resource
                                                   subordinate to
                                                   /cgi-bin/dacs. The first
                                                   directive will override the
                                                   second because an exact
                                                   match overrides a wildcard
                                                   match.

                                                       HTTP_AUTH "basic \"Info Realm\" /cgi-bin/dacs/dacs_prenv /cgi-bin/dacs/dacs_version"
                                                       HTTP_AUTH "basic \"CGI Realm\"   /cgi-bin/dacs/*"

                                                   In the next example, the
                                                   two directives associate
                                                   the Basic authentication
                                                   scheme with everything
                                                   under /cgi-bin/dacs/,
                                                   except for
                                                   /cgi-bin/dacs/dacs_prenv
                                                   (because the second
                                                   directive is an exact
                                                   match, which overrides the
                                                   first directive):

                                                         HTTP_AUTH "basic \"CGI Realm\" /cgi-bin/dacs/*"
                                                         HTTP_AUTH "except /cgi-bin/dacs/dacs_prenv"


                                                       TTiipp
                                                       An administrator can
                                                       take advantage of
                                                       DDAACCSS''ss active
                                                       configuration
                                                       processing to decide at
                                                       run-time which
                                                       _a_u_t_h___s_c_h_e_m_e,
                                                       _a_u_t_h___r_e_a_l_m, or password
                                                       file to use, for
                                                       instance, perhaps
                                                       depending on the
                                                       request's arguments.
                                                   As an example of
                                                   pre-authorization testing
                                                   authentication, consider
                                                   the following configuration
                                                   directives:

                                                       HTTP_AUTH_ENABLE "pre_acs_only"
                                                       EVAL ${Conf::http_auth_401} = "no"
                                                       HTTP_AUTH "basic \"dacs_prenv Realm\" /cgi-bin/dacs/dacs_prenv -m unix suff"

                                                   The first directive above
                                                   enables this feature. The
                                                   second directive disables
                                                   responding with a
                                                   WWW-Authenticate header -
                                                   changing its value to "yes"
                                                   enables the response. The
                                                   third directive associates
                                                   the DDAACCSS ddaaccss__pprreennvv((88))[82]
                                                   service with the built-in
                                                   Basic authentication
                                                   feature at
                                                   pre-authorization testing
                                                   time. Given this
                                                   configuration, if a client
                                                   requests ddaaccss__pprreennvv but
                                                   does not include
                                                   credentials:

                                                   +o   if no Authorization
                                                       header was sent and
                                                       _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___4_0_1_}
                                                       is "no", then execution
                                                       will proceed as if the
                                                       feature were disabled
                                                       (i.e., the user will be
                                                       unauthenticated)

                                                   +o   if no Authorization
                                                       header was sent and
                                                       _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___4_0_1_}
                                                       is "yes", then DDAACCSS
                                                       will respond with a
                                                       WWW-Authenticate
                                                       response header and 440011
                                                       status code

                                                   +o   if an Authorization
                                                       header was sent, the
                                                       username and password
                                                       will be validated using
                                                       the built-in Unix
                                                       authentication module:

                                                       +o   if authentication
                                                           succeeds, temporary
                                                           credentials will be
                                                           created and used
                                                           for the request,
                                                           but will not be
                                                           returned to the
                                                           client

                                                       +o   if authentication
                                                           fails, access will
                                                           be denied

                                                               TTiipp
                                                               You can create
                                                               an
                                                               Authorization
                                                               header by
                                                               constructing a
                                                               string
                                                               consisting of
                                                               an account
                                                               name, a colon,
                                                               and the
                                                               account's
                                                               password. MIME
                                                               encode the
                                                               resulting
                                                               string - you
                                                               can use
                                                               ddaaccsseexxpprr((11))[83]
                                                               and the
                                                               eennccooddee(())[84]
                                                               function:

                                                                   % dacsexpr
                                                                   > encode(mime, "guest:apassword")
                                                                   "Z3Vlc3Q6YXBhc3N3b3Jk"

                                                               The header for
                                                               the example
                                                               above would
                                                               look like:

                                                                   Authorization: Basic Z3Vlc3Q6YXBhc3N3b3Jk

                                                               And using
                                                               hhttttpp((11))[3], you
                                                               could use the
                                                               flag:

                                                                   -header Authorization "Basic Z3Vlc3Q6YXBhc3N3b3Jk"

                                                       HTTP_AUTH_ENABLE
                                                       (Optional1)
                                                           This directive's
                                                           value must be
                                                           "post_acs_only" if
                                                           only
                                                           post-authorization
                                                           testing HHTTTTPP
                                                           AAuutthheennttiiccaattiioonn[76]
                                                           may be used,
                                                           "pre_acs_only" if
                                                           only
                                                           pre-authorization
                                                           testing HTTP
                                                           authentication may
                                                           be used, or "yes"
                                                           or "both" if either
                                                           mechanism may be
                                                           used. Refer to
                                                           HHTTTTPP__AAUUTTHH[42] for
                                                           additional details.

                                                       HTTP_PROG (Required1)
                                                           The full pathname
                                                           of the executable
                                                           hhttttpp((11))[3] program,
                                                           a utility
                                                           distributed with
                                                           DDAACCSS. This program
                                                           is used by DDAACCSS
                                                           components to
                                                           invoke local
                                                           services,
                                                           optionally using
                                                           SSL.

                                                       INFOCARD_AUDIENCE
                                                       (Optional)
                                                           This directive must
                                                           be configured for
                                                           DDAACCSS to function as
                                                           a Relying Party.
                                                           When DDAACCSS acts as a
                                                           Relying Party, each
                                                           of these directives
                                                           is applied to the
                                                           value of an
                                                           Audience element (a
                                                           URI) in a secure
                                                           token's
                                                           AudienceRestrictionCondition
                                                           element until a
                                                           successful match is
                                                           found. Several
                                                           matching functions
                                                           are available using
                                                           the following
                                                           syntax:

                                                               _f_u_n_c_t_i_o_n [_s_p_a_c_e+ _a_r_g_-_t_o_-_m_a_t_c_h_-_a_g_a_i_n_s_t_-_A_u_d_i_e_n_c_e]


                                                           _f_u_n_c_t_i_o_n is case
                                                           insensitive.

                                                           uri _m_a_t_c_h_-_U_R_I
                                                               The _m_a_t_c_h_-_U_R_I
                                                               is compared
                                                               with the entire
                                                               Audience URI
                                                               for an exact
                                                               URI match. URI
                                                               matching syntax
                                                               is used,
                                                               meaning that
                                                               only the scheme
                                                               and hostname
                                                               components are
                                                               case
                                                               insensitive.

                                                                   INFOCARD_AUDIENCE "uri http://DACS.DSS.CA/infocard-demo"


                                                           any
                                                               Any Audience is
                                                               acceptable.

                                                                   INFOCARD_AUDIENCE "any"


                                                           regex _m_a_t_c_h_-_r_e_g_e_x
                                                           regex/_f_l_a_g_s
                                                           _m_a_t_c_h_-_r_e_g_e_x
                                                               In the first
                                                               form, the
                                                               regular
                                                               expression
                                                               _m_a_t_c_h_-_r_e_g_e_x is
                                                               matched
                                                               (unanchored)
                                                               against the
                                                               Audience URI.
                                                               In the second
                                                               form, one or
                                                               more flags can
                                                               precede the
                                                               regular
                                                               expression: 'i'
                                                               specifies
                                                               case-insensitive
                                                               matching and
                                                               'e' specifies
                                                               "extended"
                                                               regular
                                                               expressions
                                                               rather than the
                                                               default "basic"
                                                               regular
                                                               expressions.
                                                               IEEE Std 1003.2
                                                               ("POSIX.2")
                                                               regular
                                                               expressions are
                                                               supported
                                                               (rreeggeexx((33))[85]).

                                                                   INFOCARD_AUDIENCE "regex/i ^https://dacs.dss.ca:8443"

                                                               The following
                                                               directives are
                                                               equivalent:

                                                                   INFOCARD_AUDIENCE "regex .*"
                                                                   INFOCARD_AUDIENCE "any"


                                                           host _m_a_t_c_h_-_h_o_s_t_n_a_m_e
                                                               The
                                                               _m_a_t_c_h_-_h_o_s_t_n_a_m_e,
                                                               which may be a
                                                               domain name or
                                                               an IP address,
                                                               is matched
                                                               case-insensitively
                                                               against the
                                                               host name in
                                                               the Audience
                                                               URI.

                                                                   INFOCARD_AUDIENCE "host dacs.dss.ca"


                                                           prefix _m_a_t_c_h_-_U_R_I
                                                               The _m_a_t_c_h_-_U_R_I
                                                               is matched
                                                               against the
                                                               Audience URI to
                                                               test if the
                                                               former is a
                                                               prefix of the
                                                               latter. The
                                                               case-sensitivity
                                                               rules for URI
                                                               components is
                                                               respected
                                                               (e.g., the
                                                               scheme and host
                                                               name components
                                                               are treated
                                                               case-insensitively,
                                                               but the path
                                                               components are
                                                               not).

                                                                   INFOCARD_AUDIENCE "prefix https://dacs.dss.ca/infocards"



                                                       INFOCARD_AUDIENCE_RESTRICTION
                                                       (Optional)
                                                           Used by
                                                           ddaaccss__ssttss((88))[86],
                                                           this optional
                                                           directive specifies
                                                           the value of an
                                                           Audience element in
                                                           an
                                                           AudienceRestrictionCondition.

                                                       INFOCARD_CARD_DATETIME_EXPIRES
                                                       (Optional1)
                                                           This optional
                                                           directive specifies
                                                           the date and time
                                                           of expiration for a
                                                           managed InfoCard
                                                           created by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87].
                                                           The XML Schema
                                                           ddaatteeTTiimmee format
                                                           must be used (see
                                                           XXMMLL SScchheemmaa PPaarrtt 22::
                                                           DDaattaattyyppeess SSeeccoonndd
                                                           EEddiittiioonn[88]); e.g.,

                                                               INFOCARD_CARD_DATETIME_EXPIRES "2010-06-15T09:46:31-08:00"

                                                           Also see
                                                           IINNFFOOCCAARRDD__CCAARRDD__LLIIFFEETTIIMMEE__SSEECCSS[89].

                                                       INFOCARD_CARD_DEFS_URL
                                                       (Optional1)
                                                           This optional
                                                           directive is used
                                                           by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           to specify a web
                                                           service that
                                                           defines the claims
                                                           supported by a new
                                                           managed InfoCard.
                                                           If it is not
                                                           defined, the
                                                           default claim
                                                           dacs_identity is
                                                           used. To prevent
                                                           abuse, arbitrary
                                                           compile-time limits
                                                           are imposed on the
                                                           number of claims
                                                           (20) and the
                                                           lengths of various
                                                           claim components:
                                                           name (32 bytes),
                                                           value (64 bytes),
                                                           URI prefix (128
                                                           bytes), label (20
                                                           bytes), and
                                                           description (40
                                                           bytes). (These
                                                           limits should be
                                                           run-time
                                                           configurable.) The
                                                           distribution's
                                                           infocard directory
                                                           includes an example
                                                           program,
                                                           ddeemmoo__ccaarrdd__ddeeffss..pphhpp,
                                                           which documents the
                                                           program's arguments
                                                           and output syntax.

                                                       INFOCARD_CARD_FILL_URL
                                                       (Optional1)
                                                           This optional
                                                           directive is used
                                                           by ddaaccss__ssttss((88))[86]
                                                           to specify a web
                                                           service that
                                                           retrieves the
                                                           values of claims
                                                           requested by a
                                                           Relying Party. If
                                                           it is not defined,
                                                           only the value of
                                                           the default claim
                                                           dacs_identity is
                                                           available. Access
                                                           to this web service
                                                           must be
                                                           appropriately
                                                           restricted and
                                                           secured, although
                                                           it does not need to
                                                           be DDAACCSS-wrapped. It
                                                           is passed special
                                                           DDAACCSS credentials
                                                           (as an HTTP
                                                           cookie). The
                                                           distribution's
                                                           infocard directory
                                                           includes an example
                                                           program,
                                                           ddeemmoo__ffiillll__ccllaaiimmss..pphhpp,
                                                           which documents the
                                                           program's arguments
                                                           and output syntax.

                                                       INFOCARD_CARD_IMAGE_BASE_URL
                                                       (Required1-C)
                                                           This directive is
                                                           required by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87].
                                                           It is the initial
                                                           part of a DDAACCSS VVFFSS
                                                           UURRII[90] from which
                                                           image files for
                                                           managed InfoCards
                                                           can be retrieved.
                                                           The general idea is
                                                           that the particular
                                                           image associated
                                                           with a card depends
                                                           on the STS
                                                           authentication
                                                           credential that is
                                                           used by the card.
                                                           For example, the
                                                           configuration
                                                           variable
                                                           _i_n_f_o_c_a_r_d___c_a_r_d___i_m_a_g_e___p_a_s_s_w_d,
                                                           if set, specifies
                                                           the filename
                                                           (relative to
                                                           INFOCARD_CARD_IMAGE_BASE_URL)
                                                           of an image
                                                           associated with
                                                           InfoCards that use
                                                           the
                                                           username/password
                                                           type of
                                                           authentication
                                                           between its owner
                                                           and the STS; if
                                                           unspecified, a
                                                           compile-time
                                                           default
                                                           (dacs_username_password_credential.png)
                                                           is used. Similarly,
                                                           the variables
                                                           _i_n_f_o_c_a_r_d___c_a_r_d___i_m_a_g_e___c_e_r_t
                                                           (default value:
                                                           dacs_x509certificate_credential.png)
                                                           and
                                                           _i_n_f_o_c_a_r_d___c_a_r_d___i_m_a_g_e___c_a_r_d
                                                           (default value:
                                                           dacs_selfissued_credential.png)
                                                           specify filenames
                                                           for images
                                                           associated with the
                                                           X.509 V3
                                                           certificate
                                                           credential type and
                                                           the self-issued
                                                           InfoCard credential
                                                           type, respectively.
                                                           The value of
                                                           INFOCARD_CARD_IMAGE_BASE_URL
                                                           is typically the
                                                           absolute pathname
                                                           of a directory
                                                           containing the
                                                           image files or the
                                                           initial part of a
                                                           URL to which a
                                                           final path
                                                           component will be
                                                           appended. Also see
                                                           the
                                                           CCAARRDD__IIMMAAGGEE__UURRLL[91]
                                                           argument to
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd.

                                                           An image should be
                                                           in the range of 60
                                                           pixels wide by 45
                                                           pixels high and 200
                                                           pixels wide by 150
                                                           pixels high. Only
                                                           certain image
                                                           formats are allowed
                                                           by the
                                                           specification; the
                                                           image format is
                                                           deduced from the
                                                           filename extension
                                                           (case
                                                           insensitively):
                                                           ".png", ".gif",
                                                           ".tiff" (or
                                                           ".tif"), ".bmp",
                                                           and ".jpeg" (or
                                                           ".jpg"). If the
                                                           format cannot be
                                                           deduced, PNG is
                                                           assumed.

                                                       INFOCARD_CARD_LIFETIME_SECS
                                                       (Optional1)
                                                           If
                                                           INFOCARD_CARD_DATETIME_EXPIRES
                                                           is not defined, the
                                                           expiration date and
                                                           time of a managed
                                                           InfoCard created by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           can be specified
                                                           relative to the
                                                           current time as
                                                           this many seconds.
                                                           If neither this
                                                           directive nor
                                                           INFOCARD_CARD_DATETIME_EXPIRES
                                                           is defined, a
                                                           compile-time
                                                           default lifetime is
                                                           used (currently,
                                                           365 days). Also see
                                                           IINNFFOOCCAARRDD__CCAARRDD__DDAATTEETTIIMMEE__EEXXPPIIRREESS[92].

                                                       INFOCARD_CARD_OUTPUTDIR
                                                       (Optional1)
                                                           If a managed
                                                           InfoCard generated
                                                           by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           is stored in a
                                                           file, it is written
                                                           to this directory.
                                                           The name of the
                                                           file is of the form
                                                           _u_s_e_r_n_a_m_e__r_a_n_d_o_m.crd.
                                                           See
                                                           IINNFFOOCCAARRDD__CCAARRDDIIDD__BBAASSEE__UURRLL[93].

                                                       INFOCARD_CARD_VERSION
                                                       (Optional1)
                                                           This directive is
                                                           used by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           to provide a value
                                                           for the CardVersion
                                                           element in a
                                                           managed InfoCard.
                                                           The default is "1".

                                                       INFOCARD_CARDID_BASE_URL
                                                       (Required1-C)
                                                           This directive is
                                                           required by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87].
                                                           It is used as the
                                                           base URL for the
                                                           CardId of a new
                                                           managed InfoCard.
                                                           If this URL is set
                                                           so that it points
                                                           into the directory
                                                           specified by
                                                           IINNFFOOCCAARRDD__CCAARRDD__OOUUTTPPUUTTDDIIRR[94],
                                                           then the resulting
                                                           CardId URLs can be
                                                           used to fetch the
                                                           card by its owner,
                                                           assuming
                                                           appropriate access
                                                           control rules are
                                                           also configured.
                                                           Also see
                                                           IINNFFOOCCAARRDD__CCAARRDDIIDD__SSUUFFFFIIXX[95].

                                                       INFOCARD_CARDID_SUFFIX
                                                       (Optional1)
                                                           This optional
                                                           directive is used
                                                           by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           and specifies a
                                                           string to be
                                                           appended as a final
                                                           path element to the
                                                           value of
                                                           IINNFFOOCCAARRDD__CCAARRDDIIDD__BBAASSEE__UURRLL[93]
                                                           to form a new
                                                           card's CardId. If
                                                           the value of
                                                           INFOCARD_CARDID_SUFFIX
                                                           is:

                                                           identity
                                                               The specified
                                                               or implied
                                                               identity
                                                               assigned to the
                                                               card is
                                                               interpolated;
                                                               this is the
                                                               default.

                                                           username
                                                               The specified
                                                               or implied
                                                               username
                                                               assigned to the
                                                               card is
                                                               interpolated.

                                                           random
                                                               A
                                                               safely-encoded
                                                               20-byte random
                                                               string is
                                                               interpolated.

                                                           default
                                                               The default is
                                                               used
                                                               ("identity").

                                                           If the value of
                                                           INFOCARD_CARDID_SUFFIX
                                                           does not match
                                                           (case-insensitively)
                                                           any of these
                                                           strings, it is
                                                           interpolated
                                                           verbatim.
                                                           Regardless of how
                                                           it was derived, the
                                                           result string must
                                                           be a syntactically
                                                           valid URI path
                                                           segment (RRFFCC
                                                           22339966[96]).

                                                       INFOCARD_DIGEST
                                                       (Optional1)
                                                           The name of the
                                                           hash algorithm to
                                                           use in account
                                                           files for
                                                           self-issued
                                                           InfoCard-based
                                                           authentication (see
                                                           ddaaccss__iinnffooccaarrdd((88))[97]).
                                                           The syntax is the
                                                           same as for the
                                                           PPAASSSSWWOORRDD__DDIIGGEESSTT[98]
                                                           directive. The
                                                           default is
                                                           "SHA256".

                                                       INFOCARD_IP_PRIVACY_URL
                                                       (Required1-C)
                                                           This directive is
                                                           required by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           and specifies the
                                                           URL of the Identity
                                                           Provider's
                                                           PrivacyNotice. A
                                                           default notice is
                                                           configured.

                                                       INFOCARD_IP_PRIVACY_VERSION
                                                       (Optional1)
                                                           This optional
                                                           directive is used
                                                           by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           and specifies an
                                                           integer version
                                                           number (greater
                                                           than zero) of the
                                                           document returned
                                                           by the
                                                           IINNFFOOCCAARRDD__IIPP__PPRRIIVVAACCYY__UURRLL[99].
                                                           If it is set to the
                                                           empty string,
                                                           however, no version
                                                           number will be
                                                           specified for the
                                                           PrivacyNotice. The
                                                           default is "1".

                                                       INFOCARD_ISSUER_INFO_ENTRY
                                                       (Optional)
                                                           This optional
                                                           directive, which
                                                           may be repeated, is
                                                           used by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           to specify
                                                           arbitrary
                                                           descriptive
                                                           information to be
                                                           included in managed
                                                           InfoCards. This
                                                           information may be
                                                           displayed by an
                                                           Identity Selector.
                                                           The value of the
                                                           directive is a
                                                           string of the form
                                                           "_E_n_t_r_y_N_a_m_e:_E_n_t_r_y_V_a_l_u_e".

                                                       INFOCARD_MEX_URL
                                                       (Required1-C)
                                                           This directive,
                                                           used by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           specifies the URL
                                                           of the
                                                           WS-MetadataExchange
                                                           responder for
                                                           managed InfoCards.
                                                           Also see
                                                           ddaaccss__mmeexx((88))[100].

                                                       INFOCARD_REQUIRE_APPLIES_TO
                                                       (Optional1)
                                                           Used optionally by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           this directive
                                                           controls a managed
                                                           InfoCard's
                                                           RequireAppliesTo
                                                           element, which by
                                                           default is omitted.
                                                           This element is
                                                           used to control
                                                           whether the card's
                                                           Identity Provider
                                                           (e.g.,
                                                           ddaaccss__ssttss((88))[86])
                                                           will be informed as
                                                           to the identity of
                                                           the Relying Party
                                                           via the
                                                           wsp:AppliesTo
                                                           element (when it is
                                                           informed, it is
                                                           called an _a_u_d_i_t_i_n_g
                                                           _c_a_r_d, which is used
                                                           in _a_u_d_i_t_i_n_g _m_o_d_e).
                                                           Following the
                                                           Identity Selector
                                                           Interoperability
                                                           Profile, this
                                                           directive may have
                                                           any of the
                                                           following values:

                                                           no
                                                               The
                                                               RequireAppliesTo
                                                               element is
                                                               omitted (called
                                                               a _n_o_n_-_a_u_d_i_t_i_n_g
                                                               _c_a_r_d).

                                                           yes
                                                               RequireAppliesTo
                                                               is emitted, but
                                                               with its
                                                               optional
                                                               attribute
                                                               omitted (an
                                                               _a_u_d_i_t_i_n_g _c_a_r_d).

                                                           true
                                                               RequireAppliesTo
                                                               is emitted with
                                                               the attribute
                                                               Optional="true"
                                                               (called an
                                                               _a_u_d_i_t_i_n_g_-_o_p_t_i_o_n_a_l
                                                               _c_a_r_d).

                                                           false
                                                               RequireAppliesTo
                                                               is emitted with
                                                               the attribute
                                                               Optional="false"
                                                               (an _a_u_d_i_t_i_n_g
                                                               _c_a_r_d).


                                                       INFOCARD_STRONG_RP_IDENTITY
                                                       (Optional1)
                                                           Used optionally by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           if the value of
                                                           this directive is
                                                           "yes"
                                                           RequireStrongRecipientIdentity
                                                           is present in new
                                                           managed InfoCards,
                                                           which indicates
                                                           that a Relying
                                                           Party must use a
                                                           cryptographically
                                                           protected identity;
                                                           i.e., an X.509
                                                           server certificate.

                                                       INFOCARD_STS_AUTH_TYPE
                                                       (Required1-C)
                                                           This directive,
                                                           required by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           specifies
                                                           (case-insensitively)
                                                           the authentication
                                                           credential type,
                                                           which identifies an
                                                           Identity Selector
                                                           user to an IP/STS
                                                           (see
                                                           ddaaccss__ssttss((88))[86]).
                                                           The value of this
                                                           directive is
                                                           consulted when a
                                                           new managed
                                                           InfoCard is
                                                           created; the type
                                                           may be changed
                                                           without affecting
                                                           the authentication
                                                           credential type
                                                           assigned to
                                                           InfoCards created
                                                           before the change.
                                                           Recognized values
                                                           are:

                                                           password
                                                           passwd
                                                               This is the
                                                               username/password
                                                               credential
                                                               type. See
                                                               IINNFFOOCCAARRDD__SSTTSS__PPAASSSSWWOORRDD__MMEETTHHOODD[101].

                                                           cert
                                                               This is the
                                                               X.509 V3
                                                               certificate
                                                               credential
                                                               type. An SSL
                                                               client
                                                               certificate
                                                               must be used
                                                               with the
                                                               request to
                                                               ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                               for a managed
                                                               InfoCard, and
                                                               the same
                                                               certificate
                                                               must be used
                                                               when the
                                                               managed
                                                               InfoCard is
                                                               submitted to a
                                                               Relying Party.
                                                               A self-signed
                                                               certificate may
                                                               be used.

                                                           card
                                                               This is the
                                                               self-issued
                                                               credential
                                                               type. A
                                                               self-issued
                                                               InfoCard must
                                                               be submitted
                                                               with the
                                                               request to
                                                               ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                               for a managed
                                                               InfoCard, and
                                                               the same
                                                               self-issued
                                                               InfoCard must
                                                               be available to
                                                               the user's
                                                               Identity
                                                               Selector when
                                                               the managed
                                                               InfoCard is
                                                               submitted to a
                                                               Relying Party.
                                                               This
                                                               self-issued
                                                               InfoCard does
                                                               not need to be
                                                               separately
                                                               registered
                                                               using
                                                               ddaaccss__iinnffooccaarrdd((88))[97].

                                                           kerberos
                                                               This is the
                                                               Kerberos V5
                                                               credential
                                                               type. This
                                                               authentication
                                                               credential type
                                                               is currently
                                                               unsupported.


                                                               NNoottee
                                                               Although the
                                                               specification
                                                               allows an
                                                               ordered list of
                                                               STS endpoints
                                                               to appear, at
                                                               present only a
                                                               single endpoint
                                                               may be
                                                               configured.

                                                       INFOCARD_STS_CACERTFILE
                                                       (Required1-C)
                                                           This directive,
                                                           which is required
                                                           by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           specifies the
                                                           filename of the
                                                           certificate
                                                           authority's
                                                           PEM-encoded X.509
                                                           certificate for
                                                           IINNFFOOCCAARRDD__SSTTSS__CCEERRTTFFIILLEE[102].

                                                               NNoottee
                                                               File
                                                               permissions and
                                                               ownership must
                                                               be set
                                                               appropriately
                                                               to allow
                                                               run-time
                                                               access.

                                                       INFOCARD_STS_CERTFILE
                                                       (Required1-C)
                                                           This directive,
                                                           which is required
                                                           by
                                                           ddaaccssiinnffooccaarrdd((11))[103],
                                                           ddaaccss__iinnffooccaarrdd((88))[97],
                                                           and
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           specifies the
                                                           filename of the
                                                           PEM-encoded X.509
                                                           certificate for the
                                                           Secure Token
                                                           Service provided by
                                                           ddaaccss__ssttss((88))[86].

                                                               NNoottee
                                                               File
                                                               permissions and
                                                               ownership must
                                                               be set
                                                               appropriately
                                                               to allow
                                                               run-time
                                                               access. If a
                                                               self-signed
                                                               certificate is
                                                               being used, the
                                                               appropriate
                                                               root
                                                               certificate
                                                               must be
                                                               installed on
                                                               the system that
                                                               is running the
                                                               Identity
                                                               Selector.

                                                       INFOCARD_STS_KEYFILE
                                                       (Required1-C)
                                                           This directive,
                                                           which is required
                                                           by
                                                           ddaaccssiinnffooccaarrdd((11))[103],
                                                           llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[104],
                                                           ddaaccss__iinnffooccaarrdd((88))[97],
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           and
                                                           ddaaccss__ssttss((88))[86],
                                                           specifies the
                                                           filename of the key
                                                           for the X.509
                                                           certificate
                                                           specified by
                                                           INFOCARD_STS_CERTFILE.
                                                           If this file is
                                                           password protected,
                                                           IINNFFOOCCAARRDD__SSTTSS__KKEEYYFFIILLEE__PPAASSSSWWOORRDD[105]
                                                           must be configured.

                                                               NNoottee
                                                               File
                                                               permissions and
                                                               ownership must
                                                               be set
                                                               appropriately
                                                               to allow
                                                               run-time
                                                               access.

                                                       INFOCARD_STS_KEYFILE_PASSWORD
                                                       (Required1-C)
                                                           If
                                                           IINNFFOOCCAARRDD__SSTTSS__KKEEYYFFIILLEE[106]
                                                           is encrypted, this
                                                           directive is
                                                           required to specify
                                                           the password.

                                                       INFOCARD_STS_PASSWORD_METHOD
                                                       (Required1-C)
                                                           If the
                                                           username/password
                                                           credential type is
                                                           needed by a managed
                                                           InfoCard,
                                                           ddaaccss__ssttss((88))[86]
                                                           requires this
                                                           directive to
                                                           specify how the
                                                           username and
                                                           password are to be
                                                           validated:

                                                           empty
                                                               The password is
                                                               no password at
                                                               all (i.e., the
                                                               empty string).
                                                               If a password
                                                               _i_s given,
                                                               authentication
                                                               will fail.

                                                           ignore
                                                               Any password
                                                               string,
                                                               including no
                                                               password at all
                                                               (i.e., the
                                                               empty string),
                                                               is acceptable.

                                                           sts
                                                               The given
                                                               password string
                                                               must exactly
                                                               match the
                                                               authentication-time
                                                               value of the
                                                               configuration
                                                               variable
                                                               _i_n_f_o_c_a_r_d___s_t_s___p_a_s_s_w_o_r_d.

                                                           account:_i_d
                                                               The given
                                                               username and
                                                               password must
                                                               be valid
                                                               relative to the
                                                               specified DDAACCSS
                                                               authentication
                                                               module
                                                               identified by
                                                               the Auth clause
                                                               label _i_d, which
                                                               must be enabled
                                                               and configured
                                                               as per
                                                               ddaaccss__aauutthheennttiiccaattee((88))[48].
                                                               (Note: _T_h_i_s
                                                               _f_o_r_m _i_s
                                                               _c_u_r_r_e_n_t_l_y
                                                               _u_n_s_u_p_p_o_r_t_e_d.)


                                                       INFOCARD_STS_RP_ENDPOINT
                                                       (Optional)
                                                           This directive
                                                           causes
                                                           ddaaccss__ssttss((88))[86] to
                                                           issue security
                                                           tokens only to
                                                           selected identified
                                                           Relying Parties; if
                                                           the identity of a
                                                           Relying Party, as
                                                           provided by the
                                                           Address endpoint
                                                           appearing in the
                                                           token request's
                                                           AppliesTo element
                                                           (apparently the URL
                                                           of the Relying
                                                           Party's web page)
                                                           does not match any
                                                           instance of this
                                                           directive, a token
                                                           will not be
                                                           returned. A token
                                                           will be returned if
                                                           this directive is
                                                           not used or if the
                                                           Relying Party is
                                                           not identified. Not
                                                           all Relying Parties
                                                           are identified; see
                                                           IINNFFOOCCAARRDD__RREEQQUUIIRREE__AAPPPPLLIIEESS__TTOO[107].
                                                           The syntax for this
                                                           directive is
                                                           identical to that
                                                           of
                                                           IINNFFOOCCAARRDD__AAUUDDIIEENNCCEE[108].
                                                           Although the
                                                           Relying Party's
                                                           server certificate
                                                           can be provided
                                                           with the
                                                           identification
                                                           material in the
                                                           token request, it
                                                           is not currently
                                                           accessible to this
                                                           directive.

                                                       INFOCARD_STS_URL
                                                       (Required1-C)
                                                           This directive,
                                                           used by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87],
                                                           ddaaccss__mmeexx((88))[100],
                                                           and
                                                           ddaaccss__ssttss((88))[86],
                                                           specifies the URL
                                                           of the Secure Token
                                                           Service for managed
                                                           InfoCards.

                                                       INFOCARD_TOKEN_DRIFT_SECS
                                                       (Optional1)
                                                           A security token
                                                           (produced by
                                                           ddaaccss__ssttss((88))[86],
                                                           for instance) bears
                                                           a validity
                                                           condition; a
                                                           relying party may
                                                           reject a token if
                                                           its current system
                                                           date/time lies
                                                           outside of the time
                                                           window prescribed
                                                           by the token.
                                                           Because the clock
                                                           at the IP/STS
                                                           (which issued the
                                                           token) and the
                                                           clock at the
                                                           relying party may
                                                           not be closely
                                                           synchronized - the
                                                           relying party's
                                                           clock may be faster
                                                           or slower than the
                                                           IP/STS's clock - a
                                                           relying party may
                                                           be willing to
                                                           permit a certain
                                                           amount of "clock
                                                           drift" before it
                                                           rejects a token.
                                                           This directive
                                                           specifies the
                                                           maximum number of
                                                           seconds that the
                                                           IP/STS's clock may
                                                           be too fast or too
                                                           slow. If the
                                                           directive's value
                                                           is zero, or if the
                                                           directive is not
                                                           configured, a
                                                           compile time
                                                           default value is
                                                           used (currently,
                                                           300 seconds). If
                                                           the directive's
                                                           value is "disable",
                                                           the validity test
                                                           is suppressed.

                                                       INFOCARD_TOKEN_ISSUER
                                                       (Required1-C)
                                                           This directive,
                                                           used by
                                                           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[87]
                                                           and
                                                           ddaaccss__ssttss((88))[86],
                                                           specifies the
                                                           Issuer of a managed
                                                           InfoCard as a URI.
                                                           The value "self"
                                                           can be used to
                                                           represent the
                                                           special URI
                                                           identifying a
                                                           self-issued
                                                           InfoCard.

                                                               NNoottee
                                                               If your
                                                               Identity
                                                               Selector does
                                                               not let you
                                                               choose a
                                                               managed
                                                               InfoCard when
                                                               you think that
                                                               it ought to
                                                               (i.e., the
                                                               value of this
                                                               directive in
                                                               effect when the
                                                               managed
                                                               InfoCard was
                                                               created matches
                                                               the web page's
                                                               issuer
                                                               parameter), it
                                                               seems that the
                                                               INFOCARD_TOKEN_ISSUER
                                                               is ignored by
                                                               an Identity
                                                               Selector in
                                                               preference to
                                                               the name in the
                                                               Identity
                                                               Provider's SSL
                                                               certificate. It
                                                               has been noted
                                                               that if a
                                                               Relying Party
                                                               uses a wwiillddccaarrdd
                                                               cceerrttiiffiiccaattee[109],
                                                               an Identity
                                                               Selector may
                                                               have trouble
                                                               matching the
                                                               _i_s_s_u_e_r
                                                               parameter in an
                                                               HTML OBJECT
                                                               request with an
                                                               InfoCard; it
                                                               may be
                                                               necessary for
                                                               the Relying
                                                               Party to
                                                               specify the
                                                               value of the
                                                               _i_s_s_u_e_r
                                                               parameter as
                                                               the empty
                                                               string.

                                                       INFOCARD_TOKEN_LIFETIME_SECS
                                                       (Optional1)
                                                           This optional
                                                           directive specifies
                                                           the lifetime, in
                                                           seconds, of a
                                                           secure token
                                                           created by
                                                           ddaaccss__ssttss((88))[86]. If
                                                           not provided, a
                                                           compile-time value
                                                           is used. To reduce
                                                           the window of
                                                           vulnerability where
                                                           a token might be
                                                           captured and used
                                                           by an attacker,
                                                           this period should
                                                           be relatively short
                                                           (on the order of a
                                                           few seconds). Note
                                                           that a Relying
                                                           Party is free to
                                                           account for
                                                           inadequately
                                                           synchronized clocks
                                                           when deciding
                                                           whether it should
                                                           accept a token, so
                                                           this lifetime is
                                                           effectively a
                                                           recommendation for
                                                           the recipient of
                                                           the token. If the
                                                           clocks at the
                                                           Identity Selector
                                                           and token issuer
                                                           are not
                                                           sufficiently
                                                           synchronized, the
                                                           Identity Selector
                                                           will reject a token
                                                           if the token's
                                                           validity window is
                                                           outside of its
                                                           clock's current
                                                           value.

                                                       INFOCARD_TOKEN_MAX_LENGTH
                                                       (Optional1)
                                                           A relying party can
                                                           use this directive
                                                           to specify the
                                                           maximum size (in
                                                           bytes) of a
                                                           security token that
                                                           it will accept. If
                                                           this directive is
                                                           not configured or
                                                           is zero, a compile
                                                           time default value
                                                           is used (currently,
                                                           16384 bytes).

                                                       INFOCARD_USERNAME_SELECTOR
                                                       (Optional1)
                                                           This directive
                                                           determines how the
                                                           DDAACCSS username is
                                                           selected for a
                                                           self-issued
                                                           InfoCard during
                                                           registration by
                                                           ddaaccss__iinnffooccaarrdd((88))[97].
                                                           The resulting
                                                           identity is
                                                           relative to the
                                                           ccuurrrreenntt
                                                           jjuurriissddiiccttiioonn[44];
                                                           that is, if the
                                                           InfoCard is used to
                                                           sign on at a
                                                           jurisdiction where
                                                           it was registered,
                                                           the jurisdiction
                                                           will issue
                                                           credentials for the
                                                           username that was
                                                           registered with the
                                                           InfoCard. The
                                                           following directive
                                                           values are
                                                           recognized:

                                                           credentials
                                                               The username is
                                                               obtained from
                                                               the identity in
                                                               effect at
                                                               registration
                                                               time; there may
                                                               only be one
                                                               such set of
                                                               credentials and
                                                               they must have
                                                               been issued by
                                                               the
                                                               jurisdiction at
                                                               which
                                                               registration is
                                                               occurring. This
                                                               is the default
                                                               behaviour if
                                                               the directive
                                                               is not given.

                                                           email
                                                               The username is
                                                               obtained from
                                                               the email
                                                               address field
                                                               of the
                                                               InfoCard; the
                                                               email address
                                                               must be a
                                                               syntactically
                                                               valid username
                                                               (see
                                                               ddaaccss((11))[74]).

                                                           webpage
                                                               The username is
                                                               derived from
                                                               the web page
                                                               URL field of
                                                               the InfoCard;
                                                               this is not
                                                               currently
                                                               implemented.
                                                               (see
                                                               ddaaccss((11))[74]).


                                                       JURISDICTION_NAME
                                                       (Required1)
                                                           The name of the
                                                           jurisdiction. The
                                                           syntax is the same
                                                           as for
                                                           FFEEDDEERRAATTIIOONN__NNAAMMEE[53]:
                                                           an alphabetic
                                                           followed by zero or
                                                           more alphanumerics,
                                                           '-' (hyphens), or
                                                           '_' (underscores).
                                                           Note that periods
                                                           are not permitted.
                                                           By convention, this
                                                           name is in
                                                           all-caps, Please
                                                           see ddaaccss((11))[74] for
                                                           additional
                                                           information.
                                                           Example: METALOGIC

                                                       LOGINGEN_FILE
                                                       (Optional1)
                                                           Reserved for future
                                                           use. (Used with the
                                                           DDAACCSS llooggiinnggeenn
                                                           utility, this
                                                           directive gives the
                                                           full pathname of
                                                           the template file.)

                                                       LOGINGEN_PROG
                                                       (Optional1)
                                                           Reserved for future
                                                           use. (Used with the
                                                           DDAACCSS llooggiinnggeenn
                                                           utility, this
                                                           directive specifies
                                                           a program which
                                                           will read
                                                           LOGINGEN_FILE on
                                                           its stdin and write
                                                           the filtered output
                                                           to stdout.)

                                                       LOG_FILE (Optional1)
                                                           DDAACCSS uses the
                                                           LOG_FILE directive
                                                           to identify the
                                                           primary file to
                                                           which it should
                                                           write log
                                                           information.  DDAACCSS
                                                           performs directory
                                                           name interpolation
                                                           on the pathname
                                                           string using a
                                                           syntax and method
                                                           similar to AAppaacchhee''ss
                                                           mmoodd__vvhhoosstt__aalliiaass[7]
                                                           module (see SSttrriinngg
                                                           IInntteerrppoollaattiioonn[22]).

                                                           The result after
                                                           interpolation must
                                                           either be the
                                                           absolute pathname
                                                           of a file to write
                                                           log information to,
                                                           or the word
                                                           "syslog". In the
                                                           latter case,
                                                           ssyysslloogg((33))[110] is
                                                           used, with an _i_d_e_n_t
                                                           argument of "dacs"
                                                           and a facility of
                                                           "user". Each DDAACCSS
                                                           logging level is
                                                           mapped to the
                                                           corresponding
                                                           ssyysslloogg level, with
                                                           the trace level
                                                           mapped to ssyysslloogg''ss
                                                           debug level.

                                                           While DDAACCSS is
                                                           starting and before
                                                           it reads and
                                                           processes its
                                                           configuration
                                                           files, this
                                                           directive is not
                                                           yet available to
                                                           it; until DDAACCSS
                                                           knows what LOG_FILE
                                                           is, or should
                                                           LOG_FILE not be
                                                           writable, the value
                                                           of LOG_FILE is
                                                           obtained from the
                                                           value of DACS_LOG.
                                                           A compile-time
                                                           specified value,
                                                           DACS_LOG can be
                                                           specified when DDAACCSS
                                                           is built (the
                                                           default is
                                                           equivalent to
                                                           ${Conf::DACS_HOME}/logs/error_log).
                                                           If DACS_LOG is
                                                           unusable, stderr is
                                                           used.

                                                       LOG_FILTER (Stack)
                                                           This directive
                                                           configures a
                                                           fine-grained way of
                                                           specifying which
                                                           messages will be
                                                           written compared to
                                                           the LLOOGG__LLEEVVEELL[111]
                                                           directive. The
                                                           directive, which
                                                           may be repeated,
                                                           selects the types
                                                           of events that DDAACCSS
                                                           _s_h_o_u_l_d log;
                                                           unselected events
                                                           are not recorded in
                                                           a log file. It also
                                                           provides a way for
                                                           different kinds of
                                                           messages to be
                                                           logged to different
                                                           files.

                                                           Because this
                                                           directive is in the
                                                           SSttaacckk ccaatteeggoorryy[12],
                                                           "later" directives
                                                           supercede earlier
                                                           ones. When a
                                                           directive is found
                                                           that allows a
                                                           message to be
                                                           logged, no
                                                           additional
                                                           directives are
                                                           examined for the
                                                           message. If this
                                                           directive is not
                                                           given, the default
                                                           filtering is done
                                                           based on the
                                                           LOG_LEVEL and
                                                           LOG_SENSITIVE
                                                           directives.

                                                           The syntax is one
                                                           of:

                                                               LOG_FILTER "_t_y_p_e _f_l_a_g[,_f_l_a_g]* _l_e_v_e_l _n_a_m_e [[+|-]_f_i_l_e]"
                                                               LOG_FILTER "any _f_l_a_g[,_f_l_a_g]* _l_e_v_e_l [[+|-]_f_i_l_e]"

                                                           The _t_y_p_e, which is
                                                           one of the keywords
                                                           program, module,
                                                           filename, or
                                                           function (case
                                                           insensitive),
                                                           specifies the type
                                                           of the event source
                                                           to which this
                                                           filter applies;
                                                           i.e., it indicates
                                                           what _n_a_m_e is to be
                                                           matched against. If
                                                           _t_y_p_e is filename,
                                                           for instance, it
                                                           means that for this
                                                           filter to be
                                                           applicable to a
                                                           particular log
                                                           message, the _n_a_m_e
                                                           must match the
                                                           filename from which
                                                           the log message is
                                                           generated.

                                                           A list of
                                                           comma-separated,
                                                           case-insensitive
                                                           modifier flags
                                                           specifies how
                                                           matching of _t_y_p_e is
                                                           done against _n_a_m_e.
                                                           A _f_l_a_g can have the
                                                           value exact, regex,
                                                           icase, sensitive,
                                                           user, audit, or
                                                           normal.

                                                           The _n_a_m_e is matched
                                                           against _t_y_p_e case
                                                           sensitively, unless
                                                           the icase flag is
                                                           present. Matching
                                                           is performed using
                                                           rreeggeexx((33))[112]
                                                           regular expression
                                                           matching if the
                                                           regex flag is
                                                           present, or using a
                                                           string comparison
                                                           if the exact flag
                                                           is present (these
                                                           two flags are
                                                           mutually
                                                           exclusive).

                                                           A message can have
                                                           no attributes
                                                           associated with it,
                                                           or any combination
                                                           of the attributes
                                                           sensitive, user,
                                                           and audit. Messages
                                                           with the sensitive
                                                           attribute might
                                                           include potentially
                                                           private
                                                           information, such
                                                           as a password.
                                                           Messages with the
                                                           audit attribute
                                                           include relatively
                                                           high-level events,
                                                           such as successful
                                                           and unsuccessful
                                                           authentication
                                                           results, signouts,
                                                           and access control
                                                           decisions. The user
                                                           attribute is
                                                           associated with
                                                           messages produced
                                                           by the pprriinntt(())[113]
                                                           and pprriinnttff(())[114]
                                                           functions.

                                                           Modifier flags are
                                                           used to select (or
                                                           deselect) messages
                                                           to be logged. By
                                                           default, only
                                                           normal messages are
                                                           logged; these are
                                                           messages without
                                                           any attributes. The
                                                           LLOOGG__SSEENNSSIITTIIVVEE[115]
                                                           directive can
                                                           change the default
                                                           to enable sensitive
                                                           messages.

                                                           If the audit flag
                                                           is given, a message
                                                           is logged only if
                                                           it has that
                                                           attribute. Messages
                                                           with the sensitive
                                                           attribute are not
                                                           logged unless the
                                                           sensitive flag is
                                                           given, and messages
                                                           with the user
                                                           attribute are not
                                                           logged unless the
                                                           user flag is given.

                                                           Assuming the _t_y_p_e
                                                           and _l_e_v_e_l do not
                                                           deselect the
                                                           message, here are
                                                           some example cases:

                                                           +o   a message
                                                               without any
                                                               attributes will
                                                               be logged
                                                               provided the
                                                               audit flag is
                                                               not specified

                                                           +o   a message with
                                                               both the audit
                                                               and sensitive
                                                               attributes will
                                                               be logged only
                                                               if the filter
                                                               specifies the
                                                               audit flag, and
                                                               either the
                                                               sensitive flag
                                                               is given or
                                                               LOG_SENSITIVE
                                                               is enabled

                                                               If the
                                                               directive's
                                                               value begins
                                                               with the
                                                               keyword any,
                                                               the filter
                                                               matches any
                                                               source, so
                                                               there is no
                                                               _n_a_m_e and the
                                                               modifier flags
                                                               related to
                                                               matching _n_a_m_e
                                                               are ignored.

                                                               In order of
                                                               increasing
                                                               importance and
                                                               decreasing
                                                               amount of
                                                               detail, _l_e_v_e_l
                                                               is one of the
                                                               following
                                                               case-insensitive
                                                               keywords:

                                                               +o    trace (or
                                                                   tracing,
                                                                   least
                                                                   important
                                                                   messages)

                                                               +o    debug (or
                                                                   debugging)

                                                               +o    info

                                                               +o    notice (or
                                                                   notices)

                                                               +o    warn (or
                                                                   warning or
                                                                   warnings)

                                                               +o    error (or
                                                                   errors)

                                                               +o    critical
                                                                   (or crit)

                                                               +o    alert (or
                                                                   alerts)

                                                               +o    emerg (or
                                                                   emergency,
                                                                   most
                                                                   important
                                                                   messages)

                                                                   Any log
                                                                   message
                                                                   having a
                                                                   lower
                                                                   importance
                                                                   than _l_e_v_e_l
                                                                   will not
                                                                   satisfy the
                                                                   filter. If
                                                                   the logging
                                                                   level is
                                                                   set to
                                                                   info, for
                                                                   example,
                                                                   messages
                                                                   having a
                                                                   lower level
                                                                   (debug and
                                                                   trace) will
                                                                   not be
                                                                   recorded.
                                                                   These
                                                                   levels are
                                                                   intended to
                                                                   have
                                                                   semantics
                                                                   similar to
                                                                   those of
                                                                   the logging
                                                                   levels used
                                                                   by AAppaacchhee
                                                                   and
                                                                   ssyysslloogg((33))[110].

                                                                   The _f_i_l_e
                                                                   field,
                                                                   which is
                                                                   optional,
                                                                   is used
                                                                   instead of
                                                                   (or in
                                                                   addition
                                                                   to)
                                                                   LOG_FILE
                                                                   and
                                                                   interpolation
                                                                   is
                                                                   performed
                                                                   in the same
                                                                   way. If
                                                                   _f_i_l_e is
                                                                   syslog, all
                                                                   messages
                                                                   matching
                                                                   the filter
                                                                   will be
                                                                   written
                                                                   using
                                                                   ssyysslloogg((33))
                                                                   instead of
                                                                   to
                                                                   LOG_FILE.
                                                                   If _f_i_l_e is
                                                                   prefixed
                                                                   with a '+',
                                                                   output will
                                                                   be written
                                                                   to both
                                                                   LOG_FILE
                                                                   and the
                                                                   expansion
                                                                   of _f_i_l_e; if
                                                                   it is
                                                                   prefixed
                                                                   with
                                                                   nothing or
                                                                   -, the
                                                                   default
                                                                   behaviour
                                                                   results;
                                                                   the initial
                                                                   character
                                                                   can be
                                                                   escaped
                                                                   using a
                                                                   backslash.
                                                                   In some
                                                                   situations,
                                                                   using
                                                                   /dev/null
                                                                   for _f_i_l_e is
                                                                   useful to
                                                                   discard
                                                                   unhelpful
                                                                   messages.

                                                                   Without
                                                                   regard to
                                                                   how
                                                                   LOG_LEVEL
                                                                   and
                                                                   LOG_SENSITIVE
                                                                   are
                                                                   configured,
                                                                   this
                                                                   directive
                                                                   says that
                                                                   all
                                                                   messages
                                                                   generated
                                                                   by any
                                                                   function
                                                                   located
                                                                   within the
                                                                   DDAACCSS source
                                                                   file named
                                                                   crypto.c
                                                                   having a
                                                                   level of at
                                                                   least
                                                                   debug,
                                                                   should be
                                                                   logged,
                                                                   including
                                                                   those
                                                                   marked as
                                                                   sensitive:

                                                                       LOG_FILTER 'filename exact,sensitive debug crypto.c'


                                                                       TTiipp
                                                                       The
                                                                       directive:

                                                                           LOG_FILTER 'any audit trace +syslog'

                                                                       causes
                                                                       all log
                                                                       messages
                                                                       with
                                                                       the
                                                                       audit
                                                                       modifier
                                                                       having
                                                                       level
                                                                       trace
                                                                       or
                                                                       higher
                                                                       to be
                                                                       written
                                                                       to both
                                                                       ssyysslloogg((33))
                                                                       and
                                                                       LOG_FILE.
                                                                       If you
                                                                       want to
                                                                       use the
                                                                       syslog
                                                                       feature
                                                                       in this
                                                                       way,
                                                                       you
                                                                       will
                                                                       need a
                                                                       section
                                                                       in the
                                                                       ssyysslloogg((33))
                                                                       configuration
                                                                       file
                                                                       (typically
                                                                       /etc/syslog.conf)
                                                                       that
                                                                       looks
                                                                       something
                                                                       like
                                                                       the
                                                                       following,
                                                                       depending
                                                                       on the
                                                                       flavour
                                                                       of
                                                                       ssyysslloogg((33))
                                                                       that
                                                                       your
                                                                       system
                                                                       uses:

                                                                           !dacs
                                                                           *.*        /usr/local/dacs/logs/audit_log

                                                                       The
                                                                       following
                                                                       directive
                                                                       is
                                                                       similar
                                                                       except
                                                                       that it
                                                                       causes
                                                                       log
                                                                       messages
                                                                       classified
                                                                       as
                                                                       either
                                                                       audit
                                                                       or
                                                                       sensitive
                                                                       (or
                                                                       both)
                                                                       to be
                                                                       written
                                                                       to both
                                                                       LOG_FILE
                                                                       and the
                                                                       file
                                                                       logs/Audit_log,
                                                                       relative
                                                                       to the
                                                                       root of
                                                                       the
                                                                       DDAACCSS
                                                                       installation
                                                                       directory:


                                                                           LOG_FILTER 'any audit,sensitive TRACE +%bD/logs/Audit_log'

                                                                       By
                                                                       removing
                                                                       the '+'
                                                                       character,
                                                                       the log
                                                                       messages
                                                                       would
                                                                       not be
                                                                       written
                                                                       to
                                                                       LOG_FILE.
                                                                   Please
                                                                   refer to
                                                                   ddaaccss((11))[116]
                                                                   for general
                                                                   information
                                                                   about
                                                                   logging.

                                                               LOG_FORMAT
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   is used to
                                                                   specify the
                                                                   format of
                                                                   log
                                                                   messages
                                                                   produced by
                                                                   DDAACCSS.
                                                                   Interpolation
                                                                   is
                                                                   controlled
                                                                   by
                                                                   pprriinnttff-like
                                                                   format
                                                                   specifiers,
                                                                   as follows:

                                                                   %%
                                                                       Insert
                                                                       a
                                                                       literal
                                                                       percent
                                                                       character

                                                                   %a
                                                                       Insert
                                                                       the
                                                                       application
                                                                       name,
                                                                       which
                                                                       is
                                                                       typically
                                                                       the
                                                                       basename
                                                                       of
                                                                       _a_r_g_v_[_0_].

                                                                   %c
                                                                       Insert
                                                                       the
                                                                       value
                                                                       of a
                                                                       per-process
                                                                       message
                                                                       counter,
                                                                       which
                                                                       is then
                                                                       incremented.

                                                                   %F
                                                                       Insert
                                                                       event
                                                                       descriptor
                                                                       flags,
                                                                       which
                                                                       indicate
                                                                       whether
                                                                       the
                                                                       message
                                                                       is an
                                                                       audit
                                                                       event
                                                                       ("A"),
                                                                       a
                                                                       potentially
                                                                       sensitive
                                                                       event
                                                                       ("S"),
                                                                       a user
                                                                       event
                                                                       ("U"),
                                                                       or a
                                                                       normal
                                                                       event
                                                                       ("-").

                                                                   %fn
                                                                       Interpolate
                                                                       the
                                                                       federation
                                                                       name.

                                                                   %fd
                                                                       Interpolate
                                                                       the
                                                                       federation
                                                                       domain.

                                                                   %j
                                                                       Interpolate
                                                                       the
                                                                       jurisdiction
                                                                       name.

                                                                   %l
                                                                       Interpolate
                                                                       the log
                                                                       level
                                                                       of the
                                                                       message.

                                                                   %p
                                                                       Interpolate
                                                                       the
                                                                       process
                                                                       id of
                                                                       the
                                                                       process
                                                                       generating
                                                                       the
                                                                       message.

                                                                   %sF
                                                                       Interpolate
                                                                       the
                                                                       name of
                                                                       the
                                                                       function
                                                                       generating
                                                                       the
                                                                       message.

                                                                   %sf
                                                                       Interpolate
                                                                       the
                                                                       name of
                                                                       the
                                                                       file
                                                                       generating
                                                                       the
                                                                       message.

                                                                   %sl
                                                                       Interpolate
                                                                       the
                                                                       line
                                                                       number
                                                                       within
                                                                       the
                                                                       file
                                                                       that is
                                                                       generating
                                                                       the
                                                                       message.

                                                                   %sm
                                                                       Interpolate
                                                                       the
                                                                       name of
                                                                       the
                                                                       module
                                                                       generating
                                                                       the
                                                                       message.

                                                                   %sp
                                                                       Interpolate
                                                                       the
                                                                       name of
                                                                       the
                                                                       program
                                                                       generating
                                                                       the
                                                                       message.

                                                                   %t
                                                                       Interpolate
                                                                       the
                                                                       current
                                                                       time
                                                                       and
                                                                       date.

                                                                   If a % is
                                                                   followed by
                                                                   any other
                                                                   character,
                                                                   that
                                                                   character
                                                                   is printed.
                                                                   Other
                                                                   characters
                                                                   in the
                                                                   format
                                                                   specifier
                                                                   are
                                                                   interpolated
                                                                   verbatim.
                                                                   If a
                                                                   requested
                                                                   value is
                                                                   not
                                                                   available,
                                                                   nothing is
                                                                   interpolated.

                                                               LOG_LEVEL
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   specifies
                                                                   the minimum
                                                                   default
                                                                   logging
                                                                   level in
                                                                   effect -
                                                                   log
                                                                   messages
                                                                   less
                                                                   important
                                                                   than this
                                                                   will be
                                                                   discarded.
                                                                   For
                                                                   example, if
                                                                   LOG_LEVEL
                                                                   is warn,
                                                                   only log
                                                                   message of
                                                                   that level
                                                                   or more
                                                                   important
                                                                   will be
                                                                   written and
                                                                   all others
                                                                   will be
                                                                   discarded.
                                                                   If there is
                                                                   an
                                                                   applicable
                                                                   LLOOGG__FFIILLTTEERR[117]
                                                                   directive
                                                                   it
                                                                   overrides
                                                                   this
                                                                   behaviour,
                                                                   however.

                                                                   Briefly, in
                                                                   order of
                                                                   increasing
                                                                   importance,
                                                                   the names
                                                                   of the
                                                                   levels are:
                                                                   trace,
                                                                   debug,
                                                                   info,
                                                                   notice,
                                                                   warn,
                                                                   error,
                                                                   critical,
                                                                   alert, and
                                                                   emerg. The
                                                                   trace
                                                                   logging
                                                                   level emits
                                                                   the most
                                                                   detail and
                                                                   the emerg
                                                                   level emits
                                                                   the least.
                                                                   Refer to
                                                                   the
                                                                   LLOOGG__FFIILLTTEERR[117]
                                                                   directive
                                                                   for
                                                                   additional
                                                                   information.

                                                                   The
                                                                   LOG_LEVEL
                                                                   overrides
                                                                   the
                                                                   compile-time
                                                                   default,
                                                                   which is
                                                                   obtained
                                                                   using the
                                                                   LOG_DEFAULT_LEVEL
                                                                   symbol.

                                                                   The
                                                                   "verbose"
                                                                   command
                                                                   line flag
                                                                   (--vv) or the
                                                                   VERBOSE_LEVEL
                                                                   directive
                                                                   overrides
                                                                   this
                                                                   directive,
                                                                   which are
                                                                   in turn
                                                                   overridden
                                                                   by the _-_t
                                                                   command
                                                                   line flag
                                                                   ("trace")
                                                                   or the
                                                                   TRACE_LEVEL
                                                                   directive.
                                                                   A verbose
                                                                   level of
                                                                   one is
                                                                   equivalent
                                                                   to the info
                                                                   level; a
                                                                   verbose
                                                                   level
                                                                   greater
                                                                   than one is
                                                                   equivalent
                                                                   to the
                                                                   debug
                                                                   level.
                                                                   Enabling a
                                                                   trace
                                                                   level, with
                                                                   any value,
                                                                   is
                                                                   equivalent
                                                                   to
                                                                   requesting
                                                                   the trace
                                                                   logging
                                                                   level.

                                                                   Also see
                                                                   ddeebbuugg__ddaaccss[118].

                                                               LOG_SENSITIVE
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   determines
                                                                   the default
                                                                   behaviour
                                                                   for logging
                                                                   messages
                                                                   with the
                                                                   sensitive
                                                                   attribute.
                                                                   It may have
                                                                   the values
                                                                   "yes" (to
                                                                   enable
                                                                   logging
                                                                   sensitive
                                                                   messages)
                                                                   or "no"
                                                                   (the
                                                                   default,
                                                                   which
                                                                   discards
                                                                   such
                                                                   messages).

                                                                       NNoottee
                                                                       Sensitive
                                                                       messages
                                                                       may
                                                                       include
                                                                       passwords
                                                                       and
                                                                       other
                                                                       authentication
                                                                       material
                                                                       that
                                                                       should
                                                                       remain
                                                                       private.
                                                                       This
                                                                       directive
                                                                       will
                                                                       not
                                                                       suppress
                                                                       potentially
                                                                       sensitive
                                                                       messages
                                                                       generated
                                                                       by
                                                                       third-party
                                                                       support
                                                                       packages
                                                                       (e.g.,
                                                                       SSaammbbaa
                                                                       or
                                                                       OOppeennLLDDAAPP),
                                                                       AAppaacchhee
                                                                       (including
                                                                       mmoodd__aauutthh__ddaaccss),
                                                                       or the
                                                                       operating
                                                                       system.
                                                                       For
                                                                       example,
                                                                       requests
                                                                       for CGI
                                                                       programs
                                                                       invoked
                                                                       using
                                                                       the GET
                                                                       method
                                                                       will be
                                                                       logged
                                                                       in the
                                                                       AAppaacchhee
                                                                       Access
                                                                       Log,
                                                                       and the
                                                                       request's
                                                                       query
                                                                       string
                                                                       will
                                                                       typically
                                                                       be
                                                                       printed;
                                                                       password
                                                                       parameters
                                                                       may be
                                                                       present
                                                                       in the
                                                                       log
                                                                       (see
                                                                       mmoodd__lloogg__ccoonnffiigg[119]
                                                                       for
                                                                       details
                                                                       of how
                                                                       to
                                                                       change
                                                                       the log
                                                                       format.
                                                                       If
                                                                       sensitive
                                                                       messages
                                                                       are
                                                                       being
                                                                       logged,
                                                                       make
                                                                       doubly-sure
                                                                       that
                                                                       log
                                                                       files
                                                                       have
                                                                       appropriate
                                                                       permissions.
                                                                       Also,
                                                                       unencrypted
                                                                       logging
                                                                       messages
                                                                       directed
                                                                       over a
                                                                       network
                                                                       (e.g.,
                                                                       through
                                                                       ssyysslloogg((33))[110])
                                                                       may be
                                                                       visible
                                                                       to an
                                                                       attacker.

                                                               NAME_COMPARE
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   sets the
                                                                   default
                                                                   method used
                                                                   to compare
                                                                   DDAACCSS names
                                                                   in various
                                                                   contexts.
                                                                   Ordinarily,
                                                                   federation,
                                                                   jurisdiction,
                                                                   usernames,
                                                                   and group
                                                                   names are
                                                                   compared
                                                                   case-sensitively.
                                                                   If the
                                                                   value of
                                                                   this
                                                                   directive
                                                                   is case,
                                                                   then
                                                                   case-sensitive
                                                                   comparisons
                                                                   are used,
                                                                   if its
                                                                   value is
                                                                   nocase,
                                                                   then
                                                                   case-insensitive
                                                                   comparisons
                                                                   are used,
                                                                   and if its
                                                                   value is
                                                                   default,
                                                                   then the
                                                                   application
                                                                   default
                                                                   (either
                                                                   case or the
                                                                   value
                                                                   selected by
                                                                   the
                                                                   application)
                                                                   is used.
                                                                   This
                                                                   directive
                                                                   can be
                                                                   overridden
                                                                   on a
                                                                   case-by-case
                                                                   basis (pun
                                                                   intended);
                                                                   refer to
                                                                   the uusseerr(())
                                                                   function
                                                                   (ddaaccss..eexxpprrss((55))[18])
                                                                   for
                                                                   details.

                                                                       SSeeccuurriittyy
                                                                       The
                                                                       selected
                                                                       comparison
                                                                       method
                                                                       applies
                                                                       to _a_l_l
                                                                       components
                                                                       of DDAACCSS
                                                                       names;
                                                                       if this
                                                                       is not
                                                                       desired,
                                                                       the
                                                                       ssttrrttrr(())
                                                                       function
                                                                       might
                                                                       be
                                                                       helpful.
                                                                       Note
                                                                       that
                                                                       this
                                                                       directive
                                                                       does
                                                                       not
                                                                       alter
                                                                       the
                                                                       DDAACCSS
                                                                       name
                                                                       determined
                                                                       by
                                                                       authentication,
                                                                       only
                                                                       the way
                                                                       the
                                                                       name is
                                                                       compared.
                                                                       While
                                                                       it's
                                                                       unlikely
                                                                       (and
                                                                       bad
                                                                       practice)
                                                                       for
                                                                       federation
                                                                       names
                                                                       (or
                                                                       jurisdiction
                                                                       names)
                                                                       to
                                                                       differ
                                                                       only in
                                                                       their
                                                                       case,
                                                                       it is
                                                                       not
                                                                       unusual
                                                                       for
                                                                       usernames
                                                                       to be
                                                                       treated
                                                                       case-insensitively
                                                                       for
                                                                       authentication
                                                                       purposes
                                                                       and for
                                                                       this
                                                                       reason
                                                                       this
                                                                       feature
                                                                       should
                                                                       be used
                                                                       with
                                                                       care.
                                                                       When
                                                                       case-insensitive
                                                                       comparisons
                                                                       are
                                                                       used,
                                                                       the
                                                                       usernames
                                                                       bob and
                                                                       BOB
                                                                       will be
                                                                       considered
                                                                       to be
                                                                       equivalent,
                                                                       for
                                                                       example;
                                                                       sometimes
                                                                       this is
                                                                       useful
                                                                       but it
                                                                       can
                                                                       also be
                                                                       a
                                                                       security
                                                                       hole,
                                                                       depending
                                                                       on how
                                                                       authentication
                                                                       is
                                                                       configured.

                                                                       Changing
                                                                       the
                                                                       comparison
                                                                       method
                                                                       from
                                                                       case-insensitive
                                                                       back to
                                                                       case-sensitive
                                                                       may
                                                                       have
                                                                       undesirable
                                                                       consequences;
                                                                       identities
                                                                       that
                                                                       were
                                                                       formerly
                                                                       equivalent
                                                                       might
                                                                       suddenly
                                                                       become
                                                                       distinct,
                                                                       which
                                                                       at the
                                                                       very
                                                                       least
                                                                       may
                                                                       confuse
                                                                       users.

                                                                       The
                                                                       recommended
                                                                       practice
                                                                       is to
                                                                       not
                                                                       define
                                                                       NAME_COMPARE
                                                                       or set
                                                                       it to
                                                                       case
                                                                       because
                                                                       of its
                                                                       system-wide
                                                                       effects.
                                                                       When
                                                                       needed,
                                                                       use the
                                                                       uusseerr(())
                                                                       function
                                                                       with an
                                                                       appropriate
                                                                       comparison
                                                                       method
                                                                       argument.

                                                               NOTICES_ACCEPT_HANDLER
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   provides a
                                                                   URL
                                                                   (absolute
                                                                   or
                                                                   relative)
                                                                   to which a
                                                                   user agent
                                                                   will be
                                                                   redirected
                                                                   by the
                                                                   notice
                                                                   acknowledgement
                                                                   handler
                                                                   after a
                                                                   positive
                                                                   acknowledgement
                                                                   to a notice
                                                                   has been
                                                                   received
                                                                   (i.e., when
                                                                   the notice
                                                                   or notices
                                                                   were
                                                                   "accepted"),
                                                                   but only if
                                                                   it is not
                                                                   possible to
                                                                   redirect
                                                                   the user
                                                                   agent to
                                                                   the request
                                                                   that
                                                                   initiated
                                                                   notice
                                                                   acknowledgement
                                                                   processing
                                                                   (e.g., if
                                                                   that
                                                                   request
                                                                   used the
                                                                   POST
                                                                   method). If
                                                                   not
                                                                   provided, a
                                                                   default
                                                                   HTML page
                                                                   will be
                                                                   returned.

                                                               NOTICES_ACK_HANDLER
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   provides
                                                                   the URL of
                                                                   the notice
                                                                   acknowledgement
                                                                   handler,
                                                                   which is
                                                                   the program
                                                                   that
                                                                   receives a
                                                                   user's
                                                                   response to
                                                                   a request
                                                                   to
                                                                   acknowledge
                                                                   one or more
                                                                   notices. If
                                                                   not
                                                                   provided or
                                                                   if it is
                                                                   the empty
                                                                   string, the
                                                                   notice
                                                                   presentation
                                                                   handler
                                                                   should
                                                                   assume that
                                                                   it must
                                                                   also act as
                                                                   the notice
                                                                   acknowledgement
                                                                   handler.

                                                               NOTICES_DECLINE_HANDLER
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   provides a
                                                                   URL
                                                                   (absolute
                                                                   or
                                                                   relative)
                                                                   to which a
                                                                   user agent
                                                                   will be
                                                                   redirected
                                                                   by the
                                                                   notice
                                                                   acknowledgement
                                                                   handler
                                                                   after a
                                                                   negative
                                                                   acknowledgement
                                                                   to a notice
                                                                   has been
                                                                   received
                                                                   (i.e., when
                                                                   the notice
                                                                   or notices
                                                                   were
                                                                   "declined").
                                                                   If not
                                                                   provided, a
                                                                   default
                                                                   HTML page
                                                                   will be
                                                                   returned.

                                                               NOTICES_NAT_NAME_PREFIX
                                                               (Optional1)
                                                                   The default
                                                                   prefix of
                                                                   the name of
                                                                   the HTTP
                                                                   cookie
                                                                   bearing a
                                                                   notice
                                                                   acknowledgement
                                                                   token is
                                                                   "NAT-DACS".
                                                                   This
                                                                   directive
                                                                   can be used
                                                                   to override
                                                                   the
                                                                   default.

                                                               NOTICES_SECURE_HANDLER
                                                               (Optional1)
                                                                   By default,
                                                                   ddaaccss__nnoottiicceess((88))[120]
                                                                   takes steps
                                                                   to prevent
                                                                   attempts to
                                                                   simply ask
                                                                   for notice
                                                                   acknowledgement
                                                                   tokens
                                                                   (NATs),
                                                                   effectively
                                                                   bypassing
                                                                   having to
                                                                   see
                                                                   notices. If
                                                                   the value
                                                                   of this
                                                                   directive
                                                                   is "no",
                                                                   however,
                                                                   these steps
                                                                   will be
                                                                   disabled.
                                                                   Please
                                                                   refer to
                                                                   the
                                                                   description
                                                                   of
                                                                   ddaaccss__nnoottiicceess'
                                                                   SSeeccuurree
                                                                   MMooddee[121]
                                                                   of
                                                                   operation.

                                                               NOTICES_WORKFLOW_LIFETIME_SECS
                                                               (Optional1)
                                                                   By default,
                                                                   a secure
                                                                   notice
                                                                   acknowledgement
                                                                   workflow
                                                                   must
                                                                   complete
                                                                   within 120
                                                                   seconds.
                                                                   This
                                                                   directive
                                                                   can be used
                                                                   to specify
                                                                   an unsigned
                                                                   integer
                                                                   value that
                                                                   will
                                                                   override
                                                                   the
                                                                   default.

                                                               PAMD_HOST
                                                               (Optional1)
                                                                   When
                                                                   llooccaall__ppaamm__aauutthheennttiiccaattee[122]
                                                                   is used,
                                                                   this
                                                                   directive
                                                                   is required
                                                                   to specify
                                                                   the domain
                                                                   name or IP
                                                                   address of
                                                                   the host
                                                                   where
                                                                   ppaammdd((88))[123]
                                                                   is
                                                                   executed.

                                                               PAMD_PORT
                                                               (Optional1)
                                                                   When
                                                                   llooccaall__ppaamm__aauutthheennttiiccaattee[122]
                                                                   is used,
                                                                   this may be
                                                                   used to
                                                                   specify the
                                                                   port number
                                                                   or service
                                                                   name on
                                                                   PAMD_HOST
                                                                   where the
                                                                   ppaammdd((88))[123]
                                                                   server
                                                                   accepts
                                                                   connections.
                                                                   This
                                                                   directive
                                                                   can be
                                                                   overridden
                                                                   on the ppaammdd
                                                                   command
                                                                   line. If no
                                                                   value is
                                                                   explicitly
                                                                   specified,
                                                                   programs
                                                                   will use
                                                                   the
                                                                   compile-time
                                                                   symbol
                                                                   PAMD_SERVICE_NAME
                                                                   (by
                                                                   default,
                                                                   "dacs-pamd"),
                                                                   which
                                                                   assumes
                                                                   that
                                                                   /etc/services
                                                                   has been
                                                                   configured
                                                                   accordingly.

                                                               PASSWORD_CONSTRAINTS
                                                               (Optional1)
                                                                   This
                                                                   directive
                                                                   describes
                                                                   requirements
                                                                   that must
                                                                   be met by
                                                                   new
                                                                   passwords
                                                                   created by
                                                                   ddaaccss__ppaasssswwdd((88))[124],
                                                                   other than
                                                                   when used
                                                                   by a DDAACCSS
                                                                   administrator.
                                                                   In other
                                                                   situations,
                                                                   where a
                                                                   DDAACCSS
                                                                   administrator
                                                                   must be
                                                                   running the
                                                                   program
                                                                   (such as
                                                                   with
                                                                   ddaaccssppaasssswwdd((11))[125]
                                                                   or
                                                                   ddaaccssttookkeenn((11))[126]),
                                                                   a warning
                                                                   message is
                                                                   produced if
                                                                   a new,
                                                                   non-conforming
                                                                   password or
                                                                   PIN is set
                                                                   but the
                                                                   password
                                                                   can still
                                                                   be used.

                                                                   This
                                                                   directive's
                                                                   syntax is
                                                                   also used
                                                                   by the
                                                                   PPAASSSSWWOORRDD__AAUUDDIITT[127]
                                                                   directive,
                                                                   which may
                                                                   appear in
                                                                   an Auth
                                                                   clause.

                                                                   The format
                                                                   of the
                                                                   constraint
                                                                   string is a
                                                                   set of zero
                                                                   or more
                                                                   comma-separated
                                                                   terms. Each
                                                                   term
                                                                   consists of
                                                                   an unsigned
                                                                   integer
                                                                   (zero or
                                                                   greater)
                                                                   followed
                                                                   immediately
                                                                   by a single
                                                                   character
                                                                   (case
                                                                   sensitive)
                                                                   that
                                                                   indicates a
                                                                   _c_o_n_s_t_r_a_i_n_t
                                                                   _t_y_p_e:

                                                                   +o   L
                                                                       refers
                                                                       to the
                                                                       minimum
                                                                       length
                                                                       of a
                                                                       password,
                                                                       in
                                                                       characters;

                                                                   +o   C is
                                                                       the
                                                                       minimum
                                                                       number
                                                                       of
                                                                       characters
                                                                       _f_r_o_m
                                                                       _e_a_c_h
                                                                       _c_a_s_e
                                                                       that
                                                                       must be
                                                                       present
                                                                       (e.g.,
                                                                       3C
                                                                       means a
                                                                       password
                                                                       must
                                                                       have at
                                                                       least
                                                                       three
                                                                       upper
                                                                       case
                                                                       characters
                                                                       _a_n_d
                                                                       three
                                                                       lower
                                                                       case
                                                                       characters);

                                                                   +o   D is
                                                                       the
                                                                       minimum
                                                                       number
                                                                       of
                                                                       digits
                                                                       (0-9)
                                                                       that
                                                                       must be
                                                                       present;

                                                                   +o   and P
                                                                       is the
                                                                       minimum
                                                                       number
                                                                       of
                                                                       punctuation
                                                                       characters
                                                                       (see
                                                                       iissppuunncctt((33))[128])
                                                                       that
                                                                       must be
                                                                       present.

                                                                       A
                                                                       constraint
                                                                       type
                                                                       may not
                                                                       appear
                                                                       more
                                                                       than
                                                                       once.
                                                                       Not all
                                                                       constraint
                                                                       types
                                                                       need to
                                                                       be
                                                                       specified.
                                                                       If this
                                                                       directive
                                                                       is not
                                                                       given,
                                                                       or is
                                                                       the
                                                                       empty
                                                                       string,
                                                                       or the
                                                                       word
                                                                       "none"
                                                                       (case
                                                                       insensitive),
                                                                       a
                                                                       minimum
                                                                       password
                                                                       length
                                                                       of any
                                                                       six
                                                                       characters
                                                                       is
                                                                       used.
                                                                       If a
                                                                       constraint
                                                                       type is
                                                                       missing,
                                                                       a
                                                                       minimum
                                                                       of zero
                                                                       is
                                                                       used.
                                                                       In no
                                                                       event
                                                                       is a
                                                                       password
                                                                       of
                                                                       fewer
                                                                       than
                                                                       six
                                                                       characters
                                                                       allowed
                                                                       for a
                                                                       non-administrator,
                                                                       however.

                                                                           SSeeccuurriittyy
                                                                           No
                                                                           check
                                                                           is
                                                                           made
                                                                           for
                                                                           constraints
                                                                           that
                                                                           are
                                                                           impossible
                                                                           to
                                                                           satisfy.

                                                                       For
                                                                       example,
                                                                       the
                                                                       following
                                                                       directive
                                                                       says
                                                                       that
                                                                       passwords
                                                                       must be
                                                                       at
                                                                       least
                                                                       eight
                                                                       characters
                                                                       long
                                                                       and
                                                                       include
                                                                       at
                                                                       least
                                                                       one
                                                                       digit
                                                                       and one
                                                                       upper
                                                                       case
                                                                       and one
                                                                       lower
                                                                       case
                                                                       character,
                                                                       with no
                                                                       punctuation
                                                                       characters
                                                                       required:

                                                                           PASSWORD_CONSTRAINTS "8L,1D,1C,0P"


                                                                   PASSWORD_DIGEST
                                                                   (Optional1)
                                                                       By
                                                                       default,
                                                                       SHA-1
                                                                       is used
                                                                       as the
                                                                       secure
                                                                       hash
                                                                       function
                                                                       by
                                                                       ddaaccssttookkeenn((11))[126],
                                                                       ddaaccssppaasssswwdd((11))[125],
                                                                       ddaaccssttookkeenn((11))[126],
                                                                       ddaaccss__ppaasssswwdd((88))[124],
                                                                       and
                                                                       ddaaccss__aaddmmiinn((88))[129]
                                                                       for
                                                                       computing
                                                                       password
                                                                       digests.
                                                                       The
                                                                       value
                                                                       of this
                                                                       directive
                                                                       can be
                                                                       (case
                                                                       insensitively):

                                                                       CRYPT
                                                                           for
                                                                           the
                                                                           Unix
                                                                           ccrryypptt((33))[130]
                                                                           function

                                                                       MD5
                                                                           for
                                                                           the
                                                                           MMDD55
                                                                           ffuunnccttiioonn[131]
                                                                           (deprecated).

                                                                       SHA1
                                                                       SHA224
                                                                       SHA256
                                                                       SHA384
                                                                       SHA512
                                                                           , ,
                                                                           , ,
                                                                           for
                                                                           one
                                                                           of
                                                                           the
                                                                           variants
                                                                           of
                                                                           the
                                                                           Secure
                                                                           Hash
                                                                           Standard
                                                                           (FFIIPPSS
                                                                           118800--33[132]).


                                                                       The
                                                                       system
                                                                       ccrryypptt(())
                                                                       function
                                                                       may
                                                                       have
                                                                       platform-dependent
                                                                       limitations
                                                                       on the
                                                                       number
                                                                       of
                                                                       characters
                                                                       that
                                                                       are
                                                                       significant
                                                                       in a
                                                                       password
                                                                       or the
                                                                       maximum
                                                                       length
                                                                       of a
                                                                       password,
                                                                       but the
                                                                       other
                                                                       digest
                                                                       algorithms
                                                                       use all
                                                                       of the
                                                                       characters
                                                                       and
                                                                       impose
                                                                       no
                                                                       maximum
                                                                       password
                                                                       length.
                                                                       .sp The
                                                                       digest
                                                                       algorithm
                                                                       used is
                                                                       stored
                                                                       with
                                                                       the
                                                                       password
                                                                       entry,
                                                                       so the
                                                                       algorithm
                                                                       can be
                                                                       changed
                                                                       without
                                                                       voiding
                                                                       pre-existing
                                                                       passwords.

                                                                   PASSWORD_OPS_NEED_PASSWORD
                                                                   (Optional1)
                                                                       Ordinarily,
                                                                       ddaaccssppaasssswwdd((11))[125]
                                                                       will
                                                                       not
                                                                       allow
                                                                       password
                                                                       maintenance
                                                                       operations
                                                                       (other
                                                                       than
                                                                       listing)
                                                                       unless
                                                                       the
                                                                       user
                                                                       has
                                                                       authenticated
                                                                       as an
                                                                       AADDMMIINN__IIDDEENNTTIITTYY[133]
                                                                       or
                                                                       provides
                                                                       a valid
                                                                       password
                                                                       for the
                                                                       username
                                                                       being
                                                                       administered
                                                                       (one
                                                                       that
                                                                       was
                                                                       created
                                                                       by
                                                                       ddaaccssppaasssswwdd((11))[125]).
                                                                       If this
                                                                       directive
                                                                       is
                                                                       "no", a
                                                                       password
                                                                       is not
                                                                       required
                                                                       and
                                                                       ddaaccssppaasssswwdd
                                                                       will
                                                                       assume
                                                                       that
                                                                       all
                                                                       necessary
                                                                       access
                                                                       control
                                                                       has
                                                                       already
                                                                       been
                                                                       performed.

                                                                   PASSWORD_SALT_PREFIX
                                                                   (Optional1)
                                                                       This
                                                                       string
                                                                       is
                                                                       prepended
                                                                       to a
                                                                       random
                                                                       salt
                                                                       string
                                                                       used
                                                                       when
                                                                       creating
                                                                       a
                                                                       digest
                                                                       of a
                                                                       password
                                                                       used by
                                                                       DDAACCSS in
                                                                       various
                                                                       contexts
                                                                       (e.g.,
                                                                       ddaaccssppaasssswwdd((11))[125]).
                                                                       This
                                                                       may be
                                                                       of
                                                                       interest
                                                                       when
                                                                       PPAASSSSWWOORRDD__DDIIGGEESSTT[98]
                                                                       is
                                                                       CRYPT
                                                                       because
                                                                       some
                                                                       versions
                                                                       of
                                                                       ccrryypptt((33))[130]
                                                                       interpret
                                                                       the
                                                                       salt
                                                                       string.

                                                                   PERMIT_CHAINING
                                                                   (Optional1)
                                                                       If
                                                                       "yes",
                                                                       credentials
                                                                       exported
                                                                       by
                                                                       ddaaccss__aaccss((88))[5]
                                                                       anywhere
                                                                       in the
                                                                       federation
                                                                       as a
                                                                       result
                                                                       of a
                                                                       rule
                                                                       having
                                                                       the
                                                                       permit_chaining
                                                                       attribute
                                                                       set to
                                                                       yes
                                                                       will be
                                                                       honoured
                                                                       at this
                                                                       jurisdiction
                                                                       for
                                                                       access
                                                                       control
                                                                       purposes.

                                                                           SSeeccuurriittyy
                                                                           Enabling
                                                                           this
                                                                           feature
                                                                           weakens
                                                                           security
                                                                           because
                                                                           it
                                                                           may
                                                                           allow
                                                                           misappropriated
                                                                           DDAACCSS
                                                                           identities
                                                                           to
                                                                           be
                                                                           used
                                                                           at
                                                                           a
                                                                           jurisdiction
                                                                           that
                                                                           has
                                                                           enabled
                                                                           PERMIT_CHAINING.
                                                                           Use
                                                                           of
                                                                           this
                                                                           feature
                                                                           is
                                                                           discouraged
                                                                           but
                                                                           is
                                                                           sometimes
                                                                           necessary;
                                                                           use
                                                                           with
                                                                           care.
                                                                           Refer
                                                                           to
                                                                           the
                                                                           description
                                                                           of
                                                                           the
                                                                           permit_chaining
                                                                           attribute
                                                                           in
                                                                           ddaaccss..aaccllss((55))[23].

                                                                   PROXY_EXEC_DOCUMENT_ROOT
                                                                   (Optional1)
                                                                       Reserved
                                                                       for
                                                                       future
                                                                       use.

                                                                   PROXY_EXEC_MAPPER_DEFAULT_ACTION
                                                                   (Optional1)
                                                                       Reserved
                                                                       for
                                                                       future
                                                                       use.

                                                                   PROXY_EXEC_MAPPER_LOGGING
                                                                   (Optional1)
                                                                       Reserved
                                                                       for
                                                                       future
                                                                       use.

                                                                   PROXY_EXEC_MAPPER_LOG_FILE
                                                                   (Optional1)
                                                                       Reserved
                                                                       for
                                                                       future
                                                                       use.

                                                                   PROXY_EXEC_MAPPER_RULES_FILE
                                                                   (Optional1)
                                                                       Reserved
                                                                       for
                                                                       future
                                                                       use.

                                                                   PROXY_EXEC_PROG_URI
                                                                   (Optional1)
                                                                       Reserved
                                                                       for
                                                                       future
                                                                       use.

                                                                   RLINK
                                                                   (Optional)
                                                                       This
                                                                       directive,
                                                                       which
                                                                       may be
                                                                       repeated,
                                                                       is used
                                                                       to
                                                                       determine
                                                                       whether
                                                                       the
                                                                       current
                                                                       request
                                                                       includes
                                                                       an
                                                                       RRlliinnkk[134].
                                                                       The
                                                                       RLINK
                                                                       directives
                                                                       are
                                                                       processed
                                                                       in the
                                                                       order
                                                                       in
                                                                       which
                                                                       they
                                                                       occur.
                                                                       The
                                                                       value
                                                                       of the
                                                                       directive
                                                                       is a
                                                                       space-separated
                                                                       pair:
                                                                       the
                                                                       first
                                                                       is an
                                                                       eexxpprreessssiioonn[18]
                                                                       that is
                                                                       evaluated
                                                                       at
                                                                       rule-processing
                                                                       time,
                                                                       and the
                                                                       second
                                                                       is a
                                                                       VVFFSS
                                                                       ssppeecciiffiiccaattiioonn[135]
                                                                       for the
                                                                       location
                                                                       of the
                                                                       Rlinks
                                                                       (i.e.,
                                                                       a DDAACCSS
                                                                       URI, an
                                                                       item
                                                                       type,
                                                                       or an
                                                                       absolute
                                                                       pathname).
                                                                       If the
                                                                       expression
                                                                       evaluates
                                                                       to a
                                                                       non-empty
                                                                       string:

                                                                       +o   the
                                                                           string
                                                                           is
                                                                           assumed
                                                                           to
                                                                           be
                                                                           an
                                                                           RRnnaammee[134],
                                                                           which
                                                                           is
                                                                           relative
                                                                           to
                                                                           the
                                                                           VFS
                                                                           specification,

                                                                       +o   Rlink
                                                                           processing
                                                                           is
                                                                           enabled
                                                                           for
                                                                           the
                                                                           current
                                                                           request,
                                                                           and

                                                                       +o   no
                                                                           other
                                                                           RLINK
                                                                           directives
                                                                           are
                                                                           considered
                                                                           or
                                                                           evaluated.
                                                                           If
                                                                           the
                                                                           expression
                                                                           evaluates
                                                                           to
                                                                           the
                                                                           empty
                                                                           string
                                                                           or
                                                                           an
                                                                           error
                                                                           occurs,
                                                                           the
                                                                           directive
                                                                           is
                                                                           ignored
                                                                           and
                                                                           the
                                                                           next
                                                                           one,
                                                                           if
                                                                           any,
                                                                           is
                                                                           processed.
                                                                           Example:

                                                                               RLINK '"${Args::RNAME:?}" /usr/local/dacs/rlinks'

                                                                           In
                                                                           the
                                                                           example
                                                                           above,
                                                                           the
                                                                           directive
                                                                           specifies
                                                                           that
                                                                           if
                                                                           the
                                                                           current
                                                                           request
                                                                           includes
                                                                           a
                                                                           non-empty
                                                                           argument
                                                                           called
                                                                           _R_N_A_M_E,
                                                                           then
                                                                           its
                                                                           value
                                                                           is
                                                                           an
                                                                           Rname,
                                                                           Rlink
                                                                           processing
                                                                           is
                                                                           enabled,
                                                                           and
                                                                           the
                                                                           Rlink
                                                                           can
                                                                           be
                                                                           found
                                                                           in
                                                                           the
                                                                           /usr/local/dacs/rlinks
                                                                           directory.

                                                                       ROLE_STRING_MAX_LENGTH
                                                                       (Optional1)
                                                                           A
                                                                           limit
                                                                           is
                                                                           imposed
                                                                           on
                                                                           the
                                                                           length
                                                                           of
                                                                           the
                                                                           role
                                                                           string
                                                                           returned
                                                                           by
                                                                           any
                                                                           authentication
                                                                           or
                                                                           roles
                                                                           service,
                                                                           the
                                                                           length
                                                                           of
                                                                           any
                                                                           intermediate
                                                                           role
                                                                           string
                                                                           formed
                                                                           by
                                                                           concatenation
                                                                           during
                                                                           determination
                                                                           of
                                                                           the
                                                                           role
                                                                           string,
                                                                           and
                                                                           the
                                                                           length
                                                                           of
                                                                           the
                                                                           final
                                                                           role
                                                                           string,
                                                                           which
                                                                           is
                                                                           used
                                                                           in
                                                                           credentials.
                                                                           A
                                                                           string
                                                                           that
                                                                           exceeds
                                                                           the
                                                                           limit
                                                                           is
                                                                           invalid
                                                                           and
                                                                           treated
                                                                           as
                                                                           an
                                                                           empty
                                                                           string.
                                                                           The
                                                                           limit
                                                                           is
                                                                           necessary
                                                                           because
                                                                           credentials
                                                                           (which
                                                                           may
                                                                           contain
                                                                           a
                                                                           role
                                                                           string)
                                                                           are
                                                                           encapsulated
                                                                           within
                                                                           an
                                                                           HTTP
                                                                           cookie
                                                                           and
                                                                           browsers
                                                                           have
                                                                           context-dependent
                                                                           and
                                                                           implementation-dependent
                                                                           restrictions
                                                                           on
                                                                           cookie
                                                                           lengths.
                                                                           This
                                                                           directive
                                                                           is
                                                                           used
                                                                           to
                                                                           set
                                                                           the
                                                                           limit,
                                                                           overriding
                                                                           a
                                                                           compile-time
                                                                           value
                                                                           of
                                                                           200
                                                                           bytes.
                                                                           Please
                                                                           refer
                                                                           to
                                                                           ddaaccss__aauutthheennttiiccaattee((88))[46]
                                                                           for
                                                                           additional
                                                                           information
                                                                           about
                                                                           roles.

                                                                               WWaarrnniinngg
                                                                               A
                                                                               role
                                                                               string
                                                                               that
                                                                               is
                                                                               too
                                                                               long
                                                                               may
                                                                               cause
                                                                               the
                                                                               user
                                                                               to
                                                                               experience
                                                                               strange
                                                                               and
                                                                               possibly
                                                                               incorrect
                                                                               behaviour
                                                                               from
                                                                               DDAACCSS
                                                                               because
                                                                               the
                                                                               browser
                                                                               may
                                                                               discard
                                                                               cookies
                                                                               produced
                                                                               by
                                                                               DDAACCSS.

                                                                       SECURE_MODE
                                                                       (Optional1)
                                                                           This
                                                                           directive
                                                                           causes
                                                                           DDAACCSS
                                                                           to
                                                                           operate
                                                                           "insecurely"
                                                                           only
                                                                           if
                                                                           its
                                                                           value
                                                                           is
                                                                           "no"
                                                                           or
                                                                           "off"
                                                                           (case
                                                                           insensitive),
                                                                           otherwise
                                                                           DDAACCSS
                                                                           will
                                                                           use
                                                                           a
                                                                           more
                                                                           secure
                                                                           mode
                                                                           of
                                                                           operation.
                                                                           In
                                                                           secure
                                                                           mode,
                                                                           DDAACCSS
                                                                           requires
                                                                           all
                                                                           user
                                                                           interactions
                                                                           to
                                                                           be
                                                                           through
                                                                           SSL
                                                                           (HTTPS)
                                                                           and
                                                                           cookies
                                                                           will
                                                                           have
                                                                           the
                                                                           secure
                                                                           attribute.
                                                                           The
                                                                           default
                                                                           is
                                                                           "yes".
                                                                           Odd
                                                                           behaviour
                                                                           may
                                                                           result
                                                                           if
                                                                           interactions
                                                                           between
                                                                           DDAACCSS
                                                                           and
                                                                           a
                                                                           particular
                                                                           client
                                                                           mix
                                                                           http
                                                                           and
                                                                           https
                                                                           requests
                                                                           (such
                                                                           as
                                                                           when
                                                                           handlers
                                                                           are
                                                                           involved).

                                                                               SSeeccuurriittyy
                                                                               Always
                                                                               use
                                                                               the
                                                                               secure
                                                                               mode
                                                                               of
                                                                               operation
                                                                               unless
                                                                               you
                                                                               fully
                                                                               understand
                                                                               the
                                                                               consequences
                                                                               of
                                                                               disabling
                                                                               it.
                                                                               For
                                                                               DDAACCSS
                                                                               to
                                                                               be
                                                                               a
                                                                               secure
                                                                               system,
                                                                               secure
                                                                               mode
                                                                               should
                                                                               be
                                                                               disabled
                                                                               only
                                                                               for
                                                                               testing
                                                                               purposes
                                                                               or
                                                                               if
                                                                               all
                                                                               HTTP
                                                                               traffic
                                                                               is
                                                                               protected
                                                                               by
                                                                               some
                                                                               secure
                                                                               means
                                                                               other
                                                                               than
                                                                               SSL.

                                                                       SIGNOUT_HANDLER
                                                                       (Optional1)
                                                                           After
                                                                           ddaaccss__ssiiggnnoouutt((88))[31]
                                                                           successfully
                                                                           logs
                                                                           a
                                                                           user
                                                                           off,
                                                                           the
                                                                           subsequent
                                                                           action
                                                                           can
                                                                           be
                                                                           customized.
                                                                           In
                                                                           particular,
                                                                           this
                                                                           directive
                                                                           provides
                                                                           a
                                                                           way
                                                                           for
                                                                           the
                                                                           system
                                                                           administrator
                                                                           to
                                                                           redirect
                                                                           the
                                                                           user's
                                                                           browser,
                                                                           such
                                                                           as
                                                                           back
                                                                           to
                                                                           a
                                                                           login
                                                                           page.

                                                                           The
                                                                           following
                                                                           syntaxes
                                                                           are
                                                                           supported:


                                                                               1. SIGNOUT_HANDLER
                                                                               "[url]
                                                                               _U_R_L"

                                                                               This
                                                                               form
                                                                               will
                                                                               cause
                                                                               DDAACCSS
                                                                               to
                                                                               redirect
                                                                               the
                                                                               client
                                                                               to
                                                                               the
                                                                               specified
                                                                               URL,
                                                                               which
                                                                               may
                                                                               be
                                                                               a
                                                                               relative
                                                                               or
                                                                               absolute
                                                                               URL.
                                                                               If
                                                                               the
                                                                               keyword
                                                                               url
                                                                               is
                                                                               absent,
                                                                               _U_R_L
                                                                               must
                                                                               begin
                                                                               with
                                                                               the
                                                                               four
                                                                               characters
                                                                               http.
                                                                               The
                                                                               GET
                                                                               method
                                                                               is
                                                                               used.
                                                                               The
                                                                               URL
                                                                               may
                                                                               contain
                                                                               a
                                                                               properly
                                                                               escaped
                                                                               query
                                                                               string;
                                                                               DDAACCSS
                                                                               will
                                                                               append
                                                                               the
                                                                               following
                                                                               parameters,
                                                                               in
                                                                               the
                                                                               order
                                                                               given,
                                                                               to
                                                                               the
                                                                               URL:

                                                                               _D_A_C_S___V_E_R_S_I_O_N
                                                                                   The
                                                                                   version
                                                                                   number
                                                                                   of
                                                                                   DDAACCSS
                                                                                   (e.g.,
                                                                                   "1.4").

                                                                               _D_A_C_S___F_E_D_E_R_A_T_I_O_N
                                                                                   The
                                                                                   federation
                                                                                   that
                                                                                   received
                                                                                   the
                                                                                   service
                                                                                   request,
                                                                                   if
                                                                                   available.

                                                                               _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
                                                                                   The
                                                                                   jurisdiction
                                                                                   that
                                                                                   received
                                                                                   the
                                                                                   service
                                                                                   request,
                                                                                   if
                                                                                   available.

                                                                               The
                                                                               values
                                                                               of
                                                                               these
                                                                               parameters
                                                                               are
                                                                               URL
                                                                               encoded.


                                                                               2. SIGNOUT_HANDLER
                                                                               "[file]
                                                                               _f_u_l_l_-_p_a_t_h_n_a_m_e"

                                                                               This
                                                                               form
                                                                               causes
                                                                               the
                                                                               contents
                                                                               of
                                                                               the
                                                                               file
                                                                               named
                                                                               by
                                                                               _f_u_l_l_-_p_a_t_h_n_a_m_e
                                                                               to
                                                                               be
                                                                               returned.
                                                                               The
                                                                               file
                                                                               must
                                                                               include
                                                                               any
                                                                               header
                                                                               lines
                                                                               it
                                                                               requires,
                                                                               such
                                                                               as
                                                                               a
                                                                               Content-Type
                                                                               line,
                                                                               a
                                                                               header-terminating
                                                                               blank
                                                                               line,
                                                                               and
                                                                               then
                                                                               the
                                                                               document
                                                                               content.

                                                                                   NNoottee
                                                                                   The
                                                                                   "full-pathname"
                                                                                   usage
                                                                                   differs
                                                                                   from
                                                                                   the
                                                                                   "local-URL"
                                                                                   usage
                                                                                   of
                                                                                   the
                                                                                   ACS_ERROR_HANDLER
                                                                                   directive,
                                                                                   though
                                                                                   both
                                                                                   elements
                                                                                   begin
                                                                                   with
                                                                                   a
                                                                                   slash
                                                                                   character;
                                                                                   the
                                                                                   former
                                                                                   specifies
                                                                                   the
                                                                                   absolute
                                                                                   pathname
                                                                                   of
                                                                                   a
                                                                                   file,
                                                                                   while
                                                                                   the
                                                                                   latter
                                                                                   specifies
                                                                                   a
                                                                                   URL
                                                                                   local
                                                                                   to
                                                                                   the
                                                                                   receiving
                                                                                   web
                                                                                   server.
                                                                                   To
                                                                                   specify
                                                                                   a
                                                                                   relative
                                                                                   URL,
                                                                                   use
                                                                                   the
                                                                                   url
                                                                                   keyword.


                                                                               3. SIGNOUT_HANDLER
                                                                               "[message]
                                                                               \"_m_e_s_s_a_g_e\""

                                                                               This
                                                                               form
                                                                               causes
                                                                               the
                                                                               given
                                                                               message,
                                                                               surrounded
                                                                               by
                                                                               escaped
                                                                               double
                                                                               quote
                                                                               characters,
                                                                               to
                                                                               be
                                                                               returned
                                                                               as
                                                                               HTML.


                                                                               4. SIGNOUT_HANDLER
                                                                               "credentials"

                                                                               This
                                                                               form
                                                                               causes
                                                                               the
                                                                               user's
                                                                               remaining
                                                                               credentials
                                                                               to
                                                                               be
                                                                               displayed
                                                                               as
                                                                               an
                                                                               HTML
                                                                               document.
                                                                               This
                                                                               is
                                                                               the
                                                                               default
                                                                               behaviour.
                                                                               The
                                                                               optional
                                                                               keywords
                                                                               are
                                                                               treated
                                                                               case-insensitively.

                                                                           SSL_PROG
                                                                           (Optional1)
                                                                               The
                                                                               full
                                                                               pathname
                                                                               of
                                                                               the
                                                                               command
                                                                               used
                                                                               to
                                                                               provide
                                                                               an
                                                                               SSL
                                                                               connection
                                                                               for
                                                                               group
                                                                               information
                                                                               distribution.
                                                                               Currently,
                                                                               only
                                                                               ssssllcclliieenntt((11))[136]
                                                                               is
                                                                               supported
                                                                               for
                                                                               this
                                                                               purpose.

                                                                           SSL_PROG_ARGS
                                                                           (Optional1)
                                                                               Additional
                                                                               command
                                                                               line
                                                                               arguments
                                                                               to
                                                                               be
                                                                               passed
                                                                               to
                                                                               SSL_PROG.

                                                                                   NNoottee
                                                                                   This
                                                                                   directive
                                                                                   is
                                                                                   "global"
                                                                                   in
                                                                                   that
                                                                                   it
                                                                                   applies
                                                                                   to
                                                                                   all
                                                                                   internal
                                                                                   invocations
                                                                                   of
                                                                                   SSL_PROG.
                                                                                   SSL
                                                                                   options
                                                                                   should
                                                                                   probably
                                                                                   be
                                                                                   more
                                                                                   flexibly
                                                                                   configurable
                                                                                   (e.g.,
                                                                                   from
                                                                                   within
                                                                                   Auth
                                                                                   and
                                                                                   Roles
                                                                                   clauses).

                                                                           SSL_PROG_CA_CRT
                                                                           (Optional1)
                                                                               The
                                                                               full
                                                                               pathname
                                                                               of
                                                                               the
                                                                               file
                                                                               containing
                                                                               the
                                                                               CA
                                                                               certificate
                                                                               shared
                                                                               by
                                                                               this
                                                                               DDAACCSS
                                                                               federation.
                                                                               This
                                                                               is
                                                                               passed
                                                                               to
                                                                               SSL_PROG
                                                                               so
                                                                               that
                                                                               certificates
                                                                               can
                                                                               be
                                                                               validated.

                                                                           SSL_PROG_CLIENT_CRT
                                                                           (Optional1)
                                                                               This
                                                                               provides
                                                                               the
                                                                               name
                                                                               of
                                                                               a
                                                                               private
                                                                               key
                                                                               and
                                                                               certificate
                                                                               chain
                                                                               PEM
                                                                               file.
                                                                               Please
                                                                               refer
                                                                               to
                                                                               ssssllcclliieenntt((11))''ss[136]
                                                                               --ccccff
                                                                               flag.

                                                                           STATUS_LINE
                                                                           (Optional1)
                                                                               If
                                                                               this
                                                                               directive
                                                                               is
                                                                               set
                                                                               to
                                                                               "on",
                                                                               ddaaccss__aaccss((88))[5]
                                                                               will
                                                                               emit
                                                                               a
                                                                               DDAACCSS--SSttaattuuss--LLiinnee[137]
                                                                               header
                                                                               in
                                                                               the
                                                                               response
                                                                               from
                                                                               the
                                                                               server.
                                                                               The
                                                                               default
                                                                               value
                                                                               is
                                                                               "off".
                                                                               See
                                                                               the
                                                                               description
                                                                               of
                                                                               the
                                                                               DDAACCSS__AACCSS
                                                                               aarrgguummeenntt[47]
                                                                               for
                                                                               additional
                                                                               details.

                                                                           TEMP_DIRECTORY
                                                                           (Optional1)
                                                                               A
                                                                               directory
                                                                               where
                                                                               DDAACCSS
                                                                               can
                                                                               create
                                                                               temporary
                                                                               files.
                                                                               If
                                                                               the
                                                                               value
                                                                               is
                                                                               not
                                                                               an
                                                                               absolute
                                                                               path,
                                                                               the
                                                                               location
                                                                               is
                                                                               relative
                                                                               to
                                                                               DDAACCSS__HHOOMMEE[138].
                                                                               Lock
                                                                               files,
                                                                               for
                                                                               example,
                                                                               are
                                                                               put
                                                                               in
                                                                               this
                                                                               directory.
                                                                               If
                                                                               not
                                                                               configured
                                                                               or
                                                                               if
                                                                               this
                                                                               directory
                                                                               does
                                                                               not
                                                                               exist,
                                                                               a
                                                                               compile-time
                                                                               path
                                                                               (DEFAULT_TEMP_DIRECTORY)
                                                                               is
                                                                               used
                                                                               (currently:
                                                                               /tmp).
                                                                               It
                                                                               is
                                                                               always
                                                                               safe
                                                                               to
                                                                               delete
                                                                               the
                                                                               contents
                                                                               of
                                                                               this
                                                                               directory
                                                                               if
                                                                               DDAACCSS
                                                                               is
                                                                               not
                                                                               running.

                                                                           TOKEN_REQUIRES_PIN
                                                                           (Optional1)
                                                                               If
                                                                               set
                                                                               to
                                                                               no,
                                                                               then
                                                                               ddaaccssttookkeenn((11))[126]
                                                                               does
                                                                               not
                                                                               require
                                                                               created
                                                                               or
                                                                               imported
                                                                               accounts
                                                                               to
                                                                               have
                                                                               a
                                                                               PIN.
                                                                               The
                                                                               default
                                                                               value
                                                                               is
                                                                               yes,
                                                                               and
                                                                               a
                                                                               PIN
                                                                               is
                                                                               required.

                                                                           TOKEN_HOTP_ACCEPT_WINDOW
                                                                           (Optional1)
                                                                               When
                                                                               validating
                                                                               or
                                                                               authenticating
                                                                               against
                                                                               a
                                                                               given
                                                                               one-time
                                                                               password,
                                                                               this
                                                                               is
                                                                               the
                                                                               maximum
                                                                               number
                                                                               of
                                                                               successive
                                                                               counter
                                                                               values
                                                                               to
                                                                               consider,
                                                                               if
                                                                               necessary,
                                                                               after
                                                                               the
                                                                               expected
                                                                               counter
                                                                               value.
                                                                               A
                                                                               value
                                                                               of
                                                                               zero
                                                                               disables
                                                                               this
                                                                               search.
                                                                               If
                                                                               not
                                                                               configured,
                                                                               a
                                                                               compile-time
                                                                               value
                                                                               is
                                                                               used
                                                                               (currently,
                                                                               3).

                                                                           TRACE_LEVEL
                                                                           (Optional1)
                                                                               If
                                                                               assigned
                                                                               a
                                                                               non-zero
                                                                               value,
                                                                               tracing
                                                                               is
                                                                               enabled
                                                                               in
                                                                               various
                                                                               DDAACCSS
                                                                               services.
                                                                               Larger
                                                                               values
                                                                               will
                                                                               cause
                                                                               more
                                                                               events
                                                                               to
                                                                               be
                                                                               traced.
                                                                               This
                                                                               is
                                                                               intended
                                                                               to
                                                                               give
                                                                               an
                                                                               indication
                                                                               of
                                                                               the
                                                                               steps
                                                                               a
                                                                               DDAACCSS
                                                                               service
                                                                               takes
                                                                               during
                                                                               execution
                                                                               for
                                                                               debugging
                                                                               purposes.
                                                                               Logging
                                                                               information
                                                                               is
                                                                               generally
                                                                               written
                                                                               to
                                                                               the
                                                                               web
                                                                               server's
                                                                               log
                                                                               file
                                                                               or
                                                                               to
                                                                               a
                                                                               file
                                                                               configured
                                                                               into
                                                                               DDAACCSS
                                                                               at
                                                                               compile
                                                                               time.
                                                                               Also
                                                                               see
                                                                               LOG_LEVEL
                                                                               and
                                                                               VERBOSE_LEVEL.

                                                                           UNAUTH_ROLES
                                                                           (Optional1)
                                                                               This
                                                                               directive
                                                                               is
                                                                               used
                                                                               to
                                                                               assign
                                                                               a
                                                                               rroollee
                                                                               ddeessccrriippttoorr
                                                                               ssttrriinngg[139]
                                                                               to
                                                                               _u_n_a_u_t_h_e_n_t_i_c_a_t_e_d
                                                                               users.
                                                                               Association
                                                                               with
                                                                               these
                                                                               roles
                                                                               can
                                                                               be
                                                                               tested
                                                                               using
                                                                               the
                                                                               uusseerr(())[140]
                                                                               predicate.

                                                                               If
                                                                               a
                                                                               jurisdiction
                                                                               configures
                                                                               this
                                                                               directive:

                                                                                   UNAUTH_ROLES "anonymous"

                                                                               then
                                                                               the
                                                                               following
                                                                               predicates
                                                                               would
                                                                               both
                                                                               return
                                                                               TTrruuee
                                                                               when
                                                                               applied
                                                                               to
                                                                               an
                                                                               unauthenticated
                                                                               user:

                                                                                   user("unauth")
                                                                                   user("%:anonymous")

                                                                               A
                                                                               useful
                                                                               application
                                                                               of
                                                                               this
                                                                               directive
                                                                               is
                                                                               to
                                                                               classify
                                                                               unauthenticated
                                                                               users
                                                                               based
                                                                               on
                                                                               contextual
                                                                               elements.
                                                                               Consider
                                                                               this
                                                                               directive:

                                                                                   UNAUTH_ROLES from("10.0.0.0/24") ? "user" : ""

                                                                               If
                                                                               an
                                                                               unauthenticated
                                                                               user
                                                                               submits
                                                                               a
                                                                               request
                                                                               from
                                                                               a
                                                                               local
                                                                               IP
                                                                               address
                                                                               between
                                                                               10.0.0.0
                                                                               and
                                                                               10.0.0.255,
                                                                               the
                                                                               user
                                                                               would
                                                                               be
                                                                               treated
                                                                               as
                                                                               having
                                                                               the
                                                                               role
                                                                               user,
                                                                               otherwise
                                                                               the
                                                                               user
                                                                               would
                                                                               have
                                                                               no
                                                                               roles.
                                                                               This
                                                                               might
                                                                               be
                                                                               used
                                                                               to
                                                                               conveniently
                                                                               grant
                                                                               limited
                                                                               access
                                                                               to
                                                                               "local"
                                                                               users
                                                                               without
                                                                               them
                                                                               having
                                                                               to
                                                                               authenticate.
                                                                               A
                                                                               rule
                                                                               could
                                                                               be
                                                                               written
                                                                               to
                                                                               grant
                                                                               access
                                                                               based
                                                                               on
                                                                               having
                                                                               the
                                                                               role
                                                                               user,
                                                                               for
                                                                               example,
                                                                               without
                                                                               needing
                                                                               to
                                                                               consider
                                                                               whether
                                                                               or
                                                                               not
                                                                               the
                                                                               user
                                                                               has
                                                                               authenticated.

                                                                               Unlike
                                                                               roles
                                                                               assigned
                                                                               to
                                                                               credentials,
                                                                               roles
                                                                               specified
                                                                               in
                                                                               this
                                                                               way
                                                                               are
                                                                               strictly
                                                                               local
                                                                               to
                                                                               the
                                                                               jurisdiction
                                                                               that
                                                                               configures
                                                                               them.
                                                                               Some
                                                                               form
                                                                               of
                                                                               coordination
                                                                               is
                                                                               required
                                                                               if
                                                                               different
                                                                               jurisdictions
                                                                               need
                                                                               to
                                                                               assign
                                                                               the
                                                                               same
                                                                               roles
                                                                               to
                                                                               unauthenticated
                                                                               users.
                                                                               These
                                                                               roles
                                                                               are
                                                                               not
                                                                               reported
                                                                               by
                                                                               ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[141].

                                                                           UPROXY_APPROVED
                                                                           (Stack)
                                                                               This
                                                                               directive
                                                                               is
                                                                               used
                                                                               by
                                                                               ddaaccss__uupprrooxxyy((88))[142]
                                                                               to
                                                                               enable
                                                                               proxying
                                                                               to
                                                                               one
                                                                               or
                                                                               more
                                                                               hosts
                                                                               and
                                                                               to
                                                                               configure
                                                                               each
                                                                               of
                                                                               those
                                                                               mappings.
                                                                               Each
                                                                               directive
                                                                               specifies
                                                                               a
                                                                               member
                                                                               of
                                                                               the
                                                                               "approved
                                                                               list"
                                                                               (i.e.,
                                                                               a
                                                                               host
                                                                               that
                                                                               may
                                                                               be
                                                                               proxied)
                                                                               using
                                                                               the
                                                                               following
                                                                               syntax:

                                                                                   [{'http' | 'https'} '://'] _h_o_s_t_n_a_m_e [:_p_o_r_t] [_p_a_t_h]

                                                                               ddaaccss__uupprrooxxyy
                                                                               is
                                                                               invoked
                                                                               with
                                                                               a
                                                                               URI
                                                                               with
                                                                               the
                                                                               following
                                                                               syntax:

                                                                                   .../dacs_uproxy/_p_r_o_x_i_e_d_-_h_o_s_t_n_a_m_e[:_p_r_o_x_i_e_d_-_p_o_r_t][_p_r_o_x_i_e_d_-_p_a_t_h_-_p_r_e_f_i_x]

                                                                               A
                                                                               _p_r_o_x_i_e_d_-_h_o_s_t_n_a_m_e
                                                                               is
                                                                               matched
                                                                               against
                                                                               the
                                                                               _h_o_s_t_n_a_m_e
                                                                               of
                                                                               each
                                                                               entry
                                                                               in
                                                                               the
                                                                               list,
                                                                               according
                                                                               to
                                                                               the
                                                                               stacked
                                                                               directive
                                                                               ordering,
                                                                               until
                                                                               a
                                                                               (case
                                                                               insensitive)
                                                                               match
                                                                               is
                                                                               found.
                                                                               If
                                                                               the
                                                                               _p_r_o_x_i_e_d_-_h_o_s_t_n_a_m_e
                                                                               is
                                                                               followed
                                                                               by
                                                                               a
                                                                               port
                                                                               number,
                                                                               that
                                                                               port
                                                                               number
                                                                               must
                                                                               be
                                                                               explicitly
                                                                               specified
                                                                               in
                                                                               a
                                                                               directive
                                                                               for
                                                                               a
                                                                               match
                                                                               to
                                                                               occur.
                                                                               If
                                                                               no
                                                                               scheme
                                                                               is
                                                                               specified,
                                                                               http
                                                                               is
                                                                               used,
                                                                               regardless
                                                                               of
                                                                               what
                                                                               protocol
                                                                               the
                                                                               _p_o_r_t
                                                                               may
                                                                               imply.
                                                                               If
                                                                               a
                                                                               _p_a_t_h
                                                                               is
                                                                               given,
                                                                               it
                                                                               is
                                                                               appended
                                                                               to
                                                                               the
                                                                               _p_r_o_x_i_e_d_-_p_a_t_h_-_p_r_e_f_i_x.

                                                                               For
                                                                               example,
                                                                               consider
                                                                               the
                                                                               directives:

                                                                                   UPROXY_APPROVED "example.com"
                                                                                   UPROXY_APPROVED "https://foo.example.com"
                                                                                   UPROXY_APPROVED "http://bar.example.com:8080"
                                                                                   UPROXY_APPROVED "https://baz.example.com:8443/some/path"

                                                                               A
                                                                               request
                                                                               for
                                                                               the
                                                                               proxied
                                                                               hostname
                                                                               foo.example.com,
                                                                               such
                                                                               as
                                                                               this:

                                                                                   .../dacs_uproxy/foo.example.com/a/b/c.cgi

                                                                               will
                                                                               be
                                                                               forwarded
                                                                               by
                                                                               ddaaccss__uupprrooxxyy
                                                                               as
                                                                               the
                                                                               URI:

                                                                                   https://foo.example.com/a/b/c.cgi

                                                                               And
                                                                               the
                                                                               proxied
                                                                               request:

                                                                                   .../dacs_uproxy/baz.example.com/a/b/c.cgi

                                                                               will
                                                                               be
                                                                               forwarded
                                                                               by
                                                                               ddaaccss__uupprrooxxyy
                                                                               as
                                                                               the
                                                                               URI:

                                                                                   https://baz.example.com:8443/some/path/a/b/c.cgi

                                                                               This
                                                                               request
                                                                               would
                                                                               fail
                                                                               because
                                                                               there
                                                                               is
                                                                               no
                                                                               approved
                                                                               entry
                                                                               for
                                                                               bar.example.com:80:

                                                                                   .../dacs_uproxy/bar.example.com:80/a/b/c.cgi


                                                                           VERBOSE_LEVEL
                                                                           (Optional1)
                                                                               If
                                                                               assigned
                                                                               a
                                                                               non-zero
                                                                               value,
                                                                               debugging
                                                                               output
                                                                               is
                                                                               enabled
                                                                               in
                                                                               various
                                                                               DDAACCSS
                                                                               services.
                                                                               Larger
                                                                               values
                                                                               will
                                                                               cause
                                                                               more
                                                                               output
                                                                               to
                                                                               be
                                                                               generated.
                                                                               This
                                                                               is
                                                                               intended
                                                                               to
                                                                               display
                                                                               input
                                                                               arguments
                                                                               and
                                                                               the
                                                                               values
                                                                               of
                                                                               variables
                                                                               as
                                                                               a
                                                                               DDAACCSS
                                                                               service
                                                                               is
                                                                               executed,
                                                                               for
                                                                               debugging
                                                                               purposes.
                                                                               Logging
                                                                               information
                                                                               is
                                                                               generally
                                                                               written
                                                                               to
                                                                               the
                                                                               web
                                                                               server's
                                                                               log
                                                                               file
                                                                               or
                                                                               to
                                                                               a
                                                                               file
                                                                               configured
                                                                               into
                                                                               DDAACCSS
                                                                               at
                                                                               compile
                                                                               time.
                                                                               Also
                                                                               see
                                                                               LOG_LEVEL
                                                                               and
                                                                               TRACE_LEVEL.

                                                                           VERIFY_IP
                                                                           (Required1)
                                                                               If
                                                                               "yes",
                                                                               then
                                                                               the
                                                                               IP
                                                                               address
                                                                               in
                                                                               credentials
                                                                               must
                                                                               exactly
                                                                               match
                                                                               the
                                                                               IP
                                                                               address
                                                                               from
                                                                               which
                                                                               a
                                                                               service
                                                                               request
                                                                               is
                                                                               made.
                                                                               For
                                                                               example,
                                                                               if
                                                                               DDAACCSS
                                                                               issued
                                                                               credentials
                                                                               in
                                                                               response
                                                                               to
                                                                               an
                                                                               authentication
                                                                               request
                                                                               that
                                                                               came
                                                                               from
                                                                               the
                                                                               IP
                                                                               address
                                                                               10.0.0.123,
                                                                               then
                                                                               these
                                                                               credentials
                                                                               will
                                                                               only
                                                                               be
                                                                               considered
                                                                               valid
                                                                               for
                                                                               service
                                                                               requests
                                                                               that
                                                                               come
                                                                               from
                                                                               that
                                                                               IP
                                                                               address.
                                                                               If
                                                                               the
                                                                               directive's
                                                                               value
                                                                               is
                                                                               "no",
                                                                               this
                                                                               verification
                                                                               is
                                                                               not
                                                                               performed.
                                                                               Any
                                                                               other
                                                                               value
                                                                               is
                                                                               assumed
                                                                               to
                                                                               be
                                                                               a
                                                                               valid
                                                                               argument
                                                                               to
                                                                               the
                                                                               ffrroomm(())[143]
                                                                               predicate:

                                                                                   # Only credentials that were issued to an address on this subnet
                                                                                   # are acceptable
                                                                                   VERIFY_IP "10.0.0.0/24"


                                                                                   TTiipp
                                                                                   Verification
                                                                                   might
                                                                                   be
                                                                                   turned
                                                                                   off,
                                                                                   for
                                                                                   example,
                                                                                   in
                                                                                   an
                                                                                   environment
                                                                                   where
                                                                                   a
                                                                                   user
                                                                                   might
                                                                                   legitimately
                                                                                   submit
                                                                                   service
                                                                                   requests
                                                                                   associated
                                                                                   with
                                                                                   different
                                                                                   IP
                                                                                   addresses.
                                                                                   Refer
                                                                                   to
                                                                                   ddaaccss__aauutthheennttiiccaattee((88))[59]
                                                                                   for
                                                                                   additional
                                                                                   information.

                                                                           VERIFY_UA
                                                                           (Optional1)
                                                                               If
                                                                               "yes",
                                                                               then
                                                                               the
                                                                               user
                                                                               agent
                                                                               string
                                                                               presented
                                                                               when
                                                                               authentication
                                                                               occurred
                                                                               (the
                                                                               USER-AGENT
                                                                               request
                                                                               header,
                                                                               exported
                                                                               by
                                                                               AAppaacchhee
                                                                               as
                                                                               HHTTTTPP__UUSSEERR__AAGGEENNTT)
                                                                               must
                                                                               match
                                                                               the
                                                                               user
                                                                               agent
                                                                               string
                                                                               that
                                                                               is
                                                                               sent
                                                                               with
                                                                               subsequent
                                                                               requests
                                                                               using
                                                                               those
                                                                               credentials.
                                                                               This
                                                                               is
                                                                               the
                                                                               default.
                                                                               If
                                                                               the
                                                                               directive's
                                                                               value
                                                                               is
                                                                               "no",
                                                                               this
                                                                               verification
                                                                               is
                                                                               not
                                                                               performed
                                                                               at
                                                                               this
                                                                               jurisdiction
                                                                               but
                                                                               credentials
                                                                               it
                                                                               produces
                                                                               can
                                                                               still
                                                                               be
                                                                               verified
                                                                               by
                                                                               other
                                                                               jurisdictions.
                                                                               If
                                                                               the
                                                                               directive's
                                                                               value
                                                                               is
                                                                               "disable",
                                                                               the
                                                                               feature
                                                                               is
                                                                               totally
                                                                               disabled
                                                                               at
                                                                               this
                                                                               jurisdiction.
                                                                               The
                                                                               feature
                                                                               is
                                                                               always
                                                                               disabled
                                                                               for
                                                                               certain
                                                                               internally-generated
                                                                               credentials.

                                                                                   SSeeccuurriittyy
                                                                                   In
                                                                                   typical
                                                                                   use
                                                                                   of
                                                                                   DDAACCSS,
                                                                                   this
                                                                                   feature
                                                                                   should
                                                                                   be
                                                                                   enabled
                                                                                   because
                                                                                   it
                                                                                   makes
                                                                                   it
                                                                                   somewhat
                                                                                   more
                                                                                   difficult
                                                                                   for
                                                                                   misappropriated
                                                                                   DDAACCSS
                                                                                   credentials
                                                                                   to
                                                                                   be
                                                                                   used.
                                                                                   It
                                                                                   is
                                                                                   not
                                                                                   a
                                                                                   foolproof
                                                                                   measure,
                                                                                   however,
                                                                                   because
                                                                                   a
                                                                                   sophisticated
                                                                                   attacker
                                                                                   may
                                                                                   be
                                                                                   able
                                                                                   to
                                                                                   obtain
                                                                                   or
                                                                                   guess
                                                                                   a
                                                                                   user
                                                                                   agent
                                                                                   string
                                                                                   and
                                                                                   use
                                                                                   it
                                                                                   with
                                                                                   stolen
                                                                                   credentials,
                                                                                   although
                                                                                   guesses
                                                                                   may
                                                                                   draw
                                                                                   attention
                                                                                   by
                                                                                   causing
                                                                                   log
                                                                                   messages
                                                                                   to
                                                                                   be
                                                                                   emitted.

                                                                                   Some
                                                                                   user
                                                                                   agents,
                                                                                   including
                                                                                   hhttttpp((11))[3],
                                                                                   MMoozziillllaa,
                                                                                   FFiirreeffooxx,
                                                                                   ccuurrll,
                                                                                   wwggeett,
                                                                                   and
                                                                                   KKoonnqquueerroorr,
                                                                                   allow
                                                                                   the
                                                                                   user
                                                                                   agent
                                                                                   string
                                                                                   to
                                                                                   be
                                                                                   set.
                                                                                   Including
                                                                                   a
                                                                                   random
                                                                                   or
                                                                                   unusual
                                                                                   component
                                                                                   in
                                                                                   the
                                                                                   string
                                                                                   will
                                                                                   strengthen
                                                                                   this
                                                                                   feature.
                                                                                   Also,
                                                                                   middleware
                                                                                   may
                                                                                   be
                                                                                   able
                                                                                   to
                                                                                   take
                                                                                   advantage
                                                                                   of
                                                                                   its
                                                                                   ability
                                                                                   to
                                                                                   send
                                                                                   a
                                                                                   string
                                                                                   of
                                                                                   its
                                                                                   choosing
                                                                                   in
                                                                                   the
                                                                                   User-Agent
                                                                                   header
                                                                                   field.

                                                                                   Verification
                                                                                   might
                                                                                   be
                                                                                   turned
                                                                                   off,
                                                                                   for
                                                                                   example,
                                                                                   in
                                                                                   proxying
                                                                                   situations
                                                                                   or
                                                                                   if
                                                                                   credentials
                                                                                   are
                                                                                   cached
                                                                                   by
                                                                                   middleware
                                                                                   and
                                                                                   then
                                                                                   legitimately
                                                                                   used
                                                                                   with
                                                                                   different
                                                                                   user
                                                                                   agents.
                                                                                   The
                                                                                   feature
                                                                                   should
                                                                                   be
                                                                                   disabled
                                                                                   for
                                                                                   backward
                                                                                   compatibility
                                                                                   with
                                                                                   releases
                                                                                   earlier
                                                                                   than
                                                                                   DDAACCSS
                                                                                   1.4.14.

                                                                           VFS
                                                                           (Stack)
                                                                               These
                                                                               directives
                                                                               are
                                                                               used
                                                                               to
                                                                               configure
                                                                               the
                                                                               virtual
                                                                               filestore
                                                                               (VFS)
                                                                               subsystem
                                                                               (see
                                                                               ddaaccss..vvffss((55))[144]
                                                                               and
                                                                               ddaaccssvvffss((11))[145]
                                                                               for
                                                                               details).

                                                                               The
                                                                               value
                                                                               of
                                                                               this
                                                                               directive
                                                                               (a
                                                                               vfs_uri)
                                                                               has
                                                                               the
                                                                               following
                                                                               syntax:

                                                                                   vfs_uri -> [ '[' _i_t_e_m___t_y_p_e ']' ] _U_R_I

                                                                               As
                                                                               specified
                                                                               in
                                                                               RRFFCC
                                                                               22339966[96]
                                                                               and
                                                                               RRFFCC
                                                                               33998866[146],
                                                                               the
                                                                               general
                                                                               form
                                                                               of
                                                                               the
                                                                               URI
                                                                               syntax
                                                                               is:

                                                                                   _s_c_h_e_m_e : [ // _a_u_t_h_o_r_i_t_y] [_p_a_t_h] [_q_u_e_r_y] [_f_r_a_g_m_e_n_t]

                                                                               The
                                                                               _i_t_e_m___t_y_p_e
                                                                               (see
                                                                               ddaaccss((11))[147])
                                                                               is
                                                                               optional
                                                                               in
                                                                               some
                                                                               cases
                                                                               -
                                                                               it
                                                                               can
                                                                               usually
                                                                               be
                                                                               omitted
                                                                               if
                                                                               the
                                                                               directive
                                                                               will
                                                                               not
                                                                               be
                                                                               referenced
                                                                               and
                                                                               if
                                                                               it
                                                                               does
                                                                               not
                                                                               refer
                                                                               to
                                                                               an
                                                                               indexed
                                                                               object.
                                                                               It
                                                                               is
                                                                               a
                                                                               case-sensitive
                                                                               label
                                                                               that
                                                                               associates
                                                                               this
                                                                               directive
                                                                               with
                                                                               a
                                                                               class
                                                                               of
                                                                               objects
                                                                               used
                                                                               by
                                                                               DDAACCSS.
                                                                               Some
                                                                               labels
                                                                               are
                                                                               reserved
                                                                               and
                                                                               have
                                                                               predefined
                                                                               meaning
                                                                               to
                                                                               DDAACCSS;
                                                                               these
                                                                               are
                                                                               always
                                                                               lowercase;
                                                                               ddaaccssccoonnff((11))[1]
                                                                               can
                                                                               list
                                                                               them.
                                                                               Any
                                                                               label
                                                                               can
                                                                               be
                                                                               defined
                                                                               by
                                                                               a
                                                                               DDAACCSS
                                                                               administrator,
                                                                               but
                                                                               a
                                                                               reserved
                                                                               item
                                                                               type
                                                                               should
                                                                               only
                                                                               be
                                                                               defined
                                                                               for
                                                                               its
                                                                               intended
                                                                               use;
                                                                               user-defined
                                                                               item
                                                                               types
                                                                               should
                                                                               therefore
                                                                               include
                                                                               at
                                                                               least
                                                                               one
                                                                               uppercase
                                                                               letter.
                                                                               For
                                                                               example,
                                                                               here
                                                                               are
                                                                               a
                                                                               few
                                                                               reserved
                                                                               item
                                                                               types:
                                                                               passwds
                                                                               (used
                                                                               by
                                                                               ddaaccssppaasssswwdd((11))[125]
                                                                               and
                                                                               others),
                                                                               federation_keys
                                                                               and
                                                                               jurisdiction_keys
                                                                               (used
                                                                               by
                                                                               ddaaccsskkeeyy((11))[148]
                                                                               and
                                                                               others),
                                                                               revocations
                                                                               (used
                                                                               by
                                                                               ddaaccss..aaccllss((55))[23]
                                                                               and
                                                                               others),
                                                                               and
                                                                               stdin
                                                                               (used
                                                                               by
                                                                               ggeett(())[149]
                                                                               and
                                                                               others).

                                                                               Although
                                                                               the
                                                                               _s_c_h_e_m_e
                                                                               is
                                                                               case-insensitive,
                                                                               the
                                                                               canonical
                                                                               form
                                                                               is
                                                                               lowercase.
                                                                               The
                                                                               _a_u_t_h_o_r_i_t_y,
                                                                               _q_u_e_r_y,
                                                                               and
                                                                               _f_r_a_g_m_e_n_t
                                                                               URI
                                                                               components
                                                                               are
                                                                               often
                                                                               absent.
                                                                               The
                                                                               _q_u_e_r_y
                                                                               component
                                                                               is
                                                                               used
                                                                               to
                                                                               specify
                                                                               options.

                                                                               The
                                                                               _p_a_t_h
                                                                               component
                                                                               of
                                                                               a
                                                                               URI
                                                                               has
                                                                               the
                                                                               format:

                                                                                   [ _n_a_m_i_n_g___c_o_n_t_e_x_t ] [ "," _r_e_l_-_p_a_t_h ]

                                                                               For
                                                                               paths
                                                                               that
                                                                               have
                                                                               a
                                                                               separate
                                                                               key
                                                                               relative
                                                                               to
                                                                               the
                                                                               naming
                                                                               context,
                                                                               its
                                                                               start
                                                                               is
                                                                               delimited
                                                                               by
                                                                               a
                                                                               comma.

                                                                               The
                                                                               _s_c_h_e_m_e
                                                                               may
                                                                               be:

                                                                               dacs-db
                                                                                   A
                                                                                   BBeerrkkeelleeyy
                                                                                   DDBB[150],
                                                                                   a
                                                                                   hash-based
                                                                                   database
                                                                                   that
                                                                                   manages
                                                                                   a
                                                                                   collection
                                                                                   of
                                                                                   objects
                                                                                   within
                                                                                   a
                                                                                   regular
                                                                                   file.
                                                                                   The
                                                                                   _i_t_e_m___t_y_p_e
                                                                                   is
                                                                                   required
                                                                                   because
                                                                                   it
                                                                                   forms
                                                                                   the
                                                                                   initial
                                                                                   part
                                                                                   of
                                                                                   the
                                                                                   key.

                                                                               dacs-ndbm
                                                                                   The
                                                                                   Unix
                                                                                   ddbbmm((33))[151]
                                                                                   API
                                                                                   (includes
                                                                                   GGNNUU
                                                                                   ggddbbmm[152]),
                                                                                   which
                                                                                   is
                                                                                   similar
                                                                                   to
                                                                                   dacs-db.
                                                                                   The
                                                                                   _i_t_e_m___t_y_p_e
                                                                                   is
                                                                                   required
                                                                                   because
                                                                                   it
                                                                                   forms
                                                                                   the
                                                                                   initial
                                                                                   part
                                                                                   of
                                                                                   the
                                                                                   key.

                                                                               dacs-fs
                                                                               fs
                                                                               file
                                                                                   Files
                                                                                   and
                                                                                   directories
                                                                                   managed
                                                                                   through
                                                                                   filesystem
                                                                                   operations.
                                                                                   Where
                                                                                   _p_a_t_h
                                                                                   names
                                                                                   a
                                                                                   directory,
                                                                                   each
                                                                                   key
                                                                                   maps
                                                                                   to
                                                                                   a
                                                                                   regular
                                                                                   file
                                                                                   within
                                                                                   that
                                                                                   directory.

                                                                               dacs-sqlite
                                                                                   An
                                                                                   SSQQLLiittee[153]
                                                                                   database
                                                                                   that
                                                                                   manages
                                                                                   a
                                                                                   collection
                                                                                   of
                                                                                   objects
                                                                                   within
                                                                                   a
                                                                                   regular
                                                                                   file.
                                                                                   The
                                                                                   _i_t_e_m___t_y_p_e
                                                                                   is
                                                                                   required
                                                                                   because
                                                                                   it
                                                                                   is
                                                                                   used
                                                                                   as
                                                                                   the
                                                                                   SQL
                                                                                   table
                                                                                   name.

                                                                               http
                                                                               https
                                                                                   HTTP-based
                                                                                   object
                                                                                   access.
                                                                                   For
                                                                                   example,
                                                                                   example.com
                                                                                   might
                                                                                   configure
                                                                                   access
                                                                                   to
                                                                                   its
                                                                                   revocation
                                                                                   list
                                                                                   like
                                                                                   this
                                                                                   (with
                                                                                   appropriate
                                                                                   access
                                                                                   controls):

                                                                                       VFS "[revocations]https://example.com/dacs/revocation_list"


                                                                               dacs-kwv
                                                                                   A
                                                                                   keyword-value
                                                                                   organization
                                                                                   that
                                                                                   is
                                                                                   managed
                                                                                   within
                                                                                   a
                                                                                   single
                                                                                   object
                                                                                   associated
                                                                                   with
                                                                                   another
                                                                                   item
                                                                                   type.
                                                                                   In
                                                                                   other
                                                                                   words,
                                                                                   it
                                                                                   says
                                                                                   that
                                                                                   another
                                                                                   object,
                                                                                   configured
                                                                                   with
                                                                                   its
                                                                                   own
                                                                                   VFS
                                                                                   directive,
                                                                                   has
                                                                                   an
                                                                                   internal
                                                                                   structure
                                                                                   where
                                                                                   each
                                                                                   line
                                                                                   of
                                                                                   the
                                                                                   object
                                                                                   represents
                                                                                   one
                                                                                   record.
                                                                                   Each
                                                                                   record
                                                                                   consists
                                                                                   of
                                                                                   a
                                                                                   keyword,
                                                                                   followed
                                                                                   by
                                                                                   a
                                                                                   separator
                                                                                   character,
                                                                                   and
                                                                                   the
                                                                                   value
                                                                                   associated
                                                                                   with
                                                                                   the
                                                                                   keyword.
                                                                                   A
                                                                                   keyword
                                                                                   consists
                                                                                   of
                                                                                   a
                                                                                   sequence
                                                                                   of
                                                                                   printable,
                                                                                   non-whitespace
                                                                                   characters.
                                                                                   By
                                                                                   default,
                                                                                   the
                                                                                   separator
                                                                                   character
                                                                                   is
                                                                                   a
                                                                                   colon.
                                                                                   (A
                                                                                   well-known
                                                                                   example
                                                                                   of
                                                                                   a
                                                                                   file
                                                                                   having
                                                                                   this
                                                                                   format
                                                                                   is
                                                                                   /etc/password.)
                                                                                   To
                                                                                   specify
                                                                                   a
                                                                                   different
                                                                                   separator,
                                                                                   the
                                                                                   vfs_uri
                                                                                   should
                                                                                   include
                                                                                   the
                                                                                   query
                                                                                   argument
                                                                                   _f_i_e_l_d___s_e_p
                                                                                   whose
                                                                                   value
                                                                                   is
                                                                                   the
                                                                                   separator
                                                                                   character
                                                                                   to
                                                                                   use.
                                                                                   The
                                                                                   _p_a_t_h
                                                                                   component
                                                                                   gives
                                                                                   the
                                                                                   name
                                                                                   of
                                                                                   the
                                                                                   item_type
                                                                                   that
                                                                                   should
                                                                                   be
                                                                                   used
                                                                                   to
                                                                                   manage
                                                                                   the
                                                                                   underlying
                                                                                   objects.

                                                                                   For
                                                                                   example,
                                                                                   components
                                                                                   of
                                                                                   DDAACCSS
                                                                                   expect
                                                                                   the
                                                                                   passwds
                                                                                   item
                                                                                   type
                                                                                   to
                                                                                   be
                                                                                   defined.
                                                                                   Taken
                                                                                   together,
                                                                                   the
                                                                                   following
                                                                                   pair
                                                                                   of
                                                                                   directives
                                                                                   specify
                                                                                   that
                                                                                   the
                                                                                   plain
                                                                                   file
                                                                                   /usr/local/dacs/passwd
                                                                                   consists
                                                                                   of
                                                                                   keyword-value
                                                                                   pairs:

                                                                                       VFS "[password_file]dacs-fs:/usr/local/dacs/passwd"
                                                                                       VFS "[passwds]dacs-kwv:password_file"

                                                                                   To
                                                                                   specify
                                                                                   a
                                                                                   space
                                                                                   as
                                                                                   the
                                                                                   separator
                                                                                   character
                                                                                   instead
                                                                                   of
                                                                                   the
                                                                                   colon
                                                                                   (which
                                                                                   is
                                                                                   the
                                                                                   default),
                                                                                   use
                                                                                   the
                                                                                   directives:


                                                                                       VFS "[password_file]dacs-fs:/usr/local/dacs/passwd"
                                                                                       VFS "[passwds]dacs-kwv:password_file?field_sep=+"

                                                                                   Because
                                                                                   these
                                                                                   are
                                                                                   URIs,
                                                                                   they
                                                                                   must
                                                                                   be
                                                                                   properly
                                                                                   encoded
                                                                                   and
                                                                                   the
                                                                                   '+'
                                                                                   character
                                                                                   represents
                                                                                   a
                                                                                   space.
                                                                                   If
                                                                                   the
                                                                                   passwords
                                                                                   are
                                                                                   to
                                                                                   be
                                                                                   stored
                                                                                   in
                                                                                   a
                                                                                   Berkeley
                                                                                   DB
                                                                                   database,
                                                                                   the
                                                                                   directive
                                                                                   would
                                                                                   be:

                                                                                       VFS "[passwds]dacs-db:/usr/local/dacs/passwd.db"


                                                                               dacs-kwv-_s_u_b_s_c_h_e_m_e
                                                                                   A
                                                                                   concise
                                                                                   way
                                                                                   of
                                                                                   composing
                                                                                   the
                                                                                   dacs-kwv
                                                                                   scheme
                                                                                   with
                                                                                   underlying
                                                                                   objects
                                                                                   accessed
                                                                                   using
                                                                                   _s_u_b_s_c_h_e_m_e.
                                                                                   Currently,
                                                                                   _s_u_b_s_c_h_e_m_e
                                                                                   can
                                                                                   be
                                                                                   fs
                                                                                   (for
                                                                                   dacs-fs),
                                                                                   http,
                                                                                   or
                                                                                   https.
                                                                                   For
                                                                                   fs,
                                                                                   the
                                                                                   _p_a_t_h
                                                                                   component
                                                                                   is
                                                                                   the
                                                                                   absolute
                                                                                   pathname
                                                                                   of
                                                                                   a
                                                                                   file,
                                                                                   its
                                                                                   contents
                                                                                   having
                                                                                   the
                                                                                   keyword-value
                                                                                   organization.
                                                                                   For
                                                                                   http
                                                                                   and
                                                                                   https,
                                                                                   the
                                                                                   _p_a_t_h
                                                                                   component
                                                                                   is
                                                                                   the
                                                                                   remainder
                                                                                   of
                                                                                   the
                                                                                   URL
                                                                                   (i.e.,
                                                                                   the
                                                                                   scheme
                                                                                   that
                                                                                   specifies
                                                                                   the
                                                                                   object
                                                                                   is
                                                                                   implied),
                                                                                   which
                                                                                   will
                                                                                   be
                                                                                   retrieved
                                                                                   using
                                                                                   the
                                                                                   GET
                                                                                   method,
                                                                                   stored
                                                                                   and
                                                                                   replaced
                                                                                   using
                                                                                   the
                                                                                   PUT
                                                                                   method,
                                                                                   deleted
                                                                                   using
                                                                                   the
                                                                                   DELETE
                                                                                   method,
                                                                                   and
                                                                                   tested
                                                                                   for
                                                                                   using
                                                                                   the
                                                                                   HEAD
                                                                                   method.
                                                                                   Note
                                                                                   that
                                                                                   any
                                                                                   options
                                                                                   (i.e.,
                                                                                   a
                                                                                   query
                                                                                   string)
                                                                                   bind
                                                                                   to
                                                                                   _s_u_b_s_c_h_e_m_e;
                                                                                   if
                                                                                   options
                                                                                   for
                                                                                   dacs-kwv
                                                                                   are
                                                                                   needed,
                                                                                   two
                                                                                   separate
                                                                                   URIs
                                                                                   must
                                                                                   be
                                                                                   used
                                                                                   instead
                                                                                   of
                                                                                   this
                                                                                   method.

                                                                                   This
                                                                                   configuration
                                                                                   directive
                                                                                   is
                                                                                   almost
                                                                                   equivalent
                                                                                   to
                                                                                   the
                                                                                   pair
                                                                                   of
                                                                                   directives
                                                                                   described
                                                                                   in
                                                                                   the
                                                                                   example
                                                                                   above:

                                                                                       VFS "[passwds]dacs-kwv-fs:/usr/local/dacs/passwd"

                                                                                   The
                                                                                   following
                                                                                   configuration
                                                                                   directive
                                                                                   states
                                                                                   that
                                                                                   the
                                                                                   password
                                                                                   file
                                                                                   used
                                                                                   by
                                                                                   ddaaccssppaasssswwdd((11))[125]
                                                                                   is
                                                                                   to
                                                                                   be
                                                                                   accessed
                                                                                   at
                                                                                   the
                                                                                   URL
                                                                                   https://example.com/dacs/passwds
                                                                                   using
                                                                                   the
                                                                                   standard
                                                                                   HTTP
                                                                                   methods:

                                                                                       VFS "[passwds]dacs-kwv-https://example.com/dacs/passwds"


                                                                               dacs-vfs
                                                                                   The
                                                                                   DDAACCSS
                                                                                   CGI-based
                                                                                   VFS
                                                                                   service,
                                                                                   ddaaccss__vvffss((88))[154],
                                                                                   which
                                                                                   exports
                                                                                   VFS
                                                                                   operations
                                                                                   on
                                                                                   VFS
                                                                                   objects
                                                                                   through
                                                                                   a
                                                                                   web
                                                                                   service.
                                                                                   An
                                                                                   item
                                                                                   type
                                                                                   must
                                                                                   be
                                                                                   provided
                                                                                   and
                                                                                   must
                                                                                   be
                                                                                   configured
                                                                                   at
                                                                                   the
                                                                                   specified
                                                                                   DDAACCSS
                                                                                   jurisdiction
                                                                                   using
                                                                                   any
                                                                                   of
                                                                                   the
                                                                                   supported
                                                                                   store
                                                                                   types
                                                                                   (which
                                                                                   means
                                                                                   the
                                                                                   dacs-vfs
                                                                                   scheme
                                                                                   can
                                                                                   be
                                                                                   used
                                                                                   to
                                                                                   access
                                                                                   items
                                                                                   stored
                                                                                   in
                                                                                   a
                                                                                   remote
                                                                                   regular
                                                                                   file,
                                                                                   hash-based
                                                                                   database,
                                                                                   and
                                                                                   so
                                                                                   on).

                                                                                   For
                                                                                   example,
                                                                                   this
                                                                                   directive
                                                                                   causes
                                                                                   DDAACCSS
                                                                                   to
                                                                                   look
                                                                                   for
                                                                                   password
                                                                                   entries
                                                                                   used
                                                                                   by
                                                                                   llooccaall__ppaasssswwdd__aauutthheennttiiccaattee[155]
                                                                                   to
                                                                                   be
                                                                                   accessed
                                                                                   through
                                                                                   the
                                                                                   virtual
                                                                                   filestore
                                                                                   at
                                                                                   example.com:

                                                                                       VFS "[passwds]dacs-vfs:https://example.com/cgi-bin/dacs/dacs_vfs"


                                                                               A
                                                                               vfs-ref
                                                                               is
                                                                               a
                                                                               reference
                                                                               to
                                                                               a
                                                                               virtual
                                                                               filestore
                                                                               definition
                                                                               and
                                                                               can
                                                                               be
                                                                               a
                                                                               vfs_uri
                                                                               or
                                                                               an
                                                                               item_type
                                                                               defined
                                                                               by
                                                                               a
                                                                               VFS
                                                                               directive.
                                                                               In
                                                                               some
                                                                               situations
                                                                               it
                                                                               can
                                                                               also
                                                                               be
                                                                               an
                                                                               absolute
                                                                               pathname.

                                                                                   NNoottee
                                                                                   At
                                                                                   present,
                                                                                   the
                                                                                   VFS
                                                                                   does
                                                                                   not
                                                                                   implement
                                                                                   much
                                                                                   in
                                                                                   the
                                                                                   way
                                                                                   of
                                                                                   concurrency
                                                                                   control.
                                                                                   Some
                                                                                   DDAACCSS
                                                                                   components
                                                                                   use
                                                                                   coarse-grained
                                                                                   locking
                                                                                   to
                                                                                   ensure
                                                                                   that
                                                                                   only
                                                                                   a
                                                                                   single
                                                                                   user
                                                                                   can
                                                                                   access
                                                                                   resources,
                                                                                   however,
                                                                                   and
                                                                                   databases
                                                                                   may
                                                                                   implement
                                                                                   their
                                                                                   own
                                                                                   concurrency
                                                                                   control.
                                                                                   Only
                                                                                   a
                                                                                   few
                                                                                   of
                                                                                   these
                                                                                   resources
                                                                                   are
                                                                                   not
                                                                                   used
                                                                                   in
                                                                                   a
                                                                                   read-only
                                                                                   fashion;
                                                                                   administrators
                                                                                   should
                                                                                   adopt
                                                                                   appropriate
                                                                                   data
                                                                                   management
                                                                                   practices
                                                                                   for
                                                                                   them
                                                                                   to
                                                                                   ensure
                                                                                   concurrent
                                                                                   updates
                                                                                   cannot
                                                                                   occur.

                                                                           XSD_BASE_URL
                                                                           (Optional1)
                                                                               When
                                                                               DDAACCSS
                                                                               services
                                                                               are
                                                                               asked
                                                                               to
                                                                               send
                                                                               an
                                                                               XML
                                                                               Schema
                                                                               response
                                                                               (i.e.,
                                                                               they
                                                                               are
                                                                               passed
                                                                               the
                                                                               argument
                                                                               FORMAT=XMLSCHEMA)
                                                                               and
                                                                               this
                                                                               directive
                                                                               is
                                                                               configured,
                                                                               services
                                                                               will
                                                                               emit
                                                                               xmlns:xsi
                                                                               and
                                                                               xsi:schemaLocation
                                                                               attributes,
                                                                               the
                                                                               former
                                                                               having
                                                                               a
                                                                               compile-time
                                                                               value
                                                                               (e.g.,
                                                                               http://www.w3.org/2001/XMLSchema-instance)
                                                                               and
                                                                               the
                                                                               latter
                                                                               being
                                                                               a
                                                                               pair,
                                                                               the
                                                                               first
                                                                               having
                                                                               the
                                                                               same
                                                                               value
                                                                               as
                                                                               the
                                                                               value
                                                                               of
                                                                               the
                                                                               xmlns
                                                                               attribute
                                                                               and
                                                                               the
                                                                               second
                                                                               having
                                                                               a
                                                                               value
                                                                               derived
                                                                               from
                                                                               the
                                                                               XSD_BASE_URL
                                                                               directive;
                                                                               e.g.,

                                                                                   <foo xmlns="http://example.com/dacs/v1.4"
                                                                                         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                                                                                         xsi:schemaLocation="http://example.com/dacs/v1.4
                                                                                         http://example.com/dacs/dtd-xsd/foo.xsd">

                                                                               If
                                                                               XSD_BASE_URL
                                                                               is
                                                                               not
                                                                               configured,
                                                                               only
                                                                               the
                                                                               default
                                                                               xmlns
                                                                               attribute
                                                                               is
                                                                               emitted.

   TThhee AAuutthh CCllaauussee
       Each Auth clause configures an authentication module. The Auth clause
       and its directives are described in ddaaccss__aauutthheennttiiccaattee((88))[25].

       Note that the order of these clauses is significant - they are
       processed in the order in which they appear in the applicable
       configuration section.

   TThhee RRoolleess CCllaauussee
       Each Roles clause configures a roles module.  Roles clause and its
       directives are described in ddaaccss__aauutthheennttiiccaattee((88))[156].

       The clauses are processed in the order in which they appear.
       Authentication modules may return roles, to improve efficiency, but
       roles are usually obtained through a roles module. Roles modules are
       processed only if authentication is successful.

   TThhee TTrraannssffeerr CCllaauussee
       Each Transfer clause configures ddaaccss__aauutthh__ttrraannssffeerr((88))[27] for importing
       from one or more federations specified within the clause. The clauses
       are processed in the order in which they appear. No clause should apply
       to more than one initial federation, although this is not enforced.

       Each Transfer element has an id attribute. Its value is merely a label
       (an alphabetic followed by zero or more alphanumerics, hyphens, and
       underscores) that allows the clause to be referenced; the syntax is the
       same as that of a ggrroouuppnnaammee[74]. The attribute values must be unique
       (case-sensitively).  Transfer clause directives are described in
       ddaaccss__aauutthh__ttrraannssffeerr((88))[27].

   AAddvvaanncceedd TTeecchhnniiqquueess
       Configuration processing is ordinarily quite straightforward, but to
       accommodate more complicated situations it also supports a few advanced
       techniques.

       CCoonnffiigguurraattiioonn VVaarriiaabblleess
           After configuration processing determines which directives have
           been overridden, those that are in effect have their right hand
           sides (which are expressions) evaluated. These expressions are
           usually simple strings but they can be any DDAACCSS expression.

               TTiipp
               When configuration processing begins, variables in the _D_A_C_S and
               _A_r_g_s nnaammeessppaacceess[13] can by referenced by configuration
               directives.

               SSeeccuurriittyy
               The ability to reference an argument during configuration
               processing can be useful and powerful when used carefully but
               since argument values are completely in the hands of the user
               constructing a request, it is a potential security weakness,
               particularly in DDAACCSS deployments that are exposed to the
               Internet.

               For example, an argument might be missing or duplicated,
               accidentally have a problematic value (such as containing
               non-printable or otherwise invalid characters), or be
               specifically constructed in an attempt to misconfigure DDAACCSS to
               thwart security. For this reason, variables in the _A_r_g_s
               namespace should be referenced in configuration files only when
               specifically indicated in the documentation, or by advanced
               DDAACCSS administrators in appropriate circumstances and with
               caution.

           As each expression is evaluated to determine the value of the
           directive, a variable in the _C_o_n_f namespace (see ddaaccss..eexxpprrss((55))[13])
           is created and assigned the value, and can then be referenced in
           subsequent expressions. Variables in this namespace can be
           referenced within access control rules, permitting rules to be
           written that depend on how the particular site, federation, and
           jurisdiction have been configured. In addition, during the
           remainder of the configuration processing stage, the variable's
           value can be modified, effectively changing the value associated
           with the directive. After completion of configuration processing,
           the variables in the _C_o_n_f namespace become read-only. It is these
           variables that are displayed by the --vvaarrss option of ddaaccssccoonnff((11))[1].

           For example, if the directive

               FEDERATION_DOMAIN   "example.com"

           is in effect when directive evaluation begins, the variable
           _$_{_C_o_n_f_:_:_F_E_D_E_R_A_T_I_O_N___D_O_M_A_I_N_} will be created and assigned the value
           "example.com".

           Variables within the _C_o_n_f nnaammeessppaaccee[13] can be created as needed
           within expressions (using the EVAL directive, for example). Care
           should be taken not to unintentionally modify the value of a DDAACCSS
           directive, however.

           A standard set of variables is always instantiated when available:

           _A_P_A_C_H_E___H_O_M_E
               The value of the corresponding build-time symbol

           _C_G_I___S_U_F_F_I_X
               The file name extension for CGI executables, specified at
               build-time

           _D_A_C_S___C_O_N_F
               The full pathname for this jurisdiction's dacs.conf file

           _D_A_C_S___C_O_N_F___S_P_E_C
               The pathname specification template used for this
               jurisdiction's dacs.conf file

           _D_A_C_S___H_O_M_E
               The value of the corresponding build-time symbol, from the path
               set by the ----pprreeffiixx flag or defaulting to /usr/local/dacs

                   IImmppoorrttaanntt
                   This directory should be writable only by an administrator.

           _D_A_C_S___C_G_I_B_I_N_D_I_R
               The value of the corresponding build-time symbol

           _D_A_C_S___R_E_L_E_A_S_E
               The value of the the compile-time symbol DACS_VERSION_RELEASE

           _D_A_C_S___B_I_N_D_I_R
               The location of the DDAACCSS bin directory

           _D_A_C_S___S_B_I_N_D_I_R
               The location of the DDAACCSS sbin directory

           _D_A_C_S___S_I_T_E___C_O_N_F
               The full pathname for this jurisdiction's site.conf file , if
               any
                .RE

               _D_A_C_S___S_I_T_E___C_O_N_F___S_P_E_C
                   The pathname specification template used for this
                   jurisdiction's site.conf file, if any

               _D_A_C_S___V_E_R_S_I_O_N
                   The value of the compile-time symbol DACS_VERSION_NUMBER

               _D_O_C_U_M_E_N_T___R_O_O_T
                   AAppaacchhee's DDOOCCUUMMEENNTT__RROOOOTT environment variable

               _E_X_E___S_U_F_F_I_X
                   The file name extension for non-CGI executables

               _F_E_D_E_R_A_T_I_O_N_S___R_O_O_T
                   The value of the corresponding build-time symbol

               _H_T_T_P___H_O_S_T
                   AAppaacchhee's HHTTTTPP__HHOOSSTT environment variable, obtained from the
                   HTTP Host request header

               _J_U_R_I_S_D_I_C_T_I_O_N___U_R_I
                   The initial part of the request URI, including scheme and
                   port number, that uniquely identifies the jurisdiction
                   receiving the service request (also see
                   _J_U_R_I_S_D_I_C_T_I_O_N___U_R_I___P_R_E_F_I_X)

               _J_U_R_I_S_D_I_C_T_I_O_N___U_R_I___P_R_E_F_I_X
                   The URI prefix that uniquely identifies the jurisdiction
                   receiving the service request (also see _J_U_R_I_S_D_I_C_T_I_O_N___U_R_I)

               _O_P_E_N_S_S_L___P_R_O_G
                   The full pathname of the ooppeennssssll command, if available

               _S_E_R_V_E_R___A_D_D_R
                   AAppaacchhee's SSEERRVVEERR__AADDDDRR environment variable

               _S_E_R_V_E_R___N_A_M_E
                   AAppaacchhee's SSEERRVVEERR__NNAAMMEE environment variable

               _S_E_R_V_E_R___P_O_R_T
                   AAppaacchhee's SSEERRVVEERR__PPOORRTT environment variable

               _U_R_I___S_C_H_E_M_E
                   Set to https if the service request came over SSL (HHTTTTPPSS ==
                   "on"), otherwise http

           AAuutthheennttiiccaattiioonn aanndd RRoolleess
               This section unfortunately left blank.

SSEEEE AALLSSOO
       ddaaccssccoonnff((11))[1], ddaaccss__ccoonnff((88))[2], ddaaccss..eexxpprrss((55))[18]

BBUUGGSS
       There's no way to turn off inherited defaults in a jurisdiction section
       or Default section; i.e., one cannot turn off all Auth or handler
       directives for just one jurisdiction section.

AAUUTTHHOORR
       Distributed Systems Software (hhttttpp::////wwwwww..ddssss..ccaa)

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[157] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsconf(1)
           http://dacs.dss.ca/man/dacsconf.1.html

        2. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

        3. http(1)
           http://dacs.dss.ca/man/http.1.html

        4. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        5. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        6. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

        7. mmoodd__vvhhoosstt__aalliiaass
           http://httpd.apache.org/docs-2.2/mod/mod_vhost_alias.html

        8. LOG_FILE
           http://dacs.dss.ca/man/#LOG_FILE

        9. pathname()
           http://dacs.dss.ca/man/dacs.exprs.5.html#pathname

       10. Jurisdiction section's
           http://dacs.dss.ca/man/#jurisdiction_section

       11. Configuration.dtd
           http://dacs.dss.ca/man/../dtd-xsd/Configuration.dtd

       12. Stack category
           http://dacs.dss.ca/man/#directive_categories

       13. namespace
           http://dacs.dss.ca/man/dacs.exprs.5.html#variables

       14. EVAL directive
           http://dacs.dss.ca/man/#EVAL

       15. undef()
           http://dacs.dss.ca/man/dacs.exprs.5.html#undef

       16. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/#ACS_ERROR_HANDLER

       17. effective jurisdictional URIs
           http://dacs.dss.ca/man/#jurisdiction_section_uri

       18. expression
           http://dacs.dss.ca/man/dacs.exprs.5.html

       19. configuration variables
           http://dacs.dss.ca/man/#config-vars

       20. example configuration
           http://dacs.dss.ca/man/#example_dacs.conf

       21. Jurisdiction Selection by URI
           http://dacs.dss.ca/man/#selection_by_uri

       22. string interpolation
           http://dacs.dss.ca/man/#interpolation

       23. access control rules
           http://dacs.dss.ca/man/dacs.acls.5.html

       24. INIT*
           http://dacs.dss.ca/man/dacs_authenticate.8.html#INIT*

       25. Auth clause
           http://dacs.dss.ca/man/dacs_authenticate.8.html#auth_clause

       26. section merging
           http://dacs.dss.ca/man/#merging

       27. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       28. Authorization Caching
           http://dacs.dss.ca/man/dacs_acs.8.html#authorization_caching

       29. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

       30. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       31. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       32. The DACS_APPROVAL environment variable
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

       33. description of the ErrorDocument directive
           http://httpd.apache.org/docs-2.2/mod/core.html#errordocument

       34. redirect()
           http://bsd6.dss.ca/dacs/man/dacs.exprs.5.html#redirect

       35. access control rules
           http://dacs.dss.ca/man/dacs.acls.5.html#elements

       36. Bug 3641
           http://issues.apache.org/bugzilla/show_bug.cgi?id=36411

       37. Bug 42430
           http://issues.apache.org/bugzilla/show_bug.cgi?id=42430

       38. dacs_select_credentials(8)
           http://dacs.dss.ca/man/dacs_select_credentials.8.html

       39. ACS_TRACK_ACTIVITY
           http://dacs.dss.ca/man/#ACS_TRACK_ACTIVITY

       40. SetDACSAuthPostBuffer
           http://dacs.dss.ca/man/mod_auth_dacs.html#SetDACSAuthPostBuffer

       41. SERVICE_ARGS_TRUNCATED
           http://dacs.dss.ca/man/dacs_acs.8.html#SERVICE_ARGS_TRUNCATED

       42. HTTP_AUTH
           http://dacs.dss.ca/man/#HTTP_AUTH

       43. syntactically valid username
           http://dacs.dss.ca/man/dacs.1.html#dacs_identity

       44. current jurisdiction
           http://dacs.dss.ca/man/dacs.1.html#current_jurisdiction

       45. ACS_AUTHENTICATED_ONLY
           http://dacs.dss.ca/man/#ACS_AUTHENTICATED_ONLY

       46. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#Roles

       47. DACS_ACS
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

       48. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       49. on_success()
           http://dacs.dss.ca/man/dacs.exprs.5.html#on_success

       50. counter
           http://dacs.dss.ca/man/dacs.exprs.5.html#counter

       51. current federation
           http://dacs.dss.ca/man/dacs.1.html#current_federation

       52. ACS_INACTIVITY_LIMIT_SECS
           http://dacs.dss.ca/man/#ACS_INACTIVITY_LIMIT_SECS

       53. FEDERATION_NAME
           http://dacs.dss.ca/man/#FEDERATION_NAME

       54. dacs_admin()
           http://dacs.dss.ca/man/dacs.exprs.5.html#dacs_admin

       55. NAME_COMPARE
           http://dacs.dss.ca/man/#NAME_COMPARE

       56. auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/auth_reply.dtd

       57. dacs_auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_auth_reply.dtd

       58. AUTH_ERROR_HANDLER
           http://dacs.dss.ca/man/#AUTH_ERROR_HANDLER

       59. cookie name
           http://dacs.dss.ca/man/dacs_authenticate.8.html#credentials

       60. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       61. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/#ACS_CREDENTIALS_LIMIT

       62. AUTH_SUCCESS_HANDLER
           http://dacs.dss.ca/man/#AUTH_SUCCESS_HANDLER

       63. mitigate the risk of information disclosure with a cross-site
           scripting (XSS) attack
           http://msdn.microsoft.com/en-us/library/ms533046%28VS.85%29.aspx

       64. are known
           http://www.webappsec.org/lists/websecurity/archive/2006-05/msg00025.html

       65. Netscape HTTP Cookies Specification
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

       66. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

       67. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

       68. _F_O_R_M_A_T web service argument
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       69. Advanced Techniques
           http://dacs.dss.ca/man/#advanced

       70. RFC 1035
           http://www.rfc-editor.org/rfc/rfc1035.txt

       71. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#group_syntax

       72. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#jurisdiction_section_overview

       73. JURISDICTION_NAME
           http://dacs.dss.ca/man/#JURISDICTION_NAME

       74. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       75. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       76. HTTP Authentication
           http://dacs.dss.ca/man/dacs_acs.8.html#http_authentication

       77. HTTP_AUTH_ENABLE
           http://dacs.dss.ca/man/#HTTP_AUTH_ENABLE

       78. ACS_PRE_AUTH
           http://dacs.dss.ca/man/#ACS_PRE_AUTH

       79. see below
           http://dacs.dss.ca/man/#http_auth_syn2

       80. authentication styles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#STYLE

       81. chmod(2)
           http://www.freebsd.org/cgi/man.cgi?query=chmod&apropos=0&esektion=2&emanpath=FreeBSD+7.2-RELEASE&format=html

       82. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       83. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       84. encode()
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

       85. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&esektion=3&emanpath=FreeBSD+7.2-RELEASE&format=html

       86. dacs_sts(8)
           http://dacs.dss.ca/man/dacs_sts.8.html

       87. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

       88. XML Schema Part 2: Datatypes Second Edition
           http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/datatypes.html#dateTime

       89. INFOCARD_CARD_LIFETIME_SECS
           http://dacs.dss.ca/man/#INFOCARD_CARD_LIFETIME_SECS

       90. VFS URI
           http://dacs.dss.ca/man/#VFS

       91. CARD_IMAGE_URL
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html#CARD_IMAGE_URL

       92. INFOCARD_CARD_DATETIME_EXPIRES
           http://dacs.dss.ca/man/#INFOCARD_CARD_DATETIME_EXPIRES

       93. INFOCARD_CARDID_BASE_URL
           http://dacs.dss.ca/man/#INFOCARD_CARDID_BASE_URL

       94. INFOCARD_CARD_OUTPUTDIR
           http://dacs.dss.ca/man/#INFOCARD_CARD_OUTPUTDIR

       95. INFOCARD_CARDID_SUFFIX
           http://dacs.dss.ca/man/#INFOCARD_CARDID_SUFFIX

       96. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       97. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

       98. PASSWORD_DIGEST
           http://dacs.dss.ca/man/#PASSWORD_DIGEST

       99. INFOCARD_IP_PRIVACY_URL
           http://dacs.dss.ca/man/#INFOCARD_IP_PRIVACY_URL

       00. dacs_mex(8)
           http://dacs.dss.ca/man/dacs_mex.8.html

       01. INFOCARD_STS_PASSWORD_METHOD
           http://dacs.dss.ca/man/#INFOCARD_STS_PASSWORD_METHOD

       02. INFOCARD_STS_CERTFILE
           http://dacs.dss.ca/man/#INFOCARD_STS_CERTFILE

       03. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

       04. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

       05. INFOCARD_STS_KEYFILE_PASSWORD
           http://dacs.dss.ca/man/#INFOCARD_STS_KEYFILE_PASSWORD

       06. INFOCARD_STS_KEYFILE
           http://dacs.dss.ca/man/#INFOCARD_STS_KEYFILE

       07. INFOCARD_REQUIRE_APPLIES_TO
           http://dacs.dss.ca/man/#INFOCARD_REQUIRE_APPLIES_TO

       08. INFOCARD_AUDIENCE
           http://dacs.dss.ca/man/#INFOCARD_AUDIENCE

       09. wildcard certificate
           http://wiki.cacert.org/wiki/WildcardCertificates

       10. syslog(3)
           http://www.freebsd.org/cgi/man.cgi?query=syslog&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       11. LOG_LEVEL
           http://dacs.dss.ca/man/#LOG_LEVEL

       12. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       13. print()
           http://dacs.dss.ca/man/dacs.exprs.5.html#print

       14. printf()
           http://dacs.dss.ca/man/dacs.exprs.5.html#printf

       15. LOG_SENSITIVE
           http://dacs.dss.ca/man/#LOG_SENSITIVE

       16. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#logging

       17. LOG_FILTER
           http://dacs.dss.ca/man/#LOG_FILTER

       18. debug_dacs
           http://dacs.dss.ca/man/dacs_acs.8.html#debug_dacs

       19. mod_log_config
           http://httpd.apache.org/docs/2.2/mod/mod_log_config.html

       20. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       21. Secure Mode
           http://dacs.dss.ca/man/dacs_notices.8.html#secure_mode

       22. local_pam_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_pam_authenticate

       23. pamd(8)
           http://dacs.dss.ca/man/pamd.8.html

       24. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       25. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       26. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       27. PASSWORD_AUDIT
           http://dacs.dss.ca/man/dacs_authenticate.8.html#PASSWORD_AUDIT

       28. ispunct(3)
           http://www.freebsd.org/cgi/man.cgi?query=ispunct&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       29. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       30. crypt(3)
           http://www.freebsd.org/cgi/man.cgi?query=crypt&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       31. MD5 function
           http://www.rfc-editor.org/rfc/rfc1321.txt

       32. FIPS 180-3
           http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

       33. ADMIN_IDENTITY
           http://dacs.dss.ca/man/#ADMIN_IDENTITY

       34. Rlink
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       35. VFS specification
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       36. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       37. DACS-Status-Line
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_status_line

       38. DACS_HOME
           http://dacs.dss.ca/man/#var_dacs_home

       39. role descriptor string
           http://dacs.dss.ca/man/dacs.1.html#roles

       40. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       41. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       42. dacs_uproxy(8)
           http://dacs.dss.ca/man/dacs_uproxy.8.html

       43. from()
           http://dacs.dss.ca/man/dacs.exprs.5.html#from

       44. dacs.vfs(5)
           http://dacs.dss.ca/man/dacs.vfs.5.html

       45. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

       46. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       47. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#gloss_item_type

       48. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       49. get()
           http://dacs.dss.ca/man/dacs.exprs.5.html#get

       50. Berkeley DB
           http://www.oracle.com/database/berkeley-db/db/index.html

       51. dbm(3)
           http://www.freebsd.org/cgi/man.cgi?query=dbm&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       52. GNU gdbm
           http://www.gnu.org/software/gdbm/gdbm.html

       53. SQLite
           http://www.sqlite.org

       54. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

       55. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

       56. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#roles_clause

       57. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      DACS.CONF(5)
