/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Solutions Commercial License Agreement provided
** with the Software or, alternatively, in accordance with the terms
** contained in a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** Please note Third Party Software included with Qt Solutions may impose
** additional restrictions and it is the user's responsibility to ensure
** that they have met the licensing requirements of the GPL, LGPL, or Qt
** Solutions Commercial license and the relevant license of the Third
** Party Software they are using.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include "ObjectiveCTypeQualifiers.h"

using namespace CPlusPlus;

static inline int classify2(const char *s) {
  if (s[0] == 'i') {
    if (s[1] == 'n') {
      return Token_in;
    }
  }
  return Token_identifier;
}

static inline int classify3(const char *s) {
  if (s[0] == 'o') {
    if (s[1] == 'u') {
      if (s[2] == 't') {
        return Token_out;
      }
    }
  }
  return Token_identifier;
}

static inline int classify4(const char *s) {
    if (s[0] == 'c') {
        if (s[1] == 'o') {
            if (s[2] == 'p') {
                if (s[3] == 'y') {
                    return Token_copy;
                }
            }
        }
    }
    return Token_identifier;
}

static inline int classify5(const char *s) {
  if (s[0] == 'b') {
    if (s[1] == 'y') {
      if (s[2] == 'r') {
        if (s[3] == 'e') {
          if (s[4] == 'f') {
            return Token_byref;
          }
        }
      }
    }
  }
  else if (s[0] == 'i') {
    if (s[1] == 'n') {
      if (s[2] == 'o') {
        if (s[3] == 'u') {
          if (s[4] == 't') {
            return Token_inout;
          }
        }
      }
    }
  }
  return Token_identifier;
}

static inline int classify6(const char *s) {
  if (s[0] == 'a') {
      if (s[1] == 's') {
          if (s[2] == 's') {
              if (s[3] == 'i') {
                  if (s[4] == 'g') {
                      if (s[5] == 'n') {
                          return Token_assign;
                      }
                  }
              }
          }
      }
  }
  else if (s[0] == 'b') {
    if (s[1] == 'y') {
      if (s[2] == 'c') {
        if (s[3] == 'o') {
          if (s[4] == 'p') {
            if (s[5] == 'y') {
              return Token_bycopy;
            }
          }
        }
      }
    }
  }
  else if (s[0] == 'g') {
      if (s[1] == 'e') {
          if (s[2] == 't') {
              if (s[3] == 't') {
                  if (s[4] == 'e') {
                      if (s[5] == 'r') {
                          return Token_getter;
                      }
                  }
              }
          }
      }
  }
  else if (s[0] == 's') {
      if (s[1] == 'e') {
          if (s[2] == 't') {
              if (s[3] == 't') {
                  if (s[4] == 'e') {
                      if (s[5] == 'r') {
                          return Token_setter;
                      }
                  }
              }
          }
      }
  }
  else if (s[0] == 'o') {
    if (s[1] == 'n') {
      if (s[2] == 'e') {
        if (s[3] == 'w') {
          if (s[4] == 'a') {
            if (s[5] == 'y') {
              return Token_oneway;
            }
          }
        }
      }
    }
  }
  else if (s[0] == 'r') {
      if (s[1] == 'e') {
          if (s[2] == 't') {
              if (s[3] == 'a') {
                  if (s[4] == 'i') {
                      if (s[5] == 'n') {
                          return Token_retain;
                      }
                  }
              }
          }
      }
  }
  return Token_identifier;
}

static inline int classify8(const char *s) {
    if (s[0] == 'r') {
        if (s[1] == 'e') {
            if (s[2] == 'a') {
                if (s[3] == 'd') {
                    if (s[4] == 'o') {
                        if (s[5] == 'n') {
                            if (s[6] == 'l') {
                                if (s[7] == 'y') {
                                    return Token_readonly;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return Token_identifier;
}

static inline int classify9(const char *s) {
    if (s[0] == 'n') {
        if (s[1] == 'o') {
            if (s[2] == 'n') {
                if (s[3] == 'a') {
                    if (s[4] == 't') {
                        if (s[5] == 'o') {
                            if (s[6] == 'm') {
                                if (s[7] == 'i') {
                                    if (s[8] == 'c') {
                                        return Token_nonatomic;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    } else if (s[0] == 'r') {
        if (s[1] == 'e') {
            if (s[2] == 'a') {
                if (s[3] == 'd') {
                    if (s[4] == 'w') {
                        if (s[5] == 'r') {
                            if (s[6] == 'i') {
                                if (s[7] == 't') {
                                    if (s[8] == 'e') {
                                        return Token_readwrite;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return Token_identifier;
}

int CPlusPlus::classifyObjectiveCTypeQualifiers(const char *s, int n) {
  switch (n) {
    case 2: return classify2(s);
    case 3: return classify3(s);
    case 4: return classify4(s);
    case 5: return classify5(s);
    case 6: return classify6(s);
    case 8: return classify8(s);
    case 9: return classify9(s);
    default: return Token_identifier;
  } // switch
}


