/*=============================================================================

  Library: CTK

  Copyright (c) German Cancer Research Center,
    Division of Medical and Biological Informatics

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/

#include "ctkPluginConstants.h"

const QString ctkPluginConstants::SYSTEM_PLUGIN_LOCATION = "System Plugin";
const QString ctkPluginConstants::SYSTEM_PLUGIN_SYMBOLICNAME = "system.plugin";

const QString ctkPluginConstants::FRAMEWORK_VERSION = "org.commontk.pluginfw.version";
const QString ctkPluginConstants::FRAMEWORK_VENDOR = "org.commontk.pluginfw.vendor";
const QString ctkPluginConstants::FRAMEWORK_STORAGE = "org.commontk.pluginfw.storage";
const QString ctkPluginConstants::FRAMEWORK_STORAGE_CLEAN = "org.commontk.pluginfw.storage.clean";
const QString ctkPluginConstants::FRAMEWORK_STORAGE_CLEAN_ONFIRSTINIT = "onFirstInit";
const QString ctkPluginConstants::FRAMEWORK_PLUGIN_LOAD_HINTS = "org.commontk.pluginfw.loadhints";

const QString ctkPluginConstants::PLUGIN_SYMBOLICNAME = "Plugin-SymbolicName";
const QString ctkPluginConstants::PLUGIN_COPYRIGHT = "Plugin-Copyright";
const QString ctkPluginConstants::PLUGIN_DESCRIPTION = "Plugin-Description";
const QString ctkPluginConstants::PLUGIN_NAME = "Plugin-Name";
const QString ctkPluginConstants::PLUGIN_VENDOR = "Plugin-Vendor";
const QString ctkPluginConstants::PLUGIN_LOCALIZATION = "Plugin-Localization";
const QString ctkPluginConstants::PLUGIN_LOCALIZATION_DEFAULT_BASENAME = "CTK-INF/l10n/plugin";
const QString ctkPluginConstants::REQUIRE_PLUGIN = "Require-Plugin";
const QString ctkPluginConstants::PLUGIN_VERSION_ATTRIBUTE = "plugin-version";
const QString ctkPluginConstants::PLUGIN_VERSION = "Plugin-Version";
const QString ctkPluginConstants::PLUGIN_ACTIVATIONPOLICY = "Plugin-ActivationPolicy";

const QString ctkPluginConstants::ACTIVATION_EAGER = "eager";
const QString ctkPluginConstants::ACTIVATION_LAZY = "lazy";

const QString ctkPluginConstants::RESOLUTION_DIRECTIVE = "resolution";
const QString ctkPluginConstants::RESOLUTION_MANDATORY = "mandatory";
const QString ctkPluginConstants::RESOLUTION_OPTIONAL = "optional";


const QString ctkPluginConstants::OBJECTCLASS = "objectclass";

// ATTENTION!!! If the value is changed, change also ctkEventConstants::SERVICE_ID
const QString ctkPluginConstants::SERVICE_ID = "service.id";

// ATTENTION!!! If the value is changed, change also ctkEventConstants::SERVICE_PID
const QString ctkPluginConstants::SERVICE_PID = "service.pid";

const QString ctkPluginConstants::SERVICE_RANKING = "service.ranking";
const QString ctkPluginConstants::SERVICE_VENDOR = "service.vendor";
const QString ctkPluginConstants::SERVICE_DESCRIPTION = "service.description";

